C
C
      SUBROUTINE TTEST3 (NCMAX, NCOL, NF, NIN, NMAX, NROW, 
     +                   A,
     +                   FNAME, TITLE, 
     +                   NEWDAT, SUPPLY)
C
C ACTION: t tests on rows with groups defined by indicators
C AUTHOR: W. G. Bardsley, University of Manchester, U.K.
C         07/08/2008 derived from CACORR
C         07/05/2011 added calls to FORM12
C         02/02/2017 added call to FDRVEC
C         10/07/2021 added E_NUMBERS and E_FORMATS, etc.
C
C         NCMAX: (input/unchanged) maximum column dimension
C          NCOL: (input/output) column size
C            NF: (input/unchanged) preconnected unit for results
C           NIN: (input/unchanged) unconnected unit for file opening
C          NMAX: (input/unchanged) maximum row dimension
C          NROW: (input/output) row size
C             A: workspace except that A may contain the data
C                on entry or exit as follows:
C                If the routine is called with A, NROW and NCOL defined then A may be
C                used as such. If A is changed then NROW and NCOL may be changed.
C        FNAME: (output) data file name (if new data)
C        TITLE: (output) data title (if new data)
C       NEWDAT: (output) if .TRUE. then new data is requested
C       SUPPLY: (input/unchanged) if .TRUE. then A is supplied
C
C Note: If A is already stored then NCOL and NROW will be the dimensions on
C       entry. If A is filled during subroutine execution then it is returned
C       unchanged, i.e. A = ASAV, NCOL = NCSAV and NROW = NRSAV in SIMSTAT
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NCMAX, NF, NIN, NMAX
      INTEGER,             INTENT (INOUT) :: NCOL, NROW
      DOUBLE PRECISION,    INTENT (INOUT) :: A(NMAX,NCMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, TITLE
      LOGICAL,             INTENT (IN)    :: SUPPLY
      LOGICAL,             INTENT (OUT)   :: NEWDAT
C
C Local allocatable arrays
C
      INTEGER,              ALLOCATABLE :: ISZ(:)
      DOUBLE PRECISION,     ALLOCATABLE :: B(:,:), X(:), Y(:)
      CHARACTER (LEN = 40), ALLOCATABLE :: WORDX(:)
C
C Locals
C
      INTEGER    ICMAX, N0, N1, N2, N3, N4, N5, N6, N7, N8, N10, N15
      PARAMETER (ICMAX = 100, N0 = 0, N1 = 1, N2 = 2,
     +           N3 = 3, N4 = 4, N5 = 5, N6 = 6, N7 = 7, N8 = 8, 
     +           N10 = 10, N15 = 15)
      INTEGER    ISZSAV(ICMAX)
      INTEGER    I, IADD1, IERR, IFAIL, J, JADD1, JCOLOR, KX, KY, KZ,
     +           NDOF
      INTEGER    LEN200, L_KX, L_KY, L_KZ, L_NCOL, L_NROW, L_ZIN, L_ZOUT
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NOPT, NSTART, NUMTXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1, NOPT = 11)
      INTEGER    MAXROW
      PARAMETER (MAXROW = 200)
      INTEGER    ISEND, NTYPE
      PARAMETER (ISEND = 2, NTYPE = 3)
      INTEGER    NDEC, NUMBLD(30), NUMPOS(NOPT)
      INTEGER    ICOUNT, KTYPE
      DOUBLE PRECISION BOT, DIFF, DKX, DKXM1, DKY, DKYM1, FACTOR, 
     +                 P, RTOL, SEDIFF, SSQ, TOP, TU, XBAR, XVAR, YBAR,
     +                 YVAR
      DOUBLE PRECISION G01EBF$, X02AMF$ 
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      CHARACTER  CIPHER*4, HEADER*(ICMAX), LINE*120, TEXT(30)*100,
     +           TITLE1*120
      CHARACTER  TAIL*1, TAILS(3)*15
      CHARACTER  CHOP80*80, WORD80*80, TEXT2(2)*100, TEXT7(7)*100
      CHARACTER (LEN = 12) FORM12, WORD12_KX, WORD12_KY, WORD12_KZ,
     +                             WORD12_NCOL, WORD12_NROW,
     +                             WORD12_ZIN, WORD12_ZOUT
      CHARACTER (LEN = 13) D13(6), SHOWRJ
      CHARACTER  AVAIL*4, BLANK*1, DOTS*3, NODATA*10, NOTAV*4
      PARAMETER (AVAIL = '    ', BLANK = ' ', DOTS = '...',
     +           NODATA = 'No data', NOTAV = '(NA)')
      CHARACTER  BOTH*1
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    FIXCOL, FIXROW, LABEL
      PARAMETER (FIXCOL = .FALSE., FIXROW = .FALSE., LABEL = .TRUE.)
      LOGICAL    FILEIT
      PARAMETER (FILEIT = .TRUE.)
      LOGICAL    ALLPOS
      PARAMETER (ALLPOS = .FALSE.)
      LOGICAL    ABORT, OK, READY, REPEET, USEIT(2)
      LOGICAL    E_FORMATS, E_NUMBERS
      EXTERNAL   PUTFAT, MATTIN, LBOX01, DSPLAY, NXXBAR, PATCH1, CHOP80, 
     +           PUTADV, EOFINT, REVPRO, ISZEDI, PUTWAR, TABLE1, CHKBOX,
     +           LISTBX, LEN200, FORM12, FDRVEC
      EXTERNAL   G01EBF$, X02AMF$
      EXTERNAL   E_FORMATS, SHOWRJ
      INTRINSIC  SQRT, MAX
      SAVE       ICOUNT, ISZSAV
      SAVE       KTYPE
      DATA       ICOUNT / 0 /
      DATA       ISZSAV / ICMAX*1 /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NOPT*1 /
      DATA       KTYPE / 1 /
      DATA       TAIL  / '2' /
      DATA       TAILS / 'Two-tail',
     +                   'Lower-tail',
     +                   'Upper-tail' /     
C
C Initialise NEWDAT then check dimensions if SUPPY = .TRUE.
C
      NEWDAT = .FALSE.
      IF (SUPPLY) THEN
         IF (NCOL.LT.N4 .OR. NCOL.GT.NCMAX .OR.
     +       NROW.LT.N1 .OR. NROW.GT.NMAX) RETURN
      ENDIF
C
C Define RTOL
C      
      RTOL = 1.0D+09*X02AMF$()
C
C Allocate workspaces
C
      IERR = 0
      IF (ALLOCATED(ISZ)) DEALLOCATE(ISZ, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(B)) DEALLOCATE(B, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(Y)) DEALLOCATE(Y, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(ISZ(NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(B(NMAX,N7), STAT = IERR)
      IF (IERR.NE.0) RETURN
      I = MAX(NCMAX,NMAX)  
      ALLOCATE(X(I), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(Y(NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Initialise ISZ, NDEC, and WORD80
C Note that only ICMAX elements of ISZ are stored between calls
C
      E_NUMBERS = E_FORMATS()
      IF (SUPPLY) THEN
         CALL EOFINT (ISZ, NCOL,
     +                FNAME,
     +                ABORT, ALLPOS)
         IF (ABORT) THEN
            WRITE (LINE,100)
            CALL PUTADV (LINE)
         ENDIF
      ELSE
         TITLE = NODATA
         ABORT = .TRUE.
      ENDIF
      IF (ABORT) THEN
         DO I = N1, NCMAX
            IF (I.LE.ICMAX) THEN
               ISZ(I) = ISZSAV(I)
            ELSE
               ISZ(I) = N1
            ENDIF
         ENDDO
      ENDIF
      NDEC = NOPT - N1
      WORD80 = CHOP80(TITLE)
      READY = .FALSE.
C
C Main loop
C =========
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         KX = N0
         KY = N0
         KZ = N0
         HEADER = BLANK
         IF (NCOL.GT.N3 .AND. NROW.GT.N0) THEN
            OK = .TRUE.
            CIPHER = AVAIL
            DO I = N1, NCOL
               IF (ISZ(I).GT.N0) THEN
                  ISZ(I) = N1
                  KX = KX + N1
                  IF (I.LE.ICMAX) HEADER(I:I) = 'x'
               ELSEIF (ISZ(I).EQ.N0) THEN
                  IF (I.LE.ICMAX) HEADER(I:I) = '0'
                  KZ = KZ + N1
               ELSE
                  ISZ(I) = - N1
                  KY = KY + N1
                  IF (I.LE.ICMAX) HEADER(I:I) = 'y'
               ENDIF
            ENDDO
            IF (NCOL.GT.ICMAX) HEADER(ICMAX - N2:ICMAX) = DOTS
         ELSE
            OK = .FALSE.
            CIPHER = NOTAV
         ENDIF
         WORD12_NCOL = FORM12(NCOL)
         WORD12_NROW = FORM12(NROW)
         L_NCOL = LEN200(WORD12_NCOL)
         L_NROW = LEN200(WORD12_NROW)
         WORD12_KX = FORM12(KX)
         WORD12_KY = FORM12(KY)
         WORD12_KZ = FORM12(KZ)
         L_KX = LEN200(WORD12_KX)
         L_KY = LEN200(WORD12_KY)
         L_KZ = LEN200(WORD12_KZ)
         WRITE (TEXT,200) WORD12_NROW(1:L_NROW), WORD12_NCOL(1:L_NCOL),
     +                    WORD80, HEADER,
     +                    WORD12_KX(1:L_KX),
     +                    WORD12_KY(1:L_KY), 
     +                    WORD12_KZ(1:L_KZ), CIPHER, TAILS(KTYPE)
         DO I = N1, N6
            TEXT7(I) = TEXT(I)
         ENDDO   

         IF (NDEC.EQ.N0) THEN
            IF (.NOT.OK) THEN
               NDEC = N1
            ELSEIF (READY) THEN
               NDEC = N2
            ELSE
               NDEC = NOPT - N1
            ENDIF
         ENDIF
         
         IF (KTYPE.EQ.1) THEN
            BOTH = 'S'
            TAIL = '2'
         ELSEIF (KTYPE.EQ.2) THEN
            BOTH = 'L'
            TAIL = 'L' 
         ELSE
            BOTH = 'U'
            TAIL = 'U'
         ENDIF
         
         NSTART = N10
         NUMTXT = NSTART + NOPT - N1
         NUMBLD(1) = N4
         NUMBLD(4) = N1
         NUMBLD(7) = N1            
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NOPT,
     +                NUMPOS, NSTART, NUMTXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = N0
         NUMBLD(4) = N0
         NUMBLD(7) = N0
C
C Check that DATA are ready if NDEC = 2, etc. is selected
C
         IF (NDEC.GE.N2 .AND. NDEC.LE.N6) THEN
            IF (.NOT.OK) THEN
               CALL PUTFAT ('First input your current data')
               READY = .FALSE.
               NDEC = N0
            ELSEIF (NCOL.LT.N4 .OR. NROW.LT.N1) THEN
               CALL PUTFAT ('Must have at least 2 rows and 4 columns')
               NDEC = N0
            ELSEIF (NDEC.GE.N3 .AND. NDEC.LE.N6 .AND. .NOT.READY) THEN
               CALL PUTFAT ('First analyse the data')
               NDEC = N0
            ENDIF
         ENDIF
         IF (NDEC.EQ.N2) THEN
            IF (KX.LT.N2 .OR. KY.LT.N2) THEN
               CALL PUTFAT ('Must have no. of X > 1 and no. of Y > 1')
               NDEC = N0
            ENDIF
         ENDIF
C
C Send bad choices to Help
C         
         IF (NDEC.EQ.N0) NDEC = NOPT - N1
C
C The main options
C           
         IF (NDEC.EQ.N1) THEN
C
C NDEC = 1: Data input
C =========
C
            IF (SUPPLY) THEN
               NEWDAT = .TRUE.
               DO I = N1, MIN(NCOL,ICMAX)
                  ISZSAV(I) = ISZ(I)
               ENDDO
               DEALLOCATE (ISZ, STAT = IERR)
               DEALLOCATE (B, STAT = IERR)
               DEALLOCATE (X, STAT = IERR)
               DEALLOCATE (Y, STAT = IERR)
               DEALLOCATE (WORDX, STAT = IERR)
               RETURN
            ENDIF
            OK = .FALSE.
            READY = .FALSE.
            CLOSE (UNIT = NIN)
            CALL MATTIN (ISEND, NCMAX, NCOL, NIN, NMAX, NROW,
     +                   A, X,
     +                   FNAME, TITLE,
     +                   ABORT, FIXCOL, FIXROW, LABEL)         
            CLOSE (UNIT = NIN)
            WORD80 = CHOP80(TITLE)
            IF (NCOL.GT.N3 .AND. NROW.GT.N0) THEN
               CALL EOFINT (ISZ, NCOL,
     +                      FNAME,
     +                      ABORT, ALLPOS)
               OK = .TRUE.
               IF (ABORT) THEN
                  WRITE (LINE,100)
                  CALL PUTADV (LINE)
                  NDEC = N6
               ELSE
                  NDEC = N2
               ENDIF
            ELSE
               OK = .FALSE.
               NDEC = N1
            ENDIF
         ELSEIF (NDEC.EQ.N2) THEN
C
C NDEC = 2: Analysis of data 
C =========                   
C
            ICOUNT = ICOUNT + N1
            IADD1 = N0
            JADD1 = N0
            DKX = DBLE(KX)
            DKXM1 = DBLE(KX - N1)
            DKY = DBLE(KY)
            DKYM1 = DBLE(KY - N1)
            NDOF = KX + KY - N2
            BOT = DBLE(NDOF)
            FACTOR = ONE/DKX + ONE/DKY
            DO I = N1, NROW
               KX = N0
               KY = N0
               DO J = N1, NCOL
                  IF (ISZ(J).GT.N0) THEN
                     KX = KX + N1
                     X(KX) = A(I,J)
                  ELSEIF (ISZ(J).LT.N0) THEN
                     KY = KY + N1
                     Y(KY) = A(I,J)
                  ENDIF
               ENDDO 
C
C Two tail t
C
               IF (KX.GE.N2 .AND. KY.GE.N2) THEN
                  CALL NXXBAR (KX,
     +                         X, XBAR, XVAR)
                  CALL NXXBAR (KY,
     +                         Y, YBAR, YVAR)
                  IF (XVAR.GT.RTOL .AND. YVAR.GT.RTOL) THEN
                     TOP = DKXM1*XVAR + DKYM1*YVAR
                     DIFF = XBAR - YBAR
                     SSQ = TOP/BOT
                     SEDIFF = SQRT(SSQ*FACTOR)
                     TU = DIFF/SEDIFF
                     IFAIL = N1
                     P = G01EBF$(BOTH, TU, BOT, IFAIL)
                     IF (IFAIL.EQ.N0) THEN
                        IADD1 = IADD1 + N1
                        B(I,1) = XBAR
                        B(I,2) = SQRT(XVAR)
                        B(I,3) = YBAR
                        B(I,4) = SQRT(YVAR)
                        B(I,5) = SEDIFF
                        B(I,6) = TU
                        B(I,7) = P
                     ELSE
                        JADD1 = JADD1 + N1 
                        DO J = N1, N7
                           B(I,J) = - ONE
                        ENDDO     
                     ENDIF
                  ELSE
                     JADD1 = JADD1 + N1
                     DO J = N1, N7
                        B(I,J) = - ONE
                     ENDDO   
                  ENDIF
               ELSE
                  JADD1 = JADD1 + N1
                  DO J = N1, N7
                     B(I,J) = - ONE
                  ENDDO   
               ENDIF
            ENDDO
            WRITE (TEXT7(7),300) ICOUNT, WORD12_KX(1:L_KX),
     +                                   WORD12_KY(1:L_KY)
            USEIT(1) = .TRUE.
            USEIT(2) = .TRUE.
            IF (NROW.GT.MAXROW) THEN
               USEIT(1) = .FALSE.
               USEIT(2) = .FALSE.
               WRITE (LINE,400) WORD12_NROW
               WRITE (TEXT2,500) 
               CALL CHKBOX (N2,
     +                      TEXT2, LINE,
     +                      USEIT)
            ENDIF
            IF (USEIT(1)) THEN
C
C Display results table
C              
               JCOLOR = N15
               CALL TABLE1 (JCOLOR, 'OPEN')
               DO I = N1, N7
                  IF (I.EQ.N1) THEN
                     JCOLOR = N4
                  ELSEIF (I.EQ.N4 .OR. I.EQ.N6) THEN
                     JCOLOR = N1
                  ELSE
                     JCOLOR = N0
                  ENDIF         
                  CALL TABLE1 (JCOLOR, TEXT7(I))
               ENDDO  
               JCOLOR = N4
               WRITE (LINE,600) TAIL
               CALL TABLE1 (JCOLOR, LINE)
               JCOLOR = N0
               DO I = N1, NROW
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,700) (B(I,J), J = N1, N7)
                  ELSE
                     DO J = N1, N6
                       D13(J) = SHOWRJ(B(I,J))
                     ENDDO  
                     WRITE (LINE,750) (D13(J), J = N1, N6), B(I,7) 
                  ENDIF  
                  CALL TABLE1 (JCOLOR, LINE)
               ENDDO 
               CALL TABLE1 (JCOLOR, 'CLOSE')
            ENDIF   
            IF (USEIT(2)) THEN
C
C Write results table to log file
C              
               WRITE (NF,'(A)') BLANK
               DO I = N1, N7
                  WRITE (NF,'(A)') TEXT7(I)
               ENDDO  
               WRITE (NF,600) TAIL
               DO I = N1, NROW
                  IF (E_NUMBERS) THEN
                     WRITE (NF,700) (B(I,J), J = N1, N7)
                  ELSE
                     DO J = N1, N6
                       D13(J) = SHOWRJ(B(I,J))
                     ENDDO  
                     WRITE (NF,750) (D13(J), J = N1, N6), B(I,7) 
                  ENDIF 
               ENDDO 
            ENDIF               
            IF (JADD1.GT.N0) THEN
C
C Warn about singular data
C              
               WORD12_ZIN = FORM12(IADD1)
               WORD12_ZOUT = FORM12(JADD1)
               L_ZIN = LEN200(WORD12_ZIN)
               L_ZOUT = LEN200(WORD12_ZOUT)
               WRITE (LINE,800) WORD12_ZIN(1:L_ZIN),
     +                          WORD12_ZOUT(1:L_ZOUT)
               CALL PUTWAR (LINE)
            ENDIF      
            READY = .TRUE.  
            NDEC = N3
         ELSEIF (NDEC.EQ.N3) THEN
C
C NDEC = 3: View all
C =========
C
            IF (OK .AND. READY) THEN
               WRITE (TITLE1,650) TAIL 
               CALL DSPLAY (N7, N7, NF, NMAX, NROW, NTYPE,
     +                      B,
     +                      TITLE1,
     +                      FILEIT)
            ENDIF
         ELSEIF (NDEC.EQ.N4) THEN
C
C NDEC = 4: View t
C =========
C
            IF (OK .AND. READY) THEN
               DO I = N1, NROW
                  X(I) = B(I,6)
               ENDDO   
               WRITE (TITLE1,900) WORD12_KX(1:L_KX), WORD12_KY(1:L_KY)
               CALL DSPLAY (N1, N1, NF, NROW, NROW, NTYPE,
     +                      X,
     +                      TITLE1,
     +                      FILEIT)
            ENDIF
         ELSEIF (NDEC.EQ.N5) THEN
C
C NDEC = 5: View p
C =========
C
            IF (OK .AND. READY) THEN 
               DO I = N1, NROW
                  X(I) = B(I,7)
               ENDDO   
               WRITE (TITLE1,1000) TAIL, WORD12_KX(1:L_KX),
     +                                   WORD12_KY(1:L_KY)
               CALL DSPLAY (N1, N1, NF, NROW, NROW, N2,
     +                      X,
     +                      TITLE1,
     +                      FILEIT)
            ENDIF
         ELSEIF (NDEC.EQ.N6) THEN
C
C NDEC = 6: FDR
C =========
C         
            IF (OK .AND. READY) THEN 
               DO I = N1, NROW
                  X(I) = B(I,7)
               ENDDO   
               WRITE (TITLE1,1500) TAIL, WORD12_KX(1:L_KX),
     +                                   WORD12_KY(1:L_KY)
               CALL FDRVEC (NROW, NF,
     +                   X,
     +                   TITLE1)      
            ENDIF
         ELSEIF (NDEC.EQ.N7) THEN
C
C NDEC = 7: Edit ISZ
C =========
C
            IF (NCOL.GT.N1) THEN   
               CALL ISZEDI (ISZ, NCOL)
               NDEC = N2
               READY = .FALSE.
            ENDIF
         ELSEIF (NDEC.EQ.N8) THEN
C
C NDEC = 8: Change tail
C ========
C            
            CALL LISTBX (KTYPE, N3,
     +                   TAILS)
            READY = .FALSE.                    
         ELSEIF (NDEC.EQ.NOPT - N2) THEN
C
C NDEC = NOPT - 2: Results
C ===============
C
            CALL REVPRO (NF)
            NDEC = N0
         ELSEIF (NDEC.EQ.NOPT - N1) THEN
C
C NDEC = NOPT - 1: Help
C ==================
C
            WRITE (TEXT,2000)
            NUMTXT = 21
            NUMBLD(1) = N1
            CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMTXT,
     +                   TEXT, BORDER)
            NUMBLD(1) = N0
            NDEC = N0
         ELSEIF (NDEC.EQ.NOPT) THEN
C
C NDEC = NOPT: Cancel
C ==============
C
            NEWDAT = .FALSE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Store ISZ then deallocate workspace
C
      DO I = N1, MIN(NCOL,ICMAX)
         ISZSAV(I) = ISZ(I)
      ENDDO
      DEALLOCATE (ISZ, STAT = IERR)
      DEALLOCATE (B, STAT = IERR)
      DEALLOCATE (X, STAT = IERR)
      DEALLOCATE (Y, STAT = IERR)
C
C Format statements
C
  100 FORMAT (
     +'No x,y indicators were found ... consult test file g03adf.tf1')
  200 FORMAT (
     + 'Row-wise group t tests for a',1X,A,1X,'by',1X,A,1X,'matrix'
     +/
     +/'Title of current data:'
     +/A
     +/
     +/'Variables'
     +/A
     +/'Number of x =',1X,A,', Number of y =',1X,A,', Number unused =',
     +1X,A
     +/
     +/'Data: New/Edit/Transform/View'
     +/'Analyse the current data',2X,A
     +/'View/Print/Save all values'
     +/'View/Print/Save t values'
     +/'View/Print/Save p values'
     +/'View/Print/Save false discovery rates'
     +/'Define data columns as X or Y'
     +/'Change p-type, current =',2X,A
     +/'Results'
     +/'Help'
     +/'Quit ... Exit row-wise t tests')
  300 FORMAT ('Analysis number',I3,', NX =',1X,A,', NY =',1X,A,1X,
     +'(-1.0 => failure)')
  400 FORMAT ('Note: tables are large: NROWS =',1X,A)
  500 FORMAT (
     + 'Display table of results'
     +/'Write results to log file')
  600 FORMAT (
     +'         X_bar         X_std         Y_bar         Y_std',
     +'       SE_diff             t',2X,A1,'-tail p ')
  650 FORMAT (
     +'X_bar, X_std, Y_bar, Y_std, SE_diff, t, and',1X,A1,'-tail p ',
     +'(-1.0 => failure)')        
  700 FORMAT (1P,6(1X,E13.5),0P,F10.6)
  750 FORMAT (6(1X,A13),F10.6)
  800 FORMAT (
     +'Number of successes =',1X,A,', Number of failures =',1X,A)   
  900 FORMAT (
     +'t-values: NX =',1X,A,', NY =',1X,A,1X,'(-1.0 => failure)')
 1000 FORMAT (
     +A1,'-tail p: NX =',1X,A,', NY =',1X,A,1X,'(-1.000000 => failure)')
 1500 FORMAT (
     +A1,'-tail p: NX =',1X,A,', NY =',1X,A,1X,'(1 => significant)')    
 2000 FORMAT (
     + 't tests on groups within rows of a matrix'
     +/
     +/'This technique is used when the columns of a matrix represent'
     +/'variables of at least two types, say X and Y, and it is wished'
     +/'to perform t tests on the X and Y groups for all rows.'
     +/
     +/'There are conventions to be observed as follows.'
     +/
     +/'1)`Across the rows there must be at least two X and two Y'
     +/'  `values, preferably much more.'
     +/'2)`Columns representing X and Y variables can be specifed at'
     +/'  `the end of the data file by using the code'
     +/'  `begin{indicators}'
     +/'  ` a b c d ...'
     +/'  `end{indicators}'
     +/'  `where a b c d ... must be 1 for X, 0 for omit, or -1 for Y'
     +/'3)`If this technique is not used, or if it wished to vary the'
     +/'  `group membership, an interactive technique is provided.'
     +/'4)`If a group has zero variance the t test cannot be done, a'
     +/'  `warning is issued, and results for the row are set to -1.'
     +/'5)`A test file illustrating this data format is ttest.tf6')
      END
C
C
