C
C
      SUBROUTINE TTESTS (ISEND, NIN, NMAX, NOUT, NUMX, NUMY,
     +                   X, XSTEP, Y, YSTEP,
     +                   TITLEX, TITLEY)
C
C ACTION : Unpaired and paired t tests
C AUTHOR : W.G.Bardsley, University of Manchester, U.K, 26/04/2004
C          Derived from the original TTESTS by adding ISEND and rearranging
C          17/02/2005 changed NUMBLD(5) to NUMBLD(20)
C          15/11/2013 Changed F test from 1-tail to 2-tail
C
C        ISEND: (input/unchanged) 1 = paired/unpaired, 2 = unpaired, 3 = paired
C          NIN: (input/unchanged) unconnected unit for file opening
C         NMAX: (input/unchanged) dimension
C         NOUT: (input/unchanged) unit connected for saving results
C         NUMX: (input/output) sample size for X
C         NUMY: (input/output) sample size for Y
C            X: (input/output) X-data
C            Y: (input/output) Y-data
C        XSTEP: workspace
C        YSTEP: workspace
C       TITLEX: (input/output) X-title
C       TITLEY: (input/output) Y-title
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    ISEND, NIN, NMAX, NOUT, NUMX, NUMY
      DOUBLE PRECISION X(NMAX), XSTEP(2*NMAX), Y(NMAX), YSTEP(2*NMAX)
      CHARACTER  TITLEX*(*), TITLEY*(*)
C
C Locals
C
      INTEGER    I, ICOUNT, IFAIL, JCOUNT, KCOUNT, NDOF, N1, N2
      INTEGER    JSEND
      PARAMETER (JSEND = 4) 
      INTEGER    ICOLOR, IX, IY
      PARAMETER (IX = 4, IY = 4)
      INTEGER    K0, K1, K2, K3, K5
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K3 = 3, K5 = 5)
      INTEGER    NUMTXT
      INTEGER    NDOF_NAG
      INTEGER    LSHADE, NUMDEC, NSTART, NTEXT, NUMOPT
      PARAMETER (LSHADE = 1, NUMDEC = 1)
      INTEGER    KUMPOS(3), NUMBLD(20), NUMPOS(5)
      DOUBLE PRECISION PNT01, PNT05, PNT975
      PARAMETER (PNT01 = 0.01D+00, PNT05 = 0.05D+00, PNT975 = 0.975D+00)
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION RTOL
      DOUBLE PRECISION SSQ, S1, S2, PFGTVR, P2, VRATIO
      DOUBLE PRECISION ALPHA, BETA, GAMMA, XBAR, XVAR, YBAR, YVAR
      DOUBLE PRECISION DBAR, DIFF, DHIGH, DLOW, DVAR, SEDBAR, SEDIFF
      DOUBLE PRECISION BOT, TOP, TP, TU, T95
      DOUBLE PRECISION ALPHA_NAG, BETA_NAG, DLOW_NAG, DHIGH_NAG, F_NAG,
     +                 GAMMA_NAG, SE_NAG, TU_NAG
      DOUBLE PRECISION DNDF, DNX, DNY
      DOUBLE PRECISION G01EBF$, G01EDF$, G01FBF$, X02AMF$
      CHARACTER  LINE*100, TEXT(30)*100, TTEXT(4)*100
      CHARACTER  CHOP80*80, TEMP(5)*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    ABORT, YES
      LOGICAL    FIXNPT
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   G01EBF$, G01FBF$, G01EDF$, X02AMF$
      EXTERNAL   NXXBAR, PUTFAT, PUTIFA, TABLE1, YESNO2, MIDDLE, VECTWO,
     +           NORDIS, CHOP80, RBOX01
      INTRINSIC  SQRT, MIN, DBLE, NINT
      SAVE       ICOUNT, JCOUNT, KCOUNT
      SAVE       KUMPOS, NUMPOS
      DATA       ICOUNT, JCOUNT, KCOUNT / 0, 0, 0 /
      DATA       NUMBLD / 20*0 /
      DATA       KUMPOS / 2*1, 0 /
      DATA       NUMPOS / 4*1, 0 /
C
C Scheme for controlling the t test procedures (0 = false, 1 = true)
C
C     NUMPOS(1) = 0: no Shapiro-Wilks normality test for small samples
C     NUMPOS(2) = 0: no variance ratio tests for small samples
C     NUMPOS(3) = 0: no unpaired t test (set to 1 if ISEND = 2)
C     NUMPOS(4) = 0: no paired t test   (set to 1 if ISEND = 3)
C     NUMPOS(5) = 0: no further questions
C     KUMPOS(1) = NUMPOS(1)...these are always equal
C     KUMPOS(2) = NUMPOS(2)...these are always equal
C     KUMPOS(3) = NUMPOS(5)...these are always equal
C     ISEND = 1: NUMPOS are primary, KUMPOS secondary
C     ISEND > 1: KUMPOS are primary, NUMPOS are secondary
C
      IF (ISEND.EQ.K1) THEN
C
C Do both tests
C
         NUMOPT = K5
         FIXNPT = .FALSE.
      ELSEIF (ISEND.EQ.K2) THEN
C
C Do unpaired only
C
         NUMOPT = K3
         NUMPOS(3) = K1
         NUMPOS(4) = K0
         FIXNPT = .FALSE.
      ELSEIF (ISEND.EQ.3) THEN
C
C Do paired only
C
         NUMOPT = K3
         NUMPOS(3) = K0
         NUMPOS(4) = K1
         FIXNPT = .TRUE.
      ELSE
         RETURN
      ENDIF
C
C First read in data ... Use a larger RTOL than usual
C
      RTOL = 1.0D+09*X02AMF$()
      RTOL = 1.0D+09*RTOL
      CALL VECTWO (NIN, NMAX, NUMX, NUMY,
     +             X, Y,
     +             TITLEX, TITLEY,
     +             ABORT, FIXNPT)
      IF (ABORT) RETURN
      IF (NUMX.LT.K2 .OR. NUMY.LT.K2) THEN
         WRITE (LINE,100) NUMX, NUMY
         CALL PUTFAT (LINE)
         RETURN
      ENDIF
C
C Calculate means and variances
C
      CALL NXXBAR (NUMX, X, XBAR, XVAR)
      CALL NXXBAR (NUMY, Y, YBAR, YVAR)
      IF (XVAR.LE.RTOL .OR. YVAR.LE.RTOL) THEN
         WRITE (LINE,200)
         CALL PUTFAT (LINE)
         RETURN
      ENDIF
C
C Check-list if NUMPOS(5) = 0
C
      IF (KUMPOS(3).EQ.K0 .OR. NUMPOS(5).EQ.K0) THEN
         IF (ISEND.EQ.K1) THEN
            WRITE (TEXT,300)
            ICOLOR = K1
            NUMBLD(1) = K1
            NSTART = 8
            NTEXT = 12
            CALL RBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                   NUMPOS, NSTART, NTEXT,
     +                   TEXT,
     +                   BORDER, FLASH, HIGH)
            KUMPOS(1) = NUMPOS(1)
            KUMPOS(2) = NUMPOS(2)
            KUMPOS(3) = NUMPOS(5)
         ELSE
            WRITE (TEXT,350)
            ICOLOR = K1
            NUMBLD(1) = K1
            NSTART = 7
            NTEXT = 9
            CALL RBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                   KUMPOS, NSTART, NTEXT,
     +                   TEXT,
     +                   BORDER, FLASH, HIGH)
            NUMPOS(1) = KUMPOS(1)
            NUMPOS(2) = KUMPOS(2)
            NUMPOS(5) = KUMPOS(3)
         ENDIF
      ENDIF
      IF (NUMPOS(1).EQ.K0 .AND. NUMPOS(2).EQ.K0 .AND.
     +    NUMPOS(3).EQ.K0 .AND. NUMPOS(4).EQ.K0) NUMPOS(5) = K0
C
C Shapiro-Wilks if NUMPOS(1) = 1
C
      IF (NUMPOS(1).EQ.K1) THEN
         CALL NORDIS (JSEND, NUMX, NOUT,
     +                X, XSTEP, YSTEP,
     +                TTEXT, 'X-data for t test')
         CALL NORDIS (JSEND, NUMY, NOUT,
     +                Y, XSTEP, YSTEP,
     +                TTEXT, 'Y-data for t test')
      ENDIF
C
C Variance ratio test if NUMPOS(2) = 1
C
      IF (NUMPOS(2).EQ.K1) THEN
C
C Output means and standard deviations
C
         ICOUNT = ICOUNT + K1
         WRITE (TEXT,400) ICOUNT,
     +                    CHOP80(TITLEX), NUMX, XBAR, XVAR, SQRT(XVAR),
     +                    CHOP80(TITLEY), NUMY, YBAR, YVAR, SQRT(YVAR)
         WRITE (NOUT,450) ICOUNT,
     +                    TITLEX, NUMX, XBAR, XVAR, SQRT(XVAR),
     +                    TITLEY, NUMY, YBAR, YVAR, SQRT(YVAR)
C
C Now variance ratio (F) test
C
         IF (XVAR.GE.YVAR) THEN
            S1 = XVAR
            S2 = YVAR
            N1 = NUMX - K1
            N2 = NUMY - K1
         ELSE
            S1 = YVAR
            S2 = XVAR
            N1 = NUMY - K1
            N2 = NUMX - K1
         ENDIF
         IF (S2.GT.RTOL) THEN
            VRATIO = S1/S2
            IFAIL = K1
            PFGTVR = G01EDF$('Upper-tail', VRATIO, DBLE(N1), DBLE(N2),
     +                      IFAIL)
            IF (IFAIL.EQ.0) THEN
               P2 = TWO*PFGTVR
               WRITE (TEMP,500) VRATIO, N1, N2, PFGTVR, P2
               WRITE (NOUT,550) VRATIO, N1, N2, PFGTVR, P2
               DO I = K1, K5
                  TEXT(14 + I) = TEMP(I)
               ENDDO
               IF (P2.LE.PNT01) THEN
                  WRITE (LINE,600)
                  WRITE (NOUT,600)
               ELSEIF (P2.LE.PNT05) THEN
                  WRITE (LINE,700)
                  WRITE (NOUT,700)
               ELSE
                  WRITE (LINE,800)
                  WRITE (NOUT,800)
               ENDIF
               NUMTXT = 20
               TEXT(NUMTXT) = BLANK
               NUMTXT = 21
               TEXT(NUMTXT) = LINE
               ICOLOR = 15
               CALL TABLE1 (ICOLOR, 'OPEN')
               DO I = K1, NUMTXT
                  IF (I.EQ.1 .OR. I.EQ.4 .OR. I.EQ.10 .OR.
     +                I.EQ.NUMTXT) THEN
                     ICOLOR = 4
                  ELSE
                     ICOLOR = 0
                  ENDIF
                  CALL TABLE1 (ICOLOR, TEXT(I))
               ENDDO
               CALL TABLE1 (ICOLOR, 'CLOSE')
            ELSE
               CALL PUTIFA (IFAIL, NOUT, 'G01EDF/TTESTS')
            ENDIF
         ENDIF
      ENDIF
C
C t test if NUMPOS(3) = 1
C
      IF (NUMPOS(3).EQ.K1) THEN
C
C Unpaired t test
C
         DNX = DBLE(NUMX)
         DNY = DBLE(NUMY)
         TOP = (DNX - ONE)*XVAR + (DNY - ONE)*YVAR
         IF (TOP.GT.RTOL) THEN
            DIFF = XBAR - YBAR
            NDOF = NUMX + NUMY - K2
            DNDF = DBLE(NDOF)
            BOT = DBLE(NDOF)
            SSQ = TOP/BOT
            SEDIFF = SQRT(SSQ*(ONE/DNX + ONE/DNY))
            TU = DIFF/SEDIFF
            IFAIL = K1
            BETA = G01EBF$('Lower-tail', TU, DNDF, IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01EBF/TTESTS')
            ALPHA = ONE - BETA
            GAMMA = TWO*MIN(ALPHA, BETA)
            CALL MIDDLE (ZERO, ALPHA, ONE)
            CALL MIDDLE (ZERO, BETA, ONE)
            CALL MIDDLE (ZERO, GAMMA, ONE)
C
C Satterthwaites procedure for unequal variances
C
            SE_NAG = SQRT(XVAR/DNX + YVAR/DNY)
            TOP = SE_NAG**4
            BOT = (XVAR/DNX)**2/(DNX - ONE) + (YVAR/DNY)**2/(DNY - ONE)
            F_NAG = TOP/BOT
            NDOF_NAG = NINT(F_NAG)
            TU_NAG = DIFF/SE_NAG
            IFAIL = K1
            BETA_NAG = G01EBF$('Lower-tail', TU_NAG, F_NAG, IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01EBF/TTESTS')
            ALPHA_NAG = ONE - BETA_NAG
            GAMMA_NAG = TWO*MIN(ALPHA_NAG, BETA_NAG)
            CALL MIDDLE (ZERO, ALPHA_NAG, ONE)
            CALL MIDDLE (ZERO, BETA_NAG, ONE)
            CALL MIDDLE (ZERO, GAMMA_NAG, ONE)
            JCOUNT = JCOUNT + K1
            WRITE (TEXT,900) JCOUNT,
     +                       NUMX, NUMY, NDOF, NDOF_NAG, TU, TU_NAG,
     +                       ALPHA, ALPHA_NAG, BETA, BETA_NAG,
     +                       GAMMA, GAMMA_NAG
            WRITE (NOUT,950) JCOUNT,
     +                       NUMX, NUMY, NDOF, NDOF_NAG, TU, TU_NAG,
     +                       ALPHA, ALPHA_NAG, BETA, BETA_NAG,
     +                       GAMMA, GAMMA_NAG
            NUMTXT = 9
            IFAIL = K1
            T95 = G01FBF$('Lower-tail', PNT975, DBLE(NDOF), IFAIL)
            IF (IFAIL.EQ.K0) THEN
               DLOW = DIFF - T95*SEDIFF
               DHIGH = DIFF + T95*SEDIFF
               DLOW_NAG = DIFF - T95*SE_NAG
               DHIGH_NAG = DIFF + T95*SE_NAG
               WRITE (TEMP,1000) DIFF, DLOW, DLOW_NAG, DHIGH, DHIGH_NAG
               WRITE (NOUT,1050) DIFF, DLOW, DLOW_NAG, DHIGH, DHIGH_NAG
               DO I = K1, K3
                  NUMTXT = NUMTXT + K1
                  TEXT(NUMTXT) = TEMP(I)
               ENDDO
            ELSE
               CALL PUTIFA (IFAIL, NOUT, 'G01FBF/TTESTS')
            ENDIF
            IF (GAMMA.LE.PNT01) THEN
               WRITE (LINE,1100)
               WRITE (NOUT,1100)
            ELSEIF (GAMMA.LE.PNT05) THEN
               WRITE (LINE,1200)
               WRITE (NOUT,1200)
            ELSE
               WRITE (LINE,1300)
               WRITE (NOUT,1300)
            ENDIF
            NUMTXT = NUMTXT + K1
            TEXT(NUMTXT) = BLANK
            NUMTXT = NUMTXT + K1
            TEXT(NUMTXT) = LINE
            ICOLOR = 15
            CALL TABLE1 (ICOLOR, 'OPEN')
            DO I = K1, NUMTXT
               IF (I.EQ.1 .OR. I.EQ.NUMTXT) THEN
                  ICOLOR = 4
               ELSE
                  ICOLOR = 0
               ENDIF
               CALL TABLE1 (ICOLOR, TEXT(I))
            ENDDO
            CALL TABLE1 (ICOLOR, 'CLOSE')
         ELSE
            WRITE (LINE,1400)
            WRITE (NOUT,1400)
            CALL PUTFAT (LINE)
         ENDIF
      ENDIF
C
C Option for paired t test if NUMX = NUMY
C
      IF (NUMPOS(4).EQ.K1 .AND. NUMX.EQ.NUMY) THEN
         IF (ISEND.EQ.K1) THEN
            WRITE (LINE,1500)
            YES = .TRUE.
            ICOLOR = 3
            CALL YESNO2 (ICOLOR, IX, IY, LINE, YES)
            IF (.NOT.YES) RETURN
         ENDIF
         DO I = K1, NUMX
            XSTEP(I) = X(I) - Y(I)
         ENDDO
         CALL NXXBAR (NUMX, XSTEP, DBAR, DVAR)
         IF (DVAR.LE.RTOL) THEN
            WRITE (LINE,200)
            CALL PUTFAT (LINE)
            RETURN
         ENDIF
         SEDBAR = SQRT(DVAR/NUMX)
         TP = DBAR/SEDBAR
         NDOF = NUMX - K1
         IFAIL = K1
         BETA = G01EBF$('Lower-tail', TP, DBLE(NDOF), IFAIL)
         IF (IFAIL.EQ.K0) THEN
            ALPHA = ONE - BETA
            GAMMA = TWO*MIN(ALPHA, BETA)
            CALL MIDDLE (ZERO, ALPHA, ONE)
            CALL MIDDLE (ZERO, BETA, ONE)
            CALL MIDDLE (ZERO, GAMMA, ONE)
            KCOUNT = KCOUNT + K1
            WRITE (TEXT,1600) KCOUNT, NUMX, NDOF, TP, ALPHA, BETA, GAMMA
            WRITE (NOUT,1650) KCOUNT, NUMX, NDOF, TP, ALPHA, BETA, GAMMA
         ELSE
            CALL PUTIFA (IFAIL, NOUT, 'G01BAF/TTESTS')
            RETURN
         ENDIF
         IFAIL = K1
         T95 = G01FBF$('Lower-tail', PNT975, DBLE(NDOF), IFAIL)
         IF (IFAIL.EQ.K0) THEN
            DLOW = DBAR - T95*SEDBAR
            DHIGH = DBAR + T95*SEDBAR
            WRITE (TEMP,1700) DBAR, DLOW, DHIGH
            WRITE (NOUT,1750) DBAR, DLOW, DHIGH
            NUMTXT = 8
            DO I = K1, K3
               NUMTXT = NUMTXT + K1
               TEXT(NUMTXT) = TEMP(I)
            ENDDO
         ELSE
            CALL PUTIFA (IFAIL, NOUT, 'G01FBF/TTESTS')
            RETURN
         ENDIF
         IF (GAMMA.LE.PNT01) THEN
            WRITE (LINE,1100)
            WRITE (NOUT,1100)
         ELSEIF (GAMMA.LE.PNT05) THEN
            WRITE (LINE,1200)
            WRITE (NOUT,1200)
         ELSE
            WRITE (LINE,1300)
            WRITE (NOUT,1300)
         ENDIF
         NUMTXT = NUMTXT + K1
         TEXT(NUMTXT) = BLANK
         NUMTXT = NUMTXT + K1
         TEXT(NUMTXT) = LINE
         ICOLOR = 15
         CALL TABLE1 (ICOLOR, 'OPEN')
         DO I = K1, NUMTXT
            IF (I.EQ.1 .OR. I.EQ.NUMTXT) THEN
               ICOLOR = 4
            ELSE
               ICOLOR = 0
            ENDIF
            CALL TABLE1 (ICOLOR, TEXT(I))
         ENDDO
         CALL TABLE1 (ICOLOR, 'CLOSE')
      ENDIF
  100 FORMAT ('Nx =',I2,', Ny =',I2,' ... Sample size too small')
  200 FORMAT ('Variance too small for analysis')
  300 FORMAT (
     + 'Configuration options for normal, variance ratio and t tests'
     +/'...'
     +/'Do normality tests only for large samples'
     +/'Do variance ratio tests only for very large samples'
     +/'Do paired t tests only for paired samples'
     +/'Tick OK only when the configuration is as required'
     +/'...'
     +/'Shapiro-Wilks normality tests'
     +/'Variance ratio F test'
     +/'Unpaired t test'
     +/'Paired t test'
     +/'OK ... Do not ask again this session')
  350 FORMAT (
     + 'Configuration options for normal, variance ratio and t tests'
     +/'...'
     +/'Do normality tests only for large samples'
     +/'Do variance ratio tests only for very large samples'
     +/'Tick OK only when the configuration is as required'
     +/'...'
     +/'Shapiro-Wilks normality tests'
     +/'Variance ratio F test'
     +/'OK ... Do not ask again this session')
  400 FORMAT (
     + 'F test for equality of variances',I4
     +/
     +/'X-data:'
     +/A
     +/'No. of x-values         =',I8
     +/'Mean x                  =',1P,E11.3
     +/'Sample variance of x    =',E11.3
     +/'Sample std. dev. of x   =',E11.3
     +/'Y-data:'
     +/A
     +/'No. of y-values         =',I8
     +/'Mean y                  =',1P,E11.3
     +/'Sample variance of y    =',   E11.3
     +/'Sample std. dev. of y   =',   E11.3)
  450 FORMAT (
     +/1X,'F test for equality of variances',I4
     +/1X,'===================================='
     +/1X,'X-data: ',A
     +/1X,'No. of x-values         =',I8
     +/1X,'Mean x                  =',1P,E11.3
     +/1X,'Sample variance of x    =',   E11.3
     +/1X,'Sample std. dev. of x   =',   E11.3
     +/1X,'Y-data: ',A
     +/1X,'No. of y-values         =',I8
     +/1X,'Mean y                  =',1P,E11.3
     +/1X,'Sample variance of y    =',   E11.3
     +/1X,'Sample std. dev. of y   =',   E11.3)
  500 FORMAT (
     + 'Variance ratio             =',1P,E11.3
     +/'Deg. of freedom (num)      =',I8
     +/'Deg. of freedom (denom)    =',I8
     +/'p = P(F >= Variance ratio) =',0P,F8.4
     +/'Two tail p value           =',   F8.4)
  550 FORMAT (
     + 1X,'Variance ratio             =',1P,E11.3
     +/1X,'Deg. of freedom (num)      =',I8
     +/1X,'Deg. of freedom (denom)    =',I8
     +/1X,'p = P(F >= Variance ratio) =',0P,F8.4
     +/1X,'Two tail p value           =',   F8.4)
  600 FORMAT (
     +1X,'Conclusion: Reject equality of variances at 1% sig. level')
  700 FORMAT (
     +1X,'Conclusion: Reject equality of variances at 5% sig. level')
  800 FORMAT (
     +1X,'Conclusion: Consider accepting equality of variances')
  900 FORMAT (
     + 'Unpaired t test ([ ] = corrected for unequal variances)',I4
     +/
     +/'No. of x-values              =',I8
     +/'No. of y-values              =',I8
     +/'No. of degrees of freedom    =',I8,'    [',I8,']'
     +/'Unpaired t test statistic U  =',1P,E11.3,' [',E11.3,']'
     +/'p = P(t >= U) (upper tail p) =',0P,F8.4,'    [',F8.4,']'
     +/'p = P(t =< U) (lower tail p) =',F8.4,'    [',F8.4,']'
     +/'p for two tailed t test      =',F8.4,'    [',F8.4,']')
  950 FORMAT (
     +/1X,'Unpaired t test ([ ] = corrected for unequal variances)',I4
     +/1X,'==========================================================='
     +/1X,'No. of x-values              =',I8
     +/1X,'No. of y-values              =',I8
     +/1X,'No. of degrees of freedom    =',I8,'    [',I8,']'
     +/1X,'Unpaired t test statistic U  =',1P,E11.3,' [',E11.3,']'
     +/1X,'p = P(t >= U) (upper tail p) =',0P,F8.4,'    [',F8.4,']'
     +/1X,'p = P(t =< U) (lower tail p) =',F8.4,'    [',F8.4,']'
     +/1X,'p for two tailed t test      =',F8.4,'    [',F8.4,']')
 1000 FORMAT (
     + 'Difference between means DM =',1P,E11.3
     +/'Lower 95% con. limit for DM =',   E11.3,' [',E11.3,']'
     +/'Upper 95% con. limit for DM =',   E11.3,' [',E11.3,']')
 1050 FORMAT (
     + 1X,'Difference between means DM =',1P,E11.3
     +/1X,'Lower 95% con. limit for DM =',   E11.3,' [',E11.3,']'
     +/1X,'Upper 95% con. limit for DM =',   E11.3,' [',E11.3,']')
 1100 FORMAT (
     +1X,'Conclusion: Reject equality of means at 1% sig. level' )
 1200 FORMAT (
     +1X,'Conclusion: Reject equality of means at 5% sig. level' )
 1300 FORMAT (
     +1X,'Conclusion: Consider accepting equality of means')
 1400 FORMAT ('Unpaired t test not possible for this data')
 1500 FORMAT ('Do a paired t test ? (yes ... only if data are paired) ')
 1600 FORMAT (
     + 'Paired t test',I4
     +/
     +/'No. of paired comparisons   =',I8
     +/'No. of degrees of freedom   =',I8
     +/'Paired t test statistic S   =',1P,E11.3
     +/'P(t >= S)                   =',0P,F8.4
     +/'P(t =< S)                   =',   F8.4
     +/'p for two tailed t test     =',   F8.4)
 1650 FORMAT (
     +/1X,'Paired t test',I4
     +/1X,'================='
     +/1X,'No. of paired comparisons   =',I8
     +/1X,'No. of degrees of freedom   =',I8
     +/1X,'Paired t test statistic S   =',1P,E11.3
     +/1X,'p = P(t >= S)               =',0P,F8.4
     +/1X,'p = P(t =< S)               =',   F8.4
     +/1X,'p for two tailed t test     =',   F8.4)
 1700 FORMAT (
     + 'Mean of differences MD      =',1P,E11.3
     +/'Lower 95% con. limit for MD =',   E11.3
     +/'Upper 95% con. limit for MD =',   E11.3)
 1750 FORMAT (
     + 1X,'Mean of differences MD      =',1P,E11.3
     +/1X,'Lower 95% con. limit for MD =',   E11.3
     +/1X,'Upper 95% con. limit for MD =',   E11.3)
      END
C
C
