C
C
      SUBROUTINE TUKEYQ (IR, IV, NF, NOBS, NSORT, ERROR, Y)
C
C ACTION: Tukey Q test
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 10/12/99
C         13/10/2000 corrected output table and improved diagnostics
C         21/09/2021 added e_numbers and e_formats, etc. 
C
C         IR = no. of means from ANOVA
C         IV = no. degrees of freedom for experimental ERROR from ANOVA
C         NF = output unit
C         NOBS = no. in each category
C         NSORT = column no. for categories used in ANOVA
C         ERROR = error sum of squares
C         Y = vector of means
C
      IMPLICIT   NONE
      INTEGER    IR, IV, NF, NOBS(IR), NSORT(IR)
      INTEGER    NMAX
      PARAMETER (NMAX = 50)
      INTEGER    I, ICOLOR, IFAIL, J, K, L, M
      DOUBLE PRECISION ERROR, Y(IR)
      DOUBLE PRECISION G01EMF$, G01FMF$
      DOUBLE PRECISION FACTOR, P, P95, P99, Q, SE, V, XA, XB, YDIFF
      DOUBLE PRECISION Y1(NMAX), Y2(NMAX), Y3(NMAX), Y4(NMAX)
      DOUBLE PRECISION ONE, TWO
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION PNT01, PNT05
      PARAMETER (PNT01 = 0.01D+00, PNT05 = 0.05D+00)
      DOUBLE PRECISION PNT1, PNT5
      PARAMETER (PNT1 = 0.1D+00, PNT5 = 0.5D+00)
      CHARACTER  LINE*100
      CHARACTER (LEN = 12) FORM12, I12(2)
      CHARACTER (LEN = 13) D13(2), SHOWLJ, SHOWRJ
      CHARACTER  PC1*8, PC5*8, IWARNU*8
      CHARACTER  BLANK*8, ACCEPT*8, REJECT*8, NO_TEST*8
      PARAMETER (BLANK = '       ', ACCEPT = '      NS',
     +           REJECT = '       *', NO_TEST = ' No-Test')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    NOTYET_1(NMAX,NMAX), NOTYET_5(NMAX,NMAX)
      LOGICAL    EXTRA1, EXTRA2
      EXTERNAL   HPSORT, TABLE1, PUTFAT, FORM12, SHOWLJ, SHOWRJ,
     +           E_FORMATS
      EXTERNAL   G01EMF$, G01FMF$
      INTRINSIC  DBLE, SQRT, NINT
C
C Check dimensions of Y
C
      IF (IR.GT.NMAX) THEN
         CALL PUTFAT ('Maximum dimension exceeded in call to TUKEYQ')
         RETURN
      ENDIF
      E_NUMBERS = E_FORMATS()
C
C Copy the data
C
      K = IR
      V = DBLE(IV)
      DO I = 1, K
         Y1(I) = Y(I)
         Y2(I) = DBLE(NSORT(I))
         Y3(I) = ONE/DBLE(NOBS(I))
         Y4(I) = DBLE(NOBS(I))
      ENDDO
C
C Iinitialise the lower triangle of the NOTYET matrices
C
      DO J = 1, K
         DO I = J, K
            NOTYET_1(I,J) = .TRUE.
            NOTYET_5(I,J) = .TRUE.
         ENDDO
      ENDDO
C
C Sort into increasing order
C
      CALL HPSORT (K, Y1, Y2, Y3, Y4)
C
C Get the critical values for Q and calculate FACTOR
C
      P = ONE - PNT01
      IFAIL = 0
      P99 = G01FMF$(P, V, K, IFAIL)
      IFAIL = 0
      P = ONE - PNT05
      P95 = G01FMF$(P, V, K, IFAIL)
      FACTOR = SQRT(ERROR/TWO)
C
C Set up the header for the table
C
      ICOLOR = 15
      CALL TABLE1 (ICOLOR, 'OPEN')
      ICOLOR = 4
      I12(1) = FORM12(K)
      I12(2) = FORM12((K*(K - 1)/2))
      WRITE (LINE,100) TRIM(I12(1)), TRIM(I12(2))
      WRITE (NF,'(A)') BLANK
      WRITE (NF,'(A)') LINE
      CALL TABLE1 (ICOLOR, LINE)
      ICOLOR = 1
      IF (E_NUMBERS) THEN 
         WRITE (LINE,200) P95, P99
      ELSE
         D13(1) = SHOWLJ(P95)
         D13(2) = SHOWLJ(P99)
         WRITE (LINE,250) TRIM(D13(1)), TRIM(D13(2)) 
      ENDIF  
      WRITE (NF,'(A)') LINE
      CALL TABLE1 (ICOLOR, LINE)
      ICOLOR = 4
      WRITE (LINE,300)
      WRITE (NF,'(A)') LINE
      CALL TABLE1 (ICOLOR,LINE)
      ICOLOR = 0
C
C The main loop. I decends from largest to smallest
C ============== J ascends from smallest to next to largest
C
      EXTRA1 = .FALSE.
      EXTRA2 = .FALSE.
      DO I = K, 2, -1
         DO J = 1, (I - 1)

C
C Calculate SE, XA, XB, Q and P
C
            SE = FACTOR*SQRT(Y3(I) + Y3(J))
            XB = Y1(I)
            XA = Y1(J)
            Q = (XB - XA)/SE
            IFAIL = 0
            P = ONE - G01EMF$(Q, V, K, IFAIL)
C
C Is P < 0.01 ?
C
            IF (P.LE.PNT01) THEN
               IF (NOTYET_1(I,J)) THEN
                  PC1 = REJECT
               ELSE
                  PC1 = NO_TEST
               ENDIF
            ELSE
               IF (NOTYET_1(I,J)) THEN
                  PC1 = ACCEPT
               ELSE
                  PC1 = NO_TEST
               ENDIF
               DO L = I, J, -1
                  DO M = J, L
                     NOTYET_1(L,M) = .FALSE.
                  ENDDO
               ENDDO
            ENDIF
C
C Is P < 0.05 ?
C
            IF (P.LE.PNT05) THEN
               IF (NOTYET_5(I,J)) THEN
                  PC5 = REJECT
               ELSE
                  PC5 = NO_TEST
               ENDIF
            ELSE
               IF (NOTYET_5(I,J)) THEN
                  PC5 = ACCEPT
               ELSE
                  PC5 = NO_TEST
               ENDIF
               DO L = I, J, -1
                  DO M = J, L
                     NOTYET_5(L,M) = .FALSE.
                  ENDDO
               ENDDO
            ENDIF
C
C Calculate IWARNU and see if warnings are required
C
            IF (PC1.EQ.NO_TEST .OR. PC5.EQ.NO_TEST) EXTRA1 = .TRUE.
            YDIFF = (Y4(I) - Y4(J))/(Y4(I) + Y4(J))
            IF (YDIFF.GT.PNT5) THEN
               IWARNU = ' NB>>>NA'
               EXTRA2 = .TRUE.
            ELSEIF (YDIFF.GT.PNT1) THEN
               IWARNU = ' NB > NA'
            ELSEIF (YDIFF.LT. - PNT5) THEN
               IWARNU = ' NB<<<NA'
               EXTRA2 = .TRUE.
            ELSEIF (YDIFF.LT. - PNT1) THEN
               IWARNU = ' NB < NA'
            ELSE
               IWARNU = BLANK
            ENDIF
C
C Write out the results
C

            IF (E_NUMBERS) THEN
               IF (PC1.EQ.NO_TEST) THEN
                  WRITE (LINE,400) NINT(Y2(I)), NINT(Y2(J)),
     +                             Q, P, PC5, PC1,
     +                             NINT(Y4(I)), NINT(Y4(J)), IWARNU
               ELSEIF (PC5.EQ.NO_TEST) THEN
                  WRITE (LINE,500) NINT(Y2(I)), NINT(Y2(J)),
     +                             Q, P, PC5, PC1,
     +                             NINT(Y4(I)), NINT(Y4(J)), IWARNU
               ELSE
                  WRITE (LINE,600) NINT(Y2(I)), NINT(Y2(J)),
     +                             Q, P, PC5, PC1,
     +                             NINT(Y4(I)), NINT(Y4(J)), IWARNU
               ENDIF
            ELSE
                D13(1) = SHOWRJ(Q)
                IF (PC1.EQ.NO_TEST) THEN
                   WRITE (LINE,450) NINT(Y2(I)), NINT(Y2(J)),
     +                              D13(1), P, PC5, PC1,
     +                              NINT(Y4(I)), NINT(Y4(J)), IWARNU
               ELSEIF (PC5.EQ.NO_TEST) THEN
                  WRITE (LINE,550) NINT(Y2(I)), NINT(Y2(J)),
     +                             D13(1), P, PC5, PC1,
     +                             NINT(Y4(I)), NINT(Y4(J)), IWARNU
               ELSE
                  WRITE (LINE,650) NINT(Y2(I)), NINT(Y2(J)),
     +                             D13(1), P, PC5, PC1,
     +                             NINT(Y4(I)), NINT(Y4(J)), IWARNU
               ENDIF  
            ENDIF   
            WRITE (NF,'(A)') LINE
            CALL TABLE1 (ICOLOR, LINE)
         ENDDO

      ENDDO
C
C Issue warnings if required
C
      ICOLOR = 1
      IF (EXTRA1) THEN
         WRITE (LINE,700)
         CALL TABLE1(ICOLOR, LINE)
         WRITE (NF,'(A)') LINE
      ENDIF
      IF (EXTRA2) THEN
         WRITE (LINE,800)
         CALL TABLE1 (ICOLOR, LINE)
         WRITE (NF,'(A)') LINE
      ENDIF
C
C Close down the table
C
      CALL TABLE1 (ICOLOR, 'CLOSE')
C  100 FORMAT ('Tukey Q-test with',I3,' means and',i3,' comparisons')
  100 FORMAT ('Tukey Q-test with ',A,' means and ',A,' comparisons')
  200 FORMAT ('5% point =',1P,E13.5,', 1% point =',E13.5)
  250 FORMAT ('5% point =',1X,A,', 1% point =',1X,A)
  300 FORMAT ('Col1 Col2            Q         p           5%        1%',
     +'    NB    NA')
  400 FORMAT (I4,I5,'  [[',1P,E13.5,0P,F8.4,']]',A8,2X,A8,2I6,2X,A8)
  450 FORMAT (I4,I5,'  [[',1X,A13,F8.4,']]',A8,2X,A8,2I6,2X,A8)
  500 FORMAT (I4,I5,'   [',1P,E13.5,0P,F8.4,'] ',A8,2X,A8,2I6,2X,A8)
  550 FORMAT (I4,I5,'   [',1X,A13,F8.4,'] ',A8,2X,A8,2I6,2X,A8)
  600 FORMAT (I4,I5,4X,1P,E13.5,0P,F8.4,2X,A8,2X,A8,2I6,2X,A8)
  650 FORMAT (I4,I5,4X,1X,A13,F8.4,2X,A8,2X,A8,2I6,2X,A8)
  700 FORMAT (
     +'[ 5%] and/or [[ 1%]] No-Test results given for reference only')
  800 FORMAT (
     +'NB>>>NA and/or NB<<<NA suggest extreme sample size difference')
      END



