C
C
      SUBROUTINE UPDOWN (NIN, NMAX, NOUT, NZ,
     +                   Z,
     +                   TITLEZ,
     +                   NEW_DATA, SUPPLY)
C
C ACTION: Runs up and down test for randomness
C AUTHOR: W.G.Bardsley, University of Manchester, U.K.
C
C 22/05/1996 Corrected IFAIL = 7, 8 mistake after second call to G08EAF,
C            changed MAXR and added checks for ill conditioned calculations
C 03/03/2005 re-instated and increased MAXR from 4 to 10 for true NAG version
C 20/08/2007 added SUPPLY
C 16/08/2012 added NEW_DATA, LDCOV and calls to LISTBX, PATCH2, and GETJM1,
C            also removed U from argument list and many other changes 
C 25/07/2022 added E_NUMBERS and E_FORMATS, etc.    
C
C      NIN: (input/unchanged) unconnected unit for data input
C     NMAX: (input/unchanged) dimension
C     NOUT: (input/unchanged) preconnected unit for results
C       NZ: (input/output) dimension of sample 
C        Z: (input/output) data
C   TITLEZ: (input/output) title
C   SUPPLY: (input/unchanged) if true data are supplied
C NEW_DATA: (output) action required
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NIN, NMAX, NOUT
      INTEGER,             INTENT (INOUT) :: NZ
      DOUBLE PRECISION,    INTENT (INOUT) :: Z(NMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: TITLEZ
      LOGICAL,             INTENT (IN)    :: SUPPLY   
      LOGICAL,             INTENT (OUT)   :: NEW_DATA        
C
C Locals
C
      INTEGER    NUMDEC, NUMOPT, NUMSTA, NUMTXT
      PARAMETER (NUMOPT = 6, NUMSTA = 10, NUMTXT = NUMSTA + NUMOPT - 1)
      INTEGER    LDCOV, LWRK, M, MAXR, NRUNS
      PARAMETER (M = 0, LDCOV = 20, LWRK = LDCOV*(LDCOV + 5)/2 + 1)
      INTEGER    NCOUNT(LDCOV), NUMBLD(30)
      INTEGER    ICOUNT
      INTEGER    I, IFAIL, J, K
      DOUBLE PRECISION CHID, CHIU, DFD, DFU, EX(LDCOV), PROBD, PROBU
      DOUBLE PRECISION COV(LDCOV,LDCOV), WRK(LWRK)
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER  TYPEU*23, TYPED*23, YESNO*5
      CHARACTER  CHOP80*80, LINE*100, WORD80*80
      CHARACTER  BLANK*1, CL*1
      PARAMETER (BLANK = ' ', CL = 'S')
      CHARACTER (LEN = 12) FORM12, WORD12_ICOUNT, WORD12_DFU,
     +                     WORD12_DFD, WORD12_MAXR, WORD12_NZ
      CHARACTER (LEN = 13) D13(2), SHOWLJ
      CHARACTER  TEXT(30)*100
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ABORT, REPEET, RUNS_DOWN
      LOGICAL    FIXNPT
      PARAMETER (FIXNPT = .FALSE.)
      EXTERNAL   E_FORMATS, SHOWLJ
      EXTERNAL   G08EAF$
      EXTERNAL   PUTFAT, PLEVEL, PUTIFA, TABLE1, PUTADV, VECONE, CHOP80,
     +           LSTBOX, FORM12, PATCH2, GETJM1  
      INTRINSIC  NINT
      SAVE       ICOUNT, MAXR
      SAVE       RUNS_DOWN
      DATA       ICOUNT, MAXR / 0, 4 /
      DATA       RUNS_DOWN / .FALSE. /
      DATA       NUMBLD / 30*0 /
      E_NUMBERS = E_FORMATS()
C
C Adjust MAXR if NZ small or large 
C      
      IF (SUPPLY) THEN
         IF (NZ.LT.4000 .AND. MAXR.GT.4) THEN
            MAXR = 4
         ELSEIF (NZ.GT.10000 .AND. MAXR.LT.6) THEN
            MAXR = 6
         ENDIF
      ENDIF
C
C Initialise
C             
      NEW_DATA = .FALSE.
      WORD80 = CHOP80(TITLEZ)
      NUMDEC = NUMOPT - 1
C
C Main loop
C      
      REPEET = .TRUE.
      DO WHILE (REPEET)
        
         WORD12_MAXR = FORM12(MAXR)
         WORD12_NZ = FORM12(NZ)
         IF (RUNS_DOWN) THEN
            YESNO = '[Yes]'
         ELSE
            YESNO = '[No]'   
         ENDIF   
         WRITE (TEXT,100) WORD80, WORD12_MAXR, WORD12_NZ,YESNO 
         NUMBLD(1) = 4
         NUMBLD(4) = 1
         CALL LSTBOX (NUMBLD, NUMDEC, NUMOPT, NUMSTA, NUMTXT,
     +                TEXT)
         NUMBLD(1) = 0
         NUMBLD(4) = 0
         
         IF (NUMDEC.EQ.1) THEN
C
C NUMDEC = 1: Get new data
C
            IF (SUPPLY) THEN
               NEW_DATA = .TRUE.
               RETURN
            ELSE   
               CALL VECONE (NIN, NMAX, NZ, 
     +                      Z, 
     +                      TITLEZ,
     +                      ABORT, FIXNPT)
               IF (ABORT) RETURN
               WORD80 = CHOP80(TITLEZ)  
            ENDIF
         ELSEIF (NUMDEC.EQ.2) THEN     
               
C
C NUMDEC = 2: Check the data then calculate
C
            IF (NZ.LT.5*MAXR) THEN
               WRITE (LINE,200) 5*MAXR
               CALL PUTFAT (LINE)
               RETURN
            ENDIF
C
C Initialise NRUNS, CHIU, DFU, PROBU, etc. ... seems to prevent crashes
C
            CHIU = ZERO
            DFU = ZERO
            PROBU = ZERO
            NRUNS = 0
            DO I = 1, MAXR
               NCOUNT(I) = 0
               EX(I) = ZERO
            ENDDO
            IFAIL = 1
            CALL G08EAF$(CL, NZ, Z, M, MAXR, NRUNS, NCOUNT, EX, COV, 
     +                   LDCOV,
     +                   CHIU, DFU, PROBU, WRK, LWRK, IFAIL)
            IF (IFAIL.EQ.8) THEN
               WRITE (LINE,300) MAXR
               CALL PUTADV (LINE)
            ELSE
               CALL PUTIFA (IFAIL, NOUT, 'G08EAF/UPDOWN')
            ENDIF
            IF (IFAIL.NE.0.AND.IFAIL.LT.7) THEN
               RETURN
            ELSEIF (IFAIL.EQ.7) THEN
               WRITE (LINE,400)
               CALL PUTFAT (LINE)
               RETURN
            ELSEIF (IFAIL.EQ.9 .OR. DFU.LE.ZERO) THEN
               WRITE (LINE,500)
               CALL PUTFAT (LINE)
               RETURN
            ENDIF
C
C Adjust DFU if required 
C            
            J = NINT(DFU)
            IF (J.GE.MAXR) THEN
               DO I = MAXR, 1, -1
                  IF (NCOUNT(I).LE.0) THEN
                     DFU = DFU - ONE
                  ELSE
                     EXIT
                  ENDIF
               ENDDO   
            ENDIF       
            IF (RUNS_DOWN) THEN
C
C Now reverse the signs for a runs down test
C
               DO I = 1, NZ
                  Z(I) = - Z(I)
               ENDDO
C
C Initialise NRUNS, CHID, DFD, PROBD, etc. ... seems to prevent crashes
C
               CHID = ZERO
               DFD = ZERO
               PROBD = ZERO
               NRUNS = 0
               DO I = 1, MAXR
                  NCOUNT(I) = 0
                  EX(I) = ZERO
               ENDDO
               IFAIL = 1
               CALL G08EAF$(CL, NZ, Z, M, MAXR, NRUNS, NCOUNT, EX, COV,
     +                      LDCOV,
     +                      CHID, DFD, PROBD, WRK, LWRK, IFAIL)
      
               IF (IFAIL.EQ.8) THEN
                  WRITE (LINE,300) MAXR
                  CALL PUTADV (LINE)
               ELSE
                  CALL PUTIFA (IFAIL, NOUT, 'G08EAF/UPDOWN')
               ENDIF
               IF (IFAIL.EQ.9 .OR. DFD.LE.ZERO) THEN
                  WRITE (LINE,600)
                  CALL PUTFAT (LINE)
               ENDIF
C
C Adjust DFD if required
C     
               J = NINT(DFD)
               IF (J.GE.MAXR) THEN
                  DO I = MAXR, 1, -1
                     IF (NCOUNT(I).LE.0) THEN
                        DFD = DFD - ONE
                     ELSE
                        EXIT
                     ENDIF
                  ENDDO
               ENDIF                      
C
C Restore the original values
C
               DO I = 1, NZ
                  Z(I) = - Z(I)
               ENDDO
            ENDIF   
            IF (IFAIL.NE.0) RETURN
C
C Output the results
C
            CALL PLEVEL (PROBU, TYPEU)
            WORD12_NZ = FORM12(NZ)
            I = NINT(DFU)
            WORD12_DFU = FORM12(I)
            IF (RUNS_DOWN) THEN 
               CALL PLEVEL (PROBD, TYPED)
               I = NINT(DFD)
               WORD12_DFD = FORM12(I)
            ENDIF   
            ICOUNT = ICOUNT + 1
            WORD12_ICOUNT = FORM12(ICOUNT)
            WRITE (NOUT,'(A)') BLANK
            IF (RUNS_DOWN) THEN
               K = 11
               IF (E_NUMBERS) THEN
                  WRITE (NOUT,700) WORD12_ICOUNT, WORD80, WORD12_NZ,
     +                             CHIU,
     +                             WORD12_DFU, PROBU,
     +                             TYPEU, CHID, WORD12_DFD, PROBD, TYPED
                  WRITE (TEXT,700) WORD12_ICOUNT, WORD80, WORD12_NZ,
     +                             CHIU,
     +                             WORD12_DFU, PROBU,
     +                             TYPEU, CHID, WORD12_DFD, PROBD, TYPED
               ELSE
                  D13(1) = SHOWLJ(CHIU)
                  D13(2) = SHOWLJ(CHID)
                  WRITE (NOUT,750) WORD12_ICOUNT, WORD80, WORD12_NZ,
     +                             D13(1),
     +                             WORD12_DFU, PROBU,
     +                             TYPEU, D13(2), WORD12_DFD, PROBD,
     +                             TYPED
                  WRITE (TEXT,750) WORD12_ICOUNT, WORD80, WORD12_NZ,
     +                             D13(1),
     +                             WORD12_DFU, PROBU,
     +                             TYPEU, D13(2), WORD12_DFD, PROBD, 
     +                             TYPED
               ENDIF  
            ELSE
               K = 8
               IF (E_NUMBERS) THEN
                  WRITE (NOUT,800) WORD12_ICOUNT, WORD80, WORD12_NZ,
     +                             CHIU,
     +                             WORD12_DFU, PROBU,
     +                             TYPEU
                  WRITE (TEXT,800) WORD12_ICOUNT, WORD80, WORD12_NZ, 
     +                             CHIU,
     +                             WORD12_DFU, PROBU,
     +                             TYPEU
               ELSE
                  D13(1) = SHOWLJ(CHIU)
                  WRITE (NOUT,850) WORD12_ICOUNT, WORD80, WORD12_NZ,
     +                             D13(1),
     +                             WORD12_DFU, PROBU,
     +                             TYPEU
                  WRITE (TEXT,850) WORD12_ICOUNT, WORD80, WORD12_NZ, 
     +                             D13(1),
     +                             WORD12_DFU, PROBU,
     +                             TYPEU
               ENDIF  
            ENDIF
            J = 15
            CALL TABLE1 (J, 'OPEN')
            DO I = 1, K
               IF (I.EQ.1) THEN
                  J = 4
               ELSEIF (I.EQ.4) THEN
                  J = 1
               ELSE
                  J = 0
               ENDIF
               CALL TABLE1 (J, TEXT(I))
            ENDDO
            CALL TABLE1 (J, 'CLOSE')
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.3) THEN
C
C NUMDEC = 3: Change MAXR
C         
            I = 3
            J = LDCOV
            WRITE (LINE,900)
            CALL GETJM1 (I, MAXR, J,
     +                   LINE)
            NUMDEC = 2            
         ELSEIF (NUMDEC.EQ.4) THEN
C
C Do runs down
C         
            RUNS_DOWN = .NOT.RUNS_DOWN  
            NUMDEC = 2 
         ELSEIF (NUMDEC.EQ.5) THEN
C
C NUMDEC = 5: Help
C         
            WRITE (TEXT,1000)
            NUMBLD(1) = 1
            J = 22
            CALL PATCH2 (NUMBLD, J,
     +                   TEXT)     
            NUMBLD(1) = 0
            NUMDEC = 2       
         ELSE
C
C NUMDEC = 5: Exit
C           
            REPEET = .FALSE.
         ENDIF   
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'The runs up (or down) test for randomness'
     +/
     +/'Current data title is:'
     +/a
     +/
     +/'Current maximum run length MAXR =',1x,a
     +/
     +/'Current sample size n =',1x,a
     +/
     +/'Data: New/Edit/Transform/View'
     +/'Calculate'
     +/'Change MAXR'
     +/'Also test runs down',1X,A 
     +/'Help'
     +/'Quit ... Exit run test procedure')
  200 FORMAT ('Insufficient data for the test ... 5*MAXR =',I4)
  300 FORMAT (
     +'IFAIL = 8 from G08EAF/UPDOWN ... total length of runs <',I4)
  400 FORMAT ('There are ties in the sequence of observations')
  500 FORMAT ('The chi-sq. up-statistic cannot be calculated')
  600 FORMAT ('The chi-sq. down-statistic cannot be calculated')
  700 FORMAT (
     + 1X,'Runs-up (and runs-down) test number',1X,A
     +/
     +/1X,'Title of data'
     +/A
     +/1X,'Size of sample                      =',1X,A
     +/1X,'CU (chi-sq.stat. for runs up)       =',1P,E10.3
     +/1X,'Degrees of freedom                  =',1X,A
     +/1X,'p = P(chi-sq. >= CU) (upper tail p) =',0P,F7.4,3X,A
     +/1X,'CD (chi-sq.stat. for runs down)     =',1P,E10.3
     +/1X,'Degrees of freedom                  =',1X,A
     +/1X,'p = P(chi-sq. >= CD) (upper tail p) =',0P,F7.4,3X,A)
  750 FORMAT (
     + 1X,'Runs-up (and runs-down) test number',1X,A
     +/
     +/1X,'Title of data'
     +/A
     +/1X,'Size of sample                      =',1X,A
     +/1X,'CU (chi-sq.stat. for runs up)       =',1X,A
     +/1X,'Degrees of freedom                  =',1X,A
     +/1X,'p = P(chi-sq. >= CU) (upper tail p) =',F7.4,3X,A
     +/1X,'CD (chi-sq.stat. for runs down)     =',1X,A
     +/1X,'Degrees of freedom                  =',1X,A
     +/1X,'p = P(chi-sq. >= CD) (upper tail p) =',F7.4,3X,A)    
  800 FORMAT (
     + 1X,'Runs-up test number',1X,A
     +/
     +/1X,'Title of data'
     +/A
     +/1X,'Size of sample                      =',1X,A
     +/1X,'CU (chi-sq.stat. for runs up)       =',1P,E10.3
     +/1X,'Degrees of freedom                  =',1X,A
     +/1X,'p = P(chi-sq. >= CU) (upper tail p) =',0P,F7.4,3X,A)
  850 FORMAT (
     + 1X,'Runs-up test number',1X,A
     +/
     +/1X,'Title of data'
     +/A
     +/1X,'Size of sample                      =',1X,A
     +/1X,'CU (chi-sq.stat. for runs up)       =',1X,A
     +/1X,'Degrees of freedom                  =',1X,A
     +/1X,'p = P(chi-sq. >= CU) (upper tail p) =',F7.4,3X,A)     
  900 FORMAT ('The maximum run length required')     
 1000 FORMAT (
     + 'The runs up (or down) test for randomness'
     +/      
     +/'To define runs up consider the following sequence of numbers'
     +/'.2, .4, .45, .4, .15, .75, .95, .23, .27, .4, .25, .1, .34, .39,
     + .61, .12'
     +/'which has runs up of length 3, 1, 3, 3, 1, and 4.'
     +/
     +/'The runs up test is for examining randomness in a vector of'       
     +/'floating point numbers, such as when checking a random number'      
     +/'generator for presence of serial correlations. It will fail'      
     +/'if there are ties in the data, i.e. consecutive numbers are'      
     +/'equal because they are integers or are only stored with a'      
     +/'limited number of significant figures.'      
     +/      
     +/'The following points should be noted:' 
     +/     
     +/'1)`The sample size should be rather large, say n >= 4000.'
     +/'2)`Max. run length MAXR should be e.g. =< 4 for n =< 4000, or'       
     +/'  `=< 6 for n >= 10000, else chi-square bin counts may be low'       
     +/'  `and the chi-square test will be compromised. MAXR and DOF' 
     +/'  `are decreased temporarily if empty bins are encountered.'      
     +/'3)`Data sets can also analysed for runs down by temporarily'
     +/'  `reversing the signs.')                  
      END
C
C
