C
C      
      SUBROUTINE VAREQ0 (NIN, NOUT)
C
C ACTION: Call variance homogeneity routines
C AUTHOR: W. G. Bardsley, University of Manchester, U.K.
C         19/02/2009 derived from ANOVA0
C
C Note: NSAV = 1 corresponds to 1-way ANOVA for future development
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER     NIN, NOUT
C
C Locals
C
      INTEGER    ICOLOR, IXL, IYL, NUMOPT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, NUMOPT = 6)
      INTEGER    NDEC, NUMPOS(NUMOPT)
      INTEGER    NUMSAV, NUMTXT
      PARAMETER (NUMSAV = 9)
      INTEGER    NCSAV(NUMSAV), NRSAV(NUMSAV), NUMBLD(30)
      INTEGER    JSEND, NCOL, NF, NROW, NSAV
      CHARACTER  TEXT(30)*100
      CHARACTER  FNAME*1024, TITLE*80
      CHARACTER  FSAV(NUMSAV)*1024, TSAV(NUMSAV)*80
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    AGAIN
      LOGICAL    SUPPLY
      EXTERNAL   M_VAREQ1
      EXTERNAL   LBOX02, PATCH2
      SAVE       NCSAV, NRSAV
      SAVE       FSAV, TSAV
      DATA       NUMPOS / NUMOPT*1 /
      DATA       NUMBLD / 30*0 /
      DATA       NCSAV / 0, 0, 0, 0, 0, 0, 0, 0, 0 /
      DATA       NRSAV / 0, 0, 0, 0, 0, 0, 0, 0, 0 /
      DATA       FSAV  /  BLANK, BLANK, BLANK, BLANK, BLANK, BLANK,
     +                    BLANK, BLANK, BLANK /
      DATA       TSAV  /  BLANK, BLANK, BLANK, BLANK, BLANK, BLANK,
     +                    BLANK, BLANK, BLANK  /
C
C Initialise
C
      NF = NOUT
C
C Main loop
C
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
         WRITE (TEXT,100)
         NDEC = NUMOPT - 1
         CALL LBOX02 (ICOLOR, IXL, IYL, NDEC, NUMOPT, NUMPOS,
     +                TEXT)
C
C Define NSAV
C
         IF (NDEC.GE.1 .AND. NDEC.LE.3) THEN
            NSAV = 1
         ELSEIF (NDEC.GE.4 .AND. NDEC.LE.6) THEN
            NSAV = 2
         ELSEIF (NDEC.GE.7 .AND. NDEC.LE.11) THEN
            NSAV = NDEC - 4
         ELSE
            NSAV = 0
         ENDIF
C
C Define NCOL, NROW, FNAME, TITLE
C
         IF (NSAV.GE.1 .AND. NSAV.LE.NUMSAV) THEN
            NCOL = NCSAV(NSAV)
            NROW = NRSAV(NSAV)
            FNAME = FSAV(NSAV)
            TITLE = TSAV(NSAV)
         ELSE
            NCOL = 0
            NROW = 0
            FNAME = BLANK
            TITLE = BLANK
         ENDIF
C
C Call the variance equality routines
C
         IF (NDEC.GE.1 .AND. NDEC.LE.4) THEN
            JSEND = NDEC
            SUPPLY = .TRUE.
            CALL M_VAREQ1 (JSEND, NF, NIN,
     +                     SUPPLY)
            AGAIN = .FALSE.
         ELSEIF (NDEC.EQ.NUMOPT - 1) THEN
            WRITE (TEXT,200)
            NUMBLD(1) = 1
            NUMBLD(9) = 1
            NUMBLD(14) = 1
            NUMBLD(20) = 1
            NUMTXT = 22
            CALL PATCH2 (NUMBLD, NUMTXT,
     +                   TEXT)
            NUMBLD(1) = 0
            NUMBLD(9) = 0
            NUMBLD(14) = 0
            NUMBLD(20) = 0
         ELSEIF (NDEC.EQ.NUMOPT) THEN
            AGAIN = .FALSE.
         ENDIF
C
C Define NCSAV, NRSAV, FSAV, TSAV
C
         IF (AGAIN .AND. NSAV.GT.0 .AND.
     +       NCOL.GT.1 .AND. NROW .GT.1) THEN
            NCSAV(NSAV) = NCOL
            NRSAV(NSAV) = NROW
            FSAV(NSAV) = FNAME
            TSAV(NSAV) = TITLE
         ENDIF
      ENDDO
C
C Format statements
C
  100 FORMAT (
     + 'Bartlett'
     +/'Levene (median)'
     +/'Levene (mean)'
     +/'Levene (trimmed mean)'
     +/'Help'
     +/'Quit ... Exit testing for equality of variances')
  200 FORMAT (
     + 'Testing for Equality of Variances'
     +/
     +/'Some statistical procedures such as ANOVA depend upon normality'
     +/'and variance homogeneity. Often tranformations of data are used'
     +/'in the attempt to stabilise variance, so it makes sense to test'
     +/'data sets before ANOVA to see which transformations do lead to'
     +/'data sets that more closely conform to variance equality.'
     +/
     +/'Variance equality tests'
     +/'It is extremely difficult to obtain good variance estimates, as'
     +/'rather large samples are required. So variance equality tests'
     +/'have low power unless very large samples are available.'
     +/
     +/'Normal data'
     +/'If samples are normally distributed, a requirement for ANOVA'
     +/'anyway, the Bartlett test should be used. With two samples of'
     +/'equal size this is equivalent to the F test as done by Simfit'
     +/'when ANOVA for two samples (i.e., the t test) is performed.'
     +/
     +/'Arbitrary data'
     +/'The Levene test using the median should be used unless you can'
     +/'justify using the mean or trimmed mean.')
      END
C
C
