C
C
      SUBROUTINE VAREQ1 (JSEND, NCMAX, NF, NIN, NMAX, NOBS, NOMAX,
     +                   NRMAX, NSMALL,
     +                   A, B, X, Y,
     +                   FSAV, TSAV,
     +                   MATRIX, NEWDAT, SUPPLY, USE1)
C
C ACTION: Variance equality tests
C AUTHOR: W. G. Bardsley, University of Manchester, U.K.
C         19/02/2009 derived from ANOVA1
C         02/03/2009 added ALPHA and READY
C         21/03/2012 replaced EBPLOT$, BWPLOT$ by EBPLOT, BWPLOT
C         29/07/2021 added E_NUMBERS and E_FORMATS etc.
C
C The arguments depend on whether SUPPLY = .TRUE. as follows:
C  JSEND: (input/unchanged) input value for NTYPE
C  NCMAX: (input/unchanged) max. col. dimension for A depending on SUPPLY
C     NF: (input/unchanged) preconnected unit for results
C    NIN: (input/unchanged) unconnected unit for reading in data
C   NMAX: (input/unchanged) max. overall data size depending on SUPPLY
C   NOBS: (input/output) observations per column or file depending on SUPPLY
C  NOMAX: (input/unchanged) max. no. columns or files depending on SUPPLY
C  NRMAX: (input/unchanged) max. row dimension for A
C NSMALL: (input/unchanged) max. no. of vector files
C      A: (input/output) depending on SUPPLY
C      B: workspace...must have dimension >= size of data set
C   GBAR: workspace...must have dimension >= no. of columns/files
C      X: workspace...must have dimension >= size of data set
C      Y: workspace...mjust have dimension >= size of data set
C   FSAV: (input/output) vector file names depending on SUPPLY
C   TSAV: (input/output) vector file titles depending on SUPPLY
C NEWDAT: (output) used to request another data set
C MATRIX: (input/output) depending on SUPPLY
C SUPPLY: (input/unchanged) as follows:
C   USE1: workspace
C
C Note: When SUPPLY = .TRUE. and MATRIX = .TRUE.
C       ========================================
C       Data matrix A is supplied with NOMAX >= NCOL and NMAX >= NCOL*NROW
C       but only FSAV(1) and TSAV(1) are referenced so NSMALL > = 1
C       Also all NOBS(i) = NROW
C       When SUPPLY = .TRUE. and MATRIX = .FALSE.
C       =========================================
C       FSAV, TSAV, and NOBS, are supplied so NOMAX >= NSMALL > 1
C       A is not referenced so MAX >= 1, and NCMAX >= 1
C       The NOBS(i) must equal the individual file sizes and
C       NMAX >= sum of all NOBS(i)
C       Other cases
C       ===========
C       Data can be read in interactively as a matrix or vector files
C       so preferably NCMAX = NSMALL = NOMAX >> 1, NRMAX >>1, and
C       NMAX >= NCMAX*NRMAX
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    NCMAX, NMAX, NOMAX, NRMAX, NSMALL
      INTEGER    JSEND, NF, NIN, NOBS(NOMAX)
      DOUBLE PRECISION A(NRMAX,NCMAX), B(NMAX), X(NMAX), Y(NMAX)
      CHARACTER  FSAV(NSMALL)*(*), TSAV(NSMALL)*(*)
      LOGICAL    MATRIX, NEWDAT, SUPPLY, USE1(NOMAX)
C
C Local allocatable arrays
C
      INTEGER, ALLOCATABLE :: NSORT(:)
      CHARACTER (LEN = 4), ALLOCATABLE :: LTEMP(:)
      CHARACTER (LEN = 6), ALLOCATABLE :: COLUMN(:)
C
C Locals
C
      INTEGER    NCOL, NFILES, NROW
      INTEGER    I, IERR, ISEND, J, JTYPE, IFAIL, N, K, L
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NOPT, NSTART, NUMTXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 0)
      INTEGER    NDEC, NUMBLD(30), NUMPOS(20)
      INTEGER    ICOUNT, NTYPE
      INTEGER    IPREV, ITYPE, NBIG, NOUT1, NTEMP, NTOP
      PARAMETER (ITYPE = 2)
      INTEGER    N0, N1, N2, N3, N5
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N5 = 5)
      DOUBLE PRECISION BART_B, BART_BC, BART_C
      DOUBLE PRECISION DOF, DOF1, DOF2, P_VALUE, UPPER_1, UPPER_5
      DOUBLE PRECISION ONE, TWO, F100, PNT95, PNT99
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, F100 = 100.0D+00,
     +           PNT95 = 0.95D+00, PNT99 = 0.99D+00)
      DOUBLE PRECISION AFACT, AMAX, AMIN
      PARAMETER (AFACT = 100.0D+00, AMAX = 40.0D+00, AMIN = 1.0D+00)     
      DOUBLE PRECISION ALPHA, EPSI, F, FP, W
      DOUBLE PRECISION G01CEF$, RTOL, X02AMF$, XTOL, ZTOL, X02AJF$
      DOUBLE PRECISION G01ECF$, G01FCF$, G01EDF$, G01FDF$
      CHARACTER (LEN = 12) I12(2), FORM12
      CHARACTER (LEN = 13) D13(5), SHOWLJ 
      CHARACTER  FNAME*1024, TITLE*80, TYPE1*30, WORD6*6
      CHARACTER  BANDW*20, WORD60*60, SYMBOL*40, TEXT(30)*100
      CHARACTER  CHOP80*80, TRIM80*80
      CHARACTER  LINE*100, TTEMP(4)*20
      CHARACTER  BLANK*1, INFO*40
      PARAMETER (BLANK = ' ',
     +           INFO = 'Tick columns required')
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    TAB_BOT, TAB_MID, TAB_TOP
      PARAMETER (TAB_TOP = .TRUE., TAB_MID = .TRUE., TAB_BOT = .TRUE.)
      LOGICAL    FIXCOL, FIXROW, LABEL
      PARAMETER (FIXCOL = .FALSE., FIXROW = .FALSE., LABEL = .TRUE.)
      LOGICAL    ABORT, AGAIN, LIBFIL, OK, PROJ, READY
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   PUTFAT, PUTIFA, MATTIN, TBOX01, TABLE1, TRIML1, GETNOU,
     +           VECFIL, PFILES, CHKBOX, CHOP80, TRIM80, ISITMF, VAREQ2,
     +           PLEVEL, VAREQ3, GETDM1
      EXTERNAL   BWPLOT, GKS001, EBPLOT, BWPLUS
      EXTERNAL   G01CEF$, X02AMF$, X02AJF$
      EXTERNAL   G01ECF$, G01FCF$, G01EDF$, G01FDF$
      INTRINSIC  SQRT, LOG, ASIN, DBLE, MIN, MAX
      SAVE       ICOUNT, NTYPE
      SAVE       ALPHA
      DATA       ICOUNT, NTYPE / 0, 1 /
      DATA       ALPHA / 0.05D+00 /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 20*1 /
C
C Initialise NEWDAT and check if SUPPLY = .true.
C
      NEWDAT = .FALSE.
      IF (NCMAX.LT.N1 .OR. NOMAX.LT.N1 .OR. NRMAX.LT.N1 .OR.
     +    NSMALL.LT.N1 .OR. NMAX.LT.N3) RETURN
      IF (SUPPLY) THEN
         IF (MATRIX) THEN
            FNAME = FSAV(1)
            CALL ISITMF (NCOL, NROW,
     +                   FNAME)
            IF (NCOL.LT.N2 .OR. NROW.LT.N2 .OR. NROW.GT.NRMAX .OR.
     +          NCOL.GT.NOMAX .OR. NCOL*NROW.GT.NMAX) RETURN
            NFILES = NCOL
            TITLE = TSAV(1)
         ELSE
            IF (NSMALL.LT.N2 .OR. NSMALL.GT.NOMAX) RETURN
            NFILES = NSMALL
         ENDIF
         NDEC = N3
      ELSE
         NFILES = N0
         NDEC = N1
      ENDIF
C
C Allocate
C
      IERR = N0
      IF (ALLOCATED(NSORT)) DEALLOCATE(NSORT, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(LTEMP)) DEALLOCATE(LTEMP, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(COLUMN)) DEALLOCATE(COLUMN, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      NBIG = MAX(NCMAX,NSMALL)
      NTEMP = NBIG
      ALLOCATE(NSORT(NBIG), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE(LTEMP(NTEMP), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE(COLUMN(NBIG), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      DO I = N1, NTEMP
         WRITE (COLUMN(I),'(I6)') I
      ENDDO
C
C Check value of JSEND
C
      IF (JSEND.GE.1 .AND. JSEND.LE.4) NTYPE = JSEND
C
C Initialise (Note: in this version NTEMP = NSMALL...may change in future)
C
      DO I = N1, NOMAX
         USE1(I) = .TRUE.
      ENDDO
      IPREV = N0
      RTOL = 1.0D+09*X02AMF$()
      EPSI = 1.0D+01*X02AJF$()
      XTOL = ONE - EPSI
      ZTOL = ONE/RTOL
      NTOP = MIN(NTEMP,NSMALL)
      OK = .FALSE.
      READY = .FALSE.
      BANDW = '(NA)'
      E_NUMBERS = E_FORMATS()
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
C
C Main menu
C
         IF (READY) THEN
            WRITE (BANDW,'(I3,2X,A)') K, 'columns'
            CALL TRIML1 (BANDW)
         ELSE
            BANDW = '(NA)'
         ENDIF
         IF (NTYPE.EQ.1) THEN
            TYPE1 = 'Bartlett'
         ELSEIF (NTYPE.EQ.2) THEN
            TYPE1 = 'Levene (median)'
         ELSEIF (NTYPE.EQ.3) THEN
            TYPE1 = 'Levene (mean)'   
         ELSE
            WRITE (TYPE1,'(A,F5.2,A)') 'Levene (', AFACT*ALPHA,
     +                                 '% trimmed mean)' 
         ENDIF
         WRITE (TEXT,100) BANDW, BANDW, BANDW, BANDW, TYPE1, AFACT*ALPHA
         NOPT = 18
         NSTART = 7
         NUMTXT = NOPT + NSTART - 1
         NUMBLD(1) = 1
         CALL TBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NOPT,
     +                NUMPOS, NSTART, NUMTXT,
     +                TEXT,
     +                TAB_TOP, TAB_MID, TAB_BOT)
         NUMBLD(1) = 0
C
C Check if consistent or return requested
C
         IF (NDEC.GT.1 .AND. NDEC.LT.NOPT .AND. NFILES.LT.N2) THEN
            CALL PUTFAT ('First input your current data')
            NDEC = N1
            OK = .FALSE.
            READY = .FALSE.
         ELSEIF (NDEC.EQ.1) THEN
C
C NDEC = 1: Data input ... First find out input type required
C =========
C
            IF (SUPPLY) THEN
               NEWDAT = .TRUE.
               DEALLOCATE(NSORT, STAT = IERR)
               DEALLOCATE(LTEMP, STAT = IERR)
               DEALLOCATE(COLUMN, STAT = IERR)
               RETURN
            ENDIF
            OK = .FALSE.
            READY = .FALSE.
            NOPT = 4
            NDEC = NOPT - 1
            NSTART = 7
            NUMTXT = NSTART + NOPT - 1
            WRITE (TEXT,200)
            NUMBLD(1) = 4
            CALL TBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NOPT,
     +                   NUMPOS, NSTART, NUMTXT,
     +                   TEXT,
     +                   TAB_TOP, TAB_MID, TAB_BOT)
            NUMBLD(1) = 0
            IF (NDEC.EQ.1) THEN
               IPREV = N0
               MATRIX = .TRUE.
               LIBFIL = .FALSE.
               PROJ = .FALSE.
            ELSEIF (NDEC.EQ.2) THEN
               MATRIX = .FALSE.
               LIBFIL = .FALSE.
               PROJ = .FALSE.
            ELSEIF (NDEC.EQ.3) THEN
               MATRIX = .FALSE.
               LIBFIL = .TRUE.
               PROJ = .FALSE.
            ELSE
               MATRIX = .FALSE.
               LIBFIL = .FALSE.
               PROJ = .TRUE.
            ENDIF
            IF (MATRIX) THEN
C
C Read in a data matrix
C
               ISEND = N0
               CLOSE (UNIT = NIN)
               FNAME = 'Data typed in interactively'
               CALL MATTIN (ISEND, NCMAX, NCOL, NIN, NRMAX, NROW,
     +                      A, B,
     +                      FNAME, TITLE,
     +                      ABORT, FIXCOL, FIXROW, LABEL)
               CLOSE (UNIT = NIN)
               IF (ABORT) NCOL = N0
               IF (NCOL.LT.N2) NCOL = N0
               NFILES = MIN(NCOL,NTOP)
               IF (NCOL.GE.N2) THEN
                  DO I = N1, NFILES
                     NOBS(I) = NROW
                  ENDDO
               ENDIF
            ELSEIF (.NOT.PROJ) THEN
C
C Read in files
C
               CALL VECFIL (NFILES, NIN, NMAX, NTOP,
     +                      X,
     +                      FSAV, TSAV,
     +                      ABORT, LIBFIL)
               IF (NFILES.LT.N2) NFILES = N0
               IF (.NOT.ABORT .AND. NFILES.GT.N1) THEN
                  DO I = N1, NFILES
                     USE1(I) = .TRUE.
                 ENDDO
               ENDIF
            ELSEIF (PROJ) THEN
C
C Project archive
C
               CALL GETNOU (NOUT1)
               CLOSE (UNIT = NOUT1)
               CALL PFILES (IPREV, ITYPE, NFILES, NIN, NTOP, NOUT1,
     +                      FSAV,
     +                      USE1)
               CLOSE (UNIT = NOUT1)
               IF (NFILES.GT.N1) THEN
                  ABORT = .FALSE.
                  DO I = N1, NFILES
                     USE1(I) = .TRUE.
                  ENDDO
               ELSE
                  ABORT = .TRUE.
                  NFILES = N0
               ENDIF
            ENDIF
            IF (ABORT .OR. NFILES.LT.N2) THEN
               NDEC = 1
            ELSE
               NDEC = 3
            ENDIF
            IF (NFILES.LT.N2) CALL PUTFAT (
     +         'Must have at least 2 columns')
         ELSEIF (NDEC.EQ.2) THEN
C
C Add/delete data columns
C

            READY = .FALSE.
            OK = .TRUE.
            DO WHILE (OK)
               CALL CHKBOX (NFILES,
     +                      COLUMN, INFO,
     +                      USE1)
               J = N0
               DO I = N1, NFILES
                  IF (USE1(I)) J = J + N1
               ENDDO
               IF (J.LT.N2) THEN
                  CALL PUTFAT ('Must have at least 2 columns')
                  OK = .TRUE.
               ELSE
                  OK = .FALSE.
               ENDIF
            ENDDO
            NDEC = 3
         ELSEIF (NDEC.LT.12) THEN
C
C 1 < NDEC < 12: Do ANOVA
C ==============
C
            OK = .TRUE.
            N = N0
            K = N0
            DO I = N1, NFILES
               IF (OK .AND. USE1(I)) THEN
                  K = K + N1
                  IF (.NOT.MATRIX) THEN
                     CLOSE (UNIT = NIN)
                     OPEN (UNIT = NIN, FILE = FSAV(I))
                     READ (NIN,'(A)') TITLE
                     READ (NIN,*) NOBS(K), J
                  ENDIF
                  NSORT(K) = I
                  DO J = N1, NOBS(K)
                     IF (N.LT.NMAX) THEN
                        N = N + N1
                     ELSE
                        CALL PUTFAT ('Sample size is too large')
                        DEALLOCATE(LTEMP, STAT = IERR)
                        RETURN
                     ENDIF
                     IF (MATRIX) THEN
                        Y(N) = A(J,I)
                     ELSE
                        READ (NIN,*) Y(N)
                     ENDIF
                     IF (NDEC.GT.3) THEN
C
C Variance stabilising transformation requested
C
                        IF (Y(N).GT.RTOL) THEN
                           IF (NDEC.EQ.4) THEN
                              Y(N) = LOG(Y(N))
                           ELSEIF (NDEC.EQ.5) THEN
                              Y(N) = SQRT(Y(N))
                           ELSEIF (NDEC.LE.8) THEN
                              F = Y(N)/F100
                              IF (F.LE.EPSI .OR. F.GE.XTOL) THEN
                                 CALL PUTFAT ('x out of range for % ?')
                                 NDEC = N1
                                 OK = .FALSE.
                              ENDIF
                              IF (OK .AND. NDEC.EQ.6) THEN
                                 Y(N) = ASIN(SQRT(F))
                              ELSEIF (OK .AND. NDEC.EQ.7) THEN
                                 FP = F/(ONE - F)
                                 IF (FP.LE.RTOL .OR. FP.GE.ZTOL) THEN
                                    CALL PUTFAT (
     +                                   'x out of range for % ?')
                                    NDEC = N1
                                    OK = .FALSE.
                                 ELSEIF (OK) THEN
                                    Y(N) = LOG(FP)
                                 ENDIF
                              ELSEIF (OK) THEN
                                 IFAIL = N1
                                 Y(N) = G01CEF$(F, IFAIL)
                                 CALL PUTIFA (IFAIL, NF,
     +                                       'G01CEF/ANOVA1')
                                 IF (IFAIL.NE.N0) OK = .FALSE.
                              ENDIF
                           ELSE
                              F = Y(N)
                              IF (F.LE.EPSI .OR. F.GE.XTOL) THEN
                                 CALL PUTFAT ('x out of range for p ?')
                                 NDEC = N1
                                 OK = .FALSE.
                              ENDIF
                              IF (OK .AND. NDEC.EQ.9) THEN
                                 Y(N) = ASIN(SQRT(F))
                              ELSEIF (OK .AND. NDEC.EQ.10) THEN
                                 FP = F/(ONE - F)
                                 IF (FP.LE.RTOL .OR. FP.GE.ZTOL) THEN
                                    CALL PUTFAT (
     +                                   'x out of range for p ?')
                                    NDEC = N1
                                    OK = .FALSE.
                                 ELSEIF (OK) THEN
                                    Y(N) = LOG(FP)
                                 ENDIF
                              ELSEIF (OK) THEN
                                 IFAIL = N1
                                 Y(N) = G01CEF$(F, IFAIL)
                                 CALL PUTIFA (IFAIL, NF,
     +                                       'G01CEF/ANOVA1')
                                 IF (IFAIL.NE.N0) OK = .FALSE.
                              ENDIF
                           ENDIF
                        ELSE
                           CALL PUTFAT (
     +                    'x-value too small for transform')
                           NDEC = N1
                           OK = .FALSE.
                        ENDIF
                     ENDIF
                  ENDDO
               ENDIF
            ENDDO
            CLOSE (UNIT = NIN)
            WORD60 = 'x (untransformed data)'
            IF (OK) THEN
               IF (NDEC.EQ.4) THEN
                  WORD60 = 'log(x)'
               ELSEIF (NDEC.EQ.5) THEN
                  WORD60 = 'sqrt(x)'
               ELSEIF (NDEC.EQ.6) THEN
                  WORD60 = 'arcsin[sqrt(x/100)]'
               ELSEIF (NDEC.EQ.7) THEN
                  WORD60 = 'log[x/(100 - x)]'
               ELSEIF (NDEC.EQ.8) THEN
                  WORD60 = 'Phi_inverse(x/100)'
               ELSEIF (NDEC.EQ.9) THEN
                  WORD60 = 'arcsin[sqrt(x)]'
               ELSEIF (NDEC.EQ.10) THEN
                  WORD60 = 'log[x/(1 - x)]'
               ELSEIF (NDEC.EQ.11) THEN
                  WORD60 = 'Phi_inverse(x)'
               ENDIF
C
C Output the results
C
               IF (K.GT.N0) THEN
                  WRITE (NF,300) BLANK
                  WRITE (NF,300) '***'
                  WRITE (NF,300) BLANK
                  WRITE (NF,300)
     +'Data supplied to test for equality of variance'
                  WRITE (NF,300)
     +'----------------------------------------------'
                  IF (MATRIX) THEN
                     WRITE (NF,300) TRIM80(FNAME)
                     WRITE (NF,300) CHOP80(TITLE)
                     DO I = N1, NFILES
                        IF (.NOT.USE1(I)) THEN
                           WRITE (WORD6,'(I6)') I
                           CALL TRIML1 (WORD6)
                           WRITE (NF,'(1X,A,1X,A)')
     +                     '*suppressed column', WORD6
                        ENDIF
                     ENDDO
                  ELSE
                     IF (NFILES.LE.20) THEN
                        DO I = N1, NFILES
                           IF (USE1(I)) THEN
                              WRITE (NF,300) TRIM80(FSAV(I))
                           ELSE
                              WRITE (NF,'(1X,A)') '*file suppressed'                        
                           ENDIF
                        ENDDO
                     ELSE
                        DO I = N1, NFILES
                           IF (.NOT.USE1(I)) THEN
                              WRITE (WORD6,'(I6)') I
                              CALL TRIML1 (WORD6)
                              WRITE (NF,'(1X,A,1X,A)')
     +                        '*suppressed file', WORD6
                           ENDIF
                        ENDDO
                     ENDIF
                  ENDIF
                  IF (NTYPE.EQ.1) THEN
C
C Do the Bartlett test
C                    
                     IFAIL = N1
                     READY = .FALSE.
                     CALL VAREQ2 (IFAIL, K, N, NOBS,
     +                            BART_B, BART_BC, BART_C, Y)
                     IF (IFAIL.EQ.0) THEN
                        ABORT = .FALSE.
                        READY = .TRUE.
                     ELSE
                        ABORT = .TRUE.
                     ENDIF        
                  ELSEIF (NTYPE.LE.4) THEN
C
C Do the Levene test
C                  
                     IFAIL = N1
                     JTYPE = NTYPE - N1
                     READY = .FALSE.
                     CALL VAREQ3 (IFAIL, JTYPE, K, N, NOBS,
     +                            ALPHA, W, Y) 
                     IF (IFAIL.EQ.0) THEN
                        ABORT = .FALSE.
                        READY = .TRUE.
                     ELSE
                        ABORT = .TRUE.
                     ENDIF                           
                  ENDIF
                  IF (.NOT.ABORT) THEN 
                    ICOUNT = ICOUNT + N1
                    READY = .TRUE.
                     IF (NTYPE.EQ.1) THEN
                        DOF = DBLE(K - 1)
                        IFAIL = N1
                        P_VALUE = G01ECF$('U', BART_BC, DOF, IFAIL)
                        CALL PLEVEL (P_VALUE,
     +                               SYMBOL)                     
                        CALL PUTIFA (IFAIL, NF, 'G01ECF/VAREQ1')
                        UPPER_1 = G01FCF$(PNT99, DOF, IFAIL)
                        CALL PUTIFA (IFAIL, NF, 'G01FCF/VAREQ1')
                        UPPER_5 = G01FCF$(PNT95, DOF, IFAIL)
                        CALL PUTIFA (IFAIL, NF, 'G01FCF/VAREQ1')
                        WRITE (NF,'(A)') BLANK
                        IF (E_NUMBERS) THEN
                           WRITE (NF,400) ICOUNT, TYPE1, WORD60,
     +                                    BART_B,  BART_C, BART_BC,
     +                                    K - 1, P_VALUE,
     +                                    SYMBOL, UPPER_1, UPPER_5 
                           WRITE (TEXT,400) ICOUNT, TYPE1, WORD60,
     +                                      BART_B, BART_C, BART_BC,
     +                                      K - 1,  P_VALUE,
     +                                      SYMBOL, UPPER_1, UPPER_5  
                        ELSE
                           I12(1) = FORM12(K - 1) 
                           D13(1) = SHOWLJ(BART_B)
                           D13(2) = SHOWLJ(BART_C)
                           D13(3) = SHOWLJ(BART_BC) 
                           D13(4) = SHOWLJ(UPPER_1)
                           D13(5) = SHOWLJ(UPPER_5)
                           WRITE (NF,450) ICOUNT, TYPE1, WORD60,
     +                                    D13(1),  D13(2), D13(3),
     +                                    I12(1), P_VALUE,
     +                                    SYMBOL, D13(4), D13(5) 
                           WRITE (TEXT,450) ICOUNT, TYPE1, WORD60,
     +                                      D13(1),  D13(2), D13(3),
     +                                      I12(1), P_VALUE,
     +                                      SYMBOL, D13(4), D13(5)                            
                        ENDIF  
                        NUMTXT = 9
                     ELSE
                        DOF1 = DBLE(K - N1)
                        DOF2 = DBLE(N - K)
                        IFAIL = N1
                        P_VALUE = G01EDF$('U', W, DOF1, DOF2, IFAIL)  
                        CALL PLEVEL (P_VALUE,
     +                               SYMBOL)                     
                        CALL PUTIFA (IFAIL, NF, 'G01EDF/VAREQ1')
                        UPPER_1 = G01FDF$(PNT99, DOF1, DOF2, IFAIL)
                        CALL PUTIFA (IFAIL, NF, 'G01FDF/VAREQ1')
                        UPPER_5 = G01FDF$(PNT95, DOF1, DOF2, IFAIL)
                        CALL PUTIFA (IFAIL, NF, 'G01FDF/VAREQ1') 
                        WRITE (NF,'(A)') BLANK
                        IF (E_NUMBERS) THEN
                           WRITE (NF,500) ICOUNT, TYPE1, WORD60, W, 
     +                                    K - 1, N - K, P_VALUE, SYMBOL,
     +                                    UPPER_1, UPPER_5 
                           WRITE (TEXT,500) ICOUNT, TYPE1, WORD60, W, 
     +                                      K - 1, N - K, P_VALUE, 
     +                                      SYMBOL, UPPER_1, UPPER_5  
                        ELSE
                           I12(1) = FORM12(K - 1)
                           I12(2) = FORM12(N - K)
                           D13(1) = SHOWLJ(W)
                           D13(2) = SHOWLJ(UPPER_1)
                           D13(3) = SHOWLJ(UPPER_5)
                           WRITE (NF,550) ICOUNT, TYPE1, WORD60, D13(1), 
     +                                    I12(1), I12(2),
     +                                    P_VALUE, SYMBOL,
     +                                    D13(2), D13(3) 
                           WRITE (TEXT,550) ICOUNT, TYPE1, WORD60, 
     +                                      D13(1), 
     +                                      I12(1), I12(2),
     +                                      P_VALUE, SYMBOL,
     +                                      D13(2), D13(3) 
                        ENDIF  
                        NUMTXT = 8
                     ENDIF

                  
                     J = 15
                     CALL TABLE1 (J, 'OPEN')
                     DO I = N1, NUMTXT
                        IF (I.EQ.1) THEN
                           J = 4
                        ELSE
                           J = 0
                        ENDIF
                        CALL TABLE1 (J, TEXT(I))
                     ENDDO
                     CALL TABLE1 (J, 'CLOSE')
                  ENDIF
               ELSE
                  READY = .FALSE.
                  WRITE (WORD60,700) IFAIL
                  CALL PUTFAT (WORD60)
               ENDIF
            ENDIF
            NDEC = 3
         ELSEIF (NDEC.EQ.12) THEN
C
C NDEC = 12: Box and whisker plot
C ==========
C
            IF (OK .AND. READY) THEN
               J = N0
               DO I = N1, NFILES
                  IF (USE1(I)) THEN
                     J = J + N1
                     WRITE (LTEMP(J),'(I4)') I
                  ENDIF
              ENDDO
C
C NOTE: 'Box and Whisker Plot' is the title required by GKSF2B$ to interpret
C        the data as a Box and Whisker Plot and MUST NOT be altered
C        In Spanish TTEMP(1) = 'Diagrama be Whiskers'
C        The other TEMP values are arbitrary
C
               TTEMP(1) = 'Box and Whisker Plot'
               TTEMP(2) = 'Columns'
               TTEMP(3) = 'Medians'
               TTEMP(4) = ' '
               ISEND = 2
               CALL BWPLOT (ISEND, NOBS, K, N,
     +                      Y,
     +                      LTEMP, TTEMP)
            ELSE
               CALL PUTFAT ('First do variance equality test')
            ENDIF
         ELSEIF (NDEC.EQ.13) THEN
C
C NDEC = 13: Box and whisker plot
C ==========
C
            IF (OK .AND. READY) THEN
               J = N0
               DO I = N1, NFILES
                  IF (USE1(I)) THEN
                     J = J + N1
                     WRITE (LTEMP(J),'(I4)') I
                  ENDIF
              ENDDO
C
C NOTE: 'Box and Whisker Plot' is the title required by GKSF2B$ to interpret
C        the data as a Box and Whisker Plot and MUST NOT be altered
C        In Spanish TTEMP(1) = 'Diagrama be Whiskers'
C        The other TEMP values are arbitrary
C
               TTEMP(1) = 'Box and Whisker Plot'
               TTEMP(2) = 'Columns'
               TTEMP(3) = 'Medians'
               TTEMP(4) = ' '
               ISEND = 2
               CALL BWPLUS (ISEND, NOBS, K, N,
     +                      Y,
     +                      LTEMP, TTEMP)
            ELSE
               CALL PUTFAT ('First do variance equality test')
            ENDIF            
         ELSEIF (NDEC.EQ.14) THEN
C
C NDEC = 14: Barchart errorbar plot
C ==========
C
            IF (OK .AND. READY) THEN
               J = N0
               DO I = N1, NFILES
                  IF (USE1(I)) THEN
                     J = J + N1
                     WRITE (LTEMP(J),'(I4)') I
                  ENDIF
              ENDDO
C
C NOTE: 'Barchart & Errorbars' is the title required by GKSF2B$ to interpret
C        the data as a Barchart & Errorbars and MUST NOT be altered
C        In Spanish TTEMP(1) = 'Diagrama be Barras'
C        The other TEMP values are arbitrary
C
               TTEMP(1) = 'Barchart & Errorbars'
               TTEMP(2) = 'Columns'
               TTEMP(3) = 'Means'
               TTEMP(4) = ' '
               ISEND = 2
               CALL EBPLOT (ISEND, NOBS, K, N,
     +                      Y,
     +                      LTEMP, TTEMP)
            ELSE
               CALL PUTFAT ('First do variance equality test')
            ENDIF
         ELSEIF (NDEC.EQ.15) THEN
C
C NDEC = 15: Scatter plot
C ==========
C
            IF (OK .AND. READY) THEN
               L = N0
               DO I = N1, NFILES
                  IF (USE1(I)) THEN
                     DO J = N1, NOBS(I)
                        L = L + N1
                        B(L) = DBLE(I)
                     ENDDO
                  ENDIF
               ENDDO
               CALL GKS001 (N0, N5, N,
     +                      B, Y,
     +                     'Scatter Plot', 'Columns', 'Values')
            ELSE
               CALL PUTFAT ('First do variance equality test')
            ENDIF
 
         ELSEIF (NDEC.EQ.NOPT - 2) THEN
C
C NDEC = NOPT - 2: Change type
C =====================
C
            NOPT = 4
            NSTART = 3
            NUMTXT = NOPT + NSTART - 1
            WRITE (TEXT,800) AFACT*ALPHA
            CALL TBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NTYPE, NOPT,
     +                   NUMPOS, NSTART, NUMTXT,
     +                   TEXT,
     +                   TAB_TOP, TAB_MID, TAB_BOT)
            READY = .FALSE.
            OK = .FALSE.
            NDEC = 3
         ELSEIF (NDEC.EQ.NOPT - 1) THEN   
C
C NDEC = 15: Change alpha
C ========== 
C
            ALPHA = AFACT*ALPHA
            WRITE (LINE,900) ALPHA, TWO*ALPHA             
            CALL GETDM1 (AMIN, ALPHA, AMAX,
     +                   LINE)
            ALPHA = ALPHA/AFACT
            NDEC = 3
         ELSEIF (NDEC.EQ.NOPT) THEN
C
C NDEC = NOPT: Quit
C ============
C
            NEWDAT = .FALSE.
            AGAIN = .FALSE.
         ENDIF
      ENDDO
C
C Deallocate
C
      DEALLOCATE(NSORT, STAT = IERR)
      DEALLOCATE(LTEMP, STAT = IERR)
      DEALLOCATE(COLUMN, STAT = IERR)
C
C Format statements
C
  100 FORMAT (
     + 'Variance Equality tests'
     +/
     +/'Use data untransformed and only use the variance stabilisation'
     +/'if you have good reasons to do so, and know what you are doing.'
     +/'Note: log is to base e and x can be a percentage or proportion.'
     +/
     +/'Input new variance Equality data'
     +/'Suppress/Restore columns'
     +/'Test Variance Equality: x (original data)'
     +/'Test Variance Equality: log(x))'
     +/'Test Variance Equality: sqrt(x)'
     +/'Test Variance Equality: arcsin(sqrt(x/100))`(0 < x < 100)'
     +/'Test Variance Equality: log(x/(100 - x))   `(0 < x < 100)'
     +/'Test Variance Equality: Phi_inverse(x/100))`(0 < x < 100)'
     +/'Test Variance Equality: arcsin(sqrt(x))    `(0 < x < 1)'
     +/'Test Variance Equality: log(x/(1 - x))     `(0 < x < 1)'
     +/'Test Variance Equality: Phi_inverse(x)     `(0 < x < 1)'
     +/'Plot as boxes and whiskers (only)          `',A
     +/'Plot as boxes and whiskers (plus data)     `',A
     +/'Plot as bars and error-bars                `',A
     +/'Plot as scattered data                     `',A
     +/'Change test type                           `current =',1X,A
     +/'Change Levene % trimmed                    `current =',F6.2,'%'
     +/'Quit variance equality testing             `Exit')
  200 FORMAT (
     + 'Methods for supplying multiple samples'
     +/
     +/'Data can be supplied as a matrix, as individual column'
     +/'vectors, from a library file, or by using multiple file'
     +/'selection from a vector file project archive.'
     +/
     +/'Input data in matrix form'
     +/'Input individual column vectors'
     +/'Read in from a library file'
     +/'Select from a project archive')
  300 FORMAT (A)
  400 FORMAT (
     + 'Homogeneity of variance test',I4,':',1X,A 
     +/'          Transformation =',1X,A
     +/'                       B =',1P,E13.5
     +/'                       C =',   E13.5
     +/'                     B/C =',   E13.5
     +/'                    NDOF =',I8
     +/'p = P(chi-square >= B/C) =',0P,F8.4,2X,A
     +/'     Upper tail 1% point =',1P,E13.5
     +/'     Upper tail 5% point =',   E13.5)
  450 FORMAT (
     + 'Homogeneity of variance test',I4,':',1X,A 
     +/'          Transformation =',1X,A
     +/'                       B =',1X,A
     +/'                       C =',1X,A
     +/'                     B/C =',1X,A
     +/'                    NDOF =',1X,A
     +/'p = P(chi-square >= B/C) =',F7.4,2X,A
     +/'     Upper tail 1% point =',1X,A
     +/'     Upper tail 5% point =',1X,A)     
  500 FORMAT (
     + 'Homogeneity of variance test',I4,':',1X,A 
     +/'     Transformation =',1X,A
     +/'                  W =',1P,E13.5
     +/'               DOF1 =',I8
     +/'               DOF2 =',I8
     +/'      p = P(F >= W) =',0P,F8.4,2X,A
     +/'Upper tail 1% point =',1P,E13.5
     +/'Upper tail 5% point =',   E13.5)	     	
  550 FORMAT (
     + 'Homogeneity of variance test',I4,':',1X,A 
     +/'     Transformation =',1X,A
     +/'                  W =',1X,A
     +/'               DOF1 =',1X,A
     +/'               DOF2 =',1X,A
     +/'      p = P(F >= W) =',F7.4,2X,A
     +/'Upper tail 1% point =',1X,A
     +/'Upper tail 5% point =',1X,A)	     	     
  700 FORMAT ('Failure: IFAIL =',I4)   
  800 FORMAT (
     + 'You can do the Bartlett parametric test or'
     +/'the Levene nonparametric test'
     +/'Bartlett'
     +/'Levene (median)'
     +/'Levene (mean)'
     +/'Levene (',F5.2,'% trimmed mean)')
  900 FORMAT ('Percentage to be trimmed from each tail: current =',F6.2,
     +'%','(total =',F6.2,'%)')
      END
C
C
