c
c
      subroutine vareq2 (ifail, k, ntotal, nobs,
     +                   b, bc, c, y)
c
c action: Bartlett's test for homogeneity of variances
c author: w.g.bardsley, university of manchester, u.k., 19/02/2009
c
      implicit none 
c
c arguments
c
      integer,          intent (out) :: ifail
      integer,          intent (in)  :: k, ntotal, nobs(k)
      double precision, intent (in)  :: y(ntotal)
      double precision, intent (out) :: b, bc, c
c
c allocatables
c      
      double precision, allocatable :: dnu(:), xmean(:), xvar(:)
c
c locals
c      
      integer i, ierr, j, nstart, nstop
      double precision denom, sp2, sumln, sumnu, sum1dnu
      double precision zero, one, three
      parameter (zero = 0.0d+00, one = 1.0d+00, three = 3.0d+00)
      intrinsic  dble, log
c
c initialise then check
c
      ifail = 1
      b = zero
      bc = zero
      c = zero
      if (k.lt.2 .or. ntotal.lt.4) return
      j = 0
      ifail = 2
      do i = 1, k
         if (nobs(i).lt.2) return
         j = j + nobs(i)
      enddo
      ifail = 3
      if (j.ne.ntotal) return     
c
c allocate
c        
      ifail = 4
      ierr = 0
      if (allocated(dnu)) deallocate (dnu, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(xmean)) deallocate (xmean, stat = ierr)
      if (ierr.ne.0) return  
      if (allocated(xvar)) deallocate (xvar, stat = ierr)
      if (ierr.ne.0) return
      allocate (dnu(k), stat = ierr)
      if (ierr.ne.0) return 
      allocate (xmean(k), stat = ierr)
      if (ierr.ne.0) return 
      allocate (xvar(k), stat = ierr)
      if (ierr.ne.0) return  
c
c initialise counters
c        
      sp2 = zero
      sum1dnu = zero
      sumln = zero
      sumnu = zero
      nstart = 1
c
c loop over each group
c      
      do j = 1, k 
         nstop = nstart + nobs(j) - 1
c
c calculate the means
c         
         dnu(j) = dble(nobs(j))
         xmean(j) = zero       
         do i = nstart, nstop
            xmean(j) = xmean(j) + y(i)
         enddo
         xmean(j) = xmean(j)/dnu(j)
c
c redefine dnu, calculate sp2, variance, sumnu, and sum1dnu
c         
         dnu(j) = dnu(j) - one
         sumnu = sumnu + dnu(j)
         sum1dnu = sum1dnu + one/dnu(j)
         xvar(j) = zero
         do i = nstart, nstop
            xvar(j) = xvar(j) + (y(i) - xmean(j))**2
         enddo
         sp2 = sp2 +  xvar(j)
         xvar(j) = xvar(j)/dnu(j)
         sumln = sumln + dnu(j)*log(xvar(j))
         nstart = nstop + 1   
      enddo
c
c check that all values have been used
c      
      ifail = 5
      if (nstop.ne.ntotal) return
c
c redefine sp2 then calculate b, b and bc
c      
      sp2 = sp2/sumnu
      b = sumnu*log(sp2) - sumln
      denom = three*(dble(k) - one)
      c = one + (sum1dnu - one/sumnu)/denom
      bc = b/c
c
c finally deallocate and set ifail = 0
c
      deallocate(dnu)
      deallocate(xmean)
      deallocate(xvar)
      ifail = 0
      end
c
c        