c
c
      subroutine vareq3 (ifail, itype, k, ntotal, nobs,
     +                   alpha, w, y)
c
c action: Levene test for homogeneity of variances
c author: w.g.bardsley, university of manchester, u.k., 19/02/2009
c         02/03/2009 made alpha an argument
c         01/04/2011 deleted reference to levene.txt  
c         Note: this routine was thrown together in a hurry and should be
c               be re-written to avoid uneccessary allocations and do loops
c               when I get some time to spare
c
c itype = 1: median
c itype = 2: mean
c itype = 3: trimmed mean
c
      implicit none 
c
c arguments
c
      integer,          intent (out) :: ifail
      integer,          intent (in)  :: itype, k, ntotal, nobs(k)
      double precision, intent (in)  :: alpha, y(ntotal)
      double precision, intent (out) :: w
c
c allocatables
c      
      double precision, allocatable :: dnu(:), sx(:), zi_dot(:), zij(:)
c
c locals
c      
      integer    i, ierr, j, l, m, nstart, nstop
      double precision fstmed
      double precision tvar, wmean, wvar, ymean, z_dot_dot
      double precision dn, bot, top
      double precision zero
      parameter (zero = 0.0d+00)
      external   fstmed
      external   g07ddf$
      intrinsic  abs, dble
c
c initialise then check
c
      ifail = 1
      w = zero
      if (k.lt.2 .or. ntotal.lt.4 .or.
     +    itype.lt.1 .or. itype.gt.3) return
      j = 0
      ifail = 2
      do i = 1, k
         if (nobs(i).lt.2) return
         j = j + nobs(i)
      enddo
      ifail = 3
      if (j.ne.ntotal) return     
c
c allocate
c        
      ifail = 4
      ierr = 0
      if (allocated(dnu)) deallocate (dnu, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(zij)) deallocate (zij, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(zi_dot)) deallocate (zi_dot, stat = ierr)
      if (ierr.ne.0) return      
      allocate (dnu(k), stat = ierr)
      if (ierr.ne.0) return 
      allocate (zij(ntotal), stat = ierr)
      if (ierr.ne.0) return 
      allocate (zi_dot(k), stat = ierr)
      if (ierr.ne.0) return    
c
c initialise 
c        
      nstart = 1
      dn = dble(ntotal)
c
c Step 1: loop over each group to define dnu(i) and ymean(i)
c =======
c      
      do i = 1, k 
         nstop = nstart + nobs(i) - 1
c
c calculate the means
c         
         dnu(i) = dble(nobs(i))
         if (itype.eq.1) then
c
c median
c
            ymean = fstmed (y(nstart), nobs(i))
         elseif (itype.eq.2) then
c
c mean
c         
            ymean = zero  
            do j = nstart, nstop
               ymean = ymean + y(j)
            enddo
            ymean = ymean/dnu(i)
         else
c
c trimmed mean
c              
            ierr = 0
            m = nobs(i)
            allocate(sx(m), stat = ierr)
            if (ierr.ne.0) return
            ifail = 1  
            call g07ddf$(m, y(nstart), alpha, ymean, wmean, tvar,
     +                   wvar, l, sx, ifail)
            if (ifail.ne.0) return
            deallocate(sx, stat = ierr)  
            if (ierr.ne.0) return
         endif    
c
c define zij
c 
         do j = nstart, nstop
            zij(j) = abs(y(j) - ymean)
         enddo
         nstart = nstop + 1   
      enddo
c
c check that all values have been used
c      
      ifail = 5
      if (nstop.ne.ntotal) return
c
c Step 2: calculate z_dot_dot
c =======
c
      z_dot_dot = zero
      l = 0
      do i = 1, k
         do j = 1, nobs(i)
            l = l + 1
            z_dot_dot = z_dot_dot + zij(l)
         enddo
      enddo  
      ifail = 6
      if (l.ne.ntotal) return        
      z_dot_dot = z_dot_dot/dn
c
c Step 4: calculate zi_dot
c =======
c      
      nstart = 1
      do i = 1, k
         nstop = nstart + nobs(i) - 1
         zi_dot(i) = zero
         do j = nstart, nstop
            zi_dot(i) = zi_dot(i) + zij(j)
         enddo  
         zi_dot(i) = zi_dot(i)/dnu(i)
         nstart = nstop + 1
      enddo
      ifail = 7  
      if (nstop.ne.ntotal) return
c
c Step 5: define top
c ======
c      
      top = zero
      do i = 1, k
         top = top + dnu(i)*(zi_dot(i) - z_dot_dot)**2
      enddo  
      top = top*dble(ntotal - k)
c
c Step 6: define bot
c =======
c      
      bot = zero
      nstart = 1
      do i = 1, k
         nstop = nstart + nobs(i) - 1
         do j = nstart, nstop
            bot = bot + (zij(j) - zi_dot(i))**2
         enddo   
         nstart = nstop + 1
      enddo  
      ifail = 8
      if (nstop.ne.ntotal) return
      bot = bot*dble(k - 1)
c
c Step 7: define w
c =======
c      
      if (bot.gt.zero) then
         ifail = 0
         w = top/bot
      else
         ifail = 9
         w = zero 
      endif     
c
c finally deallocate 
c
      deallocate(dnu)
      deallocate(zij)
      deallocate(zi_dot)
      end
c
c        