C
C
      SUBROUTINE VECEX1 (NOUT, NUM,
     +                   Z,
     +                   TITLE)
C
C ACTION : Exhaustive analysis of a sorted vector
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          19/10/1995 replaced G01CAF, G01CCF by G01FBF, G01FCF for NAG mark 16
C          16/12/1996 Added CV and RTOL
C          07/02/2001 added CHOP80
C          06/06/2001 added query for Shapiro-Wilks test
C          24/09/2002 replaced patch1 by table1
C          23/01/2006 revised
C          07/04/2009 made workspace Y allocatable, improved formulas for skew and
C                     kurtosis and added INTENTS
C          12/03/2011 suppressed last two text lines if SWTST = .FALSE.
C
C          NOUT: (input/unchanged) preconnected unit for results
C           NUM: (input/unchanged) sample size
C             Z: (input/unchanged) sorted data
C         TITLE: (input/unchanged) data title
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: NOUT, NUM
      DOUBLE PRECISION,    INTENT (IN) :: Z(NUM)
      CHARACTER (LEN = *), INTENT (IN) :: TITLE
C
C Allocatable array
C      
      DOUBLE PRECISION, ALLOCATABLE :: Y(:)
C
C Locals
C
      INTEGER    NCALLS, NUMY
      INTEGER    I, ICOLOR, IFAIL, K, M, NTEXT
      INTEGER    IX, IY, NUMTXT
      PARAMETER (IX = 4, IY = 4, NUMTXT = 21)
      DOUBLE PRECISION TWO, THREE, ZERO, F100
      PARAMETER (TWO = 2.0D+00, THREE = 3.0D+00,
     +           ZERO = 0.0D+00, F100 = 100.0D+00)
      DOUBLE PRECISION PNT025, PNT975
      PARAMETER (PNT025 = 0.025D+00, PNT975 = 0.975D+00)
      DOUBLE PRECISION SIGHAT, STDERR, VARHAT, XMUHAT
      DOUBLE PRECISION CHIL95, CHIU95, XMH95, XML95
      DOUBLE PRECISION XLH, XMED, XMIN, XMAX, XUH
      DOUBLE PRECISION ROOTN, T95, XVL95, XVU95
      DOUBLE PRECISION RTOL, S2, S3, S4
      DOUBLE PRECISION DNP1, DN, DNM1, DNM2, DNM3
      DOUBLE PRECISION PW, SW
      DOUBLE PRECISION G01FBF$, G01FCF$, X02AMF$
      CHARACTER  ANSWER*32, CVPC*12
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER (LEN = 80) CHOP80, WORD80
      LOGICAL    CALWTS, FIRST, SWTST
      EXTERNAL   PUTFAT, PUTIFA, NXXBAR, TABLE1, CHOP80, YESNO2
      EXTERNAL   G01DDF$, G01FBF$, G01FCF$, X02AMF$
      INTRINSIC  ABS, SQRT, MOD, DBLE
      SAVE FIRST, SWTST
      SAVE NCALLS
      DATA FIRST, SWTST / .TRUE., .TRUE. /
      DATA NCALLS / 0 /
C
C Return if sample size too small
C
      IF (NUM.LE.4) THEN
         CALL PUTFAT ('Sample too small for meaningful analysis (< 4)')
         RETURN
      ENDIF
C
C Check data for increasing order
C
      DO I = 2, NUM
         IF (Z(I).LT.Z(I - 1)) THEN
            CALL PUTFAT ('Data not sorted into increasing order')
            RETURN
         ENDIF
      ENDDO
C
C Allocate
C      
      IFAIL = 0
      IF (ALLOCATED(Y)) DEALLOCATE(Y, STAT = IFAIL)
      IF (IFAIL.NE.0) RETURN
      NUMY = NUM  
      ALLOCATE (Y(NUMY), STAT = IFAIL)
      IF (IFAIL.NE.0) RETURN  
C
C Define DN, etc.
C     
      DNP1 = DBLE(NUM + 1)
      DN = DBLE(NUM)
      DNM1 = DBLE(NUM - 1)
      DNM2 = DBLE(NUM - 2)
      DNM3 = DBLE(NUM - 3)     
      ROOTN = SQRT(DN)
C
C Shapiro-Wilks test ?
C
      IF (FIRST) THEN
         ICOLOR = 1
         FIRST = .FALSE.
         LINE =
     +'Include Shapiro-Wilks normality tests in current analyses'
         CALL YESNO2 (ICOLOR, IX, IY, 
     +                LINE,
     +                SWTST)
      ENDIF
C
C HINGES, MIN, MED, MAX, Shapiro and Wilks test
C
      XMIN = Z(1)
      XMAX = Z(NUM)
      IF (MOD(NUM,2).EQ.0) THEN
         M = NUM/2
         K = M/2
         XLH = (Z(K) + Z(K + 1))/TWO
         XMED = (Z(M) + Z(M + 1))/TWO
         XUH = (Z(NUM - K) + Z(NUM - K + 1))/TWO
      ELSE
         M = (NUM + 1)/2
         K = (M + 1)/2
         XLH = Z(K)
         XMED = Z(M)
         XUH = Z(NUM - K + 1)
      ENDIF
      
      IF (SWTST) THEN
         NTEXT = NUMTXT
         CALWTS = .TRUE.
         IFAIL = 1
         CALL G01DDF$(Z, NUM, CALWTS, Y, SW, PW, IFAIL)
         IF (IFAIL.NE.0) THEN
            CALL PUTIFA (IFAIL, NOUT, 'G01DDF/VECEXH')
            RETURN
         ENDIF
         IF (PW.LT.0.01D+00) THEN
            ANSWER = 'Reject normality at 1% sig.level'
         ELSEIF (PW.LT.0.05D+00) THEN
            ANSWER = 'Reject normality at 5% sig.level'
         ELSE
            ANSWER = 'Tentatively accept normality'
         ENDIF
      ELSE
         NTEXT = NUMTXT - 2
         SW = ZERO
         PW = ZERO
         ANSWER = 'No test'
      ENDIF
C
C Work out mean and standard deviation of sample
C
      CALL NXXBAR (NUM,
     +             Z, XMUHAT, VARHAT)
      SIGHAT = SQRT(VARHAT)
      STDERR = SIGHAT/ROOTN
      RTOL = 1.0D+09*X02AMF$()
      IF (ABS(XMUHAT).GT.RTOL) THEN
         S2 = F100*SIGHAT/ABS(XMUHAT)
         IF (S2.GT.100.0D+00) THEN
            CVPC = '>100%'
         ELSEIF (S2.GE.1.0D+00) THEN
            WRITE (CVPC,'(I2,A)') NINT(S2), '%'
         ELSE
            CVPC = '<1%'
         ENDIF         
      ELSE
         CVPC = 'Not possible'
         CVPC = '*Not Defined'
      ENDIF
      IFAIL = 1
      T95 = G01FBF$('Lower-tail', PNT975, DNM1, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01FBF/VECEXH')
      XML95 = XMUHAT - T95*STDERR
      XMH95 = XMUHAT + T95*STDERR
      IFAIL = 1
      CHIL95 = G01FCF$(PNT025, DNM1, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01FCF/VECEXH')
      IFAIL = 1
      CHIU95 = G01FCF$(PNT975, DNM1, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01FCF/VECEXH')
      XVL95 = DNM1*VARHAT/CHIU95
      XVU95 = DNM1*VARHAT/CHIL95
      NCALLS = NCALLS + 1
C
C Work out skew and kurtosis
C
      S2 = SIGHAT
      S3 = ZERO
      S4 = ZERO
      DO I = 1, NUM
         S3 = S3 + (Z(I) - XMUHAT)**3
         S4 = S4 + (Z(I) - XMUHAT)**4
      ENDDO
      S3 = DN*S3/(DNM1*DNM2*S2*VARHAT)
      S4 = DNP1*DN*S4/(DNM1*DNM2*DNM3*VARHAT**2) - 
     +     THREE*DNM1**2/(DNM2*DNM3)
      WORD80 = CHOP80(TITLE)
      WRITE (TEXT,100) NCALLS, WORD80, NUM, XMIN, XMAX, XLH,
     +                 XUH,
     +                 S3, S4, XMED, XMUHAT, S2, CVPC, STDERR, T95,
     +                 XML95,
     +                 XMH95, VARHAT, XVL95, XVU95, SW, PW, ANSWER
      ICOLOR = 15
      CALL TABLE1 (ICOLOR, 'OPEN')
      DO I = 1, NTEXT
         IF (I.EQ.1 .OR. I.EQ.4) THEN
            ICOLOR = 4
         ELSE
            ICOLOR = 0
         ENDIF
         CALL TABLE1 (ICOLOR, TEXT(I))
      ENDDO
      CALL TABLE1 (ICOLOR, 'CLOSE')
      WRITE (TEXT,200) NCALLS, WORD80, NUM, XMIN, XMAX, XLH, XUH,
     +                 S3, S4, XMED, XMUHAT, S2, CVPC, STDERR, T95,
     +                 XML95,
     +                 XMH95, VARHAT, XVL95, XVU95, SW, PW, ANSWER
      DO I = 1, NTEXT
         WRITE (NOUT,'(A)') TEXT(I)
      ENDDO   
C
C Deallocate
C     
      DEALLOCATE(Y, STAT = IFAIL)
C
C Format statements
C      
  100 FORMAT (
     + 'Exhaustive analysis of vector',I4
     +/
     +/'Data:'
     +/A
     +/'Sample size                =',I8
     +/'Minimum value              =',1P,E13.5
     +/'Maximum value              =',E13.5
     +/'Lower Hinge                =',E13.5
     +/'Upper Hinge                =',E13.5
     +/'Coefficient of skew        =',E13.5
     +/'Coefficient of kurtosis    =',E13.5
     +/'Median value               =',E13.5
     +/'Sample mean                =',E13.5
     +/'Sample standard deviation  =',E13.5
     +/'Coefficient of variation   =',1X,A
     +/'Standard error of the mean =',E13.5
     +/'Upper 2.5% t-value         =',E13.5
     +/'Lower 95% con lim for mean =',E13.5
     +/'Upper 95% con lim for mean =',E13.5
     +/'Sample variance            =',E13.5
     +/'Lower 95% con lim for var. =',E13.5
     +/'Upper 95% con lim for var. =',E13.5
     +/'Shapiro-Wilks W statistic  =',E13.5
     +/'Significance level for W   =',0P,F8.4
     +/'Conclusion about normality =',1X,A)
  200 FORMAT (
     + 'Exhaustive analysis of vector',I4
     +/'---------------------------------'
     +/'Data:'
     +/A
     +/'Sample size                =',I8
     +/'Min. and max. values       =',1P,E13.5,',',E13.5
     +/'Lower and Upper Hinges     =',E13.5,',',E13.5
     +/'Coefficient of skew        =',E13.5
     +/'Coefficient of kurtosis    =',E13.5
     +/'Median value               =',E13.5
     +/'Sample mean                =',E13.5
     +/'Sample standard deviation  =',E13.5,': CV% is ',A
     +/'Standard error of the mean =',E13.5
     +/'Upper 2.5% t-value         =',E13.5
     +/'Lower 95% con lim for mean =',E13.5
     +/'Upper 95% con lim for mean =',E13.5
     +/'Sample variance            =',E13.5
     +/'Lower 95% con lim for var. =',E13.5
     +/'Upper 95% con lim for var. =',E13.5
     +/'Shapiro-Wilks W statistic  =',E13.5
     +/'Significance level for W   =',0P,F8.4,5X,A)     
      END
C
C
