C
C
      SUBROUTINE VECEX2 (NFILE, NUM,
     +                   Z,
     +                   FILEIT)
C
C ACTION : Histogram for a vector
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          30/10/1998 removed NOUT from argument list
C          03/02/2001 displayed defaults in edit box and used REPEET
C          19/01/2006 improved error trapping
C          07/04/2009 introduced allocatable workspace
C          17/03/2010 added pdf file with Area = 1
C          26/10/2012 added call to X2IBIN, corrected, simplified, and
C                     removed the need to be in increasing order  
C
C         NFILE: (input/unchanged) unconnected unit for pdf-fitting file
C           NUM: (input/unchanged) actual length of vector

C             Z: (input/unchanged) data
C        FILEIT: (input/unchanged) create fitting files ?
C
C
C           LIW: workspace length (histogram bin max)
C          IWRK: workspace
C          NMAX: dimension (also limits pdf/cdf plot)
C             T: workspace
C             U: workspace
C             V: workspace
C             X: workspace
C             Y: workspace
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN) :: NFILE, NUM
      DOUBLE PRECISION, INTENT (IN) :: Z(NUM)
      LOGICAL,          INTENT (IN) :: FILEIT
C
C Allocatables
C      
      INTEGER,          ALLOCATABLE :: IWRK(:)
      DOUBLE PRECISION, ALLOCATABLE :: T(:), U(:), V(:), X(:), Y(:)
C
C Locals
C
      INTEGER    N0, N1, N2, N3, N5, N11
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N5 = 5, N11 = 11)
      INTEGER    I, ICOUNT, IERR, LIW, NH, NMAX
      INTEGER    NBINS
      INTEGER    MINBIN, MAXBIN, NBIN1, NBIN2
      PARAMETER (MINBIN = 2, NBIN1 = 20, NBIN2 = 300)
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NUMOPT = 4,
     +           NSTART = 12, NTEXT = NSTART + NUMOPT - 1)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      DOUBLE PRECISION ERRMIN
      PARAMETER (ERRMIN = 1.0D-200)
      DOUBLE PRECISION PNT5
      PARAMETER (PNT5 = 0.5D+00)
      DOUBLE PRECISION RNUM
      DOUBLE PRECISION AREA, DELTA, XBOT, XTOP, ZBOT, ZTOP
      CHARACTER  FNAME*1024
      CHARACTER  LINE*100, TEXT(NTEXT)*100
      LOGICAL    ABORT
      LOGICAL    SAVEIT
      PARAMETER (SAVEIT = .TRUE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   PUTFAT, HIST01, GETJM1, GETDG2, OFILES, GETTXT, LBOX01,
     +           PUTADV, X2IBIN
      INTRINSIC  SQRT, DBLE, MIN
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Check sample size
C
      IF (NUM.LE.N5) THEN
         CALL PUTFAT ('Sample too small for meaningful analysis')
         RETURN
      ENDIF
C
C Check data for limits
C
      ZBOT = Z(1)
      ZTOP = Z(1)
      DO I = N1, NUM
         IF (Z(I).LT.ZBOT) THEN
            ZBOT = Z(I)
         ELSEIF (Z(I).GT.ZTOP) THEN
            ZTOP = Z(I)   
         ENDIF
      ENDDO            
C
C Assign dimensions and allocate workspace as follows
C  LIW = max. no. of bins for this run
C   NH = workspace then outline for plotting >= 11*NUM
C NMAX = LIW in this version
C    
      LIW = MIN(NUM + N1, NBIN2)
      NH = N11*LIW + N2   
      NMAX = LIW 
      
      IERR = N0
      IF (ALLOCATED(IWRK)) DEALLOCATE(IWRK, STAT = IERR)
      IF (IERR.NE.N0) RETURN 
      IF (ALLOCATED(T)) DEALLOCATE(T, STAT = IERR)
      IF (IERR.NE.N0) RETURN         
      IF (ALLOCATED(U)) DEALLOCATE(U, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(V)) DEALLOCATE(V, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(Y)) DEALLOCATE(Y, STAT = IERR)
      IF (IERR.NE.N0) RETURN
        
      ALLOCATE(IWRK(LIW), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE(T(NMAX), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE(U(NH), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE(V(NH), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE(X(NMAX), STAT = IERR)
      IF (IERR.NE.N0) RETURN  
      ALLOCATE(Y(NMAX), STAT = IERR)
      IF (IERR.NE.N0) RETURN    

C
C Find data limits
C
      WRITE (LINE,100) ZBOT, ZTOP
      XBOT = ZBOT
      XTOP = ZTOP
      CALL GETDG2 (XBOT, XTOP, 
     +             LINE)
      IF (XBOT.GT.ZBOT .OR. XTOP.LT.ZTOP) CALL PUTADV (
     +'Some sample values are out of range and will not be included')
      MAXBIN = LIW
      IF (MAXBIN.GT.NUM) MAXBIN = NUM
      IF (MAXBIN.GT.NBIN2) MAXBIN = NBIN2
      IF (MAXBIN.LT.MINBIN) MAXBIN = MINBIN + N1
      NBINS = MIN(NUM/N5, NBIN1)
      IF (NBINS.LT.MINBIN) THEN
         NBINS = MINBIN
      ELSEIF (NBINS.GT.MAXBIN) THEN
         NBINS = MAXBIN
      ENDIF
      CALL GETJM1 (MINBIN, NBINS, MAXBIN,
     +            'Number of histogram bins required')
C
C Assign XBOT =< X  =< XTOP then calculate IWRK
C     
      ICOUNT = N0
      DO I = N1, NUM
         IF (Z(I).GE.XBOT .AND. Z(I).LE.XTOP) THEN
            ICOUNT = ICOUNT + N1
            X(ICOUNT) = Z(I)
         ENDIF
      ENDDO
      CALL X2IBIN (IWRK, NBINS, ICOUNT,
     +             XBOT, XTOP, X,
     +             ABORT)
      IF (ICOUNT.LT.N5) THEN
         CALL PUTFAT ('Sub-sample too small for meaningful analysis')
         RETURN
      ENDIF
C
C Construct bin limits
C
      DELTA = (XTOP - XBOT)/DBLE(NBINS)
      RNUM = DBLE(ICOUNT)
C
C Ceate arrays
C
      X(N1) = XBOT + PNT5*DELTA
      Y(N1) = DBLE(IWRK(N1))
      T(N1) = SQRT(Y(N1)*(ONE - Y(N1)/RNUM))
      DO I = N2, NBINS
         X(I) = X(I - N1) + DELTA
         Y(I) = DBLE(IWRK(I))
         T(I) = SQRT(Y(I)*(ONE - Y(I)/RNUM))
      ENDDO
C
C Plot
C     
      CALL HIST01 (NBINS, NH, I,
     +             T, X, U, Y, V,
     +             SAVEIT)
     
      IF (FILEIT) THEN
C
C Create a curve-fitting file if required
C        
         AREA = DELTA*RNUM
         WRITE (TEXT,200) AREA, AREA
         NUMBLD(N1) = N1
         NUMDEC = NUMOPT
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT, 
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         IF (NUMDEC.LT.NUMOPT) THEN
            I = N1
            CLOSE (UNIT = NFILE)
            CALL OFILES (I, NFILE,
     +                   FNAME,
     +                   ABORT)
            IF (.NOT.ABORT) THEN
               CALL GETTXT ('Title for data', LINE)
               WRITE (NFILE,300) LINE
               WRITE (NFILE,400) NBINS, N3
               DO I = N1, NBINS
                  IF (NUMDEC.EQ.N1) THEN
                     WRITE (NFILE,500) X(I), Y(I), ONE
                  ELSEIF (NUMDEC.EQ.N2) THEN
                     IF (Y(I).LT.ONE .OR. T(I).LE.ERRMIN) T(I) = ONE
                     WRITE (NFILE,500) X(I), Y(I), T(I)
                  ELSE
                     WRITE (NFILE,500) X(I), Y(I)/AREA, ONE   
                  ENDIF
               ENDDO
               WRITE (NFILE,600) N1
               WRITE (NFILE,300) 'Default line'
               CLOSE (UNIT = NFILE)
            ENDIF
         ENDIF
      ENDIF
C
C Deallocate
C      
      DEALLOCATE(T, STAT = IERR)
      DEALLOCATE(U, STAT = IERR)
      DEALLOCATE(V, STAT = IERR)
      DEALLOCATE(X, STAT = IERR)
      DEALLOCATE(Y, STAT = IERR)
C
C Format statements
C      
  100 FORMAT (
     +'Histogram limits required (current data range:',1P,2E11.3,')')
  200 FORMAT (
     + 'Creating pdf/histogram type curve-fitting files'
     +/
     +/'You can now save a curve-fitting file for program QNFIT to fit'
     +/'pdfs with an arbitrary scaling parameter or pdfs with area = 1.'
     +/'Such files can have s = 1 for unweighted regression or, for'
     +/'special reasons, the binomial distribution can be used to set'
     +/'s = sqrt[y(1 - y/N)] for weighted regression.'
     +/'Note that it is better to create cdf type files and fit cdfs'
     +/'than to fit pdfs to histograms, as histogram shapes depend on'
     +/'the number of bins, leading to ambiguous parameter estimates.'
     +/
     +/'Save a curve fit file: s = 1, Area =',1P,E10.3
     +/'Save a curve fit file: s = sqrt[y(1-y/N)], Area =',1P,E10.3
     +/'Save a curve fit file: s = 1, Area = 1'
     +/'Quit ... Exit these file saving options')
  300 FORMAT (A)
  400 FORMAT (2I6)
  500 FORMAT (1P,3E15.7)
  600 FORMAT (I6)
      END
C
C
