C
C
      SUBROUTINE VECEX3 (NFILE, NUM,
     +                   Z,
     +                   FILEIT)
C
C ACTION : Create cdf from sorted vector
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          01/04/1998 Added option for 1 - cdf file
C          30/10/1998 removed NOUT from argument list
C          23/01/2006 revised
C
C      NFILE: (input/unchanged) unconnected unit for cdf file
C        NUM: (input/unchanged) actual length of vector
C          Z: (input/unchanged) sorted data
C     FILEIT: (input/unchanged) instruction to save to file
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN) :: NFILE, NUM
      DOUBLE PRECISION, INTENT (IN) :: Z(NUM)
      LOGICAL,          INTENT (IN) :: FILEIT
C
C Allocatable
C      
      DOUBLE PRECISION, ALLOCATABLE :: X(:), Y(:)
C
C Locals
C
      INTEGER    N0, N1, N2, N3
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3)
      INTEGER    I, IERR, J
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NUMOPT = 3,
     +           NSTART = 11, NTEXT = 13)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      DOUBLE PRECISION ONE, ZERO
      PARAMETER (ONE = 1.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION RNUM
      CHARACTER  FNAME*1024
      CHARACTER  LINE*100, TEXT(NTEXT)*100
      CHARACTER  PTITLE*32, XTITLE*13, YTITLE*20
      PARAMETER (PTITLE = 'Cumulative Distribution Function',
     +           XTITLE = 'Sample Values',
     +           YTITLE = 'Cumulative Frequency')
      LOGICAL    ABORT
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   PUTFAT, GKS001, OFILES, GETTXT, LBOX01
      INTRINSIC  DBLE
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Check sample size
C
      IF (NUM.LT.N2) THEN
         CALL PUTFAT ('Sample size is too small')
         RETURN
      ENDIF
C
C Check data for increasing order
C
      DO I = N2, NUM
         IF (Z(I).LT.Z(I - N1)) THEN
            CALL PUTFAT ('Data is not sorted into increasing order')
            RETURN
         ENDIF
      ENDDO
      
      IERR = N0
      IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
      IF (IERR.NE.N0) RETURN 
      IF (ALLOCATED(Y)) DEALLOCATE(Y, STAT = IERR)
      IF (IERR.NE.N0) RETURN     
      ALLOCATE(X(N2*NUM + N1), STAT = IERR)
      IF (IERR.NE.N0) RETURN 
      ALLOCATE(Y(N2*NUM + N1), STAT = IERR)
      IF (IERR.NE.N0) RETURN  
          
      RNUM = DBLE(NUM)
      X(N1) = Z(N1)
      Y(N1) = ZERO
      X(N2) = X(N1)
      Y(N2) = ONE/RNUM
      J = N2
      DO I = N2, NUM
         J = J + N1
         X(J) = Z(I)
         Y(J) = Y(J - N1)
         J = J + N1
         X(J) = X(J - N1)
         Y(J) = DBLE(I)/RNUM
      ENDDO
      CALL GKS001 (N1,
     +             N0,
     +             J, 
     +             X, Y,
     +             PTITLE, XTITLE, YTITLE)
     
      IF (FILEIT) THEN
         WRITE (TEXT,100)
         NUMBLD(N1) = N1
         NUMDEC = N1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         IF (NUMDEC.LT.NUMOPT) THEN
            I = N1
            CLOSE (UNIT = NFILE)
            CALL OFILES (I, NFILE, FNAME, ABORT)
            IF (.NOT.ABORT) THEN
               CALL GETTXT ('Title for data', LINE)
               WRITE (NFILE,200) LINE
               WRITE (NFILE,300) NUM, N3
               J = N0
               DO I = N1, NUM
                  J = J + N2
                  IF (NUMDEC.EQ.1) THEN
                     WRITE (NFILE,400) X(J), Y(J), ONE
                  ELSE
                     WRITE (NFILE,400) X(J), ONE - Y(J), ONE
                  ENDIF
               ENDDO
               WRITE (NFILE,500) N1
               WRITE (NFILE,200) 'Default line'
               CLOSE (UNIT = NFILE)
            ENDIF
         ENDIF
      ENDIF
C
C Deallocate
C      
      DEALLOCATE(X, STAT = IERR)
      DEALLOCATE(Y, STAT = IERR)
C
C Format statements
C      
  100 FORMAT (
     + 'Creating a cdf or (1 - cdf) curve-fitting type file'
     +/
     +/'This cdf data can be written to a curve-fitting type file'
     +/'which can you can use in program QNFIT to fit a statistical'
     +/'distribution function, F(x).'
     +/'Alternatively, a survival analysis type file (1 - cdf) can'
     +/'be created if you wish to use program GCFIT in mode 2 to fit'
     +/'survivor functions, S(x) = 1 - F(x).'
     +/'Both file types will have s = 1 for unweighted regression.'/
     +/'Save a cdf file'
     +/'Save a (1 - cdf) file'
     +/'Quit ... Exit these file saving options')
  200 FORMAT (A)
  300 FORMAT (2I6)
  400 FORMAT (1P,E12.4,',',E12.4,',',E12.4)
  500 FORMAT (I6)
      END
C
C
