C
C
      SUBROUTINE VECEXH (ISEND, NFILE, NIN, NMAX, NOUT, NUM,
     +                   W,
     +                   FNAME, TITLE, 
     +                   FILEIT)
C
C ACTION : Exhaustive analysis of a vector
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          23/12/1996 Added VECONE
C          05/05/1997 win32 version
C          11/08/1998 Now does not change NUM on exit from VECONE
C          08/08/1999 Added option for runs and signs
C          28/05/2001 added pie chart and sequential plots
C          19/11/2002 added half normal and normal plots
C          17/11/2003 provided plot titles using GTYPE
C          09/08/2008 revised and added FNAME to arguments to extract labels
C          07/04/2009 Changed arguments here and in calls to VECEX1, VECEX2, and VECEX3
C          07/12/2010 added PANEL1 in call to LABELS 
C          21/03/2012 replaced TSPLOT$ and PCPLOT$ by TSPLOT and PCPLOT
C          29/10/2012 added SDPLOT and expanded and re-numbered the menu 
C          14/05/2013 corrected argument list for call to LABELS      
C
C
C ADVICE   ISEND = -1: Read in vector, then use menu
C          ISEND =  0: Supply  vector, then use menu (NUM = length of vector)
C          ISEND =  1: Supply  vector, Exhaustive analysis then return
C          ISEND =  2: Supply  vector, pdf analysis then return
C          ISEND =  3: Supply  vector, cdf analysis then return
C          ISEND =  4: Supply  vector, plot as pie chart then return
C          ISEND =  5: Supply  vector, plot as bar chart then return
C          ISEND =  6: Supply  vector, plot as time series plot then return
C          ISEND =  7: Supply  vector, plot as zero-centered rod plot then return
C          ISEND =  8: Supply  vector, plot as mean-centered rod plot then return
C          ISEND =  9: Supply  vector, plot as half-normal scores then return
C          ISEND = 10: Supply  vector, plot as normal scores then return
C          ISEND = 11: Supply  vector, runs/signs then return
C          NFILE: Unit for pdf/cdf files
C          NIN: input unit
C          NMAX: Maximum length of vector 
C          NOUT: Output unit
C          NUM: Actual length of vector
C          W: actual data (returned unchanged if supplied)
C
C
C          T: workspace
C          U: workspace
C          V: workspace
C          Z: workspace for sorted data 
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ISEND, NFILE, NIN,
     +                                       NMAX, NOUT
      INTEGER,             INTENT (INOUT) :: NUM
      DOUBLE PRECISION,    INTENT (INOUT) :: W(NMAX) 
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, TITLE
      LOGICAL,             INTENT (IN)    :: FILEIT   
C
C Allocatables
C       
      DOUBLE PRECISION, ALLOCATABLE :: T(:), U(:), V(:), X(:), Y(:), 
     +                                 Z(:)
C
C Locals
C      
      INTEGER    I, IERR, J, JSEND, NX, NY, NZ
      INTEGER    KMAX
      PARAMETER (KMAX = 50)
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12,
     +           N13
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5, N6 = 6,
     +           N7 = 7, N8 = 8, N9 = 9, N10 = 10, N11 = 11, N12 = 12,
     +           N13 = 13 )
      INTEGER    NUMDEC, NUMOPT, NUMSTA, NUMTXT
      PARAMETER (NUMOPT = 14, NUMSTA = 7, NUMTXT = NUMSTA + NUMOPT - N1)
      INTEGER    NUMBLD(30)
      INTEGER    IFILL(KMAX), IHUE(KMAX)
      DOUBLE PRECISION A, B, DELTA, START, XBAR
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER (LEN = 12 ) FORM12, WORD12 
      CHARACTER (LEN = 40 ) LABEL1(KMAX), PANEL1(KMAX)
      CHARACTER (LEN = 40 ) WORDX(KMAX), VECTORS(60)
      CHARACTER (LEN = 50 ) GTYPE(4:7)
      CHARACTER (LEN = 80 ) TRIM80, WORD80
      CHARACTER (LEN = 100) TEXT(30)
      LOGICAL    ABORT, OK
      LOGICAL    FIXNPT
      PARAMETER (FIXNPT = .FALSE.)
      LOGICAL    FIRST, REPEET, THERE
      EXTERNAL   PUTFAT, NXSORT, VECEX1, VECEX2, VECEX3, LSTBOX, VECONE,
     +           RUNSIN, HNPLOT, GETWRD, LABELS, REVPRO, M_NDTEST
      EXTERNAL   PCPLOT, TSPLOT, SDPLOT, FORM12, TRIM80
      INTRINSIC  DBLE
      DATA       NUMBLD / 30*0 /
      DATA       GTYPE  / 'Pie Chart',
     +                    'Time Series Plot',
     +                    'Zero-centered Rod Plot',
     +                    'Mean-centered Rod Plot' /
C
C Set FIRST = .TRUE. and THERE = .FALSE. as attempt may be made to read labels
C     
      FIRST = .TRUE.
      THERE = .FALSE.
C
C If ISEND = - 1 then read data into W
C
      IF (ISEND.EQ.- N1) THEN
         NUM = N0
         CALL VECONE (NIN, NMAX, NUM,
     +                W,
     +                TITLE,
     +                ABORT, FIXNPT)
         IF (ABORT) RETURN
      ENDIF
      DELTA = ONE
      START = ONE
C
C Return if sample size too small
C
      IF (NUM.LT.N2) THEN
         CALL PUTFAT ('Sample too small for meaningful analysis')
         RETURN
      ENDIF
C
C Allocate
C
      IERR = N0
      IF (ALLOCATED(T)) DEALLOCATE(T, STAT = IERR)
      IF (IERR.NE.N0) RETURN         
      IF (ALLOCATED(U)) DEALLOCATE(U, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(V)) DEALLOCATE(V, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(Y)) DEALLOCATE(Y, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(Z)) DEALLOCATE(Z, STAT = IERR)
      IF (IERR.NE.N0) RETURN   
        
      ALLOCATE(T(NUM), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE(U(NUM), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE(V(NUM), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE(X(NUM), STAT = IERR)
      IF (IERR.NE.N0) RETURN  
      ALLOCATE(Y(NUM), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE(Z(NUM), STAT = IERR)
      IF (IERR.NE.N0) RETURN             
C
C Copy data into Z then sort into increasing order
C
      DO I = N1, NUM
         Z(I) = W(I)
      ENDDO
C
C From now on NUM and W are not changed but Z is ordered
C
      CALL NXSORT (NUM,
     +             Z)
      A = Z(1)
      B = Z(NUM)
C
C Main menu if ISEND .LE. 0, o/w use NUMDEC = ISEND then return
C
      IF (ISEND.LE.N0) THEN
         NUMDEC = N1
      ELSE
         NUMDEC = ISEND
      ENDIF
      WORD12 = FORM12(NUM)
      WORD80 = TRIM80(TITLE)
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (ISEND.LE.N0) THEN
            
            WRITE (TEXT,100) WORD80, WORD12
            NUMBLD(1) = N4 
            NUMBLD(4) = N1
            CALL LSTBOX (NUMBLD, NUMDEC, NUMOPT, NUMSTA, NUMTXT,
     +                   TEXT)
            NUMBLD(1) = N0
            NUMBLD(4) = N0
         ENDIF
         IF (NUMDEC.EQ.N1) THEN
C
C NUMDEC = 1: exhasutive analysis
C           
            CALL VECEX1 (NOUT, NUM,
     +                   Z,
     +                   TITLE)
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C NUMDEC= 2: histogram
C         
            CALL VECEX2 (NFILE, NUM,
     +                   Z,
     +                   FILEIT)
         ELSEIF (NUMDEC.EQ.N3) THEN
C
C NUMDEC = 3: cdf
C         
            CALL VECEX3 (NFILE, NUM,
     +                   Z,
     +                   FILEIT)
         ELSEIF (NUMDEC.EQ.N4) THEN
C
C NUMDEC = 4: pie chart
C         
            OK = .TRUE.
            IF (NUM.GT.KMAX) THEN
               OK = .FALSE.
               CALL PUTFAT (
     +'Sample too large for a pie chart (N > 50)')
            ENDIF
            IF (OK) THEN
               IF (Z(1).LE.ZERO) THEN
               OK = .FALSE.
               CALL PUTFAT (
     +'Must have positive segment values for a pie chart')
               ENDIF
            ENDIF
            IF (OK) THEN
               IF (FIRST) THEN
                  FIRST = .FALSE.
                  INQUIRE (FILE = FNAME, EXIST = THERE)
                  IF (THERE) THEN
                     CALL LABELS (N1, IHUE, IFILL,
     +                            LABEL1, PANEL1, WORDX, VECTORS) 
                     CALL GETWRD (N1, N1, NIN, NUM, KMAX,
     +                            FNAME, LABEL1)
                     IF (NUM.GT.N12) THEN 
                        DO I = N1, N3
                           DO J = N1, N12
                              IHUE(I*N12 + J) = IHUE(J)
                              IFILL(I*N12 + J) = IFILL(J)
                           ENDDO
                        ENDDO
                        IHUE(49) = IHUE(1)
                        IHUE(50) = IHUE(2)
                        IFILL(49) = IFILL(1)
                        IFILL(50) = IFILL(2)
                     ENDIF          
                  ENDIF 
               ENDIF
               IF (THERE) THEN
                  JSEND = N2
               ELSE
                  JSEND = N1
               ENDIF  
               DO I = N1, NUM
                  T(I) = ZERO
               ENDDO                          
               CALL PCPLOT (JSEND, IFILL, IHUE, NUM,
     +                      T, W,
     +                      LABEL1, GTYPE(N4))
            ENDIF
         ELSEIF (NUMDEC.EQ.N5) THEN
C
C NUMDEC = 5: bar chart
C         
            CALL SDPLOT (NUM,
     +                   A, B, Z)               
         ELSEIF (NUMDEC.EQ.N6) THEN
C
C NUMDEC = 6: time sequence
C         
            DELTA = ONE
            START = ONE
            JSEND = N2
            CALL TSPLOT (JSEND, N1, N0, NUM,
     +                   DELTA, U, V, START, W,
     +                   GTYPE(N5), 'Position', 'Values')
         ELSEIF (NUMDEC.EQ.N7) THEN
C
C NUMDEC = 7: zero-centered rods
C         
            JSEND = N4
            CALL TSPLOT (JSEND, N1, N0, NUM,
     +                   DELTA, U, V, START, W,
     +                   GTYPE(N6), 'Position', 'Values')
         ELSEIF (NUMDEC.EQ.N8) THEN
C
C NUMDEC = 8: mean centered rods
C         
            XBAR = ZERO
            DO I = N1, NUM
               XBAR = XBAR + Z(I)
            ENDDO
            XBAR = XBAR/DBLE(NUM)
            DO I = N1, NUM
               T(I) = W(I) - XBAR
            ENDDO
            JSEND = N4
            CALL TSPLOT (JSEND, N1, N0, NUM,
     +                   DELTA, U, V, START, T,
     +                   GTYPE(N7), 'Position', 'Values')
         ELSEIF (NUMDEC.EQ.N9) THEN
C
C NUMDEC = 9: half-normal plot
C         
            JSEND = N1
            CALL HNPLOT (JSEND, NUM,
     +                   W)
         ELSEIF (NUMDEC.EQ.N10) THEN
C
C NUMDEC = 10: full-normal plot
C         
         
            JSEND = N2
            CALL HNPLOT (JSEND, NUM,
     +                   W)
         ELSEIF (NUMDEC.EQ.N11) THEN
C
C NUMDEC = 11: runs and signs
C         
            NZ = NUM
            JSEND = N3
            CALL RUNSIN (JSEND, NIN, NUM, NOUT, NX, NY, NZ,
     +                   T, U, W,
     +                   TITLE, TITLE, TITLE)
         ELSEIF (NUMDEC.EQ.N12) THEN
C
C NUMDEC = 12: normal distribution test
C         
            NZ = NUM
            CALL M_NDTEST (NOUT, NZ,
     +                     Z,
     +                     TITLE)
         ELSEIF (NUMDEC.EQ.N13) THEN
C
C NUMDEC = 13: results
C         
            CALL REVPRO (NOUT)
         ENDIF
         IF (NUMDEC.EQ.NUMOPT .OR. ISEND.GT.N0) REPEET = .FALSE.
         NUMDEC = NUMOPT - N1
      ENDDO
C
C Deallocate
C      
      DEALLOCATE(T, STAT = IERR)
      DEALLOCATE(U, STAT = IERR)
      DEALLOCATE(V, STAT = IERR)
      DEALLOCATE(X, STAT = IERR)
      DEALLOCATE(Y, STAT = IERR)
      DEALLOCATE(Z, STAT = IERR)
C
C Format statement
C      
  100 FORMAT (
     + 'Exhaustive analysis of a vector'
     +/
     +/'Current data set:'
     +/A
     +/'Current sample size:',1X,A
     +/
     +/'Exploratory analysis of the sample'
     +/'Plot-Histograms/save-pdf-fitting-file'
     +/'Plot-Cumulative/save-cdf-fitting-file'
     +/'Plot sample as a pie chart (if > 0)'
     +/'Plot sample as a bar chart'
     +/'Plot sample as a time sequence'
     +/'Plot sample as zero-centered rods'
     +/'Plot sample as mean-centered rods'
     +/'Plot sample in half-normal scores format'
     +/'Plot sample in normal scores format'
     +/'Perform runs and signs tests'
     +/'Perform normal distribution tests'
     +/'Results'
     +/'Quit ... Exit exhaustive analysis of a vector')
      END
C
C


