C
C
      SUBROUTINE VECTST (IWRK, NIN, NMAX, NOUT, NSMALL,
     +                   V, W, X, Y,
     +                   FSAV, TSAV)
C
C ACTION : All pairwise tests
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 12/12/96
C          05/05/1997 win32 version
C          11/12/1999 Added further calculations for P1 and P5
C          13/10/2000 minor improvements to stop crashing
C          07/02/2001 added TRIM80
C          02/07/2002 extensive revision to allow more options
C          12/02/2006 new code to control MWU small sample test
C          11/05/2010 introduced NKLCFG to switch on/off the test file advice 
C          30/04/2011 introduced call to TFILEQ
C
C
C          Note the dimensions IWRK(4*NMAX + 2), V(2*NMAX), W(3*NMAX),
C          X(NMAX), Y(NMAX) in the calling program
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    NIN, NMAX, NOUT, NSMALL
      INTEGER    IWRK(4*NMAX + 2)
      DOUBLE PRECISION V(2*NMAX), W(3*NMAX), X(NMAX), Y(NMAX)
      CHARACTER  FSAV(NSMALL)*(*), TSAV(NSMALL)*(*)
C
C Locals
C
      INTEGER    I, ICOLOR, IFAIL, J, LWRK, MTYPE, NCOMP, NDOF, NFILES,
     +           NTESTS, NX, NY
      INTEGER    KVAL9, NKLCFG
      INTEGER    NTYPE, N1, N21
      PARAMETER (NTYPE = 1, N1 = 1, N21 = 21)
      INTEGER    JCOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (JCOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 9,
     +           NSTART = 3)
      INTEGER    NUMBLD(30), NUMPOS(NUMOPT)
      INTEGER    NBOT, NSUM, NTEST, NTOP
      DOUBLE PRECISION D, P, P1, P5, UMW, UNOR, Z
      DOUBLE PRECISION BOT, DIFF, RTOL, SEDIFF, SSQ, TOP, TU
      DOUBLE PRECISION XBAR, XVAR, YBAR, YVAR
      DOUBLE PRECISION ONE, PNT95, PNT99
      PARAMETER (ONE = 1.0D+00, PNT95 = 0.95D+00, PNT99 = 0.99D+00)
      DOUBLE PRECISION G01EBF$, X02AMF$
      CHARACTER  LINE*100, SYMBOL*2, TEXT(30)*100
      CHARACTER  WORD8(2)*8, TRIM80*80
      CHARACTER  BLANK*1, BOTH*1, TAIL*1
      PARAMETER (BLANK = ' ', BOTH = 'S', TAIL = 'T')
      CHARACTER  CIPHER(4)*20
      CHARACTER (LEN = 12) FORM12, WORD12
      CHARACTER (LEN = 13) WORD13, SHOWLJ
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    ABORT, TIES
      LOGICAL    AGAIN, LIBFIL, REPEET
      LOGICAL    TAB_BOT, TAB_MID, TAB_TOP
      PARAMETER (TAB_BOT = .FALSE., TAB_MID = .FALSE.,
     +           TAB_TOP = .FALSE.)
      LOGICAL    BORDER
      PARAMETER (BORDER = .FALSE.)
      LOGICAL    MTEST, KTEST, TTEST
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   VECFIL, VEC2IN, TABLE1, NXXBAR, LBOX01, YESNO2,
     +           TRIM80, PATCH1, REVPRO
      EXTERNAL   NKLCFG, TFILEQ
      EXTERNAL   G08AHF$, G08CDF$, G01EBF$, G08AJF$, G08AKF$, X02AMF$
      INTRINSIC  DBLE, SQRT, MAX, MIN
      SAVE       MTEST, KTEST, TTEST
      SAVE       MTYPE
      DATA       MTYPE / 1 /
      DATA       MTEST, KTEST, TTEST / .TRUE., .FALSE., .FALSE. /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C RTOL
C
      E_NUMBERS = E_FORMATS()
      RTOL = 1.0D+09*X02AMF$()
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
C
C Main menu to select options
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (MTEST) THEN
            CIPHER(1) = '[Yes]'
         ELSE
            CIPHER(1) = '[No]'
         ENDIF
         IF (KTEST) THEN
            CIPHER(2) = '[Yes]'
         ELSE
            CIPHER(2) = '[No]'
         ENDIF
         IF (TTEST) THEN
            CIPHER(3) = '[Yes]'
         ELSE
            CIPHER(3) = '[No]'
         ENDIF
         IF (MTYPE.EQ.1) THEN
            CIPHER(4) = '[Bonferroni]'
         ELSE
            CIPHER(4) = '[Dunn-Sidak]'
         ENDIF
         WRITE (TEXT,100) (CIPHER(I), I = 1, 4)
         NTEXT = NSTART + NUMOPT - 1
         NUMDEC = NUMOPT - 1
         NUMBLD(1) = 1
         CALL LBOX01 (JCOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                NUMOPT, NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                TAB_TOP, TAB_MID, TAB_BOT)
         IF (NUMDEC.EQ.1) THEN
C
C Individual files
C

            LIBFIL = .FALSE.
            REPEET = .FALSE.
            KVAL9 = NKLCFG(N21)
            IF (KVAL9.EQ.N1) CALL TFILEQ (
     +'Now input vector files formatted like vector.tf1')
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Library file
C
            LIBFIL = .TRUE.
            REPEET = .FALSE.
            KVAL9 = NKLCFG(N21)
            IF (KVAL9.EQ.N1) CALL TFILEQ (
     +'Now input a library file formatted like anova1.tfl')
         ELSEIF (NUMDEC.EQ.3) THEN
C
C Toggle MWU test
C
            MTEST = .NOT.MTEST
         ELSEIF (NUMDEC.EQ.4) THEN
C
C Toggle KS1 test
C
            KTEST = .NOT.KTEST
         ELSEIF (NUMDEC.EQ.5) THEN
C
C Toggle t test
C
            TTEST = .NOT.TTEST
         ELSEIF (NUMDEC.EQ.6) THEN
C
C Toggle method
C
            IF (MTYPE.EQ.1) THEN
               MTYPE = 2
            ELSE
               MTYPE = 1
            ENDIF
         ELSEIF (NUMDEC.EQ.7) THEN
C
C Results
C
            CALL REVPRO (NOUT)
         ELSEIF (NUMDEC.EQ.8) THEN
C
C Help
C
            WRITE (TEXT,1000)
            NTEXT = 21
            ICOLOR = 9
            CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NTEXT,
     +                   TEXT,
     +                   BORDER)
         ELSE
C
C Cancel
C
            RETURN
         ENDIF
      ENDDO
C
C Get the data files
C
      CLOSE (UNIT = NIN)
      CALL VECFIL (NFILES, NIN, NMAX, NSMALL,
     +             X,
     +             FSAV, TSAV,
     +             ABORT, LIBFIL)
      CLOSE (UNIT = NIN)
      IF (ABORT .OR. NFILES.LT.2) RETURN
C
C Calculate the parameters
C
      NTESTS = 0
      IF (MTEST) NTESTS = NTESTS + 1
      IF (KTEST) NTESTS = NTESTS + 1
      IF (TTEST) NTESTS = NTESTS + 1
      NCOMP = NFILES*(NFILES - 1)
      NCOMP = NCOMP/2
      NCOMP = NTESTS*NCOMP
C
C Check for large NFILES
C
      IF (NFILES.GT.15) THEN
         ABORT = .TRUE.
         WRITE (LINE,200) NFILES, NCOMP
         CALL YESNO2 (JCOLOR, IXL, IYL, LINE, ABORT)
         IF (ABORT) RETURN
      ENDIF
      IF (MTYPE.EQ.1) THEN
         Z = DBLE(NCOMP)
         P1 = (ONE - PNT99)/Z
         P5 = (ONE - PNT95)/Z
      ELSE
         Z = ONE/DBLE(NCOMP)
         P1 = ONE - PNT99**Z
         P5 = ONE - PNT95**Z
      ENDIF
      WRITE (WORD8(1),'(F8.6)') P1
      WRITE (WORD8(2),'(F8.6)') P5
C
C Start the table and results output
C
      ICOLOR = 15
      CALL TABLE1 (ICOLOR, 'OPEN')
      WRITE (NOUT,'(A)') BLANK
      LINE = 'Mann-Whitney-U/Kolmogorov-Smirnov-D/unpaired-t tests'
      WRITE (NOUT,'(A)') LINE
      ICOLOR = 4
      CALL TABLE1 (ICOLOR, LINE)
      WRITE (NOUT,'(A)') BLANK
      WORD12 = FORM12(NCOMP)
      WRITE (LINE,300) TRIM(WORD12), WORD8(1), WORD8(2), CIPHER(4)
      WRITE (NOUT,'(A)') LINE
      ICOLOR = 0
      CALL TABLE1 (ICOLOR, LINE)
C
C Main loop
C
      DO I = 1, NFILES
         CALL VEC2IN (NIN, NMAX, NX,
     +                X,
     +                FSAV(I), TSAV(I),
     +                ABORT)
         DO J = I + 1, NFILES
            CALL VEC2IN (NIN, NMAX, NY,
     +                   Y,
     +                   FSAV(J), TSAV(J),
     +                   ABORT)
            IF (NX.GE.2 .AND. NY.GE.2) THEN
               LINE = TRIM80(FSAV(I))
               WRITE (NOUT,'(A)') LINE
               ICOLOR = 4
               CALL TABLE1 (ICOLOR, LINE)
               LINE = TRIM80(FSAV(J))
               WRITE (NOUT,'(A)') LINE
               CALL TABLE1 (ICOLOR, LINE)
               IF (MTEST) THEN
C
C Mann Whitney U test
C
                  IFAIL = 1
                  CALL G08AHF$(NX, X, NY, Y, TAIL, UMW, UNOR, P, TIES,
     +                         V, W, IFAIL)
                  IF (IFAIL.EQ.0) THEN
                     NBOT = MIN(NX,NY)
                     NTOP = MAX(NX,NY)
                     NSUM = NX + NY
                     IF (NTOP.LT.30 .AND. NSUM.LT.40) THEN
                        IFAIL = 1
                        LWRK = 3*NMAX
                        IF (TIES) THEN
                           NTEST = NBOT + NBOT*(NBOT + 1)*NSUM -
     +                             NBOT*(NBOT + 1)*(2*NBOT + 1)/3 + 1
                           IF (LWRK.GE.NTEST) CALL G08AKF$(NX, NY, TAIL,
     +                                                     V, UMW, P, W,
     +                                                     LWRK, IWRK,
     +                                                     IFAIL)
                        ELSE
                           NTEST = NX*NY + 1
                           IF (LWRK.GE.NTEST) CALL G08AJF$(NX, NY, TAIL,
     +                                                     UMW, P, W,
     +                                                     LWRK, IFAIL)
                        ENDIF
                     ENDIF
                     IF (P.LE.P1) THEN
                        SYMBOL = '**'
                     ELSEIF (P.LE.P5) THEN
                        SYMBOL = ' *'
                     ELSE
                        SYMBOL = '  '
                     ENDIF
                     WORD12 = FORM12(NX)
                     WRITE (LINE,400) WORD12
                     WRITE (NOUT,'(A)') LINE
                     ICOLOR = 0
                     CALL TABLE1 (ICOLOR, LINE)
                     WORD12 = FORM12(NY)
                     WRITE (LINE,425) WORD12
                     WRITE (NOUT,'(A)') LINE
                     CALL TABLE1 (ICOLOR, LINE)
                     IF (E_NUMBERS) THEN
                        WRITE (LINE,450) UMW, P, SYMBOL
                     ELSE
                        WORD13 = SHOWLJ(UMW)
                        WRITE (LINE,460) WORD13, P, SYMBOL
                     ENDIF  
                  ELSE
                     WRITE (LINE,500) IFAIL, 'G08AHF/VECTST'
                  ENDIF
                  WRITE (NOUT,'(A)') LINE
                  ICOLOR = 0
                  CALL TABLE1 (ICOLOR, LINE)
               ENDIF
               IF (KTEST) THEN
C
C Kolomogorov Smirnov 2 sample
C
                  IFAIL = 1
                  CALL G08CDF$(NX, X, NY, Y, NTYPE, D, Z, P, V, W,
     +                         IFAIL)
                  IF (IFAIL.EQ.0) THEN
                     IF (P.LE.P1) THEN
                        SYMBOL = '**'
                     ELSEIF (P.LE.P5) THEN
                        SYMBOL = ' *'
                     ELSE
                        SYMBOL = '  '
                     ENDIF
                     IF (E_NUMBERS) THEN
                        WRITE (LINE,600) D, P, SYMBOL
                     ELSE
                        WORD13 = SHOWLJ(D) 
                        WRITE (LINE,610) WORD13, P, SYMBOL
                     ENDIF  
                  ELSE
                     WRITE (LINE,500) IFAIL, 'G08CDF/VECTST'
                  ENDIF
                  WRITE (NOUT,'(A)') LINE
                  ICOLOR = 0
                  CALL TABLE1 (ICOLOR, LINE)
               ENDIF
            ENDIF
            IF (TTEST) THEN
C
C Two tail t
C
               IF (NX.GE.2 .AND. NY.GE.2) THEN
                  CALL NXXBAR (NX, X, XBAR, XVAR)
                  CALL NXXBAR (NY, Y, YBAR, YVAR)
                  IF (XVAR.GT.RTOL .AND. YVAR.GT.RTOL) THEN
                     NDOF = NX + NY - 2
                     TOP = (DBLE(NX) - ONE)*XVAR + (DBLE(NY) - ONE)*YVAR
                     DIFF = XBAR - YBAR
                     BOT = DBLE(NDOF)
                     SSQ = TOP/BOT
                     SEDIFF = SQRT(SSQ*(ONE/DBLE(NX) + ONE/DBLE(NY)))
                     TU = DIFF/SEDIFF
                     IFAIL = 1
                     P = G01EBF$(BOTH, TU, BOT, IFAIL)
                     IF (IFAIL.EQ.0) THEN
                        IF (P.LE.P1) THEN
                           SYMBOL = '**'
                        ELSEIF (P.LE.P5) THEN
                           SYMBOL = ' *'
                        ELSE
                           SYMBOL = '  '
                        ENDIF
                        IF (E_NUMBERS) THEN
                           WRITE (LINE,700) TU, P, SYMBOL
                        ELSE
                           WORD13 = SHOWLJ(TU)
                           WRITE (LINE,710) WORD13, P, SYMBOL
                        ENDIF  
                     ELSE
                        WRITE (LINE,500) IFAIL, 'G01EBF/VECTST'
                     ENDIF
                  ELSE
                     WRITE (LINE,800)
                  ENDIF
               ELSE
                  WRITE (LINE,900)
               ENDIF
               WRITE (NOUT,'(A)') LINE
               ICOLOR = 0
               CALL TABLE1 (ICOLOR, LINE)
            ENDIF
         ENDDO
      ENDDO
      CALL TABLE1 (ICOLOR, 'CLOSE')
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'All possible pairwise comparisons'
     +/
     +/'New-data/analyse (individual files)'
     +/'New-data/analyse (library file, e.g. ANOVA1.TFL)'
     +/'MWU',2X,A
     +/'KS1',2X,A
     +/'t',2X,A
     +/'Method',2X,A
     +/'Results'
     +/'Help'
     +/'Quit ... Exit pairwise comparisons')
  200 FORMAT (I4,' samples means',I6,' tests. Stop calculation')
  300 FORMAT (
     +'Number of tests =',1X,A,', p(1%) = ',A8,', p(5%) = ',A8,2X,A)
  400 FORMAT ('N1 =',1X,A)   
  425 FORMAT ('N2 =',1X,A)   
  450 FORMAT ('MWU =',1P,E13.5,', p is',0P,F9.6,1X,A)
  460 FORMAT ('MWU =',1X,A13,' p is',F9.6,1X,A)
  500 FORMAT ('ERROR: IFAIL =',I3,' from',1X,A)
  600 FORMAT ('KSD =',1P,E13.5,', p is',0P,F9.6,1X,A)
  610 FORMAT ('KSD =',1X,A13,' p is',F9.6,1X,A)
  700 FORMAT ('  T =',1P,E13.5,', p is',0P,F9.6,1X,A)
  710 FORMAT ('  T =',1X,A13,' p is',F9.6,1X,A)
  800 FORMAT ('ERROR: Variances must both be > 0 for t test')
  900 FORMAT ('FATAL: N1 and N2 must both be > 1 for testing')
 1000 FORMAT (
     + 'All possible pairwise comparisons of k samples (vectors)'
     +/
     +/'This procedure performs all possible Mann-Whitney-U, Kolmogorov'
     +/'-Smirnov-1-sample and unpaired t tests on k samples. You should'
     +/'use it for preliminary data exploration rather than for formal'
     +/'hypothesis testing, but you can regard the p values as giving a'
     +/'measure of the difference between corresponding sample pairs.'
     +/'You should use 1-way ANOVA followed by a Tukey Q test if your'
     +/'samples are normally distributed with the same variances and'
     +/'have similar sample sizes.'
     +/
     +/'With k samples there will be m = 3k(k - 1)/2 comparisons and,'
     +/'if a_e = experimentwise, while a_c = comparisonwise alpha, then'
     +/'1 - a_e = (1 - a_c)^m. This is the Dunn-Sidak formula, but you'
     +/'can select the alternative Bonferroni formula, a_c = a_e/m.'
     +/'Values for a_c where a_e = 0.05 and a_e = 0.01 are calculated'
     +/'and any pairwise p values less than a_c are starred * or **.'
     +/
     +/'To cut down the total number of comparisons you, can use one'
     +/'or two tests, for instance, just the Mann-Whitney U test. For'
     +/'efficiency, data should be in a library file like anova1.tfl.')
      END
C
C
