c
c
      subroutine vtranv (isend, n, nrmax, c, u, abort)
c
c action: form c from u^t*u if isend = 1, or u from c if isend = 2
c author: w.g.bardsley, university of manchester, u.k., 26/10/2003
c         17/04/2004 allowed n = 1
c         24/02/2005 version of utranu but with dpotrf replaced by f07fdf$
c
c         isend (input, unchanged)
c         isend = 1: supply u and return c = u^t*u
c         isend = 2: supply c and return u
c
c         n: dimension of c
c         nrmax: leading dimension of c
c         c: symmetric positive definite matrix
c            isend = 1 (output as u^t*u)
c            isend = 2 (input, unchanged)
c         u: packed as upper triangular by columns
c            isend = 1 (input, unchanged)
c            isend = 2 (output)
c         abort: (output)
c
      implicit   none
      integer    isend, n, nrmax
      double precision c(nrmax,n), u(n*(n + 1)/2)
      logical    abort
      integer    i, iadd1, info, istart, j, jadd1, jstart, k, number
      double precision zero
      parameter (zero = 0.0d+00)
      character  uplo*1
      parameter (uplo = 'U')
      external   f07fdf$
c
c initialise abort then check input arguments
c
      abort = .true.
      if (isend.lt.1 .or. isend.gt.2 .or. n.lt.1) return
      if (isend.eq.1 .and. nrmax.lt.n .or.
     +    isend.eq.2 .and. nrmax.lt.n + 1) return
      if (isend.eq.1) then
c
c istart: u(istart) start row of lower triangle, i.e. 1, 2, 4, 7, 11, 16, 22, etc.
c
         istart = 1
         do i = 1, n
            istart = istart + i - 1
c
c jstart: u(jstart) start column of upper triangle, i.e. 1, 2, 4, 7, 11, 16, 22, etc.
c
            jstart = istart - i + 1
            number = i
            do j = i, n
               jstart = jstart + j - 1
               c(i,j) = zero
               iadd1 = istart - 1
               jadd1 = jstart - 1
c
c form inner product of length number = i to define c(i,j) then c(j,i)
c
               do k = 1, number
                  iadd1 = iadd1 + 1
                  jadd1 = jadd1 + 1
                  c(i,j) = c(i,j) + u(iadd1)*u(jadd1)
               enddo
               c(j,i) = c(i,j)
            enddo
         enddo
      elseif (isend.eq.2) then
c
c copy the upper triangle into the strict lower triangle
c
         do i = 1, n
            do j = 1, i
               c(i + 1,j) = c(j,i)
            enddo
         enddo
c
c factorise c
c
         call f07fdf$(uplo, n, c, nrmax, info)
         if (info.ne.0) return
c
c copy the upper triangle into u
c
         k = 0
         do j = 1, n
            do i = 1, j
               k = k + 1
               u(k) = c(i,j)
            enddo
         enddo
c
c reconsitute c
c
         do i = 1, n
            do j = 1, i
               c(i,j) = c(i + 1,j)
               if (i.ne.j) c(j,i) = c(i,j)
            enddo
         enddo
      endif
      abort = .false.
      end
c
c
