C
C
      SUBROUTINE WSRTST (NIN, NMAX, NOUT, NX, NY,
     +                   WRK, X, Y, Z,
     +                   TITLEX, TITLEY)
C
C ACTION : Wilcoxon signed rank test
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 22/04/2004
C          Derived from MWUTST
C
C           NIN: (input/unchanged) unconnected unit for input
C          NMAX: (input/unchanged) array dimension
C          NOUT: (input/unchanged) preconnected unit for output
C            NX: (input/output) X-dimension
C            NY: (input/output) Y-dimension
C           WRK: workspace
C             X: (input/output) X-data
C             Y: (input/output) Y-data
C             z: workspace
C        TITLEX: (input/output) X-title
C        TITLEY: (input/output) Y-title
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    NIN, NMAX, NOUT, NX, NY
      DOUBLE PRECISION WRK(3*NMAX), X(NMAX), Y(NMAX), Z(NMAX)
      CHARACTER  TITLEX*(*), TITLEY*(*)
C
C Locals
C
      INTEGER    I, ICOUNT, IFAIL, N, NSUPP
      INTEGER    ICOLOR, NUMTXT, N1
      PARAMETER (NUMTXT = 19, N1 = 1)
      INTEGER    JCOLOR, IX, IY, NOPT, NUMDEC
      PARAMETER (JCOLOR = 9, IX = 4, IY = 4, NOPT = 4)
      INTEGER    NUMPOS(NOPT)
      DOUBLE PRECISION P1, P2, P3, U1, U2, U3, Z1, Z2, Z3
      DOUBLE PRECISION W, WNOR, XME
      DOUBLE PRECISION ONE, TWO, EPSI
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, EPSI = 1.0D-06)
      CHARACTER  TAIL*1
      CHARACTER  P1TYPE*23, P2TYPE*23, P3TYPE*23
      CHARACTER  CHOP60*60, LINE*100, TEXT(30)*100
      CHARACTER  CIPHER*10, ZEROS*1
      LOGICAL    ABORT, REPEET
      LOGICAL    FIXNPT
      PARAMETER (FIXNPT = .TRUE.)
      EXTERNAL   PLEVEL, PUTIFA, TABLE1, CHOP60, VECTWO, PUTFAT,
     +           GETD01, PUTADV, LBOX02
      EXTERNAL   G08AGF$
      INTRINSIC  ABS, MIN
      SAVE       ICOUNT, XME, ZEROS
      DATA       ICOUNT / 0 /
      DATA       NUMPOS / NOPT*1 /
      DATA       XME / 0.0D+00 /
      DATA       ZEROS / 'N' /
C
C Get data or use data supplied depending on NX, NY
C
      CALL VECTWO (NIN, NMAX, NX, NY, X, Y, TITLEX, TITLEY, ABORT,
     +             FIXNPT)
      IF (ABORT) RETURN
      IF (NX.NE.NY) THEN
         WRITE (LINE,100) NX, NY
         CALL PUTFAT (LINE)
         RETURN
      ENDIF
      N = NX
      IF (N.LT.2) THEN
         WRITE (LINE,200) N
         CALL PUTFAT (LINE)
         RETURN
      ENDIF
C
C Decision loop
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (ZEROS.EQ.'Y' .OR. ZEROS.EQ.'y') THEN
            CIPHER = ' [Yes]'
         ELSE
            ZEROS = 'N'
            CIPHER = ' [No]'
         ENDIF
         WRITE (TEXT,300) XME, CIPHER
         NUMDEC = NOPT - 1
         CALL LBOX02 (JCOLOR, IX, IY, NUMDEC, NOPT, NUMPOS, TEXT)
         IF (NUMDEC.EQ.1) THEN
C
C Change test median
C
            WRITE (LINE,400)
            CALL GETD01 (XME, LINE)
            IF (ABS(XME).GT.EPSI) THEN
               WRITE (LINE,500)
               CALL PUTADV (LINE)
            ENDIF
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Togle ZEROS
C
            IF (ZEROS.EQ.'Y' .OR. ZEROS.EQ.'y') THEN
               ZEROS = 'N'
            ELSE
               ZEROS = 'Y'
            ENDIF
            IF (ZEROS.EQ.'Y') THEN
               WRITE (LINE,600)
               CALL PUTADV (LINE)
            ENDIF
         ELSEIF (NUMDEC.EQ.3) THEN
C
C Analysis requested
C
            REPEET = .FALSE.
            IF (ABS(XME).GT.EPSI) THEN
               WRITE (LINE,500)
               CALL PUTADV (LINE)
            ENDIF
            IF (ZEROS.EQ.'Y') THEN
               WRITE (LINE,600)
               CALL PUTADV (LINE)
            ENDIF
         ELSE
C
C Cancel
C
            REPEET = .FALSE.
         ENDIF
      ENDDO
      IF (NUMDEC.EQ.NOPT) RETURN
C
C Calculate the differences
C
      DO I = N1, N
         Z(I) = X(I) - Y(I)
      ENDDO
C
C Calculate U, Z, and P with TAIL = 'L'
C
      IFAIL = 1
      TAIL = 'L'
      CALL G08AGF$(N, Z, XME, TAIL, ZEROS, U2, Z2, P2, I, WRK,
     +             IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G08AGF/WSRTST')
      IF (IFAIL.NE.0) RETURN
      NSUPP = N - I
C
C Copy U and set approximate significance levels in case of future errors
C
      W = U2
      WNOR = Z2
      U1 = U2
      U3 = U2
      P3 = ONE - P2
      P1 = TWO*MIN(P2, P3)
C
C Calculate exact significance levels for small samples
C
      IF (N.LE.80) THEN
         IFAIL = 1
         TAIL = 'T'
         CALL G08AGF$(N, Z, XME, TAIL, ZEROS, U1, Z1, P1, I, WRK,
     +             IFAIL)
         CALL PUTIFA (IFAIL, NOUT, 'G08AGF/WSRTST')
         IF (IFAIL.NE.0) RETURN
         IFAIL = 1
         TAIL = 'U'
         CALL G08AGF$(N, Z, XME, TAIL, ZEROS, U3, Z3, P3, I, WRK,
     +                IFAIL)
         CALL PUTIFA (IFAIL, NOUT, 'G08AGF/WSRTST')
         IF (IFAIL.NE.0) RETURN
      ENDIF
C
C Output the results
C
      ICOUNT = ICOUNT + 1
      CALL PLEVEL (P1, P1TYPE)
      CALL PLEVEL (P2, P2TYPE)
      CALL PLEVEL (P3, P3TYPE)
      IF (ZEROS.EQ.'Y') THEN
         WRITE (LINE,700) XME
      ELSE
         WRITE (LINE,800) XME
      ENDIF
      WRITE (NOUT,1000) ICOUNT,
     +                  LINE, TITLEX, TITLEY, N, NSUPP, W, WNOR, P1,
     +                  P1TYPE, P2, P2TYPE, P3, P3TYPE
      WRITE (TEXT,2000) ICOUNT,
     +                  LINE, CHOP60(TITLEX), CHOP60(TITLEY), N, NSUPP,
     +                  W, WNOR, P1, P1TYPE, P2, P2TYPE, P3, P3TYPE
      ICOLOR = 15
      CALL TABLE1 (ICOLOR, 'OPEN')
      DO I = 1, NUMTXT
         IF (I.EQ.1  .OR. I.EQ.12 .OR. I.EQ.14 .OR. I.EQ.16 .OR.
     +       I.EQ.18) THEN
            ICOLOR = 4
         ELSEIF (I.EQ.5 .OR. I.EQ.7) THEN
            ICOLOR = 1
         ELSE
            ICOLOR = 0
         ENDIF
         CALL TABLE1 (ICOLOR, TEXT(I))
      ENDDO
      CALL TABLE1 (ICOLOR, 'CLOSE')
  100 FORMAT (
     +'This test requires equal sample sizes but NX =',I6,', NY =',I6)
  200 FORMAT (
     +'This test requires sample sizes > 2 but NX = NY =',I6)
  300 FORMAT (
     + 'Change median of differences (current =',1P,E11.3,')'
     +/'Include zero differences,',A
     +/'Calculate'
     +/'Quit ... Exit these options')
  400 FORMAT ('New median test value required (usually median = 0)')
  500 FORMAT ('Usually set the median of differences test value = 0')
  600 FORMAT ('It is usual to suppress zero differences')
  700 FORMAT (
     +'Zero differences included, median test value =',1P,E11.3)
  800 FORMAT (
     +'Zero differences suppressed, median test value =',1P,E11.3)
 1000 FORMAT (
     +/1X,'Wilcoxon paired-sample signed-rank test',I4
     +/1X,'==========================================='
     +/1X,A
     +/1X,'X-data: ',A
     +/1X,'Y-data: ',A
     +/1X,'Size of data =',I6
     +/1X,'No. values suppressed =',I4
     +/1X,'W =',1P,E11.3
     +/1X,'z =',1P,E11.3
     +/1X,'H0: X median = Y median'
     +/1X,'    as null hypothesis against the alternatives:-'
     +/1X,'H1: Medians differ'
     +/1X,'p =',0P,F8.4,4X,A
     +/1X,'H2: X median < Y median'
     +/1X,'p =',0P,F8.4,4X,A
     +/1X,'H3: X median > Y median'
     +/1X,'p =',0P,F8.4,4X,A)
 2000 FORMAT (
     + 'Wilcoxon paired-sample signed-rank test',I4
     +/
     +/A
     +/'X-data:'
     +/A
     +/'Y-data:'
     +/A
     +/'Size of data =',I6
     +/'No. values suppressed =',I4
     +/'W =',1P,E11.3
     +/'z =',1P,E11.3
     +/'H0: X median = Y median'
     +/'    as null hypothesis against the alternatives:-'
     +/'H1: Medians differ'
     +/'p =',0P,F8.4,4X,A
     +/'H2: X median < Y median'
     +/'p =',0P,F8.4,4X,A
     +/'H3: X median > Y median'
     +/'p =',0P,F8.4,4X,A)
      END
C
C
