C
C
      SUBROUTINE XSTART (NDIMEX, NTYPES, NUMBER, X, SYMBOL, POSTIV)
C
C ACTION : Input starting estimates for parameters X as follows:-
C
C          NDIMEX = dimension of X
C          NTYPES = no. of types of parameters
C          NUMBER = numbers for each type
C          SYMBOL = symbol required for each type
C          POSTIV = .TRUE. if X must be positive
C          Requests array for SYMBOL = A, B, k, K, Km, P, Q, R, Vmax
C
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          DBOS version ... 23/2/94
C          03/02/2001 Now displays defaults
C          Date of this version 03/02/2001
C
      IMPLICIT   NONE
      INTEGER    NDIMEX, NTYPES, NUMBER(NTYPES)
      INTEGER    I, J, K
      DOUBLE PRECISION X(NDIMEX)
      DOUBLE PRECISION ONE, FMAX, FMIN
      PARAMETER (ONE = 1.0D+00, FMAX = 1.0D+20, FMIN = 1.0D-10)
      CHARACTER  SYMBOL(NTYPES)*6
      CHARACTER  LINE*100
      LOGICAL    POSTIV(NDIMEX)
      EXTERNAL   GETDL1, PUTFAT
C
C Initialise X
C
      X(1) = ONE
      DO I = 2, NDIMEX
         X(I) = X(I - 1) + ONE
      ENDDO
C
C Check that dimensions add up correctly
C
      K = 0
      DO I = 1, NTYPES
         K = K + NUMBER(I)
      ENDDO
      IF (K.NE.NDIMEX) THEN
         CALL PUTFAT ('Wrong dimensions in XSTART')
         RETURN
      ENDIF
C
C Get the values
C
      K = 0
      DO I = 1, NTYPES
         DO J = 1, NUMBER(I)
            K = K + 1
            IF (SYMBOL(I).EQ.'     A'  .OR.
     +          SYMBOL(I).EQ.'     B'  .OR.
     +          SYMBOL(I).EQ.'     k'  .OR.
     +          SYMBOL(I).EQ.'     K'  .OR.
     +          SYMBOL(I).EQ.'    Km'  .OR.
     +          SYMBOL(I).EQ.'     P'  .OR.
     +          SYMBOL(I).EQ.'     Q'  .OR.
     +          SYMBOL(I).EQ.'     R'  .OR.
     +          SYMBOL(I).EQ.'  Vmax') THEN
               WRITE (LINE,100) SYMBOL(I), J
            ELSE
               WRITE (LINE,200) SYMBOL(I)
            ENDIF
            IF (POSTIV(K)) THEN
               CALL GETDL1 (FMIN, X(K), FMAX, LINE)
            ELSE
               CALL GETDL1 (-FMAX, X(K), FMAX, LINE)
            ENDIF
         ENDDO
      ENDDO
  100 FORMAT ('Start value for parameter',1X,A6,'(',I1,')')
  200 FORMAT ('Start value for parameter',1X,A6)
      END
C
C
