C
C
      subroutine xstat1 (estim)
c
c action: extra statistics subroutine 1 ... return logical, variable estim
c author: w.g.bardsley, university of manchester, u.k. 23/08/2007
c         03/04/2020 improved the options by adding again and estim_copy
c
c estim: (output) parameters estimated or fixed 
c
      implicit none
c
c arguments
c          
      logical, intent (out) :: estim 
c
c locals
c      
      integer    i, numdec
      integer    numopt, numtxt
      parameter (numopt = 5, numtxt = 22)
      integer    numbld(numtxt)
      character (len = 100) text(numtxt)
      character (len = 6  ) cipher(3)
      logical    again, estim_copy, repeet 
      external   listbx, patch2
      data       numbld / numtxt*0 /
      data       again, estim_copy / .true., .true. /
c
c initial check for again and set defaults 
c    
      estim = estim_copy     
      if (.not.again) then
         return
      else 
         cipher(3) = ' '
      endif      
      numdec = 3
c
c loop to get the option required 
c      
      repeet = .true.
      do while (repeet)
         estim = estim_copy
         if (estim) then
            cipher(1) = ' [Yes]'
            cipher(2) = ' [No]'
         else
            cipher(1) = ' [No]'
            cipher(2) = ' [Yes]'
         endif       
         write (text,100) (cipher(i), i = 1, 3)
         call listbx (numdec, numopt,
     +                text)
         if (numdec.eq.1) then
c
c parameters from sample
c           
            estim = .true.
         elseif (numdec.eq.2) then
c
c parameters input
c         
            estim = .false.
         elseif (numdec.eq.3) then
c
c help
c           
            write (text,200)
            numbld(1) = 1
            numbld(10) = 1
            numbld(18) = 1
            call patch2 (numbld, numtxt,
     +                   text)
            numbld(1) = 0
            numbld(10) = 0
            numbld(18) = 0   
         elseif (numdec.eq.4) then
            again = .false.
            cipher(3) = ' [OK]'
         else
            repeet = .false.                 
         endif        
         estim_copy = estim               
      enddo   
c
c format statements
c      
  100 format (
     + 'Parameters: estimated from sample',1x,a
     +/'Parameters: fixed independently',1x,a
     +/'Help'
     +/'Do not ask again this session',1x,a
     +/'Quit ... Accept the current option')      
  200 format (
     + 'Using sample or population parameters in statistical tests'
     +/
     +/'Parameteric tests are based upon hypothetical distributions and'
     +/'use parameters that define that distribution, like the mean and'
     +/'variance of a normal distribution. Of course, if the assumed'
     +/'distribution is incorrect, or the parameters are not sensible,'
     +/'the test will be of limited value. There are two ways to supply'
     +/'parameters.'
     +/
     +/'Parameters estimated from the sample'
     +/'This is the recommended option'
     +/'The test will be based on the sample parameter estimates. This'
     +/'is very convenient, and often the only way if you do not have'
     +/'independent parameter estimates. However, the test will then'
     +/'be weaker, i.e., have lower power than if the parameters are'
     +/'presumed to be known, i.e., the population parameters.'
     +/
     +/'Population parameters fixed independently'
     +/'The higher power in this case is only justified if you have'
     +/'an independent and meaningful set of parameter estimates, say'
     +/'estimated from a large and reliable data set, or assumed for'
     +/'the population by the null hypothesis')
      end
c
c
