c
c
      subroutine xstat3 (nbins, ngraf, ny, 
     +                   expect, observ, xgraf, xstep, y, ygraf,
     +                   ystep, 
     +                   type1)
c
c action: extra statistics 2: display/save/plot transforms/chi-square bins
c author: w.g.bardsley, university of manchester, u.k., 23/08/2007
c
c Note: if nbins < 2 return, if ny < nbins no transforms  
c
      implicit none
c
c arguments
c           
      integer,             intent (in) :: nbins, ngraf, ny
      double precision,    intent (in) :: expect(nbins), observ(nbins),
     +                                    xgraf(ngraf), xstep(2*ny),
     +                                    y(ny), ygraf(ngraf),
     +                                    ystep(2*ny)  
      character (len = *), intent (in) :: type1
c
c local allocatable array
c      
      double precision,    allocatable :: a(:,:)
      character (len = 4), allocatable :: labels(:)
c
c locals
c      
      integer    i, ierr, numdec
      integer    ncmax, ncol, nrmax, nrow 
      integer    isend, nf, ntype, numopt, numtxt
      parameter (isend = 2, nf = 4, ntype = 3, numopt = 6, numtxt = 20)
      integer    l0, l1, n2
      parameter (l0 = 0, l1 = 1, n2 = 2)
      integer    numbld(numtxt)
      character  cipher*4, line*100, text(numtxt)*100
      character  titles(4)*50, word50*50
      character  ptitle*80, xtitle*60, ytitle*60
      logical    repeet, trans
      logical    axes, gsave, fileit
      parameter (axes = .true., gsave = .true., fileit = .false.)
      external   listbx, patch2, dsplay, putfat, bcplot, gks004
      data       numbld / numtxt*0 /
c
c check then define cipher and trans
c      
      if (nbins.lt.2) return
      if (ny.lt.nbins) then
         trans = .false.
         cipher = '[NA]'
      else
         trans = .true.
         cipher = '    '
      endif     
c
c allocate then define a(i,j) and labels
c         
      ierr = 0
      if (allocated(a)) deallocate(a, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(labels)) deallocate(labels, stat = ierr)
      if (ierr.ne.0) return  
      ncmax = 2
      nrmax = nbins  
      allocate(a(nrmax,ncmax), stat = ierr)
      if (ierr.ne.0) return 
      allocate(labels(nrmax), stat = ierr)
      if (ierr.ne.0) return       
      nrow = nbins
      do i = 1, nrow
         a(i,1) = observ(i)
         a(i,2) = expect(i)
         write (labels(i),'(i4)') i
      enddo
c
c main loop
c           
      repeet = .true.
      numdec = numopt - 1
      do while (repeet)
         write (text,100) cipher
         call listbx (numdec, numopt,
     +                text)
         if (numdec.eq.1) then
            PTITLE = TYPE1
            XTITLE = 'The sample values'
            YTITLE = 'Current cdf and step function'
            CALL GKS004 (L1, L1, L0, L0, L0, L0, L0, L0,
     +                   NGRAF, N2*NY, N2*NY, N2*NY,
     +                   XGRAF, XSTEP, XSTEP, XSTEP,
     +                   YGRAF, YSTEP, YSTEP, YSTEP,
     +                   PTITLE, XTITLE, YTITLE, 
     +                   AXES, GSAVE)
         elseif (numdec.eq.2) then
c
c display observed and expected
c           
            ncmax = 2
            ncol = 2
            nrmax = nbins
            nrow = nbins
            call dsplay (ncmax, ncol, nf, nrmax, nrow, ntype,
     +                   a,
     +                   type1,
     +                   fileit)       
         elseif (numdec.eq.3) then
c
c plot observe and expected
c         
            word50 = type1
            write (titles,200) word50
            ncol = 2
            nrmax = nbins
            nrow = nbins
            call bcplot (isend, ncol, nrmax, nrow,
     +                   a,
     +                   labels, titles)
         elseif (numdec.eq.4) then
c
c display transforms
c         
            if (trans) then
               ncmax = 1
               ncol = 1
               nrmax = ny
               nrow = ny
               call dsplay (ncmax, ncol, nf, nrmax, nrow, ntype,
     +                      y,
     +                      type1,
     +                      fileit)
            else
               write (line,300)
               call putfat (line)
            endif          
         elseif (numdec.eq.numopt - 1) then
c
c help
c         
            write (text,400) type1
            numbld(1) = 1
            numbld(11) = 1
            call patch2 (numbld, numtxt,
     +                   text)            
            numbld(1) = 0
            numbld(11) = 0          
         else
c
c cancel
c           
            repeet = .false.
         endif   
      enddo   
      deallocate(a, stat = ierr)
      deallocate(labels, stat = ierr) 
c
c format statements
c      
  100 format (
     + 'Original data and best-fit cdf: plot'  
     +/'Observed and expected: display'
     +/'Observed and expected: plot'
     +/'U(0,1) transforms: display',2x,a
     +/'Help'
     +/'Quit ... Exit these options')
  200 format (
     + a
     +/'Bins'
     +/'O/E Frequencies'
     +/)      
  300 format ('No transforms calculated')     
  400 format (
     + 'Observed and Expected frequencies'
     +/
     +/'Many experiments lead to observed frequencies which can be'
     +/'compared to expected frequencies for a goodness of fit test.'
     +/'For instance, a chi-square test would calculate C given by'
     +/
     +/'    C = Sum from i = 1, to i = n of [O(i) - E(i)]^2/E(i)'
     +/
     +/'with degrees of freedom = n - 1 - no. of parameters estimated.'          
     +/
     +/'U(0,1) transforms using the asumed cdf function'
     +/'A special case is where the expected frequencies may be from'
     +/'a uniform distribution, as the random variables have been'
     +/'transformed using the assumed cumulative distribution, with'
     +/'parameters estimated or assumed for the test. In this case'
     +/'all the expected values would equal k/n, where n is the'
     +/'number of histogram bins and k is the original sample size.'
     +/ 
     +/'You can now examine the frequencies for the following data:'
     +/A)
      end
c
c