c
c
      subroutine xtrnax (isend, nout, nrmax, n, a, s, x, abort)
c
c action: calculate either s = (x^T)*a*x or s = (x^T)*(a^-1)*x
c author: w.g.bardsley, university of manchester, u.k., 10/09/2003
c         09/10/2003 introduced epsi and rtol to test for symmetry
c         03/12/2003 allowed isend = 3 to omit cv matrix check
c         15/06/2004 allowed n = 1 but error exit if N < 1
c
c         isend: (input/unchanged) has the following meaning:
c                isend = 1: use a directly ... no check for symmetric
c                isend = 2: use a-inverse  ... check for covariance matrix
c                isend = 3: use a-inverse  ... just check if symmetric
c
c          nout: (input/unchanged) preconnected unit for error messages
c         nrmax: (input/unchanged) 1st dimension of a
c             n: (input/unchanged) order of the matrices and vector
c             a: (input/unchanged) input data matrix
c                all values must be set, and if isend = 2, a(i,i) must
c                be >= 0, and a(i,j) = a(j,i), e.g. a covariance matrix
c             s: (output) scalar value returned if abort = .true.
c             x: (input/unchanged) vector
c         abort: (output) error indicator returned as true or false
c
      implicit none
c
c arguments
c
      integer isend, nout, nrmax, n
      double precision a(nrmax,n), s, x(n)
      logical abort
c
c locals
c
      integer    i, ifail, j
      integer    nmax
      parameter (nmax = 251)
      double precision atemp(nmax,nmax), btemp(nmax,nmax), ztemp(nmax)
      double precision zero, epsi, rtol
      double precision x02amf$, x02ajf$
      double precision bot, top, ratio
      parameter (zero = 0.0d+00)
      character  line*100
      external   putfat, putifa
      external   f01abf$, x02ajf$, x02amf$
      intrinsic  abs, max, sqrt
c
c initialise abort and s then check inmput parameters
c
      abort = .true.
      s = zero
      epsi = sqrt(x02ajf$())
      rtol = 1.0d+09*x02amf$()
c
c is isend in range
c
      if (isend.lt.1 .or. isend.gt.3) then
         write (line,100)
         call putfat (line)
         return
      endif
c
c are dimensions OK
c
      if (nrmax.lt.1 .or. n.lt.1) then
         write (line,200)
         call putfat (line)
         return
      endif
c
c is n too big
c
      if (n.gt.nmax - 1) then
         write (line,300) nmax - 1
         call putfat (line)
         return
      endif
c
c check that a is a covariance matrix if isend = 2
c
      if (isend.eq.2) then
         do i = 1, n
            if (a(i,i).lt.zero) then
               write (line,400) i, i
               call putfat (line)
               return
            endif
         enddo
      endif
c
c check for symmetry if isend = 2 or isend = 3
c
      if (isend.eq.2 .or. isend.eq.3) then
         do i = 2, n
            do j = 1, i - 1
               bot = max(rtol, abs(a(i,j)) + abs(a(j,i)))
               top = abs(a(i,j) - a(j,i))
               ratio = top/bot
               if (ratio.gt.epsi) then
                  write (line,500) i, j, j, i
                  call putfat (line)
                  return
               endif
            enddo
         enddo
      endif
c
c copy a into atemp
c
      do j = 1, n
         do i = 1, n
            atemp(i,j) = a(i,j)
         enddo
      enddo
c
c invert a then make atemp = a inverse if isend = 2 or isend = 3
c
      if (isend.eq.2 .or. isend.eq.3) then
         ifail = 1
         call f01abf$(atemp, nmax, n, btemp, nmax, ztemp, ifail)
         call putifa (ifail, nout, 'F01ABF/XTRNAX')
         if (ifail.ne.0) return
         do i = 1, n
            atemp(i,i) = btemp(i,i)
         enddo
         do i = 2, n
            do j = 1, n - 1
               atemp(i,j) = btemp(i,j)
               atemp(j,i) = atemp(i,j)
            enddo
         enddo
      endif
c
c initialise ztemp
c
      do i = 1, n
         ztemp(i) = zero
      enddo
c
c Ax
c
      do i = 1, n
         do j = 1, n
            ztemp(i) = ztemp(i) + atemp(i,j)*x(j)
         enddo
      enddo
c
c x^TAx
c
      s = zero
      do i = 1, n
         s = s + x(i)*ztemp(i)
      enddo
c
c success so set abort = .false.
c
      abort = .false.
  100 format ('ISEND out of range in call to XTRNAX')
  200 format ('N < 1 in call to XTRNAX')
  300 format ('Matrix too large ... max. dimension in XTRNAX =',i4)
  400 format (
     +'A(',i4,',',i4,') < 0 in call to XTRNAX')
  500 format (
     +'A(',i4,',',i4,') not equal A(',i4,',',i4,') in call to XTRNAX')
      end
c
c
