C
C
      SUBROUTINE XYCORR (NCMAX, NCOL, NF, NIN, NRMAX, NROW, NSMALL,
     +                   A,
     +                   FNAME, FSAV, TITLE, TSAV,
     +                   NEWDAT, SUPPLY)
C
C ACTION: Pearson parametric correlation analysis
C AUTHOR: W. G. Bardsley, University of Manchester, U.K., 18/5/95
C         19/10/1995 Changed G01BAF to G01EBF for NAG mark 16
C         28/10/1996 Corrected call to VECFIL
C         14/12/1996 Added NSMALL, FSAV, TSAV
C         18/10/1997 Return if library file unusable
C         09/08/1999 Added VECCHK and ICMAX and VECCPY
C         12/08/1999 Altered code so A can be supplied as in NPCORR
C                    In this version A is only changed by data input
C         30/01/2002 introduced STATMT and CHOP80
C         14/02/2004 added call to F03ABF$
C         14/03/2004 added call to PACORR
C         10/01/2006 moved B, W, X, Y, CORR to allocatables
C         04/02/2006 added NEWDAT and SUPPLY to argument list and added
C                    A1 to hold rolled data, ISXEDI, and ISXDAT
C         27/07/2006 Redimensioned arrays using NBIG and and extensive
C                    editing to allow for M > N
C         02/10/2006 edited and introduced EOFINT, R, SSP, D, and VIEWIT 
C         11/11/2006 added ALLPOS in call to EOFINT 
C         16/04/2011 edited the main menu
C         07/07/2016 used PMIN, PMAX instead of RMIN, RMAX [ERROR! By mistake I made PMIN .ne. -PMAX] 
C         11/07/2016 introduced calls to PUTERR to trap allocation errors
C         11/12/2016 icreased format 600 to F9.5
C         31/12/2016 Corrected error introduced at 07/07/2016 by restoring RMAX and RMIN = -RMAX 
C         05/01/2022 added E_NUMBERS, E_FORMATS, DONE1, DONE2, FILE1, FILE, FIRST, etc.
C         12/01/2022 further editing to control the output to the results file
C
C   NCMAX: (input/unchanged) dimension
C    NCOL: (input/output) depending on SUPPLY
C      NF: (input/unchanged) preconnected unit for results
C     NIN: (input/unchanged) unconnected unit for data input
C   NRMAX: (input/unchanged) dimension
C    NROW: (input/output) depending on SUPPLY
C  NSMALL: (input/unchanged) dimension
C       A: (input/output) depending on SUPPLY
C   FNAME: (input/output) depending on SUPPLY
C    FSAV: (input/output) depending on SUPPLY
C   TITLE: (input/output) depending on SUPPLY
C    TSAV: (input/output) depending on SUPPLY
C  SUPPLY: (input/unchanged) if SUPPLY = .TRUE. then supply NCOL, NROW, A,
C                            FNAME, TITLE, but not FSAV, TSAV
C  NEWDAT: (output) NEWDAT returned as .TRUE. if new data requested
C
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NCMAX, NF, NIN, NRMAX,
     +                                       NSMALL
      INTEGER,             INTENT (INOUT) :: NCOL, NROW
      DOUBLE PRECISION,    INTENT (INOUT) :: A(NRMAX,NCMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, FSAV(NSMALL), TITLE,
     +                                       TSAV(NSMALL)
      LOGICAL,             INTENT (IN)    :: SUPPLY
      LOGICAL,             INTENT (OUT)   :: NEWDAT
C
C
C Local allocatable arrays
C
      INTEGER,             ALLOCATABLE :: ISX(:)
      DOUBLE PRECISION,    ALLOCATABLE :: A1(:,:), B(:), D(:,:), R(:,:),
     +                                    SSP(:,:), W(:,:), X(:), Y(:,:)
      CHARACTER (LEN = 9), ALLOCATABLE :: CORR(:,:)
C
C Locals
C
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N15
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N6 = 6, N7 = 7, N15 = 15)
      INTEGER    I, IERR, J, IFAIL, NBIG, NDOF, NTYPE, NVAR
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NOPT, NSTART, NUMTXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1, NOPT = 10,
     +           NSTART = 13)
      INTEGER    NDEC, NUMBLD(30), NUMPOS(NOPT)
      INTEGER    ICOUNT, ISIZE, JSIZE, NX, NY
      INTEGER    NISX
      PARAMETER (NISX = 200)
      INTEGER    ISXSAV(NISX)
      DOUBLE PRECISION ONE, TWO, ZERO, SIX, ELEVEN
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, ZERO = 0.0D+00,
     +           SIX = 6.0D+00, ELEVEN = 11.0D+00)
      DOUBLE PRECISION DELTA
      DOUBLE PRECISION EPSI, RSMALL 
      PARAMETER (EPSI = 1.0D-20, RSMALL = 1.0D-06)
      DOUBLE PRECISION RMAX, RMIN
      PARAMETER (RMAX = ONE - RSMALL, RMIN = - RMAX)
      DOUBLE PRECISION DET, DNDOF, PVAL, STAT, TEMP
      DOUBLE PRECISION G01EBF$, G01ECF$
      CHARACTER (LEN = 100) LINE, LINE_COPY, TEXT(30)
      CHARACTER (LEN = 80 ) CHOP80, WORD80
      CHARACTER (LEN = 40 ) VERDIC
      CHARACTER (LEN = 13 ) D13(2), SHOWLJ
      CHARACTER (LEN = 12 ) I12, FORM12
      CHARACTER (LEN = 9  ) SYMBOL
      CHARACTER (LEN = 8  ) NUMC, NUMR, NUMS
      CHARACTER (LEN = 4  ) AVAIL, CIPHER, NOTAV
      CHARACTER (LEN = 1  ) BLANK
      PARAMETER (AVAIL = '    ', BLANK = ' ', NOTAV = '(NA)',
     +           SYMBOL = '    .....')
      LOGICAL    DONE, E_NUMBERS, E_FORMATS, FILE1, FILE2, FIRST   
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    PRINT1, QUERY, SUPPL1
      PARAMETER (PRINT1 = .TRUE., QUERY = .TRUE., 
     +           SUPPL1 = .TRUE.)
      LOGICAL    ABORT, AGAIN, EQUAL, IWARNU, OK, PLOT, REPEET
      LOGICAL    ALLPOS
      PARAMETER (ALLPOS = .TRUE.)
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   PUTADV, PUTIFA, LINFIT, GETJM1, STATMT, LBOX01, MATCOR,
     +           YESNO2, PATCH1, CHOP80, TABLE1, PLEVEL, PACORR, ISXEDI,
     +           ISXDAT, TRIML1, ISXTYP, REVPRO, EOFINT, VIEWIT,
     +           PUTERR  
      EXTERNAL   G02BAF$, G01EBF$, G01ECF$, F03ABF$
      INTRINSIC  MIN, SQRT, ABS, DBLE, LOG, NINT, MAX
      SAVE       ICOUNT      
      SAVE       ISXSAV
      DATA       ICOUNT / 0 /
      DATA       ISXSAV / NISX*1 /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NOPT*1 /
C
C Initialise FIRST, DONE, FILE1, FILE2,  NEWDAT and check if SUPPLY = .TRUE.
C

      DONE = .FALSE.
      FILE1 = .TRUE.
      FILE2 = .TRUE.
      FIRST = .TRUE.
      NEWDAT = .FALSE.
      
      IF (SUPPLY) THEN
         IF (NCOL.LT.N2 .OR. NCOL.GT.NCMAX .OR.
     +       NROW.LT.N2 .OR. NROW.GT.NRMAX) RETURN
      ELSE        
         NCOL = N0
         NROW = N0 
         FNAME = 'No file'
         TITLE = 'No data'
      ENDIF
C
C Allocate workspace
C
      IERR = 0
      IF (ALLOCATED(ISX)) DEALLOCATE(ISX, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(A1)) DEALLOCATE(A1, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(B)) DEALLOCATE(B, STAT = IERR)
      IF (IERR.NE.0) RETURN 
      IF (ALLOCATED(D)) DEALLOCATE(D, STAT = IERR)
      IF (IERR.NE.0) RETURN   
      IF (ALLOCATED(R)) DEALLOCATE(R, STAT = IERR)
      IF (IERR.NE.0) RETURN 
      IF (ALLOCATED(SSP)) DEALLOCATE(SSP, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(W)) DEALLOCATE(W, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(Y)) DEALLOCATE(Y, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(CORR)) DEALLOCATE(CORR, STAT = IERR)
      IF (IERR.NE.0) RETURN
        
      ALLOCATE(ISX(NCMAX), STAT = IERR)
      IF (IERR.NE.0) THEN
         CALL PUTERR (IERR, 'A, XYCORR vector ISX')
         RETURN
      ENDIF
      
      ALLOCATE(A1(NRMAX,NCMAX), STAT = IERR)
      IF (IERR.NE.0) THEN
         CALL PUTERR (IERR, 'A, XYCORR matrix A1')
         RETURN
      ENDIF
      
      NBIG = MAX(NCMAX,NRMAX)
      ALLOCATE(B(NBIG), STAT = IERR)
      IF (IERR.NE.0) THEN
         CALL PUTERR (IERR, 'A, XYCORR vector B')
         RETURN 
      ENDIF
      
      ALLOCATE(D(N2,NCMAX), STAT = IERR)
      IF (IERR.NE.0) THEN
         CALL PUTERR (IERR, 'A, XYCORR matrix D')
         RETURN
      ENDIF
      
      ALLOCATE(R(NCMAX,NCMAX), STAT = IERR)
      IF (IERR.NE.0) THEN
          CALL PUTERR (IERR, 'A, XYCORR matrix R')
         RETURN   
      ENDIF   
      
      ALLOCATE(SSP(NCMAX,NCMAX), STAT = IERR)
      IF (IERR.NE.0) THEN
         CALL PUTERR (IERR, 'A, XYCORR matrix SSP')
         RETURN
      ENDIF
      
      ALLOCATE(W(NCMAX,NCMAX), STAT = IERR)
      IF (IERR.NE.0) THEN
         CALL PUTERR (IERR, 'A, XYCORR matrix W')
         RETURN
      ENDIF
      
      ALLOCATE(X(NBIG), STAT = IERR)
      IF (IERR.NE.0) THEN
         CALL PUTERR (IERR, 'A, XYCORR vector X')
         RETURN
      ENDIF
      
      ALLOCATE(Y(NCMAX,NCMAX), STAT = IERR)
      IF (IERR.NE.0) THEN
         CALL PUTERR (IERR, 'A, XYCORR matrix Y')
         RETURN
      ENDIF
      
      ALLOCATE(CORR(NCMAX,NCMAX), STAT = IERR)
      IF (IERR.NE.0) THEN
         CALL PUTERR (IERR, 'A, XYCORR matrix CORR')
         RETURN
      ENDIF 
     
C
C Initialise ISX, NVAR, NDEC, NX and NY
C      
      E_NUMBERS = E_FORMATS()              
      OK = .FALSE.
      IWARNU = .FALSE.
      DO I = N1, NCMAX
         IF (I.LE.NISX) THEN
            ISX(I) = ISXSAV(I)
         ELSE   
            ISX(I) = N1
         ENDIF 
      ENDDO
      IF (SUPPLY) CALL EOFINT (ISX, NCOL,
     +                         FNAME,
     +                         ABORT, ALLPOS)  
      NX = N1
      NY = N2
      NDEC = NOPT - N1
      WORD80 = CHOP80(TITLE)
C
C Main loop
C =========
C
     
      REPEET = .TRUE.
      DO WHILE (REPEET)
         NVAR = N0
         IF (NCOL.GT.N1 .AND. NROW.GT.N1) THEN
            CALL ISXTYP (ISX, NCOL, NVAR, N2,
     +                   LINE,
     +                   IWARNU)   
            LINE_COPY = LINE         
            CIPHER = AVAIL
         ELSE
            LINE = BLANK
            CIPHER = NOTAV
         ENDIF
         WRITE (NUMC,'(I8)') NCOL
         WRITE (NUMR,'(I8)') NROW
         WRITE (NUMS,'(I8)') NCOL - NVAR
         CALL TRIML1 (NUMC)
         CALL TRIML1 (NUMR)
         CALL TRIML1 (NUMS)
         WRITE (TEXT,100) LINE, WORD80, NUMR, NUMC, NUMS, CIPHER
         IF (IWARNU) TEXT(5) = '* = variable suppressed'
         
         NUMTXT = NSTART + NOPT - N1
         NUMBLD(1) = N4
         NUMBLD(4) = N1
         NUMBLD(7) = N1   
         IF (NDEC.LT.1) NDEC = NOPT - N1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NOPT,
     +                NUMPOS, NSTART, NUMTXT, TEXT,
     +                BORDER, FLASH, HIGH)
         IF (FIRST .AND. NDEC.EQ.2) THEN
            FIRST = .FALSE.
            ICOUNT = ICOUNT + 1
            WRITE (NF,400) BLANK
            WRITE (NF,200) ICOUNT  
            DO I = 6, 11
               IF (I.NE.8) WRITE (NF,400) TEXT(I)
            ENDDO
            DONE = .FALSE.
         ENDIF     
         NUMBLD(1) = N0
         NUMBLD(4) = N0
         NUMBLD(7) = N0
C
C Check that DATA are ready if NDEC = 2 is selected
C
         IF (NDEC.GE.N2 .AND. NDEC.LE.N7) THEN
            IF (NCOL.LT.N1 .OR. NROW.LT.N1) THEN
               CALL PUTADV ('First input your current data')
               NDEC = N0
            ELSEIF (NCOL.LT.N2 .OR. NROW.LT.N3) THEN
               CALL PUTADV ('Must have at least 3 rows and 2 columns')
               NDEC = N0
            ENDIF
         ENDIF
         IF (NDEC.GE.N3 .AND. NDEC.LE.N6) THEN
            IF (.NOT.OK) THEN
               CALL PUTADV ('First analyse some data')
               NDEC = N0
            ENDIF
         ENDIF
         IF (NDEC.EQ.N1) THEN
C
C NDEC = 1: Data input
C =========
C
            IF (SUPPLY) THEN 
               DO I = N1, MIN(NCMAX, NISX)
                  ISXSAV(I) = ISX(I)
               ENDDO
               NEWDAT = .TRUE.
               DEALLOCATE(ISX, STAT = IERR)
               DEALLOCATE(A1, STAT = IERR)
               DEALLOCATE(B, STAT = IERR) 
               DEALLOCATE(D, STAT = IERR)
               DEALLOCATE(R, STAT = IERR)
               DEALLOCATE(SSP, STAT = IERR)
               DEALLOCATE(W, STAT = IERR)
               DEALLOCATE(X, STAT = IERR)
               DEALLOCATE(Y, STAT = IERR)
               DEALLOCATE(CORR, STAT = IERR)
               RETURN
            ENDIF
            CALL STATMT (NCMAX, NCOL, NF, NIN, NRMAX, NROW, NSMALL,
     +                   A, B, X,
     +                   FNAME, FSAV, TITLE, TSAV) 
            CALL EOFINT (ISX, NCOL,
     +                   FNAME,
     +                   ABORT, ALLPOS)  
            WORD80 = CHOP80(TITLE)
            IF (NCOL.GT.N1 .AND. NROW.GT.N1) THEN
               NDEC = N2
            ELSE
               NDEC = N1
            ENDIF  
            OK = .FALSE.
         ELSEIF (NDEC.EQ.N2) THEN
C
C NDEC = 2: Analysis of data ... First read data into A1
C =========
C
            OK = .FALSE.
            ISIZE = NROW
            JSIZE = NCOL
            DO I = N1, JSIZE
               IF (ISX(I).NE.N0) THEN
                  EQUAL = .TRUE.
                  DO J = N1, ISIZE
                     A1(J,I) = A(J,I)
                     IF (J.GT.N1) THEN
                        DELTA = ABS(A1(J - N1,I) - A1(J,I))
                        IF (DELTA.GT.EPSI) EQUAL = .FALSE.
                     ENDIF
                  ENDDO
                  IF (EQUAL) THEN
                     CALL PUTADV ('Variance too small for analysis')
                     IF (SUPPLY) THEN
                        NEWDAT = .TRUE.
                        DEALLOCATE(ISX, STAT = IERR)
                        DEALLOCATE(A1, STAT = IERR)
                        DEALLOCATE(B, STAT = IERR)
                        DEALLOCATE(W, STAT = IERR)
                        DEALLOCATE(X, STAT = IERR)
                        DEALLOCATE(Y, STAT = IERR)
                        DEALLOCATE(CORR, STAT = IERR)
                        RETURN
                     ENDIF
                     NCOL = N0
                     NROW = N0
                     ISIZE = N0
                  ENDIF
               ENDIF
            ENDDO
C
C Start of action if DATA are OK
C ----------------------------------------------------------------
            IF (NCOL.GT.N1 .AND. NROW.GT.N1 .AND. NVAR.GT.N1) THEN
C ----------------------------------------------------------------
C
C Roll data matrix according to ISX and redfine JSIZE if required
C
            IF (NVAR.NE.NCOL) THEN
               DO J = N1, NCOL
                  DO I =  N1, NROW
                     A1(I,J) = A(I,J)
                  ENDDO
               ENDDO
               CALL ISXDAT (ISX, NCOL, NRMAX, NROW,
     +                      A1,
     +                      ABORT)
               JSIZE = NVAR
            ENDIF
            IF (ISIZE.GT.N1 .AND. JSIZE.GT.N1) THEN
C
C Blank out the correlation matrix
C
               DO I = N1, NCMAX
                  DO J = N1, NCMAX
                     CORR(J,I) = BLANK
                  ENDDO
               ENDDO
               IFAIL = N1
               CALL G02BAF$(ISIZE, JSIZE, A1, NRMAX, B, X, W, NCMAX,
     +                      Y, NCMAX, IFAIL) 
               IF (IFAIL.EQ.N0) THEN
                  OK = .TRUE.
               ELSE   
                  CALL PUTIFA (IFAIL, NF, 'G02BAF/XYCORR')
               ENDIF   
C
C Matrix A1 still has the rolled data but Y now has the correlation
C matrix so copy it into W but save a copy in R and save the means 
C and std. devs. in D
C
               DO I = N1, JSIZE 
                  D(1,I) = B(I)
                  D(2,I) = X(I)
                  DO J = N1, JSIZE 
                     SSP(J,I) = W(J,I)
                     W(J,I) = Y(J,I)
                     R(J,I) = Y(J,I)
                  ENDDO
               ENDDO
C
C Write the correlation coefficients to the correlation matrix
C
               DO I = N1, JSIZE
                  DO J = I, JSIZE
                     IF (J.EQ.I) THEN
                        CORR(I,J) = SYMBOL
                     ELSE
                        WRITE (CORR(I,J),600) W(I,J)
                     ENDIF
                  ENDDO
               ENDDO
C
C Now overwrite lower triangle of W with the probabilities
C
               NDOF = ISIZE - N2
               DNDOF = DBLE(NDOF)
               TEMP = SQRT(DNDOF)
               DO I = N1, JSIZE
                  DO J = N1, I - N1
                     PVAL = W(I,J)  
                     IF (PVAL.LE.RMIN) THEN
                        PVAL = RMIN
                     ELSEIF (PVAL.GE.RMAX) THEN
                        PVAL = RMAX
                     ENDIF   
                     STAT = PVAL*TEMP/SQRT(ONE - PVAL**2)
                     IFAIL = N1
                     PVAL = G01EBF$('S', STAT, DNDOF, IFAIL)
                     CALL PUTIFA (IFAIL, NF, 'G01EBF/XYCORR')
                     W(I,J) = PVAL
                     WRITE (CORR(I,J),600) W(I,J)
                  ENDDO
               ENDDO
               WRITE (NF,'(A)') BLANK
               WRITE (NF,'(A)') ' Current variables:'
               WRITE (NF,'(A)') LINE_COPY
               WRITE (LINE,500)
               FILE1 = .TRUE.
               CALL MATCOR (NCMAX, JSIZE, NF,
     +                      CORR, LINE,
     +                      FILE1)
C
C Work out the determinant
C
               IFAIL = N0
               CALL F03ABF$(Y, NCMAX, JSIZE, DET, X, IFAIL)
               IF (IFAIL.EQ.N0 .AND. DET.GT.ZERO) THEN
                  TEMP = DBLE(ISIZE) - (TWO*DBLE(JSIZE) + ELEVEN)/SIX
                  STAT = - TEMP*LOG(DET)
                  DNDOF = DBLE(JSIZE*(JSIZE - N1))/TWO
                  IFAIL = N0
                  PVAL = G01ECF$('U', STAT, DNDOF, IFAIL)
                  CALL PUTIFA (IFAIL, NF, 'G01ECF/XYCORR')
                  IF (IFAIL.EQ.0) THEN
                     CALL PLEVEL (PVAL, VERDIC)
                     IF (E_NUMBERS) THEN
                        IF (.NOT.DONE) THEN
                           WRITE (NF,700) DET, STAT, NINT(DNDOF), PVAL,
     +                                    VERDIC
                           DONE = .TRUE.
                        ENDIF   
                        WRITE (TEXT,700) DET, STAT, NINT(DNDOF), PVAL,
     +                                   VERDIC
                     ELSE
                        D13(1) = SHOWLJ(DET)
                        D13(2) = SHOWLJ(STAT)
                        I12 = FORM12(NINT(DNDOF))
                        IF (.NOT.DONE) THEN
                           WRITE (NF,750) D13(1), D13(2), I12, PVAL,
     +                                    VERDIC
                           DONE = .TRUE.
                        ENDIF   
                        WRITE (TEXT,750) D13(1), D13(2), I12, PVAL,
     +                                   VERDIC
                     ENDIF  
                     J = N15
                     CALL TABLE1 (J, 'OPEN')
                     DO I = N1, N7
                        IF (I.EQ.N1) THEN
                           J = N4
                        ELSEIF (I.EQ.N2) THEN
                           J = N1
                        ELSE
                           J = N0
                        ENDIF
                        CALL TABLE1 (J, TEXT(I))
                     ENDDO
                     CALL TABLE1 (J, 'CLOSE')
                  ENDIF
               ENDIF
            ENDIF
C
C Correlation plots if required
C =============================
C
            IF (IFAIL.EQ.N0 .AND. JSIZE.GT.N1 .AND. ISIZE.GT.N2) THEN
               AGAIN = .TRUE.
            ELSE
               AGAIN = .FALSE.
            ENDIF
            DO WHILE (AGAIN)
               PLOT = .TRUE.
               CALL YESNO2 (ICOLOR, IXL, IYL,
     +'Further analysis/plot for any two columns as (X,Y) ?', PLOT)
               IF (PLOT) THEN
                  CALL GETJM1 (N1, NX, JSIZE,
     +'Number of current data column to use for X in correlation')
                  CALL GETJM1 (N1, NY, JSIZE,
     +'Number of current data column to use for Y in correlation')
                  IF (NX.EQ.NY) THEN
                     CALL PUTADV ('X = Y ... Try again')
                  ELSE
                     WRITE (NF,800) NX, NY
C
C Copy correlation/plotting pairs from A1 into X and B
C
                     DO I = N1, NROW
                        X(I) = A1(I,NX)
                        B(I) = A1(I,NY)
                     ENDDO
                     CALL LINFIT (NF, NROW,
     +                            X, B,
     +                            FILE2, PRINT1)
                  ENDIF
               ELSE
                  AGAIN = .FALSE.
               ENDIF
            ENDDO
C
C Partial correlations if required
C ================================
C
            IF (IFAIL.EQ.N0 .AND. JSIZE.GT.N2 .AND. ISIZE.GT.JSIZE) THEN
               CALL PACORR (NCMAX, NIN, NF, NRMAX, ISIZE, JSIZE,
     +                      A1, Y, W, X, B,
     +                      FNAME, TITLE,
     +                      QUERY, SUPPL1)
            ENDIF
C
C End of action if DATA are OK
C ----------------------------
            ENDIF
C ----------------------------
            NDEC = N1
         ELSEIF (NDEC.EQ.N3) THEN 
C
C NDEC = 3: data           
C =========
C                        
            NTYPE = N3        
            CALL VIEWIT (NVAR, NRMAX, NROW, NTYPE,
     +                   A1,
     +                   'Current Data')            
         ELSEIF (NDEC.EQ.N4) THEN 
C
C NDEC = 4: means and std.devs.
C ========= 
C                                
            NTYPE = N3        
            CALL VIEWIT (NVAR, N2, N2, NTYPE,
     +                   D,
     +                   'Means and Std.Devs.')
         ELSEIF (NDEC.EQ.N5) THEN
C
C NDEC = 5: ssp matrix
C ========= 
C                                
            NTYPE = N3        
            CALL VIEWIT (NVAR, NCMAX, NVAR, NTYPE,
     +                   SSP,
     +                   'SSP Matrix')      
         ELSEIF (NDEC.EQ.N6) THEN
C
C NDEC = 6: correlation matrix
C ========= 
C                                
            NTYPE = N2        
            CALL VIEWIT (NVAR, NCMAX, NVAR, NTYPE,
     +                   R,
     +                   'Correlation Matrix')      
         ELSEIF (NDEC.EQ.N7) THEN
C
C NDEC = 7: Suppress/restore variables
C =========
C
            CALL ISXEDI (ISX, NCOL, NVAR, N2)
            IWARNU = .FALSE.  
            OK = .FALSE.
            IF (NCOL.NE.NVAR) THEN
               J = N0
               DO I = N1, NVAR
                  IF (ISX(I).NE.N0) J = J + N1
               ENDDO
               IF (J.NE.NVAR) THEN
                  IWARNU = .TRUE.
                  WRITE (LINE,900)
                  CALL PUTADV (LINE)
               ENDIF
            ENDIF 
         ELSEIF (NDEC.EQ.NOPT - N2) THEN
C
C NDEC = NOPT - 2: Results
C ================
C         
            CALL REVPRO (NF)   
         ELSEIF (NDEC.EQ.NOPT - N1) THEN
C
C NDEC = NOPT - 1: Help
C ================
C
            WRITE (TEXT,1000)
            NUMTXT = 20
            NUMBLD(1) = N1
            CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMTXT,
     +                   TEXT,
     +                   BORDER)
            NUMBLD(1) = N0
         ELSEIF (NDEC.EQ.NOPT) THEN
C
C NDEC = NOPT: Cancel
C ============
C
            NEWDAT = .FALSE.
            REPEET = .FALSE.
         ENDIF
      ENDDO           
C
C Save ISX
C      
      DO I = N1, MIN(NCMAX, NISX)
         ISXSAV(I) = ISX(I)
      ENDDO
C
C Deallocate workspace
C
      DEALLOCATE(ISX, STAT = IERR)
      DEALLOCATE(A1, STAT = IERR)
      DEALLOCATE(B, STAT = IERR)
      DEALLOCATE(D, STAT = IERR)
      DEALLOCATE(R, STAT = IERR)
      DEALLOCATE(SSP, STAT = IERR)
      DEALLOCATE(W, STAT = IERR)
      DEALLOCATE(X, STAT = IERR)
      DEALLOCATE(Y, STAT = IERR)
      DEALLOCATE(CORR, STAT = IERR)
C
C Format statements
C
  100 FORMAT (
     + ' Pearson correlation analysis:'
     +/    
     +/' Current variables:'
     +/1x,A
     +/
     +/' Title of current data:'
     +/1x,A
     +/
     +/' Number of rows =',1x,a
     +/' Number of columns =',1x,a
     +/' Number of variables suppressed =',1x,a
     +/
     +/'Data: New/Edit/Transform/View'
     +/'Analyse the current data',2X,A 
     +/'View/Print/Save: current data'  
     +/'View/Print/Save: means/std.devs.' 
     +/'View/Print/Save: SSP matrix' 
     +/'View/Print/Save: correlation matrix' 
     +/'Suppress/Restore variables'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit Pearson correlation analysis')
  200 FORMAT (
     +/' Pearson correlation analysis:',i3
     +/' --------------------------------'
     +/)    
  400 FORMAT (1X,A)
  500 FORMAT (' Pearson correlation analysis',
     +': Upper triangle = r, Lower = corresponding two-tail p values')
  600 FORMAT (F9.5)
  700 FORMAT (
     +/' Test for absence of any significant correlations'
     +/' H0: correlation matrix is the identity matrix'
     +/' Determinant         =',1P,E11.3
     +/' Test statistic (TS) =',   E11.3
     +/' Degrees of freedom  =',   I8
     +/' p = P(chi-sq >= TS) =',0P,F8.4,1X,A)
  750 FORMAT (
     +/' Test for absence of any significant correlations'
     +/' H0: correlation matrix is the identity matrix'
     +/' Determinant         =',1X,A
     +/' Test statistic (TS) =',1X,A
     +/' Degrees of freedom  =',1X,A 
     +/' p = P(chi-sq >= TS) =',F7.4,1X,A)     
  800 FORMAT (
     +/'For the next analysis: X is column',I3,', Y is column',I3
     +/)
  900 FORMAT ('The variables have now been re-numbered')
 1000 FORMAT (
     + 'Pearson correlation analysis'
     +/
     +/'This technique is used when variables are pairwise bivariate'
     +/'normally distributed, so it is not suitable for counts, n-point'
     +/'scales, proportions, or categorical variables.'
     +/
     +/'For correlation analysis you require m columns of length n'
     +/'for m variables observed in n related cases, e.g. antibodies'
     +/'A, B and C in the same set of 127 patients would require 3'
     +/'columns of length 127.'
     +/'Simfit estimates all the Pearson product moment correlation'
     +/'coefficients and shows a matrix with all possible correlation'
     +/'coefficients (r, i.e. rho estimates) in the upper triangle.'
     +/'The lower triangle contains corresponding two tail p-values'
     +/'for the appropriate t statistics (with ..... for diagonals).'
     +/
     +/'Do not just plot a best fit line for y = f(x) (which assumes'
     +/'no errors in x) or x = g(y) (which assumes no errors in y),'
     +/'but plot either both of these regression lines, or the major or'
     +/'reduced major axis lines (which assume variation in x and y).')
      END
C
C
