C
C
      SUBROUTINE ZEROS1 (M, N, NIN, NF, NMAX,
     +                   A, W, Z,
     +                   ABORT, DSPLAY, FILE, SUPPLY)
C
C ACTION: Zeros of a real polynomial
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 15/6/96
C         24/07/1996 added close unit before and after call to VEC1IN
C         08/08/1997 win32 version
C         03/02/2006 minor editing
C         30/10/2021 added E_NUMBERS and E_FORMATS, etc.
C
C ADVICE: The case SUPPLY = .FALSE.
C
C              M: (output) length of vector A
C              N: (output) degree of polynomial
C            NIN: (input/unchanged) unconnected unit for data input
C             NF: (input/unchanged) preconnected unit for results
C           NMAX: (input/unchanged) maximum dimension of A, Z
C              A: (output) vector of coefficients
C              Z: (output) matrix of zeros
C              W: workspace
C          ABORT: (output) error indicator
C         DSPLAY: (input/unchanged) show table on screen ?
C           FILE: (input/unchanged) write output to file ?
C         SUPPLY: (input/unchanged) provide data ?
C
C        The case SUPPLY = .TRUE. as above except as follows:
C
C            NIN: not referenced
C           NMAX: the number of coefficients >= 1
C              A: (input/unchanged)
C

      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    M, N, NIN, NF, NMAX
      DOUBLE PRECISION A(NMAX), Z(2,NMAX), W(2*(NMAX + 1))
      LOGICAL    ABORT, DSPLAY, FILE, SUPPLY
C
C Locals
C
      INTEGER    I, ICOLOR, IFAIL, J, K, NSTART
      INTEGER    N0, N1, N2, N4, N15
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N4 = 4, N15 = 15)
      DOUBLE PRECISION EPSI, X02AJF$
      CHARACTER  FNAME*1024, LINE*100
      CHARACTER (LEN = 13) D13(3), SHOWLJ, SHOWRJ 
      LOGICAL    E_NUMBERS, E_FORMATS 
      LOGICAL    FIXNPT, LABEL, SCALE1
      PARAMETER (FIXNPT = .FALSE., SCALE1 = .TRUE., LABEL = .FALSE.)
      LOGICAL    READY
      EXTERNAL   E_FORMATS, SHOWLJ, SHOWRJ
      EXTERNAL   X02AJF$, C02AGF$
      EXTERNAL   VEC1IN, TABLE1, PUTIFA, PUTFAT, PUTADV
      INTRINSIC  ABS
C
C Check maximum degree requested
C
      IF (SUPPLY .AND. NMAX.GT.101) THEN
         ABORT = .TRUE.
         CALL PUTFAT ('Degree requested is too high (maximum = 100)')
         RETURN
      ENDIF
C
C Set ABORT = .TRUE. then define EPSI
C
      E_NUMBERS = E_FORMATS()
      ABORT = .TRUE.
      EPSI = X02AJF$()
      N = - N1
      IF (.NOT.SUPPLY) THEN
C
C Read in the vector of coefficients
C
         CALL PUTADV (
     +'Now input A(i) as in: A(1)x^(n-1) + A(2)x^(n-2) + ... + A(n)')
         I = 0
         CLOSE (UNIT = NIN)
         CALL VEC1IN (I, NIN, NMAX, M,
     +                A,
     +                FNAME,
     +                LINE, ABORT, FIXNPT, LABEL)
         CLOSE (UNIT = NIN)
         IF (ABORT) RETURN
      ENDIF
C
C Make sure the leading coefficient is non-zero
C
       READY = .FALSE.
       NSTART = N1
       DO I = N1, M
          IF (.NOT.READY) THEN
             IF (ABS(A(I)).GE.EPSI) THEN
                READY = .TRUE.
             ELSE
                NSTART = NSTART + N1
             ENDIF
          ENDIF
       ENDDO
       IF (NSTART.GT.M) THEN
          ABORT = .TRUE.
          IF (DSPLAY) CALL PUTFAT ('All A(i) = 0.0')
          RETURN
       ENDIF
C
C Define the degree of the polynomial
C
       N = M - NSTART
       IF (N.LT.N1) THEN
          IF (DSPLAY) CALL PUTFAT ('Degree < 1')
          ABORT = .TRUE.
          RETURN
       ENDIF
C
C Find the zeros
C
       IFAIL = N1
       CALL C02AGF$(A(NSTART), N, SCALE1, Z, W, IFAIL)
       IF (IFAIL.NE.0) THEN
C
C Failure
C
          IF (DSPLAY) CALL PUTIFA (IFAIL, NF, 'ZEROS1/C02AGF')
          ABORT = .TRUE.
          RETURN
       ELSE
C
C Success
C
          ABORT = .FALSE.
       ENDIF
       IF (DSPLAY) THEN
          ICOLOR = N15
          CALL TABLE1 (ICOLOR, 'OPEN')
          ICOLOR = N4
          WRITE (LINE,100)
          CALL TABLE1 (ICOLOR, LINE)
          WRITE (LINE,200)
          CALL TABLE1 (ICOLOR, LINE)
          ICOLOR = N0
          IF (NSTART.GT.N1) THEN
             DO I = N1, NSTART - N1
                WRITE (LINE,300) I
                CALL TABLE1 (ICOLOR, LINE)
             ENDDO
          ENDIF
          J = NSTART
          K = N1
          DO I = NSTART, M - N1
             IF (ABS(Z(N2,K)).LE.EPSI) THEN
                IF (E_NUMBERS) THEN
                   WRITE (LINE,400) J, A(J), Z(N1,K)
                ELSE
                   D13(1) = SHOWLJ(A(J))
                   D13(2) = SHOWRJ(Z(N1,K))
                   WRITE (LINE,450) J, D13(1), D13(2)
                ENDIF  
             ELSE
                IF (E_NUMBERS) THEN
                   WRITE (LINE,500) J, A(J), Z(N1,K), Z(N2,K)
                ELSE
                   D13(1) = SHOWLJ(A(J))
                   D13(2) = SHOWRJ(Z(N1,K))
                   D13(3) = SHOWRJ(Z(N2,K))
                   WRITE (LINE,550) J, D13(1), D13(2), D13(3)  
                ENDIF              
             ENDIF
             CALL TABLE1 (ICOLOR, LINE)
             J = J + N1
             K = K + N1
          ENDDO
          IF (E_NUMBERS) THEN
             WRITE (LINE,600) J, A(J)
          ELSE
             D13(1) = SHOWlJ(A(J))
             WRITE (LINE,650) J, TRIM(D13(1)) 
          ENDIF  
          CALL TABLE1 (ICOLOR, LINE)
          CALL TABLE1 (ICOLOR, 'CLOSE')
       ENDIF
       IF (FILE) THEN
          WRITE (NF,'(A)') ' '
          WRITE (LINE,100)
          WRITE (NF,'(A)') LINE
          WRITE (LINE,200)
          WRITE (NF,'(A)') LINE
          IF (NSTART.GT.N1) THEN
             DO I = N1, NSTART - N1
                WRITE (LINE,300) I
                WRITE (NF,'(A)') LINE
             ENDDO
          ENDIF
          J = NSTART
          K = N1
          DO I = NSTART, M - N1
             IF (ABS(Z(N2,K)).LE.EPSI) THEN
                IF (E_NUMBERS) THEN
                   WRITE (LINE,400) J, A(J), Z(N1,K)
                ELSE
                   D13(1) = SHOWLJ(A(J))
                   D13(2) = SHOWRJ(Z(N1,K))
                   WRITE (LINE,450) J, D13(1), D13(2)
                ENDIF  
             ELSE
                IF (E_NUMBERS) THEN
                   WRITE (LINE,500) J, A(J), Z(N1,K), Z(N2,K)
                ELSE
                   D13(1) = SHOWLJ(A(J))
                   D13(2) = SHOWRJ(Z(N1,K))
                   D13(3) = SHOWRJ(Z(N2,K))
                   WRITE (LINE,550) J, D13(1), D13(2), D13(3)  
                ENDIF 
             ENDIF
             WRITE (NF,'(A)') LINE
             J = J + N1
             K = K + N1
          ENDDO
          IF (E_NUMBERS) THEN
             WRITE (LINE,600) J, A(J)
          ELSE
             D13(1) = SHOWlJ(A(J))
             WRITE (LINE,650) J, TRIM(D13(1)) 
          ENDIF     
          WRITE (NF,'(A)') LINE
       ENDIF
C
C Format statements
C       
  100 FORMAT (' Zeros of f(x) = A(1)x^(n-1) + A(2)x^(n-2) + ... + A(n)')
  200 FORMAT (' Coefficients',18X,'    Real Part  Imaginary Part')
  300 FORMAT (' A(',I3,') =  0',23X,'(infinity)')
  400 FORMAT (' A(',I3,') =',1P,E15.7,2X,E18.7)
  450 FORMAT (' A(',I3,') =',2X,A13,  7X,A) 
  500 FORMAT (' A(',I3,') =',1P,E15.7,2X,E18.7,E15.7,'i')
  550 FORMAT (' A(',I3,') =',2X,A13,  7X,A13,2X,A13,'i')
  600 FORMAT (' A(',I3,') =',1P,E15.7,' (constant term)')
  650 FORMAT (' A(',I3,') =',2X,A,' (constant term)')
      END
C
C
