; -- Simfit.iss --
; SIMFIT Setup Script for Inno Setup Compiler
; By Ivan N. Lucas <ivan.lucas@lockdown.co.uk>, http://www.lockdown.co.uk/
; SIMFIT Copyright (C) The University of Manchester
; By W. G. Bardsley <bill.bardsley@manchester.ac.uk>, http://www.simfit.manchester.ac.uk
; ----------------

[Setup]
AppName=x64_SIMFIT
AppVerName=SIMFIT Version 7.1.2 (64-bit)
AppCopyright=Copyright  2015 The University of Manchester
DefaultDirName={pf64}\Simfit
DefaultGroupName=Simfit
MinVersion=5.1
SourceDir=c:\setup
InfoBeforeFile=x64_infobefo.txt
UninstallFilesDir={app}\bin

[Dirs]
Name: "{app}\bin"
Name: "{app}\dem"
Name: "{app}\doc"

[Files]
; MAIN FILES

Source: "c:\simfit7\dll\clearwin64\CLEARWIN64.DLL"; DestDir: "{app}\bin"; Flags: ignoreversion
Source: "LIB64F53.DLL"; DestDir: "{app}\bin"; Flags: ignoreversion
Source: "LIB64F60RTS.DLL"; DestDir: "{app}\bin"; Flags: ignoreversion
Source: "programs\x64_simfit.exe"; DestDir: "{app}\bin"

; ADDITIONAL EXECUTABLES
Source: "c:\simfit7\dll\clearwin64\x64_simfitbar.exe"; DestDir: "{app}\bin"
Source: "c:\simfit7\dll\clearwin64\x64_change_simfit_version.exe"; DestDir: "{app}\bin"
Source: "programs\x64_change_simfit_version.config"; DestDir: "{app}\bin"
Source: "programs\x64_adderr.exe"; DestDir: "{app}\bin"
Source: "programs\x64_average.exe"; DestDir: "{app}\bin"
Source: "programs\x64_binomial.exe"; DestDir: "{app}\bin"
Source: "programs\x64_calcurve.exe"; DestDir: "{app}\bin"
Source: "programs\x64_chisqd.exe"; DestDir: "{app}\bin"
Source: "programs\x64_compare.exe"; DestDir: "{app}\bin"
Source: "programs\x64_csafit.exe"; DestDir: "{app}\bin"
Source: "programs\x64_deqsol.exe"; DestDir: "{app}\bin"
Source: "programs\x64_editfl.exe"; DestDir: "{app}\bin"
Source: "programs\x64_editmt.exe"; DestDir: "{app}\bin"
Source: "programs\x64_editps.exe"; DestDir: "{app}\bin"
Source: "programs\x64_eoqsol.exe"; DestDir: "{app}\bin"
Source: "programs\x64_exfit.exe"; DestDir: "{app}\bin"
Source: "programs\x64_ftest.exe"; DestDir: "{app}\bin"
Source: "programs\x64_gcfit.exe"; DestDir: "{app}\bin"
Source: "programs\x64_help.exe"; DestDir: "{app}\bin"
Source: "programs\x64_hlfit.exe"; DestDir: "{app}\bin"
Source: "programs\x64_inrate.exe"; DestDir: "{app}\bin"
Source: "programs\x64_linfit.exe"; DestDir: "{app}\bin"
Source: "programs\x64_makcsa.exe"; DestDir: "{app}\bin"
Source: "programs\x64_makdat.exe"; DestDir: "{app}\bin"
Source: "programs\x64_makfil.exe"; DestDir: "{app}\bin"
Source: "programs\x64_maklib.exe"; DestDir: "{app}\bin"
Source: "programs\x64_makmat.exe"; DestDir: "{app}\bin"
Source: "programs\x64_maksim.exe"; DestDir: "{app}\bin"
Source: "programs\x64_mmfit.exe"; DestDir: "{app}\bin"
Source: "programs\x64_normal.exe"; DestDir: "{app}\bin"
Source: "programs\x64_polnom.exe"; DestDir: "{app}\bin"
Source: "programs\x64_qnfit.exe"; DestDir: "{app}\bin"
Source: "programs\x64_rannum.exe"; DestDir: "{app}\bin"
Source: "programs\x64_rffit.exe"; DestDir: "{app}\bin"
Source: "programs\x64_rstest.exe"; DestDir: "{app}\bin"
Source: "programs\x64_sffit.exe"; DestDir: "{app}\bin"
Source: "programs\x64_simplot.exe"; DestDir: "{app}\bin"
Source: "programs\x64_simstat.exe"; DestDir: "{app}\bin"
Source: "programs\x64_spline.exe"; DestDir: "{app}\bin"
Source: "programs\x64_ttest.exe"; DestDir: "{app}\bin"
Source: "programs\x64_usermod.exe"; DestDir: "{app}\bin"


; DYNAMIC LINK LIBRARIES
Source: "c:\simfit7\dll\graphics\x64_graphics.dll"; DestDir: "{app}\bin"
Source: "c:\simfit7\dll\menus\x64_menus.dll"; DestDir: "{app}\bin"
Source: "C:\simfit7\dll\models\x64_models.dll"; DestDir: "{app}\bin"
Source: "C:\simfit7\dll\simfit\x64_simfit.dll"; DestDir: "{app}\bin"
Source: "c:\simfit7\dll\clearwin64\x64_clearwin.dll"; DestDir: "{app}\bin"
Source: "C:\simfit7\dll\numbers\x64_numbers.dll"; DestDir: "{app}\bin"
Source: "C:\simfit7\dll\maths\x64_maths.dll"; DestDir: "{app}\bin"
Source: "C:\simfit7\dll\maths\x64_academic_maths.dll"; DestDir: "{app}\bin"
Source: "C:\simfit7\dll\nag\FLW6I24DC_mkl_maths.dll"; DestDir: "{app}\bin"
Source: "C:\simfit7\dll\nag\FLW6I24DC_nag_maths.dll"; DestDir: "{app}\bin"
Source : "extras\msvcr100.dll";  DestDir: "{app}\bin"



; EXTRAS

Source: "extras\LICENSE.TXT"; DestDir: "{app}\doc"
Source: "extras\ERRORS.TXT"; DestDir: "{app}\doc"
Source: "extras\SIMFIT4.XLS"; DestDir: "{app}\doc"
Source: "extras\SIMFIT6.XLS"; DestDir: "{app}\doc"
Source: "extras\ConvertToTable.doc"; DestDir: "{app}\doc"
Source: "extras\PSCODES.PS"; DestDir: "{app}\doc"
Source: "extras\PSCODES.PDF"; DestDir: "{app}\doc"
Source: "extras\SIMFIG1.PS"; DestDir: "{app}\dem"
Source: "extras\SIMFIG2.PS"; DestDir: "{app}\dem"
Source: "extras\SIMFIG3.PS"; DestDir: "{app}\dem"
Source: "extras\SIMFIG4.PS"; DestDir: "{app}\dem"
Source: "extras\MS_OFFICE.PDF"; DestDir: "{app}\doc"
Source: "extras\SIMFONTS.PS"; DestDir: "{app}\doc"
Source: "extras\PROMOTE.PDF"; DestDir: "{app}\doc"
Source: "extras\PSFRAGEX.PS"; DestDir: "{app}\doc"
Source: "extras\PSFRAGEX.PS1"; DestDir: "{app}\doc"
Source: "extras\PSFRAGEX.PS2"; DestDir: "{app}\doc"
Source: "extras\PSFRAGEX.TEX"; DestDir: "{app}\doc"
Source: "extras\w_simfig1.cfg"; DestDir: "{app}\dem"
Source: "extras\w_simfig2.cfg"; DestDir: "{app}\dem"
Source: "extras\w_simfig3.cfg"; DestDir: "{app}\dem"
Source: "extras\w_simfig4.cfg"; DestDir: "{app}\dem"
Source: "extras\pspecial.1"; DestDir: "{app}\dem"
Source: "extras\pspecial.2"; DestDir: "{app}\dem"
Source: "extras\pspecial.3"; DestDir: "{app}\dem"
Source: "extras\templates.txt"; DestDir: "{app}\dem"
Source: "extras\version7.txt"; DestDir: "{app}\doc"
Source: "extras\speedup.pdf"; DestDir: "{app}\doc"
Source: "extras\tutorials.pdf"; DestDir: "{app}\doc"
Source: "extras\configure.pdf"; DestDir: "{app}\doc"
Source: "extras\install.pdf"; DestDir: "{app}\doc"


; MANUALS
Source: "manuals\w_manual.pdf";   DestDir: "{app}\doc"
Source: "manuals\w_examples.pdf";    DestDir: "{app}\doc"
Source: "manuals\front_page.pdf"; DestDir: "{app}\doc"
Source: "manuals\back_page.pdf";  DestDir: "{app}\doc"


; README
Source: "readme\commands.txt"; DestDir: "{app}\doc"
Source: "readme\configure.txt"; DestDir: "{app}\doc"
Source: "readme\speedup.txt"; DestDir: "{app}\doc"
Source: "readme\install.txt"; DestDir: "{app}\doc"
Source: "readme\linux.txt"; DestDir: "{app}\doc"
Source: "readme\formats.txt"; DestDir: "{app}\doc"
Source: "readme\w_readme.0"; DestDir: "{app}\doc"
Source: "readme\w_readme.index"; DestDir: "{app}\doc"
Source: "readme\w_readme.c1"; DestDir: "{app}\doc"
Source: "readme\w_readme.c2"; DestDir: "{app}\doc"
Source: "readme\w_readme.d1"; DestDir: "{app}\doc"
Source: "readme\w_readme.d2"; DestDir: "{app}\doc"
Source: "readme\w_readme.f1"; DestDir: "{app}\doc"
Source: "readme\w_readme.f2"; DestDir: "{app}\doc"
Source: "readme\w_readme.f3"; DestDir: "{app}\doc"
Source: "readme\w_readme.f4"; DestDir: "{app}\doc"
Source: "readme\w_readme.f5"; DestDir: "{app}\doc"
Source: "readme\w_readme.f6"; DestDir: "{app}\doc"
Source: "readme\w_readme.f7"; DestDir: "{app}\doc"
Source: "readme\w_readme.f8"; DestDir: "{app}\doc"
Source: "readme\w_readme.f9"; DestDir: "{app}\doc"
Source: "readme\w_readme.g1"; DestDir: "{app}\doc"
Source: "readme\w_readme.g2"; DestDir: "{app}\doc"
Source: "readme\w_readme.g3"; DestDir: "{app}\doc"
Source: "readme\w_readme.g4"; DestDir: "{app}\doc"
Source: "readme\w_readme.g5"; DestDir: "{app}\doc"
Source: "readme\w_readme.g6"; DestDir: "{app}\doc"
Source: "readme\w_readme.g7"; DestDir: "{app}\doc"
Source: "readme\w_readme.g8"; DestDir: "{app}\doc"
Source: "readme\w_readme.g9"; DestDir: "{app}\doc"
Source: "readme\w_readme.g10"; DestDir: "{app}\doc"
Source: "readme\w_readme.g11"; DestDir: "{app}\doc"
Source: "readme\w_readme.i0"; DestDir: "{app}\doc"
Source: "readme\w_readme.i1"; DestDir: "{app}\doc"
Source: "readme\w_readme.i2"; DestDir: "{app}\doc"
Source: "readme\readme.txt"; DestDir: "{app}\doc"
Source: "readme\readme.1st"; DestDir: "{app}\doc"
Source: "readme\w_readme.s1"; DestDir: "{app}\doc"
Source: "readme\w_readme.s2"; DestDir: "{app}\doc"

; DATA
Source: "data\ADDERR.TF1"; DestDir: "{app}\dem"
Source: "data\ADDERR.TF2"; DestDir: "{app}\dem"
Source: "data\ANOVA1.TF1"; DestDir: "{app}\dem"
Source: "data\ANOVA1.TFL"; DestDir: "{app}\dem"
Source: "data\ANOVA2.TF1"; DestDir: "{app}\dem"
Source: "data\ANOVA2.TF2"; DestDir: "{app}\dem"
Source: "data\ANOVA3.TF1"; DestDir: "{app}\dem"
Source: "data\ANOVA4.TF1"; DestDir: "{app}\dem"
Source: "data\ANOVA5.TF1"; DestDir: "{app}\dem"
Source: "data\ANOVA5.TF2"; DestDir: "{app}\dem"
Source: "data\ANOVA5.TF3"; DestDir: "{app}\dem"
Source: "data\ANOVA5.TF4"; DestDir: "{app}\dem"
Source: "data\ANOVA6.TF1"; DestDir: "{app}\dem"
Source: "data\AVERAGE.TF1"; DestDir: "{app}\dem"
Source: "data\BARCHART.TF1"; DestDir: "{app}\dem"
Source: "data\BARCHART.TF2"; DestDir: "{app}\dem"
Source: "data\BARCHART.TF3"; DestDir: "{app}\dem"
Source: "data\BARCHART.TF4"; DestDir: "{app}\dem"
Source: "data\BARCHART.TF5"; DestDir: "{app}\dem"
Source: "data\BARCHART.TF6"; DestDir: "{app}\dem"
Source: "data\BARCHART.TF7"; DestDir: "{app}\dem"
Source: "data\BARCHT3D.TF1"; DestDir: "{app}\dem"
Source: "data\BARCHT3D.TF2"; DestDir: "{app}\dem"
Source: "data\BARCHT3D.TF3"; DestDir: "{app}\dem"
Source: "data\BINOMIAL.TF1"; DestDir: "{app}\dem"
Source: "data\BINOMIAL.TF2"; DestDir: "{app}\dem"
Source: "data\BINOMIAL.TF3"; DestDir: "{app}\dem"
Source: "data\CALCURVE.TF1"; DestDir: "{app}\dem"
Source: "data\CALCURVE.TF2"; DestDir: "{app}\dem"
Source: "data\CALCURVE.TF3"; DestDir: "{app}\dem"
Source: "data\CAMALOT.MOD"; DestDir: "{app}\dem"
Source: "data\CHEBY.MOD"; DestDir: "{app}\dem"
Source: "data\CHEBY.DATA"; DestDir: "{app}\dem"
Source: "data\CHISQD.TF1"; DestDir: "{app}\dem"
Source: "data\CHISQD.TF2"; DestDir: "{app}\dem"
Source: "data\CHISQD.TF3"; DestDir: "{app}\dem"
Source: "data\CHISQD.TF4"; DestDir: "{app}\dem"
Source: "data\CHISQD.TF5"; DestDir: "{app}\dem"
Source: "data\CHISQD.TF5"; DestDir: "{app}\dem"
Source: "data\CLUSTER.TF1"; DestDir: "{app}\dem"
Source: "data\CLUSTER.TF2"; DestDir: "{app}\dem"
Source: "data\COCHRANQ.TF1"; DestDir: "{app}\dem"
Source: "data\COCHRANQ.TF2"; DestDir: "{app}\dem"
Source: "data\COLUMN1.TF1"; DestDir: "{app}\dem"
Source: "data\COLUMN1.TF2"; DestDir: "{app}\dem"
Source: "data\COLUMN1.TF3"; DestDir: "{app}\dem"
Source: "data\COLUMN1.TF4"; DestDir: "{app}\dem"
Source: "data\COLUMN1.TF5"; DestDir: "{app}\dem"
Source: "data\COLUMN2.TF1"; DestDir: "{app}\dem"
Source: "data\COLUMN2.TF2"; DestDir: "{app}\dem"
Source: "data\COLUMN2.TF3"; DestDir: "{app}\dem"
Source: "data\COMPARE.TF1"; DestDir: "{app}\dem"
Source: "data\COMPARE.TF2"; DestDir: "{app}\dem"
Source: "data\CONSEC3.MOD"; DestDir: "{app}\dem"
Source: "data\CONSEC3.TFL"; DestDir: "{app}\dem"
Source: "data\CONSEC3_A.DATA"; DestDir: "{app}\dem"
Source: "data\CONSEC3_B.DATA"; DestDir: "{app}\dem"
Source: "data\CONSEC3_C.DATA"; DestDir: "{app}\dem"
Source: "data\CONSEC5.TF1"; DestDir: "{app}\dem"
Source: "data\CONSEC5.TF2"; DestDir: "{app}\dem"
Source: "data\CONSEC5.TF3"; DestDir: "{app}\dem"
Source: "data\CONSEC5.TF4"; DestDir: "{app}\dem"
Source: "data\CONSEC5.TF5"; DestDir: "{app}\dem"
Source: "data\CONSEC5.TFL"; DestDir: "{app}\dem"
Source: "data\CONVOLVE.MOD"; DestDir: "{app}\dem"
Source: "data\CONVOLV3.MOD"; DestDir: "{app}\dem"
Source: "data\CONVOLV3.TFL"; DestDir: "{app}\dem"
Source: "data\CONVOLV3.DATA"; DestDir: "{app}\dem"
Source: "data\COX.TF1"; DestDir: "{app}\dem"
Source: "data\COX.TF2"; DestDir: "{app}\dem"
Source: "data\COX.TF3"; DestDir: "{app}\dem"
Source: "data\COX.TF4"; DestDir: "{app}\dem"
Source: "data\CSADAT.TF1"; DestDir: "{app}\dem"
Source: "data\CSADAT.TF2"; DestDir: "{app}\dem"
Source: "data\CSAFIT.TF1"; DestDir: "{app}\dem"
Source: "data\CSAFIT.TF2"; DestDir: "{app}\dem"
Source: "data\CSAFIT.TF3"; DestDir: "{app}\dem"
Source: "data\DBLE_EXP.MOD"; DestDir: "{app}\dem"
Source: "data\DEQMAT.TF1"; DestDir: "{app}\dem"
Source: "data\DEQMAT.TF2"; DestDir: "{app}\dem"
Source: "data\DEQMOD1.TF1"; DestDir: "{app}\dem"
Source: "data\DEQMOD1.TF2"; DestDir: "{app}\dem"
Source: "data\DEQMOD1.TF3"; DestDir: "{app}\dem"
Source: "data\DEQMOD1.TF4"; DestDir: "{app}\dem"
Source: "data\DEQMOD1.TF5"; DestDir: "{app}\dem"
Source: "data\DEQMOD1.TF6"; DestDir: "{app}\dem"
Source: "data\DEQMOD2.TF1"; DestDir: "{app}\dem"
Source: "data\DEQMOD2.TF2"; DestDir: "{app}\dem"
Source: "data\DEQMOD2.TF3"; DestDir: "{app}\dem"
Source: "data\DEQMOD3.TF1"; DestDir: "{app}\dem"
Source: "data\DEQMOD3.TF2"; DestDir: "{app}\dem"
Source: "data\DEQMOD4.TF1"; DestDir: "{app}\dem"
Source: "data\DEQPAR1.TF1"; DestDir: "{app}\dem"
Source: "data\DEQPAR1.TF2"; DestDir: "{app}\dem"
Source: "data\DEQPAR1.TF3"; DestDir: "{app}\dem"
Source: "data\DEQPAR1.TF4"; DestDir: "{app}\dem"
Source: "data\DEQPAR1.TF5"; DestDir: "{app}\dem"
Source: "data\DEQPAR1.TF6"; DestDir: "{app}\dem"
Source: "data\DEQPAR2.TF1"; DestDir: "{app}\dem"
Source: "data\DEQPAR2.TF2"; DestDir: "{app}\dem"
Source: "data\DEQPAR2.TF3"; DestDir: "{app}\dem"
Source: "data\DEQPAR4.TF1"; DestDir: "{app}\dem"
Source: "data\DEQSOL.TF1"; DestDir: "{app}\dem"
Source: "data\DEQSOL.TF2"; DestDir: "{app}\dem"
Source: "data\DEQSOL.TF3"; DestDir: "{app}\dem"
Source: "data\DEQSOL.TFL"; DestDir: "{app}\dem"
Source: "data\EDITFL.TF1"; DestDir: "{app}\dem"
Source: "data\EDITFL.TF2"; DestDir: "{app}\dem"
Source: "data\EDITFL.TF3"; DestDir: "{app}\dem"
Source: "data\EDITFL.TF4"; DestDir: "{app}\dem"
Source: "data\EDITMT.TF1"; DestDir: "{app}\dem"
Source: "data\EDITMT.TF2"; DestDir: "{app}\dem"
Source: "data\EDITMT.TF3"; DestDir: "{app}\dem"
Source: "data\EDITPS.TFL"; DestDir: "{app}\dem"
Source: "data\ELLIPSE.MOD"; DestDir: "{app}\dem"
Source: "data\EPIDEMIC.TFL"; DestDir: "{app}\dem"
Source: "data\ERRORBAR.TF1"; DestDir: "{app}\dem"
Source: "data\ERRORBAR.TF2"; DestDir: "{app}\dem"
Source: "data\EXFIT.TF1"; DestDir: "{app}\dem"
Source: "data\EXFIT.TF2"; DestDir: "{app}\dem"
Source: "data\EXFIT.TF3"; DestDir: "{app}\dem"
Source: "data\EXFIT.TF4"; DestDir: "{app}\dem"
Source: "data\EXFIT.TF5"; DestDir: "{app}\dem"
Source: "data\EXFIT.TF6"; DestDir: "{app}\dem"
Source: "data\EXFIT.TF7"; DestDir: "{app}\dem"
Source: "data\EXFIT-TF4.PLF"; DestDir: "{app}\dem"
Source: "data\FAMILY2D.MOD"; DestDir: "{app}\dem"
Source: "data\FAMILY3D.MOD"; DestDir: "{app}\dem"
Source: "data\FTEST.TF1"; DestDir: "{app}\dem"
Source: "data\GAUSS3.TF1"; DestDir: "{app}\dem"
Source: "data\GAUSS3-TF1.PLF"; DestDir: "{app}\dem"
Source: "data\GCFIT.TF1"; DestDir: "{app}\dem"
Source: "data\GCFIT.TF2"; DestDir: "{app}\dem"
Source: "data\GCFIT.TF3"; DestDir: "{app}\dem"
Source: "data\GCFIT.TF4"; DestDir: "{app}\dem"
Source: "data\GCFIT.TF5"; DestDir: "{app}\dem"
Source: "data\GCFIT.TF6"; DestDir: "{app}\dem"
Source: "data\GLM.TF1"; DestDir: "{app}\dem"
Source: "data\GLM.TF2"; DestDir: "{app}\dem"
Source: "data\GLM.TF3"; DestDir: "{app}\dem"
Source: "data\GLM.TF4"; DestDir: "{app}\dem"
Source: "data\GOMPERTZ.TF1"; DestDir: "{app}\dem"
Source: "data\HELIX.MOD"; DestDir: "{app}\dem"
Source: "data\HOTCOLD.TF1"; DestDir: "{app}\dem"
Source: "data\HOTEL.TF1"; DestDir: "{app}\dem"
Source: "data\HOUSES.TF1"; DestDir: "{app}\dem"
Source: "data\HLFIT.TF1"; DestDir: "{app}\dem"
Source: "data\HLFIT.TF2"; DestDir: "{app}\dem"
Source: "data\HLFIT.TF3"; DestDir: "{app}\dem"
Source: "data\HLFIT.TF4"; DestDir: "{app}\dem"
Source: "data\HLFIT-TF4.PLF"; DestDir: "{app}\dem"
Source: "data\IF.MOD"; DestDir: "{app}\dem"
Source: "data\IMAGES.TFL"; DestDir: "{app}\dem"
Source: "data\IMPULSE.MOD"; DestDir: "{app}\dem"
Source: "data\INHIBIT.TF1"; DestDir: "{app}\dem"
Source: "data\INHIBIT.TFL"; DestDir: "{app}\dem"
Source: "data\INHIBITA.DATA"; DestDir: "{app}\dem"
Source: "data\INHIBITB.DATA"; DestDir: "{app}\dem"
Source: "data\INHIBITC.DATA"; DestDir: "{app}\dem"
Source: "data\INHIBITD.DATA"; DestDir: "{app}\dem"
Source: "data\INHIBITE.DATA"; DestDir: "{app}\dem"
Source: "data\INHIBITF.DATA"; DestDir: "{app}\dem"
Source: "data\INHIBITG.DATA"; DestDir: "{app}\dem"
Source: "data\INHIBITH.DATA"; DestDir: "{app}\dem"
Source: "data\INHIBITI.DATA"; DestDir: "{app}\dem"
Source: "data\INHIBITJ.DATA"; DestDir: "{app}\dem"
Source: "data\INHIBITK.DATA"; DestDir: "{app}\dem"
Source: "data\INRATE.TF1"; DestDir: "{app}\dem"
Source: "data\INRATE.TF2"; DestDir: "{app}\dem"
Source: "data\INRATE.TF3"; DestDir: "{app}\dem"
Source: "data\IRIS.TF1"; DestDir: "{app}\dem"
Source: "data\IRIS.TF2"; DestDir: "{app}\dem"
Source: "data\KENDALL.TF1"; DestDir: "{app}\dem"
Source: "data\KMEANS.TF1"; DestDir: "{app}\dem"
Source: "data\KMEANS.TF2"; DestDir: "{app}\dem"
Source: "data\INRATE.TF4"; DestDir: "{app}\dem"
Source: "data\LABELS.TF1"; DestDir: "{app}\dem"
Source: "data\LATINSQ.TF1"; DestDir: "{app}\dem"
Source: "data\LD50.TF1"; DestDir: "{app}\dem"
Source: "data\LD50.TF2"; DestDir: "{app}\dem"
Source: "data\LD50.TF3"; DestDir: "{app}\dem"
Source: "data\LINE.TF1"; DestDir: "{app}\dem"
Source: "data\LINE.TF2"; DestDir: "{app}\dem"
Source: "data\LINE1.DATA"; DestDir: "{app}\dem"
Source: "data\LINE2.DATA"; DestDir: "{app}\dem"
Source: "data\LINE3.DATA"; DestDir: "{app}\dem"
Source: "data\LINE3.MOD"; DestDir: "{app}\dem"
Source: "data\LINE3.TFL"; DestDir: "{app}\dem"
Source: "data\LINFIT.TF1"; DestDir: "{app}\dem"
Source: "data\LINFIT.TF2"; DestDir: "{app}\dem"
Source: "data\LOGISTIC.TF1"; DestDir: "{app}\dem"
Source: "data\LOGISTIC.TF2"; DestDir: "{app}\dem"
Source: "data\LOGISTIC.TF3"; DestDir: "{app}\dem"
Source: "data\LOGISTIC.TF4"; DestDir: "{app}\dem"
Source: "data\LOGISTIC.TF5"; DestDir: "{app}\dem" 
Source: "data\LOGLIN.TF1"; DestDir: "{app}\dem"
Source: "data\LV1.TF1"; DestDir: "{app}\dem"
Source: "data\LV2.TF1"; DestDir: "{app}\dem"
Source: "data\MAKSIM.TF1"; DestDir: "{app}\dem"
Source: "data\MAKSIM.TF2"; DestDir: "{app}\dem"
Source: "data\MANOVA1.TF1"; DestDir: "{app}\dem"
Source: "data\MANOVA1.TF2"; DestDir: "{app}\dem"
Source: "data\MANOVA1.TF3"; DestDir: "{app}\dem"
Source: "data\MANOVA1.TF4"; DestDir: "{app}\dem"
Source: "data\MANOVA1.TF5"; DestDir: "{app}\dem"
Source: "data\MATRIX.TF1"; DestDir: "{app}\dem"
Source: "data\MATRIX.TF2"; DestDir: "{app}\dem"
Source: "data\MATRIX.TF3"; DestDir: "{app}\dem"
Source: "data\MATRIX.TF4"; DestDir: "{app}\dem"
Source: "data\MATRIX.TF5"; DestDir: "{app}\dem"
Source: "data\MCNEMAR.TF1"; DestDir: "{app}\dem"
Source: "data\MCNEMAR.TF2"; DestDir: "{app}\dem"
Source: "data\MCNEMAR.TF3"; DestDir: "{app}\dem"
Source: "data\META.TF1"; DestDir: "{app}\dem"
Source: "data\META.TF2"; DestDir: "{app}\dem"
Source: "data\META.TF3"; DestDir: "{app}\dem"
Source: "data\META.TF4"; DestDir: "{app}\dem"
Source: "data\METAFILE.TF1"; DestDir: "{app}\dem"
Source: "data\METAFILE.TF2"; DestDir: "{app}\dem"
Source: "data\METAFILE.TF3"; DestDir: "{app}\dem"
Source: "data\METAFILE.TF4"; DestDir: "{app}\dem"
Source: "data\METAFILE.TF5"; DestDir: "{app}\dem"
Source: "data\METAFILE.TF6"; DestDir: "{app}\dem"
Source: "data\METAFILE.TF7"; DestDir: "{app}\dem"
Source: "data\METAFILE.TF8"; DestDir: "{app}\dem"
Source: "data\MMFIT.TF1"; DestDir: "{app}\dem"
Source: "data\MMFIT.TF2"; DestDir: "{app}\dem"
Source: "data\MMFIT.TF3"; DestDir: "{app}\dem"
Source: "data\MMFIT.TF4"; DestDir: "{app}\dem"
Source: "data\MMFIT-TF4.PLF"; DestDir: "{app}\dem"
Source: "data\NEGATIVE.PLF"; DestDir: "{app}\dem"
Source: "data\NORMAL.TF1"; DestDir: "{app}\dem"
Source: "data\NORMAL.TF2"; DestDir: "{app}\dem"
Source: "data\NPCORR.TF1"; DestDir: "{app}\dem"
Source: "data\NPCORR.TF2"; DestDir: "{app}\dem"
Source: "data\NPCORR.TFL"; DestDir: "{app}\dem"
Source: "data\OPTIMUM.MOD"; DestDir: "{app}\dem"
Source: "data\ORBIT.TF1"; DestDir: "{app}\dem"
Source: "data\ORBIT.TF2"; DestDir: "{app}\dem"
Source: "data\ORBIT.TF3"; DestDir: "{app}\dem"
Source: "data\ORBIT.TF4"; DestDir: "{app}\dem"
Source: "data\ORBIT.TF5"; DestDir: "{app}\dem"
Source: "data\ORBIT.TF6"; DestDir: "{app}\dem"
Source: "data\ORBIT.TFL"; DestDir: "{app}\dem"
Source: "data\PACORR.TF1"; DestDir: "{app}\dem"
Source: "data\PERIODIC.MOD"; DestDir: "{app}\dem"
Source: "data\PIECHART.TF1"; DestDir: "{app}\dem"
Source: "data\PIECHART.TF2"; DestDir: "{app}\dem"
Source: "data\PIECHART.TF3"; DestDir: "{app}\dem"
Source: "data\POISSON.TF1"; DestDir: "{app}\dem"
Source: "data\POISSON.TF2"; DestDir: "{app}\dem"
Source: "data\PLOT2.TF1"; DestDir: "{app}\dem"
Source: "data\PLOT2.TF2"; DestDir: "{app}\dem"
Source: "data\PLOT2.TF3"; DestDir: "{app}\dem"
Source: "data\PLS_X.TF1"; DestDir: "{app}\dem"
Source: "data\PLS_Y.TF1"; DestDir: "{app}\dem"
Source: "data\PLS_Z.TF1"; DestDir: "{app}\dem"
Source: "data\POLNOM.TF1"; DestDir: "{app}\dem"
Source: "data\POLNOM.TF2"; DestDir: "{app}\dem"
Source: "data\POLNOM.TF3"; DestDir: "{app}\dem"
Source: "data\POLNOM.TF4"; DestDir: "{app}\dem"
Source: "data\POLNOM-TF1.PLF"; DestDir: "{app}\dem"
Source: "data\POSITIVE.PLF"; DestDir: "{app}\dem"
Source: "data\QNFIT.TF1"; DestDir: "{app}\dem"
Source: "data\QNFIT.TF2"; DestDir: "{app}\dem"
Source: "data\QNFIT.TF3"; DestDir: "{app}\dem"
Source: "data\QNFIT.TFL"; DestDir: "{app}\dem"
Source: "data\QNFIT_ODE.TF1"; DestDir: "{app}\dem"
Source: "data\QNFIT_ODE.TF2"; DestDir: "{app}\dem"
Source: "data\QNFIT_ODE.TF3"; DestDir: "{app}\dem"
Source: "data\RFFIT.TF1"; DestDir: "{app}\dem"
Source: "data\RFFIT.TF2"; DestDir: "{app}\dem"
Source: "data\RFFIT.TF3"; DestDir: "{app}\dem"
Source: "data\RFFIT.TF4"; DestDir: "{app}\dem"
Source: "data\RFFIT.TF5"; DestDir: "{app}\dem"
Source: "data\RFFIT.TF6"; DestDir: "{app}\dem"
Source: "data\RFFIT.TF7"; DestDir: "{app}\dem"
Source: "data\ROBUST.TF1"; DestDir: "{app}\dem"
Source: "data\ROSE.MOD"; DestDir: "{app}\dem"
Source: "data\RSTEST.TF1"; DestDir: "{app}\dem"
Source: "data\SFFIT.TF1"; DestDir: "{app}\dem"
Source: "data\SFFIT.TF2"; DestDir: "{app}\dem"
Source: "data\SFFIT.TF3"; DestDir: "{app}\dem"
Source: "data\SFFIT.TF4"; DestDir: "{app}\dem"
Source: "data\SFFIT-TF4.PLF"; DestDir: "{app}\dem"
Source: "data\SIMFIG1.TFL"; DestDir: "{app}\dem"
Source: "data\SIMFIG2.TFL"; DestDir: "{app}\dem"
Source: "data\SIMFIG3.TFL"; DestDir: "{app}\dem"
Source: "data\SIMFIG3A.DATA"; DestDir: "{app}\dem"
Source: "data\SIMFIG3B.DATA"; DestDir: "{app}\dem"
Source: "data\SIMFIG3C.DATA"; DestDir: "{app}\dem"
Source: "data\SIMFIG3D.DATA"; DestDir: "{app}\dem"
Source: "data\SIMFIG4.TFL"; DestDir: "{app}\dem"
Source: "data\SIMFIG4A.DATA"; DestDir: "{app}\dem"
Source: "data\SIMFIG4B.DATA"; DestDir: "{app}\dem"
Source: "data\SIMPLOT.TF1"; DestDir: "{app}\dem"
Source: "data\SIMPLOT.TF2"; DestDir: "{app}\dem"
Source: "data\SIMPLOT.TF3"; DestDir: "{app}\dem"
Source: "data\SIMPLOT.TFL"; DestDir: "{app}\dem"
Source: "data\SPIRAL.TF1"; DestDir: "{app}\dem"
Source: "data\SPIRAL.TF2"; DestDir: "{app}\dem"
Source: "data\SPIRAL.TF1"; DestDir: "{app}\dem"
Source: "data\SPIRAL.TFL"; DestDir: "{app}\dem"
Source: "data\SPLINE.TF1"; DestDir: "{app}\dem"
Source: "data\SPLINE.TF2"; DestDir: "{app}\dem"
Source: "data\SPLINE.TF3"; DestDir: "{app}\dem"
Source: "data\STRATA.TF1"; DestDir: "{app}\dem"
Source: "data\SURFACE.TF1"; DestDir: "{app}\dem"
Source: "data\SURFACE.TF2"; DestDir: "{app}\dem"
Source: "data\SURFACE.TF3"; DestDir: "{app}\dem"
Source: "data\SURFACE.TF4"; DestDir: "{app}\dem"
Source: "data\SURVIVE.TF1"; DestDir: "{app}\dem"
Source: "data\SURVIVE.TF2"; DestDir: "{app}\dem"
Source: "data\SURVIVE.TF3"; DestDir: "{app}\dem"
Source: "data\SURVIVE.TF4"; DestDir: "{app}\dem"
Source: "data\SURVIVE.TF5"; DestDir: "{app}\dem"
Source: "data\SURVIVE.TF6"; DestDir: "{app}\dem"
Source: "data\SWARM.TF1"; DestDir: "{app}\dem"
Source: "data\TANGENT.MOD"; DestDir: "{app}\dem"
Source: "data\TRINOM.TF1"; DestDir: "{app}\dem"
Source: "data\TRINOM.TF2"; DestDir: "{app}\dem"
Source: "data\TRINOM.TF3"; DestDir: "{app}\dem"
Source: "data\TIMES.TF1"; DestDir: "{app}\dem"
Source: "data\TTEST.TF1"; DestDir: "{app}\dem"
Source: "data\TTEST.TF2"; DestDir: "{app}\dem"
Source: "data\TTEST.TF3"; DestDir: "{app}\dem"
Source: "data\TTEST.TF4"; DestDir: "{app}\dem"
Source: "data\TTEST.TF5"; DestDir: "{app}\dem"
Source: "data\TTEST.TF6"; DestDir: "{app}\dem"
Source: "data\TUKEYQ.TF1"; DestDir: "{app}\dem"
Source: "data\TWISTER.MOD"; DestDir: "{app}\dem"
Source: "data\UKMAP.TF1"; DestDir: "{app}\dem"
Source: "data\UKMAP.TF2"; DestDir: "{app}\dem"
Source: "data\UKMAP.TF3"; DestDir: "{app}\dem"
Source: "data\UNCONSTRAINED.PLF"; DestDir: "{app}\dem"
Source: "data\UPDOWN.MOD"; DestDir: "{app}\dem"
Source: "data\UPDOWNUP.MOD"; DestDir: "{app}\dem"
Source: "data\USERMOD1.TF1"; DestDir: "{app}\dem"
Source: "data\USERMOD1.TF2"; DestDir: "{app}\dem"
Source: "data\USERMOD1.TF3"; DestDir: "{app}\dem"
Source: "data\USERMOD1.TF4"; DestDir: "{app}\dem"
Source: "data\USERMOD1.TF5"; DestDir: "{app}\dem"
Source: "data\USERMOD1.TF6"; DestDir: "{app}\dem"
Source: "data\USERMOD1.TF7"; DestDir: "{app}\dem"
Source: "data\USERMOD1.TF8"; DestDir: "{app}\dem"
Source: "data\USERMOD1.TF9"; DestDir: "{app}\dem"
Source: "data\USERMOD2.TF1"; DestDir: "{app}\dem"
Source: "data\USERMOD3.TF1"; DestDir: "{app}\dem"
Source: "data\USERMOD4.TF1"; DestDir: "{app}\dem"
Source: "data\USERMODD.TF1"; DestDir: "{app}\dem"
Source: "data\USERMODN.TF1"; DestDir: "{app}\dem"
Source: "data\USERMODN.TF2"; DestDir: "{app}\dem"
Source: "data\USERMODN.TF3"; DestDir: "{app}\dem"
Source: "data\USERMODN.TF4"; DestDir: "{app}\dem"
Source: "data\USERMODS.TF1"; DestDir: "{app}\dem"
Source: "data\USERMODS.TF2"; DestDir: "{app}\dem"
Source: "data\USERMODS.TF3"; DestDir: "{app}\dem"
Source: "data\USERMODX.TF1"; DestDir: "{app}\dem"
Source: "data\USERMODX.TF2"; DestDir: "{app}\dem"
Source: "data\USERMODX.TF3"; DestDir: "{app}\dem"
Source: "data\USERMODX.TF4"; DestDir: "{app}\dem"
Source: "data\USERMODX.TF5"; DestDir: "{app}\dem"
Source: "data\USER1.MOD"; DestDir: "{app}\dem"
Source: "data\VECTOR.TF1"; DestDir: "{app}\dem"
Source: "data\VECTOR.TF2"; DestDir: "{app}\dem"
Source: "data\VECTOR.TF3"; DestDir: "{app}\dem"
Source: "data\VFIELD.TF1"; DestDir: "{app}\dem"
Source: "data\VFIELD.TF2"; DestDir: "{app}\dem"
Source: "data\WEIBULL.TF1"; DestDir: "{app}\dem"
Source: "data\WILCOXON.TF1"; DestDir: "{app}\dem"
Source: "data\WILCOXON.TF2"; DestDir: "{app}\dem"
Source: "data\Y1.DATA"; DestDir: "{app}\dem"
Source: "data\Y2.DATA"; DestDir: "{app}\dem"
Source: "data\Y3.DATA"; DestDir: "{app}\dem"
Source: "data\ZIGZAG.TF1"; DestDir: "{app}\dem"
Source: "NAG\LIST.NAG"; DestDir: "{app}\dem"
Source: "NAG\C05ADF.MOD"; DestDir: "{app}\dem"
Source: "NAG\C05NBF.MOD"; DestDir: "{app}\dem"
Source: "NAG\D01AJF.MOD"; DestDir: "{app}\dem"
Source: "NAG\D01EAF.MOD"; DestDir: "{app}\dem"
Source: "NAG\D01FCF.MOD"; DestDir: "{app}\dem"
Source: "NAG\C02AGF.TF1"; DestDir: "{app}\dem"
Source: "NAG\E02ADF.TF1"; DestDir: "{app}\dem"
Source: "NAG\E02BAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\E02BAF.TF2"; DestDir: "{app}\dem"
Source: "NAG\E02BEF.TF1"; DestDir: "{app}\dem"
Source: "NAG\E04FYF.TF1"; DestDir: "{app}\dem"
Source: "NAG\E04FYF.MOD"; DestDir: "{app}\dem"
Source: "NAG\F01ABF.TF1"; DestDir: "{app}\dem"
Source: "NAG\F01BLF.TF1"; DestDir: "{app}\dem"
Source: "NAG\F02FDF.TF1"; DestDir: "{app}\dem"
Source: "NAG\F02WEF.TF1"; DestDir: "{app}\dem"
Source: "NAG\F02WEF.TF2"; DestDir: "{app}\dem"
Source: "NAG\F02FDF.TF2"; DestDir: "{app}\dem"
Source: "NAG\F03AAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\F03AEF.TF1"; DestDir: "{app}\dem"
Source: "NAG\F07FDF.TF1"; DestDir: "{app}\dem"
Source: "NAG\F08KFF.TF1"; DestDir: "{app}\dem"
Source: "NAG\F08KFF.TF2"; DestDir: "{app}\dem"
Source: "NAG\G02BAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G02BNF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G02BYF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G02CAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G02DAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G02GAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G02GBF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G02GCF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G02GDF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G02HAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G02LAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G02LAF.TF2"; DestDir: "{app}\dem"
Source: "NAG\G02LAF.TF3"; DestDir: "{app}\dem"
Source: "NAG\G03AAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03ACF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03ADF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03BAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03BCF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03BCF.TF2"; DestDir: "{app}\dem"
Source: "NAG\G03CAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03CCF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03DAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03DBF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03DCF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03EAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03ECF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03EFF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03EFF.TF2"; DestDir: "{app}\dem"
Source: "NAG\G03EHF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03EJF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03FAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G04ADF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G04AEF.TFL"; DestDir: "{app}\dem"
Source: "NAG\G04CAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G07BEF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G08ACF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G08ACF.TF2"; DestDir: "{app}\dem"
Source: "NAG\G08AEF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G08AFF.TFL"; DestDir: "{app}\dem"
Source: "NAG\G08AHF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G08AHF.TF2"; DestDir: "{app}\dem"
Source: "NAG\G08BAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G08BAF.TF2"; DestDir: "{app}\dem"
Source: "NAG\G08CBF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G08DAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G08EAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G08AGF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G08AGF.TF2"; DestDir: "{app}\dem"
Source: "NAG\G08RAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G08RBF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G10ABF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G10CAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G11CAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G12AAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G12AAF.TF2"; DestDir: "{app}\dem"
Source: "NAG\G12BAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G13DMF.TF1"; DestDir: "{app}\dem"
Source: "NAG\J06SBF.TF1"; DestDir: "{app}\dem"
Source: "EPS\WAVES.EPS";            DestDir: "{app}\dem"
Source: "EPS\ROSENBROCK.EPS";       DestDir: "{app}\dem"
Source: "EPS\DENDROGRAM.EPS";       DestDir: "{app}\dem"
Source: "EPS\TRINOM.EPS";           DestDir: "{app}\dem"
Source: "EPS\PSFRAG_CDF.EPS";       DestDir: "{app}\dem"
Source: "EPS\PSFRAG_EQUATION.EPS";  DestDir: "{app}\dem"
Source: "EPS\UKMAP.EPS";            DestDir: "{app}\dem"
Source: "EPS\DIFFUSION.EPS";        DestDir: "{app}\dem"
Source: "EPS\ROSE.EPS";             DestDir: "{app}\dem"
Source: "EPS\GAUSS3.EPS";           DestDir: "{app}\dem"
Source: "EPS\CONVOLUTION.EPS";      DestDir: "{app}\dem"
Source: "EPS\SCATCHARD.EPS";        DestDir: "{app}\dem"
Source: "EPS\META.EPS";             DestDir: "{app}\dem"
Source: "EPS\SPLINES.EPS";          DestDir: "{app}\dem"
Source: "EPS\NORMAL_CDF.EPS";       DestDir: "{app}\dem"
Source: "EPS\SURVIVAL.EPS";         DestDir: "{app}\dem"
Source: "EPS\CYLINDER.EPS";         DestDir: "{app}\dem"
Source: "EPS\BETA.EPS";             DestDir: "{app}\dem"
Source: "EPS\PHASEPORTRAIT.EPS";    DestDir: "{app}\dem"
Source: "EPS\ORBITS.EPS";           DestDir: "{app}\dem"
Source: "EPS\PERSPEC1.EPS";         DestDir: "{app}\dem"
Source: "EPS\PERSPEC2.EPS";         DestDir: "{app}\dem"
Source: "EPS\BIPLOT.EPS";           DestDir: "{app}\dem"
Source: "EPS\TRIPLOT.EPS";          DestDir: "{app}\dem"
Source: "EPS\SCATTER3D.EPS";        DestDir: "{app}\dem"
Source: "EPS\PACF.EPS";             DestDir: "{app}\dem"
Source: "EPS\ARIMA.EPS";            DestDir: "{app}\dem"
Source: "EPS\ANOVA.EPS";            DestDir: "{app}\dem"
Source: "EPS\CSAFIT.EPS";           DestDir: "{app}\dem"
Source: "EPS\ELLIPSES_C.EPS";       DestDir: "{app}\dem"
Source: "EPS\VENN_C.EPS";           DestDir: "{app}\dem"
Source: "EPS\CENTROID_C.EPS";       DestDir: "{app}\dem"
Source: "EPS\INSET.EPS";            DestDir: "{app}\dem"
Source: "EPS\EXTRAPOLATE.EPS";      DestDir: "{app}\dem"
Source: "EPS\EPIDEMIC.EPS";         DestDir: "{app}\dem"
Source: "EPS\SURFACE3D.EPS";        DestDir: "{app}\dem"
Source: "data\metafile.tf1";    DestDir: "{app}\dem"
Source: "data\metafile.tf2";    DestDir: "{app}\dem"
Source: "data\metafile.tf3";    DestDir: "{app}\dem"
Source: "data\metafile.tf4";    DestDir: "{app}\dem"
Source: "data\metafile.tf5";    DestDir: "{app}\dem"
Source: "data\metafile.tf6";    DestDir: "{app}\dem"
Source: "data\metafile.tf7";    DestDir: "{app}\dem"
Source: "data\metafile.tf8";    DestDir: "{app}\dem"



[Icons]
Name: "{group}\64-bit Simfit"; Filename: "{app}\bin\x64_simfit.exe"; WorkingDir: "{app}\bin"; Comment: "Simfit: A package for simulation, curve fitting, statistical analysis and graph plotting. "
Name: "{group}\64-bit Simfit Reference Manual PDF"; Filename: "{app}\doc\w_manual.pdf"
Name: "{group}\64-bit Simfit Worked Examples PDF"; Filename: "{app}\doc\w_examples.pdf"

[Registry]
Root: HKCU; Subkey: "Software\University of Manchester"; Flags: uninsdeletekeyifempty
Root: HKCU; Subkey: "Software\University of Manchester\Simfit"; Flags: uninsdeletekey
Root: HKLM; Subkey: "Software\University of Manchester"; Flags: uninsdeletekeyifempty
Root: HKLM; Subkey: "Software\University of Manchester\Simfit"; Flags: uninsdeletekey
Root: HKLM; Subkey: "Software\University of Manchester\Simfit\Settings"; ValueType: string; ValueName: "Path"; ValueData: "{app}"


