 %
Example: storing data for a Chebyshev approximation
===================================================

f(x) = [Chebyshev expansion of exp(x)] - exp(x)

Note that only half of coefficient 1 is used and x is
is reflected into (-1,1) by the command middle. The
command cheby(x,m,n) returns zero for x outside (-1,1)

Chebyshev coefficients can be set individually using
the command store(.) or initialised globally using
the command storef(.) with filename, e.g. cheby.data.
Comment lines begin with a !

 %
 1 equation
 1 variable
 0 parameters
 %
!***********************************************************
!The next 10 lines would set the 5 coefficients individually
!***********************************************************
!2.532132
!1.130318
!0.271495
!0.044337
!0.005474
!store(5)
!store(4)
!store(3)
!store(2)
!store(1)
!****************************************************************
!Alternatively, the next line sets the 5 coefficients from a file
!****************************************************************
 storef(cheby.data)
!************************************************
!The next 5 lines ensure that -1 =< argument =< 1
!************************************************
 -1
 x
 1
 middle
 put(100)
!*************************************************
!The next 4 lines evaluate the Chebyshev expansion
!*************************************************
 1
 5
 get(100)
 cheby(x,m,n)
!**********************************************************
!The next 4 lines subtract the exponential then define f(1)
!**********************************************************
 get(100)
 exp
 subtract
 f(1)
 %
