 %
Irreversible chemical kinetics A --> B --> C
with A(0) > 0, B(0) = 0, C(0) = 0
p(1) = k(1), p(2) = k(2), p(3) = A(0)

  A(x) = A(0)exp(-k(1)x) 

If p(1) does not equal p(2) then sub-model 1 evaluates

  B(x) = p(1)p(3)[exp(-k(1)x) - exp(-k(2)x)]/[(p(2) - p(1)]

otherwise if k(1) equals k(2) then sub-model 2 evaluates

  B(x) = k(1)xA(x)

  C(x) = A(0) - A(x) - B(x)
 %
 3 equations
 1 variable
 3 parameters
 %
 putpar             communicate parameters to sub-models 
 p(1)              
 x
 multiply
 negative
 exp
 p(3)
 multiply
 put(1)              storage(1) = A(x)
 p(2)
 p(1)
 subtract
 value3(1,2,1)       B(x) depends on p(2) - p(1)                      
 put(2)              storage(2) = B(x) 
 p(3) 
 get(1)
 subtract
 get(2)
 subtract
 f(3)                                                  
 get(1)
 f(1)
 get(2)
 f(2)
 %
 begin{model(1)}
 %
 sub-model 1
 B in A --> B --> C where p(1) is not equal to p(2)
 %
 1 equation
 1 variable
 3 parameters
 %
 p(1)
 x
 multiply
 negative
 exp
 p(2)
 x
 multiply
 negative
 exp
 subtract
 p(1)
 multiply
 p(3)
 multiply
 p(2)
 p(1)
 subtract 
 divide
 f(1)
 %
 end{model(1)}
 begin{model(2)}
 %
 sub-model 2
 B in A --> B --> C where p(1) is equal to p(2)
 %
 1 equation
 1 variable
 3 parameters
 %
 get(1)
 x
 multiply
 p(1)
 multiply
 f(1)
 %
 end{model(2)}

 Rules for supplying a user defined function for simulation or fitting
 =====================================================================

 NOTE: Please observe the use of the special symbol % in this file.
 ===== The symbol % starting a line is an escape sequence to indicate
       a change in the meaning of the input stream, e.g. from text to
       parameters, from parameters to model instructions, from model
       to Jacobian, etc.
       Characters occurring more than eight places after the first
       non-blank character are interpreted as comments and text here is
       ignored when the model is parsed.
       The % symbol MUST be used to indicate:-
       i)   start of the file
       ii)  start of the model parameters
       iii) start of the model equations
       iv)  end of model equations (start of Jacobian with diff. eqns.)

 The file you supply must have EXACTLY the format now described.
                               =======

 a) The file must start with a % symbol indicating where text starts
    The next lines must be the name/details you choose for the model.
    This would normally be at least 4 not greater than 24 lines. This
    text is only to identify the model and is not used by simfit.
    The end of this section is marked by a % symbol.
    The next three lines define the type of model.
 b) The first of these lines must indicate the number of equations in
    the model, e.g. 1 equation, 2 equations, 3 equations, etc.
 c) The next must indicate the number of independent variables as in:-
    1 variable, 2 variables, 3 variables, etc. or else it could be
    differential equation to indicate that the model is one or a set of
    ordinary differential equations with one independent variable.
 d) The next line must define the number of parameters in the model.
 e) With differential equations, the last parameters are reserved to set
    the values for the integration constants y0(i), which can be either
    estimated or fixed as required.
    For example, if there are n equations and m parameters are declared
    in the file, only m-n can be actually used in the model, since
    y0(i) = p(m-n+i) for i = 1, 2, ..., n.
 f) Lines are broken up into tokens by spaces.
 g) Only the first token in each line matters after the model starts.
 h) Comments begin with % and are added just to explain what's going on.
 i) Usually the comments beginning with a % can be omitted.
 j) Critical lines starting with % must be present as explained above.
 k) The model operations then follow, one per line until the next line
    starting with a % character indicates the end of the model.
 l) Numbers can be in any format, e.g. 2, 1.234, 1.234E-6, 1.234E6
 m) The symbol f(i) indicates that model equation i is evaluted at
    this point.
 n) Differential equations can define the Jacobian after defining
    the model. If there are n differential equations of the form

    dy(i)/dx = f(i)(x, y(1), y(2), ..., y(n))

    then the symbol y(i) is used to put y(i) on the stack and there
    must be a n by n matrix defined in the following way. The element
    J(a,b) is indicated by putting j(n*(b-1) + a) on the stack. That is
    the columns are filled up first. For instance with 3 equations you
    would have a Jacobian J(i,j) = df(i)/dy(j) defined by the sequence:

    J(1,1) = j(1),  J(1,2) = j(4),  J(3,1) = j(7)
    J(2,1) = j(2),  J(2,2) = j(5),  J(3,2) = j(8)
    J(3,1) = j(3),  J(3,2) = j(6),  J(3,3) = j(9)

 The reverse Polish notation
 ===========================
 The model must be in the reverse Polish, that is, the post-fix notation
 which is used by some programmable calulators, and laguages such as
 PostScript. If you want to make your own model, study the test examples
 usermod?.tf? and use the SIMFIT utility USERMOD to develop your model.
 The files usermod1.tf? are functions of 1 variable, usermod2.tf? are
 functions of two variables, usermod3.tf? are functions of 3 variables,
 while usermodd.tf? are differential equations. Models deqmod?.tf? are
 models for several functions at the same time, e.g. sets of differential
 equations as used by deqsol or sqpfit.
 The program USERMOD allows you to read in a file you have created, to
 evaluate it etc., to check before you proceed to simulation or fitting.

 Permitted operations and the effects produced
 =============================================
 x             : stack -> stack, x
 y             : stack -> stack, y
 z             : stack -> stack, z
 add           : stack, a, b -> stack, (a + b)
 subtract      : stack, a, b -> stack, (a - b)
 multiply      : stack, a, b -> stack, (a*b)
 divide        : stack, a, b -> stack, (a/b)
 p(i)          : stack -> stack, p(i)         ...  i can be 1, 2, 3, etc
 f(i)          : stack, a -> stack  ...evaluate model since now f(i) = a
 power         : stack, a, b -> stack, (a^b)
 squareroot    : stack, a -> stack, sqrt(a)
 exponential   : stack, a -> stack, exp(a)
 tentothepower : stack, a -> stack, 10^a
 ln (or log)   : stack, a -> stack, ln(a)
 log10         : stack, a -> stack, log(a) (to base ten)
 pi            : stack -> stack, 3.1415927
 sine          : stack, a -> stack, sin(a)       ... radians not degrees
 cosine        : stack, a -> stack, cos(a)       ... radians not degrees
 tangent       : stack, a -> stack, tan(a)       ... radians not degrees
 arcsine       : stack, a -> stack, arcsin(a)    ... radians not degrees
 arccosine     : stack, a -> stack, arccos(a)    ... radians not degrees
 arctangent    : stack, a -> stack, arctan(a)    ... radians not degrees
 sinh          : stack, a -> stack, sinh(a)
 cosh          : stack, a -> stack, cosh(a)
 tanh          : stack, a -> stack, tanh(a)
 exchange      : stack, a, b -> stack, b, a
 duplicate     : stack, a -> stack, a, a
 pop           : stack, a, b -> stack, a
 absolutevalue : stack, a -> stack, abs(a)
 negative      : stack, a -> stack , -a
 minimum       : stack, a, b -> stack, min(a,b)
 maximum       : stack, a, b -> stack, max(a,b)
 gammafunction : stack, a -> stack, gamma(a)
 lgamma        : stack, a -> stack, ln(gamma(a))
 normalcdf     : stack, a -> stack, phi(a)  integral from -infinity to a
 erfc          : stack, a -> stack, erfc(a)
 y(i)          : stack    -> stack, y(i)                Only diff. eqns.
 j(i)          : stack, a -> stack  J(i-(i/n), (i/n)+1) Only diff. eqns.
 ***           : stack -> stack, ***          ...  *** can be any number

 Error handling
 ==============
 As the stack is evaluated, action is taken to avoid underflow,
 overflow and forbidden operations, like 1/x as x tends to zero or
 taking the log or square root of a negative number etc.

 Note: other functions may be possible ... see the simfit reference manual
 =========================================================================
 The intention is to supply the facility to call libraries of special
 functions and integration routines which can be included in models.

