; -- x64_Simfit.iss --
; SIMFIT Setup Script for Inno Setup Compiler
; By Ivan N. Lucas <ivan.lucas@lockdown.co.uk>, http://www.lockdown.co.uk/
; SIMFIT Copyright (C) The University of Manchester
; By W. G. Bardsley <bill.bardsley@simfit.org.uk>, http://www.simfit.org.uk
; ----------------

[Setup]
AppName=x64_SIMFIT
AppVerName=SIMFIT Version 8.0.4 (64-bit)
AppCopyright=Copyright  2022 The University of Manchester
AppPublisher=W.G.Bardsley
AppPublisherURL=https://simfit.org.uk
DefaultDirName={commonpf64}\Simfit
DefaultGroupName=Simfit
SourceDir=c:\setup
InfoBeforeFile=x64_infobefo.txt
LicenseFile=license.txt
UninstallFilesDir={app}\bin

[Dirs]
Name: "{app}\bin"
Name: "{app}\dem"
Name: "{app}\doc"

[Files]
; MAIN FILES

Source: "c:\program files (x86)\silverfrost\ftn95\salflibc64.dll"; DestDir: "{app}\bin"; Flags: ignoreversion
Source: "c:\program files (x86)\silverfrost\ftn95\CLEARWIN64.DLL"; DestDir: "{app}\bin"; Flags: ignoreversion
Source: "programs\x64_simfit.exe"; DestDir: "{app}\bin"

; ADDITIONAL EXECUTABLES
Source: "programs\x64_simfitbar.exe"; DestDir: "{app}\bin"
Source: "programs\x64_change_simfit_version.exe"; DestDir: "{app}\bin"
Source: "programs\x64_change_simfit_version.config"; DestDir: "{app}\bin"
Source: "programs\x64_adderr.exe"; DestDir: "{app}\bin"
Source: "programs\x64_average.exe"; DestDir: "{app}\bin"
Source: "programs\x64_binomial.exe"; DestDir: "{app}\bin"
Source: "programs\x64_calcurve.exe"; DestDir: "{app}\bin"
Source: "programs\x64_chisqd.exe"; DestDir: "{app}\bin"
Source: "programs\x64_compare.exe"; DestDir: "{app}\bin"
Source: "programs\x64_csafit.exe"; DestDir: "{app}\bin"
Source: "programs\x64_deqsol.exe"; DestDir: "{app}\bin"
Source: "programs\x64_editfl.exe"; DestDir: "{app}\bin"
Source: "programs\x64_editmt.exe"; DestDir: "{app}\bin"
Source: "programs\x64_editps.exe"; DestDir: "{app}\bin"
Source: "programs\x64_eoqsol.exe"; DestDir: "{app}\bin"
Source: "programs\x64_exfit.exe"; DestDir: "{app}\bin"
Source: "programs\x64_ftest.exe"; DestDir: "{app}\bin"
Source: "programs\x64_gcfit.exe"; DestDir: "{app}\bin"
Source: "programs\x64_help.exe"; DestDir: "{app}\bin"
Source: "programs\x64_hlfit.exe"; DestDir: "{app}\bin"
Source: "programs\x64_inrate.exe"; DestDir: "{app}\bin"
Source: "programs\x64_linfit.exe"; DestDir: "{app}\bin"
Source: "programs\x64_makcsa.exe"; DestDir: "{app}\bin"
Source: "programs\x64_makdat.exe"; DestDir: "{app}\bin"
Source: "programs\x64_makfil.exe"; DestDir: "{app}\bin"
Source: "programs\x64_maklib.exe"; DestDir: "{app}\bin"
Source: "programs\x64_makmat.exe"; DestDir: "{app}\bin"
Source: "programs\x64_maksim.exe"; DestDir: "{app}\bin"
Source: "programs\x64_mmfit.exe"; DestDir: "{app}\bin"
Source: "programs\x64_normal.exe"; DestDir: "{app}\bin"
Source: "programs\x64_polnom.exe"; DestDir: "{app}\bin"
Source: "programs\x64_qnfit.exe"; DestDir: "{app}\bin"
Source: "programs\x64_rannum.exe"; DestDir: "{app}\bin"
Source: "programs\x64_rffit.exe"; DestDir: "{app}\bin"
Source: "programs\x64_rstest.exe"; DestDir: "{app}\bin"
Source: "programs\x64_sffit.exe"; DestDir: "{app}\bin"
Source: "programs\x64_simplot.exe"; DestDir: "{app}\bin"
Source: "programs\x64_simstat.exe"; DestDir: "{app}\bin"
Source: "programs\x64_spline.exe"; DestDir: "{app}\bin"
Source: "programs\x64_ttest.exe"; DestDir: "{app}\bin"
Source: "programs\x64_usermod.exe"; DestDir: "{app}\bin"


; DYNAMIC LINK LIBRARIES
Source: "programs\x64_graphics.dll"; DestDir: "{app}\bin"
Source: "programs\x64_menus.dll"; DestDir: "{app}\bin"
Source: "programs\x64_models.dll"; DestDir: "{app}\bin"
Source: "programs\x64_simfit.dll"; DestDir: "{app}\bin"
Source: "programs\x64_clearwin.dll"; DestDir: "{app}\bin"
Source: "programs\x64_numbers.dll"; DestDir: "{app}\bin"
Source: "programs\x64_maths.dll"; DestDir: "{app}\bin"
Source: "programs\x64_academic_maths.dll"; DestDir: "{app}\bin"
Source: "programs\FLW6I24DC_mkl_maths.dll"; DestDir: "{app}\bin"
Source: "programs\FLW6I24DC_nag_maths.dll"; DestDir: "{app}\bin"
Source: "programs\FLW6I25DC_mkl_maths.dll"; DestDir: "{app}\bin"
Source: "programs\FLW6I25DC_nag_maths.dll"; DestDir: "{app}\bin"
Source: "programs\FLW6I26DE_mkl_maths.dll"; DestDir: "{app}\bin"
Source: "programs\FLW6I26DE_nag_maths.dll"; DestDir: "{app}\bin"
Source: "programs\NLW6I27DE_nag_maths.dll"; DestDir: "{app}\bin"
Source: "programs\NLW6I27DE_mkl_maths.dll"; DestDir: "{app}\bin"
Source: "programs\NLW6I273E_nag_maths.dll"; DestDir: "{app}\bin"
Source: "programs\NLW6I273E_mkl_maths.dll"; DestDir: "{app}\bin"
Source: "programs\GSDLL64.DLL"; DestDir: "{app}\bin"
Source: "extras\msvcr100.dll";  DestDir: "{app}\bin"



; EXTRAS

Source: "extras\LICENSE.TXT"; DestDir: "{app}\doc"
Source: "extras\LICENSE.PDF"; DestDir: "{app}\doc"
Source: "extras\ERRORS.TXT"; DestDir: "{app}\doc"
Source: "extras\SIMFIT4.XLS"; DestDir: "{app}\doc"
Source: "extras\SIMFIT6.XLS"; DestDir: "{app}\doc"
Source: "extras\ConvertToTable.doc"; DestDir: "{app}\doc"
Source: "extras\PSCODES.PS"; DestDir: "{app}\doc"
Source: "extras\PSCODES.PDF"; DestDir: "{app}\doc"
Source: "extras\SIMFIG1.PS"; DestDir: "{app}\dem"
Source: "extras\SIMFIG2.PS"; DestDir: "{app}\dem"
Source: "extras\SIMFIG3.PS"; DestDir: "{app}\dem"
Source: "extras\SIMFIG4.PS"; DestDir: "{app}\dem"
Source: "extras\MS_OFFICE.PDF"; DestDir: "{app}\doc"
Source: "extras\SIMFONTS.PS"; DestDir: "{app}\doc"
Source: "extras\SIMFIT_SUMMARY.PDF"; DestDir: "{app}\doc"
Source: "extras\PSFRAGEX.PS"; DestDir: "{app}\doc"
Source: "extras\PSFRAGEX.PS1"; DestDir: "{app}\doc"
Source: "extras\PSFRAGEX.PS2"; DestDir: "{app}\doc"
Source: "extras\PSFRAGEX.TEX"; DestDir: "{app}\doc"
Source: "extras\w_simfig1.cfg"; DestDir: "{app}\dem"
Source: "extras\w_simfig2.cfg"; DestDir: "{app}\dem"
Source: "extras\w_simfig3.cfg"; DestDir: "{app}\dem"
Source: "extras\w_simfig4.cfg"; DestDir: "{app}\dem"
Source: "extras\pspecial.1"; DestDir: "{app}\dem"
Source: "extras\pspecial.2"; DestDir: "{app}\dem"
Source: "extras\pspecial.3"; DestDir: "{app}\dem"
Source: "extras\templates.txt"; DestDir: "{app}\dem"
Source: "extras\version7.txt"; DestDir: "{app}\doc"
Source: "extras\speedup.pdf"; DestDir: "{app}\doc"
Source: "extras\tutorials.pdf"; DestDir: "{app}\doc"
Source: "extras\configure.pdf"; DestDir: "{app}\doc"
Source: "extras\install.pdf"; DestDir: "{app}\doc"


; MANUALS
Source: "c:\setup\manuals\w_manual.pdf";   DestDir: "{app}\doc"
Source: "c:\setup\manuals\w_examples.pdf"; DestDir: "{app}\doc"
Source: "c:\setup\manuals\front_page.pdf"; DestDir: "{app}\doc"
Source: "c:\setup\manuals\back_page.pdf";  DestDir: "{app}\doc"


; README
Source: "readme\commands.txt"; DestDir: "{app}\doc"
Source: "readme\configure.txt"; DestDir: "{app}\doc"
Source: "readme\speedup.txt"; DestDir: "{app}\doc"
Source: "readme\install.txt"; DestDir: "{app}\doc"
Source: "readme\linux.txt"; DestDir: "{app}\doc"
Source: "readme\formats.txt"; DestDir: "{app}\doc"
Source: "readme\w_readme.0"; DestDir: "{app}\doc"
Source: "readme\w_readme.index"; DestDir: "{app}\doc"
Source: "readme\w_readme.c1"; DestDir: "{app}\doc"
Source: "readme\w_readme.c2"; DestDir: "{app}\doc"
Source: "readme\w_readme.d1"; DestDir: "{app}\doc"
Source: "readme\w_readme.d2"; DestDir: "{app}\doc"
Source: "readme\w_readme.f1"; DestDir: "{app}\doc"
Source: "readme\w_readme.f2"; DestDir: "{app}\doc"
Source: "readme\w_readme.f3"; DestDir: "{app}\doc"
Source: "readme\w_readme.f4"; DestDir: "{app}\doc"
Source: "readme\w_readme.f5"; DestDir: "{app}\doc"
Source: "readme\w_readme.f6"; DestDir: "{app}\doc"
Source: "readme\w_readme.f7"; DestDir: "{app}\doc"
Source: "readme\w_readme.f8"; DestDir: "{app}\doc"
Source: "readme\w_readme.f9"; DestDir: "{app}\doc"
Source: "readme\w_readme.f10"; DestDir: "{app}\doc"
Source: "readme\w_readme.g1"; DestDir: "{app}\doc"
Source: "readme\w_readme.g2"; DestDir: "{app}\doc"
Source: "readme\w_readme.g3"; DestDir: "{app}\doc"
Source: "readme\w_readme.g4"; DestDir: "{app}\doc"
Source: "readme\w_readme.g5"; DestDir: "{app}\doc"
Source: "readme\w_readme.g6"; DestDir: "{app}\doc"
Source: "readme\w_readme.g7"; DestDir: "{app}\doc"
Source: "readme\w_readme.g8"; DestDir: "{app}\doc"
Source: "readme\w_readme.g9"; DestDir: "{app}\doc"
Source: "readme\w_readme.g10"; DestDir: "{app}\doc"
Source: "readme\w_readme.g11"; DestDir: "{app}\doc"
Source: "readme\w_readme.i0"; DestDir: "{app}\doc"
Source: "readme\w_readme.i1"; DestDir: "{app}\doc"
Source: "readme\w_readme.i2"; DestDir: "{app}\doc"
Source: "readme\w_readme.i3"; DestDir: "{app}\doc"
Source: "readme\readme.txt"; DestDir: "{app}\doc"
Source: "readme\readme.1st"; DestDir: "{app}\doc"
Source: "readme\w_readme.s1"; DestDir: "{app}\doc"
Source: "readme\w_readme.s2"; DestDir: "{app}\doc"

; DATA
Source: "data\ADDERR.TF1"; DestDir: "{app}\dem"
Source: "data\ADDERR.TF2"; DestDir: "{app}\dem"
Source: "data\ANOVA1.TF1"; DestDir: "{app}\dem"
Source: "data\ANOVA1.TFL"; DestDir: "{app}\dem"
Source: "data\ANOVA2.TF1"; DestDir: "{app}\dem"
Source: "data\ANOVA2.TF2"; DestDir: "{app}\dem"
Source: "data\ANOVA3.TF1"; DestDir: "{app}\dem"
Source: "data\ANOVA4.TF1"; DestDir: "{app}\dem"
Source: "data\ANOVA5.TF1"; DestDir: "{app}\dem"
Source: "data\ANOVA5.TF2"; DestDir: "{app}\dem"
Source: "data\ANOVA5.TF3"; DestDir: "{app}\dem"
Source: "data\ANOVA5.TF4"; DestDir: "{app}\dem"
Source: "data\ANOVA6.TF1"; DestDir: "{app}\dem"
Source: "data\AVERAGE.TF1"; DestDir: "{app}\dem"
Source: "data\BARCHART.TF1"; DestDir: "{app}\dem"
Source: "data\BARCHART.TF2"; DestDir: "{app}\dem"
Source: "data\BARCHART.TF3"; DestDir: "{app}\dem"
Source: "data\BARCHART.TF4"; DestDir: "{app}\dem"
Source: "data\BARCHART.TF5"; DestDir: "{app}\dem"
Source: "data\BARCHART.TF6"; DestDir: "{app}\dem"
Source: "data\BARCHART.TF7"; DestDir: "{app}\dem"
Source: "data\BARCHT3D.TF1"; DestDir: "{app}\dem"
Source: "data\BARCHT3D.TF2"; DestDir: "{app}\dem"
Source: "data\BARCHT3D.TF3"; DestDir: "{app}\dem"
Source: "data\BETA.TF1"; DestDir: "{app}\dem"
Source: "data\BETA32_CDF.TF1";  DestDir: "{app}\dem"
Source: "data\BETA32_DATA.TF1"; DestDir: "{app}\dem"
Source: "data\BETA32_PDF.TF1";  DestDir: "{app}\dem"
Source: "data\BINOMIAL.TF1"; DestDir: "{app}\dem"
Source: "data\BINOMIAL.TF2"; DestDir: "{app}\dem"
Source: "data\BINOMIAL.TF3"; DestDir: "{app}\dem"
Source: "data\BINOMIAL.TF4"; DestDir: "{app}\dem"
Source: "data\BINOMIAL.TF5"; DestDir: "{app}\dem"
Source: "data\BIVARIATE.TF1"; DestDir: "{app}\dem"
Source: "data\CALCURVE.TF1"; DestDir: "{app}\dem"
Source: "data\CALCURVE.TF2"; DestDir: "{app}\dem"
Source: "data\CALCURVE.TF3"; DestDir: "{app}\dem"
Source: "data\CAMALOT.MOD"; DestDir: "{app}\dem"
Source: "data\CAMALOT_E.MOD"; DestDir: "{app}\dem"
Source: "data\CHEBY.MOD"; DestDir: "{app}\dem"
Source: "data\CHEBY.DATA"; DestDir: "{app}\dem"
Source: "data\CHISQD.TF1"; DestDir: "{app}\dem"
Source: "data\CHISQD.TF2"; DestDir: "{app}\dem"
Source: "data\CHISQD.TF3"; DestDir: "{app}\dem"
Source: "data\CHISQD.TF4"; DestDir: "{app}\dem"
Source: "data\CHISQD.TF5"; DestDir: "{app}\dem"
Source: "data\CHISQD.TF5"; DestDir: "{app}\dem"
Source: "data\CLUSTER.TF1"; DestDir: "{app}\dem"
Source: "data\CLUSTER.TF2"; DestDir: "{app}\dem"
Source: "data\COCHRANQ.TF1"; DestDir: "{app}\dem"
Source: "data\COCHRANQ.TF2"; DestDir: "{app}\dem"
Source: "data\COLUMN1.TF1"; DestDir: "{app}\dem"
Source: "data\COLUMN1.TF2"; DestDir: "{app}\dem"
Source: "data\COLUMN1.TF3"; DestDir: "{app}\dem"
Source: "data\COLUMN1.TF4"; DestDir: "{app}\dem"
Source: "data\COLUMN1.TF5"; DestDir: "{app}\dem"
Source: "data\COLUMN2.TF1"; DestDir: "{app}\dem"
Source: "data\COLUMN2.TF2"; DestDir: "{app}\dem"
Source: "data\COLUMN2.TF3"; DestDir: "{app}\dem"
Source: "data\COMPARE.TF1"; DestDir: "{app}\dem"
Source: "data\COMPARE.TF2"; DestDir: "{app}\dem"
Source: "data\CONSEC3.MOD"; DestDir: "{app}\dem"
Source: "data\CONSEC3.TFL"; DestDir: "{app}\dem"
Source: "data\CONSEC3_A.DATA"; DestDir: "{app}\dem"
Source: "data\CONSEC3_B.DATA"; DestDir: "{app}\dem"
Source: "data\CONSEC3_C.DATA"; DestDir: "{app}\dem"
Source: "data\CONSEC4.TF1"; DestDir: "{app}\dem"
Source: "data\CONSEC4.TF2"; DestDir: "{app}\dem"
Source: "data\CONSEC4.TF3"; DestDir: "{app}\dem"
Source: "data\CONSEC4.TF4"; DestDir: "{app}\dem"
Source: "data\CONSEC4.TFL"; DestDir: "{app}\dem"
Source: "data\CONSEC5.TF1"; DestDir: "{app}\dem"
Source: "data\CONSEC5.TF2"; DestDir: "{app}\dem"
Source: "data\CONSEC5.TF3"; DestDir: "{app}\dem"
Source: "data\CONSEC5.TF4"; DestDir: "{app}\dem"
Source: "data\CONSEC5.TF5"; DestDir: "{app}\dem"
Source: "data\CONSEC5.TFL"; DestDir: "{app}\dem"
Source: "data\CONVOLVE.MOD"; DestDir: "{app}\dem"
Source: "data\CONVOLV3_E.MOD"; DestDir: "{app}\dem"
Source: "data\CONVOLV3.MOD"; DestDir: "{app}\dem"
Source: "data\CONVOLV3.TFL"; DestDir: "{app}\dem"
Source: "data\CONVOLV3.DATA"; DestDir: "{app}\dem"
Source: "data\COX.TF1"; DestDir: "{app}\dem"
Source: "data\COX.TF2"; DestDir: "{app}\dem"
Source: "data\COX.TF3"; DestDir: "{app}\dem"
Source: "data\COX.TF4"; DestDir: "{app}\dem"
Source: "data\CSADAT.TF1"; DestDir: "{app}\dem"
Source: "data\CSADAT.TF2"; DestDir: "{app}\dem"
Source: "data\CSAFIT.TF1"; DestDir: "{app}\dem"
Source: "data\CSAFIT.TF2"; DestDir: "{app}\dem"
Source: "data\CSAFIT.TF3"; DestDir: "{app}\dem"
Source: "data\DBLE_EXP.MOD"; DestDir: "{app}\dem"
Source: "data\DEQMAT.TF1"; DestDir: "{app}\dem"
Source: "data\DEQMAT.TF2"; DestDir: "{app}\dem"
Source: "data\DEQMOD1.TF1"; DestDir: "{app}\dem"
Source: "data\DEQMOD1_E.TF1"; DestDir: "{app}\dem"
Source: "data\DEQMOD1.TF2"; DestDir: "{app}\dem"
Source: "data\DEQMOD1_E.TF2"; DestDir: "{app}\dem"
Source: "data\DEQMOD1.TF3"; DestDir: "{app}\dem"
Source: "data\DEQMOD1_E.TF3"; DestDir: "{app}\dem"
Source: "data\DEQMOD1.TF4"; DestDir: "{app}\dem"
Source: "data\DEQMOD1_E.TF4"; DestDir: "{app}\dem"
Source: "data\DEQMOD1.TF5"; DestDir: "{app}\dem"
Source: "data\DEQMOD1_E.TF5"; DestDir: "{app}\dem"
Source: "data\DEQMOD1.TF6"; DestDir: "{app}\dem"
Source: "data\DEQMOD1_E.TF6"; DestDir: "{app}\dem"
Source: "data\DEQMOD2.TF1"; DestDir: "{app}\dem"
Source: "data\DEQMOD2_E.TF1"; DestDir: "{app}\dem"
Source: "data\DEQMOD2.TF2"; DestDir: "{app}\dem"
Source: "data\DEQMOD2_E.TF2"; DestDir: "{app}\dem"
Source: "data\DEQMOD2.TF3"; DestDir: "{app}\dem"
Source: "data\DEQMOD2_E.TF3"; DestDir: "{app}\dem"
Source: "data\DEQMOD3.TF1"; DestDir: "{app}\dem"
Source: "data\DEQMOD3_E.TF1"; DestDir: "{app}\dem"
Source: "data\DEQMOD3.TF2"; DestDir: "{app}\dem"
Source: "data\DEQMOD3_E.TF2"; DestDir: "{app}\dem"
Source: "data\DEQMOD4.TF1"; DestDir: "{app}\dem"
Source: "data\DEQMOD4_E.TF1"; DestDir: "{app}\dem"
Source: "data\DEQN_DATA.TF1"; DestDir: "{app}\dem"
Source: "data\DEQN_DATA.TF2"; DestDir: "{app}\dem"
Source: "data\DEQN_DATA.TF3"; DestDir: "{app}\dem"
Source: "data\DEQN_MODEL.TF1"; DestDir: "{app}\dem"
Source: "data\DEQN_MODEL.TF2"; DestDir: "{app}\dem"
Source: "data\DEQN_MODEL.TF3"; DestDir: "{app}\dem"
Source: "data\DEQPAR1.TF1"; DestDir: "{app}\dem"
Source: "data\DEQPAR1.TF2"; DestDir: "{app}\dem"
Source: "data\DEQPAR1.TF3"; DestDir: "{app}\dem"
Source: "data\DEQPAR1.TF4"; DestDir: "{app}\dem"
Source: "data\DEQPAR1.TF5"; DestDir: "{app}\dem"
Source: "data\DEQPAR1.TF6"; DestDir: "{app}\dem"
Source: "data\DEQPAR2.TF1"; DestDir: "{app}\dem"
Source: "data\DEQPAR2.TF2"; DestDir: "{app}\dem"
Source: "data\DEQPAR2.TF3"; DestDir: "{app}\dem"
Source: "data\DEQPAR4.TF1"; DestDir: "{app}\dem"
Source: "data\DEQSOL.TF1"; DestDir: "{app}\dem"
Source: "data\DEQSOL.TF2"; DestDir: "{app}\dem"
Source: "data\DEQSOL.TF3"; DestDir: "{app}\dem"
Source: "data\DEQSOL.TFL"; DestDir: "{app}\dem"
Source: "data\DIVERSITY.TF1"; DestDir: "{app}\dem"
Source: "data\EDITFL.TF1"; DestDir: "{app}\dem"
Source: "data\EDITFL.TF2"; DestDir: "{app}\dem"
Source: "data\EDITFL.TF3"; DestDir: "{app}\dem"
Source: "data\EDITFL.TF4"; DestDir: "{app}\dem"
Source: "data\EDITMT.TF1"; DestDir: "{app}\dem"
Source: "data\EDITMT.TF2"; DestDir: "{app}\dem"
Source: "data\EDITMT.TF3"; DestDir: "{app}\dem"
Source: "data\EDITPS.TFL"; DestDir: "{app}\dem"
Source: "data\ELLIPSE.MOD"; DestDir: "{app}\dem"
Source: "data\ELLIPSE_E.MOD"; DestDir: "{app}\dem"
Source: "data\EPIDEMIC.TFL"; DestDir: "{app}\dem"
Source: "data\ERRORBAR.TF1"; DestDir: "{app}\dem"
Source: "data\ERRORBAR.TF2"; DestDir: "{app}\dem"
Source: "data\EXFIT.TF1"; DestDir: "{app}\dem"
Source: "data\EXFIT.TF2"; DestDir: "{app}\dem"
Source: "data\EXFIT.TF3"; DestDir: "{app}\dem"
Source: "data\EXFIT.TF4"; DestDir: "{app}\dem"
Source: "data\EXFIT.TF5"; DestDir: "{app}\dem"
Source: "data\EXFIT.TF6"; DestDir: "{app}\dem"
Source: "data\EXFIT.TF7"; DestDir: "{app}\dem"
Source: "data\EXFIT-TF4.PLF"; DestDir: "{app}\dem"
Source: "data\FAMILY2D.MOD"; DestDir: "{app}\dem"
Source: "data\FAMILY3D.MOD"; DestDir: "{app}\dem"
Source: "data\FDR_BH.TF1"; DestDir: "{app}\dem"
Source: "data\FTEST.TF1"; DestDir: "{app}\dem"
Source: "data\GAMMA.TF1"; DestDir: "{app}\dem"
Source: "data\GAUSS3.TF1"; DestDir: "{app}\dem"
Source: "data\GAUSS3-TF1.PLF"; DestDir: "{app}\dem"
Source: "data\GCFIT.TF1"; DestDir: "{app}\dem"
Source: "data\GCFIT.TF2"; DestDir: "{app}\dem"
Source: "data\GCFIT.TF3"; DestDir: "{app}\dem"
Source: "data\GCFIT.TF4"; DestDir: "{app}\dem"
Source: "data\GCFIT.TF5"; DestDir: "{app}\dem"
Source: "data\GCFIT.TF6"; DestDir: "{app}\dem"
Source: "data\GCFIT.TF7"; DestDir: "{app}\dem"
Source: "data\GLM.TF1"; DestDir: "{app}\dem"
Source: "data\GLM.TF2"; DestDir: "{app}\dem"
Source: "data\GLM.TF3"; DestDir: "{app}\dem"
Source: "data\GLM.TF4"; DestDir: "{app}\dem"
Source: "data\GOMPERTZ.TF1"; DestDir: "{app}\dem"
Source: "data\HELIX.MOD"; DestDir: "{app}\dem"
Source: "data\HELIX_E.MOD"; DestDir: "{app}\dem"
Source: "data\HOTCOLD.TF1"; DestDir: "{app}\dem"
Source: "data\HOTEL.TF1"; DestDir: "{app}\dem"
Source: "data\HOUSES.TF1"; DestDir: "{app}\dem"
Source: "data\HLFIT.TF1"; DestDir: "{app}\dem"
Source: "data\HLFIT.TF2"; DestDir: "{app}\dem"
Source: "data\HLFIT.TF3"; DestDir: "{app}\dem"
Source: "data\HLFIT.TF4"; DestDir: "{app}\dem"
Source: "data\HLFIT-TF4.PLF"; DestDir: "{app}\dem"
Source: "data\IF.MOD"; DestDir: "{app}\dem"
Source: "data\IMAGES.TFL"; DestDir: "{app}\dem"
Source: "data\IMPULSE.MOD"; DestDir: "{app}\dem"
Source: "data\INCOMPLETE.TF1"; DestDir: "{app}\dem"
Source: "data\INCOMPLETE.TF2"; DestDir: "{app}\dem"
Source: "data\INCOMPLETE.TF3"; DestDir: "{app}\dem"
Source: "data\INCOMPLETE.MV1"; DestDir: "{app}\dem"
Source: "data\INCOMPLETE.MV2"; DestDir: "{app}\dem"
Source: "data\INCOMPLETE.MV3"; DestDir: "{app}\dem"
Source: "data\INHIBIT.TF1"; DestDir: "{app}\dem"
Source: "data\INHIBIT.TFL"; DestDir: "{app}\dem"
Source: "data\INHIBITA.DATA"; DestDir: "{app}\dem"
Source: "data\INHIBITB.DATA"; DestDir: "{app}\dem"
Source: "data\INHIBITC.DATA"; DestDir: "{app}\dem"
Source: "data\INHIBITD.DATA"; DestDir: "{app}\dem"
Source: "data\INHIBITE.DATA"; DestDir: "{app}\dem"
Source: "data\INHIBITF.DATA"; DestDir: "{app}\dem"
Source: "data\INHIBITG.DATA"; DestDir: "{app}\dem"
Source: "data\INHIBITH.DATA"; DestDir: "{app}\dem"
Source: "data\INHIBITI.DATA"; DestDir: "{app}\dem"
Source: "data\INHIBITJ.DATA"; DestDir: "{app}\dem"
Source: "data\INHIBITK.DATA"; DestDir: "{app}\dem"
Source: "data\INRATE.TF1"; DestDir: "{app}\dem"
Source: "data\INRATE.TF2"; DestDir: "{app}\dem"
Source: "data\INRATE.TF3"; DestDir: "{app}\dem"
Source: "data\IRIS.TF1"; DestDir: "{app}\dem"
Source: "data\IRIS.TF2"; DestDir: "{app}\dem"
Source: "data\KENDALL.TF1"; DestDir: "{app}\dem"
Source: "data\KMEANS.TF1"; DestDir: "{app}\dem"
Source: "data\KMEANS.TF2"; DestDir: "{app}\dem"
Source: "data\INRATE.TF4"; DestDir: "{app}\dem"
Source: "data\LABELS.TF1"; DestDir: "{app}\dem"
Source: "data\LATINSQ.TF1"; DestDir: "{app}\dem"
Source: "data\LD50.TF1"; DestDir: "{app}\dem"
Source: "data\LD50.TF2"; DestDir: "{app}\dem"
Source: "data\LD50.TF3"; DestDir: "{app}\dem"
Source: "data\LINE.TF1"; DestDir: "{app}\dem"
Source: "data\LINE.TF2"; DestDir: "{app}\dem"
Source: "data\LINE1.DATA"; DestDir: "{app}\dem"
Source: "data\LINE2.DATA"; DestDir: "{app}\dem"
Source: "data\LINE3.DATA"; DestDir: "{app}\dem"
Source: "data\LINE3.MOD"; DestDir: "{app}\dem"
Source: "data\LINE3_E.MOD"; DestDir: "{app}\dem"
Source: "data\LINE3.TFL"; DestDir: "{app}\dem"
Source: "data\LINFIT.TF1"; DestDir: "{app}\dem"
Source: "data\LINFIT.TF2"; DestDir: "{app}\dem"                                                                                         
Source: "data\LINFIT.TF3"; DestDir: "{app}\dem"
Source: "data\LOGISTIC.TF1"; DestDir: "{app}\dem"
Source: "data\LOGISTIC.TF2"; DestDir: "{app}\dem"
Source: "data\LOGISTIC.TF3"; DestDir: "{app}\dem"
Source: "data\LOGISTIC.TF4"; DestDir: "{app}\dem"
Source: "data\LOGISTIC.TF5"; DestDir: "{app}\dem" 
Source: "data\LOGLIN.TF1"; DestDir: "{app}\dem"
Source: "data\LOGODDS.CFG"; DestDir: "{app}\dem"
Source: "data\LOGODDSRATIOS.CFG"; DestDir: "{app}\dem"
Source: "data\LOGNOR.TF1"; DestDir: "{app}\dem"
Source: "data\LV1.TF1"; DestDir: "{app}\dem"
Source: "data\LV2.TF1"; DestDir: "{app}\dem"
Source: "data\MAKSIM.TF1"; DestDir: "{app}\dem"
Source: "data\MAKSIM.TF2"; DestDir: "{app}\dem"
Source: "data\MAKSIM.TF3"; DestDir: "{app}\dem"
Source: "data\MAKSIM_1.HTML"; DestDir: "{app}\dem"
Source: "data\MAKSIM_2.HTML"; DestDir: "{app}\dem"
Source: "data\MAKSIM_3.HTML"; DestDir: "{app}\dem"
Source: "data\MANOVA1.TF1"; DestDir: "{app}\dem"
Source: "data\MANOVA1.TF2"; DestDir: "{app}\dem"
Source: "data\MANOVA1.TF3"; DestDir: "{app}\dem"
Source: "data\MANOVA1.TF4"; DestDir: "{app}\dem"
Source: "data\MANOVA1.TF5"; DestDir: "{app}\dem"
Source: "data\MATRIX_A.TF1"; DestDir: "{app}\dem"
Source: "data\MATRIX_B.TF1"; DestDir: "{app}\dem"
Source: "data\MATRIX_P.TF1"; DestDir: "{app}\dem"
Source: "data\MATRIX.TF1"; DestDir: "{app}\dem"
Source: "data\MATRIX.TF2"; DestDir: "{app}\dem"
Source: "data\MATRIX.TF3"; DestDir: "{app}\dem"
Source: "data\MATRIX.TF4"; DestDir: "{app}\dem"
Source: "data\MATRIX.TF5"; DestDir: "{app}\dem"
Source: "data\MCNEMAR.TF1"; DestDir: "{app}\dem"
Source: "data\MCNEMAR.TF2"; DestDir: "{app}\dem"
Source: "data\MCNEMAR.TF3"; DestDir: "{app}\dem"
Source: "data\META.TF1"; DestDir: "{app}\dem"
Source: "data\META.TF2"; DestDir: "{app}\dem"
Source: "data\META.TF3"; DestDir: "{app}\dem"
Source: "data\META.TF4"; DestDir: "{app}\dem"
Source: "data\METAFILE.TF1"; DestDir: "{app}\dem"
Source: "data\METAFILE.TF2"; DestDir: "{app}\dem"
Source: "data\METAFILE.TF3"; DestDir: "{app}\dem"
Source: "data\METAFILE.TF4"; DestDir: "{app}\dem"
Source: "data\METAFILE.TF5"; DestDir: "{app}\dem"
Source: "data\METAFILE.TF6"; DestDir: "{app}\dem"
Source: "data\METAFILE.TF7"; DestDir: "{app}\dem"
Source: "data\METAFILE.TF8"; DestDir: "{app}\dem"
Source: "data\METAFILE.TF9"; DestDir: "{app}\dem"
Source: "data\MMFIT.TF1"; DestDir: "{app}\dem"
Source: "data\MMFIT.TF2"; DestDir: "{app}\dem"
Source: "data\MMFIT.TF3"; DestDir: "{app}\dem"
Source: "data\MMFIT.TF4"; DestDir: "{app}\dem"
Source: "data\MMFIT-TF4.PLF"; DestDir: "{app}\dem"
Source: "data\NEGATIVE.PLF"; DestDir: "{app}\dem"
Source: "data\NEGEXP.TF1"; DestDir: "{app}\dem"
Source: "data\NORMAL.TF1"; DestDir: "{app}\dem"
Source: "data\NORMAL.TF2"; DestDir: "{app}\dem"
Source: "data\NORMAL.TF3"; DestDir: "{app}\dem"
Source: "data\NPCORR.TF1"; DestDir: "{app}\dem"
Source: "data\NPCORR.TF2"; DestDir: "{app}\dem"
Source: "data\NPCORR.TFL"; DestDir: "{app}\dem"
Source: "data\OPTIMUM.MOD"; DestDir: "{app}\dem"
Source: "data\OPTIMUM_E.MOD"; DestDir: "{app}\dem"
Source: "data\ORBIT.TF1"; DestDir: "{app}\dem"
Source: "data\ORBIT.TF2"; DestDir: "{app}\dem"
Source: "data\ORBIT.TF3"; DestDir: "{app}\dem"
Source: "data\ORBIT.TF4"; DestDir: "{app}\dem"
Source: "data\ORBIT.TF5"; DestDir: "{app}\dem"
Source: "data\ORBIT.TF6"; DestDir: "{app}\dem"
Source: "data\ORBIT.TFL"; DestDir: "{app}\dem"
Source: "data\PACORR.TF1"; DestDir: "{app}\dem"
Source: "data\PABST-EINSTEIN.TF1"; DestDir: "{app}\dem"
Source: "data\PERIODIC.MOD"; DestDir: "{app}\dem"
Source: "data\PIECHART.TF1"; DestDir: "{app}\dem"
Source: "data\PIECHART.TF2"; DestDir: "{app}\dem"
Source: "data\PIECHART.TF3"; DestDir: "{app}\dem"
Source: "data\POISSON.TF1"; DestDir: "{app}\dem"
Source: "data\POISSON.TF2"; DestDir: "{app}\dem"
Source: "data\PLOT2.TF1"; DestDir: "{app}\dem"
Source: "data\PLOT2.TF2"; DestDir: "{app}\dem"
Source: "data\PLOT2.TF3"; DestDir: "{app}\dem"
Source: "data\PLS_X.TF1"; DestDir: "{app}\dem"
Source: "data\PLS_Y.TF1"; DestDir: "{app}\dem"
Source: "data\PLS_Z.TF1"; DestDir: "{app}\dem"
Source: "data\POLNOM.TF1"; DestDir: "{app}\dem"
Source: "data\POLNOM.TF2"; DestDir: "{app}\dem"
Source: "data\POLNOM.TF3"; DestDir: "{app}\dem"
Source: "data\POLNOM.TF4"; DestDir: "{app}\dem"
Source: "data\POLNOM-TF1.PLF"; DestDir: "{app}\dem"
Source: "data\POSITIVE.PLF"; DestDir: "{app}\dem"
Source: "data\PRIMES.TF1"; DestDir: "{app}\dem"
Source: "data\PRIMES.TF2"; DestDir: "{app}\dem"
Source: "data\QNFIT_DATA.TF1"; DestDir: "{app}\dem"
Source: "data\QNFIT_DATA.TF2"; DestDir: "{app}\dem"
Source: "data\QNFIT_DATA.TF3"; DestDir: "{app}\dem"
Source: "data\QNFIT_DATA.TF4"; DestDir: "{app}\dem"
Source: "data\QNFIT_DATA.TF5"; DestDir: "{app}\dem"
Source: "data\QNFIT_DATA.TF6"; DestDir: "{app}\dem"
Source: "data\QNFIT_DATA.TF7"; DestDir: "{app}\dem"
Source: "data\QNFIT_DATA.TF8"; DestDir: "{app}\dem"
Source: "data\QNFIT_DATA.TF9"; DestDir: "{app}\dem"
Source: "data\QNFIT_MODEL.TF1"; DestDir: "{app}\dem"
Source: "data\QNFIT_MODEL.TF2"; DestDir: "{app}\dem"
Source: "data\QNFIT_MODEL.TF3"; DestDir: "{app}\dem"
Source: "data\QNFIT_MODEL.TF4"; DestDir: "{app}\dem"
Source: "data\QNFIT_MODEL.TF5"; DestDir: "{app}\dem"
Source: "data\QNFIT_MODEL.TF6"; DestDir: "{app}\dem"
Source: "data\QNFIT_MODEL.TF7"; DestDir: "{app}\dem"
Source: "data\QNFIT_MODEL.TF8"; DestDir: "{app}\dem"
Source: "data\QNFIT_MODEL.TF9"; DestDir: "{app}\dem"
Source: "data\QNFIT.TF1"; DestDir: "{app}\dem"
Source: "data\QNFIT.TF2"; DestDir: "{app}\dem"
Source: "data\QNFIT.TF3"; DestDir: "{app}\dem"
Source: "data\QNFIT.TFL"; DestDir: "{app}\dem"
Source: "data\QNFIT_ODE.TF1"; DestDir: "{app}\dem"
Source: "data\QNFIT_ODE.TF2"; DestDir: "{app}\dem"
Source: "data\QNFIT_ODE.TF3"; DestDir: "{app}\dem"
Source: "data\RAINFALL.TF1"; DestDir: "{app}\dem"
Source: "data\RECURRENT.TF1"; DESTdir: "{app}\dem"
Source: "data\RECURRENT.TF2"; DESTdir: "{app}\dem"
Source: "data\RECURRENT.TF3"; DESTdir: "{app}\dem"
Source: "data\RECURRENT.TFL"; DESTdir: "{app}\dem"
Source: "data\RFFIT.TF1"; DestDir: "{app}\dem"
Source: "data\RFFIT.TF2"; DestDir: "{app}\dem"
Source: "data\RFFIT.TF3"; DestDir: "{app}\dem"
Source: "data\RFFIT.TF4"; DestDir: "{app}\dem"
Source: "data\RFFIT.TF5"; DestDir: "{app}\dem"
Source: "data\RFFIT.TF6"; DestDir: "{app}\dem"
Source: "data\RFFIT.TF7"; DestDir: "{app}\dem"
Source: "data\ROBUST.TF1"; DestDir: "{app}\dem"
Source: "data\ROSE.MOD"; DestDir: "{app}\dem"
Source: "data\ROSE_E.MOD"; DestDir: "{app}\dem"
Source: "data\RSTEST.TF1"; DestDir: "{app}\dem"
Source: "data\SFFIT.TF1"; DestDir: "{app}\dem"
Source: "data\SFFIT.TF2"; DestDir: "{app}\dem"
Source: "data\SFFIT.TF3"; DestDir: "{app}\dem"
Source: "data\SFFIT.TF4"; DestDir: "{app}\dem"
Source: "data\SFFIT-TF4.PLF"; DestDir: "{app}\dem"
Source: "data\SIMFIG1.TFL"; DestDir: "{app}\dem"
Source: "data\SIMFIG2.TFL"; DestDir: "{app}\dem"
Source: "data\SIMFIG3.TFL"; DestDir: "{app}\dem"
Source: "data\SIMFIG3A.DATA"; DestDir: "{app}\dem"
Source: "data\SIMFIG3B.DATA"; DestDir: "{app}\dem"
Source: "data\SIMFIG3C.DATA"; DestDir: "{app}\dem"
Source: "data\SIMFIG3D.DATA"; DestDir: "{app}\dem"
Source: "data\SIMFIG4.TFL"; DestDir: "{app}\dem"
Source: "data\SIMFIG4A.DATA"; DestDir: "{app}\dem"
Source: "data\SIMFIG4B.DATA"; DestDir: "{app}\dem"
Source: "data\SIMPLOT.TF1"; DestDir: "{app}\dem"
Source: "data\SIMPLOT.TF2"; DestDir: "{app}\dem"
Source: "data\SIMPLOT.TF3"; DestDir: "{app}\dem"
Source: "data\SIMPLOT.TFL"; DestDir: "{app}\dem"
Source: "data\SPIRAL.TF1"; DestDir: "{app}\dem"
Source: "data\SPIRAL.TF2"; DestDir: "{app}\dem"
Source: "data\SPIRAL.TF1"; DestDir: "{app}\dem"
Source: "data\SPIRAL.TFL"; DestDir: "{app}\dem"
Source: "data\SPLINE.TF1"; DestDir: "{app}\dem"
Source: "data\SPLINE.TF2"; DestDir: "{app}\dem"
Source: "data\SPLINE.TF3"; DestDir: "{app}\dem"
Source: "data\STRATA.TF1"; DestDir: "{app}\dem"
Source: "data\SURFACE.TF1"; DestDir: "{app}\dem"
Source: "data\SURFACE.TF2"; DestDir: "{app}\dem"
Source: "data\SURFACE.TF3"; DestDir: "{app}\dem"
Source: "data\SURFACE.TF4"; DestDir: "{app}\dem"
Source: "data\SURVIVE.TF1"; DestDir: "{app}\dem"
Source: "data\SURVIVE.TF2"; DestDir: "{app}\dem"
Source: "data\SURVIVE.TF3"; DestDir: "{app}\dem"
Source: "data\SURVIVE.TF4"; DestDir: "{app}\dem"
Source: "data\SURVIVE.TF5"; DestDir: "{app}\dem"
Source: "data\SURVIVE.TF6"; DestDir: "{app}\dem"
Source: "data\SWARM.TF1"; DestDir: "{app}\dem"
Source: "data\TANGENT.MOD"; DestDir: "{app}\dem"
Source: "data\TRINOM.TF1"; DestDir: "{app}\dem"
Source: "data\TRINOM.TF2"; DestDir: "{app}\dem"
Source: "data\TRINOM.TF3"; DestDir: "{app}\dem"
Source: "data\TIMES.TF1"; DestDir: "{app}\dem"
Source: "data\TTEST.TF1"; DestDir: "{app}\dem"
Source: "data\TTEST.TF2"; DestDir: "{app}\dem"
Source: "data\TTEST.TF3"; DestDir: "{app}\dem"
Source: "data\TTEST.TF4"; DestDir: "{app}\dem"
Source: "data\TTEST.TF5"; DestDir: "{app}\dem"
Source: "data\TTEST.TF6"; DestDir: "{app}\dem"
Source: "data\TUKEYQ.TF1"; DestDir: "{app}\dem"
Source: "data\TWISTER.MOD"; DestDir: "{app}\dem"
Source: "data\UKMAP.TF1"; DestDir: "{app}\dem"
Source: "data\UKMAP.TF2"; DestDir: "{app}\dem"
Source: "data\UKMAP.TF3"; DestDir: "{app}\dem"
Source: "data\UNCONSTRAINED.PLF"; DestDir: "{app}\dem"
Source: "data\UNIFORM.TF1"; DestDir: "{app}\dem"
Source: "data\UPDOWN.MOD"; DestDir: "{app}\dem"
Source: "data\UPDOWNUP.MOD"; DestDir: "{app}\dem"
Source: "data\USERMOD1.TF1"; DestDir: "{app}\dem"
Source: "data\USERMOD1.TF2"; DestDir: "{app}\dem"
Source: "data\USERMOD1.TF3"; DestDir: "{app}\dem"
Source: "data\USERMOD1.TF4"; DestDir: "{app}\dem"
Source: "data\USERMOD1.TF5"; DestDir: "{app}\dem"
Source: "data\USERMOD1.TF6"; DestDir: "{app}\dem"
Source: "data\USERMOD1.TF7"; DestDir: "{app}\dem"
Source: "data\USERMOD1.TF8"; DestDir: "{app}\dem"
Source: "data\USERMOD1.TF9"; DestDir: "{app}\dem"
Source: "data\USERMOD1_E.TF1"; DestDir: "{app}\dem"
Source: "data\USERMOD1_E.TF2"; DestDir: "{app}\dem"
Source: "data\USERMOD1_E.TF3"; DestDir: "{app}\dem"
Source: "data\USERMOD1_E.TF4"; DestDir: "{app}\dem"
Source: "data\USERMOD1_E.TF5"; DestDir: "{app}\dem"
Source: "data\USERMOD1_E.TF6"; DestDir: "{app}\dem"
Source: "data\USERMOD1_E.TF7"; DestDir: "{app}\dem"
Source: "data\USERMOD1_E.TF8"; DestDir: "{app}\dem"
Source: "data\USERMOD1_E.TF9"; DestDir: "{app}\dem"
Source: "data\USERMOD2.TF1"; DestDir: "{app}\dem"
Source: "data\USERMOD3.TF1"; DestDir: "{app}\dem"
Source: "data\USERMOD4.TF1"; DestDir: "{app}\dem"
Source: "data\USERMOD2_E.TF1"; DestDir: "{app}\dem"
Source: "data\USERMOD3_E.TF1"; DestDir: "{app}\dem"
Source: "data\USERMOD4_E.TF1"; DestDir: "{app}\dem"
Source: "data\USERMODD.TF1"; DestDir: "{app}\dem"
Source: "data\USERMODD_E.TF1"; DestDir: "{app}\dem"
Source: "data\USERMODN.TF1"; DestDir: "{app}\dem"
Source: "data\USERMODN.TF2"; DestDir: "{app}\dem"
Source: "data\USERMODN.TF3"; DestDir: "{app}\dem"
Source: "data\USERMODN.TF4"; DestDir: "{app}\dem"
Source: "data\USERMODN_E.TF1"; DestDir: "{app}\dem"
Source: "data\USERMODN_E.TF2"; DestDir: "{app}\dem"
Source: "data\USERMODN_E.TF3"; DestDir: "{app}\dem"
Source: "data\USERMODN_E.TF4"; DestDir: "{app}\dem"
Source: "data\USERMODS.TF1"; DestDir: "{app}\dem"
Source: "data\USERMODS.TF2"; DestDir: "{app}\dem"
Source: "data\USERMODS.TF3"; DestDir: "{app}\dem"
Source: "data\USERMODS_E.TF1"; DestDir: "{app}\dem"
Source: "data\USERMODS_E.TF2"; DestDir: "{app}\dem"
Source: "data\USERMODS_E.TF3"; DestDir: "{app}\dem"
Source: "data\USERMODX.TF1"; DestDir: "{app}\dem"
Source: "data\USERMODX.TF2"; DestDir: "{app}\dem"
Source: "data\USERMODX.TF3"; DestDir: "{app}\dem"
Source: "data\USERMODX.TF4"; DestDir: "{app}\dem"
Source: "data\USERMODX.TF5"; DestDir: "{app}\dem"
Source: "data\USER1.MOD"; DestDir: "{app}\dem"
Source: "data\VECTOR.TF1"; DestDir: "{app}\dem"
Source: "data\VECTOR.TF2"; DestDir: "{app}\dem"
Source: "data\VECTOR.TF3"; DestDir: "{app}\dem"
Source: "data\VFIELD.TF1"; DestDir: "{app}\dem"
Source: "data\VFIELD.TF2"; DestDir: "{app}\dem"
Source: "data\WEIBULL.TF1"; DestDir: "{app}\dem"
Source: "data\WEIBULL.TF2"; DestDir: "{app}\dem"
Source: "data\WILCOXON.TF1"; DestDir: "{app}\dem"
Source: "data\WILCOXON.TF2"; DestDir: "{app}\dem"
Source: "data\Y1.DATA"; DestDir: "{app}\dem"
Source: "data\Y2.DATA"; DestDir: "{app}\dem"
Source: "data\Y3.DATA"; DestDir: "{app}\dem"
Source: "data\ZETA_ZEROS.TF1"; DestDir: "{app}\dem"
Source: "data\ZIGZAG.TF1"; DestDir: "{app}\dem"
Source: "NAG\LIST.NAG"; DestDir: "{app}\dem"
Source: "NAG\C05ADF.MOD"; DestDir: "{app}\dem"
Source: "NAG\C05ADF_E.MOD"; DestDir: "{app}\dem"
Source: "NAG\C05NBF.MOD"; DestDir: "{app}\dem"
Source: "NAG\C05NBF_E.MOD"; DestDir: "{app}\dem"
Source: "NAG\D01AJF.MOD"; DestDir: "{app}\dem"
Source: "NAG\D01AJF_E.MOD"; DestDir: "{app}\dem"
Source: "NAG\D01EAF.MOD"; DestDir: "{app}\dem"
Source: "NAG\D01EAF_E.MOD"; DestDir: "{app}\dem"
Source: "NAG\D01FCF.MOD"; DestDir: "{app}\dem"
Source: "NAG\D01FCF_E.MOD"; DestDir: "{app}\dem"
Source: "NAG\C02AGF.TF1"; DestDir: "{app}\dem"
Source: "NAG\E02ADF.TF1"; DestDir: "{app}\dem"
Source: "NAG\E02BAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\E02BAF.TF2"; DestDir: "{app}\dem"
Source: "NAG\E02BEF.TF1"; DestDir: "{app}\dem"
Source: "NAG\E04FYF.TF1"; DestDir: "{app}\dem"
Source: "NAG\E04FYF.MOD"; DestDir: "{app}\dem"
Source: "NAG\E04FYF_E.MOD"; DestDir: "{app}\dem"
Source: "NAG\F01ABF.TF1"; DestDir: "{app}\dem"
Source: "NAG\F01BLF.TF1"; DestDir: "{app}\dem"
Source: "NAG\F02FDF.TF1"; DestDir: "{app}\dem"
Source: "NAG\F02WEF.TF1"; DestDir: "{app}\dem"
Source: "NAG\F02WEF.TF2"; DestDir: "{app}\dem"
Source: "NAG\F02FDF.TF2"; DestDir: "{app}\dem"
Source: "NAG\F03AAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\F03AEF.TF1"; DestDir: "{app}\dem"
Source: "NAG\F07FDF.TF1"; DestDir: "{app}\dem"
Source: "NAG\F08KFF.TF1"; DestDir: "{app}\dem"
Source: "NAG\F08KFF.TF2"; DestDir: "{app}\dem"
Source: "NAG\G02BAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G02BNF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G02BYF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G02CAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G02DAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G02GAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G02GBF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G02GCF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G02GDF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G02HAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G02LAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G02LAF.TF2"; DestDir: "{app}\dem"
Source: "NAG\G02LAF.TF3"; DestDir: "{app}\dem"
Source: "NAG\G03AAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03ACF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03ADF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03BAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03BCF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03BCF.TF2"; DestDir: "{app}\dem"
Source: "NAG\G03CAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03CCF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03DAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03DBF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03DCF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03EAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03ECF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03EFF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03EFF.TF2"; DestDir: "{app}\dem"
Source: "NAG\G03EHF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03EJF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G03FAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G04ADF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G04AEF.TFL"; DestDir: "{app}\dem"
Source: "NAG\G04CAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G07BEF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G08ACF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G08ACF.TF2"; DestDir: "{app}\dem"
Source: "NAG\G08AEF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G08AFF.TFL"; DestDir: "{app}\dem"
Source: "NAG\G08AHF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G08AHF.TF2"; DestDir: "{app}\dem"
Source: "NAG\G08BAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G08BAF.TF2"; DestDir: "{app}\dem"
Source: "NAG\G08CBF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G08DAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G08EAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G08AGF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G08AGF.TF2"; DestDir: "{app}\dem"
Source: "NAG\G08RAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G08RBF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G10ABF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G10CAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G11CAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G12AAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G12AAF.TF2"; DestDir: "{app}\dem"
Source: "NAG\G12BAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\G13DMF.TF1"; DestDir: "{app}\dem"
Source: "NAG\J06CAF.TF1"; DestDir: "{app}\dem"
Source: "NAG\J06CCF.TF1"; DestDir: "{app}\dem"
Source: "NAG\J06SBF.TF1"; DestDir: "{app}\dem"
Source: "EPS\WAVES.EPS";            DestDir: "{app}\dem"
Source: "EPS\ROSENBROCK.EPS";       DestDir: "{app}\dem"
Source: "EPS\DENDROGRAM.EPS";       DestDir: "{app}\dem"
Source: "EPS\TRINOM.EPS";           DestDir: "{app}\dem"
Source: "EPS\PSFRAG_CDF.EPS";       DestDir: "{app}\dem"
Source: "EPS\PSFRAG_EQUATION.EPS";  DestDir: "{app}\dem"
Source: "EPS\UKMAP.EPS";            DestDir: "{app}\dem"
Source: "EPS\DIFFUSION.EPS";        DestDir: "{app}\dem"
Source: "EPS\ROSE.EPS";             DestDir: "{app}\dem"
Source: "EPS\GAUSS3.EPS";           DestDir: "{app}\dem"
Source: "EPS\CONVOLUTION.EPS";      DestDir: "{app}\dem"
Source: "EPS\SCATCHARD.EPS";        DestDir: "{app}\dem"
Source: "EPS\META.EPS";             DestDir: "{app}\dem"
Source: "EPS\SPLINES.EPS";          DestDir: "{app}\dem"
Source: "EPS\NORMAL_CDF.EPS";       DestDir: "{app}\dem"
Source: "EPS\SURVIVAL.EPS";         DestDir: "{app}\dem"
Source: "EPS\CYLINDER.EPS";         DestDir: "{app}\dem"
Source: "EPS\BETA.EPS";             DestDir: "{app}\dem"
Source: "EPS\PHASEPORTRAIT.EPS";    DestDir: "{app}\dem"
Source: "EPS\ORBITS.EPS";           DestDir: "{app}\dem"
Source: "EPS\PERSPEC1.EPS";         DestDir: "{app}\dem"
Source: "EPS\PERSPEC2.EPS";         DestDir: "{app}\dem"
Source: "EPS\BIPLOT.EPS";           DestDir: "{app}\dem"
Source: "EPS\TRIPLOT.EPS";          DestDir: "{app}\dem"
Source: "EPS\SCATTER3D.EPS";        DestDir: "{app}\dem"
Source: "EPS\PACF.EPS";             DestDir: "{app}\dem"
Source: "EPS\ARIMA.EPS";            DestDir: "{app}\dem"
Source: "EPS\ANOVA.EPS";            DestDir: "{app}\dem"
Source: "EPS\CSAFIT.EPS";           DestDir: "{app}\dem"
Source: "EPS\ELLIPSES_C.EPS";       DestDir: "{app}\dem"
Source: "EPS\VENN_C.EPS";           DestDir: "{app}\dem"
Source: "EPS\CENTROID_C.EPS";       DestDir: "{app}\dem"
Source: "EPS\INSET.EPS";            DestDir: "{app}\dem"
Source: "EPS\EXTRAPOLATE.EPS";      DestDir: "{app}\dem"
Source: "EPS\EPIDEMIC.EPS";         DestDir: "{app}\dem"
Source: "EPS\SURFACE3D.EPS";        DestDir: "{app}\dem"
Source: "data\metafile.tf1";    DestDir: "{app}\dem"
Source: "data\metafile.tf2";    DestDir: "{app}\dem"
Source: "data\metafile.tf3";    DestDir: "{app}\dem"
Source: "data\metafile.tf4";    DestDir: "{app}\dem"
Source: "data\metafile.tf5";    DestDir: "{app}\dem"
Source: "data\metafile.tf6";    DestDir: "{app}\dem"
Source: "data\metafile.tf7";    DestDir: "{app}\dem"
Source: "data\metafile.tf8";    DestDir: "{app}\dem"
Source: "data\metafile.tf9";    DestDir: "{app}\dem"

; SVG
Source: "svg\beta_pdf_plot.svg";            DestDir: "{app}\dem"
Source: "svg\beta_pdf_with_equation.svg";   DestDir: "{app}\dem"
Source: "svg\blank_plot.svg";               DestDir: "{app}\dem"
Source: "svg\chemical_formula1.svg";        DestDir: "{app}\dem"
Source: "svg\exfit.svg";                    DestDir: "{app}\dem" 
Source: "svg\exfit_logplot.svg";            DestDir: "{app}\dem" 
Source: "svg\exfit_normalplot.svg";         DestDir: "{app}\dem" 
Source: "svg\fonts.svg";                    DestDir: "{app}\dem"
Source: "svg\latex_beta_pdf.svg";           DestDir: "{app}\dem"
Source: "svg\latex_chemical_formula.svg";   DestDir: "{app}\dem" 
Source: "svg\latex_chemical_plot.svg";      DestDir: "{app}\dem" 
Source: "svg\latex_chemistry.svg";          DestDir: "{app}\dem" 
Source: "svg\latex_maths.svg";              DestDir: "{app}\dem"
Source: "svg\latex_maths_equation.svg";     DestDir: "{app}\dem"
Source: "svg\latex_maths_plot.svg";         DestDir: "{app}\dem" 
Source: "svg\lines.svg";                    DestDir: "{app}\dem"     
Source: "svg\new_lines.svg";                DestDir: "{app}\dem"     
Source: "svg\stack_plot.svg";               DestDir: "{app}\dem"   
Source: "svg\svg_collage.TFL";              DestDir: "{app}\dem"  
Source: "svg\binomial_poisson.tex";         DestDir: "{app}\dem"   
Source: "svg\chemical_formula1.tex";        DestDir: "{app}\dem" 
Source: "svg\latex_beta_pdf.tex";           DestDir: "{app}\dem" 
Source: "svg\latex_chemical_formula.tex";   DestDir: "{app}\dem" 
Source: "svg\latex_chemical_synthesis.tex"; DestDir: "{app}\dem" 
Source: "svg\latex_maths_equation.tex";     DestDir: "{app}\dem"  
Source: "svg\beta_pdf_plot.metafile";        DestDir: "{app}\dem" 
Source: "svg\blank_plot.metafile";           DestDir: "{app}\dem"   
Source: "svg\exfit_logplot.metafile";        DestDir: "{app}\dem"  
Source: "svg\exfit_normalplot.metafile";     DestDir: "{app}\dem"  
Source: "svg\latex_chemical_plot.metafile";  DestDir: "{app}\dem"  
Source: "svg\latex_maths_plot.metafile";     DestDir: "{app}\dem"  
Source: "svg\lines.metafile";                DestDir: "{app}\dem"  
Source: "c:\setup\svg\new_lines.metafile";            DestDir: "{app}\dem"               


 ; TUTORIALS
 Source: "tutorials\blueball.gif"; DestDir: "{app}\doc"
 Source: "tutorials\simfit_tutorials.html"; DestDir: "{app}\doc"
 Source: "tutorials\introduction_data_preparation.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\simfit_data_files.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\creating_simfit_data_files.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\incomplete_matrices_with_missing_values.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\introduction_results.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\extracting_tables_from_simfit_results_files.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\introduction_distributions.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\uniform_distribution.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\normal_distribution.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\t_distribution.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\chi-square_distribution.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\f_distribution.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\binomial_distribution.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\poisson_distribution.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\bivariate_normal_distribution.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\generating_a_random_vector.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\introduction_tests.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\one_sample_t_test.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\kolmogorov-smirnov_test.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\shapiro-wilks_test.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\poisson_distribution_test.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\unpaired_t_test.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\paired_t_test.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\kolmogorov-smirnov_2_sample_test.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\mann-whitney_U_test.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\wilcoxon_signed_ranks_test.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\chi-square_observed_and_expected.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\contingency_table_tests.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\mcnemar_test.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\cochran_q_test.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\binomial_test.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\sign_test.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\run_test.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\f_test.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\median-mood-david_tests.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\bartlett-levene_tests.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\kendall-concordance_test.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\introduction_data_exploration.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\exhaustive_analysis_of_a_vector.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\exhaustive_analysis_of_a_matrix.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\exhaustive_analysis_of_a_multivariate_normal_matrix.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\t_tests_on_rows_of_a_matrix.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\nonparametric_tests_on_rows_of_a_matrix.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\all_pairwise_comparisons_of_n_samples.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\robust_analysis_of_1_sample.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\robust_analysis_of_2_samples.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\introduction_ANOVA.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\ANOVA_1_way.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\ANOVA_kruskal-wallis.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\ANOVA_tukey_q_test.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\ANOVA_2_way.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\ANOVA_friedman.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\ANOVA_repeat_measures.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\ANOVA_latin_square.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\ANOVA_groups_and_subgroups.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\ANOVA_factorial.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\introduction_proportions.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\binomial_proportions.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\trinomial_proportions.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\meta_analysis.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\ld50.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\power_and_sample_size.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\parameter_confidence_limits.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\robust_analysis_of_1_sample.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\robust_analysis_of_2_samples.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\indices_of_diversity.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\non-central_distributions.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\ligand-binding_cooperativity_analysis.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\kernel-density_estimation.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\false_discovery_rates.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\introduction_multivariate.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\introduction_correlation.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\pearson_product_moment_correlation.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\kendall_tau_spearman_rank_correlation.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\partial_correlation.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\canonical_correlation.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\introduction_cluster_analysis.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\dendrograms.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\metric_and_non-metric_scaling.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\k-means_clustering.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\principal_components.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\factor_analysis.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\procrustes_analysis.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\varimax_quartimax_rotation.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\biplots.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\partial_least_squares.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\plotting_labels.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\introduction_MANOVA.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\MANOVA_examples.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\canonical_variates.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\discriminant_analysis_mahalanobis_distances.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\discriminant_analysis_allocating_observations.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\introduction_survival.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\survival_Kaplan-Meier.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\survival_Weibull.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\survival_GLM.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\survival_Mantel-Haenszel.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\survival_Cox.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\introduction_curve_fitting.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\goodness_of_fit.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\linear_regression_simple.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\linear_regression_comprehensive.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\linear_regression_orthogonal.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\polynomial_regression.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\multilinear_regression.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\partial_least_squares.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\introduction_GLM.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\GLM_examples.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\survival_GLM.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\LD50_using_GLM.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\GLM_loglinear_contingency_table_analysis.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\GLM_logistic_regression.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\GLM_binary_logistic_regression.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\Michaelis-Menten_kinetics.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\high_low_affinity_ligand_binding.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\cooperative_ligand_binding.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\deviations_from_Michaelis-Menten_kinetics.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\fitting_exponential_functions.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\fitting_growth-decay-survival_models.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\initial-rates_lag-times_asymptotes.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\introduction_constrained_nonlinear_regression.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\choosing_parameter_starting_values_and_limits.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\calculating_with_the_best_fit_curve.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\fitting_a_mixture_of_2_normal_distributions.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\fitting_a_beta_distribution_to_observations.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\graphical_deconvolution_of_best_fit_models.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\contours_of_the_objective_function_at_solution_points.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\contours_and_sections_across_a_best_fit_surface.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\fitting_n_functions_of_1_variable.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\fitting_a_convolution_integral.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\fitting_a_single_differential_equation.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\introduction_data_smoothing.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\fitting_cubic_splines.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\splines_for_calculations.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\splines_for_comparing_curves.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\smooth_interpolation_of_discrete_data.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\introduction_calibration_bioassay.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\calibration_using_straight_lines.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\calibration_using_polynomials.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\calibration_using_cubic_splines.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\LD50_using_GLM.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\partial_least_squares.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\T4253H_smoothing.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\lags_and_autocorrelations.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\auto_and_crosscorrelation_matrices.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\ARIMA_with_forecasts.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\introduction_simulation.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\generating_a_random_vector.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\generating_a_random_matrix.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\generating_a_shuffled_list.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\generating_a_random_latin_square.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\generating_a_random_walk.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\uniform_distribution.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\simulating_a_function_of_1_variable.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\simulating_a_function_of_2_variables.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\simulating_a_differential_equation.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\creating_a_user_defined_model.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\simulating_a_user_defined_model.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\simulating_a_parametric_curve.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\simulating_experimental_error.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\introduction_numerical.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\zeros_of_a_polynomial.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\determinant_inverse_eigenvalues_of_a_matrix.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\singular_value_decomposition_of_a_matrix.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\pseudo-inverse_of_a_matrix.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\LU_factorization_of_a_matrix.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\QR_factorization_of_a_matrix.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\Cholesky_factorization_of_a_matrix.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\matrix_multiplication.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\evaluation_of_quadratic_forms.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\solving_exact_linear_equations.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\solving_overdetermined_linear_equations.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\solving_symmetric_eigenvalue_problems.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\initial-rates_lag-times_asymptotes.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\trapezoidal_estimate_of_area_under_a_curve.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\zeros_of_1_function_of_1_variable.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\zeros_of_n_functions_of_n_variables.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\integration_of_1_function_of_1_variable.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\integration_of_1_function_of_m_variables.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\integration_of_n_functions_of_m_variables.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\bound-constrained_quasi-Newton_optimization.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\optimization_contours_with_trajectory.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\evaluation_of_a_convolution_integral.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\introduction_differential_equations.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\Von_Bertalanffy_differential_equation.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\Lotka-Volterra_predator_prey_equations.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\epidemic_differential_equations.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\recurrent_epidemic_differential_equations.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\introduction_graphics.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\lines_symbols_and_text.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\sizes_shapes_and_aspect_ratios.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\pie_charts.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\bar_charts.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\box_and_whisker_plots.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\standard_plots.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\double_plots.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\plotting_error_bars.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\plotting_labels.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\plotting_mathematical_equations.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\configure_template_and_metafiles.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\log_odds_plot.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\log_odds_ratios_plot.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\scatchard_plot.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\hill_plot.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\dendrograms.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\biplots.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\vector_fields.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\surface_plot.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\contour_plot.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\trinomial_proportions.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\skyscraper_and_cylinder_plots.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\plotting_curves_in_space.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\parametric_plots.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\adding_text_arrows_objects_to_graphs.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\structure_of_simfit_postscript_files.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\displaying_standard_and_nonstandard_postscript_fonts.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\editing_postscript_text_symbols_and_lines.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\scaling_rotating_and_stretching_postscript_files.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\using_postscript_specials.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\simfit_latex_options.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\creating_collages_overlays_and_insets.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\editing_postscript_colors.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\creating_hardcopy_from_eps_files.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\svg_graphics.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\introduction_svg.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\importing_latex_chemical_formulas_into_svg.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\importing_latex_maths_equations_into_svg.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\importing_svg_files_into_svg_files.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\using_latex_to_label_svg_y_axes.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\editing_svg_files_using_notepad.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\creating_svg_collages.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\differential_scaling_of_svg_files.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\simfit_test_files.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\significant_digits_in_tables.pdf"; DestDir: "{app}\doc"
 Source: "tutorials\contact.pdf"; DestDir: "{app}\doc"


[Icons]
Name: "{group}\64-bit Simfit"; Filename: "{app}\bin\x64_simfit.exe"; WorkingDir: "{app}\bin"; Comment: "Simfit: A package for simulation, curve fitting, statistical analysis and graph plotting. "
Name: "{group}\64-bit Simfit Reference Manual PDF"; Filename: "{app}\doc\w_manual.pdf"
Name: "{group}\64-bit Simfit Worked Examples PDF"; Filename: "{app}\doc\w_examples.pdf"

[Registry]
Root: HKCU; Subkey: "Software\University of Manchester"; Flags: uninsdeletekeyifempty
Root: HKCU; Subkey: "Software\University of Manchester\Simfit"; Flags: uninsdeletekey
Root: HKLM; Subkey: "Software\University of Manchester"; Flags: uninsdeletekeyifempty
Root: HKLM; Subkey: "Software\University of Manchester\Simfit"; Flags: uninsdeletekey
Root: HKLM; Subkey: "Software\University of Manchester\Simfit\Settings"; ValueType: string; ValueName: "Path"; ValueData: "{app}"


