c
c 
c
      program  main
      external sv_simfit
      call sv_simfit
      end
c       
c
      subroutine sv_simfit
c
c Action : Simplified version of Simfit
c Author : w.g.bardsley, university of manchester, uk
c Version: 1
c Date   : 01/10/2023
c          03/10/2023 now includes sv_demsim70 and sv_simfit1 
c          14/10/2023 extensive editing 
c          16/10/2023 shortened number of items on main list
c          29/10/2023 changed '0' to '11' when using run_programs to call simstat      
c      
      implicit   none
      integer    i_view_results
      integer    i, ifail, isend, j,
     +           numdec, numdec1,
     +           numopt, numopt1,
     +           numsta1,
     +           numtxt1
      integer    n
      parameter (n = 50)
      parameter (numopt = 10)
      integer    numbld(80)
      character (len = 256) fname(n)
      character (len = 30) title
      parameter (title = 'SV_simfit') 
      character (len = 100) line, text1(10) 
      character (len = 1  ) blank
      parameter (blank = ' ')
      logical    action
      external   lstbox, window, sv_simfit_help
      external   run_simfit_programs, i_view_results
      external   run_acrobat, sv_demsim70
      external   putadv, run_program, get_fname
      external   help_simplot
      external   sv_editmt, sv_makfil, sv_makmat, sv_viewer
      external   sv_main_menu
c      
c initialise
c
      j = 1
      i = j
      do i = 1, 30
         numbld(i) = 0
         fname(i) = blank
      enddo
c
c get the paths and filenames 
c            
      call get_fname (n,
     +                fname)
c
c Initialise main menu
c
      isend = 2
      action = .true.
      call window (isend,
     +             title,
     +             action)
c
c call chosen programs
c     
      numdec = 1 
      do while (numdec.lt.numopt)
         ifail = 0
         call sv_main_menu (numdec)

c**********************************************************  
c
c numdec = 1: documents
c   
         if (numdec.eq.1) then
             write (text1,400)
             numdec1 = 1
             numsta1 = 2
             numopt1 = 8
             numtxt1 = numopt1 + 1
             do while (numdec1.lt.numopt1)
                numbld(1) = 4  
                call lstbox (numbld, numdec1,
     +                       numopt1, numsta1, numtxt1,
     +                       text1)
                
                if (numdec1.eq.1) then
                   call sv_simfit_help 
                elseif (numdec1.eq.2) then  
                   call run_acrobat (fname(2))   
                elseif (numdec1.eq.3) then  
                   call run_acrobat (fname(25))   
                elseif (numdec1.eq.4) then
                   call run_acrobat (fname(12))
                elseif (numdec1.eq.5) then         
                   j = 1
                   call sv_viewer (j)  
                elseif (numdec1.eq.6) then         
                   j = 2
                   call sv_viewer (j)
                 elseif (numdec1.eq.7) then         
                   j = 3
                   call sv_viewer (j)     
                endif                                              
             enddo
c*******************************************************************

         elseif (numdec.eq.2) then
c
c numdec = 2: data preparation
c         
             write (text1,900)
             numdec1 = 1
             numsta1 = 2
             numopt1 = 5
             numtxt1 = numopt1 + 1
             do while (numdec1.lt.numopt1)
                numbld(1) = 4  
                call lstbox (numbld, numdec1,
     +                       numopt1, numsta1, numtxt1,
     +                       text1)
                if (numdec1.eq.1) then
                   call sv_makfil 
                elseif (numdec1.eq.2) then
                   call sv_makmat      
                elseif (numdec1.eq.3) then
                   call sv_editmt 
                elseif (numdec1.eq.4) then 
                   call run_program (ifail,
     +                               fname(24), '1')                          
                endif                                  
             enddo  
                

c*********************************************************************
         elseif (numdec.eq.3) then
c
c numdec = 3: linear regression
c         
           call run_program (ifail,
     +                       fname(5), '1')    
c************************************************************************      
         elseif (numdec.eq.4) then
c numdec = 4: call nonlinear regression programs         
             write (text1,300)
             numdec1 = 1
             numsta1 = 2
             numopt1 = 6
             numtxt1 = numopt1 + 1
             do while (numdec1.lt.numopt1)
                numbld(1) = 4  
                call lstbox (numbld, numdec1,
     +                       numopt1, numsta1, numtxt1,
     +                       text1)
                if (numdec1.eq.1) then 
                   call run_program (ifail,
     +                               fname(15), '1') 
                elseif (numdec1.eq.2) then
                   call run_program (ifail,
     +                               fname(16), '1')                            
                elseif (numdec1.eq.3) then              
                   call run_program (ifail,
     +                               fname(17), '1')    
                elseif (numdec1.eq.4) then
                   call run_program (ifail,
     +                               fname(18), '1') 
                elseif (numdec1.eq.5) then
                   call run_program (ifail,
     +                               fname(19), '1')             
                endif
             enddo
c************************************************             
         elseif (numdec.eq.5) then
c         
c numdec = 5: run sv_simstat
c 
            call run_program (ifail,
     +                        fname(7), '11') 
c*************************************************     
         elseif (numdec.eq.6) then
c         
c numdec = 6: calibration
c
             write (text1,800)
             numdec1 = 1
             numsta1 = 2
             numopt1 = 4
             numtxt1 = numopt1 + 1
             do while (numdec1.lt.numopt1)
                call lstbox (numbld, numdec1,
     +                       numopt1, numsta1, numtxt1,
     +                       text1)
                if (numdec1.eq.1) then
                   call run_program (ifail,
     +                               fname(8), ' ') 
                elseif (numdec1.eq.2) then
                   call run_program (ifail,
     +                               fname(20), ' ') 
                elseif (numdec1.eq.3) then
                   call run_program (ifail,
     +                               fname(21), ' ') 
                endif
             enddo
c*************************************************     
         elseif (numdec.eq.7) then 
c         
c numdec = 7: plotting    
c
            numopt1 = 4
            numtxt1 = numopt1 + 1
            numsta1 = 2
            numdec1 = 1 
            write (text1,700) 
            do while (numdec1.lt.numopt1) 
               call lstbox (numbld, numdec1,
     +         numopt1, numsta1, numtxt1,
     +         text1)
               if (numdec1.eq.1) then 
                  call sv_demsim70
               elseif (numdec1.eq.2) then   
                  call run_program (ifail,
     +                              fname(9), '1') 
               elseif (numdec1.eq.3) then
                  call help_simplot ('simplot')  
               endif
            enddo       
              
c*************************************************     
         elseif (numdec.eq.8) then
c         
c numdec = 8: [A/Z] 
c
            call run_simfit_programs()  
c***************************************************            
         elseif (numdec.eq.9) then
c         
c numdec = 9: [Results]         
c
            j = i_view_results()
         endif
            
c*****************************************************
c final check on ifail
c*****************************************************            
         if (ifail.ne.0) then
            write (line,200) ifail
            call putadv (line)
         endif   
      enddo  
c
c close window
c      
      isend = 2
      action = .false.
      call window (isend,
     +             title,
     +             action)  
c
c format statements
c       
                          
  200 format ('IFAIL from run_program =', i3) 
  300 format ('Simplified Simfit nonlinear regression'
     +/'Fit: exponential functions'
     +/'Fit: growth curve models'  
     +/'Fit: Michaelis Menten enzyme kinetic models'
     +/'Fit: High/Low affinity ligand binding models'
     +/'Fit: Cooperative ligand binding models'
     +/'Quit .. Exit nonlinear regression options') 
  400 format ('Help'  
     +/'sv_simfit one-page summary'
     +/'sv_simfit essential details' 
     +/'sv_simfit reference manual' 
     +/'Support'
     +/'Typical Simfit test files'
     +/'Typical Simfit library files'
     +/'Typical Simfit model files'
     +/'Quit ... Exit documents options')
  700 format ('Simplified Simfit graphics' 
     +/'View plot types'
     +/'Run simplified simplot'
     +/'Help'
     +/'Quit ... Exit graphics options') 
  800 format ('Simplified Simfit calibration'
     +/'Polynomial with user-chosen degree'
     +/'Fixed knot cubic splines'
     +/'Variable knot cubic splines'
     +/'Quit ... Exit calibration options')   
  900 format ('Simplified Simfit data file preparation'
     +/'Make/Plot/Edit a curve-fit/plot file'
     +/'Make a vector/matrix file'
     +/'Edit a vector/matrix file'
     +/'Make a Simfit file from Excel/clipboard/txt/CSV/HTML data'
     +/'Quit ... Exit data file options') 
      end   
c
c
      subroutine get_fname (n,
     +                      fname)
      implicit none
      integer , intent (in):: n
      character (len = *), intent (out) :: fname (n)
      character (len = 1024) dem, doc, sim
      integer i, k, l, m
      character (len = 1) blank
      parameter (blank = ' ')
      logical    showit
      external x_demdir, x_docdir, x_simdir
      if (n.lt.1) return  
      do i = 1, n
         fname(i) = blank
      enddo 
      showit = .false.
c get the paths and filenames 
c            
      call x_docdir (k, 
     +               doc)
      if (showit) print *, 'doc = ', doc
            call x_simdir (l,
     +                     sim)        
      if (showit) print *, 'sim = ', sim
      call x_demdir (m,
     +               dem)
             if (showit) print *, 'dem = ', dem
      fname(1) = doc(1:k)//'simfit_summary.pdf'
             if (showit) print *, 1, blank, fname(1)
      fname(2) = doc(1:k)//'essentials_of_simplified_simfit.pdf'
             if (showit) print *, 2, blank, fname(2) 
      fname(5) = sim(1:l)//'x64_linfit.exe'
             if (showit) print *, 5, blank, fname(5) 
      fname(7) = sim(1:l)//'x64_simstat.exe'
             if (showit) print *, 7, blank, fname(7)
      fname(8) = sim(1:l)//'x64_polnom.exe' 
             if (showit) print *, 8, blank, fname(8)
      fname(9) = sim(1:l)//'x64_simplot.exe' 
             if (showit) print *, 9, blank, fname(9)
      fname(12) = doc(1:k)//'contact.pdf'
             if (showit) print *, 12, blank,  fname(12)
      fname(15) = sim(1:l)//'x64_exfit.exe'
             if (showit) print *, 15, blank, fname(15)  
       fname(16) = sim(1:l)//'x64_gcfit.exe'
             if (showit) print *, 16, blank, fname(16)  
       fname(17) = sim(1:l)//'x64_mmfit.exe'
             if (showit) print *, 17, blank, fname(17)  
       fname(18) = sim(1:l)//'x64_hlfit.exe'
             if (showit) print *, 18, blank, fname(18)  
       fname(19) = sim(1:l)//'x64_sffit.exe'
             if (showit) print *, 19, blank, fname(19)  
       fname(20) = sim(1:l)//'x64_calcurve.exe'
             if (showit) print *, 20, blank, fname(20)  
       fname(21) = sim(1:l)//'x64_spline.exe'
             if (showit) print *, 21, blank, fname(21)
       fname(22) = sim(1:l)//'x64_makfil.exe'
             if (showit) print *, 22, blank, fname(22)
c       fname(23) = sim(1:l)//'sv_simstat.exe'
c             if (showit) print *, 23, blank, fname(23)
       fname(24) = sim(1:l)//'x64_maksim.exe'
             if (showit) print *, 24, blank, fname(24)
       fname(25) = doc(1:k)//'sv_manual.pdf'
             if (showit) print *, 25, blank, fname(25)         
      end
c
c
      subroutine sv_simfit_help
      integer i, icolor, ixl, iyl, lshade, numbld(30), numtxt
      parameter (icolor = 9,
     +           ixl = 0,
     +           iyl = 0,
     +           lshade = 0,
     +           numtxt = 29) 
      character (len = 100) text(30)
      logical fixed
      parameter (fixed = .false.)
      external w_patch1
      do i = 1, numtxt
         numbld(i) = 0
      enddo   
      numbld(1) = 4
      numbld(6) = 1
      numbld(19) = 1
      write (text, 100)
      call w_patch1 (icolor, ixl, iyl, lshade, numbld, numtxt,
     +               text,
     +               fixed)
  100 format (
     +'Description of this simplified version of the Simfit program'  
     +/  
     +/'The Simfit package is large and comprehensive covering many'  
     +/'of the areas often required in data analysis'
     +/
     +/'Standard features'
     +/
     +/'1. Preparation and editing data files.'
     +/'2. Linear regression and constrained nonlinear optimisation.'
     +/'3. Statistics e.g., ANOVA, GLM, partial least squares, power'
     +/'   calculations, central and non-central distributions.'                                               
     +/'4. Simulation e.g., random numbers and matrices.' 
     +/
     +/'The program you are now using is a much simplified version'
     +/'designed so that first-time users can try out Simfit' 
     +/'before using the full version. Actually users can run any' 
     +/'of the Simfit programs by simply choosing the [A/Z] option.' 
     +/
     +/'Special features' 
     +/
     +/'1. Programs provide the option to practise with test files.'
     +/'2. Requested data can be read in from a file, copied as tables'
     +/'   from the clipboard, or typed in directly.'
     +/'3. Programs save tables to view/save using the [Results]option.' 
     +/'4. Hardcopy as *.png/*pdf is available but device independent'
     +/'   vector graphic *.svg/*.eps for LaTeX users is provided.' 
     +/'5. Users can supply models to simulate or fit including 3D'
     +/'   models and systems of nonlinear differential equations.'
     +/)
      end
c
c
      subroutine sv_main_menu (numdec)
      integer, intent(inout) :: numdec 
      integer    i
      integer    icolor, nmax, numopt, numhdr
      parameter (icolor = 9, nmax = 24, numopt = 10, numhdr = 24)
      integer    numbld(nmax), numpos(nmax) 
      character (len = 100) header(nmax), option(nmax)
      character (len = 1  ) blank
      parameter (blank = ' ')
      logical    first
      data       first / .true. /
      save       first, numbld, numpos, header, option 
      external   title1
      if (first) then
         first = .false.
         do i = 1, nmax
            numbld(i) = 0
            numpos(i) = 1
            header(i) = blank
            option(i) = blank
         enddo   
         write (header,100)  
         write (option,300)
      endif   
      numdec = 1
      call title1 (icolor, numbld, numdec, numhdr, numopt, numpos,
     +             header, option)
  100 format (
     + 'Program       `sv_simfit.exe' 
     +/'              ` '
     +/'Version       ` 8.1.3'
     +/'              ` '
     +/'Compiler      `Silverfrost FTN95' 
     +/'              ` '
     +/'Action        `A simplified interface to the simfit' 
     +/'              `package involving cut-down versions of'
     +/'              `popular programs for first-time users.'
     +/'              ` '
     +/'Source        `The simfit package is Open Source and'
     +/'              `the sv_simfit code is distributed within'
     +/'              `the same zip file as the simfit package.'
     +/'              ` '
     +/'Web document  `Essentials_of_simplified_simfit.pdf'  
     +/'              ` '
     +/'Manual        `sv_manual.pdf'
     +/'              ` ' 
     +/'Author        `W.G.Bardsley'
     +/'              `University of Manchester, u.k.' 
     +/'              ` '
     +/'Websites      `https://simfit.uk'
     +/'              `https://simfit.org.uk'
     +/'              `https://simfit.silverfrost.com' )
  300 format (  
     + 'Help'                                                       
     +/'Data files'                                        
     +/'Linear regression'                                               
     +/'Nonlinear regression'                                            
     +/'Statistics'                                                      
     +/'Calibration'                                                     
     +/'Plotting'                                                   
     +/'Full programs'                                                           
     +/'Results'                                                         
     +/'Quit ... Exit')    
      end
c
c    