C
C SIMSTAT4.INS: Include file for SIMSTAT
C =============
C
C SUB004
C Date of this version 12/03/2006
C
C-----------------------------------------------------------------------
C
      SUBROUTINE SV_SUB004 (NIN, NOUT)
C
C ANOVAP, analysis of proportions
C
      IMPLICIT   NONE
      INTEGER    NIN, NOUT
      EXTERNAL   SV_ANOVAP
      CLOSE (UNIT = NIN)
      CALL SV_ANOVAP (NIN, NOUT)
      CLOSE (UNIT = NIN)
      END
C
C-----------------------------------------------------------------------
C
C
      SUBROUTINE SV_ANOVAP (NIN, NOUT)
C
C ACTION : Analysis of proportions
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.,
C          Derived from original ANOVAP 22/12/2004
C          16/02/2005 increased dimension of A to A(NMAX,4) for call to LDLC50
C          10/06/2005 extensive editing with increased argument list
C          14/02/2006 now calls m_matone
C          23/07/2007 set NCOL = NROW = 0 to force use of SIM256 when initialising
C          10/01/2013 minor editing
C          04/12/2020 added trinomial confidence contours   
C
C           NIN: (input/unchanged) Unconnected unit for data input
C          NOUT: (input/unchanged) Unit connected for results
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    NIN, NOUT
C
C Locals
C
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 7,
     +           NSTART = 16)
      INTEGER    NUMBLD(30), NUMPOS(20)
      INTEGER    ISEND
      INTEGER    NCOL12, NROW12
      INTEGER    NCOL13, NROW13
      INTEGER    NCOL14, NROW14
      INTEGER    NCOL32, NROW32
      CHARACTER  TEXT(30)*100
      CHARACTER  FNAME12*1024, TITLE12*80
      CHARACTER  FNAME13*1024, TITLE13*80
      CHARACTER  FNAME14*1024, TITLE14*80
      CHARACTER  FNAME32*1024, TITLE32*80
      LOGICAL    BORDER, FLASH, HIGH, REPEET
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   LBOX01, PATCH1, REVPRO
      EXTERNAL   M_MATONE
      SAVE       NCOL12, NROW12, FNAME12, TITLE12
      SAVE       NCOL13, NROW13, FNAME13, TITLE13
      SAVE       NCOL14, NROW14, FNAME14, TITLE14
      SAVE       NCOL32, NROW32, FNAME32, TITLE32
      DATA       NCOL12, NROW12 / 0, 0 /
      DATA       NCOL13, NROW13 / 0, 0 /
      DATA       NCOL14, NROW14 / 0, 0 /
      DATA       NCOL32, NROW32 / 0, 0 /
      DATA       FNAME12, TITLE12 / 'ld50.tf1',
     +                              'Test file ld50.tf1' /
      DATA       FNAME13, TITLE13 / 'binomial.tf3',
     +                              'Test file binomial.tf3' /
      DATA       FNAME14, TITLE14 / 'meta.tf1',
     +                              'Test file meta.tf1' /
      DATA       FNAME32, TITLE32 / 'trinom.tf1',
     +                              'Test file trinom.tf1' / 
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 20*1 /
      REPEET = .TRUE.
      DO WHILE (REPEET)
         WRITE (TEXT,100)
         NTEXT = NSTART + NUMOPT - 1
         NUMDEC = NUMOPT - 1
         NUMBLD(1) = 1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         IF (NUMDEC.EQ.1) THEN
C
C NUMDEC = 1: Analysis of proportions
C
            ISEND = 13
            CALL M_MATONE (ISEND, NCOL13, NIN, NOUT, NROW13,
     +                     FNAME13, TITLE13)
         ELSEIF (NUMDEC.EQ.2) THEN
C
C NUMDEC = 2: Meta analysis
C
            ISEND = 14
            CALL M_MATONE (ISEND, NCOL14, NIN, NOUT, NROW14,
     +                     FNAME14, TITLE14)
         ELSEIF (NUMDEC.EQ.3) THEN
C
C NUMDEC = 3: Bioassay and LD50
C
            ISEND = 12
            CALL M_MATONE (ISEND, NCOL12, NIN, NOUT, NROW12,
     +                     FNAME12, TITLE12)
          ELSEIF (NUMDEC.EQ.4) THEN
C
C NUMDEC = 4: Trinomial confidence contours
C     
            ISEND = 32
            CALL M_MATONE (ISEND, NCOL32, NIN, NOUT, NROW32,
     +                     FNAME32, TITLE32)
         ELSEIF (NUMDEC.EQ.5) THEN
C
C NUMDEC = 5: Results
C
            CALL REVPRO (NOUT)
         ELSEIF (NUMDEC.EQ.6) THEN
C
C NUMDEC = 6: Help
C
            WRITE (TEXT,200)
            NTEXT = 22
            NUMBLD(1) = 1
            NUMBLD(14) = 1
            NUMBLD(19) = 1
            CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NTEXT,
     +                   TEXT, BORDER)
            NUMBLD(1) = 0
            NUMBLD(14) = 0
            NUMBLD(19) = 0
         ELSE
C
C NUMDEC = 7: Exit
C
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'SV_SIMSTAT analysis of proportions options'
     +/
     +/'y = number of successes (where Y is b(N,p))'
     +/'N = number of Bernoulli trials (N >= y >= 0)'
     +/'x = optional covariate, e.g. time, concentration.'
     +/'If supplied, x must be in nondecreasing order.'
     +/'X is used as the X-coordinate in binomial p-plots.'
     +/'The program calculates/plots p_hat = y/N with exact'
     +/'con. lim., and lists all relative risks, differences,'
     +/'odds/ratios, with large sample confidence limits.'
     +/'For k adjacent 2 x 2 pairs, Cochran-Mantel-Haenszel'
     +/'Meta Analysis can be done, and Log Odds Ratios plotted.'
     +/'Test files: binomial.tf2 (y,N), binomial.tf3 (y,N,x),'
     +/'meta.tf1 (2x2xk Cochran-Mantel-Haenszel Meta Analysis)'
     +/
     +/'Analysis of binomial proportions'
     +/'Cochran-Mantel-Haenszel Meta Analysis'
     +/'Bioassay, Dose response and LD50'
     +/'Plot trinomial proportions confidence contours' 
     +/'Results'
     +/'Help'
     +/'Quit ... Exit analysis of proportions options')
  200 FORMAT (
     + 'Analysis of proportions with dichotomous data'
     +/'It is assumed that you have conducted a number of experiments'
     +/'with only two possible outcomes and wish to test'
     +/'H0: identical binomial parameters p.'
     +/'This program will calculate all possible binomial parameter p'
     +/'estimates with exact confidence limits, and all differences,'
     +/'relative risks and relative odds with large sample confidence'
     +/'limits. To avoid lengthy calculations and output lists the'
     +/'options involving all possible comparisons should not be used'
     +/'with large data sets (say > 5 sets of Bernoulli trials). The'
     +/'p-estimates and log[Odds] with exact confidence limits can be'
     +/'plotted.'
     +/
     +/'Meta Analysis'
     +/'For k pairs of experiments leading to 2 by 2 contingency tables'
     +/'an overall analysis is performed, but a Cochran-Mantel-Haenszel'
     +/'test is also done and log[Odds-Ratios] can be plotted.'
     +/
     +/'Curve fitting'
     +/'GLM data in x,y,N,s format can be accepted and y/N data can be'
     +/'transformed into x,p-hat,s format for fitting models to p-hat'
     +/'with either estimated weights, or with all s = 1.')
      END
C
C

