
C
C SIMSTATA.INS: Include file for SIMSTAT
C =============
C
C SUB010
C Date of this version 12/03/2006
C 31/07/2012 Procrustes does not now require NAG
C 05/01/2013 Orthomax   does not now require NAG
C
C
C-----------------------------------------------------------------------
C
      SUBROUTINE SV_SUB010 (MAX_MM, MAX_MV, NAMAX, NB_MV, NC_MV, NCSAV,
     +                      NC1_MM, NC2_MM, NIN, NOUT, NRSAV, NR_MV,
     +                      NR1_MM, NR2_MM, NZMAX, NZSAV,
     +                      F1_MM, F1_MV, F2_MM, F2_MV, FNAMEA, FNAMEZ,
     +                      NO_DATA, NO_FILE, S_MM, S_MV, STOREA,
     +                      STOREZ, TITLEA, TITLEZ, T1_MM, T1_MV, T2_MM,
     +                      T2_MV)
C
C Numerical calculations
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    MAX_MM, MAX_MV, NZMAX
      INTEGER    NC1_MM(MAX_MM), NC2_MM(MAX_MM), NR1_MM(MAX_MM),
     +           NR2_MM(MAX_MM)
      INTEGER    NB_MV(MAX_MV), NC_MV(MAX_MV), NR_MV(MAX_MV)
      INTEGER    NAMAX, NCSAV(NAMAX), NIN, NOUT, NRSAV(NAMAX),
     +           NZSAV(NZMAX)
      CHARACTER  F1_MM(MAX_MM)*(*), F1_MV(MAX_MV)*(*),
     +           F2_MM(MAX_MM)*(*), F2_MV(MAX_MV)*(*),
     +           S_MM(MAX_MM)*(*), S_MV(MAX_MV)*(*),
     +           T1_MM(MAX_MM)*(*), T1_MV(MAX_MV)*(*),
     +           T2_MM(MAX_MM)*(*), T2_MV(MAX_MV)*(*)
      CHARACTER  FNAMEA(NAMAX)*(*), FNAMEZ(NZMAX)*(*),
     +           NO_DATA*(*), NO_FILE*(*),
     +           STOREA(NAMAX)*(*), STOREZ(NZMAX)*(*),
     +           TITLEA(NAMAX)*(*), TITLEZ(NZMAX)*(*)
C
C Locals
C
      INTEGER    IX, IY, NUMDEC, NUMOPT, NTEXT
      PARAMETER (IX = 4, IY = 4, NUMOPT = 11, NTEXT = NUMOPT + 1)
      INTEGER    I, ISEND
C      CHARACTER  NAG5(2)*5, TEXT(NTEXT)*100
      CHARACTER  TEXT(NTEXT)*100
      LOGICAL    TITLES
      PARAMETER (TITLES = .TRUE.)
      LOGICAL    REPEET
C      EXTERNAL   LVIEW2, REVPRO, M_VECONE, STORE_Z, STORE_A, M_MATONE,
C     +           M_MATVEC, M_MATTWO, STORE_MM, STORE_MV 
      EXTERNAL   LVIEW2, REVPRO, M_VECONE, STORE_Z, STORE_A, M_MATONE,
     +           M_MATVEC, STORE_MM, STORE_MV       
      EXTERNAL   HELP_SIMSTAT
      REPEET = .TRUE.
      DO WHILE (REPEET)
         CALL STORE_A (NAMAX, NCSAV, NRSAV,
     +                 FNAMEA, NO_DATA, NO_FILE, STOREA, TITLEA)
         CALL STORE_MM (MAX_MM, NC1_MM, NC2_MM, NR1_MM, NR2_MM,
     +                  F1_MM, F2_MM, NO_DATA, NO_FILE, S_MM, T1_MM,
     +                  T2_MM)
         CALL STORE_MV (MAX_MV, NB_MV, NC_MV, NR_MV,
     +                  F1_MV, F2_MV, NO_DATA, NO_FILE, S_MV, T1_MV,
     +                  T2_MV)
         CALL STORE_Z (NZMAX, NZSAV,
     +                 FNAMEZ, NO_DATA, NO_FILE, STOREZ, TITLEZ)
C         NAG5(1) = STOREA(30)
C         NAG5(2) = S_MM(3) 
         CLOSE (UNIT = NIN)
C     +         WRITE (TEXT,100) STOREZ(10), (STOREA(I), I = 1, 2), !1-3
C     +                          STOREA(37),                        !4
C     +                         (STOREA(I), I = 3, 5),              !5-7    
C     +                         (S_MV(I), I = 1, 5),                !8-12
C     +                         (S_MM(I), I = 1, 2),                !13-14  
C     +                         (NAG5(I), I = 1, 2)                 !15-16
         WRITE (TEXT,100) STOREZ(10), (STOREA(I), I = 1, 2), !3
     +                    STOREA(37),                        !1 
     +                   (S_MV(I), I = 1, 4)                 !4 
         NUMDEC = NUMOPT - 1
         CALL LVIEW2 (IX, IY, NUMDEC, NUMOPT,
     +                TEXT,
     +                TITLES)
         IF (NUMDEC.EQ.1) THEN
C
C Zeros of a polynomial
C
            ISEND = 10
            CALL M_VECONE (ISEND, NIN, NOUT, NZSAV(ISEND),
     +                     FNAMEZ(ISEND), TITLEZ(ISEND))
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Square matrix calculations
C
            ISEND = 1
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.EQ.3) THEN
C
C Singular value decomposition
C
            ISEND = 2
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.EQ.4) THEN
C
C Pseudo inverse
C
            ISEND = 37
            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
     +                     FNAMEA(ISEND), TITLEA(ISEND))
C        ELSEIF (NUMDEC.EQ.5) THEN
C
C LU factorisation
C
C            ISEND = 3
C            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
C     +                     FNAMEA(ISEND), TITLEA(ISEND))
C         ELSEIF (NUMDEC.EQ.6) THEN
C
C QR factorisation
C
C            ISEND = 4
C            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
C     +                     FNAMEA(ISEND), TITLEA(ISEND))
C         ELSEIF (NUMDEC.EQ.7) THEN
C
C Cholesky factorisation
C
C            ISEND = 5
C            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
C     +                     FNAMEA(ISEND), TITLEA(ISEND))
         ELSEIF (NUMDEC.EQ.5) THEN
C
C Ax = b: A nonsingular
C
            ISEND = 1
            CALL M_MATVEC (ISEND, NB_MV(ISEND), NC_MV(ISEND), NIN, NOUT,
     +                     NR_MV(ISEND),
     +                     F1_MV(ISEND), F2_MV(ISEND), T1_MV(ISEND),
     +                     T2_MV(ISEND))
         ELSEIF (NUMDEC.EQ.6) THEN
C
C Ax = b: L1 overdetermined
C
            ISEND = 2
            CALL M_MATVEC (ISEND, NB_MV(ISEND), NC_MV(ISEND), NIN, NOUT,
     +                     NR_MV(ISEND),
     +                     F1_MV(ISEND), F2_MV(ISEND), T1_MV(ISEND),
     +                     T2_MV(ISEND))
         ELSEIF (NUMDEC.EQ.7) THEN
C
C Ax = b: L2 overdetermined
C
            ISEND = 3
            CALL M_MATVEC (ISEND, NB_MV(ISEND), NC_MV(ISEND), NIN, NOUT,
     +                     NR_MV(ISEND),
     +                     F1_MV(ISEND), F2_MV(ISEND), T1_MV(ISEND),
     +                     T2_MV(ISEND))
         ELSEIF (NUMDEC.EQ.8) THEN
C
C  Ax = b: L-infinity
C
            ISEND = 4
            CALL M_MATVEC (ISEND, NB_MV(ISEND), NC_MV(ISEND), NIN, NOUT,
     +                     NR_MV(ISEND),
     +                     F1_MV(ISEND), F2_MV(ISEND), T1_MV(ISEND),
     +                     T2_MV(ISEND))
C         ELSEIF (NUMDEC.EQ.12) THEN
C
C Evalute quadratic forms
C
C            ISEND = 5
C            CALL M_MATVEC (ISEND, NB_MV(ISEND), NC_MV(ISEND), NIN, NOUT,
C     +                     NR_MV(ISEND),
C     +                     F1_MV(ISEND), F2_MV(ISEND), T1_MV(ISEND),
C     +                     T2_MV(ISEND))
C         ELSEIF (NUMDEC.EQ.13) THEN
C
C Matrix multiplication
C
C            ISEND = 1
C            CALL M_MATTWO (ISEND, NC1_MM(ISEND), NC2_MM(ISEND), NIN,
C     +                     NOUT, NR1_MM(ISEND), NR2_MM(ISEND),
C     +                     F1_MM(ISEND), F2_MM(ISEND), T1_MM(ISEND),
C     +                     T2_MM(ISEND))
C         ELSEIF (NUMDEC.EQ.14) THEN
C
C Ax = lambda*Bx
C
C            ISEND = 2
C            CALL M_MATTWO (ISEND, NC1_MM(ISEND), NC2_MM(ISEND), NIN,
C     +                     NOUT, NR1_MM(ISEND), NR2_MM(ISEND),
C     +                     F1_MM(ISEND), F2_MM(ISEND), T1_MM(ISEND),
C     +                     T2_MM(ISEND))   
C         ELSEIF (NUMDEC.EQ.15) THEN
C
C Rotation: orthomax
C         
C            ISEND = 30
C            CALL M_MATONE (ISEND, NCSAV(ISEND), NIN, NOUT, NRSAV(ISEND),
C     +                     FNAMEA(ISEND), TITLEA(ISEND))
C         ELSEIF (NUMDEC.EQ.16) THEN
C
C Rotation: Procrustes
C
C            ISEND = 3
C            CALL M_MATTWO (ISEND, NC1_MM(ISEND), NC2_MM(ISEND), NIN,
C     +                     NOUT, NR1_MM(ISEND), NR2_MM(ISEND),
C     +                     F1_MM(ISEND), F2_MM(ISEND), T1_MM(ISEND),
C     +                     T2_MM(ISEND))
         ELSEIF (NUMDEC.EQ.NUMOPT - 2) THEN
C
C Results
C
            CALL REVPRO (NOUT)
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
C
C Help
C
            CALL HELP_SIMSTAT ('simstat')
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Quit calculation options
C
            REPEET = .FALSE.
         ENDIF
         CLOSE (UNIT = NIN)
      ENDDO
  100 FORMAT (
     + 'SV_SIMSTAT numerical analysis options    `Data format'
     +/'Polynomial: calculate zeros              `nx1 vector',1X,A
     +/'Matrix: determinant/eigenvalues/inverse  `nxn matrix',1X,A
     +/'Matrix: singular value decomposition     `mxn matrix',1X,A
     +/'Matrix: pseudo inverse and rank          `mxn matrix',1X,A
C     +/'Matrix: LU factorisation/norms/cond.no.`mxn matrix',1X,A
C     +/'Matrix: QR factorisation               `mxn matrix',1X,A
C     +/'Matrix: Cholesky factorisation         `nxn pos-def matrix',
C     +1X,A
     +/'Solve: Ax = b (A nonsingular)            `A nxn, b nx1',
     +1X,A
     +/'Solve: Ax = b (L_1 norm overdetermined)  `A mxn (m > n), b mx1',
     +1X,A
     +/'Solve: Ax = b (L_2 norm overdetermined)  `A mxn (m > n), b mx1',
     +1X,A
     +/'Solve: Ax = b (L_i norm overdetermined)  `A mxn (m > n), b mx1',
     +1X,A
C     +/'Calculate: (y^T)Ay, (y^T)(A^{-1})y     `A nxn, y nx1',
C     +1X,A
C     +/'Calculate: AB,(A^T)B,A(B^T),(A^T)(B^T) `A(ma,na), B(mb,nb)',
C     +1X,A
C     +/'Calculate: Ax = lambda*Bx (B pos.def.) `A, B nxn symmetric',
C     +1X,A  
C     +/'Rotation: Orthomax                     `A mxn',1X,A                                
C     +/'Rotation: Procrustes                   `A, B mxn',1X,A
     +/'Results                                  `...'
     +/'Help                                     `...'
     +/'Quit ... Exit numerical analysis options `...')
      END
C
C
