//
// This code is by David Bailey for a Simfit curtain which uses subroutine c_window
// 11/08/2014 ... Tested by WGB and seems OK with 32-bit and 64-bit Simfit 
// 29/10/2015 ... Edited for SetProcessDpiAwareness
//

/***********************************************************/
/*                                                         */
/*      Byte 0  Set to 1 to close the bar                  */
/*      Byte 1  Set to 1 to close the driver               */
/*      Byte 2  Set to 1 by driver to say it is present    */
/*      Byte 3  Set to 1 to close the individual program   */
/*                                                         */
/***********************************************************/
#include<windows.h>
#include<stdio.h>
#include<stdlib.h>
#define CLOSE_BAR 0
#define CLOSE_DRIVER 1
#define DRIVER_PRESENT 2
#define CLOSE_PROGRAM 3

#define register_message_loop_hook(a) __register_message_loop_hook(a)
extern  "C" void register_message_loop_hook(void*);
#define winio __winio
#define create_interprocess_shared_memory(a,b) __create_interprocess_shared_memory(a,b)
#define window_update(a) __window_update(a)
#define start_process_and_wait(a,b,c) __start_process_and_wait(a,b,c)
#define wait_for_window_to_close(a) __wait_for_window_to_close(a)
//$$$$$$$ #define temporary_yield() __temporary_yield()
#define sleep_at(a) __sleep_at(a)
#define open_interprocess_shared_memory(a)  __open_interprocess_shared_memory(a)

extern "C" int winio(char*,...);
extern "C" char* create_interprocess_shared_memory(CHAR *map_name,int size);
// 
extern "C" void wait_for_window_to_close(int*);
extern "C" void __set_dpi_awareness(int);

int bar_var;
char* shared_mem;
int definitely_closing = 0;
HANDLE bar_handle;



int quit()
{
  int ans;
  if(definitely_closing) return 0;
  if(shared_mem[DRIVER_PRESENT] != 0)
  {
    ans = winio((char*)"%sy[topmost]%ca[Are you sure you want to quit?]%bt[Exit Simfit]  %bt[Exit program] %bt[Cancel]");
    if(ans == 3 || ans == 0) return 1;
    if(ans == 1) shared_mem[CLOSE_DRIVER] = 1;
    shared_mem[CLOSE_PROGRAM] = 1;
  }
  else
  {
    ans = winio((char*)"%sy[topmost]%ca[Are you sure you want to quit?]%cn %8bt[Quit] %8bt[Cancel]");
    if(ans == 2 || ans == 0) return 1;
    shared_mem[CLOSE_PROGRAM] = 1;
  }
  TerminateProcess(OpenProcess(PROCESS_ALL_ACCESS,0,GetCurrentProcessId()),0);
  return 0;
}

int check_for_close()
{
  if(shared_mem[CLOSE_BAR] != 0)
  {
    shared_mem[CLOSE_BAR] = 0;
    TerminateProcess(OpenProcess(PROCESS_ALL_ACCESS,0,GetCurrentProcessId()),0);        
  }
  return 0;
}

int main()
{
  char control_file[1024];
  int width,depth;
  __set_dpi_awareness(1);
  shared_mem = create_interprocess_shared_memory((char*)"SIMFIT",200);
  register_message_loop_hook((void*) check_for_close);
  width = clearwin_info("SCREEN_WIDTH");
//      Note that this uses native calls, but after cleawin has been initialised, and set the DPI!  
  bar_var =-1;  
  depth = GetSystemMetrics(SM_CYCAPTION)+GetSystemMetrics(SM_CYMENU)+1;
  winio((char*)"%ww[no_maxminbox]%mn[File[Exit]]%ca@%hw%sp%lw%cc",quit,shared_mem+10,
    &bar_handle,0,0,&bar_var,quit);
  MoveWindow((HWND) bar_handle,0,0,width,depth,1);
//    wait_for_window_to_close(&bar_var);
  GetTempPath(1024,control_file);
  strcat(control_file,"SimfitBar.tmp");
//$$$$$$$   strcpy(control_file,"c:\\cpp\\junk");
  while(bar_var)
  {
    Sleep(100);
    temporary_yield();
    FILE* f = fopen(control_file,"wb");
    if(f)
    {
      definitely_closing = 1;
      SendMessage(bar_handle,WM_CLOSE,0,0);
      temporary_yield();
    }
  }
}







