C
C ADDERR.FOR
C FTN95 version
C =============
C
C MAIN
C
C     INCLUDE 'adderr1.for'
C     INCLUDE 'adderr2.for'
C     INCLUDE 'adderr3.for'
C     INCLUDE 'dllchk.for'

C*********************************************************************
C Start of MODULE_ADDERR
C
      MODULE MODULE_ADDERR
      IMPLICIT NONE
      INTEGER NMAX 
C
C Allocatable arrays
C      
      INTEGER,          ALLOCATABLE :: NUM(:)
      DOUBLE PRECISION, ALLOCATABLE :: EE(:), XX(:), YY(:)
      DOUBLE PRECISION, ALLOCATABLE :: E(:), ESAV(:), X(:), Y(:), Z(:)
      DOUBLE PRECISION, ALLOCATABLE :: U(:), UU(:), V(:), VV(:)      
      END MODULE MODULE_ADDERR
      
C End of MODULE_ADDERR
C***********************************************************************      

      PROGRAM MAIN

      USE MODULE_ADDERR      
C
C VERSION : details set in SIMVER/DLLCHK
C FORTRAN : 95, Double precision
C NAG     : G05CAF, G05CCF, G05DBF, G05DDF, G05DFF, G05DHF, G05DYF
C INPUT   : File with TITLE, NPTS, X, Y, Std. error in Y, etc.
C           as prepared by programs MAKFIL, MAKDAT or EDITFL
C OUTPUT  : File after adding random error.
C ADVICE  : Maximum array dimensions set in parameter statement
C           Y = F(X) --> Z = Y + ERRROR
C           Y = F(X,U) --> Z = Y + ERROR
C           Y = F(X,U,V) --> Z = Y + ERROR
C           EE, UU, VV, XX, YY = ORIGINAL VALUES
C           ESAV = exact error when replicates used
C AUTHOR  : W. G. Bardsley, University of Manchester U.K., 25/11/85
C REVISED : 21/11/1989 Option for replicates and graph
C           15/12/1989 Mixed power law added
C           11/01/1990 ERR007 and ERRFCN added
C           05/03/1991 DATTIN/FNAMES/GRF002
C           28/04/1991 SCREEN/GRFGK2
C           22/05/1991 GKS002
C           30/07/1992 CHECKT, ENDALL, GETNUM, GETCHR
C           27/02/1993 GET???, PUT??? and compressed
C           20/09/1994 DBOS version
C           16/02/1995 Revised for Salamanca
C           24/11/1995 ESAV = 1 now if ESAV < 1.0e-20
C           17/05/1997 win32 version
C           05/08/1998 added dllchk
C           14/12/1998 Changed TUTORS to TUTOR1
C           12/09/1999 Added call to WINDOW
C           12/02/2000 Introduced SIMVER
C           19/03/2001 revised
C           11/02/2005 moved help to DLL, initialised ESAV
C           28/03/2008 edited for version 6 
C           06/04/2022 added E_NUMBERS and E_FORMATS, etc. and increased NMAX to 2000
C           08/05/2022 now defines NKEEP (= original NPTS) after the call to DATAIN and added NKEEP,
C                      XX(NKEEP), and YY(NKEEP) to simplify the call to GKS in OUTDAT
C
      IMPLICIT   NONE
      INTEGER    NBIG
      PARAMETER (NBIG = 1000)
      INTEGER    MTEXT, NDEC, NKEEP, NPTS, NREPS, NVAR
      INTEGER    IERR, ISEND, ITYPE
      DOUBLE PRECISION XVER, YVER
      CHARACTER  FNAME(2)*1024, TEX(NBIG)*80, TITLE*80
      CHARACTER  BLANK*1, PNAME*6
      PARAMETER (BLANK = ' ', PNAME = 'ADDERR')
      CHARACTER  DVER*30, PVER*15
      PARAMETER (PVER = 'w_adderr.exe')
      LOGICAL    ABORT, ACTION, ECALC, FIRST, JUMP, REPEET, SHOW
      EXTERNAL   STOPGO
      EXTERNAL   ADVISE, DATAIN, DETAIL, ERR001, ERR002, ERR003, ERR004,
     +           ERR005, ERR006, ERR007, ERROUT, OUTDAT
      EXTERNAL   DLLCHK, WINDOW, SIMVER
      EXTERNAL   G05CCF$

C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C
      ISEND = 1
      ACTION = .TRUE.
      TITLE = 'Simfit: program '//PNAME
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
      CALL SIMVER (XVER, YVER,
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER, 
     +             DVER, PVER, 
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C

C
C Initialise the program
C
      CALL G05CCF$
      FIRST = .TRUE.
      CALL ADVISE (DVER,
     +             ABORT, FIRST)
      IF (ABORT) THEN
C
C No action required
C        
         REPEET = .FALSE.
      ELSE
C
C Initialise
C
         ITYPE = 0
         NVAR = 1
         NPTS = 1
         NREPS = 5
         JUMP = .FALSE.
         REPEET = .TRUE.
         FNAME(1) = BLANK
         FNAME(2) = BLANK
         NMAX = 2000 
         IERR = 0
         ALLOCATE(NUM(NMAX), STAT = IERR)
         IF (IERR.EQ.0) ALLOCATE(EE(NMAX), STAT = IERR)
         IF (IERR.EQ.0) ALLOCATE(XX(NMAX), STAT = IERR)
         IF (IERR.EQ.0) ALLOCATE(YY(NMAX), STAT = IERR)
         IF (IERR.EQ.0) ALLOCATE(E(NMAX), STAT = IERR)
         IF (IERR.EQ.0) ALLOCATE(ESAV(NMAX), STAT = IERR)
         IF (IERR.EQ.0) ALLOCATE(X(NMAX), STAT = IERR)
         IF (IERR.EQ.0) ALLOCATE(Y(NMAX), STAT = IERR)
         IF (IERR.EQ.0) ALLOCATE(Z(NMAX), STAT = IERR)
         IF (IERR.EQ.0) ALLOCATE(U(NMAX), STAT = IERR)
         IF (IERR.EQ.0) ALLOCATE(UU(NMAX), STAT = IERR)
         IF (IERR.EQ.0) ALLOCATE(V(NMAX), STAT = IERR)
         IF (IERR.EQ.0) ALLOCATE(VV(NMAX), STAT = IERR)
         IF (IERR.NE.0) REPEET = .FALSE.
      ENDIF  
C
C The main cycle point
C
      DO WHILE (REPEET)
C
C Read in data then decide what to do, NPTS is returned as the exact data set size
C
         CALL DATAIN (ITYPE, MTEXT, NBIG, NPTS, NVAR,
     +                FNAME(1), TEX, TITLE,
     +                ABORT, JUMP)
         NKEEP = NPTS
         IF (.NOT.ABORT .AND. .NOT.JUMP) THEN
C
C A data file has been accepted so define ECALC, adjust NREPS if necessary
C then call DETAIL for further action
C           
            IF (NREPS.GT.NMAX/NPTS) NREPS = NMAX/NPTS
            ECALC = .FALSE.
            CALL DETAIL (NDEC, NMAX, NPTS)
            
C
C Action depending on NDEC as set in subroutine DETAIL
C
            IF (NDEC.EQ.1) THEN
C
C NDEC = 1: Single observations with constant relative error
C
               CALL ERR001 (NPTS,
     +                      E, EE, Y, Z)
            ELSEIF (NDEC.EQ.2) THEN
C
C NDEC = 2: Single observations with constant variance
C
               CALL ERR002 (NPTS,
     +                      E, EE, Y, Z)
            ELSEIF (NDEC.EQ.3) THEN
C
C NDEC = 3: Single observations with mixed error
C
               CALL ERR003 (NPTS,
     +                      E, EE, Y, Z)
            ELSEIF (NDEC.EQ.4) THEN
C
C NDEC = 4: Replicates with constant relative error
C           NKEEP is returned as the original NPTS for the exact data set
C           NPTS is returned as NREPS*NKEEP
C
               CALL ERR004 (NKEEP, NMAX, NPTS, NREPS, NVAR,
     +                      E, EE, ESAV, U, UU, V, VV, X, XX, Y, YY, Z,
     +                      ECALC)
            ELSEIF (NDEC.EQ.5) THEN
C
C NDEC = 5: Replicates with constant variance, NPTS is increased by NREPS, i.e.
C           NKEEP is returned as the original NPTS for the exact data set
C           NPTS is returned as NREPS*NKEEP
C
               CALL ERR005 (NKEEP, NMAX, NPTS, NREPS, NVAR,
     +                      E, EE, ESAV, U, UU, V, VV, X, XX, Y, YY, Z,
     +                      ECALC)
            ELSEIF (NDEC.EQ.6) THEN
C
C NDEC = 6: Replicates with mixed error, NPTS is increased by NREPS, i.e.
C           NKEEP is returned as the original NPTS for the exact data set
C           NPTS is returned as NREPS*NKEEP
C
               CALL ERR006 (NKEEP, NMAX, NPTS, NREPS, NVAR,
     +                      E, EE, ESAV, U, UU, V, VV, X, XX, Y, YY, Z,
     +                      ECALC)
            ELSEIF (NDEC.EQ.7) THEN
C
C NDEC = 7: Selected error type, NPTS is increased by NREP, i.e.
C           NKEEP is returned as the original NPTS for the exact data set
C           NPTS is returned as NREPS*NKEEP
C
               CALL ERR007 (NKEEP, NMAX, NPTS, NREPS, NVAR,
     +                      E, EE, ESAV, U, UU, V, VV, X, XX, Y, YY, Z,
     +                      ECALC)
            ENDIF
            IF (NDEC.LE.8) THEN
C
C 1 =< NDEC =< 8: Outliers then TABLE/GRAPH/SAVE
C
               CALL ERROUT (NDEC, NKEEP, NPTS, NREPS, NUM,
     +                      E, Y, Z,
     +                      ECALC)
               CALL OUTDAT (ITYPE, MTEXT, NKEEP, NPTS, NVAR,
     +                      E, ESAV, U, V, X, XX, Y, YY, Z,
     +                      FNAME, TEX,
     +                      ECALC)
            ENDIF
         ENDIF
C
C Another go or stop the program
C
         IF (ITYPE.LE.0) THEN  
            IF (JUMP) THEN
               ABORT = .TRUE.
            ELSE   
              CALL STOPGO (FNAME(1), FNAME(2), PNAME,
     +                     ABORT)
            ENDIF
            IF (ABORT) THEN
               REPEET = .FALSE.
            ELSE
               REPEET = .TRUE.
            ENDIF
         ELSEIF (ITYPE.GT.2) THEN
            REPEET = .FALSE.   
         ENDIF   
      ENDDO
C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = 1
      ACTION = .FALSE.
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
C
C======================================================================
C
      END
C
C
     