C
C ADDERR1.FOR
C =============
C ADVISE
C DATAIN
C DETAIL
C
C
      SUBROUTINE ADVISE (DVER,
     +                   ABORT, FIRST)
C
C Advise user
C DVER and FIRST are (input/unchanged) ABORT is (output)
C
      IMPLICIT   NONE
C
C Arguments
C
      CHARACTER (LEN = *), INTENT (IN)     :: DVER
      LOGICAL,             INTENT (IN)     :: FIRST
      LOGICAL,             INTENT (OUT)    :: ABORT
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 3, NUMHDR = 13, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_ADDERR
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help           ',
     +'Run the program',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (FIRST) THEN
            WRITE (HEADER,100) DVER
            ISEND = 1
            CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
            ISEND = 1
         ENDIF
         IF (ISEND.EQ.1) THEN
            CALL HELP_ADDERR ('adderr')
            IF (FIRST) THEN
               REPEET = .TRUE.
            ELSE
               ABORT = .FALSE.
               REPEET = .FALSE.
            ENDIF
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `ADDERR'
     +/'        `      '
     +/'Action  `Add random error to simulate experimental data.'
     +/'        `Input: file with exact data from program MAKDAT'
     +/'        `Output: file with data after adding random errors'
     +/'        `      '
     +/'Version `',A
     +/'        `      '
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      '
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C---------------------------------------------------------------------
C
      SUBROUTINE DATAIN (ITYPE, MTEXT, NBIG, NPTS, NVAR,
     +                   FNAME, TEX, TITLE,
     +                   ABORT, JUMP)

      USE MODULE_ADDERR
C
C Read in and check data
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NBIG
      INTEGER,             INTENT (OUT)   :: NPTS   
      INTEGER,             INTENT (INOUT) :: ITYPE, MTEXT
      INTEGER,             INTENT (INOUT) :: NVAR
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, TEX(NBIG), TITLE
      LOGICAL,             INTENT (INOUT) :: ABORT
      LOGICAL,             INTENT (OUT)   :: JUMP
C
C Locals
C
      INTEGER    NN, NMAX1
      INTEGER    I, ICOUNT, IERR, IOS, NDEC, NIN, NLINES, NVEC
      PARAMETER (NIN = 3)
      INTEGER    ICOLOR, IX, IY, LSHADE
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1)
      INTEGER    NUMOPT, NSTART, NTEXT
      INTEGER    NUMBLD(20), NUMPOS(6)
      DOUBLE PRECISION ERRMIN, ONE
      PARAMETER (ERRMIN = 1.0D-200, ONE = 1.0D+00)
      CHARACTER (LEN = 12) I12, FORM12
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    AGAIN, FIRST, NEWDAT, REPEET
      LOGICAL    TAB_BOT, TAB_MID, TAB_TOP
      PARAMETER (TAB_BOT = .FALSE., TAB_MID = .FALSE.,
     +           TAB_TOP = .FALSE.)
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .FALSE.) 
      EXTERNAL   FORM12
      EXTERNAL   DAT5IN, PUTFAT, PUTADV, PUTIOS, LBOX01,
     +           LBOX02, GETJ01
      EXTERNAL   ADVISE
      INTRINSIC  ABS
      SAVE       FIRST, NN
      DATA       FIRST / .TRUE. /
      DATA       NN / 0 /
      DATA       NUMBLD / 20*0 /
      DATA       NUMPOS / 6*1 /
C
C Initialise JUMP
C      
      JUMP = .FALSE.

      IF (ITYPE.EQ.1) THEN
         NEWDAT = .FALSE.
      ELSEIF (ITYPE.EQ.2) THEN
         NEWDAT = .TRUE.   
      ELSEIF (FIRST) THEN
C
C First time round demand a data set
C        
         FIRST = .FALSE.
         NEWDAT = .TRUE.
         FNAME = BLANK
      ELSE
C
C Subsequently provide options for changes
C        
         WRITE (TEXT,100)
         NDEC = 1
         NUMOPT = 2
         CALL LBOX02 (ICOLOR, IX, IY, NDEC, NUMOPT, NUMPOS,
     +                TEXT)
         IF (NDEC.EQ.1) THEN
            NEWDAT = .FALSE.
         ELSE
            NEWDAT = .TRUE.
            FNAME = BLANK
         ENDIF
      ENDIF
      
      ITYPE = 0
      
      IF (NEWDAT) THEN
C
C A new file has been requested
C
         REPEET = .TRUE.
         DO WHILE (REPEET)
            I12 = FORM12(NMAX)
            WRITE (TEXT,200) I12
            NVAR = 1
            NUMOPT = 6
            NSTART = 14
            NTEXT = NSTART + NUMOPT - 1
            NUMBLD(1) = 1
            CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NVAR, NUMOPT,
     +                   NUMPOS, NSTART, NTEXT,
     +                   TEXT,
     +                   TAB_BOT, TAB_MID, TAB_TOP)
            NUMBLD(1) = 0
            IF (NVAR.LE.3) THEN
C
C Attempt to open a file
C              
               REPEET = .FALSE.
            ELSEIF (NVAR.EQ.4) THEN
C
C Request to increase NMAX
C            
               AGAIN = .TRUE.
               DO WHILE (AGAIN)
                  NMAX1 = NMAX
                  I12 = FORM12(NMAX1)
                  WRITE (LINE,300) I12
                  CALL GETJ01 (NMAX1,
     +                         LINE)
                  IF (NMAX1.GT.NMAX) THEN
                     IERR = 0
                     DEALLOCATE (NUM,
     +                           EE, XX, YY, E, ESAV, X, Y, Z,
     +                           U, UU, V, VV,
     +                           STAT = IERR)                  
                     IF (IERR.EQ.0) ALLOCATE(NUM(NMAX1), STAT = IERR)
                     IF (IERR.EQ.0) ALLOCATE(EE(NMAX1), STAT = IERR)
                     IF (IERR.EQ.0) ALLOCATE(XX(NMAX1), STAT = IERR)
                     IF (IERR.EQ.0) ALLOCATE(YY(NMAX1), STAT = IERR)
                     IF (IERR.EQ.0) ALLOCATE(E(NMAX1), STAT = IERR)
                     IF (IERR.EQ.0) ALLOCATE(ESAV(NMAX1), STAT = IERR)
                     IF (IERR.EQ.0) ALLOCATE(X(NMAX1), STAT = IERR)
                     IF (IERR.EQ.0) ALLOCATE(Y(NMAX1), STAT = IERR)
                     IF (IERR.EQ.0) ALLOCATE(Z(NMAX1), STAT = IERR)
                     IF (IERR.EQ.0) ALLOCATE(U(NMAX1), STAT = IERR)
                     IF (IERR.EQ.0) ALLOCATE(UU(NMAX1), STAT = IERR)
                     IF (IERR.EQ.0) ALLOCATE(V(NMAX1), STAT = IERR)
                     IF (IERR.EQ.0) ALLOCATE(VV(NMAX1), STAT = IERR)                  
                     IF (IERR.EQ.0) THEN
                        NMAX = NMAX1
                        AGAIN =.FALSE.
                     ELSE
                        CALL PUTFAT ('Allocation error  ...  Try again')
                     ENDIF
                  ELSE
                     AGAIN = .FALSE.           
                  ENDIF   
               ENDDO
            ELSEIF (NVAR.EQ.NUMOPT - 1) THEN
C
C Help
C            
               CALL ADVISE (BLANK,
     +                      ABORT, FIRST)                  
            ELSEIF (NVAR.EQ.NUMOPT) THEN
C
C Quit ... Exit program ADDERR
C            
               ABORT = .TRUE.
               JUMP = .TRUE.
               RETURN      
            ENDIF      
         ENDDO
         
         NVEC = NVAR + 2
         IF (NVAR.EQ.1) THEN
C
C Function of 1 variable
C           
            CALL DAT5IN (NIN, NMAX, NPTS, NVEC,
     +                   X, Y, E, U, V,
     +                   FNAME, TITLE,
     +                   ABORT, SUPPLY)
         ELSEIF (NVAR.EQ.2) THEN
C
C Function of 2 variables
C         
            CALL DAT5IN (NIN, NMAX, NPTS, NVEC,
     +                   X, U, Y, E, V,
     +                   FNAME, TITLE,
     +                   ABORT, SUPPLY)
         ELSE
C
C Function 0f 3 variables 
C           
            CALL DAT5IN (NIN, NMAX, NPTS, NVEC,
     +                   X, U, V, Y, E,
     +                   FNAME, TITLE,
     +                   ABORT, SUPPLY)
         ENDIF
         IF (ABORT) THEN
            NN = 0
            NPTS = 0
            FNAME = BLANK
            FIRST = .TRUE.
            CLOSE (UNIT = NIN)
            RETURN
         ENDIF
C
C NIN is still connected so read the number of trailing lines
C
         ICOUNT = NPTS + 2
         READ (NIN,*,IOSTAT=IOS) MTEXT
C
C If there is no trailer add a default line
C
         IF (IOS.NE.0) THEN
            IOS = 0
            MTEXT = 1
            TEX(1) = 'Default line'
            ICOUNT = ICOUNT + 2
         ElSE
C
C Otherwise read the trailer
C
            IF (MTEXT.GT.NBIG - 2) MTEXT = NBIG - 2
            DO I = 1, MTEXT
               ICOUNT = ICOUNT + 1
               READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TEX(I)
               IF (IOS.NE.0) GOTO 20
            ENDDO
         ENDIF
C
C Disconnect the file then check and store the values as follows
C EE = E, XX = X, YY = Y, UU = U, VV = V, and also Z = Y
C
         CLOSE (UNIT = NIN)
         NN = NPTS
         NLINES = 0
         DO I = 1, NPTS
            IF (ABS(Y(I)).LT.ERRMIN) NLINES = NLINES + 1
            EE(I) = E(I)
            XX(I) = X(I)
            YY(I) = Y(I)
            Z(I) = Y(I)
            IF (NVAR.GT.1) UU(I) = U(I)
            IF (NVAR.GT.2) VV(I) = V(I)
         ENDDO
         IF (NLINES.GT.0) THEN
            I12 = FORM12(NLINES)
            WRITE (LINE,400) I12
            CALL PUTADV (LINE)
         ENDIF
C
C Initialise all ESAV as no. of replicates is not yet known
C
         DO I = 1, NMAX
            ESAV(I) = ONE
         ENDDO
      ELSE
C
C The previous exact data is to be re-used
C
         NPTS = NN
         DO I = 1, NPTS
            E(I) = EE(I)
            X(I) = XX(I)
            Y(I) = YY(I)
            Z(I) = Y(I)
            IF (NVAR.GT.1) U(I) = UU(I)
            IF (NVAR.GT.2) V(I) = VV(I)
         ENDDO
      ENDIF
      RETURN
C
C LABEL 20: Here only after a crash
C =========
C
   20 CONTINUE
      CLOSE (UNIT = NIN)
      ABORT = .TRUE.
      FIRST = .TRUE.
      FNAME = BLANK
      I12 = FORM12(ICOUNT)
      WRITE (LINE,500) I12
      CALL PUTFAT (LINE)
      IF (IOS.NE.0) CALL PUTIOS (IOS, 'DATAIN')
      WRITE (LINE,600)
      CALL PUTADV (LINE)
C
C Format statements
C      
  100 FORMAT (
     + 'Add new random errors (to current exact data)'
     +/'Input a new data file (new set of exact data)')
  200 FORMAT (
     + 'Options available for program ADDERR'
     +/
     +/'The data in the input file should have no'
     +/'replicates, but should have single values for'
     +/'the exact dependent variables, and weighting'
     +/'factors (e.g. s = std.err(y), or s = 1, etc.).'
     +/
     +/'You can add pseudo-random errors to functions'
     +/'of one, two, or three independent variables.'
     +/
     +/'With functions of more than one variable, only'
     +/'functions of the first variable will be plotted.'
     +/
     +/'Number of variables = 1: y = f(x1)'
     +/'Number of variables = 2: y = g(x1,x2)'
     +/'Number of variables = 3: y = h(x1,x2,x3)'
     +/'Increase maximum sample size: current =',1X,A
     +/'Help'
     +/'Quit  ...   Exit program ADDERR')
  300 FORMAT ('New sample size required: current =',1X,A)
  400 FORMAT (
     +'Number of y-values too small to calculate relative error =',1X,A)
  500 FORMAT ('Error reading from data file at line',1X,A)
  600 FORMAT ('Prepare data files using program MAKDAT')
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE DETAIL (NDEC, NMAX, NPTS)
C
C Details
C
C NDEC: (output)
C NMAX: (input/unchanged) leading dimension
C NPTS: (input/unchanged) no. data points
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER, INTENT (IN)  :: NMAX, NPTS
      INTEGER, INTENT (OUT) :: NDEC
C
C Locals
C
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 9, IX = 12, IY = 8, LSHADE = 1, NUMOPT = 10,
     +           NSTART = 3, NTEXT = 22)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      CHARACTER  TEXT(NTEXT)*100, LINE*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    ABORT, FIRST
      PARAMETER (FIRST = .FALSE.)
      LOGICAL    REPEET
      EXTERNAL   ADVISE, PUTFAT
      EXTERNAL   LBOX01
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
      REPEET = .TRUE.
      DO WHILE (REPEET)
         WRITE (TEXT,100) NMAX
         NUMBLD(1) = 1
         NUMBLD(14) = 1
         NDEC = 4
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         IF (NDEC.EQ.NUMOPT - 1) THEN
            CALL ADVISE (BLANK,
     +                   ABORT, FIRST)
            REPEET = .TRUE.
         ELSEIF (NDEC.GE.4 .AND. NDEC.LE.7) THEN
            IF (NMAX/NPTS.LT.2) THEN   
               WRITE (LINE,200)
               CALL PUTFAT (LINE)
            ELSE
               REPEET = .FALSE.
            ENDIF    
         ELSE
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Options for adding pseudo random error'
     +/
     +/'1. Single measurements, constant relative error'
     +/'2. Single measurements, fixed constant variance'
     +/'3. Single measurements, mixed power law error'
     +/'4. Generate replicates, constant relative error'
     +/'5. Generate replicates, fixed constant variance'
     +/'6. Generate replicates, mixed power law error'
     +/'7. Choose from selection of error distributions'
     +/'8. Just add outliers to the data set supplied'
     +/'Help'
     +/'Cancel'
     +/
     +/'Advice: maximum size for simulation =',I6
     +/'Choose 4 to simulate error that increases as y increases.'
     +/'For instance, try 3 to 6 replicates and 5-10% relative error.'
     +/'Option 4 is quite close to reality but errors tend to be'
     +/'underestimated at low |y| values.'
     +/'Select option 4 if you are not sure what to do.'
     +/'Choose 5 to simulate errors remaining constant as y varies.'
     +/'For instance, try 3-6 replicates, sigma 5-10% average |y|.'
     +/'Choose 1, 2, 3, 6, 7, or 8 only if you know what to do!')
  200 FORMAT (
     +'Not possible: maximum simulation size < twice data set size')     
      END
C
C
