
C
C ADDERR2.FOR
C ===========
C ERR001
C ERR002
C ERR003
C ERR004
C ERR005
C ERR006
C ERR007
C
      SUBROUTINE ERR001 (NPTS,
     +                   E, EE, Y, Z)
C
C Constant relative error (single measurements)
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: NPTS
      DOUBLE PRECISION, INTENT (IN)  :: EE(NPTS), Y(NPTS)
      DOUBLE PRECISION, INTENT (OUT) :: E(NPTS), Z(NPTS)
C
C Locals
C      
      INTEGER    I, IFAIL, NDEC, NDOF, NREP
      INTEGER    N0, N1, N2, N3, N4, N5, N100
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N100 = 100)
      INTEGER    ICOLOR, IX, IY, NUMOPT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, NUMOPT = 5)
      INTEGER    NUMPOS(NUMOPT)
      DOUBLE PRECISION ONE, PMAX, PMIN, P100
      PARAMETER (ONE = 1.0D+00, PMAX = 1.0D+03, PMIN = 1.0D-3,
     +           P100 = 100.0D+00)
      DOUBLE PRECISION CHISQ, ERR, FRACN, PCENT, RNDOF, STORE
      DOUBLE PRECISION G05DHF$
      CHARACTER  TEXT(30)*100
      EXTERNAL   GETJM1, GETDM1, LBOX02
      EXTERNAL   ERRORS
      EXTERNAL   G05DHF$
      INTRINSIC  ABS, DBLE, SQRT
      SAVE       NREP, PCENT
      DATA       NREP, PCENT / N5, 7.50D+00 /
      DATA       NUMPOS / NUMOPT*1 /
      WRITE (TEXT,100)
      NDEC = N5
      CALL LBOX02 (ICOLOR, IX, IY, NDEC, NUMOPT, NUMPOS,
     +             TEXT)
      IF (NDEC.EQ.N3) THEN
         CALL GETJM1 (N2, NREP, N100,
     +               'No. of supposed replicates at each fixed x')
         NDOF = NREP - N1
         RNDOF = DBLE(NDOF)
      ENDIF
      CALL GETDM1 (PMIN, PCENT, PMAX,
     +            'Percentage relative error required')
      FRACN = PCENT/P100
      IFAIL = N0
      DO I = N1, NPTS
         CALL ERRORS (ERR)
         STORE = ABS(FRACN*Y(I))
         Z(I) = Y(I) + ERR*STORE
         IF (NDEC.EQ.N1) THEN
            E(I) = STORE
         ELSEIF (NDEC.EQ.N2) THEN
            E(I) = ABS(FRACN*Z(I))
         ELSEIF (NDEC.EQ.N3) THEN
            CHISQ = G05DHF$(NDOF, IFAIL)
            E(I) = STORE*SQRT(CHISQ/RNDOF)
         ELSEIF (NDEC.EQ.N4) THEN
            E(I) = EE(I)
         ELSE
            E(I) = ONE
         ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT (
     + 'Set s = percentage of the original |y|  values'
     +/'Set s = percentage of the perturbed |y| values'
     +/'Set s = sqrt(chi-square), to simulate sampling'
     +/'Set s = value from input file'
     +/'Set s = 1')
      END
C
C---------------------------------------------------------------------------
C
      SUBROUTINE ERR002 (NPTS,
     +                   E, EE, Y, Z)
C
C Constant variance (single measurements)
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: NPTS
      DOUBLE PRECISION, INTENT (IN)  :: EE(NPTS), Y(NPTS)
      DOUBLE PRECISION, INTENT (OUT) :: E(NPTS), Z(NPTS)
C
C Locals
C      
      INTEGER    I, IFAIL, NDEC, NDOF, NREP
      INTEGER    N0, N1, N2, N3, N4, N5, N100
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N100 = 100)
      INTEGER    ICOLOR, IX, IY, NUMOPT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, NUMOPT = 4)
      INTEGER    NUMPOS(NUMOPT)
      DOUBLE PRECISION ONE, SMAX, SMIN
      PARAMETER (ONE = 1.0D+00, SMAX = 1.0D+200, SMIN = 1.0D-200)
      DOUBLE PRECISION CHISQ, ERR, RNDOF, SIGMA
      DOUBLE PRECISION G05DHF$
      CHARACTER  TEXT(30)*100
      EXTERNAL   GETJM1, GETDM1, LBOX02
      EXTERNAL   ERRORS
      EXTERNAL   G05DHF$
      INTRINSIC  DBLE, SQRT
      SAVE       NREP, SIGMA
      DATA       NREP, SIGMA / N5, ONE /
      DATA       NUMPOS / NUMOPT*1 /
      WRITE (TEXT,100)
      NDEC = N4
      CALL LBOX02 (ICOLOR, IX, IY, NDEC, NUMOPT, NUMPOS,
     +             TEXT)
      CALL GETDM1 (SMIN, SIGMA, SMAX, 'Sigma required')
      IF (NDEC.EQ.2) THEN
         CALL GETJM1 (N2, NREP, N100,
     +               'No. of supposed replicates at each fixed x')
         NDOF = NREP - N1
         RNDOF = DBLE(NDOF)
      ENDIF
      IFAIL = N0
      DO I = N1, NPTS
         CALL ERRORS (ERR)
         Z(I) = Y(I) + ERR*SIGMA
         IF (NDEC.EQ.N1) THEN
            E(I) = SIGMA
         ELSEIF (NDEC.EQ.N2) THEN
            CHISQ = G05DHF$(NDOF, IFAIL)
            E(I) = SIGMA*SQRT(CHISQ/RNDOF)
         ELSEIF (NDEC.EQ.N3) THEN
            E(I) = EE(I)
         ELSE
            E(I) = ONE
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Set s = a sigma value (> 0) that you input now'
     +/'Set s = sqrt(chi-square), to simulate sampling'
     +/'Set s = value from input file'
     +/'Set s = 1')
      END
C
C-------------------------------------------------------------------
C
      SUBROUTINE ERR003 (NPTS, 
     +                   E, EE, Y, Z)
C
C Mixed power law error (single measurements)
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: NPTS
      DOUBLE PRECISION, INTENT (IN)  :: EE(NPTS), Y(NPTS)
      DOUBLE PRECISION, INTENT (OUT) :: E(NPTS), Z(NPTS)
C
C Locals
C      
      INTEGER    I, IFAIL, NDEC, NDOF, NREP
      INTEGER    N0, N1, N2, N3, N4, N5, N100
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N100 = 100)
      INTEGER    ICOLOR, IX, IY, NUMOPT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, NUMOPT = 5)
      INTEGER    NUMPOS(NUMOPT)
      DOUBLE PRECISION ONE, SMAX, SMIN, TWO
      PARAMETER (ONE = 1.0D+00, SMAX = 1.0D+10, SMIN = 0.0D+00,
     +           TWO = 2.0D+00)
      DOUBLE PRECISION COEFF, POWER, SIGMA
      DOUBLE PRECISION CHISQ, ERR, RNDOF, SIGSQD, STORE, SVAR
      DOUBLE PRECISION G05DHF$
      CHARACTER  TEXT(30)*100
      EXTERNAL   GETJM1, GETDM1, LBOX02
      EXTERNAL   ERRORS
      EXTERNAL   G05DHF$
      INTRINSIC  ABS, DBLE, SQRT
      SAVE       NREP, COEFF, POWER, SIGMA
      DATA       NREP, COEFF, POWER, SIGMA / N5, 0.075D+00, TWO, ONE /
      DATA       NUMPOS / NUMOPT*1 /
      WRITE (TEXT,100)
      NDEC = N5
      CALL LBOX02 (ICOLOR, IX, IY, NDEC, NUMOPT, NUMPOS, 
     +             TEXT)
      IF (NDEC.EQ.N3) THEN
         CALL GETJM1 (N2, NREP, N100,
     +               'No. of supposed replicates at each fixed x')
         NDOF = NREP - N1
         RNDOF = DBLE(NDOF)
      ENDIF
      CALL GETDM1 (SMIN, SIGMA, SMAX, 'Sigma (> 0)')
      CALL GETDM1 (SMIN, COEFF, SMAX, 'Coefficient (> 0)')
      CALL GETDM1 (SMIN, POWER, SMAX, 'Power (> 0)')
      SIGSQD = SIGMA*SIGMA
      IFAIL = N0
      DO I = N1, NPTS
         STORE = SQRT(SIGSQD + (COEFF*ABS(Y(I)))**POWER)
         CALL ERRORS (ERR)
         Z(I)  = Y(I) + ERR*STORE
         IF (NDEC.EQ.N1) THEN
            E(I) = STORE
         ELSEIF (NDEC.EQ.N2) THEN
            SVAR  = SIGSQD + (COEFF*ABS(Z(I)))**POWER
            E(I) = SQRT(SVAR)
         ELSEIF (NDEC.EQ.N3) THEN
            CHISQ = G05DHF$(NDOF, IFAIL)
            SVAR = CHISQ*STORE*STORE/RNDOF
            E(I) = SQRT(SVAR)
         ELSEIF (NDEC.EQ.N4) THEN
            E(I) = EE(I)
         ELSE
            E(I) = ONE
         ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT (
     + 'Set s = mixed error  using  original  y values'
     +/'Set s = mixed error  using  perturbed y values'
     +/'Set s = sqrt(chi-square), to simulate sampling'
     +/'Set s = value from input file'
     +/'Set s = 1')
      END
C
C---------------------------------------------------------------------
C
      SUBROUTINE ERR004 (NKEEP, NMAX, NPTS, NREPS, NVAR,
     +                   E, EE, ESAV, U, UU, V, VV, X, XX, Y, YY, Z,
     +                   ECALC)
C
C Generate replicates then add error (constant relative error)
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NMAX, NVAR
      INTEGER,          INTENT (INOUT) :: NKEEP
      INTEGER,          INTENT (INOUT) :: NPTS, NREPS
      DOUBLE PRECISION, INTENT (IN)    :: EE(NMAX), UU(NMAX)
      DOUBLE PRECISION, INTENT (OUT)   :: E(NMAX), U(NMAX)
      DOUBLE PRECISION, INTENT (INOUT) :: ESAV(NMAX)
      DOUBLE PRECISION, INTENT (IN)    :: VV(NMAX), XX(NMAX)
      DOUBLE PRECISION, INTENT (OUT)   :: V(NMAX), X(NMAX)
      DOUBLE PRECISION, INTENT (IN)    :: YY(NMAX)
      DOUBLE PRECISION, INTENT (OUT)   :: Y(NMAX), Z(NMAX)
      LOGICAL,          INTENT (OUT)   :: ECALC
C
C locals
C      
      INTEGER    I, J, K, NDEC
      INTEGER    N0, N1, N2, N3, N5
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N5 = 5)
      INTEGER    ICOLOR, IX, IY, NUMOPT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, NUMOPT = 5)
      INTEGER    NUMPOS(NUMOPT)
      DOUBLE PRECISION ONE, PMAX, PMIN, P100
      PARAMETER (ONE = 1.0D+00, PMAX = 1.0D+03, PMIN = 1.0D-03,
     +           P100 = 100.0D+00)
      DOUBLE PRECISION ERR, FRACN, PCENT, STORE
      CHARACTER  TEXT(30)*100
      EXTERNAL   GETJM1, GETDM1, LBOX02
      EXTERNAL   ESTATS, ERRORS
      INTRINSIC  ABS
      SAVE       PCENT
      DATA       PCENT / 7.5D+00 /
      DATA NUMPOS / NUMOPT*1 /
      ECALC = .FALSE.
      WRITE (TEXT,100)
      NDEC = N3
      CALL LBOX02 (ICOLOR, IX, IY, NDEC, NUMOPT, NUMPOS,
     +             TEXT)
      CALL GETJM1 (N2, NREPS, NMAX/NPTS,
     +            'No. of replicates required at each x value')
      NKEEP = NPTS
      NPTS = NREPS*NKEEP
      K = N0
      DO I = N1, NKEEP
         DO J = N1, NREPS
            K = K + N1
            X(K) = XX(I)
            Y(K) = YY(I)
            E(K) = EE(I)
            IF (NVAR.GT.1) U(K) = UU(I)
            IF (NVAR.GT.2) V(K) = VV(I)
         ENDDO
      ENDDO
      CALL GETDM1 (PMIN, PCENT, PMAX,
     +            'Percentage relative error required')
      FRACN = PCENT/P100
      DO I = N1, NPTS
         CALL ERRORS (ERR)
         STORE = ABS(FRACN*Y(I))
         Z(I) = Y(I) + ERR*STORE
         IF (NDEC.EQ.N1) THEN
            E(I) = STORE
         ELSEIF (NDEC.EQ.N2) THEN
            E(I) = ABS(FRACN*Z(I))
         ELSEIF (NDEC.EQ.N3) THEN
            ESAV(I) = STORE
         ELSEIF (NDEC.EQ.N5) THEN
            E(I) = ONE
         ENDIF
      ENDDO
      IF (NDEC.EQ.N3) THEN
         ECALC = .TRUE.
         CALL ESTATS (NKEEP, NPTS, NREPS,
     +                E, Z)
      ENDIF
C
C Format statment
C      
  100 FORMAT (
     + 'Set s = percentage of the original |y|  values'
     +/'Set s = percentage of the perturbed |y| values'
     +/'Set s = sample std. dev. of perturbed y values'
     +/'Set s = value from input file'
     +/'Set s = 1')
      END
C
c--------------------------------------------------------------------
C
      SUBROUTINE ERR005 (NKEEP, NMAX, NPTS, NREPS, NVAR,
     +                   E, EE, ESAV, U, UU, V, VV, X, XX, Y, YY, Z,
     +                   ECALC)
C
C Generate replicates then add error (constant variance)
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NMAX, NVAR
      INTEGER,          INTENT (INOUT) :: NPTS, NREPS
      INTEGER,          INTENT (OUT)   :: NKEEP
      DOUBLE PRECISION, INTENT (IN)    :: EE(NMAX), UU(NMAX)
      DOUBLE PRECISION, INTENT (OUT)   :: E(NMAX), U(NMAX)
      DOUBLE PRECISION, INTENT (INOUT) :: ESAV(NMAX)
      DOUBLE PRECISION, INTENT (IN)    :: VV(NMAX), XX(NMAX)
      DOUBLE PRECISION, INTENT (OUT)   :: V(NMAX), X(NMAX)
      DOUBLE PRECISION, INTENT (IN)    :: YY(NMAX)      
      DOUBLE PRECISION, INTENT (OUT)   :: Y(NMAX), Z(NMAX)      
      LOGICAL,          INTENT (OUT)   :: ECALC
C
C Locals
C      
      INTEGER    I, J, K, NDEC
      INTEGER    N0, N1, N2, N4
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N4 = 4)
      INTEGER    ICOLOR, IX, IY, NUMOPT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, NUMOPT = 4)
      INTEGER    NUMPOS(NUMOPT)
      DOUBLE PRECISION ONE, SMAX, SMIN
      PARAMETER (ONE = 1.0D+00, SMAX = 1.0D+200, SMIN = 1.0D-200)
      DOUBLE PRECISION ERR, SIGMA
      CHARACTER  TEXT(30)*100
      EXTERNAL   GETJM1, GETDM1, LBOX02
      EXTERNAL   ERRORS, ESTATS
      SAVE       SIGMA
      DATA       SIGMA / ONE /
      DATA       NUMPOS / NUMOPT*1 /
C
C Initialise 
C      
      NKEEP = NPTS
      ECALC = .FALSE.
      WRITE (TEXT,100)
      NDEC = N2
      CALL LBOX02 (ICOLOR, IX, IY, NDEC, NUMOPT, NUMPOS,
     +             TEXT)
      CALL GETJM1 (N2, NREPS, NMAX/NPTS,
     +            'No. of replicates required at each x value')
C
C Redefine NPTS, E, X, Y, U, V 
C     
      NPTS = NREPS*NKEEP
      K = N0
      DO I = N1, NKEEP
         DO J = N1, NREPS
            K = K + N1
            X(K) = XX(I)
            Y(K) = YY(I)
            E(K) = EE(I)
            IF (NVAR.GT.1) U(K) = UU(I)
            IF (NVAR.GT.2) V(K) = VV(I)
         ENDDO
      ENDDO
      CALL GETDM1 (SMIN, SIGMA, SMAX, 'Sigma required (> 0)')
      DO I = N1, NPTS
         CALL ERRORS (ERR)
         Z(I) = Y(I) + ERR*SIGMA
         IF (NDEC.EQ.N1) THEN
            E(I) = SIGMA
         ELSEIF (NDEC.EQ.N2) THEN
            ESAV(I) = SIGMA
         ELSEIF (NDEC.EQ.N4) THEN
            E(I) = ONE
         ENDIF
      ENDDO
      IF (NDEC.EQ.N2) THEN
         ECALC = .TRUE.
         CALL ESTATS (NKEEP, NPTS, NREPS, E, Z)
      ENDIF
C
C Format statment
C      
  100 FORMAT (
     + 'Set s = standard deviation  you  have supplied'
     +/'Set s = sample std. dev. of perturbed y values'
     +/'Set s = value from input file'
     +/'Set s = 1')
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE ERR006 (NKEEP, NMAX, NPTS, NREPS, NVAR,
     +                   E, EE, ESAV,  U, UU, V, VV, X, XX, Y, YY, Z,
     +                   ECALC)
C
C Generate replicates then add error (mixed power law error)
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NMAX, NVAR
      INTEGER,          INTENT (INOUT) :: NPTS, NREPS
      INTEGER,          INTENT (INOUT) :: NKEEP
      DOUBLE PRECISION, INTENT (IN)    :: EE(NMAX), UU(NMAX)
      DOUBLE PRECISION, INTENT (OUT)   :: E(NMAX), U(NMAX)
      DOUBLE PRECISION, INTENT (INOUT) :: ESAV(NMAX)
      DOUBLE PRECISION, INTENT (IN)    :: VV(NMAX), XX(NMAX)
      DOUBLE PRECISION, INTENT (OUT)   :: V(NMAX), X(NMAX)
      DOUBLE PRECISION, INTENT (IN)    :: YY(NMAX)
      DOUBLE PRECISION, INTENT (OUT)   :: Y(NMAX), Z(NMAX)
      LOGICAL,          INTENT (OUT)   :: ECALC
C
C Locals
C      
      INTEGER    I, J, K, NDEC
      INTEGER    N0, N1, N2, N3, N5
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N5 = 5)
      INTEGER    ICOLOR, IX, IY, NUMOPT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, NUMOPT = 5)
      INTEGER    NUMPOS(NUMOPT)
      DOUBLE PRECISION COEFF, POWER, SIGMA
      DOUBLE PRECISION ERR, SIGSQD, STORE, SVAR
      DOUBLE PRECISION ZERO, ONE, TWO, TEN, XBIG
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           TEN = 10.0D+00, XBIG = 1.0D+20)
      CHARACTER  TEXT(30)*100
      EXTERNAL   GETJM1, GETDM1, LBOX02
      EXTERNAL   ESTATS, ERRORS
      INTRINSIC  ABS, SQRT
      SAVE       COEFF, POWER, SIGMA
      DATA       COEFF, POWER, SIGMA / 0.075D+00, TWO, ONE /
      DATA       NUMPOS / NUMOPT*1 /
C
C Initialise
C      
      NKEEP = NPTS
      ECALC = .FALSE.
      WRITE (TEXT,100)
      NDEC = N3
      CALL LBOX02 (ICOLOR, IX, IY, NDEC, NUMOPT, NUMPOS,
     +             TEXT)
      CALL GETJM1 (N2, NREPS, NMAX/NPTS,
     +            'No. of replicates required at each x value')
C
C Redefine, NPTS, E, X, Y, U, V
C     
      NPTS = NREPS*NKEEP
      K = N0
      DO I = N1, NKEEP
         DO J = N1, NREPS
            K = K + N1
            X(K) = XX(I)
            Y(K) = YY(I)
            E(K) = EE(I)
            IF (NVAR.GT.1) U(K) = UU(I)
            IF (NVAR.GT.2) V(K) = VV(I)
         ENDDO
      ENDDO
      CALL GETDM1 (ZERO, SIGMA, XBIG, 'Sigma (> 0)')
      CALL GETDM1 (ZERO, COEFF, XBIG, 'Coefficient (> 0)')
      CALL GETDM1 (ZERO, POWER, TEN, 'Power (> 0)')
      SIGSQD = SIGMA*SIGMA
      DO I = N1, NPTS
         STORE = SQRT(SIGSQD + (COEFF*ABS(Y(I)))**POWER)
         CALL ERRORS (ERR)
         Z(I)  = Y(I) + ERR*STORE
         IF (NDEC.EQ.N1) THEN
            E(I) = STORE
         ELSEIF (NDEC.EQ.N2) THEN
            SVAR = SIGSQD + (COEFF*ABS(Z(I)))**POWER
            E(I) = SQRT(SVAR)
         ELSEIF (NDEC.EQ.N3) THEN
            ESAV(I) = STORE
         ELSEIF (NDEC.EQ.N5) THEN
            E(I) = ONE
         ENDIF
      ENDDO
      IF (NDEC.EQ.N3) THEN
         ECALC = .TRUE.
         CALL ESTATS (NKEEP, NPTS, NREPS, E, Z)
      ENDIF
C
C Format statement
C      
  100 FORMAT (
     + 'Set s = mixed error  using  original  y values'
     +/'Set s = mixed error  using  perturbed y values'
     +/'Set s = sample std. dev. of perturbed y values'
     +/'Set s = value from input file'
     +/'Set s = 1')
      END
C
C------------------------------------------------------------------
C
      SUBROUTINE ERR007 (NKEEP, NMAX, NPTS, NREPS, NVAR,
     +                   E, EE, ESAV, U, UU, V, VV, X, XX, Y, YY, Z,
     +                   ECALC)
C
C Miscellaneous distributions
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NMAX, NVAR
      INTEGER,          INTENT (INOUT) :: NPTS, NREPS
      INTEGER,          INTENT (INOUT) :: NKEEP
      DOUBLE PRECISION, INTENT (IN)    :: EE(NMAX), UU(NMAX)
      DOUBLE PRECISION, INTENT (OUT)   :: E(NMAX), U(NMAX)
      DOUBLE PRECISION, INTENT (INOUT) :: ESAV(NMAX)
      DOUBLE PRECISION, INTENT (IN)    :: VV(NMAX), XX(NMAX)
      DOUBLE PRECISION, INTENT (OUT)   :: V(NMAX), X(NMAX)
      DOUBLE PRECISION, INTENT (IN)    :: YY(NMAX)      
      DOUBLE PRECISION, INTENT (OUT)   :: Y(NMAX), Z(NMAX)      
      LOGICAL,          INTENT (OUT)   :: ECALC
C
C Locals
C      
      INTEGER    I, ISEND, J, K, NDEC
      INTEGER    N0, N1, N2, N4
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N4 = 4)
      INTEGER    ICOLOR, IX, IY, NUMOPT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, NUMOPT = 4)
      INTEGER    NUMPOS(NUMOPT)
      DOUBLE PRECISION ERR, SIGMA
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      CHARACTER  TEXT(30)*100
      EXTERNAL   GETJM1, LBOX02
      EXTERNAL   ERRFCN, ESTATS
      DATA       NUMPOS / NUMOPT*1 /
C
C Initialise
C      
      NKEEP = NPTS
      ECALC = .FALSE.
      WRITE (TEXT,100)
      NDEC = N2
      CALL LBOX02 (ICOLOR, IX, IY, NDEC, NUMOPT, NUMPOS,
     +             TEXT)
      ISEND = N1
      CALL ERRFCN (ISEND, ERR, SIGMA)
      CALL GETJM1 (N2, NREPS, NMAX/NPTS,
     +            'No. of replicates required at each x value')
C
C Redefine NPTS, E, X, Y, U, V
C     
      NPTS = NREPS*NKEEP
      K = N0
      DO I = N1, NKEEP
         DO J = N1, NREPS
            K = K + N1
            X(K) = XX(I)
            Y(K) = YY(I)
            E(K) = EE(I)
            IF (NVAR.GT.1) U(K) = UU(I)
            IF (NVAR.GT.2) V(K) = VV(I)
         ENDDO
      ENDDO
      ISEND = N2
      DO I = N1, NPTS
         CALL ERRFCN (ISEND,
     +                ERR, SIGMA)
         Z(I) = Y(I) + ERR
         IF (NDEC.EQ.N1) THEN
            E(I) = SIGMA
         ELSEIF (NDEC.EQ.N2) THEN
            ESAV(I) = SIGMA
         ELSEIF (NDEC.EQ.N4) THEN
            E(I) = ONE
         ENDIF
      ENDDO
      IF (NDEC.EQ.N2) THEN
         ECALC = .TRUE.
         CALL ESTATS (NKEEP, NPTS, NREPS, E, Z)
      ENDIF
C
C Format statement
C      
  100 FORMAT (
     + 'Set s = the exact value for chosen distribution'
     +/'Set s = sample std. dev. of perturbed  y values'
     +/'Set s = value from input file'
     +/'Set s = 1')
      END
C
C
