
C
C ADDERR3.FOR
C ===========
C ERRFCN
C ERRORS
C ERROUT
C ESTATS
C OUTDAT
C
C
      SUBROUTINE ERRFCN (ISEND,
     +                   ERR, SIGMA)
C
C ISEND = 1 : Define distributions, read A, B and calculate SIGSAV
C ISEND = 2 : Set SIGMA = SIGSAV, return appropriate random number ERR
C NAG       : G05CAF, G05DBF, G05DDF, G05DFF
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: ISEND
      DOUBLE PRECISION, INTENT (OUT) :: ERR, SIGMA
C
C Locals
C      
      INTEGER    NPDF
      INTEGER    N1, N2, N3, N4
      PARAMETER (N1 = 1, N2 = 2, N3 = 3, N4 = 4)
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NUMTXT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 1, NUMOPT = 4)
      INTEGER    NUMBLD(NUMOPT)
      DOUBLE PRECISION EMAX, EMIN
      PARAMETER (EMAX = 1.0D200, EMIN = 1.0D-200)
      DOUBLE PRECISION EPSI, ZERO, HALF, ONE, ONE_M, TWO, F12
      PARAMETER (EPSI = 1.0D-06, ZERO = 0.0D+00, HALF = 0.5D+00, 
     +           ONE = 1.0D+00, ONE_M = -ONE, TWO = 2.0D+00,
     +           F12 = 12.0D+00)
      DOUBLE PRECISION A1, A2, A3, A4, B1, B2, B3, B4, C, SIGSAV, TEMP
      DOUBLE PRECISION G05CAF$, G05DBF$, G05DDF$, G05DFF$
      CHARACTER  TEXT(30)*100
      LOGICAL    BORDER, TITLES
      PARAMETER (BORDER = .FALSE., TITLES = .TRUE.)
      EXTERNAL   G05DFF$, G05DBF$, G05CAF$, G05DDF$
      EXTERNAL   GETD01, GETDM1, PUTCAU, GETDG2, PATCH1, LVIEW2
      INTRINSIC  SQRT, ABS
      SAVE       NPDF, A1, A2, A3, A4, B1, B3, B4, C, SIGSAV
      DATA       NPDF / 3 /
      DATA       A1, A2, A3, A4 / ZERO, ONE, ZERO, ONE_M /  
      DATA       B1, B3, B4 / ONE, ONE, ONE /
      DATA       NUMBLD / NUMOPT*0 /
      IF (ISEND.EQ.N1) THEN
C
C ISEND = 1: Choose a distribution
C        
         WRITE (TEXT,100)
         CALL LVIEW2 (IX, IY, NPDF, NUMOPT, 
     +                TEXT, TITLES)
         IF (NPDF.EQ.N1) THEN
C
C NPDF = 1: Cauchy, median A semi-interquartile range B
C           Uses A1 and B1
C           
            WRITE (TEXT,200)
            NUMTXT = N2
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMTXT,
     +                   TEXT,
     +                   BORDER)
            CALL GETD01 (A1,
     +'Value required for Cauchy distribution median A (usually 0)')
            IF (ABS(A1 - ZERO).GT.EPSI) CALL PUTCAU (
     +'Centre of Cauchy distribution (A) is not zero')
            IF (B1.LT.EMIN) B1 = ONE
            CALL GETDM1 (EMIN, B1, EMAX, 
     +'Value required for Cauchy semi-interquartile range B (B > 0)')
            SIGSAV = ONE
         ELSEIF (NPDF.EQ.2) THEN
C
C NPDF = 2: (negative) exponential with mean A
C           uses A2 but not B2 
C         
            WRITE (TEXT,300)
            NUMTXT = N4
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMTXT,
     +                   TEXT,
     +                   BORDER)
            IF (A2.LT.EMIN) A2 = ONE
            CALL GETDM1 (EMIN, A2, EMAX,
     +'Value required for exponential distribution parameter A (A > 0)')
            SIGSAV = A2*SQRT(TWO)
         ELSEIF (NPDF.EQ.N3) THEN
C
C NPDF = 3: Normal with mean A, standard deviation B
C           Uses A3 and B3
C         
            WRITE (TEXT,400)
            NUMTXT = N2
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMTXT,
     +                   TEXT, 
     +                   BORDER)
            CALL GETD01 (A3,
     +'Value required for normal distribution mean A (usually 0)')
            IF (ABS(A3 - ZERO).GT.EPSI) CALL PUTCAU (
     +'Centre of distribution (A) is not zero')
            IF (B3.LE.EMIN) B3 = ONE
            CALL GETDM1 (EMIN, B3, EMAX,
     +'Value for normal distribution standard deviation B (B > 0)')
            SIGSAV = B3
         ELSE
C
C NPDF = 4: Uniform A, B
C           Uses A4, B4, and C 
C           
            WRITE (TEXT,500)
            NUMTXT = N2
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMTXT,
     +                   TEXT,
     +                   BORDER)
            IF (A4.GT.B4) B4 = A4 + ONE
            CALL GETDG2 (A4, B4,
     +'Values required for limits of uniform distribution A, B (B > A)')
            C = (A4 + B4)/TWO
            IF (ABS(C - ZERO).GT.EPSI) CALL PUTCAU (
     +'Centre of uniform distribution (A + B)/2 is not zero')
            C = B4 - A4
            SIGSAV = SQRT(C*C/F12)
         ENDIF
      ELSE
C
C Return a random variable
C        
         SIGMA = SIGSAV
         IF (NPDF.EQ.N1) THEN
            ERR = G05DFF$(A1, B1)
         ELSEIF (NPDF.EQ.N2) THEN
            ERR = G05DBF$(A2)
            B2 = G05CAF$(TEMP)
            IF (B2.LE.HALF) ERR = - ERR
         ELSEIF (NPDF.EQ.N3) THEN
            ERR = G05DDF$(A3, B3)
         ELSE
            ERR = G05CAF$(TEMP)
            ERR = A4 + C*ERR
         ENDIF
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     + 'Distribution `Range of values for random error'
     +/'Cauchy       `-infinity < error < infinity'
     +/'Exponential  `-infinity < error < infinity'
     +/'Normal       `-infinity < error < infinity'
     +/'Uniform      `-inf < A =< error =< B < inf')
  200 FORMAT (
     +'pdf = 1.0/{pi*B(1.0 + [(x - A)/B]^2}, where B > 0.'
     +/'Exact s will be set equal to 1.0 for this distribution')
  300 FORMAT (
     +'pdf = (0.5/A)*exp(-|x|/A), where A > 0.'
     +/'Note that -infinity =< x =< infinity so the distribution is'
     +/'(+/-) exponential not the (+) exponential one with x >= 0.'
     +/'Exact s = A*sqrt(2.0) for this distribution')
  400 FORMAT (
     +'pdf = {1.0/[B*sqrt(2.0*pi)]}exp{-0.5*[(x - A)/B]^2}, B > 0'
     +/'Exact s = B for this distribution')
  500 FORMAT (
     +'pdf = 1.0/(B - A), where B > A.'
     +/'Exact s = sqrt[(B - A)^2/12.0] for this distribution')
      END
C
C-----------------------------------------------------------------------------
C
      SUBROUTINE ERRORS (ERR)
C
C (0,1) normal variate from G05DDF truncated to (BOT, TOP)
C
      IMPLICIT   NONE
C
C Argument
C      
      DOUBLE PRECISION, INTENT (OUT) :: ERR
C
C Locals
C      
      DOUBLE PRECISION BOT, ONE, TOP, ZERO
      DOUBLE PRECISION G05DDF$
      PARAMETER (BOT = - 3.0D+00, ONE = 1.0D+00, TOP = 3.0D+00,
     +           ZERO = 0.0D+00)
      LOGICAL  REPEET
      EXTERNAL G05DDF$
      REPEET = .TRUE.
      DO WHILE (REPEET)
         ERR = G05DDF$(ZERO, ONE)
         IF (ERR.GT.TOP .OR. ERR.LT.BOT) THEN
            REPEET = .TRUE.
         ELSE
            REPEET = .FALSE.
         ENDIF
      ENDDO
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE ERROUT (NDEC, NKEEP, NPTS, NREPS, NUM,
     +                   E, Y, Z,
     +                   ECALC)
C
C Add outliers to data
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NDEC, NKEEP, NPTS, NREPS
      INTEGER,          INTENT (OUT)   :: NUM(NPTS)
      DOUBLE PRECISION, INTENT (IN)    :: Y(NPTS)
      DOUBLE PRECISION, INTENT (INOUT) :: E(NPTS), Z(NPTS)
      LOGICAL,          INTENT (IN)    :: ECALC
C
C Locals
C      
      INTEGER    N0, N1, N2, N3, N4, N8, N10, N15
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N8 = 8,
     +           N10 = 10, N15 = 15)
      INTEGER    I, MAXOUT, NOPT, NUMBER
      INTEGER    COLOUR
      INTEGER    ICOLOR, IX, IY, NUMOPT
      PARAMETER (ICOLOR = 2, IX = 4, IY = 4, NUMOPT = 3)
      INTEGER    NUMPOS(NUMOPT)
      DOUBLE PRECISION AMOUNT, ERR, PCENT, SIGNS
      DOUBLE PRECISION ZERO, ONE, TEN, D20, PNT01
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TEN = 10.0D+00, 
     +           D20 = 1.0D+20, PNT01 = 0.01D+00)
      CHARACTER (LEN = 13) D13, SHOWLJ
      CHARACTER  (LEN = 12) FORM12, I12(2)
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ABORT, YES 
      CHARACTER  LINE*100, TEXT(30)*100
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   ERRORS, ESTATS
      EXTERNAL   GETDM1, GETJM1, GETD01, TABLE1, YESNO2, LBOX02, RANSEQ
      INTRINSIC  TRIM
      SAVE       AMOUNT, PCENT
      SAVE       NUMBER
      DATA       NUMBER / 1 /
      DATA       AMOUNT, PCENT / ONE, TEN /
      DATA       NUMPOS / NUMOPT*1 /
C
C Check NPTS and define MAXOUT 
C      
      IF (NPTS.LT.N2) RETURN
      E_NUMBERS = E_FORMATS()  
      IF (NPTS.LE.N10) THEN
         MAXOUT = NPTS/N2
      ELSEIF (NPTS.LE.100) THEN
         MAXOUT = NPTS/N3
      ELSE
         MAXOUT = NPTS/N4
      ENDIF
C
C Are outliers required ?
C      
      IF (NDEC.NE.N8) THEN
         LINE = 'Add outliers to current data ? (usually no)'
         YES = .FALSE.
         CALL YESNO2 (ICOLOR, IX, IY,
     +                LINE,
     +                YES)
         IF (.NOT.YES) RETURN
      ENDIF
      I12(1) = FORM12(MAXOUT)
      WRITE (LINE,100) I12(1)
      IF (NUMBER.GT.MAXOUT) NUMBER = N0
      CALL GETJM1 (N0, NUMBER, MAXOUT,
     +             LINE)
      IF (NUMBER.EQ.N0) RETURN
C
C Nature of outlier positions
C        
      LINE = 'You select the outlier positions ? (usually no)'
      YES = .FALSE.
      CALL YESNO2 (ICOLOR, IX, IY, 
     +             LINE,
     +             YES)
      IF (YES) THEN
C
C Positions input manually
C        
         DO I = N1, NUMBER
            NUM(I) = I
            I12(1) = FORM12(I)
            WRITE (LINE,200) I12(1)
            CALL GETJM1 (N1, NUM(I), NPTS,
     +                   LINE)
         ENDDO
      ELSE
C
C Positions chosen as a random permutation
C        
         DO I = N1, NPTS
            NUM(I) = I
         ENDDO 
         CALL RANSEQ (NPTS, NUM, 
     +                ABORT)    
         LINE = 'Table for positions selected ? (usually no)'
         YES = .FALSE.
         CALL YESNO2 (ICOLOR, IX, IY,
     +                LINE,
     +                YES)
         IF (YES) THEN
            COLOUR = N15
            CALL TABLE1 (COLOUR, 'OPEN')
            COLOUR = N4
            LINE = 'Table of current outlier positions'
            CALL TABLE1 (COLOUR, LINE)
            COLOUR = N0
            DO I = N1, NUMBER
               I12(1) = FORM12(I)
               I12(2) = FORM12(NUM(I))
               WRITE (LINE,300) TRIM(I12(1)), I12(2)
               CALL TABLE1 (COLOUR, LINE)
            ENDDO
            CALL TABLE1 (COLOUR, 'CLOSE')
         ENDIF
      ENDIF
C
C Select the outlier type
C      
      WRITE (TEXT,400)
      NOPT = N1
      CALL LBOX02 (ICOLOR, IX, IY, NOPT, NUMOPT, NUMPOS, 
     +             TEXT)
      IF (NOPT.EQ.N1) THEN
C
C Relative outlier
C        
         CALL GETDM1 (ZERO, PCENT, D20,
     +               'Percentage outlier error required')
         DO I = N1, NUMBER
            SIGNS = PNT01
            CALL ERRORS (ERR)
            IF (ERR.LE.ZERO) SIGNS = - PNT01
            Z(NUM(I)) = Y(NUM(I)) + PCENT*SIGNS*Y(NUM(I))
         ENDDO
      ELSEIF (NOPT.EQ.N2) THEN
C
C Constant outlier
C      
         CALL GETDM1 (ZERO, AMOUNT, D20,
     +               'Absolute value of outlier error required')
         DO I = N1, NUMBER
            CALL ERRORS (ERR)
            SIGNS = ONE
            IF (ERR.LE.ZERO) SIGNS = - ONE
            Z(NUM(I)) = Y(NUM(I)) + AMOUNT*SIGNS
         ENDDO
      ELSEIF (NOPT.EQ.N3) THEN
C
C Individual outliers
C      
         DO I = N1, NUMBER
            I12(1) = FORM12(NUM(I))
            IF (E_NUMBERS) THEN
               WRITE (LINE,500) TRIM(I12(1)), Y(NUM(I))
            ELSE
               D13 = SHOWLJ(Y(NUM(I)))
               WRITE (LINE,550) TRIM(I12(1)), D13
            ENDIF  
            CALL GETD01 (AMOUNT, LINE)
            Z(NUM(I)) = Y(NUM(I)) + AMOUNT
         ENDDO
      ENDIF
      
      IF (ECALC) THEN
C
C Possibility to re-calculate weights
C        
         WRITE (LINE,600)
         YES = .TRUE.
         CALL YESNO2 (ICOLOR, IX, IY,
     +                LINE, 
     +                YES)
         IF (YES) CALL ESTATS (NKEEP, NPTS, NREPS,
     +                         E, Z)
      ENDIF
C
C Format statements
C      
  100 FORMAT ('Number of outliers required: Maximum =',1X,A)
  200 FORMAT ('Position required for outlier number',1X,A)
  300 FORMAT (1X,'Position of outlier(',A,') =',1X,A)
  400 FORMAT (
     + 'Outlier errors = a% exact|y| but with random sign'
     +/'Outlier errors = fixed value but with random sign'
     +/'Outlier errors = your  individually chosen values')
  500 FORMAT ('Outlier error required: (y(',A,') =',1P,E11.3,')')
  550 FORMAT ('Outlier error required: (y(',A,') =',1X,A,')')  
  600 FORMAT ('Now re-calculate s to include outliers ? (usually yes)')
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE ESTATS (NKEEP, NPTS, NREPS,
     +                   E, Z)
C
C Calculate standard errors from data supplied
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: NKEEP, NPTS, NREPS
      DOUBLE PRECISION, INTENT (IN)  :: Z(NPTS)
      DOUBLE PRECISION, INTENT (OUT) :: E(NPTS)
C
C Locals
C      
      INTEGER    N0, N1
      PARAMETER (N0 = 0, N1 = 1)
      INTEGER    I, J, K1, K2, K3
      DOUBLE PRECISION RNDOF, RNREP, STDEV, ZBAR, ZSQ
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      INTRINSIC  DBLE, SQRT
      RNREP = DBLE(NREPS)
      RNDOF = RNREP - ONE
      K1 = N0
      K2 = N0
      K3 = N0
      DO I = N1, NKEEP
         ZBAR = ZERO
         DO J = N1, NREPS
            K1 = K1 + N1
            ZBAR = ZBAR + Z(K1)
         ENDDO
         ZBAR = ZBAR/RNREP
         ZSQ = ZERO
         DO J = N1, NREPS
            K2 = K2 + N1
            ZSQ = ZSQ + (Z(K2) - ZBAR)**2
         ENDDO
         STDEV = SQRT(ZSQ/RNDOF)
         DO J = N1, NREPS
            K3 = K3 + N1
            E(K3) = STDEV
          ENDDO
      ENDDO
      END
C
C--------------------------------------------------------------------
C
      SUBROUTINE OUTDAT (ITYPE, MTEXT, NKEEP, NPTS, NVAR,
     +                   E, ESAV, U, V, X, XX, Y, YY, Z,
     +                   FNAME, TEX,
     +                   ECALC)
C
C Output data
C 06/04/2022 added E_NUMBERS and E_FORMATS, etc.
C 08/05/2022 added NKEEP, XX(NKEEP), and YY(NKEEP) containing the original data as well
C            X1 and Y1 to simplify the call to GKS004so that the number of asterisks is
C            the same as the dimension of the original data   
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: MTEXT, NKEEP, NPTS, NVAR
      INTEGER,             INTENT (OUT)   :: ITYPE
      DOUBLE PRECISION,    INTENT (IN)    :: X(NPTS), Y(NPTS)  
      DOUBLE PRECISION,    INTENT (IN)    :: XX(NKEEP), YY(NKEEP)      
      DOUBLE PRECISION,    INTENT (IN)    :: U(NPTS), V(NPTS)
      DOUBLE PRECISION,    INTENT (INOUT) :: E(NPTS), ESAV(NPTS),
     +                                       Z(NPTS)
      CHARACTER (LEN = *), INTENT (IN)    :: TEX(MTEXT)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME(2)
      LOGICAL,             INTENT (IN)    :: ECALC
C
C Locals
C      
      INTEGER    N0, N1, N2, N3, N4, N5, N7, N15
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5, N7 = 7,
     +           N15 = 15)
      INTEGER    L0, M4, M5, NIN, NOUT
      PARAMETER (L0 = 0, M4 = 4, M5 = 1, NIN = 3, NOUT = 4)
      INTEGER    ISEND, NDEC
      INTEGER    I
      INTEGER    COLOUR
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMOPT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 6)
      INTEGER    NUMBLD(30), NUMPOS(NUMOPT)
      INTEGER    NSTART, NTEXT
      DOUBLE PRECISION X1(N1), Y1(N1)
      DOUBLE PRECISION ZERO, DFAULT, RTOL, WDIFF, WSSQ
      PARAMETER (ZERO = 0.0D+00, DFAULT = 1.0D+00, RTOL = 1.0D-200)
      CHARACTER (LEN = 13) D13(6), SHOWLJ, SHOWRJ 
      CHARACTER (LEN = 12) I12, FORM12
      CHARACTER  TITLE*80
      CHARACTER  PTITLE*25, XTITLE*1, YTITLE*1
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    SAVEIT
      PARAMETER (SAVEIT = .TRUE.)
      LOGICAL    ABORT, ALLPOS
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    REPEET
      CHARACTER  LINE*100, TEXT(30)*100
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ, SHOWRJ
      EXTERNAL   GKS004, OFILES, GETTXT, FNAMES, TABLE1, LBOX01,
     +           PATCH1
      DATA NUMPOS / NUMOPT*1 /
      DATA NUMBLD / 30*0 /
C
C Initialise then check weights
C      
      E_NUMBERS = E_FORMATS()
      X1(1) = DFAULT
      Y1(1) = DFAULT
      ITYPE = N0
      WSSQ = ZERO
      ALLPOS = .TRUE.
      ABORT = .FALSE.
      DO I = N1, NPTS
         IF (E(I).LE.RTOL) THEN
            IF (.NOT.ABORT) THEN
               ABORT = .TRUE.
               COLOUR = N15
               CALL TABLE1 (COLOUR, 'OPEN')
               COLOUR = N0
            ENDIF
            E(I) = DFAULT
            I12 = FORM12(I)
            IF (E_NUMBERS) THEN
               WRITE (LINE,100) TRIM(I12), RTOL, DFAULT
            ELSE
               D13(1) = SHOWLJ(RTOL)
               D13(2) = SHOWLJ(DFAULT)
               WRITE (LINE,150) TRIM(I12), TRIM(D13(1)), D13(2)   
            ENDIF   
            CALL TABLE1 (COLOUR, LINE)
         ENDIF
         IF (ESAV(I).LT.RTOL) ESAV(I) = DFAULT
         IF (Z(I).LT.ZERO) ALLPOS = .FALSE.
         WDIFF = (Z(I) - Y(I))/E(I)
         WSSQ  = WSSQ + WDIFF*WDIFF
      ENDDO
      IF (ABORT) THEN
         CALL TABLE1 (COLOUR, 'CLOSE')
         ABORT = .FALSE.
      ENDIF
C
C Check what to do with negative Y values
C      
      IF (.NOT.ALLPOS) THEN
         WRITE (TEXT,200)
         NDEC = N1
         NSTART = N5
         NTEXT = N7
         I = N3
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, I,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         IF (NDEC.EQ.N1) THEN
C
C Set to zero
C           
            DO I = N1, NPTS
               IF (Z(I).LT.ZERO) Z(I) = ZERO
            ENDDO
         ELSEIF (NDEC.EQ.N2) THEN
C
C Reverse the sign
C         
            DO I = N1, NPTS
               IF (Z(I).LT.ZERO) Z(I) = - Z(I)
            ENDDO
         ENDIF
      ENDIF
C
C Main cycle point
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (E_NUMBERS) THEN
            WRITE (TEXT,300) WSSQ
         ELSE
            D13(1) = SHOWLJ(WSSQ)  
            WRITE (TEXT,350) D13(1)  
         ENDIF  
         NDEC = N2
         NSTART = 15
         NTEXT = NSTART + NUMOPT - N1
         NUMBLD(1) = 1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         IF (NDEC.EQ.1) THEN
C
C Table
C           
            COLOUR = N15
            CALL TABLE1 (COLOUR, 'OPEN')
            COLOUR = N4
            IF (NVAR.EQ.1) THEN
               WRITE (LINE,400)
               CALL TABLE1 (COLOUR, LINE)
               COLOUR = N0
               DO I = N1, NPTS
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,500) I, X(I), Y(I), Z(I), E(I)
                  ELSE
                     D13(1) = SHOWRJ(X(I))
                     D13(2) = SHOWRJ(Y(I))
                     D13(3) = SHOWRJ(Z(I))
                     D13(4) = SHOWRJ(E(I))
                     WRITE (LINE,550) I, D13(1), D13(2), D13(3), D13(4)
                  ENDIF  
                  CALL TABLE1 (COLOUR, LINE)
               ENDDO
            ELSEIF (NVAR.EQ.N2) THEN
               WRITE (LINE,600)
               CALL TABLE1 (COLOUR, LINE)
               COLOUR = 0
               DO I = N1, NPTS
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,700) I, X(I), U(I), Y(I), Z(I), E(I)
                  ELSE
                     D13(1) = SHOWRJ(X(I))
                     D13(2) = SHOWRJ(U(I))
                     D13(3) = SHOWRJ(Y(I))
                     D13(4) = SHOWRJ(Z(I))
                     D13(5) = SHOWRJ(E(I))
                     WRITE (LINE,750) I, D13(1), D13(2), D13(3), D13(4), 
     +                                D13(5)  
                  ENDIF  
                  CALL TABLE1 (COLOUR, LINE)
               ENDDO
            ELSE
               WRITE (LINE,800)
               CALL TABLE1 (COLOUR, LINE)
               COLOUR = 0
               DO I = N1, NPTS
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,900) I, X(I), U(I), V(I), Y(I), Z(I),
     +                                E(I)
                  ELSE
                     D13(1) = SHOWRJ(X(I))
                     D13(2) = SHOWRJ(U(I))
                     D13(3) = SHOWRJ(V(I))
                     D13(4) = SHOWRJ(Y(I))
                     D13(5) = SHOWRJ(Z(I))
                     D13(6) = SHOWRJ(E(I))
                     WRITE (LINE,950) I, D13(1), D13(2), D13(3), D13(4), 
     +                                D13(5), D13(6) 
                  ENDIF  
                  CALL TABLE1 (COLOUR, LINE)
               ENDDO
            ENDIF
            CALL TABLE1 (COLOUR, 'CLOSE')
            REPEET = .TRUE.
         ELSEIF (NDEC.EQ.N2) THEN
C
C Plot
C         
            IF (NPTS.GT.N2) THEN
               PTITLE = 'Exact = *, Plus error = .'
               XTITLE = 'X'
               YTITLE = 'Y'
               CALL GKS004 (L0, L0, L0, L0, M4, M5, L0, L0,
     +                      NKEEP, NPTS, N1, N1,
     +                      XX, X, X1, X1,
     +                      YY, Z, Y1, Y1,
     +                      PTITLE, XTITLE, YTITLE, SAVEIT, SAVEIT)
            ENDIF
            REPEET = .TRUE.
         ELSEIF (NDEC.EQ.N3) THEN
C
C File but first connect the input data file to prevent overwriting
C         
            CLOSE (UNIT = NIN)
            OPEN (UNIT = NIN, FILE = FNAME(1))
            ISEND = N1
            CALL OFILES (ISEND, NOUT,
     +                   FNAME(2),
     +                   ABORT)
            CLOSE (UNIT = NIN) 
            IF (ABORT) THEN
               CLOSE (UNIT = NOUT)
            ELSE
               CALL GETTXT ('Title for perturbed data', TITLE)
               WRITE (NOUT,'(A)') TITLE
               WRITE (NOUT,'(2I6)') NPTS, NVAR + 2
               IF (NVAR.EQ.N1) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (NOUT,1000) (X(I), Z(I), E(I), I = 1, NPTS)
                  ELSE
                     DO I = 1, NPTS
                        D13(1) = SHOWRJ(X(I))
                        D13(2) = SHOWRJ(Z(I))
                        D13(3) = SHOWRJ(E(I))
                        WRITE (NOUT,1050) D13(1), D13(2), D13(3)  
                     ENDDO  
                  ENDIF  
               ELSEIF (NVAR.EQ.N2) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (NOUT,1100) (X(I), U(I), Z(I), E(I),
     +                                  I = 1, NPTS)
                  ELSE
                     DO I = N1, NPTS
                        D13(1) = SHOWRJ(X(I))
                        D13(2) = SHOWRJ(U(I))
                        D13(3) = SHOWRJ(Z(I))
                        D13(4) = SHOWRJ(ESAV(I))
                        WRITE (NOUT,1150) D13(1), D13(2), D13(3),
     +                                    D13(4)  
                     ENDDO
                  ENDIF  
               ELSE
                  IF (E_NUMBERS) THEN
                     WRITE (NOUT,1200) (X(I), U(I), V(I), Z(I), E(I),
     +                                  I = 1, NPTS)
                  ELSE
                     DO I = N1, NPTS
                        D13(1) = SHOWRJ(X(I))
                        D13(2) = SHOWRJ(U(I))
                        D13(3) = SHOWRJ(V(I))
                        D13(4) = SHOWRJ(Z(I))
                        D13(5) = SHOWRJ(ESAV(I))
                        WRITE (NOUT,1250) D13(1), D13(2), D13(3),
     +                                    D13(4), D13(5)  
                     ENDDO
                   ENDIF 
               ENDIF
               WRITE (NOUT,'(I6)') (MTEXT + 1)
               WRITE (NOUT,'(A)') (TEX(I), I = N1, MTEXT)
               WRITE (NOUT,'(A)') 'Random error added by program ADDERR'
               
               IF (ECALC) THEN
C
C Add a further set with exact weights
C                 
                  WRITE (NOUT,'(A)') TITLE
                  WRITE (NOUT,'(2I6)') NPTS, NVAR + N2
                  IF (NVAR.EQ.N1) THEN
                     IF (E_NUMBERS) THEN
                        WRITE (NOUT,1000) (X(I), Z(I), ESAV(I),
     +                                     I = N1, NPTS)
                     ELSE
                        DO I = 1, NPTS
                           D13(1) = SHOWRJ(X(I))
                           D13(2) = SHOWRJ(Z(I))
                           D13(3) = SHOWRJ(ESAV(I))
                           WRITE (NOUT,1050) D13(1), D13(2), D13(3)  
                        ENDDO  
                     ENDIF
                  ELSEIF (NVAR.EQ.N2) THEN
                     IF (E_NUMBERS) THEN
                        WRITE (NOUT,1100) (X(I), U(I), Z(I), ESAV(I),
     +                                     I = N1, NPTS)
                     ELSE
                        DO I = N1, NPTS
                           D13(1) = SHOWRJ(X(I))
                           D13(2) = SHOWRJ(U(I))
                           D13(3) = SHOWRJ(Z(I))
                           D13(4) = SHOWRJ(ESAV(I))
                           WRITE (NOUT,1150) D13(1), D13(2), D13(3),
     +                                       D13(4)  
                        ENDDO
                     ENDIF  
                  ELSE
                     IF (E_NUMBERS) THEN
                        WRITE (NOUT,1200) (X(I), U(I), V(I), Z(I),
     +                         ESAV(I), I = N1, NPTS)
                     ELSE
                         DO I = N1, NPTS
                           D13(1) = SHOWRJ(X(I))
                           D13(2) = SHOWRJ(U(I))
                           D13(3) = SHOWRJ(V(I))
                           D13(4) = SHOWRJ(Z(I))
                           D13(5) = SHOWRJ(ESAV(I))
                           WRITE (NOUT,1250) D13(1), D13(2), D13(3),
     +                                       D13(4), D13(5)  
                        ENDDO
                     ENDIF  
                  ENDIF
                  WRITE (NOUT,'(I6)') (MTEXT + N1)
                  WRITE (NOUT, '(A)') (TEX(I), I = N1, MTEXT)
                  WRITE (NOUT,'(A)')
     +      'Random error added by program ADDERR ... but with exact s'
               ENDIF
               
               CLOSE (UNIT = NOUT)
               
               IF (ECALC) THEN
C
C Inform user if exact weights have been appended
C                 
                  WRITE (TEXT,1300)
                  NTEXT = N4
                  CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NTEXT,
     +                         TEXT,
     +                         BORDER)
               ENDIF
C
C Announce the output file
C               
               I = N2
               CALL FNAMES (I,
     +                      FNAME(N2))
               FNAME(N2) = BLANK
            ENDIF
            REPEET = .TRUE.
         ELSEIF (NDEC.EQ. NUMOPT - N2) THEN
C
C New error to same data
C         
            ITYPE = N1
            REPEET = .FALSE.
         ELSEIF (NDEC.EQ.NUMOPT - N1) THEN
C
C New data file
C         
            ITYPE = N2
            REPEET = .FALSE.      
         ELSEIF (NDEC.EQ.NUMOPT) THEN
C
C Exit
C         
            ITYPE = N3
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C
  100 FORMAT (11X,'s(',A,') =<',1P,E8.1,': value re-set to',0P,F4.1)
  150 FORMAT (11X,'s(',A,') =<',1X,A,': value re-set to',1X,A)  
  200 FORMAT (
     + 'Some experiments only generate positive y-values'
     +/'but, as a result of adding random error by this'
     +/'program, some y-values are now negative.'/
     +/'Set all negative y-values to zero'
     +/'Change sign for negative y-values'
     +/'No change .... leave y-values < 0')
  300 FORMAT (
     + 'View/Save current simulation or resume'
     +/
     +/'The exact data in the input file has been'
     +/'perturbed by adding random errors of the'
     +/'type requested.'
     +/
     +/'The current WSSQ =',1P,E13.5
     +/
     +/'To save the current data set you can write'
     +/'it out now to a file.'
     +/
     +/'Otherwise, you can add another vector of'
     +/'errors, read in another data set or quit.'
     +/
     +/'Display table'
     +/'Display graph'
     +/'Save simulated data to file'
     +/'Add errors to same data set'
     +/'Add errors to a new data set'
     +/'Quit  ...  Exit program ADDERR')
  350 FORMAT (
     + 'View/Save current simulation or resume'
     +/
     +/'The exact data in the input file has been'
     +/'perturbed by adding random errors of the'
     +/'type requested.'
     +/
     +/'The current WSSQ =',1X,A
     +/
     +/'To save the current data set you can write'
     +/'it out now to a file.'
     +/
     +/'Otherwise, you can add another vector of'
     +/'errors, read in another data set or quit.'
     +/
     +/'Display table'
     +/'Display graph'
     +/'Save simulated data to file'
     +/'Add errors to same data set'
     +/'Add errors to a new data set'
     +/'Quit  ...  Exit program ADDERR')   
  400 FORMAT (
     +'   Number       x-value          y-old          y-new',
     +'          s-new')
C  400 TEMPLATE FORMAT (
C     +'   Number       x-value          y-old          y-new',
C     +'          s-new')     
  500 FORMAT (I6,2X,1P,4(2X,E13.5))
  550 FORMAT (I6,2X,4(2X,A13))
  600 FORMAT (
     +'   Number      x1-value       x2-value          y-old',
     +'          y-new          s-new')
C  600 TEMPLATE FORMAT (
C     +'   Number        x1-value       x2-value          y-old',
C     +'          y-new          s-new')     
  700 FORMAT (I6,2X,1P,5(2X,E13.5))
  750 FORMAT (I6,2X,5(2X,A13))
  800 FORMAT (
     +'   Number      x1-value       x2-value       x3-value',
     +'          y-old          y-new          s-new')
C  800 TEMPLATE FORMAT (
C     +'   Number      x1-value       x2-value       x3-value',
C     +'          y-old          y-new          s-new')     
  900 FORMAT (I6,2X,1P,6(2X,E13.5))
  950 FORMAT (I6,2X,6(2X,A13))
 1000 FORMAT (1P,3(2X,E13.5))
 1050 FORMAT (3(2X,A13))
 1100 FORMAT (1P,4(2X,E13.5))
 1150 FORMAT (4(2X,A13))
 1200 FORMAT (1P,5(2X,E13.5))
 1250 FORMAT (5(2X,A13))
 1300 FORMAT (
     + 'The same data but having exact s has been appended to the'
     +/'end of the output file, so you can compare the effects of'
     +/'exact weights with weights calculated from perturbed data'
     +/'by splitting the file and analysing each half separately.')
      END
C
C
