C
C
C FTN95 version
C =============
C
C
C     INCLUDE 'dllchk.for'
      PROGRAM MAIN
C
C PACKAGE : SIMFIT
C PROGRAM : AVERAGE
C ACTION  : Input X, Y then calculate average Y e.g. from spike curve
C VERSION : details from SIMVER/DLLCHK
C ADVICE  : The program is now controlled by N and XTOTAL as follows:
C           N =< 2: Error in data so try to read in a new data set if required
C           XTOTAL =< EPSI: Current calculation with XSTART, XSTOP has failed
C           Note that X1 and X2 are used to set and hold the fixed limits but
C           XSTART and XSTOP are always adjusted to lie in (XMIN,XMAX)
C           Note that N should never be < 1 o/w program will crash
C           since array dimensions in called routines will be < 1
C AUTHOR  : W. G. Bardsley, University of Manchester, U.K., 22/11/92
C           DBOS version ... 16/9/94
C           16/02/1995 Removed error when N < 1 and allowed 3 column input
C           16/02/1995 Revised for Salamanca
C           17/06/1997 win32 version
C           05/08/1998 added dllchk
C           14/12/1998 replaced TUTORS by TUTOR1
C           12/09/1999 added calls to WINDOW
C           12/02/2000 Introduced SIMVER
C           20/03/2001 revised
C           11/12/2007 revised for version 6
C           13/05/2022 added E_NUMBERS and E_FORMATS, etc.
C
      IMPLICIT   NONE
      INTEGER    NIN, NMAX, NOUT
      PARAMETER (NIN = 3, NOUT = 4)
      INTEGER    N0, N1, N2, N3, N4, N5
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5)
      INTEGER    IERR, ISEND, L, M, N, NCOL, NGRAF, NROW
      DOUBLE PRECISION, ALLOCATABLE :: A(:,:), E(:), X(:), Y(:),
     +                                 XGRAF(:), YGRAF(:)
      DOUBLE PRECISION AREA, XABOVE, XBELOW, XSTART, XSTOP, XTOTAL
      DOUBLE PRECISION XMAX, XMIN, X1, X2, YMAX, YMIN
      DOUBLE PRECISION YCRIT, YMEAN
      DOUBLE PRECISION XVER, YVER
      DOUBLE PRECISION XTEMP(2), YTEMP(2)
      DOUBLE PRECISION DFAULT
      PARAMETER (DFAULT = - 1.0D+00)
      CHARACTER  DFILE*1024, FNAME*1024, TITLE*80
      CHARACTER  PTITLE*30, XTITLE*1, YTITLE*2
      CHARACTER  DVER*30, PVER*15
      PARAMETER (PVER = 'w_average.exe')
      CHARACTER  BLANK*1, PNAME*7
      PARAMETER (BLANK = ' ', PNAME = 'AVERAGE')
      LOGICAL    SAVEIT, SUPPLY
      PARAMETER (SAVEIT = .TRUE., SUPPLY = .TRUE.)
      LOGICAL    ABORT, ACTION, AGAIN, FIRST, RESET, SHOW
      EXTERNAL   GKS004, REVPRO, WINDOW, M_FITONE, FNAMES
      EXTERNAL   ADVISE, DETAIL, DATAIN, WRKOUT
      EXTERNAL   DLLCHK, SIMVER
      INTRINSIC  MAX, MIN

C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C
      ISEND = 1
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
      CALL SIMVER (XVER, YVER,
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER,
     +             DVER, PVER,
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C

C
C Initialise and provide program description
C
      FIRST = .TRUE.
      CALL ADVISE (DVER,
     +             ABORT, FIRST)
      IF (ABORT) THEN
         AGAIN = .FALSE.
         DFILE = BLANK
      ELSE
         NCOL = 0
         NROW = 0
         DFILE = BLANK
         FNAME = BLANK
         TITLE = BLANK
         AGAIN = .TRUE.
         XTOTAL = DFAULT
         N = N1
         NMAX = 1000
         IERR = 0
         IF (ALLOCATED(A)) DEALLOCATE(A, STAT = IERR)
         IF (IERR.NE.0) STOP  
         IF (ALLOCATED(E)) DEALLOCATE(E, STAT = IERR)
         IF (IERR.NE.0) STOP
         IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
         IF (IERR.NE.0) STOP
         IF (ALLOCATED(XGRAF)) DEALLOCATE(XGRAF, STAT = IERR)
         IF (IERR.NE.0) STOP
         IF (ALLOCATED(Y)) DEALLOCATE(Y, STAT = IERR)
         IF (IERR.NE.0) STOP
         IF (ALLOCATED(YGRAF)) DEALLOCATE(YGRAF, STAT = IERR)
         IF (IERR.NE.0) STOP 
         ALLOCATE(A(NMAX,N3), STAT = IERR)
         IF (IERR.NE.0) STOP
         ALLOCATE(E(NMAX), STAT = IERR)
         IF (IERR.NE.0) STOP
         ALLOCATE(X(NMAX), STAT = IERR)
         IF (IERR.NE.0) STOP
         ALLOCATE(XGRAF(NMAX), STAT = IERR)
         IF (IERR.NE.0) STOP
         ALLOCATE(Y(NMAX), STAT = IERR)
         IF (IERR.NE.0) STOP
         ALLOCATE(YGRAF(NMAX), STAT = IERR)
         IF (IERR.NE.0) STOP     
      ENDIF
C
C Decide what to do ... No action if N < 2 or XTOTAL < 0
C
      DO WHILE (AGAIN)
         CALL DETAIL (ISEND, N,
     +                AREA, XABOVE, XBELOW, XMAX, XMIN,
     +                XSTART, XSTOP, XTOTAL, X1, X2, YCRIT, YMAX,
     +                YMEAN, YMIN)
         IF (ISEND.EQ.N1) THEN
C
C Read in and check a new data set
C
            ISEND = 14
            CALL M_FITONE (ISEND, NCOL, NIN, NROW,
     +                     FNAME, TITLE)
            IF (NROW.GT.NMAX) THEN
               NMAX = NROW
               IERR = 0
               IF (ALLOCATED(A)) DEALLOCATE(A, STAT = IERR)
               IF (IERR.NE.0) STOP  
               IF (ALLOCATED(E)) DEALLOCATE(E, STAT = IERR)
               IF (IERR.NE.0) STOP
               IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
               IF (IERR.NE.0) STOP
               IF (ALLOCATED(XGRAF)) DEALLOCATE(XGRAF, STAT = IERR)
               IF (IERR.NE.0) STOP
               IF (ALLOCATED(Y)) DEALLOCATE(Y, STAT = IERR)
               IF (IERR.NE.0) STOP
               IF (ALLOCATED(YGRAF)) DEALLOCATE(YGRAF, STAT = IERR)
               IF (IERR.NE.0) STOP 
               ALLOCATE(A(NMAX,N3), STAT = IERR)
               IF (IERR.NE.0) STOP
               ALLOCATE(E(NMAX), STAT = IERR)
               IF (IERR.NE.0) STOP
               ALLOCATE(X(NMAX), STAT = IERR)
               IF (IERR.NE.0) STOP
               ALLOCATE(XGRAF(NMAX), STAT = IERR)
               IF (IERR.NE.0) STOP
               ALLOCATE(Y(NMAX), STAT = IERR)
               IF (IERR.NE.0) STOP
               ALLOCATE(YGRAF(NMAX), STAT = IERR)
               IF (IERR.NE.0) STOP     
            ENDIF     
            IF (NROW.GT.N1 .AND. NCOL.GE.N2 .AND. NCOL.LE.3) THEN
               N = NROW               
               CALL DATAIN (N, NGRAF, NIN, NMAX, NOUT, N3,
     +                      A, E, X, XGRAF, XMAX, XMIN, XSTART,
     +                      XSTOP, X1, X2, Y, YCRIT,
     +                      YGRAF, YMAX, YMIN,
     +                      DFILE, FNAME,
     +                      ABORT, RESET, SUPPLY)
            ELSE
               ABORT = .TRUE.
            ENDIF   
C
C N, X and Y are used to calculate, NGRAF, XGRAF and YGRAF to plot
C
            IF (ABORT) THEN
               N = N1
               XTOTAL = DFAULT
               FNAME = BLANK
               AGAIN = .FALSE.
            ELSE
C
C Define XSTART and XSTOP then calculate with the new data set
C
               XSTART = MAX(X1,XMIN)
               XSTOP = MIN(X2,XMAX)
               IF (XSTART.GT.XMAX) XSTART = XMAX
               IF (XSTOP.LT.XMIN) XSTOP = XMIN
               CALL WRKOUT (N, NOUT,
     +                      AREA, X, XABOVE, XBELOW, XSTART,
     +                      XSTOP, XTOTAL, Y, YCRIT, YMEAN)
               AGAIN = .TRUE.
            ENDIF
         ELSEIF (ISEND.EQ.N2) THEN
C
C Plot current data
C
            XTEMP(N1) = XSTART
            XTEMP(N2) = XSTOP
            YTEMP(N1) = YCRIT
            YTEMP(N2) = YCRIT
            PTITLE = 'Data(.) and critical level(*)'
            XTITLE = 'X'
            YTITLE = 'Y'
            M = N1! Data 
            L = N2! Threshold
            CALL GKS004 (N1, L, N0, N0,
     +                   N0, N4, M, N0,
     +                   N, N2, NGRAF, N2,
     +                   X, XTEMP, XGRAF, XTEMP,
     +                   Y, YTEMP, YGRAF, YTEMP,
     +                   PTITLE, XTITLE, YTITLE,
     +                   SAVEIT, SAVEIT)
            AGAIN = .TRUE.
         ELSEIF (ISEND.EQ.N3) THEN
C
C Define XSTART and XSTOP then calculate with the old data set
C
            XSTART = MAX(X1,XMIN)
            XSTOP = MIN(X2,XMAX)
            IF (XSTART.GT.XMAX) XSTART = XMAX
            IF (XSTOP.LT.XMIN) XSTOP = XMIN
            CALL WRKOUT (N, NOUT,
     +                   AREA, X, XABOVE, XBELOW, XSTART,
     +                   XSTOP, XTOTAL, Y, YCRIT, YMEAN)
            AGAIN = .TRUE.
         ELSEIF (ISEND.EQ.N4) THEN
C
C Advice
C
            FIRST = .FALSE.
            CALL ADVISE (DVER,
     +                   ABORT, FIRST)
            AGAIN = .TRUE.
         ELSEIF (ISEND.EQ.N5) THEN
            CALL REVPRO (NOUT)
            AGAIN = .TRUE.
         ELSE
            ABORT = .FALSE.
            AGAIN = .FALSE.
         ENDIF
      ENDDO
 
      IF (DFILE.NE.BLANK) THEN
         CLOSE (UNIT = NOUT)
         ISEND = 2
         CALL FNAMES(ISEND,
     +               DFILE)
      ENDIF         

C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = 1
      ACTION = .FALSE.
      CALL WINDOW (ISEND,
     +             TITLE, 
     +             ACTION)
C
C======================================================================
C

      CLOSE (UNIT = NOUT)
      END
C
C----------------------------------------------------------------
C
      SUBROUTINE ADVISE (DVER,
     +                   ABORT, FIRST)
C
C Advise user
C
      IMPLICIT   NONE
C
C Arguments
C
      CHARACTER (LEN = *), INTENT (IN)  :: DVER
      LOGICAL,             INTENT (IN)  :: FIRST
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 3, NUMHDR = 13, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*63, OPTION(NUMOPT)*15
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_AVERAGE
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help           ',
     +'Run the program',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (FIRST) THEN
            WRITE (HEADER,100) DVER
            ISEND = 1
            CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
            ISEND = 1
         ENDIF
         IF (ISEND.EQ.1) THEN
            CALL HELP_AVERAGE ('average')
            IF (FIRST) THEN
               REPEET = .TRUE.
            ELSE
               ABORT = .FALSE.
               REPEET = .FALSE.
            ENDIF
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `AVERAGE'
     +/'        `      '
     +/'Action  `Trapezoidal estimation of areas and averages'
     +/'        `Input x,y: calculate area, mean-y and fraction'
     +/'        `above and below a y-threshold over a sub-interval'
     +/'        `      '
     +/'Version `',A
     +/'        `      '
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      '
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C-----------------------------------------------------------------------------
C
      SUBROUTINE DATAIN (N, NGRAF, NIN, NMAX, NOUT, N3,
     +                   A, E, X, XGRAF, XMAX, XMIN, XSTART, XSTOP,
     +                   X1, X2, Y, YCRIT,  YGRAF, YMAX, YMIN,
     +                   DFILE, FNAME,
     +                   ABORT, RESET, SUPPLY)
C
C Read in data and check
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NIN, NMAX, NOUT, N3
      INTEGER,             INTENT (INOUT) :: N, NGRAF
      DOUBLE PRECISION,    INTENT (INOUT) :: A(NMAX,N3), E(NMAX),
     +                                       X(NMAX), XGRAF(NMAX), XMAX,
     +                                       XMIN, XSTART, XSTOP, X1, X2
      DOUBLE PRECISION,    INTENT (INOUT) :: Y(NMAX), YCRIT,
     +                                       YGRAF(NMAX), YMAX, YMIN
      CHARACTER (LEN = *), INTENT (INOUT) :: DFILE, FNAME
      LOGICAL,             INTENT (IN)    :: SUPPLY
      LOGICAL,             INTENT (INOUT) :: RESET
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C      
      INTEGER    I, IOS, J
      INTEGER    NCMAX, NCOL
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4)
      DOUBLE PRECISION EPSI, ZERO, ONE
      PARAMETER (EPSI = 1.0D-200, ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER (LEN = 100) LINE
      CHARACTER (LEN = 80 ) TFILE, TITLE, TRIM80
      CHARACTER (LEN = 13 ) D13(4), SHOWRJ
      CHARACTER (LEN = 1  ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    FIRST, NOFILE
      LOGICAL    FIXCOL, FIXROW, LABEL
      PARAMETER (FIXCOL = .FALSE., FIXROW = .FALSE., LABEL = .TRUE.)
      LOGICAL    RESETX, RESETY
      LOGICAL    YREPS
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   MATTIN, PUTFAT, RESFIL, YESNO2, NYYBAR, PUTADV
      EXTERNAL   TRIM80
      SAVE       RESETX, RESETY
      SAVE       FIRST
      DATA       FIRST / .TRUE. /
C
C Get the data
C
      E_NUMBERS = E_FORMATS()
      IF (.NOT.SUPPLY) THEN
         I = - 1
         NCOL = 2
         NCMAX = N3
         FNAME = BLANK
         CLOSE (UNIT = NIN)
         CALL MATTIN (I, NCMAX, NCOL, NIN, NMAX, N,
     +                A, X, 
     +                FNAME, TITLE,
     +                ABORT, FIXCOL, FIXROW, LABEL)
         CLOSE (UNIT = NIN)
         IF (ABORT) THEN
            FNAME = BLANK
            RETURN
         ENDIF
      ELSE
         ABORT = .FALSE. 
         OPEN (UNIT = NIN, FILE = FNAME)
         READ (NIN,'(A)') TITLE
         READ (NIN,*, IOSTAT=IOS) N, NCOL
         IF (N.GT.1 .AND. NCOL.GE.2 .AND. NCOL.LE.3) THEN
            DO I = 1, N
               READ (NIN,*,IOSTAT=IOS) (A(I,J), J = 1, NCOL)
            ENDDO
         ENDIF
         CLOSE (UNIT = NIN)       
      ENDIF   
C
C Check that there are sufficient points
C
      IF (N.LT.2) THEN
         N = 1
         CALL PUTFAT ('Must have at least 2 x,y points')
         ABORT = .TRUE.
         RETURN
      ENDIF
      IF (NCOL.EQ.1) THEN
         CALL PUTFAT ('Must have at least two columns: x, y')
         ABORT = .TRUE.
         RETURN
      ENDIF
      IF (FNAME.EQ.BLANK) THEN
         NOFILE = .TRUE.
      ELSE
         NOFILE = .FALSE.
      ENDIF
C
C Copy the data values into N, NGRAF, X, XGRAF, Y, YGRAF
C
      NGRAF = N
      DO I = 1, N
         E(I) = ONE
         X(I) = A(I,1)
         Y(I) = A(I,2)
         XGRAF(I) = X(I)
         YGRAF(I) = Y(I)
      ENDDO
      YMIN = Y(N)
      YMAX = Y(N)
      YREPS = .FALSE.
      DO I = 1, N - 1
C
C Check for nondecreasing order
C
         IF (X(I + 1).LT.X(I)) THEN
            WRITE (LINE,100) I
            CALL PUTFAT (LINE)
            ABORT = .TRUE.
            RETURN
         ENDIF
C
C Check for replicates
C
         IF (X(I + 1) - X(I).LE.EPSI) YREPS = .TRUE.
C
C Check for negative Y
C
         IF (Y(I).LT.ZERO) THEN
            WRITE (LINE,200) I
            CALL PUTFAT (LINE)
            ABORT = .TRUE.
            RETURN
         ENDIF
         IF (Y(I).LT.YMIN) YMIN = Y(I)
         IF (Y(I).GT.YMAX) YMAX = Y(I)
      ENDDO
      XMIN = X(1)
      XMAX = X(N)
      IF (Y(N).LT.ZERO) THEN
         WRITE (LINE,200) N
         CALL PUTFAT (LINE)
         ABORT = .TRUE.
         RETURN
      ENDIF
C
C Calculate means if replicates are present
C
      IF (YREPS) THEN
         I = 2
         CALL NYYBAR (I, N,
     +                X, Y, E)
         CALL PUTADV ('Replicates have been replaced by means')
      ENDIF
C
C First time round open a results file
C
      IF (FIRST) THEN
         CALL RESFIL (NOUT, 
     +                DFILE,
     +                ABORT)
         IF (ABORT) RETURN
         WRITE (NOUT,300)
         RESETX = .TRUE.
         CALL YESNO2 (ICOLOR, IX, IY,
     +  'Re-set X-range for each new data set (usually yes)',
     +   RESETX)
         RESETY = .TRUE.
         CALL YESNO2 (ICOLOR, IX, IY,
     +  'Re-set Y-test level for each new data set (usually yes)',
     +   RESETY)
         XSTART = XMIN
         XSTOP = XMAX
         X1 = XMIN
         X2 = XMAX
         YCRIT = YMIN
         RESET = .TRUE.
         FIRST = .FALSE.
      ELSE
         RESET = RESETX
      ENDIF
      IF (E_NUMBERS) THEN
         IF (NOFILE) THEN
            WRITE (NOUT,400) TITLE, XMIN, XMAX, YMIN, YMAX
         ELSE
            TFILE = TRIM80(FNAME)
            WRITE (NOUT,500) TFILE, TITLE, XMIN, XMAX, YMIN, YMAX
         ENDIF
      ELSE
         D13(1) = SHOWRJ(XMIN)
         D13(2) = SHOWRJ(XMAX)
         D13(3) = SHOWRJ(YMIN)
         D13(4) = SHOWRJ(YMAX) 
         IF (NOFILE) THEN
            WRITE (NOUT,450) TITLE, D13(1), D13(2), D13(3), D13(4)
         ELSE
            TFILE = TRIM80(FNAME)
            WRITE (NOUT,550) TFILE, TITLE, D13(1), D13(2), D13(3),
     +                       D13(4)
         ENDIF
      ENDIF  
      IF (RESETX) THEN
         XSTART = XMIN
         XSTOP = XMAX
         X1 = XMIN
         X2 = XMAX
      ENDIF
      IF (RESETY) YCRIT = YMIN
C
C Format statements
C        
  100 FORMAT ('X not increasing at row',I5)
  200 FORMAT ('Y < 0 at row',I5)
  300 FORMAT (/1X,'PACKAGE : SIMFIT'/1X,'PROGRAM : AVERAGE'
     +/1X,'ACTION  : Calculate average y(x) and fraction above/below'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U.K.')
  400 FORMAT (/1X,'Data title'
     +/1X,A
     +/4X,'     X-min         X-max         Y-min         Y-max'
     +/1P,4(1X,E13.5)
     +/5X,'Begin',6X,'End',4X,
     +'  Above (as %)    Below  (as %)   Y-test    Y-area    Y-mean')
  450 FORMAT (/1X,'Data title'
     +/1X,A
     +/4X,'     X-min         X-max         Y-min         Y-max'
     +/4(1X,A13)
     +/5X,'Begin',6X,'End',4X,
     +'  Above (as %)    Below  (as %)   Y-test    Y-area    Y-mean')     
  500 FORMAT (/1X,'Filename'
     +/1X,A
     +/1X,'Data title'
     +/1X,A
     +/4X,'     X-min         X-max         Y-min         Y-max'
     +/1P,4(1X,E13.5)
     +/5X,'Begin',7X,'End',3X,
     +'  Above (as %)    Below (as %)   Y-test    Y-area    Y-mean')
  550 FORMAT (/1X,'Filename'
     +/1X,A
     +/1X,'Data title'
     +/1X,A
     +/4X,'     X-min         X-max         Y-min         Y-max'
     +/4(1X,A13)
     +/5X,'Begin',7X,'End',3X,
     +'  Above (as %)    Below (as %)   Y-test    Y-area    Y-mean')     
      END
C
C
      SUBROUTINE DETAIL (ISEND, N, 
     +                   AREA, XABOVE, XBELOW, XMAX,
     +                   XMIN, XSTART, XSTOP, XTOTAL, X1, X2, YCRIT,
     +                   YMAX, YMEAN, YMIN)
C
C Details and next course of action
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (INOUT) :: ISEND, N
      DOUBLE PRECISION, INTENT (IN)    :: AREA, XABOVE, XBELOW, XMAX,
     +                                    XMIN, XSTART, XSTOP 
      DOUBLE PRECISION, INTENT (IN)    :: YMAX, YMEAN, YMIN
      DOUBLE PRECISION, INTENT (INOUT) :: XTOTAL, X1, X2, YCRIT
C
C Locals
C      
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 1, NUMOPT = 7,
     +           NSTART = 11, NTEXT = 17)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      DOUBLE PRECISION X1TEMP, X2TEMP
      DOUBLE PRECISION EPSI, ONE, F100
      PARAMETER (EPSI = 1.0D-200, ONE = 1.0D+00, F100 = 100.0D+00)
      CHARACTER (LEN = 9 ) D9(13), FORM09
      CHARACTER (LEN = 10) WORD10(2), FORM10 
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER  CHAR4(2)*6
      CHARACTER  BLANKS*6, ARROW*6
      PARAMETER (BLANKS = '      ', ARROW = ' *****')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   E_FORMATS, FORM09, FORM10
      EXTERNAL   PUTADV, GETDM1, GETRG2, LBOX01
      INTRINSIC  ABS, TRIM
      DATA NUMBLD / NTEXT*0 /
      DATA NUMPOS / NUMOPT*1 /
      IF (N.LT.2) THEN
        N = 1
        XTOTAL = - ONE
        ISEND = 1
        RETURN
      ENDIF
      E_NUMBERS = E_FORMATS()
      IF (ABS(XSTART - XMIN).GT.EPSI .OR. ABS(X1 - XMIN).GT.EPSI) THEN
         CHAR4(1) = ARROW
      ELSE
         CHAR4(1) = BLANKS
      ENDIF
      IF (ABS(XSTOP - XMAX).GT.EPSI .OR. ABS(X2 - XMAX).GT.EPSI) THEN
         CHAR4(2) = ARROW
      ELSE
         CHAR4(2) = BLANKS
      ENDIF
      IF (XTOTAL.GE.EPSI) THEN
         IF (E_NUMBERS) THEN
            WRITE (TEXT,100) XSTART, XMIN, X1, CHAR4(1),
     +                       XSTOP, XMAX, X2, CHAR4(2),
     +                       YCRIT, YMIN, YMAX,
     +                       XABOVE,
     +                       F100*XABOVE/XTOTAL, XBELOW,
     +                       F100*XBELOW/XTOTAL,
     +                       AREA, YMEAN
         ELSE
            D9(1) = FORM09(XSTART)
            D9(2) = FORM09(XMIN)
            D9(3) = FORM09(X1)
            D9(4) = FORM09(XSTOP)
            D9(5) = FORM09(XMAX)
            D9(6) = FORM09(X2)
            D9(7) = FORM09(YCRIT)
            D9(8) = FORM09(YMIN)
            D9(9) = FORM09(YMAX)
            D9(10) = FORM09(XABOVE)
            D9(11) = FORM09(XBELOW)
            D9(12) = FORM09(AREA)
            D9(13) = FORM09(YMEAN)
            WRITE (TEXT,150) D9(1), D9(2), D9(3), CHAR4(1),
     +                       D9(4), D9(5), D9(6), CHAR4(2),
     +                       D9(7), D9(8), D9(9),
     +                       D9(10),
     +                       F100*XABOVE/XTOTAL, D9(11),
     +                       F100*XBELOW/XTOTAL,
     +                       D9(12), D9(13)
         ENDIF  
      ELSE
         IF (E_NUMBERS) THEN
            WRITE (TEXT,200) XSTART, XMIN, X1, CHAR4(1),
     +                       XSTOP, XMAX, X2, CHAR4(2),
     +                       YCRIT, YMIN, YMAX
         ELSE
            D9(1) = FORM09(XSTART)
            D9(2) = FORM09(XMIN)
            D9(3) = FORM09(X1)
            D9(4) = FORM09(XSTOP)
            D9(5) = FORM09(XMAX)
            D9(6) = FORM09(X2)
            D9(7) = FORM09(YCRIT)
            D9(8) = FORM09(YMIN)
            D9(9) = FORM09(YMAX) 
            WRITE (TEXT,250) D9(1), D9(2), D9(3), CHAR4(1),
     +                       D9(4), D9(5), D9(6), CHAR4(2),
     +                       D9(7), D9(8), D9(10)
         ENDIF  
      ENDIF
      ISEND = 5
      CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, ISEND, NUMOPT,
     +             NUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      IF (ISEND.EQ.1) THEN
         RETURN
      ELSEIF (ISEND.EQ.2) THEN
         IF (XTOTAL.LE.EPSI) THEN
            CALL PUTADV ('Plot not possible now ... Try again')
            ISEND = 4
         ENDIF
      ELSEIF (ISEND.EQ.3) THEN
         IF (YCRIT.LT.YMIN) THEN
            YCRIT = YMIN
         ELSEIF (YCRIT.GT.YMAX) THEN
            YCRIT = YMAX
         ENDIF   
         IF (E_NUMBERS) THEN   
            WRITE (LINE,300) YCRIT
         ELSE
            WORD10(1) = FORM10(YCRIT)
            WRITE (LINE,350) TRIM(WORD10(1))
         ENDIF      
         CALL GETDM1 (YMIN, YCRIT, YMAX,
     +                LINE)
      ELSEIF (ISEND.EQ.4) THEN
         ISEND = 3
         IF (E_NUMBERS) THEN
            WRITE (LINE,400) X1, X2
         ELSE
            WORD10(1) = FORM10(X1)
            WORD10(2) = FORM10(X2)
            WRITE (LINE, 450) TRIM(WORD10(1)), TRIM(WORD10(2))
         ENDIF  
         X1TEMP = X1
         X2TEMP = X2
         CALL GETRG2 (X1TEMP, X2TEMP,
     +                LINE)
         IF (X1TEMP.LT.XMIN .OR. X2TEMP.GT.XMAX) THEN
            IF (E_NUMBERS) THEN
               WRITE (LINE,500) XMIN, XMAX
            ELSE
               WORD10(1) = FORM10(XMIN)
               WORD10(2) = FORM10(XMAX) 
               WRITE (LINE,550) TRIM(WORD10(1)), TRIM(WORD10(2)) 
            ENDIF  
            CALL PUTADV (LINE)
         ELSE   
            X1 = X1TEMP
            X2 = X2TEMP
         ENDIF   
      ELSE
         ISEND = ISEND - 1
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     + 'Options for program Average'
     +/ 
     +/'Begin =',1P,E11.3,' (  Xmin =',E11.3,'   x1 =',E11.3,')',A
     +/'  End ='   ,E11.3,' (  Xmax =',E11.3,' 
     `  x2 =',E11.3,')',A
     +/'Ytest ='   ,E11.3,' (  Ymin =',E11.3,' Ymax =',E11.3,')'
     +/'Above ='   ,E11.3,' [As a % =',0P,F8.3,'%]'
     +/'Below =',1P,E11.3,' [As a % =',0P,F8.3,'%]'
     +/'Yarea =',1P,E11.3,
     +/'Ymean ='   ,E11.3
     +/
     +/'New data'
     +/'Plot'
     +/'Change Ytest (critical y_threshold)'
     +/'Change Begin, End (critical x-limits)'
     +/'Help'
     +/'View calculated values (archived in your results file)'
     +/'Quit ... Exit program AVERAGE')
  150 FORMAT (
     + 'Options for program Average'
     +/ 
     +/'Begin =',1X,A9,'`(  Xmin =',1X,A9,'   x1 =',1X,A9,')',A
     +/'  End =',1X,A9,'`(  Xmax =',1X,A9,'   x2 =',1X,A9,')',A
     +/'Ytest =',1X,A9,'`(  Ymin =',1X,A9,' Ymax =',1X,A9,')'
     +/'Above =',1X,A9,'`[As a % =',F8.3,'%]'
     +/'Below =',1X,A9,'`[As a % =',F8.3,'%]'
     +/'Yarea =',1X,A9,
     +/'Ymean =',1X,A9
     +/
     +/'New data'
     +/'Plot'
     +/'Change Ytest (critical y_threshold)'
     +/'Change Begin, End (critical x-limits)'
     +/'Help'
     +/'View calculated values (archived in your results file)'
     +/'Quit ... Exit program AVERAGE') 
  200 FORMAT (
     + 'Options for program Average'
     +/
     +/'Begin =',1P,E11.3,'`(  Xmin =',E11.3,'   x1 =',E11.3,')',A
     +/'  End ='   ,E11.3,'`(  Xmax =',E11.3,'   x2 =',E11.3,')',A
     +/'Ytest ='   ,E11.3,'`(  Ymin =',E11.3,' Ymax =',E11.3,')'     
     +/' Above = Not defined'
     +/' Below = Not defined'
     +/' Yarea = Not defined'
     +/' Ymean = Not defined'
     +/
     +/'New data'
     +/'Plot'
     +/'Change Ytest (critical threshold)'
     +/'Change Begin, End (critical limits)'
     +/'Help'
     +/'View calculated values (archived in your results file)'
     +/'Quit ... Exit program AVERAGE')
  250 FORMAT (
     + 'Options for program Average'
     +/
     +/'Begin =',1X,A9,' (  Xmin =',1X,A9,'   x1 =',1X,A9,')',A
     +/'  End =',1X,A9,' (  Xmax =',1X,A9,'   x2 =',1X,A9,')',A
     +/'Ytest =',1X,A9,' (  Ymin =',1X,A9,' Ymax =',1X,A9,')'     
     +/' Above = Not defined'
     +/' Below = Not defined'
     +/' Yarea = Not defined'
     +/' Ymean = Not defined'
     +/
     +/'New data'
     +/'Plot'
     +/'Change Ytest (critical threshold)'
     +/'Change Begin, End (critical limits)'
     +/'Help'
     +/'View calculated values (archived in your results file)'
     +/'Quit ... Exit program AVERAGE')     
  300 FORMAT (
     +'New value for Ytest (current value =',1P,E11.3,')')
  350 FORMAT (
     +'New value for Ytest (current value = ',1X,A,')')     
  400 FORMAT (
     +'New values for x1, x2 (current values:',1P,E11.3,',',E11.3,')')
  450 FORMAT (
     +'New values for x1, x2 (current values:',1X,A,',',1X,A,')')     
  500 FORMAT (
     +'Must have',1X,1P,E11.3,1X,'=< X1 =< X2 =<',1X,1P,E11.3)   
  550 FORMAT (
     +'Must have',1X,A,1X,'=< X1 =< X2 =<',1X,A)        
      END
C
C---------------------------------------------------------------------------
C
      SUBROUTINE WRKOUT (N, NOUT,
     +                   AREA, X, XABOVE, XBELOW, XSTART,
     +                   XSTOP, XTOTAL, Y, YCRIT, YMEAN)
C
C Work out results ... Set XTOTAL = - 1.0 if calculation fails
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: N, NOUT
      DOUBLE PRECISION, INTENT (IN)    :: X(N), Y(N), XSTART, XSTOP
      DOUBLE PRECISION, INTENT (OUT)   :: AREA, XABOVE, XBELOW, XTOTAL
      DOUBLE PRECISION, INTENT (IN)    :: YCRIT
      DOUBLE PRECISION, INTENT (INOUT) :: YMEAN
C
C Locals
C      
      INTEGER    I, IP1
      DOUBLE PRECISION CONST, SLOPE, X1, X2, XCRIT, Y1, Y2
      DOUBLE PRECISION EPSI, HALF, ZERO, ONE, F100
      PARAMETER (EPSI = 1.0D-200, HALF = 0.5D+00, ZERO = 0.0D+00,
     +           ONE = 1.0D+00, F100 = 100.0D+00)
      CHARACTER (LEN = 9) D09(7), SHOW09
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    DOSUMS
      EXTERNAL   E_FORMATS, SHOW09 
      EXTERNAL   PUTADV
      IF (N.LT.2) THEN
         XTOTAL = - ONE
         CALL PUTADV ('Must have at least two points')
         RETURN
      ENDIF
      E_NUMBERS = E_FORMATS() 
      AREA = ZERO
      XABOVE = ZERO
      XBELOW = ZERO
      XTOTAL = ZERO
      DO I = 1, N - 1
         IP1 = I + 1
         X1 = X(I)
         X2 = X(IP1)
         Y1 = Y(I)
         Y2 = Y(IP1)
         SLOPE = (Y2 - Y1)/(X2 - X1)
         CONST = HALF*(Y1 - SLOPE*X1 + Y2 - SLOPE*X2)
         DOSUMS = .TRUE.
         IF (X(I).GE.XSTOP .OR. X(IP1).LE.XSTART) THEN
            DOSUMS = .FALSE.
         ELSEIF (X(I).GE.XSTART) THEN
            IF (X(IP1).GE.XSTOP) THEN
               X2 = XSTOP
               Y2 = SLOPE*X2 + CONST
            ENDIF
         ELSE
            X1 = XSTART
            Y1 = SLOPE*X1 + CONST
            IF (X(IP1).GE.XSTOP) THEN
               X2 = XSTOP
               Y2 = SLOPE*X2 + CONST
            ENDIF
         ENDIF
         IF (DOSUMS) THEN
            AREA = AREA + HALF*(X2 - X1)*(Y1 + Y2)
            XTOTAL = XTOTAL + X2 - X1
            IF (Y1.GE.YCRIT .AND. Y2.GE.YCRIT) THEN
               XABOVE = XABOVE + X2 - X1
            ELSEIF (Y1.LE.YCRIT .AND. Y2.LE.YCRIT) THEN
               XBELOW = XBELOW + X2 - X1
            ELSE
               XCRIT = (YCRIT - CONST)/SLOPE
               IF (Y1.LE.YCRIT .AND. Y2.GE.YCRIT) THEN
                  XBELOW = XBELOW + XCRIT - X1
                  XABOVE = XABOVE + X2 - XCRIT
               ELSE
                  XABOVE = XABOVE + XCRIT - X1
                  XBELOW = XBELOW + X2 - XCRIT
               ENDIF
            ENDIF
         ENDIF
      ENDDO
      IF (XTOTAL.LE.EPSI) THEN
         XTOTAL = - ONE
      ELSE
         YMEAN = AREA/XTOTAL
         IF (E_NUMBERS) THEN
            WRITE (NOUT,100) XSTART, XSTOP, XABOVE, F100*XABOVE/XTOTAL,
     +                       XBELOW, F100*XBELOW/XTOTAL, YCRIT, AREA,
     +                       YMEAN
         ELSE
            D09(1) = SHOW09(XSTART)
            D09(2) = SHOW09(XSTOP)
            D09(3) = SHOW09(XABOVE)
            D09(4) = SHOW09(XBELOW)
            D09(5) = SHOW09(YCRIT)
            D09(6) = SHOW09(AREA)
            D09(7) = SHOW09(YMEAN)
            WRITE (NOUT,150) D09(1), D09(2), D09(3), F100*XABOVE/XTOTAL,
     +                       D09(4), F100*XBELOW/XTOTAL, D09(5), D09(6),
     +                       D09(7)
         ENDIF  
      ENDIF
C
C Format statement
C      
  100 FORMAT (1P,3E10.2,0P,F6.1,1P,E10.2,0P,F6.1,1P,3E10.2)
  150 FORMAT (3(1X,A9),F6.1,1X,A9,F6.1,3(1X,A9))
      END
C
C
