C
C Extra code for program BINOMIAL
C
C BINOMIA1.FOR: CDFVAL, CONLIM, INVERT, NCXVAL, PARAMS, PDFVAL, DNCX, POISSN
C =============
C
C
      SUBROUTINE CDFVAL (IDBN, N, NOUT,
     +                   P, R)
C
C ACTION : Evaluate CDF
C AUTHOR : W.G.Bardsley, University of manchester, U.K.
C          05/04/2000 revised for Poisson distribution
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: IDBN, N, NOUT
      DOUBLE PRECISION, INTENT (IN) :: P, R
C
C Locals
C      
      INTEGER    KMAX, KMIN, K0, K1, K2
      PARAMETER (KMAX = 20, KMIN = 0, K0 = 0, K1 = 1, K2 = 2)
      INTEGER    I, KX, NXVALS
      INTEGER    ICOLOR, NTEMP(3)
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION ALPHA, BETA, CDF_BINOMIAL, CDF_POISSON, 
     +                 XTEMP(3)
      CHARACTER  LINE*100
      EXTERNAL   PUTFAT, GETJM1, TABLE4
      EXTERNAL   PARAMS, CDF_BINOMIAL, CDF_POISSON
      INTRINSIC  MAX
      SAVE       NXVALS
      DATA       NXVALS / 1 /
      IF (IDBN.EQ.K1) THEN
         IF (N.LT.K1 .OR. P.LE.ZERO .OR. P.GE.ONE) THEN
            CALL PUTFAT ('First use option 1 to input N > 0, 0 < p < 1')
            RETURN
         ENDIF
         CALL GETJM1 (KMIN, NXVALS, KMAX,
     +               'Number of binomial cdf(x) values required')
      ELSEIF (IDBN.EQ.K2) THEN
         IF (R.LE.ZERO) THEN
            CALL PUTFAT ('First use option 1 to input lambda > 0')
            RETURN
         ENDIF
         CALL GETJM1 (KMIN, NXVALS, KMAX,
     +               'Number of Poisson cdf(x) values required')
      ENDIF
      IF (NXVALS.LT.K1) RETURN
      CALL PARAMS (IDBN, N, NOUT, 
     +             P, R)
      ICOLOR = 9
      CALL TABLE4 (ICOLOR, NTEMP, XTEMP, 'OPEN')
      WRITE (LINE,50)
      WRITE (NOUT,50)
      CALL TABLE4 (ICOLOR, NTEMP, XTEMP, LINE)
      DO I = K1, NXVALS
         IF (IDBN.EQ.K1) THEN
            NTEMP(1) = K0
            NTEMP(3) = N
            CALL TABLE4 (ICOLOR, NTEMP, XTEMP, 'GETIM1')
            CALL TABLE4 (ICOLOR, NTEMP, XTEMP,
     +     'x-value required for binomial cdf(x) (0 =< x =< N)')
            KX = NTEMP(2)
            BETA = CDF_BINOMIAL (KX, N, NOUT,
     +                           P)            
         ELSEIF (IDBN.EQ.K2) THEN
            CALL TABLE4 (ICOLOR, NTEMP, XTEMP, 'GETI01')
            CALL TABLE4 (ICOLOR, NTEMP, XTEMP,
     +     'x-value required for Poisson cdf(x) (x >= 0)')
            KX = MAX(K0,NTEMP(1))
            BETA = CDF_POISSON (KX, NOUT,
     +                          R)           
         ENDIF
         ALPHA = ONE - BETA
         WRITE (LINE,100) KX, BETA, ALPHA
         WRITE (NOUT,100) KX, BETA, ALPHA
         CALL TABLE4 (ICOLOR, NTEMP, XTEMP, LINE)
      ENDDO
      CALL TABLE4 (ICOLOR, NTEMP, XTEMP, 'CLOSE')
C
C Format statements
C     
   50 FORMAT ('        x      cdf(x)    1-cdf(x)') 
  100 FORMAT (I9,2(F12.6))   
      END
C
C----------------------------------------------------------------------------
C
      SUBROUTINE CONLIM (ILIM, NOUT)
C
C ACTION : 90, 95, 99% con. lim. for binomial P using the F and Q methods
C          User inputs N and X interactively. Output written to NOUT
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 19/11/92
C          10/06/1996 Added special cases x = 0 and x = N
C          01/09/1998 added ILIM
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER, INTENT (IN) :: ILIM, NOUT
C
C Locals
C      
      INTEGER    I, KX, N, NUMVAL
      INTEGER    KMAX, KMIN
      PARAMETER (KMAX = 10, KMIN = 0)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMCOL, NUMROW, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 0,
     +           NUMCOL = 2, NUMROW = 0, NTEXT = 7)
      INTEGER    JCOLOR, NTEMP(3)
      INTEGER    N0, N2, NHUGE
      PARAMETER (N0 = 0, N2 = 2, NHUGE = 100000000)
      DOUBLE PRECISION ONE, TWO, FOUR, ZERO, Z90SQD, Z95SQD, Z99SQD,
     +                 Z95, Z975, Z995
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, FOUR = 4.0D+00,
     +           ZERO = 0.0D+00, Z90SQD = 1.282**2, Z95SQD = 1.645**2,
     +           Z99SQD = 2.326**2, Z95 = 1.645, Z975 = 1.96,
     +           Z995 = 3.291)
      DOUBLE PRECISION A, B, C, D, PHAT, PHIGH, PLOW, TEMP
      DOUBLE PRECISION RN, X, XTEMP(3), ZVAL, ZSQD
      CHARACTER  METHOD*3, LINEN*9, LINEX*9
      CHARACTER  LINE*100, TEXT(30)*100
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    QUAD, YES
      EXTERNAL   PHAT95
      EXTERNAL   YESNO1, YESNO2, TABLE4, GETJM1, TRIML1, PUTFAT
      INTRINSIC  SQRT, DBLE, MAX
      SAVE       NUMVAL
      DATA       NUMVAL / 1 /
C
C Use the quadratic method also ?
C This was turned off (09/04/2000) since ILIM and NOUT are always > 0
C but the code is preserved for possible re-use
C
      IF (ILIM.LT.N0 .AND. NOUT.LT.N0) THEN
         WRITE (TEXT,100)
         WRITE (LINE,200)
         YES = .FALSE.
         CALL YESNO1 (ICOLOR, IXL, IYL, LSHADE, NUMCOL, NUMROW, NTEXT,
     +                LINE, TEXT, 
     +                BORDER, FLASH, HIGH, YES)
      ELSE
         YES = .FALSE.
      ENDIF
      IF (YES) THEN
         QUAD = .TRUE.
         IF (ILIM.EQ.90) THEN
            ZSQD = Z90SQD
            ZVAL = Z95
         ELSEIF (ILIM.EQ.95) THEN
            ZSQD = Z95SQD
            ZVAL = Z975
         ELSEIF (ILIM.EQ.99) THEN
            ZSQD = Z99SQD
            ZVAL = Z995
         ELSE
            CALL PUTFAT ('ILIM not 90, 95 or 99 in CONLIM')
            RETURN
         ENDIF
      ELSE
         QUAD = .FALSE.
      ENDIF
C
C Outer Main Loop
C
      YES = .TRUE.
      DO WHILE (YES)
C
C How many pairs of N and X values ?
C
         IF (QUAD) THEN
            CALL GETJM1 (KMIN, NUMVAL, KMAX,
     +      'Number of pairs of (N, x) values for analysis')
         ELSE
            CALL GETJM1 (KMIN, NUMVAL, 2*KMAX,
     +      'Number of pairs of (N, x) values for analysis')
         ENDIF
         IF (NUMVAL.LT.1) RETURN
C
C Inner Loop
C
         WRITE (NOUT,300)
         JCOLOR = 9
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'OPEN')
         DO I = 1, NUMVAL
            CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'GETIL1')
            NTEMP(1) = N2
            NTEMP(3) = NHUGE
            CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'N value (N > 1)')
            N = NTEMP(2)
            CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'GETIL1')
            NTEMP(1) = N0
            NTEMP(3) = N
            CALL TABLE4 (ICOLOR, NTEMP, XTEMP,
     +                  'Corresponding x value (0 < x < N)')
            KX = NTEMP(2)
            CALL PHAT95 (ILIM, KX, N, NOUT, PLOW, PHAT, PHIGH)
            IF (QUAD) THEN
               METHOD = '(F)'
            ELSE
               METHOD = ' '
            ENDIF
            WRITE (LINE,400) N
            CALL TRIML1 (LINE)
            LINEN = LINE(1:9)
            WRITE (LINE,400) KX
            CALL TRIML1 (LINE)
            LINEX = LINE(1:9)
            WRITE (LINE,500) METHOD, LINEN, LINEX, ILIM, PLOW, PHAT,
     +                       ILIM, PHIGH
            WRITE (NOUT,500) METHOD, LINEN, LINEX, ILIM, PLOW, PHAT,
     +                       ILIM, PHIGH
            CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
C
C Use the quadratic method if requested
C
            IF (QUAD) THEN
               RN = DBLE(N)
               IF (KX.EQ.N0) THEN
                  PLOW = ZERO
                  PHIGH = ZSQD/(RN + ZSQD)
               ELSEIF (KX.EQ.N) THEN
                  PLOW = RN/(RN + ZSQD)
                  PHIGH = ONE
               ELSE
                  X = DBLE(KX)
                  A = RN**2 + ZVAL**2*RN
                  B = - RN*(TWO*X + ZVAL**2)
                  C = X**2
                  TEMP = MAX(ZERO, B**2 - FOUR*A*C)
                  D = SQRT(TEMP)
                  A = TWO*A
                  PLOW = (- B - D)/A
                  PHIGH = (- B + D)/A
               ENDIF
               IF (PLOW.LT.ZERO) PLOW = ZERO
               IF (PHIGH.GT.ONE) PHIGH = ONE
               METHOD = '(Q)'
               WRITE (LINE,600) METHOD, PLOW, PHIGH
               WRITE (NOUT,600) METHOD, PLOW, PHIGH
               CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
            ENDIF
         ENDDO
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'CLOSE')
         WRITE (LINE,700)
         YES = .TRUE.
         CALL YESNO2 (ICOLOR, IXL, IYL,
     +                LINE,
     +                YES)
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'You input N and x then the program estimates p'
     +/'with exact non-central confidence limits, as'
     +/'long as N > 1, 0 =< x =< N.'
     +/'A beta distribution method is used except for'
     +/'very large N, when either the chi-square or'
     +/'quadratic method is used as appropriate.'/)
  200 FORMAT ('Also use the quadratic method ?')
  300 FORMAT (/1X,
     +'Binomial p and 95% limits given x successes in N trials.'/)
  400 FORMAT (I9)
  500 FORMAT (1X,A3,1X,'N = ',A9,' X = ',A9,
     +':L ',I2,'% =',F8.5,', p =',F8.5,', U ',I2,'% =',F8.5)
  600 FORMAT (1X,A3,36X,'(',F7.5,')',20X,'(',F7.5,')')
  700 FORMAT ('Input another set of values ?')
      END
C
C----------------------------------------------------------------------------
C
      SUBROUTINE INVERT (IDBN, N, NOUT,
     +                   P, R)
C
C ACTION : Invert binomial distribution
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          05/04/2000 revised for Poisson distribution
C          02/10/2012 now calls CDF_INVERT 
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: IDBN, N, NOUT
      DOUBLE PRECISION, INTENT (IN) :: P, R
C
C Locals
C      
      INTEGER    I, ISEND, I1, I2, NPVALS
      INTEGER    KMAX, KMIN, K1, K2
      PARAMETER (KMAX = 10, KMIN = 0, K1 = 1, K2 = 2)
      INTEGER    ICOLOR, NTEMP(3)
      DOUBLE PRECISION ZERO, ONE, F100
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, F100 = 100.0D+00)
      DOUBLE PRECISION PCMAX, PCMIN
      PARAMETER (PCMAX = 99.9D+00, PCMIN = 0.1D+00)
      DOUBLE PRECISION XTEMP(3)
      DOUBLE PRECISION ALPHA, ALPHA1, ALPHA2, BETA, BETA1, BETA2
      DOUBLE PRECISION CDF_BINOMIAL, CDF_POISSON, PCENT
      CHARACTER (LEN = 100) TEXT(2)
      CHARACTER (LEN = 8  ) WORD8
      EXTERNAL   PUTFAT, GETJM1, TABLE4
      EXTERNAL   PARAMS, CDF_BINOMIAL, CDF_POISSON, CDF_INVERT
      SAVE       NPVALS
      DATA       NPVALS / 1 /
      
      IF (IDBN.EQ.K1) THEN
         IF (N.LT.K1 .OR. P.LE.ZERO .OR. P.GE.ONE) THEN
            CALL PUTFAT ('First use option 1 to input N >0, 0 < p < 1')
            RETURN
         ENDIF
         CALL GETJM1 (KMIN, NPVALS, KMAX,
     +               'Number of binomial percentage points required')
      ELSEIF (IDBN.EQ.K2) THEN
         IF (R.LE.ZERO) THEN
            CALL PUTFAT ('First use option 1 to input lambda > 0')
            RETURN
         ENDIF
         CALL GETJM1 (KMIN, NPVALS, KMAX,
     +               'Number of Poisson percentage points required')
      ENDIF
      IF (NPVALS.LT.K1) RETURN
        
      CALL PARAMS (IDBN, N, NOUT, P, R)

C
C Set up a reference vector for the current distribution
C        
      ISEND = IDBN
      CALL CDF_INVERT (ISEND, I1, I2, N,
     +                 P, ALPHA, R) 
C
C Loop over the chosen values
C     
      ICOLOR = 9
      CALL TABLE4 (ICOLOR, NTEMP, XTEMP, 'OPEN')
      XTEMP(1) = PCMIN
      XTEMP(3) = PCMAX
      DO I = K1, NPVALS
         CALL TABLE4 (ICOLOR, NTEMP, XTEMP, 'GETRL1')
         IF (IDBN.EQ.K1) THEN
            CALL TABLE4 (ICOLOR, NTEMP, XTEMP,
     +     'Binomial percentage point (i.e. 100*alpha%) required')
         ELSEIF (IDBN.EQ.K2) THEN
            CALL TABLE4 (ICOLOR, NTEMP, XTEMP,
     +     'Poisson percentage point (i.e. 100*alpha*) required')
         ENDIF
         PCENT = XTEMP(2)
         WRITE (WORD8,50) PCENT
         ALPHA = PCENT/F100
         BETA = ONE - ALPHA
C
C ------------------------------------
C Start of code to calculate I1 and I2
C ------------------------------------
C         
            ISEND = 3
            CALL CDF_INVERT (ISEND, I1, I2, N,
     +                       P, BETA, R)  
            IF (IDBN.EQ.K1) THEN
               BETA1 = CDF_BINOMIAL (I1, N, NOUT,
     +                               P)
               BETA2 = CDF_BINOMIAL (I2, N, NOUT,
     +                               P)
            ELSEIF (IDBN.EQ.K2) THEN
               BETA1 = CDF_POISSON (I1, NOUT,
     +                              R)
               BETA2 = CDF_POISSON (I2, NOUT,
     +                              R)               
            ENDIF 
             
            ALPHA1 = ONE - BETA1
            ALPHA2 = ONE - BETA2
            
            IF (I2.LT.10) THEN
               WRITE (TEXT,100) I1, BETA1, I2, BETA2, 
     +                          I1, ALPHA1, I2, ALPHA2, WORD8
               WRITE (NOUT,100) I1, BETA1, I2, BETA2, 
     +                          I1, ALPHA1, I2, ALPHA2, WORD8
            ELSEIF (I2.LT.100) THEN
               WRITE (TEXT,200) I1, BETA1, I2, BETA2, 
     +                          I1, ALPHA1, I2, ALPHA2, WORD8
               WRITE (NOUT,200) I1, BETA1, I2, BETA2, 
     +                          I1, ALPHA1, I2, ALPHA2, WORD8
            ELSEIF (I2.LT.1000) THEN
               WRITE (TEXT,300) I1, BETA1, I2, BETA2, 
     +                          I1, ALPHA1, I2, ALPHA2, WORD8
               WRITE (NOUT,300) I1, BETA1, I2, BETA2, 
     +                          I1, ALPHA1, I2, ALPHA2, WORD8
            ELSEIF (I2.LT.100000) THEN
               WRITE (TEXT,400) I1, BETA1, I2, BETA2, 
     +                          I1, ALPHA1, I2, ALPHA2, WORD8
               WRITE (NOUT,400) I1, BETA1, I2, BETA2, 
     +                          I1, ALPHA1, I2, ALPHA2, WORD8
            ELSE
               WRITE (TEXT,500) I1, BETA1, I2, BETA2, 
     +                          I1, ALPHA1, I2, ALPHA2, WORD8
               WRITE (NOUT,500) I1, BETA1, I2, BETA2, 
     +                          I1, ALPHA1, I2, ALPHA2, WORD8
            ENDIF
C
C ----------------------------------
C End of code to calculate I1 and I2
C ----------------------------------
C         
         CALL TABLE4 (ICOLOR, NTEMP, XTEMP, TEXT(1))
         CALL TABLE4 (ICOLOR, NTEMP, XTEMP, TEXT(2))
      ENDDO
      CALL TABLE4 (ICOLOR, NTEMP, XTEMP, 'CLOSE')
C
C Format statements
C      
   50 FORMAT (' (',F4.1,'%)')  
  100 FORMAT (
     +1X,'P(X =<',I2,') =',F8.5,5X,'P(X =<',I2,') =',F8.5,
     +/1X,'P(X  >',I2,') =',F8.5,' *** P(X  >',I2,') =',F8.5,A)
  200 FORMAT (
     +1X,'P(X =<',I3,') =',F8.5,5X,'P(X =<',I3,') =',F8.5,
     +/1X,'P(X  >',I3,') =',F8.5,' *** P(X  >',I3,') =',F8.5,A)
  300 FORMAT (
     +1X,'P(X =<',I4,') =',F9.6,5X,'P(X =<',I4,') =',F9.6,
     +/1X,'P(X  >',I4,') =',F9.6,' *** P(X  >',I4,') =',F9.6,A)
  400 FORMAT (
     +1X,'P(X =<',I6,') =',F10.7,5X,'P(X =<',I6,') =',F10.7,
     +/1X,'P(X  >',I6,') =',F10.7,' *** P(X  >',I6,') =',F10.7,A)
  500 FORMAT (
     +1X,'P(X =<',I9,') =',F11.8,5X,'P(X =<',I9,') =',F11.8,
     +/1X,'P(X  >',I9,') =',F11.8,' *** P(X  >',I9,') =',F11.8,A)
      END
C
C----------------------------------------------------------------------------
C
      SUBROUTINE NCXVAL (NBIG, NOUT, NVBIG)
C
C ACTION : Calculate NCX(X) given X
C          This is very approximate and should be improved eventually
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER, INTENT (IN) :: NBIG, NOUT, NVBIG
C
C Locals
C      
      INTEGER    NLOSS
      PARAMETER (NLOSS = 30)
      INTEGER    I, K, KX, KSUM, M, NCK, NXVALS
      INTEGER    NMAX, NMIN
      PARAMETER (NMAX = 20, NMIN = 0)
      INTEGER    ICOLOR, NTEMP(3)
      INTEGER    N1, NHUGE
      PARAMETER (N1 = 1, NHUGE = 1000000)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      DOUBLE PRECISION DCK, DNCX, DSUM
      DOUBLE PRECISION RCK, RK, RM, RSUM, X, XTEMP(3)
      CHARACTER  LINE*100
      CHARACTER  LINE10*10, LINE11*11, LINE12*12, FORM12*12,LINE90*90 
      EXTERNAL   DNCX
      EXTERNAL   GETJM1, PUTWAR, PUTCAU, PUTADV, TRIML1, TABLE4, FORM12
      INTRINSIC  NINT, DBLE
      SAVE       M, NXVALS
      DATA       M, NXVALS / 2, 1 /
      CALL GETJM1 (N1, M, NHUGE,
     +            'N required for Binomial coefficient NCX(x) (N > 0)')
      LINE12 = FORM12(M)
      IF (M.GT.NVBIG) THEN
         WRITE (LINE,100) ' large ', LINE12
         WRITE (NOUT,'(A)') ' '
         WRITE (NOUT,100) ' large ', LINE12
         CALL PUTWAR (LINE)
      ELSEIF (M.GT.NBIG) THEN
         WRITE (LINE,100) ' some ', LINE12
         WRITE (NOUT,'(A)') ' '
         WRITE (NOUT,100) ' some ', LINE12
         CALL PUTCAU (LINE)
      ELSEIF (M.GT.NLOSS) THEN
         WRITE (LINE,100) ' small ', LINE12
         WRITE (NOUT,'(A)') ' '
         WRITE (NOUT,100) ' small ', LINE12
         CALL PUTADV (LINE)
      ENDIF
      CALL GETJM1 (NMIN, NXVALS, NMAX,
     +            'The number of NCX(x) values required')
      IF (NXVALS.LT.1) RETURN
      WRITE (LINE,'(I10)') M
      CALL TRIML1 (LINE)
      LINE10 = LINE(1:10)
      WRITE (NOUT,200) LINE10
      WRITE (LINE90,250) LINE10
      ICOLOR = 9
      CALL TABLE4 (ICOLOR, NTEMP, XTEMP, 'OPEN')
      CALL TABLE4 (ICOLOR, NTEMP, XTEMP, LINE90)
      RM = DBLE(M)
      NTEMP(1) = 0
      NTEMP(3) = M
      DO I = 1, NXVALS
         CALL TABLE4 (ICOLOR, NTEMP, XTEMP, 'GETIL1')
         CALL TABLE4 (ICOLOR, NTEMP, XTEMP,
     +               'x-value required for NCX(x) (0 =< x =< N)')
         KX = NTEMP(2)
         X = DBLE(KX)
         LINE = 'Not valid'
         IF (M.LE.NLOSS) THEN
            KSUM = 0
            DO K = 0, KX
               RK = DBLE(K)
               NCK = NINT(DNCX(NOUT, RM, RK))
               KSUM = KSUM + NCK
            ENDDO
            WRITE (LINE,'(I10)') NCK
            CALL TRIML1 (LINE)
            LINE10 = LINE(1:10)
            WRITE (LINE,'(I11)') KSUM
            CALL TRIML1 (LINE)
            LINE11 = LINE(1:11)
            WRITE (LINE,300) KX, LINE10, KX, LINE11
            WRITE (NOUT,300) KX, LINE10, KX, LINE11
         ELSEIF (M.LE.NVBIG) THEN
            DSUM = ZERO
            DO K = 0, KX
               RK = DBLE(K)
               DCK = DNCX(NOUT, RM, RK)
               DSUM = DSUM + DCK
            ENDDO
            RCK = DCK
            RSUM = DSUM
            WRITE (LINE,400) KX, RCK, KX, RSUM
            WRITE (NOUT,400) KX, RCK, KX, RSUM
         ELSE
            RCK = DNCX(NOUT, RM, X)
            IF (RCK.GT.ZERO) THEN
               IF (M.LT.10000) THEN
                  WRITE (LINE,500) KX, RCK
                  WRITE (NOUT,500) KX, RCK
               ELSEIF (M.LT.1000000) THEN
                  WRITE (LINE,600) KX, RCK
                  WRITE (NOUT,600) KX, RCK
               ELSE
                  WRITE (LINE,700) KX, RCK
                  WRITE (NOUT,700) KX, RCK
               ENDIF
            ENDIF
         ENDIF
         CALL TABLE4 (ICOLOR, NTEMP, XTEMP, LINE)
      ENDDO
      CALL TABLE4 (ICOLOR, NTEMP, XTEMP, 'CLOSE')
C
C Format statements
C      
  100 FORMAT (
     + 1X,'Coefficients may have',A,'rounding-off errors for N =',1X,A)
  200 FORMAT (/1X,'In binomial coefficients NCX(x), N = ',A10)
  250 FORMAT (1X,'In binomial coefficients NCX(x), N = ',A10)
  300 FORMAT (
     +1X,'NCX(',I2,') = ',A10,', NCX(0) +...+ NCX(',I2,') = ',A11)
  400 FORMAT (
     +1X,'NCX(',I3,') =',1P,E16.8,
     +', NCX(0) + ... + NCX(',I3,') =',1P,E16.8)
  500 FORMAT (1X,'NCX(',I4,') =',1P,E16.8)
  600 FORMAT (1X,'NCX(',I6,') =',1P,E16.8)
  700 FORMAT (1X,'NCX(',I9,') =',1P,E16.8)
      END
C
C----------------------------------------------------------------------------
C
      SUBROUTINE PARAMS (IDBN, N, NOUT,
     +                   P, R)
C
C ACTION : Output current parameters to file on unit NOUT
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          05/04/2000 added Poisson distribution
C
      IMPLICIT  NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: IDBN, N, NOUT
      DOUBLE PRECISION, INTENT (IN) :: P, R
C
C Locals
C      
      INTEGER    ISEND
      PARAMETER (ISEND = 0)
      CHARACTER (LEN = 12) VALUEN 
      CHARACTER (LEN = 10) FORMGR, WORD10
      CHARACTER (LEN = 1 ) CIPHER
      PARAMETER (CIPHER = 'L')
      EXTERNAL FORMGR, TRIML1, X_DOFDOT  
      IF (IDBN.EQ.1) THEN
         WRITE (WORD10,'(I10)') N
         CALL TRIML1 (WORD10)
         WRITE (VALUEN,'(F12.4)') P
         CALL X_DOFDOT (ISEND,
     +                  CIPHER, VALUEN)         
         WRITE (NOUT,100) TRIM(WORD10), VALUEN
      ELSEIF (IDBN.EQ.2) THEN
         WORD10 = FORMGR(R)
         WRITE (NOUT,200) WORD10
      ENDIF
C
C Format statements
C      
  100 FORMAT (/1X,'Current binomial parameters: N = ',A,', p =',1X,A)
  200 FORMAT (/1X,'Current Poisson parameter: lambda =',1X,A)
      END
C
C----------------------------------------------------------------------------
C
      SUBROUTINE PDFVAL (IDBN, N, NOUT,
     +                   P, R)
C
C ACTION : Calculate PDF(X) given X
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          05/04/2000 revised for Poisson distribution
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: IDBN, N, NOUT
      DOUBLE PRECISION, INTENT (IN) :: P, R
C
C Locals
C      
      INTEGER    I, KX, NXVALS
      INTEGER    NMAX, NMIN, N0, N1, N2
      PARAMETER (NMAX = 20, NMIN = 0, N0 = 0, N1 = 1, N2 = 2)
      INTEGER    ICOLOR, NTEMP(3)
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION XTEMP(3)
      DOUBLE PRECISION PDF_BINOMIAL, PDF_POISSON, VALUE
      CHARACTER  LINE*100
      EXTERNAL   PDF_BINOMIAL, PDF_POISSON, PARAMS
      EXTERNAL   PUTFAT, GETJM1, TABLE4
      INTRINSIC  MAX
      SAVE       NXVALS
      DATA       NXVALS / 1 /
      IF (IDBN.EQ.N1) THEN
         IF (N.LT.N1 .OR. P.LE.ZERO .OR. P.GE.ONE) THEN
            CALL PUTFAT ('First use option 1 to input N > 0, 0 < p < 1')
            RETURN
         ENDIF
         CALL GETJM1 (NMIN, NXVALS, NMAX,
     +  'Number of binomial pmf(x) values required')
      ELSEIF (IDBN.EQ.N2) THEN
         IF (R.LE.ZERO) THEN
            CALL PUTFAT ('First use option 1 to input lambda > 0')
            RETURN
         ENDIF
         CALL GETJM1 (NMIN, NXVALS, NMAX,
     +   'Number of Poisson pmf(x) values required')
      ENDIF
      IF (NXVALS.LT.N1) RETURN
      CALL PARAMS (IDBN, N, NOUT,
     +             P, R)
      ICOLOR = 9
      CALL TABLE4 (ICOLOR, NTEMP, XTEMP, 'OPEN')
      WRITE (LINE,50)
      WRITE (NOUT,50)
      CALL TABLE4 (ICOLOR, NTEMP, XTEMP, LINE)
      DO I = N1, NXVALS
         IF (IDBN.EQ.N1) THEN
            NTEMP(1) = N0
            NTEMP(3) = N
            CALL TABLE4 (ICOLOR, NTEMP, XTEMP, 'GETIM1')
            CALL TABLE4 (ICOLOR, NTEMP, XTEMP,
     +     'x-value required for binomial pmf(x) (0 =< x =< N)')
            KX = NTEMP(2)
            VALUE = PDF_BINOMIAL (KX, N, NOUT,
     +                            P)            
         ELSEIF (IDBN.EQ.N2) THEN
            CALL TABLE4 (ICOLOR, NTEMP, XTEMP, 'GETI01')
            CALL TABLE4 (ICOLOR, NTEMP, XTEMP,
     +     'x-value required for Poisson pmf(x) (x > 0)')
            KX = MAX(N0,NTEMP(1))
            VALUE = PDF_POISSON (KX, NOUT,
     +                           R)             
         ENDIF
          WRITE (LINE,100) KX, VALUE
          WRITE (NOUT,100) KX, VALUE
         CALL TABLE4 (ICOLOR, NTEMP, XTEMP, LINE)
      ENDDO
      CALL TABLE4 (ICOLOR, NTEMP, XTEMP, 'CLOSE')
C
C Format statements
C  
   50 FORMAT ('         x      pmf(x)')              
  100 FORMAT (I10,F12.6) 
      END
C
C----------------------------------------------------------------------------
C
      DOUBLE PRECISION FUNCTION DNCX (NOUT, 
     +                                RN, X)
C
C ACTION: N-choose-X
C         This is very approximate and should be improved eventually
C
      IMPLICIT  NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NOUT
      DOUBLE PRECISION, INTENT (IN) :: RN, X
C
C Locals
C      
      INTEGER   IFAIL
      DOUBLE PRECISION S14ABF$, X02AMF$
      DOUBLE PRECISION ARG, EPOS, FN, FNMX, FX
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      EXTERNAL  X02AMF$, S14ABF$
      EXTERNAL  PUTIFA, PUTFAT
      INTRINSIC LOG, EXP
      EPOS = - LOG(X02AMF$())
      IFAIL = 1
      FN = S14ABF$(RN + ONE, IFAIL)
      IF (IFAIL.NE.0) THEN
         CALL PUTIFA (IFAIL, NOUT, 'S14ABF/DNCX')
         DNCX = ZERO
         RETURN
      ENDIF
      IFAIL = 1
      FX = S14ABF$(X + ONE, IFAIL)
      IF (IFAIL.NE.0) THEN
         CALL PUTIFA (IFAIL, NOUT, 'S14ABF/DNCX')
         DNCX = ZERO
         RETURN
      ENDIF
      IFAIL = 1
      FNMX = S14ABF$(RN - X + ONE, IFAIL)
      IF (IFAIL.NE.0) THEN
         CALL PUTIFA (IFAIL, NOUT, 'S14ABF/DNCX')
         DNCX = ZERO
         RETURN
      ENDIF
      ARG = FN - FX - FNMX
      IF (ARG.GT.EPOS) THEN
         CALL PUTFAT ('Overflow ... Calculation stopped')
         DNCX = ZERO
         RETURN
      ENDIF
      DNCX = EXP(ARG)
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE POISSN (ILIM, NOUT)
C
C ACTION : 90, 95, 99% con. lim. for Poisson
C          User inputs X interactively. Output written to NOUT
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 1/9/98
C          Derived from CONLIM
C          09/04/2000 altered to resemble new version of CLIM95
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER, INTENT (IN) :: ILIM, NOUT
C
C Locals
C      
      INTEGER    I, IFAIL, N, NUMVAL
      INTEGER    KMAX, KMIN, N1
      PARAMETER (KMAX = 20, KMIN = 0, N1 = 1)
      INTEGER    ICOLOR, IXL, IYL
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4)
      INTEGER    JCOLOR, NTEMP(3)
      DOUBLE PRECISION ZERO, F100
      PARAMETER (ZERO = 0.0D+00, F100 = 100.0D+00)
      DOUBLE PRECISION CLEVEL, PHAT, PHIGH, PLOW
      DOUBLE PRECISION XTEMP(3)
      CHARACTER (LEN = 13 ) D13(3), SHOWRJ
      CHARACTER (LEN = 100) LINE
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    YES
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   YESNO2, TABLE4, GETJM1, PUTIFA, PUTFAT
      EXTERNAL   G07ABF$
      INTRINSIC  DBLE, MAX
      SAVE       NUMVAL
      DATA       NUMVAL / 1 /
      IF (ILIM.NE.90 .AND. ILIM.NE.95 .AND. ILIM.NE.99) THEN
         CALL PUTFAT ('ILIM not 90, 95 or 99 in POISSN')
         RETURN
      ELSE
         CLEVEL = DBLE(ILIM)/F100
      ENDIF
      E_NUMBERS = E_FORMATS()
   20 CONTINUE
C
C How many X values ?
C
      CALL GETJM1 (KMIN, NUMVAL, KMAX,
     +            'Number of Poisson lambda estimates for analysis')
      IF (NUMVAL.LT.1) RETURN
C
C Main loop
C
      WRITE (NOUT,100) ILIM
      JCOLOR = 9
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'OPEN')
      WRITE (LINE,150) ILIM, ILIM
      WRITE (NOUT,150) ILIM, ILIM
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
      DO I = 1, NUMVAL
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'GETI01')
         CALL TABLE4 (ICOLOR, NTEMP, XTEMP,
     +'The sample size used to calculate the sample mean (i.e. N > 0)')
         N = MAX(N1,NTEMP(1))
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'GETR01')
         CALL TABLE4 (ICOLOR, NTEMP, XTEMP,
     +'The Poisson parameter (i.e. the sample mean, lambda > 0)')
         PHAT = MAX(ZERO,XTEMP(1))
         IFAIL = 0
         CALL G07ABF$(N, PHAT, CLEVEL, PLOW, PHIGH, IFAIL)
         CALL PUTIFA (IFAIL, NOUT, 'G01ABF/POISSN')
         IF (E_NUMBERS) THEN
            WRITE (LINE,200) N, PLOW, PHAT, PHIGH
            WRITE (NOUT,200) N, PLOW, PHAT, PHIGH
         ELSE
            D13(1) = SHOWRJ(PLOW)
            D13(2) = SHOWRJ(PHAT)
            D13(3) = SHOWRJ(PHIGH)
            WRITE (LINE,250) N, D13(1), D13(2), D13(3)
            WRITE (NOUT,250) N, D13(1), D13(2), D13(3) 
         ENDIF  
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
      ENDDO
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'CLOSE')
      WRITE (LINE,300)
      YES = .FALSE.
      CALL YESNO2 (ICOLOR, IXL, IYL, 
     +             LINE,
     +             YES)
      IF (YES) GOTO 20
C
C Format statements
C      
        
  100 FORMAT (/1X,'Poisson lambda and ',I2,
     +'% limits given x = mean and N = sample size'/)
  150 FORMAT (7X,'N',8X,'Lower',I2,'%',8X,'Estimate',8X,'Upper',I2,'%')    
c  200 FORMAT ('N = ',A9,' :L ',I2,'% =',1P,E12.4,
c     +' :X =',E12.4,' :U ',I2,'% =',E12.4)
  200 FORMAT (I8,1P,3(3X,E13.5)) 
  250 FORMAT (I8,3(A16))    
  300 FORMAT ('Input another set of values ?')
      END
C
C