C
C
C BINOMIAL.FOR: MAIN, ADVISE, ARGUIN, DETAIL
C ============
C
C Requires extra source code BINOMIA1.FOR
c
C BINOMIA1.FOR: CDFVAL, CONLIM, INVERT, NCXVAL, PARAMS, PDFVAL, DNCX, POISSN
C These must now be included 
C =========================
C
C     INCLUDE 'binomia1.for'
C     INCLUDE 'dllchk.for'
C
C
      PROGRAM MAIN
C
C VERSION : set by SIMVER/DLLCHK
C FORTRAN : 95, Double precision
C NAG     : G01BJF, G01FDF, S14ABF, X02AMF
C INPUT   : N, P, X
C OUTPUT  : PDF, CDF, ALPHA, Inverses for binomial distribution
C           Chi-square test for binomial distribution
C ADVICE  : NMAX = Max. no. points for testing B(N,X)
C           NTOP = Max. no. for graph and max binomial N for testing B(N,X)
C AUTHOR  : W. G. Bardsley, 11/07/90
C           03/07/1992 EOBINS, GKS001, EOIOUT edited
C           19/11/1992 Added CONLIM
C           22/11/1992 Added GETYES, REJECT, NBEEPS
C           03/03/1993 GET???, PUT??? and compressed
C           16/06/1993 RESFIL
C           10/08/1994 DBOS version
C           16/02/1995 Version for Salamanca
C           10/11/1995 Added ANOVAP/PHAT95 and upgraded for nag mark 16
C           22/04/1996 Changed the calculation for -2log(lambda) in ANOVAP
C           10/06/1996 Added special cases x = 0 and x = n
C           25/11/1996 Added TRINOM
C           05/04/1997 Win32 version
C           18/04/1997 Edited COMMON so only used by functions PDF and CDF
C                      and DETAIL so ADVISE can be called for a tutorial
C           05/08/1998 added DLLCHK
C           01/09/1998 added SPOWER and ILIM
C           14/12/1998 replaced TUTORS by TUTOR1
C           12/09/1999 added call to WINDOWS
C           20/12/1999 added call to NONCEN
C           12/02/2000 added call to SIMVER
C           05/04/2000 removed COMMON and added IDBN, R for Poisson, and
C                      provided option for KS 1-sample test
C           20/03/2001 revised
C           04/03/2002 added EXACTP and separated chi-square, KS1, Fisher
C                      exact so requested individually evry time
C           26/04/2002 added FSAV to distinguish results file
C           14/02/2005 increased dimension of A to A(NMAX,4)
C           10/06/2005 redimensioned A(NMAX,3), added NTEMP, ATEMP and new
C                      argument list for call to ANOVAP
C           28/07/2005 increased DVEr to *30 and added in call to ADVISE
C           14/02/2006 simplified for new arguments for ANOVAP
C           22/09/2007 edited for version 6 
C           09/07/2022 added E_NUMBERS and E_FORMATS and extensive revision
C
C
      IMPLICIT   NONE
      INTEGER    NIN, NOUT
      PARAMETER (NIN = 3, NOUT = 4)
      INTEGER    NBIG, NVBIG, N95
      PARAMETER (NBIG = 50, NVBIG = 127, N95 = 95)
      INTEGER    NPAR
      PARAMETER (NPAR = 2)
      INTEGER    IDBN, ITEST, N
      INTEGER    ILIM, ISEND, JSEND, NTYPE
      INTEGER    N_B, N_P, N_X
      INTEGER    NCOL_32, NROW_32
      DOUBLE PRECISION P, Q, R
      DOUBLE PRECISION XVER, YVER
      DOUBLE PRECISION PAR(NPAR)
      CHARACTER  FNAME_32*1024, TITLE_32*80
      CHARACTER  FNAME_B*1024, TITLE_B*80
      CHARACTER  FNAME_P*1024, TITLE_P*80
      CHARACTER  FNAME_X*1024, TITLE_X*80
      CHARACTER  FSAV*1024, TITLE*80
      CHARACTER  DVER*30, PVER*15
      PARAMETER (PVER = 'w_binomial.exe')
      CHARACTER  BLANK*1, PNAME*8
      PARAMETER (BLANK = ' ', PNAME = 'BINOMIAL')
      LOGICAL    ABORT, ACTION, AGAIN, FIRST, SHOW
      EXTERNAL   FNAMES, REVPRO, SPOWER, WINDOW, NONCEN
      EXTERNAL   ADVISE, RESFIL, DETAIL, ARGUIN, PDFVAL, CDFVAL, INVERT,
     +           NCXVAL, CONLIM, ANOVAP, POISSN, PUTADV, M_MATONE,
     +           M_VECONE, M_ONEVEC
      EXTERNAL   DLLCHK, SIMVER
      INTRINSIC  DBLE


C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C Note ISEND = 2 since may be called from SIMSTAT which has called
C WINDOW with ISEND = 1
C
      ISEND = 2
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND,
     +             TITLE, 
     +             ACTION)
      CALL SIMVER (XVER, YVER,
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER,
     +             DVER, PVER,
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C

      FIRST = .TRUE.
      CALL ADVISE (DVER,
     +             ABORT, FIRST)
      IF (.NOT.ABORT) THEN
         IDBN = 1
         FSAV = BLANK
         CALL RESFIL (NOUT,
     +                FSAV,
     +                ABORT)
      ENDIF
      IF (.NOT.ABORT) THEN
         WRITE (NOUT,100)
C
C First set ILIM, N, P, Q, R, ISEND, etc.
C
         ILIM = N95
         N =  10
         P = 0.5D+00
         Q = 1.0D+00 - P
         R = 2.0D+00
         ISEND = 14
         ITEST = 0
         FNAME_32 = BLANK
         TITLE_32 = BLANK
         NCOL_32 = 0
         NROW_32 = 0
         FNAME_B = BLANK
         TITLE_B = BLANK
         N_B = 0
         FNAME_P = BLANK
         TITLE_P = BLANK
         N_P = 0
         FNAME_X = BLANK
         TITLE_X = BLANK
         N_X = 0
C
C Main cycle point
C ================
C
         AGAIN = .TRUE.
         DO WHILE (AGAIN)
            CALL DETAIL (IDBN, ILIM, ISEND, ITEST, N,
     +                   P, R)
            IF (ISEND.EQ.1) THEN
C
C ISEND = 1: arguments
C              
               CALL ARGUIN (N, NOUT, 
     +                      P, Q, R)
            ELSEIF (ISEND.EQ.2) THEN
C
C ISEND = 2: pmf values
C            
               CALL PDFVAL (IDBN, N, NOUT, 
     +                      P, R)
            ELSEIF (ISEND.EQ.3) THEN
C
C ISEND = 3: cdf values
C            
               CALL CDFVAL (IDBN, N, NOUT,
     +                      P, R)
            ELSEIF (ISEND.EQ.4) THEN
C
C ISEND = 4: percentage points
C            
               CALL INVERT (IDBN, N, NOUT,
     +                      P, R)
            ELSEIF (ISEND.EQ.5) THEN
C
C ISEND = 5: binomial coefficients
C            
               CALL NCXVAL (NBIG, NOUT, NVBIG)
            ELSEIF (ISEND.EQ.6) THEN
C
C ISEND = 6: binomial confidence limits
C            
               CALL CONLIM (ILIM, NOUT)
            ELSEIF (ISEND.EQ.7) THEN
C
C ISEND = 7: test for named distributions
C
            
C
C Save then restore N, P, Q and R after call to TESTBN/TESTPN
C
C              IDBN = 1: Binomial distribution
C              IDBN = 2: Poisson distribution
C              ITEST = 1: Just a chi-square test
C              ITEST = 2: Just a KS 1-sample test
C              ITEST = 3: Poisson test
C              N_B, N_P, N_X, NROW_32 = dimension of current data sets
C
               IF (ITEST.EQ.1) THEN
                  IF (IDBN.EQ.1) THEN
C
C Chi-square for binomial
C
                     CALL PUTADV (
     +'k sets of x successes in N trials needed for b(N,p) chi-sq test')
                      PAR(1) = DBLE(N)
                      PAR(2) = P
                      JSEND = 4
                      CALL M_ONEVEC (JSEND, NIN, NOUT, NPAR, N_B,
     +                               PAR,
     +                               FNAME_B, TITLE_B)                      
                     
                  ELSEIF (IDBN.EQ.2) THEN
C
C Chi-square for Poisson
C
                     CALL PUTADV (
     +'k sets of x counts required for Poisson P(lambda) chi-sq. test')
                      PAR(1) = R
                      JSEND = 5
                      CALL M_ONEVEC (JSEND, NIN, NOUT, NPAR, N_P,
     +                               PAR,
     +                               FNAME_P, TITLE_P)
                  ENDIF
               ELSEIF (ITEST.EQ.2) THEN
C
C KS 1-sample test
C
                  IF (IDBN.EQ.1) THEN
                     CALL PUTADV (
     +'k sets of x successes in N trials needed for KS 1-sample test')
                     JSEND = 15
                     CALL M_VECONE (JSEND, NIN, NOUT, N_B,
     +                              FNAME_B, TITLE_B)                     
                  ELSEIF (IDBN.EQ.2) THEN
                     CALL PUTADV (
     +'k sets of x Poisson counts required for KS 1-sample test')
                     JSEND = 16
                     CALL M_VECONE (JSEND, NIN, NOUT, N_P,
     +                              FNAME_P, TITLE_P)         
                  ENDIF
               ELSEIF (ITEST.EQ.3) THEN
                  CALL PUTADV (
     +'k sets of x Poisson counts required for Fisher exact test')
                  JSEND = 5
                  CALL M_VECONE (JSEND, NIN, NOUT, N_X,
     +                           FNAME_X, TITLE_X)                
               ENDIF
            ELSEIF (ISEND.EQ.8) THEN
C
C ISEND = 8: analysis of proportions
C            
               CALL ANOVAP (NIN, NOUT)
            ELSEIF (ISEND.EQ.9) THEN
C
C ISEND = 9: trinomial confidence limits
C
               JSEND = 32
               CALL M_MATONE (JSEND, NCOL_32, NIN, NOUT, NROW_32,
     +                        FNAME_32, TITLE_32)                           
            ELSEIF (ISEND.EQ.10) THEN
C
C ISEND = 10: power and sample size
C            
               CALL SPOWER (NOUT)
            ELSEIF (ISEND.EQ.11) THEN
C
C ISEND = 11: Poisson confidence limits
C            
               CALL POISSN (ILIM, NOUT)
            ELSEIF (ISEND.EQ.13) THEN
C
C ISEND = 13: non-central distributions
C            
               NTYPE = 3
               CALL NONCEN (NOUT, NTYPE)
            ELSEIF (ISEND.EQ.14) THEN
C
C ISEND = 14: help
C            
               FIRST = .FALSE.
               CALL ADVISE (DVER,
     +                      ABORT, FIRST)
            ELSEIF (ISEND.EQ.15) THEN
C
C ISEND = 15: results
C            
               CALL REVPRO (NOUT)
            ELSEIF (ISEND.EQ.16) THEN
C
C ISEND = 16: quit
C            
               AGAIN = .FALSE.
            ENDIF
         ENDDO
         CLOSE (UNIT = NOUT)
         ISEND = 2
         CALL FNAMES (ISEND,
     +                FSAV)
      ENDIF

C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = 2
      ACTION = .FALSE.
      CALL WINDOW (ISEND, 
     +             TITLE,
     +             ACTION)
C
C======================================================================
C
      CLOSE (UNIT = NOUT)
C
C Format statement
C
  100 FORMAT (/1X,'PACKAGE : SIMFIT'/1X,'PROGRAM : BINOMIAL'
     +/1X,'ACTION  : Binomial and Poisson distributions'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U.K.')
      END
C
C---------------------------------------------------------------------
C
      SUBROUTINE ADVISE (DVER,
     +                   ABORT, FIRST)
C
C ACTION : Advise user
C
      IMPLICIT   NONE
C
C Arguments
C
      CHARACTER (LEN = *), INTENT (IN)  :: DVER
      LOGICAL,             INTENT (IN)  :: FIRST
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 3, NUMHDR = 13, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_BINOMIAL
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help           ',
     +'Run the program',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (FIRST) THEN
            WRITE (HEADER,100) DVER
            ISEND = 1
            CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
            ISEND = 1
         ENDIF
         IF (ISEND.EQ.1) THEN
            CALL HELP_BINOMIAL ('binomial')
            IF (FIRST) THEN
               REPEET = .TRUE.
            ELSE
               ABORT = .FALSE.
               REPEET = .FALSE.
            ENDIF
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `BINOMIAL'
     +/'        `      '
     +/'Action  `Binomial/Poisson dbn. and Analysis of Proportions,'
     +/'        `pdf/cdf/inverse,test for b(N,p)/P(lambda),estimate'
     +/'        `p,lambda,CMH-Meta Analysis,power/sample size,etc.'
     +/'        `      '
     +/'Version `',A
     +/'        `      '
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      '
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C---------------------------------------------------------------------
C
      SUBROUTINE ARGUIN (N, NOUT, 
     +                   P, Q, R)
C
C ACTION : Enter N, P and R then calculate Q = 1 - P
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          Call to graphics limited by dimensions in GKS004
C          16/04/1997 revised for win32 version
C          05/04/2000 added IDBN, NOUT, R
C          27/09/2007 extensively revised   
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NOUT
      INTEGER,          INTENT (INOUT) :: N
      DOUBLE PRECISION, INTENT (INOUT) :: P, Q, R
C
C Local allocatable arrays
C     
      DOUBLE PRECISION, ALLOCATABLE :: XGRAF(:), YGRAF(:)
C
C Locals
C     
      INTEGER    I, IERR, J, KTEMP, L, M, NBIG, NSMALL
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT, NSTART,
     +           NTEXT, N0, N1
      PARAMETER (ICOLOR = 7, IX = 4, IY = 4, LSHADE = 1, NUMOPT = 6,
     +           NSTART = 7, NTEXT = 12, N0 = 0, N1 = 1)
      INTEGER    ISEND    
      PARAMETER (ISEND = 0)      
      INTEGER    NTOP, NGRAF
      PARAMETER (NTOP = 1999, NGRAF = 3*(NTOP + 1))
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      DOUBLE PRECISION ZERO, ONE, PMIN, PMAX, RMIN
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00,
     +           PMIN = 0.0001D+00, PMAX = ONE - PMIN, RMIN = PMIN)
      DOUBLE PRECISION TEMP
      DOUBLE PRECISION PDF_BINOMIAL, PDF_POISSON
      CHARACTER (LEN = 1 ) CIPHER
      PARAMETER (CIPHER = 'L')
      CHARACTER (LEN = 10) D10, FORMGR, VALUEP
      CHARACTER (LEN = 12) I12, FORM12
      CHARACTER (LEN = 13) D13, SHOWLJ
      CHARACTER  PTITLE*45, XTITLE*1, YTITLE*7
      CHARACTER  TEXT(NTEXT)*100, LINE*100, WORD10*10
      LOGICAL    E_NUMBERS, E_FORMATS 
      LOGICAL    AGAIN, YES
      PARAMETER (YES = .TRUE.)
      LOGICAL    TAB_BOT, TAB_MID, TAB_TOP
      PARAMETER (TAB_BOT = .FALSE., TAB_MID = .FALSE., TAB_TOP = .TRUE.)
      EXTERNAL   E_FORMATS, FORM12, FORMGR, SHOWLJ, X_DOFDOT
      EXTERNAL   PDF_BINOMIAL, PDF_POISSON
      EXTERNAL   GETJM1, GETDM1, GKS004, PUTWAR, LBOX01, GETDGE, TRIML1,
     +           GETJGE
      INTRINSIC  DBLE
      SAVE       NBIG, NSMALL
      DATA       NBIG, NSMALL / 10, 0 /
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
      E_NUMBERS = E_FORMATS()
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
         WRITE (WORD10,'(I10)') N
         CALL TRIML1 (WORD10)
         IF (E_NUMBERS) THEN
            WRITE (TEXT,100) WORD10, P, R
         ELSE
            D13 = SHOWLJ(R)
            WRITE (VALUEP,'(F10.4)') P
            CALL X_DOFDOT (ISEND,
     +                     CIPHER, VALUEP) 
            WRITE (TEXT,150) WORD10, VALUEP, D13
         ENDIF      
         NUMDEC = NUMOPT
         NUMBLD(1) = 1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                TAB_BOT, TAB_MID, TAB_TOP)
         IF (NUMDEC.EQ.4 .OR. NUMDEC.EQ.5) THEN
C
C Allocate if plotting required
C           
            IERR = 0
            IF (ALLOCATED(XGRAF)) DEALLOCATE(XGRAF, STAT = IERR)
            IF (IERR.NE.0) RETURN 
            IF (ALLOCATED(YGRAF)) DEALLOCATE(YGRAF, STAT = IERR)
            IF (IERR.NE.0) RETURN     
            ALLOCATE(XGRAF(NGRAF), STAT = IERR)
            IF (IERR.NE.0) RETURN 
            ALLOCATE(YGRAF(NGRAF), STAT = IERR)
            IF (IERR.NE.0) RETURN
         ENDIF          
         IF (NUMDEC.EQ.1) THEN
C
C NUMDEC = 1: binomial N
C           
            I = 1
            J = 100000000
            CALL GETJM1 (I, N, J,
     +'N required for b(N,p), where N >= 1')
         ELSEIF (NUMDEC.EQ.2) THEN
C
C NUMDEC = 2: binomial p
C         
            CALL GETDM1 (PMIN, P, PMAX,
     +'p required for b(N,p), where 0 < p < 1' )
            Q = ONE - P
         ELSEIF (NUMDEC.EQ.3) THEN
C
C NUMDEC = 3: Poisson lambda
C         
            CALL GETDGE (R, RMIN,
     +'Poisson parameter lambda for P(lambda), where lambda > 0')
         ELSEIF (NUMDEC.EQ.4) THEN
C
C NUMDEC = 4: binomial plot
C         
            IF (N.LE.NTOP) THEN
               J = 0
               DO I = 1, N + 1
                  J = J + 1
                  TEMP = DBLE(I - 1)
                  KTEMP = I - 1
                  XGRAF(J) = TEMP
                  YGRAF(J) = ZERO
                  J = J + 1
                  XGRAF(J) = TEMP
                  YGRAF(J) = PDF_BINOMIAL (KTEMP, N, NOUT,
     +                                     P)
                  J = J + 1
                  XGRAF(J) = TEMP
                  YGRAF(J) = ZERO
               ENDDO
               L = 1
               M = 0
               WRITE (VALUEP,'(F10.4)') P
               CALL X_DOFDOT (ISEND,
     +                        CIPHER, VALUEP)              
               IF (N.LT.10) THEN
                  WRITE (PTITLE,200) N, VALUEP
               ELSEIF (N.LT.100) THEN
                  WRITE (PTITLE,300) N, VALUEP
               ELSEIF (N.LT.1000) THEN
                  WRITE (PTITLE,400) N, VALUEP
               ELSE
                  WRITE (PTITLE,500) N, VALUEP
               ENDIF
               XTITLE = 'x'
               YTITLE = 'prob(x)'
               I = 3*(N + 1)
               CALL GKS004 (L, M, M, M, M, M, M, M, I, I, I, I,
     +                      XGRAF, XGRAF, XGRAF, XGRAF,
     +                      YGRAF, YGRAF, YGRAF, YGRAF,
     +                      PTITLE, XTITLE, YTITLE,
     +                      YES, YES)
            ELSE
               I12 = FORM12(NTOP)
               WRITE (LINE,600) I12
               CALL PUTWAR (LINE)
            ENDIF
            DEALLOCATE(XGRAF, STAT = IERR)
            DEALLOCATE(YGRAF, STAT = IERR)
         ELSEIF (NUMDEC.EQ.5) THEN
C
C NUMDEC = 5: Poisson plot
C         
            CALL GETJGE (NSMALL, N0, 'Starting value (x > = 0)')
            IF (NBIG.LE.NSMALL) NBIG = NSMALL + N1
            CALL GETJGE (NBIG, NSMALL + N1, ' Upper value for x')
            IF (NBIG - NSMALL.LE.NTOP) THEN
               J = 0
               DO I = NSMALL, NBIG
                  J = J + 1
                  TEMP = DBLE(I)
                  KTEMP = I
                  XGRAF(J) = TEMP
                  YGRAF(J) = ZERO
                  J = J + 1
                  XGRAF(J) = TEMP
                  YGRAF(J) = PDF_POISSON (KTEMP, NOUT,
     +                                    R)
                  J = J + 1
                  XGRAF(J) = TEMP
                  YGRAF(J) = ZERO
               ENDDO
               L = 1
               M = 0
               IF (E_NUMBERS) THEN
                  WRITE (PTITLE,700) R
               ELSE
                  D10 = FORMGR(R)
                  WRITE (PTITLE,750) D10
               ENDIF      
               XTITLE = 'x'
               YTITLE = 'prob(x)'
               I = 3*(NBIG - NSMALL + 1)
               CALL GKS004 (L, M, M, M, M, M, M, M, I, I, I, I,
     +                      XGRAF, XGRAF, XGRAF, XGRAF,
     +                      YGRAF, YGRAF, YGRAF, YGRAF,
     +                      PTITLE, XTITLE, YTITLE, 
     +                      YES, YES)
               DEALLOCATE(XGRAF, STAT = IERR)
               DEALLOCATE(YGRAF, STAT = IERR)
            ELSE
               WRITE (LINE,600) NTOP
               CALL PUTWAR (LINE)
            ENDIF
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C NUMDEC = NUMOPT: cancel
C         
            AGAIN = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Binomial and Poisson parameters'
     +/
     +/'Binomial N = ',A
     +/'Binomial p =',F7.4
     +/'Poisson lambda =',1P,E10.3
     +/
     +/'Change binomial N'
     +/'Change binomial p'
     +/'Change Poisson lambda'
     +/'Plot Binomial probabilities'
     +/'Plot Poisson probabilities'
     +/'Apply')
  150 FORMAT (
     + 'Binomial and Poisson parameters'
     +/
     +/'Binomial N = ',A
     +/'Binomial p =',1X,A
     +/'Poisson lambda =',1X,A
     +/
     +/'Change binomial N'
     +/'Change binomial p'
     +/'Change Poisson lambda'
     +/'Plot Binomial probabilities'
     +/'Plot Poisson probabilities'
     +/'Apply')   
  200 FORMAT ('  Binomial Probabilities: N =',I2,', p =',1X,A)
  300 FORMAT (' Binomial Probabilities: N =',I3,', p =',1X,A)
  400 FORMAT ('Binomial Probabilities: N =',I4,', p =',1X,A)
  500 FORMAT ('Binomial Probabilities: N =',I5,', p =',1X,A)
  600 FORMAT (
     +'N too large to plot probabilities ... Max. allowed =',1X,A)
  700 FORMAT (' Poisson probablilities: lambda =',1P,E10.3)
  750 FORMAT (' Poisson probablilities: lambda =',1X,A)
      END
C
C---------------------------------------------------------------------
C
      SUBROUTINE DETAIL (IDBN, ILIM, ISEND, ITEST, N,
     +                   P, R)
C
C ACTION : Decide option required
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          Previous options saved in ISAV, JSAV
C          16/04/1997 Revised for win32 version
C          05/04/2000 added IDBN and BINOM to control sub-menu
C          21/09/2007 re-written 
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)    :: N       
      INTEGER,          INTENT (INOUT) :: IDBN, ILIM, ISEND, ITEST
      DOUBLE PRECISION, INTENT (IN)    :: P, R
C
C Locals
C      
      INTEGER    KSEND
      PARAMETER (KSEND = 0)
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT, N1, N2
      PARAMETER (ICOLOR = 9, IX = 12, IY = 8, LSHADE = 1,
     +           NSTART = 3, N1 = 1, N2 = 2)
      INTEGER    NUMBLD(30), NUMPOS(20)
      INTEGER    L, LEN200
      INTEGER    ISAV, JSAV, JSEND
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER (LEN = 1  ) CIPHER
      PARAMETER (CIPHER = 'L')
      CHARACTER (LEN = 10 ) WORD10, VALUEP
      CHARACTER (LEN = 13 ) D13, SHOWLJ
      CHARACTER (LEN = 100) TEXT(30)
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    AGAIN
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE.,
     +           HIGH = .FALSE.)
      EXTERNAL   E_FORMATS, SHOWLJ, X_DOFDOT
      EXTERNAL   LBOX01, TRIML1, LEN200, GETJ01, PUTFAT
      INTRINSIC  TRIM
      SAVE       ISAV, JSAV
      DATA       ISAV, JSAV / 18, 18 /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 20*1 /
      E_NUMBERS = E_FORMATS()
      ISEND = ISAV
      JSEND = JSAV
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
         WRITE (TEXT,100) ILIM
         NUMOPT = 20
         NTEXT = NSTART + NUMOPT 
         IF (N.LT.N1 .OR. P.LE.ZERO .OR. P.GE.ONE .OR. R.LE.ZERO) THEN
            WRITE (TEXT(NTEXT),200)
         ELSE
            WRITE (WORD10,'(I10)') N
            CALL TRIML1 (WORD10)
            L = LEN200(WORD10)
            IF (E_NUMBERS) THEN
               WRITE (TEXT(NTEXT),300) WORD10(N1:L), P, R
            ELSE
               WRITE (VALUEP,'(F10.5)') P
               CALL X_DOFDOT (KSEND,
     +                        CIPHER, VALUEP)             
               D13 = SHOWLJ(R)
               WRITE (TEXT(NTEXT),350) TRIM(WORD10), TRIM(VALUEP), D13 
            ENDIF  
         ENDIF
         NUMBLD(1) = 1
         NUMBLD(NTEXT ) = 1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, JSEND, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         AGAIN = .FALSE.
         IF (JSEND.LE.9) THEN
            ISEND = JSEND
            IDBN = N1
            AGAIN = .FALSE.
         ELSEIF (JSEND.GE.10 .AND. JSEND.LE.12) THEN    
            IDBN = N2
            ISEND = JSEND - 8
            AGAIN = .FALSE.
         ELSEIF (JSEND.EQ.13) THEN
            ISEND = 11
            IDBN = N2
            AGAIN = .FALSE.
         ELSEIF (JSEND.EQ.14) THEN    
            ISEND = 7
            IDBN = N2
            AGAIN = .FALSE.    
         ELSEIF (JSEND.EQ.15) THEN   
            ISEND = 10
            AGAIN = .FALSE.
         ELSEIF (JSEND.EQ.16) THEN
C
C Change percentage for confidence limits
C
            L = ILIM
            CALL GETJ01 (L, '90, 95 or 99 for the % required')
            IF (L.EQ.90) THEN
               ILIM = 90
            ELSEIF (L.EQ.95) then
               ILIM = 95
            ELSEIF (L.EQ.99) THEN
               ILIM = 99
            ELSE
               CALL PUTFAT ('Only 90, 95 or 99 allowed')
            ENDIF
            AGAIN = .TRUE.
         ELSE
            ISEND = JSEND - 4
            AGAIN = .FALSE.   
         ENDIF
      ENDDO
      ISAV = ISEND
      JSAV = JSEND
      IF (ISEND.EQ.7) THEN
         WRITE (TEXT,400)
         IF (IDBN.EQ.1) THEN
            NTEXT = 4
            NUMOPT = 2
         ELSE
            NTEXT = 5
            NUMOPT = 3
         ENDIF
         ITEST = 1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, ITEST, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     + 'Options for the binomial, trinomial, or Poisson distributions'
     +/
     +/'Input: binomial and Poisson parameters then plot if required'
     +/'Input: binomial x ... calculate pmf(x)'
     +/'Input: binomial x ... calculate cdf(x)'
     +/'Input: binomial % ... calculate x-critical values'
     +/'Input: binomial N,x, calculate binomial coefficients'
     +/'Input: binomial N,x, estimate p, and confidence limits'
     +/'Input: a sample, test if distributed b(N,p)'
     +/'Input: binomial x,N,t, analysis of proportions'
     +/'Input: trinomial x,y,N, plot confidence regions'
     +/'Input: Poisson x ... calculate pmf(x)'
     +/'Input: Poisson x ... calculate cdf(x)'
     +/'Input: Poisson % ... calculate x-critical values'
     +/'Input: Poisson x, estimate lambda and confidence limits'
     +/'Input: a sample, test if distributed P(lambda)'
     +/'Calculate: power and sample size'
     +/'Calculate: change confidence limits (now ',i3,'%)'
     +/'Calculate: using the non-central beta distribution'
     +/'Help'
     +/'Results'
     +/'Quit ... Exit program BINOMIAL'
     +/)
  200 FORMAT ('Initialise N, p, and lambda')
  300 FORMAT ('Parameters: N = ',A,', p =',F8.5,', lambda =',1P,E10.3)
  350 FORMAT ('Parameters: N = ',A,', p =',1X,A,', lambda =',1X,A)
  400 FORMAT (
     + 'Goodness of fit options'
     +/
     +/'Chi-square test'
     +/'KS 1-sample test'
     +/'Fisher exact test')
      END
C
C
