//
// This code is by David Bailey for a Simfit curtain which uses simfitbar.exe
// 11/08/2014 ... Tested by WGB and seems OK with 32-bit and 64-bit Simfit 
//

/***********************************************************/
/*                                                         */
/*      Byte 0  Set to 1 to close the bar                  */
/*     	Byte 1  Set to 1 to close the driver               */
/*     	Byte 2  Set to 1 by driver to say it is present    */
/*      Byte 3  Set to 1 to close the individual program   */
/*                                                         */
/***********************************************************/

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>

#define CLOSE_BAR 0
#define CLOSE_DRIVER 1
#define DRIVER_PRESENT 2
#define CLOSE_PROGRAM 3

#define winio __winio
#define create_interprocess_shared_memory(a,b) __create_interprocess_shared_memory(a,b)
#define window_update(a) __window_update(a)
#define start_process_and_wait(a,b,c) __start_process_and_wait(a,b,c)
extern "C" int winio(char*,...);
extern "C" void window_update(void*);
extern "C" int start_process_and_wait(char*,char*,int);
extern "C" char* create_interprocess_shared_memory(CHAR *map_name,int size); 

int mask_var;
char* shared_mem;

HANDLE mask_handle;
#define register_message_loop_hook(a) __register_message_loop_hook(a)
extern  "C" void register_message_loop_hook(int (*)());

void terminate_process()
{
TerminateProcess(OpenProcess(PROCESS_ALL_ACCESS,0,GetCurrentProcessId()),0);
}

int DriverQuit()
{
    if(shared_mem[CLOSE_DRIVER] != 0)TerminateProcess(OpenProcess(PROCESS_ALL_ACCESS,0,GetCurrentProcessId()),0);
	    return 0;
}

extern "C" int DriverCloser()
{
        shared_mem=create_interprocess_shared_memory((char*)"SIMFIT",200);
         shared_mem[DRIVER_PRESENT]=1;
		 register_message_loop_hook(DriverQuit);
		 return 0;
}

typedef void (* close4)();
close4 ptr_close4=NULL;


int check_for_close()
{
    if (shared_mem[CLOSE_PROGRAM] != 0)
    {
        shared_mem[CLOSE_PROGRAM]=0;
		if(ptr_close4)(*ptr_close4)();
         terminate_process();
    }
    return 0;
}

extern "C" int c_window(char* title,int action,close4 sub)
{
    int width,depth;
    if (action)
    {
	    ptr_close4=sub;
        shared_mem=create_interprocess_shared_memory((char*)"SIMFIT",200);

        register_message_loop_hook(check_for_close);

        width=GetSystemMetrics(SM_CXSCREEN);
        int sdepth=GetSystemMetrics(SM_CYSCREEN);
        depth=GetSystemMetrics(SM_CYMENU)+GetSystemMetrics(SM_CYCAPTION)+1;

        winio((char*)"%ww[no_caption]%bg%ca@%hw%sp%lw",
              RGB(127,153,153),title,&mask_handle,0,0,&mask_var);


         int ans=MoveWindow((HWND)mask_handle,0,depth,width,sdepth,1);
        strcpy(shared_mem+10,title);

        ans=start_process_and_wait((char*)"SimfitBar.exe",(char*)"", 0);
		return ans;
		
    }
    else
    {
        shared_mem[CLOSE_BAR]=1;
		mask_var=0;
		window_update(&mask_var);
    }
	return 0;
}





