C
C INCLUDE file ... for program CALCURVE
C
C CALCURV1.INS : FUNC, CHECK1, CHECK2, CHOOSE, DATAIN, DATFIT, DATOUT
C ============
C
C Note NOUT = 4 etc. for output to PUTIFA
C
C
      DOUBLE PRECISION FUNCTION FUNC (N,
     +                                A, F, P, Q)
C
C Function for predicting X given Y
C Note parameter setting for NOUT in call to PUTIFA
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: N
      DOUBLE PRECISION, INTENT (IN) :: A(N), F(N), P, Q
C
C Locals
C      
      INTEGER    NOUT
      PARAMETER (NOUT = 4)
      INTEGER    IFAIL
      DOUBLE PRECISION S
      EXTERNAL   E02BBF$
      EXTERNAL   PUTIFA
      IFAIL = 1
      CALL E02BBF$(N, F, A, P, S, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'E02BBF/FUNC')
      FUNC = S - Q
      END
C
C
      SUBROUTINE CHECK1 (NOPT,
     +                   PCENT,
     +                   ABORT)
C
C Check settings before curve fitting
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: NOPT(8)
      DOUBLE PRECISION, INTENT (IN)  :: PCENT
      LOGICAL,          INTENT (OUT) :: ABORT
C
C Locals
C      
      INTEGER    N1, N2, N3, N4
      PARAMETER (N1 = 1, N2 = 2, N3 = 3, N4 = 4)
      INTEGER    I, NCHECK(8)
      DOUBLE PRECISION PBOT, PTOP
      PARAMETER (PBOT = 0.01D+00, PTOP = 99.0D+00)
      CHARACTER (LEN = 100) LINE
      EXTERNAL   PUTFAT, PUTWAR
      INTRINSIC  ABS
      DATA       NCHECK / N3, N2, N4, N3, N2, N4, N2, N2 /
      ABORT = .FALSE.
      DO I = 1, 8
         IF (NOPT(I).LT.N1 .OR. NOPT(I).GT.NCHECK(I)) THEN
            WRITE (LINE,100) I, NOPT(I), N1, NCHECK(I)
            CALL PUTFAT (LINE)
            ABORT = .TRUE.
         ENDIF
      ENDDO
      IF (ABORT) RETURN
      IF (NOPT(4).EQ.2) THEN
         IF (PCENT.LT.PBOT .OR. PCENT.GT.PTOP) THEN
            WRITE (LINE,200) PCENT
            CALL PUTWAR (LINE)
         ENDIF
      ENDIF
C
C Format statements
C      
  100 FORMAT ('I(',I1,') =',I3,1X,'... Must be between',I2,1X,'and',I2)
  200 FORMAT ('Relative error specified as',F10.2,'%',1X,
     +'... Unrealistic ?')
      END
C
C
      SUBROUTINE CHECK2 (ICHECK, INDEX, N,
     +                   X, Y, YDIFF,
     +                   REJECT)
C
C Check X, Y data for turning points
C
      IMPLICIT   NONE
      INTEGER,          INTENT (IN)    :: N
      INTEGER,          INTENT (INOUT) :: ICHECK(N), INDEX(N)
      DOUBLE PRECISION, INTENT (IN)    :: X(N), Y(N), YDIFF
      LOGICAL,          INTENT (OUT)   ::  REJECT
C
C Locals
C      
      INTEGER    I, NTP
      INTEGER    JCOLOR
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMTXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NUMTXT = 22)
      INTEGER    NUMBLD(NUMTXT)
      DOUBLE PRECISION TEST1, TEST2, TEST3, TEST4
      PARAMETER (TEST1 = 0.02D+00, TEST2 = 0.04D+00, TEST3 = 0.06D+00,
     +           TEST4 = 0.08D+00)
      DOUBLE PRECISION DELTA1, DELTA2, RATIO, XHIGH, XLOW
      DOUBLE PRECISION ZERO, TWO, TEN
      PARAMETER (ZERO = 0.0D+00, TWO = 2.0D+00, TEN = 10.0D+00)
      CHARACTER (LEN = 100) LINE, TEXT(30)
      CHARACTER (LEN = 28 ) VERDIC
      CHARACTER (LEN = 13 ) D13(2), SHOWRJ
      CHARACTER (LEN = 7  ) TYPE1
      LOGICAL    E_NUMBERS, E_FORMATS 
      LOGICAL    YES
      LOGICAL    BORDER
      PARAMETER (BORDER = .FALSE.)
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   TABLE1, YESNO2, PATCH1
      INTRINSIC  MIN, ABS, NINT
      DATA       NUMBLD / NUMTXT*0 /
C
C First find out if there are any turning points
C
      REJECT = .FALSE.
      NTP = 0
      DELTA1 = Y(2) - Y(1)
      DO I = 2, N - 1
         DELTA2 = Y(I + 1) - Y(I)
         IF (DELTA1*DELTA2.LT.ZERO) THEN
            NTP = NTP + 1
            INDEX(NTP) = I
         ENDIF
         DELTA1 = DELTA2
      ENDDO
C
C Return now if there are no turning points
C
      IF (NTP.EQ.0) RETURN
      E_NUMBERS = E_FORMATS()  
      JCOLOR = 15
      CALL TABLE1 (JCOLOR, 'OPEN')
      ICHECK(1) = 1
      DO I = 2, NTP
         ICHECK(I) = NINT((INDEX(I - 1) + INDEX(I))/TWO)
      ENDDO
      ICHECK(NTP + 1) = N
      DELTA1 = (X(N) - X(1))/TEN
      XHIGH = X(N) - DELTA1
      XLOW = X(1) + DELTA1
      WRITE (TEXT,100) NTP
      DO I = 1, 4
         IF (I.LE.2) THEN
            JCOLOR = 4
         ELSE
            JCOLOR = 0
         ENDIF
         CALL TABLE1 (JCOLOR, TEXT(I))
      ENDDO
      JCOLOR = 0
      DO I = 1, NTP
         DELTA1 = Y(ICHECK(I)) - Y(INDEX(I))
         DELTA2 = Y(INDEX(I)) - Y(ICHECK(I + 1))
         IF (DELTA1.GT.ZERO) THEN
            TYPE1 = 'Minimum'
         ELSE
            TYPE1 = 'Maximum'
         ENDIF
         RATIO = MIN(ABS(DELTA1),ABS(DELTA2))/YDIFF
         IF (RATIO.GT.TEST4) THEN
            VERDIC = '   Very serious         No'
            REJECT = .TRUE.
         ELSEIF (RATIO.GT.TEST3) THEN
            VERDIC = ' Fairly serious   Possibly ?'
            REJECT = .TRUE.
         ELSEIF (RATIO.GT.TEST2) THEN
            VERDIC = ' A bit worrying   Probably ?'
            REJECT = .TRUE.
         ELSEIF (RATIO.GT.TEST1) THEN
            VERDIC = ' Fairly trivial        Yes ?'
         ELSE
            VERDIC = '   Very trivial        Yes'
         ENDIF
         IF (X(INDEX(I)).LE.XLOW) THEN
            VERDIC = 'Near start of curve    Yes ?'
         ELSEIF(X(INDEX(I)).GE.XHIGH) THEN
            VERDIC = 'Near end of curve      Yes ?'
         ENDIF
         IF (E_NUMBERS) THEN
            WRITE (LINE,200) X(INDEX(I)), Y(INDEX(I)), TYPE1, VERDIC
         ELSE
            D13(1) = SHOWRJ(X(INDEX(I)))
            D13(2) = SHOWRJ(Y(INDEX(I)))
            WRITE (LINE,250) D13(1), D13(2), TYPE1, VERDIC
         ENDIF  
         CALL TABLE1 (JCOLOR, LINE)
      ENDDO
      CALL TABLE1 (JCOLOR, 'CLOSE')
      IF (REJECT) THEN
         WRITE (LINE,300)
         YES = .FALSE.
         CALL YESNO2 (ICOLOR, IX, IY,
     +                LINE,
     +                YES)
         IF (YES) THEN
            WRITE (TEXT,400)
            NUMBLD(1) = 1
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMTXT,
     +                   TEXT,
     +                   BORDER)
         ENDIF
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     +/1X,'WARNING : The best-fit curve has',I3,1X,'turning point(s)'
     +/
     +/7X,'x-value',7X,'y-value',5X,'Type',9X,'Verdict',7X,
     +'Use curve')
  200 FORMAT (1X,1P,E13.5,1X,E13.5,4X,A7,4X,A28)
  250 FORMAT (1X,A13,     1X,A13,  4X,A7,4X,A28)
  300 FORMAT ('Do you want any advice about turning points ?')
  400 FORMAT (
     + 'Turning points in calibration curves'
     +/
     +/'Turning points may result from badly spaced out points,data'
     +/'near asymptotes, noisy data, innappropriate weighting or an'
     +/'unfortunate choice of spline-knot placing and/or density.'
     +/'You still could be able to use the calibration curve if you'
     +/'only require prediction well away from any turning points.'
     +/'This should be clear from the data provided in the previous'
     +/'table and after inspecting the graphical display.'
     +/
     +/'For a better curve consider these possibilities:'
     +/'1. `Change the independent variable e.g. from x to log(x) or'
     +/'   `from log(x) to x.'
     +/'2. `Change the weighting, e.g. from w = 1/(s supplied)^2 to'
     +/'   `w = 1/%y^2, or to w = 1 (i.e. all s = 1).'
     +/'3. `Change the knot density e.g. from  normal to sparse or'
     +/'   `from solid to dense etc.'
     +/'4. `Eliminate outliers or data near horizontal asymptotes.'
     +/'5. `Extra data with a more even covering of the x-axis.'
     +/'6. `If the data really has turning points you can split it'
     +/'   `into sections before and after the turning points then'
     +/'   `analyse the monotonic sections separately.')
      END
C
C
      SUBROUTINE CHOOSE (ISEND, NOPT, NOUT, NSET, N7,
     +                   PCENT,
     +                   TEXT_SAV,
     +                   ISTOP, XPERT)
C
C Choose option required  ... Note that TEXT_SAV is set in SETSUP
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NOUT(3)
      INTEGER,             INTENT (INOUT) :: ISEND, NOPT(8), NSET, N7 
      DOUBLE PRECISION,    INTENT (INOUT) :: PCENT
      CHARACTER (LEN = *), INTENT (INOUT) :: TEXT_SAV(*)
      LOGICAL,             INTENT (INOUT) :: ISTOP(2), XPERT
C
C Locals
C      
      INTEGER    I
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NUMOPT = 10,
     +           NSTART = 13, NTEXT = NSTART + NUMOPT - 1)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      CHARACTER (LEN = 100) TEMP(30), TEXT(30)
      CHARACTER (LEN = 4  ) SYMBOL(2)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   SETSUP
      EXTERNAL   LBOX01
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
      NSET = 3
      CALL SETSUP (NOPT, NOUT, NSET, N7,
     +             PCENT,
     +             TEXT_SAV,
     +             ISTOP, XPERT)
      ISEND = 4
      IF (ISTOP(1)) THEN
         ISEND = 1
         SYMBOL(1) = ' ***'
         SYMBOL(2) = ' '
         DO I = 1, 10
            TEXT(I) = TEXT_SAV(I)
         ENDDO
      ELSE
         SYMBOL(1) = ' '
         IF (ISTOP(2)) THEN
             ISEND = 2
             SYMBOL(2) = ' ***'
         ELSE
             ISEND = 4
             SYMBOL(2) = ' '
         ENDIF
      ENDIF
      WRITE (TEMP,100) SYMBOL(1), SYMBOL(2)
      TEXT(1) = 'Options for program Calcurve'
      DO I = 1, 10
         TEXT(I + 1) = TEXT_SAV(I)
         TEXT(11 + I) = TEMP(I)
      ENDDO
      TEXT(NTEXT) = TEMP(11)
      NUMBLD(1) = 4
      NUMBLD(10) = 1
      NUMBLD(11) = 1
      CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, ISEND, NUMOPT,
     +             NUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             BORDER, FLASH, HIGH)
C
C Format statement
C     
  100 FORMAT (
     +/'Input new calibration data',A4
     +/'Construct the calibration curve',A4
     +/'Residuals'
     +/'Plot'
     +/'Predict x given y'
     +/'Calculate y given x'
     +/'Configure'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit program Calcurve')
      END
C
C
      SUBROUTINE DATAIN (ISEND, NBIG, NMAX, NOPT, NOUT, NPTS, N7,
     +                   E, PCENT, W, WINV, X, Y, YMAX, YMIN, 
     +                   FNAME, TITLE,
     +                   ISTOP, XISLOG, XPERT)
C
C Read in and check data supplied
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ISEND, NBIG, NMAX, NOUT(3)
      INTEGER,             INTENT (INOUT) :: NOPT(8), NPTS, N7
      DOUBLE PRECISION,    INTENT (INOUT) :: E(NMAX), PCENT, W(NMAX), 
     +                                       WINV(NMAX), X(NMAX),
     +                                       Y(NMAX)  
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, TITLE
      LOGICAL,             INTENT (INOUT) :: ISTOP(2), XISLOG, XPERT
C
C Locals
C      
      INTEGER    I, ICOUNT, IOS, NCOL, NDIST, NPAUSE, NROW, NTEMP
      INTEGER    NOPT1(8), NSET
      DOUBLE PRECISION E1, PCENT1, X1, Y1
      DOUBLE PRECISION RATIO, YMAX, YMIN
      DOUBLE PRECISION ONE, TEN, HUN, XTOL
      PARAMETER (ONE = 1.0D+00, TEN = 10.0D+00, HUN = 100.0D+00,
     +           XTOL = 1.0D-150)
      CHARACTER (LEN = 100) LINE, TEXT_SAV(30)
      CHARACTER (LEN = 80 ) TRIM80, WORD80
      LOGICAL    FIXNPT, LABEL
      PARAMETER (FIXNPT = .FALSE., LABEL = .TRUE.)
      LOGICAL    ABORT, REJECT
      EXTERNAL   PUTWAR, PUTFAT, PUTCAU, DATTIN, DATCHK, TRIM80
      EXTERNAL   CHECK1, M_FITONE, SETSUP
      INTRINSIC  ABS, LOG10
      SAVE       NCOL, NROW
      SAVE       REJECT
      SAVE       ICOUNT, NDIST
      DATA       ICOUNT / 0 /
      DATA       NCOL, NROW / 0, 0 /
C
C ISEND = 1: read in data
C
      IF (ISEND.EQ.1) THEN
         ISTOP(1) = .TRUE.
         ISTOP(2) = .TRUE.
         REJECT = .TRUE.
        
           
         CLOSE (UNIT = NOUT(1))
         
         IF (NOPT(1).LE.2) THEN
            I = 35
            CALL M_FITONE (I, NCOL, NOUT(1), NROW,
     +                     FNAME, TITLE) 
            IF (NCOL.LT.2 .OR. NROW.LT.4) THEN
               NPTS = 0
               ABORT = .TRUE.
            ELSE
               OPEN (UNIT = NOUT(1), FILE = FNAME)
               READ (NOUT(1),'(A)') TITLE
               READ (NOUT(1),*) NPTS, NCOL
               IF (NCOL.EQ.2) THEN
                  DO I = 1, NPTS
                     READ (NOUT(1),*) X(I), Y(I)
                     E(I) = ONE
                  ENDDO
               ELSEIF (NCOL.EQ.3) THEN  
                  DO I = 1, NPTS
                     READ (NOUT(1),*) X(I), Y(I), E(I)
                  ENDDO   
               ENDIF    
               ABORT = .FALSE.
            ENDIF                
         ELSE
            I = 1
            CALL DATTIN (I, NOUT(1), NMAX, NPTS,
     +                   E, X, Y,
     +                   FNAME, TITLE,
     +                   ABORT, FIXNPT, LABEL)
         ENDIF 
         
         CLOSE (UNIT = NOUT(1))
         
         IF (ABORT) RETURN
         IF (NPTS.LT.4) THEN
            CALL PUTFAT ('There must be at least 4 x-values')
            GOTO 40
         ENDIF
         CALL DATCHK (NPTS,
     +                E, X, Y,
     +                ABORT)
         IF (ABORT) GOTO 40

         XPERT = .FALSE.
         OPEN (UNIT = NOUT(1), FILE = FNAME, IOSTAT = IOS)
           
         IF (IOS.EQ.0) READ (NOUT(1),'(A)', IOSTAT=IOS) LINE
         IF (IOS.EQ.0) READ (NOUT(1),*,IOSTAT=IOS) NROW, NCOL
         IF (NROW.EQ.2) THEN
            DO I = 1, NROW
               IF (IOS.EQ.0) READ (NOUT(1),*,IOSTAT=IOS) X1, Y1
            ENDDO   
         ELSE
            DO I = 1, NROW
               IF (IOS.EQ.0) READ (NOUT(1),*,IOSTAT=IOS) X1, Y1, E1
            ENDDO   
         ENDIF
           
         IF (IOS.EQ.0) THEN
            NTEMP = 0
            READ (NOUT(1),*,IOSTAT=IOS) I
            IF (IOS.EQ.0) NTEMP = I
            IF (IOS.EQ.0 .AND. NTEMP.GT.0) READ (NOUT(1),*,IOSTAT=IOS)
     +           (NOPT1(I), I = 1, 8), PCENT1
            IF (IOS.EQ.0) THEN
               IF (NOPT1(1).LT.1 .OR. NOPT1(1).GT.3) IOS = 1  
               IF (NOPT1(2).LT.1 .OR. NOPT1(2).GT.2) IOS = 2
               IF (NOPT1(3).LT.1 .OR. NOPT1(3).GT.4) IOS = 3
               IF (NOPT1(4).LT.1 .OR. NOPT1(4).GT.3) IOS = 4
               IF (NOPT1(5).LT.1 .OR. NOPT1(5).GT.2) IOS = 5
               IF (NOPT1(6).LT.1 .OR. NOPT1(6).GT.4) IOS = 6
               IF (NOPT1(7).LT.1 .OR. NOPT1(7).GT.2) IOS = 7
               IF (NOPT1(8).LT.1 .OR. NOPT1(8).GT.2) IOS = 8  
               IF (PCENT1.LT.0.1D+00 .OR. PCENT1.GT.100.0D+00) IOS = 9         
            ENDIF
            IF (IOS.EQ.0) XPERT = .TRUE.
         ENDIF
           
         CLOSE (UNIT = NOUT(1))
           
         YMAX = Y(1)
         YMIN = Y(1)
         NDIST = 1
         DO I = 2, NPTS
            IF (X(I).GT.X(I - 1)) NDIST = NDIST + 1
            IF (Y(I).GT.YMAX) YMAX = Y(I)
            IF (Y(I).LT.YMIN) YMIN = Y(I)
         ENDDO
         IF (X(1).LT.XTOL) THEN
            IF (NOPT(2).EQ.2) THEN
               CALL PUTCAU ('x too small for log(x) transformation')
               NOPT(2) = 1
            ENDIF   
         ENDIF
         IF (NDIST.LT.4) THEN
            CALL PUTFAT ('There must be at least 4 distinct x-values')
            GOTO 40
         ENDIF
         CALL CHECK1 (NOPT,
     +                PCENT, 
     +                ABORT)
         IF (ABORT) GOTO 40
         REJECT = .FALSE.
         ICOUNT = ICOUNT + 1
         IF (NOPT(7).EQ.2) THEN
            WRITE (NOUT(2),100) ICOUNT
            WORD80 = TRIM80(FNAME)
            WRITE (NOUT(2),200) WORD80
            WRITE (NOUT(2),300) TITLE
         ENDIF
         ISTOP(1) = .FALSE.
         IF (XPERT) THEN
C
C Overwrite the existing defaults if sensible XPERT parameters have been identified
C           
            DO I = 1, 8
               NOPT(I) = NOPT1(I)
            ENDDO
            IF (NOPT(1).EQ.3) NOPT(1) = 2
            PCENT = PCENT1
         ENDIF   
         IF (.NOT.XPERT) THEN
C
C If in normal mode restore the current defaults
C           
            NSET = 0
            CALL SETSUP (NOPT, NOUT, NSET, N7,
     +                   PCENT,
     +                   TEXT_SAV,
     +                   ISTOP, XPERT)  
         ENDIF
         XISLOG = .FALSE.
         RETURN
      ELSEIF (ISEND.EQ.2) THEN
C
C ISEND = 2: Check data then set up for curve-fitting
C
       
         IF (ISTOP(1)) THEN
            CALL PUTFAT ('Input data before curve-fitting')
            RETURN
         ENDIF
         IF (REJECT) GOTO 40
         IF (NOPT(2).EQ.2 .AND. .NOT.XISLOG) THEN
            IF (X(1).LE.XTOL) THEN
               CALL PUTFAT ('x too small for log(x)')
               ISTOP(2) = .TRUE.
               RETURN
            ENDIF
            DO I = 1, NPTS
               X(I) = LOG10(X(I))
           ENDDO
           XISLOG = .TRUE.
         ENDIF
         IF (NOPT(2).EQ.1 .AND. XISLOG) THEN
            DO I = 1, NPTS
               X(I) = TEN**X(I)
            ENDDO
            XISLOG = .FALSE.
         ENDIF
         IF (NOPT(4).EQ.1) THEN
            NPAUSE = 0
            DO I = 1, NPTS
               IF (E(I).GT.XTOL) THEN
                  W(I) = ONE/E(I)
               ELSE
                  W(I) = ONE
                  NPAUSE = NPAUSE + 1
               ENDIF
            ENDDO
            IF (NPAUSE.NE.0) THEN
               WRITE (LINE,400) NPAUSE
               CALL PUTWAR (LINE)
            ENDIF
         ELSEIF (NOPT(4).EQ.2) THEN
            RATIO = HUN/PCENT
            NPAUSE = 0
            DO I = 1, NPTS
               IF (ABS(Y(I)).GT.XTOL) THEN
                  W(I) = RATIO/ABS(Y(I))
               ELSE
                  W(I) = ONE
                  NPAUSE = NPAUSE + 1
               ENDIF
            ENDDO
            IF (NPAUSE.NE.0) THEN
               WRITE (LINE,500) NPAUSE
               CALL PUTWAR (LINE)
            ENDIF
         ELSE
            DO I = 1, NPTS
               W(I) = ONE
            ENDDO      
         ENDIF
         DO I = 1, NPTS
            WINV(I) = ONE/W(I)
         ENDDO
         IF (NOPT(3).EQ.1) THEN
            N7 = NDIST/12 + 8
            IF (N7.GT.(NBIG - 30)) N7 = NBIG - 30
         ELSEIF (NOPT(3).EQ.2) THEN
            N7 = NDIST/6 + 8
            IF (N7.GT.(NBIG - 20)) N7 = NBIG - 20
            IF (N7.EQ.8) N7 = 9  
         ELSEIF (NOPT(3).EQ.3) THEN
            N7 = NDIST/3 + 8
            IF (N7.GT.(NBIG - 10)) N7 = NBIG - 10
            IF (N7.EQ.9) N7 = 10  
         ELSE
            N7 = NDIST + 7
         ENDIF
         IF (N7.LT.8) N7 = 8
         IF (N7.GT.(NDIST + 4) .AND. NOPT(3).LT.4) N7 = NDIST + 4
         RETURN
      ENDIF
C
C Here for error exit conditions
C
   40 CONTINUE
      CLOSE (UNIT = NOUT(1))
      CALL PUTFAT ('Data not suitable for calibration curve')
      N7 = 1
      ISTOP(1) = .TRUE.
      ISTOP(2) = .TRUE.
C
C Format statements
C      
  100 FORMAT (/1X,'Analysis number',I3/1X,'------------------')
  200 FORMAT (1X,'File with calibration data is'/1X,A)
  300 FORMAT (1X,'Title of calibration data is'/1X,A/)
  400 FORMAT ('s too small ... w set = 1 at',I5,1X,'data points')
  500 FORMAT ('y too small ... w set = 1 at',I5,1X,'data points')
      END
C
C
      SUBROUTINE DATFIT (ICHECK, INDEX, NCHECK, NMAX, NOPT, NPTS, N7,
     +                   C, CL, CU, FK, W, WINV, WORK1, WORK2, X, XTEMP,
     +                   XTP, Y, YMAX, YMIN, YTEMP, YTP, Z,
     +                   ISTOP, XISLOG)
C
C Fit B-splines
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NCHECK, NMAX
      INTEGER,          INTENT (INOUT) :: N7, NOPT(8), NPTS
      INTEGER,          INTENT (INOUT) :: ICHECK(NCHECK), INDEX(NCHECK)
      DOUBLE PRECISION, INTENT (INOUT) :: C(NMAX), CL(NMAX), CU(NMAX),
     +                                    FK(NMAX)
      DOUBLE PRECISION, INTENT (INOUT) :: W(NPTS), WINV(NPTS),
     +                                    WORK1(NPTS), WORK2(4,N7)
      DOUBLE PRECISION, INTENT (IN)    :: X(NPTS), Y(NPTS), YMAX, YMIN
      DOUBLE PRECISION, INTENT (INOUT) :: XTEMP(NPTS), XTP(NCHECK),
     +                                    YTEMP(NPTS), YTP(NCHECK),
     +                                    Z(NPTS)
      LOGICAL,          INTENT (INOUT) :: ISTOP(2)
      LOGICAL,          INTENT (IN)    :: XISLOG
C
C Locals
C      
      INTEGER    I, IFAIL, J, K, KNOTS, NMID, NMP1
      INTEGER    JCOLOR
      INTEGER    NOUT
      PARAMETER (NOUT = 4)
      DOUBLE PRECISION EPSI, XTOL
      PARAMETER (EPSI = 1.0D-06, XTOL = 1.0D-150)
      DOUBLE PRECISION RKP1, WSSQ, W1, W2, XDIFF, XMAX, XMIN, YDIFF
      DOUBLE PRECISION AVCVPC, FACTOR, SIGEST, TEMP, YABS
      DOUBLE PRECISION ZERO, ONE, TWO, THREE, HUN, FMIN, FMAX, FOUR
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           THREE = 3.0D+00, HUN = 100.0D+00, FMIN = 1.0D+00,
     +           FMAX = 100.0D+00, FOUR = 4.0D+00)
      CHARACTER (LEN = 100) TEXT(30)
      CHARACTER (LEN = 31 ) ADVICE
      CHARACTER (LEN = 13 ) D13(3), SHOWLJ
      LOGICAL    NO, YES
      PARAMETER (NO = .FALSE., YES = .TRUE.)
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    IWARNU, REJECT, WEIGHT
      EXTERNAL   E_FORMATS, SHOWLJ
      EXTERNAL   E02BAF$, E02BBF$
      EXTERNAL   CHECK2
      EXTERNAL   PUTIFA, GKSR01, TABLE1
      EXTERNAL   XVALID
      INTRINSIC  NINT, ABS, SQRT, DBLE
      ISTOP(2) = .TRUE.
      IF (ISTOP(1)) RETURN
      IF (N7.LT.8) RETURN
      IF (NOPT(2).EQ.2 .AND. .NOT.XISLOG) RETURN
      E_NUMBERS = E_FORMATS()  
      NMID = 0
      NMP1 = 0
      RKP1 = ZERO 
      KNOTS = N7 - 8
      IF (KNOTS.GT.0 .AND. NOPT(6).LT.4) THEN
         NMID = 0
         DO I = 2, NPTS
            XDIFF = X(I) - X(I - 1)
            IF (XDIFF.GT.XTOL) THEN
               NMID = NMID + 1
               XTEMP(NMID) = X(I - 1) + XDIFF/TWO
            ENDIF
         ENDDO
         RKP1 = KNOTS + ONE
         NMP1 = NMID + 1
         DO I = 1, KNOTS
            J = NINT((I*NMP1)/RKP1)
            FK(I + 4) = XTEMP(J)
         ENDDO
      ENDIF
      IFAIL = 1
      IF (NOPT(3).EQ.4) THEN 
C
C generalised cross validation
C        
         CALL XVALID (NMAX,
     +                NPTS, N7, X, Y, W, FK, WORK1, WORK2, C, WSSQ,
     +                IFAIL)
         CALL PUTIFA (IFAIL, NOUT, 'XVALID_1/DATFIT')
      ELSE
C
C weighted least squares
C        
         CALL E02BAF$(NPTS, N7, X, Y, W, FK, WORK1, WORK2, C, WSSQ,
     +                IFAIL)
         CALL PUTIFA (IFAIL, NOUT, 'E02BAF_1/DATFIT')
      ENDIF   
      IF (IFAIL.NE.0) RETURN
C
C calculated best-fit points
C        
      DO I = 1, NPTS
         IFAIL = 1
         CALL E02BBF$(N7, FK, C, X(I), Z(I), IFAIL)
         CALL PUTIFA (IFAIL, NOUT, 'E02BBF_1/DATFIT')
         IF (IFAIL.NE.0) RETURN
      ENDDO
      IF (NOPT(3).EQ.4) THEN
         WSSQ = ZERO
         DO I = 1, NPTS
            WSSQ = WSSQ + ((Y(I) - Z(I))*W(I))**2
         ENDDO
      ENDIF      
C
C goodness of fit
C     
      I = 4  
      K = 4
      CALL GKSR01 (I, K, NPTS,
     +             WORK1, WINV, Z, YTEMP, X, Y,
     +             NO, YES, NO, YES, YES)
C
C check for turning points
C     
      XMAX = X(NPTS)
      XMIN = X(1)
      XDIFF = (XMAX - XMIN)/(NCHECK - 1)
      XTP(1) =  XMIN
      YTP(1) =  Z(1)
      DO I = 2, NCHECK - 1
         XTP(I) = XTP(I - 1) + XDIFF
         IFAIL = 1
         CALL E02BBF$(N7, FK, C, XTP(I), YTP(I), IFAIL)
         CALL PUTIFA (IFAIL, NOUT, 'E02BBF_2/DATFIT')
         IF (IFAIL.NE.0) RETURN
      ENDDO
      XTP(NCHECK) = XMAX
      YTP(NCHECK) = Z(NPTS)
      YDIFF = ABS(YMAX - YMIN)
      CALL CHECK2 (ICHECK, INDEX, NCHECK,
     +             XTP, YTP, YDIFF,
     +             REJECT)
      IF (NOPT(4).EQ.1) THEN
         W1 = ONE + EPSI
         W2 = ONE - EPSI
         WEIGHT = .FALSE.
         DO I = 1, NPTS
            IF (W(I).GT.W1 .OR. W(I).LT.W2) THEN
              WEIGHT = .TRUE.
              EXIT
            ENDIF  
         ENDDO
      ELSE
         WEIGHT = .FALSE.   
      ENDIF
      IF (NOPT(4).EQ.3) THEN   
         YABS = ZERO
         DO I = 1, NPTS
            YABS = YABS + ABS(Y(I))
         ENDDO
         YABS = YABS/DBLE(NPTS)
         IF (NPTS.GT.3 .AND. YABS.GT.ZERO) THEN
            SIGEST = SQRT(WSSQ/(NPTS - THREE))
            AVCVPC = HUN*SIGEST/YABS
            IF (AVCVPC.LT.FMIN) THEN
               IWARNU = .TRUE.
               ADVICE = 'Too small ... Use fewer knots ?'
            ELSEIF (AVCVPC.GT.FMAX) THEN
               IWARNU = .TRUE.
               ADVICE = ' Too large ... Use more knots ?'
            ELSE
               IWARNU = .FALSE.
               ADVICE = ' '
            ENDIF
            IF (IWARNU .AND. NOPT(3).LT.4) THEN
               IF (E_NUMBERS) THEN
                  WRITE (TEXT,100) SIGEST**2, SIGEST, YABS, AVCVPC, 
     +                             ADVICE
               ELSE
                  TEMP = SIGEST**2
                  D13(1) = SHOWLJ(TEMP)
                  D13(2) = SHOWLJ(SIGEST)
                  D13(3) = SHOWLJ(YABS)
                  WRITE (TEXT,150) D13(1), D13(2), D13(3), AVCVPC, 
     +                             ADVICE
               ENDIF  
               JCOLOR = 15
               CALL TABLE1 (JCOLOR, 'OPEN')
               DO I = 1, 13
                  IF (I.EQ.2) THEN
                     JCOLOR = 4
                  ELSE
                     JCOLOR = 0
                  ENDIF
                  CALL TABLE1 (JCOLOR, TEXT(I))
               ENDDO
               CALL TABLE1 (JCOLOR, 'CLOSE')
            ENDIF   
         ENDIF
      ENDIF   
      IF (NOPT(6).LE.2) THEN
         FACTOR = FOUR
      ELSEIF (NOPT(6).EQ.3) THEN
         FACTOR = THREE
      ELSEIF (NOPT(6).EQ.4) THEN
         FACTOR = TWO
      ENDIF
      DO I = 1, NPTS
         IF (WEIGHT) THEN
            YTEMP(I) = Y(I) - FACTOR/W(I)
         ELSE
            YTEMP(I) = Y(I) - FACTOR*SIGEST
         ENDIF
      ENDDO
      IFAIL = 1
      IF (NOPT(3).EQ.4) THEN
         CALL XVALID (NMAX,
     +                NPTS, N7, X, YTEMP, W, FK, WORK1, WORK2, CL,
     +                WSSQ, IFAIL) 
         CALL PUTIFA (IFAIL, NOUT, 'XVALID_2/DATFIT')
      ELSE        
         CALL E02BAF$(NPTS, N7, X, YTEMP, W, FK, WORK1, WORK2, CL,
     +                WSSQ, IFAIL)
         CALL PUTIFA (IFAIL, NOUT, 'E02BAF_2/DATFIT')
      ENDIF  
      IF (IFAIL.NE.0) RETURN
      DO I = 1, NPTS
         IF (WEIGHT) THEN
            YTEMP(I) = Y(I) + FACTOR/W(I)
         ELSE
            YTEMP(I) = Y(I) + FACTOR*SIGEST
         ENDIF
      ENDDO
      IFAIL = 1
      IF (NOPT(3).EQ.4) THEN
         CALL XVALID (NMAX,
     +                NPTS, N7, X, YTEMP, W, FK, WORK1, WORK2, CU,
     +                WSSQ, IFAIL)          
         CALL PUTIFA (IFAIL, NOUT, 'XVALID_3/DATFIT')
      ELSE
         CALL E02BAF$(NPTS, N7, X, YTEMP, W, FK, WORK1, WORK2, CU,
     +                WSSQ, IFAIL)
         CALL PUTIFA (IFAIL, NOUT, 'E02BAF_3/DATFIT')
      ENDIF   
      IF (IFAIL.NE.0) RETURN
      ISTOP(2) = .FALSE.
C
C Format statements
C      
  100 FORMAT (
     +/1X,'CAUTION : The program is now in unweighted regression mode.'
     +/
     +/11X,'Do not use too many spline knots with unweighted'
     +/11X,'regression as (sum of squares)/(no. deg. freedom)'
     +/11X,'is used as a variance estimate in calculating the'
     +/11X,'confidence limits. Too many knots will lead to too'
     +/11X,'good a fit and unrealistic confidence limits.'
     +/
     +/11X,'Variance estimate     =',1P,E13.5
     +/11X,'Standard deviation    =',   E13.5
     +/11X,'Average absolute Y    =',   E13.5
     +/11X,'Estimated average CV% =',0P,F8.2,'%',4X,A31)
  150 FORMAT (
     +/1X,'CAUTION : The program is now in unweighted regression mode.'
     +/
     +/11X,'Do not use too many spline knots with unweighted'
     +/11X,'regression as (sum of squares)/(no. deg. freedom)'
     +/11X,'is used as a variance estimate in calculating the'
     +/11X,'confidence limits. Too many knots will lead to too'
     +/11X,'good a fit and unrealistic confidence limits.'
     +/
     +/11X,'Variance estimate     =',1X,A13
     +/11X,'Standard deviation    =',1X,A13
     +/11X,'Average absolute Y    =',1X,A13
     +/11X,'Estimated average CV% =',0P,F8.2,'%',4X,A31)    
      END
C
C
      SUBROUTINE DATOUT (NOPT, NOUT, NPTS, WINV, WORK1, X, XTEMP, Y, Z,
     +                   ISTOP)
C
C Output best-fit B-spline and residuals
C
      IMPLICIT  NONE
      INTEGER   NOPT(8), NOUT(3), NPTS
      INTEGER   I, K
      DOUBLE PRECISION WINV(NPTS), WORK1(NPTS), X(NPTS), XTEMP(NPTS),
     +                 Y(NPTS)
      DOUBLE PRECISION Z(NPTS)
      LOGICAL   ISTOP(2)
      LOGICAL   FILE1, FILE2, GRAPH, TABLE1, TABLE2
      EXTERNAL  PUTFAT, GKSR01
      FILE1 = .FALSE.
      FILE2 = .TRUE.
      GRAPH = .TRUE.
      TABLE1 = .TRUE.
      TABLE2 = .TRUE.
      IF (ISTOP(1)) THEN
         CALL PUTFAT ('Input data before requesting tables')
         RETURN
      ENDIF
      IF (ISTOP(2)) THEN
         CALL PUTFAT ('Curve-fit before requesting tables')
         RETURN
      ENDIF
      IF (NOPT(7).EQ.2) THEN
         FILE1 = .TRUE.
         FILE2 = .TRUE.
         I = NOUT(2)
      ENDIF
      I = 4
      K = 4
      CALL GKSR01 (I, K, NPTS,
     +             WORK1, WINV, Z, XTEMP, X, Y,
     +             FILE1, FILE2, GRAPH, TABLE1, TABLE2)
      END
C
C
