C
C INCLUDE FILE  ...  for CALCURVE
C
C CALCURV2.INS: PLOTIT, PRDXFY, PRDYFX
C =============
C
C
      SUBROUTINE PLOTIT (NGRAF, NOPT, NOUT, NPTS, N7,
     +                   C, CL, CU, FK,
     +                   X, XFIT, XGRAF, XL95, XTEMP, XU95,
     +                   Y, YFIT, YGRAF, YL95, YTEMP, YU95, 
     +                   ISTOP, XISLOG)
C
C Plot best-fit B-spline
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NGRAF, NOPT(8), NOUT(3), NPTS,
     +                                    N7
      DOUBLE PRECISION, INTENT (IN)    :: C(N7), CL(N7), CU(N7), FK(N7),
     +                                    X(NPTS), Y(NPTS)
      DOUBLE PRECISION, INTENT (INOUT) :: XFIT(NGRAF), XGRAF(NGRAF),
     +                                    XL95(NGRAF), XTEMP(NPTS),
     +                                    XU95(NGRAF), YFIT(NGRAF), 
     +                                    YGRAF(NGRAF), YL95(NGRAF),
     +                                    YTEMP(NPTS), YU95(NGRAF)
      LOGICAL,          INTENT (IN)    :: ISTOP(2), XISLOG
C
C Locals
C      
      INTEGER    I, J, K, IFAIL
      INTEGER    L0, L1, L3, L5
      PARAMETER (L0 = 0, L1 = 1, L3 = 3, L5 = 5)
      DOUBLE PRECISION DELTA, XMAX, XMIN
      DOUBLE PRECISION TEN
      PARAMETER (TEN = 10.0D+00)
      CHARACTER (LEN = 60) PTITLE
      CHARACTER (LEN = 6 ) XTITLE, YTITLE
      LOGICAL    CONLIM
      LOGICAL    AXES, SAVEIT
      PARAMETER (AXES = .TRUE., SAVEIT = .TRUE.)
      EXTERNAL   E02BBF$
      EXTERNAL   PUTFAT, GKS004, PUTIFA
      INTRINSIC  LOG10, DBLE
      IF (ISTOP(1)) THEN
         CALL PUTFAT ('Input data before requesting graphs')
         RETURN
      ENDIF
      IF (ISTOP(2)) THEN
         CALL PUTFAT ('Curve-fit before requesting graphs')
         RETURN
      ENDIF
      IF (NOPT(5).EQ.1) THEN
         PTITLE = 'y against x'
         XTITLE = 'x'
         YTITLE = 'y'
      ELSE
         PTITLE = 'y(x)+confidence limits'
         XTITLE = 'x'
         YTITLE = 'y'
      ENDIF
      XMAX = X(NPTS)
      XMIN = X(1)
      DELTA = (XMAX - XMIN)/DBLE(NGRAF - 1)
      XGRAF(1) = XMIN
      DO I = 2, NGRAF - 1
         XGRAF(I) = XGRAF(I - 1) + DELTA
      ENDDO
      XGRAF(NGRAF) = XMAX
      IF (NOPT(5).EQ.1) THEN
         CONLIM = .FALSE.
      ELSE
         CONLIM = .TRUE.
      ENDIF
      DO I = 1, NGRAF
         IF (XGRAF(I).LE.X(1)) XGRAF(I) = X(1)
         IF (XGRAF(I).GE.X(NPTS)) XGRAF(I) = X(NPTS)
         IFAIL = 1
         CALL E02BBF$(N7, FK, C, XGRAF(I), YGRAF(I), IFAIL)
         CALL PUTIFA (IFAIL, NOUT(2), 'E02BBF_1/PLOTIT')
         IF (IFAIL.NE.0) RETURN
         IF (CONLIM) THEN
            IFAIL = 1
            CALL E02BBF$(N7, FK, CL, XGRAF(I), YL95(I), IFAIL)
            CALL PUTIFA (IFAIL, NOUT(2), 'E02BBF_2/PLOTIT')
            IF (IFAIL.NE.0) RETURN
            IFAIL = 1
            CALL E02BBF$(N7, FK, CU, XGRAF(I), YU95(I), IFAIL)
            CALL PUTIFA (IFAIL, NOUT(2), 'E02BBF_3/PLOTIT')
            IF (IFAIL.NE.0) RETURN
         ENDIF
      ENDDO
      DO I = 1, NPTS
         XTEMP(I) = X(I)
         IF (XISLOG) XTEMP(I) = TEN**XTEMP(I)
         YTEMP(I) = Y(I)
      ENDDO
      J = 0
      K = 0
      DO I = 1, NGRAF
         XFIT(I) = XGRAF(I)
         IF (XISLOG) XFIT(I) = TEN**XFIT(I)
         YFIT(I) = YGRAF(I)
         J = J + 1
         K = K + 1
         XL95(J) = XFIT(I)
         XU95(K) = XFIT(I)
      ENDDO
      IF (J.NE.NGRAF .OR. K.NE.NGRAF) THEN
         CALL PUTFAT ('Some values too large/small ... Points omitted')
         IF (J.LT.2) THEN
            J = 2
            XL95(1) = XFIT(1)
            XL95(2) = XFIT(1)
            YL95(1) = YFIT(1)
            YL95(2) = YFIT(1)
         ENDIF
         IF (K.LT.2) THEN
            K = 2
            XU95(1) = XFIT(1)
            XU95(2) = XFIT(1)
            YU95(1) = YFIT(1)
            YU95(2) = YFIT(1)
         ENDIF
      ENDIF
      IF (CONLIM) THEN
         CALL GKS004 (L0, L1, L3, L3,
     +                L5, L0, L0, L0,
     +                NPTS, NGRAF, J, K,
     +                XTEMP, XFIT, XL95, XU95,
     +                YTEMP, YFIT, YL95, YU95, 
     +                PTITLE, XTITLE, YTITLE,
     +                AXES, SAVEIT)
      ELSE
         CALL GKS004 (L0, L1, L0, L0, 
     +                L5, L0, L0, L0,
     +                NPTS, NGRAF, J, K,
     +                XTEMP, XFIT, XL95, XU95, 
     +                YTEMP, YFIT, YL95, YU95,
     +                PTITLE, XTITLE, YTITLE,
     +                AXES, SAVEIT)
      ENDIF
      END
C
C
      SUBROUTINE PRDXFY (NHUGE, NOPT, NOUT, NPTS, N7,
     +                   C, CL, CU,
     +                   FK, X, XL, XPRED, XU, YMAX, YMIN, YPRED, YTRY,
     +                   FNAME, LL, SYMBOL, TITLE, UL, 
     +                   ISTOP, XISLOG)
C
C Predict X given Y
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NHUGE, NOPT(8), NOUT(3),
     +                                       NPTS, N7
      DOUBLE PRECISION,    INTENT (IN)    :: C(N7), CL(N7), CU(N7),
     +                                       FK(N7),
     +                                       X(NPTS), YMAX, YMIN
      DOUBLE PRECISION,    INTENT (INOUT) :: XL(NHUGE), XPRED(NHUGE),
     +                                       XU(NHUGE), YPRED(NHUGE),
     +                                       YTRY(NHUGE)
      CHARACTER (LEN = *), INTENT (IN)    :: FNAME, TITLE
      CHARACTER (LEN = *), INTENT (INOUT) :: LL(NHUGE), SYMBOL(NHUGE)
C
C Locals
C      
      INTEGER    I, IFAIL, IND, IR, J, K, NPRED, NTRY
      INTEGER    JCOLOR
      DOUBLE PRECISION FUNC
      DOUBLE PRECISION FX, F1, F2, TOLX, WORK(17), XHALF, XMAX, XMIN,
     +                 X1, X2
      DOUBLE PRECISION FACTOR, YP, TEMP
      DOUBLE PRECISION ZERO, HALF, TEN, EPSI
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, TEN = 10.0D+00,
     +           EPSI = 1.0D-04)
      DOUBLE PRECISION FBIG, FMID, FSMALL
      PARAMETER (FBIG = 0.15D+00, FMID = 0.075D+00, FSMALL = 0.025D+00)
      CHARACTER (LEN = 1024) FNAMEP
      CHARACTER (LEN = 100 ) LINE, TEXT(30)
      CHARACTER (LEN = 80  ) TITLEP, TRIM80, WORD80
      CHARACTER (LEN = 13  ) D13(4), SHOWRJ
      CHARACTER (LEN = 11  ) CAL
      CHARACTER (LEN = 10  ) PRD
      PARAMETER (CAL = 'Calibration', PRD = 'Prediction')
      CHARACTER (LEN = 10  ) BAD, GOOD, INDIF, UL(NHUGE)
      PARAMETER (BAD = '** Discard', GOOD = ' ',
     +           INDIF = '** Caution')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ISTOP(2), XISLOG
      LOGICAL    FIXNPT, LABEL
      PARAMETER (FIXNPT = .FALSE., LABEL = .TRUE.)
      LOGICAL    ABORT, HRDCPY
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   FUNC
      EXTERNAL   C05AZF$
      EXTERNAL   PUTFAT, VEC1IN, TABLE1, TRIM80, GETVEC, GETJM1
      INTRINSIC  ABS
C
C Check current state
C
      IF (ISTOP(1)) THEN
         CALL PUTFAT ('Input data before predicting')
         RETURN
      ENDIF
      IF (ISTOP(2)) THEN
         CALL PUTFAT ('Curve-fit before predicting')
         RETURN
      ENDIF
      E_NUMBERS = E_FORMATS()
C      
C Read in data
C
      HRDCPY = .FALSE.
      IF (NOPT(7).EQ.2) THEN
         HRDCPY = .TRUE.
         J = NOUT(2)
      ENDIF
      XMAX = X(NPTS)
      XMIN = X(1)
      XHALF = HALF*(XMAX + XMIN)
      IF (NOPT(1).EQ.1) THEN
         I = 2
         K = NOUT(1)
         CLOSE (UNIT = K)
         CALL VEC1IN (I, K, NHUGE, NTRY, YTRY, FNAMEP, TITLEP,
     +                ABORT, FIXNPT, LABEL)
         IF (ABORT .OR. NTRY.LT.1) RETURN
      ELSE
         I = 0
         K = 50
         NTRY = 1
         CALL GETJM1 (I, NTRY, K, 'Number of values required')
         IF (NTRY.GT.0) CALL GETVEC (NTRY, YTRY,
     +                               'Input y to predict x')
         FNAMEP = 'No file'
         TITLEP = 'Values typed in'
         IF (NTRY.LT.1) RETURN
      ENDIF
     
C
C Data OK so set background colour to 15 then check if y is in range
C
      JCOLOR = 15
      CALL TABLE1 (JCOLOR, 'OPEN')
      JCOLOR = 4
      NPRED = 0
      DO I = 1, NTRY
         IF (YTRY(I).GT.YMAX .OR. YTRY(I).LT.YMIN) THEN
            WRITE (LINE,300) I
            CALL TABLE1 (JCOLOR, LINE)
            IF (HRDCPY) WRITE (J,300) I
         ELSE
            NPRED = NPRED + 1
            YPRED(NPRED) = YTRY(I)
         ENDIF
      ENDDO
C
C Return if no values in range
C
      IF (NPRED.LT.1) THEN
         CALL TABLE1 (JCOLOR, 'CLOSE')
         RETURN
      ENDIF
C
C Carry on since some y-values are in range, i.e. NPRED > 0
C
      DO I = 1, NPRED
         X1 = XMIN
         X2 = XMAX
         YP = YPRED(I)
         F1 = FUNC(N7, C, FK, X1, YP)
         F2 = FUNC(N7, C, FK, X2, YP)
         IF (F1*F2.GT.ZERO) THEN
            IFAIL = 0
            IND = 0
            GOTO 30
         ENDIF
         TOLX = EPSI
         IR = 0
         IND = 1
         IFAIL = 1
   10    CONTINUE
         CALL C05AZF$(X1, X2, FX, TOLX, IR, WORK, IND, IFAIL)
         IF (IND.EQ.0) GOTO 20
         IF (IND.LT.2 .OR. IND.GT.4) GOTO 30
         FX = FUNC (N7, C, FK, X1, YP)
         GOTO 10
   20    CONTINUE
         XPRED(I) = X1
         SYMBOL(I) = GOOD
         GOTO 40
   30    CONTINUE
         WRITE (LINE,400) I
         CALL TABLE1 (JCOLOR, LINE)
         IF (HRDCPY) WRITE (J,400) I
         XPRED(I) = XHALF
         SYMBOL(I) = BAD
   40    CONTINUE
         IF (XPRED(I).LT.XMIN .OR. XPRED(I).GT.XMAX) THEN
            WRITE (LINE,500) I
            CALL TABLE1 (JCOLOR, LINE)
            IF (HRDCPY) WRITE (J,500) I
            SYMBOL(I) = INDIF
         ENDIF
         IF (IFAIL.NE.0 .OR. IND.NE.0) THEN
            WRITE (LINE,600) IFAIL, IND, I
            CALL TABLE1 (JCOLOR, LINE)
            IF (HRDCPY) WRITE (J,600) IFAIL, IND, I
            SYMBOL(I) = BAD
         ENDIF
      ENDDO
C
C Calculation of XPRED completed ... Output starts
C
      IF (NOPT(6).EQ.1) THEN
C
C Output of header where there are no confidence limits
C
         JCOLOR = 0
         IF (NOPT(1).LT.3) THEN
            WORD80 = TRIM80(FNAME)
            WRITE (TEXT,700) CAL, WORD80
            CALL TABLE1 (JCOLOR, TEXT(1))
            CALL TABLE1 (JCOLOR, TEXT(2))
         ENDIF
         WRITE (TEXT,800) CAL, TITLE
         CALL TABLE1 (JCOLOR, TEXT(1))
         CALL TABLE1 (JCOLOR, TEXT(2))
         IF (NOPT(1).EQ.1) THEN
            WORD80 = TRIM80(FNAMEP)
            WRITE (TEXT,700) PRD, WORD80
            CALL TABLE1 (JCOLOR, TEXT(1))
            CALL TABLE1 (JCOLOR, TEXT(2))
         ENDIF
         WRITE (TEXT,800) PRD, TITLEP
         CALL TABLE1 (JCOLOR, TEXT(1))
         CALL TABLE1 (JCOLOR, TEXT(2))
         JCOLOR = 4
         WRITE (LINE,900)
         JCOLOR = 4
         CALL TABLE1 (JCOLOR, LINE)
         JCOLOR = 0
         IF (HRDCPY) THEN
            WORD80 = TRIM80(FNAMEP)
            IF (NOPT(1).EQ.1) WRITE (J,700) PRD, WORD80
            WRITE (J,800) PRD, TITLEP
            WRITE (J,900)
         ENDIF
C
C Main output loop for no confidence limits
C
         JCOLOR = 0
         DO I = 1, NPRED
            IF (XISLOG) THEN
               IF (E_NUMBERS) THEN
                  WRITE (LINE,1000) YPRED(I), TEN**XPRED(I), SYMBOL(I)
                  IF (HRDCPY) WRITE (J,1000) YPRED(I), TEN**XPRED(I),
     +                                       SYMBOL(I)
               ELSE
                  D13(1) = SHOWRJ(YPRED(I))
                  TEMP = TEN**XPRED(I)
                  D13(2) = SHOWRJ(TEMP)
                   WRITE (LINE,1050) D13(1), D13(2), SYMBOL(I)
                  IF (HRDCPY) WRITE (J,1050) D13(1), D13(2),
     +                                       SYMBOL(I)
               ENDIF  
            ELSE
               IF (E_NUMBERS) THEN
                  WRITE (LINE,1000) YPRED(I), XPRED(I), SYMBOL(I)
                  IF (HRDCPY) WRITE (J,1000) YPRED(I), XPRED(I), 
     +                        SYMBOL(I)
               ELSE
                  D13(1) = SHOWRJ(YPRED(I))
                  D13(2) = SHOWRJ(XPRED(I))
                  WRITE (LINE,1050) D13(1), D13(2), SYMBOL(I)
                  IF (HRDCPY) WRITE (J,1050) D13(1), D13(2), 
     +                        SYMBOL(I)
               ENDIF  
            ENDIF
            CALL TABLE1 (JCOLOR, LINE)
         ENDDO
C
C Output when there are confidence limits ... extra calculations required
C
      ELSE
         IF (NOPT(6).EQ.2) THEN
            FACTOR = FBIG
         ELSEIF (NOPT(6).EQ.3) THEN
            FACTOR = FMID
         ELSE
            FACTOR = FSMALL
         ENDIF
         JCOLOR = 0
         DO K = 1, 2
            DO I = 1, NPRED
               X1 = XMIN
               X2 = XMAX
               IF (K.EQ.1) THEN
                  YP = YPRED(I) + FACTOR*ABS(YPRED(I))
                  F1 = FUNC(N7, CL, FK, X1, YP)
                  F2 = FUNC(N7, CL, FK, X2, YP)
               ELSE
                  YP = YPRED(I) - FACTOR*ABS(YPRED(I))
                  F1 = FUNC(N7, CU, FK, X1, YP)
                  F2 = FUNC(N7, CU, FK, X2, YP)
               ENDIF
               IF (F1*F2.GT.ZERO) THEN
                  IFAIL = 0
                  IND = 0
                  GOTO 80
               ENDIF
               TOLX = EPSI
               IR = 0
               IND = 1
               IFAIL = 1
   60          CONTINUE
               CALL C05AZF$(X1, X2, FX, TOLX, IR, WORK, IND, IFAIL)
               IF (IND.EQ.0) GOTO 70
               IF (IND.LT.2 .OR. IND.GT.4) GOTO 80
               IF (K.EQ.1) THEN
                  FX = FUNC(N7, CL, FK, X1, YP)
               ELSE
                  FX = FUNC(N7, CU, FK, X1, YP)
               ENDIF
               GOTO 60
   70          CONTINUE
               IF (K.EQ.1) THEN
                  XL(I) = X1
                  LL(I) = GOOD
               ELSE
                  XU(I) = X1
                  UL(I) = GOOD
               ENDIF
               GOTO 90
   80          CONTINUE
               WRITE (LINE,1100) I
               CALL TABLE1 (JCOLOR, LINE)
               IF (HRDCPY) WRITE (J,1100) I
               IF (K.EQ.1) THEN
                  XL(I) = XMAX
                  LL(I) = BAD
               ELSE
                  XU(I) = XMIN
                  UL(I) = BAD
               ENDIF
   90          CONTINUE
               IF (K.EQ.1) THEN
                  IF (XL(I).LT.XMIN .OR. XL(I).GT.XMAX) THEN
                     WRITE (LINE,1100) I
                     CALL TABLE1 (JCOLOR, LINE)
                     IF (HRDCPY) WRITE (J,1100) I
                     LL(I) = INDIF
                  ENDIF
               ELSE
                  IF (XU(I).LT.XMIN .OR. XU(I).GT.XMAX) THEN
                     WRITE (LINE,1100) I
                     CALL TABLE1 (JCOLOR, LINE)
                     IF (HRDCPY) WRITE (J,1100) I
                     UL(I) = INDIF
                  ENDIF
               ENDIF
               IF (IFAIL.NE.0 .OR. IND.NE.0 ) THEN
                  WRITE (LINE,1100) I
                  CALL TABLE1 (JCOLOR, LINE)
                  IF (HRDCPY) WRITE (J,1100) I
                  IF (K.EQ.1) THEN
                     XL(I) = XMIN
                     LL(I) = BAD
                  ELSE
                     XU(I) = XMAX
                     UL(I) = BAD
                  ENDIF
               ENDIF
            ENDDO
         ENDDO
C
C Output header where confidence limits
C
         JCOLOR = 0
         IF (NOPT(1).LT.3) THEN
            WORD80 = TRIM80(FNAME)
            WRITE (TEXT,700) CAL, WORD80
            CALL TABLE1 (JCOLOR, TEXT(1))
            CALL TABLE1 (JCOLOR, TEXT(2))
         ENDIF
         WRITE (TEXT,800) CAL, TITLE
         CALL TABLE1 (JCOLOR, TEXT(1))
         CALL TABLE1 (JCOLOR, TEXT(2))
         IF (NOPT(1).EQ.1) THEN
            WORD80 = TRIM80(FNAMEP)
            WRITE (TEXT,700) PRD, WORD80
            CALL TABLE1 (JCOLOR, TEXT(1))
            CALL TABLE1 (JCOLOR, TEXT(2))
         ENDIF
         WRITE (TEXT,800) PRD, TITLEP
         CALL TABLE1 (JCOLOR, TEXT(1))
         CALL TABLE1 (JCOLOR, TEXT(2))
         WRITE (LINE,1200)
         JCOLOR = 4
         CALL TABLE1 (JCOLOR, LINE)
         JCOLOR = 0
         IF (HRDCPY) THEN
            WORD80 = TRIM80(FNAMEP)
            IF (NOPT(1).EQ.1) WRITE (J,700) PRD, WORD80
            WRITE (J,800) PRD, TITLEP
            WRITE (J,1200)
         ENDIF
C
C Main output loop where confidence limits
C
         JCOLOR = 0
         DO I = 1, NPRED
            IF (XISLOG) THEN
               IF (E_NUMBERS) THEN
                  WRITE (LINE,1300) YPRED(I), TEN**XPRED(I), SYMBOL(I),
     +                           TEN**XU(I), UL(I), TEN**XL(I), LL(I)
                  IF (HRDCPY) WRITE (J,1300) YPRED(I), TEN**XPRED(I),
     +                SYMBOL(I), TEN**XU(I), UL(I), TEN**XL(I), LL(I)
               ELSE
                  D13(1) = SHOWRJ(YPRED(I))
                  TEMP = TEN**XPRED(I)
                  D13(2) = SHOWRJ(TEMP)
                  TEMP = TEN**XU(I)
                  D13(3) = SHOWRJ(TEMP)
                  TEMP = TEN**XL(I)
                  D13(4) = SHOWRJ(TEMP)
                  WRITE (LINE,1350) D13(1), D13(2), SYMBOL(I),
     +                              D13(3), UL(I), D13(4), LL(I)
                  IF (HRDCPY) WRITE (J,1350) D13(1), D13(2),
     +                SYMBOL(I), D13(3), UL(I), D13(4), LL(I)
               ENDIF  
            ELSE
               IF (E_NUMBERS) THEN
                   WRITE (LINE,1300) YPRED(I), XPRED(I), SYMBOL(I),
     +                               XU(I), UL(I), XL(I), LL(I)
                   IF (HRDCPY) WRITE (J,1300) YPRED(I), XPRED(I),
     +                                        SYMBOL(I), XU(I), UL(I), 
     +                                        XL(I), LL(I)
               ELSE
                  D13(1) = SHOWRJ(YPRED(I))
                  D13(2) = SHOWRJ(XPRED(I))
                  D13(3) = SHOWRJ(XU(I))
                  D13(4) = SHOWRJ(XL(I))
                  WRITE (LINE,1350) D13(1), D13(2), SYMBOL(I),
     +                               D13(3), UL(I), D13(4), LL(I)
                  IF (HRDCPY) WRITE (J,1350) D13(1), D13(2),
     +                                       SYMBOL(I), D13(3), UL(I), 
     +                                       D13(4), LL(I)
               ENDIF  
            ENDIF
            CALL TABLE1 (JCOLOR, LINE)
         ENDDO
      ENDIF
      CALL TABLE1 (JCOLOR, 'CLOSE')
C
C Format statments
C      
  300 FORMAT (1X,'*FATAL* : y(',I4,') discarded ... Out of range')
  400 FORMAT (1X,'*FATAL* : Prediction',I5,1X,'unreliable ... Check')
  500 FORMAT (1X,'*FATAL* : x(',I4,') out of range')
  600 FORMAT (1X,'*FATAL* : IFAIL =',I2,1X,'IND =',I3,1X,
     +'C05AZF/PRDXFY',1X,'at prediction',I5)
  700 FORMAT (1X,A,1X,'file:'/1X,A)
  800 FORMAT (1X,A,1X,'title:'/1X,A)
  900 FORMAT (4X,' y-measured',4X,'x-predicted')
 1000 FORMAT (2X,1P,E13.5,2X,E13.5,A10)
 1050 FORMAT (2X,   A13  ,2X,A13,  A10)
 1100 FORMAT (1X,'WARNING : Ignore 95% con. lim. at prediction',I5)
 1200 FORMAT (2X,' y-measured  x-predicted',11X,'  Lower95%cl',12X,
     +' Upper95%cl')
 1300 FORMAT (1P,2E13.5,A10,E13.5,A10,E13.5,A10)
 1350 FORMAT (1P,2A13  ,A10,A13  ,A10,A13  ,A10)
      END
C
C
      SUBROUTINE PRDYFX (NHUGE, NOPT, NOUT, NPTS, N7,
     +                   C, CL, CU, FK, X, XPRED, XTRY, YL, YPRED, YU,
     +                   ISTOP, XISLOG)
C
C Evaluate Y given X
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NHUGE, NOPT(8), NOUT(3), NPTS,
     +                                    N7
      DOUBLE PRECISION, INTENT (IN)    :: C(N7), CL(N7), CU(N7), FK(N7),
     +                                    X(NPTS)
      DOUBLE PRECISION, INTENT (INOUT) :: XPRED(NHUGE), XTRY(NHUGE),
     +                                    YL(NHUGE), YPRED(NHUGE),
     +                                    YU(NHUGE)
      LOGICAL,          INTENT (IN)    :: ISTOP(2), XISLOG
C
C locals
C      
      INTEGER    I, IFAIL, J, K, NPRED, NTRY
      INTEGER    JCOLOR
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4)
      DOUBLE PRECISION TEMP, XMAX, XMIN
      DOUBLE PRECISION ZERO, ONE, TEN
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TEN = 10.0D+00)
      CHARACTER (LEN = 1024) FNAMEP 
      CHARACTER (LEN = 100 ) LINE
      CHARACTER (LEN = 80  ) TITLEP, TRIM80, WORD80
      CHARACTER (LEN = 13  ) D13(4), SHOWRJ
      CHARACTER (LEN = 11  ) EVA
      PARAMETER (EVA = ' evaluation')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    FIXNPT, LABEL
      PARAMETER (FIXNPT = .FALSE., LABEL = .TRUE.)
      LOGICAL    ABORT, HRDCPY, YES
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   E02BBF$
      EXTERNAL   PUTFAT, VEC1IN, TABLE1, YESNO2, TRIM80, GETJM1, GETVEC
      INTRINSIC  LOG10
C
C Check if ready
C
      IF (ISTOP(1)) THEN
         CALL PUTFAT ('Input data before evaluating')
         RETURN
      ENDIF
      IF (ISTOP(2)) THEN
         CALL PUTFAT ('Curve-fit before evaluating')
         RETURN
      ENDIF
      E_NUMBERS = E_FORMATS()
C
C Check if ok then read in data
C
      WRITE (LINE,300)
      YES = .FALSE.
      CALL YESNO2 (ICOLOR, IX, IY, LINE, YES)
      IF (.NOT.YES) RETURN
      HRDCPY = .FALSE.
      IF (NOPT(7).EQ.2) THEN
          HRDCPY = .TRUE.
          J = NOUT(2)
      ENDIF
      XMAX = X(NPTS)
      XMIN = X(1)
      IF (NOPT(1).EQ.1) THEN
         I = 2
         K = NOUT(1)
         CLOSE (UNIT = K)
         CALL VEC1IN (I, K, NHUGE, NTRY, XTRY, 
     +                FNAMEP, TITLEP,
     +                ABORT, FIXNPT, LABEL)
         IF (ABORT .OR. NTRY.LT.1) RETURN
      ELSE
         I = 0
         K = 50
         NTRY = 1
         CALL GETJM1 (I, NTRY, K, 'Number of values required')
         IF (NTRY.GT.0) CALL GETVEC (NTRY, XTRY,
     +                               'Input x to evaluate y') 
         FNAMEP = 'No file'
         TITLEP = 'Values typed in'
         IF (NTRY.LT.1) RETURN           
      ENDIF
      JCOLOR = 15
      CALL TABLE1 (JCOLOR, 'OPEN')
      JCOLOR = 0
      NPRED = 0
      DO I = 1, NTRY
         IF (XISLOG) THEN
            IF (XTRY(I).GT.ZERO) THEN
               XTRY(I) = LOG10(XTRY(I))
            ELSE
               XTRY(I) = XMIN - ONE
            ENDIF
         ENDIF
         IF (XTRY(I).GT.XMAX .OR. XTRY(I).LT.XMIN) THEN
            WRITE (LINE,400) I
            CALL TABLE1 (JCOLOR, LINE)
            IF (HRDCPY) WRITE (J,400) I
         ELSE
            NPRED = NPRED + 1
            XPRED(NPRED) = XTRY(I)
         ENDIF
      ENDDO
      IF (NPRED.LT.1) THEN
         CALL TABLE1 (JCOLOR, 'CLOSE')
         RETURN
      ENDIF
      DO I = 1, NPRED
         IFAIL = 1
         CALL E02BBF$(N7, FK, C, XPRED(I), YPRED(I), IFAIL)
         IF (IFAIL.NE.0) THEN
            WRITE (LINE,500) IFAIL, I
            CALL TABLE1 (JCOLOR, LINE)
         ENDIF
         IF (NOPT(6).GT.1) THEN
            IFAIL = 1
            CALL E02BBF$(N7, FK, CL, XPRED(I), YL(I), IFAIL)
            IF (IFAIL.NE.0) THEN
               WRITE (LINE,500) IFAIL, I
               CALL TABLE1 (JCOLOR, LINE)
            ENDIF
            IFAIL = 1
            CALL E02BBF$(N7, FK, CU, XPRED(I), YU(I), IFAIL)
            IF (IFAIL.NE.0) THEN
               WRITE (LINE,500) IFAIL, I
               CALL TABLE1 (JCOLOR, LINE)
            ENDIF
         ENDIF
      ENDDO
      IF (HRDCPY) THEN
         WORD80 = TRIM80(FNAMEP)
         IF (NOPT(1).EQ.1) WRITE (J,600) EVA, WORD80
         WRITE (J,700) EVA, TITLEP
      ENDIF
      IF (NOPT(6).EQ.1) THEN
         WRITE (LINE,800)
         JCOLOR = 4
         CALL TABLE1 (JCOLOR, LINE)
         JCOLOR = 0
         IF (HRDCPY) WRITE (J,800)
         DO I = 1, NPRED
            IF (XISLOG) THEN
               IF (E_NUMBERS) THEN
                  WRITE (LINE,900) TEN**XPRED(I), YPRED(I)
                  IF (HRDCPY) WRITE (J,900) TEN**XPRED(I), YPRED(I)
               ELSE
                  TEMP = TEN**XPRED(I)
                  D13(1) = SHOWRJ(TEMP)
                  D13(2) = SHOWRJ(YPRED(I)) 
                  WRITE (LINE,950) D13(1), D13(2)
                  IF (HRDCPY) WRITE (J,950) D13(1), D13(2)
               ENDIF  
            ELSE
               IF (E_NUMBERS) THEN
                  WRITE (LINE,900) XPRED(I), YPRED(I)
                  IF (HRDCPY) WRITE (J,900) XPRED(I), YPRED(I)
               ELSE
                  D13(1) = SHOWRJ(XPRED(I))
                  D13(2) = SHOWRJ(YPRED(I))	
                  WRITE (LINE,950) D13(1), D13(2)
                  IF (HRDCPY) WRITE (J,950) D13(1), D13(2)
               ENDIF          
            ENDIF
            CALL TABLE1 (JCOLOR, LINE)
         ENDDO
      ELSE
         WRITE (LINE,1000)
         JCOLOR = 4
         CALL TABLE1 (JCOLOR, LINE)
         JCOLOR = 0
         IF (HRDCPY) WRITE (J,1000)
         DO I = 1, NPRED
            IF (XISLOG) THEN
               IF (E_NUMBERS) THEN
                  WRITE (LINE,1100) TEN**XPRED(I), YPRED(I), YL(I),
     +                              YU(I)
                  IF (HRDCPY) WRITE (J,1100) TEN**XPRED(I), YPRED(I),
     +                                    YL(I), YU(I)
               ELSE
                  TEMP = TEN**XPRED(I)
                  D13(1) = SHOWRJ(TEMP)
                  D13(2) = SHOWRJ(YPRED(I))
                  D13(3) = SHOWRJ(YL(I))
                  D13(4) = SHOWRJ(YU(I))  
                  WRITE (LINE,1150) D13(1), D13(2), D13(3), D13(4)
                  IF (HRDCPY) WRITE (J,1150) D13(1), D13(2), D13(3),
     +                                       D13(4)
               ENDIF  
            ELSE
               IF (E_NUMBERS) THEN
                  WRITE (LINE,1100) XPRED(I), YPRED(I), YL(I), YU(I)
                  IF (HRDCPY) WRITE (J,1100) XPRED(I), YPRED(I), YL(I),
     +                                       YU(I)
               ELSE
                  D13(1) = SHOWRJ(XPRED(I))
                  D13(2) = SHOWRJ(YPRED(I))
                  D13(3) = SHOWRJ(YL(I))
                  D13(4) = SHOWRJ(YU(I))
                  WRITE (LINE,1150) D13(1), D13(2), D13(3), D13(4)
                  IF (HRDCPY) WRITE (J,1150) D13(1), D13(2), D13(3), 
     +                                       D13(4)
               ENDIF  
            ENDIF
            CALL TABLE1 (JCOLOR, LINE)
         ENDDO
      ENDIF
      CALL TABLE1 (JCOLOR, 'CLOSE')
C
C Format statements
C      
  300 FORMAT (
     +'Proceed to evaluate y = f(x) ... Is this correct ? (usually no)')
  400 FORMAT (1X,'*FATAL* : x(',I4,') discarded ... Out of range')
  500 FORMAT (1X,'*FATAL* : IFAIL =',I2,1X,'from E02BBF/PRDYFX',1X,
     +'at evaluation',I5,1X,'Check data')
  600 FORMAT (1X,'File with',1X,A11,1X,'data is'/1X,A)
  700 FORMAT (1X,'Title of',1X,A11,1X,'data is'/1X,A)
  800 FORMAT (4X,' x-chosen',6X,'y-evaluated')
  900 FORMAT (2X,1P,E13.5,2X,E13.5)
  950 FORMAT (2X,   A13  ,2X,A13)
 1000 FORMAT (2X,' x-chosen',4X,'y-evaluated',10X,'  Lower95%cl',11X,
     +' Upper95%cl')
 1100 FORMAT (1P,2E13.5,9X,E13.5,9X,E13.5)
 1150 FORMAT (   2A13  ,9X,A13  ,9X,A13)   
      END
C
C