C
C INCLUDE FILE ...  for CALCURVE
C
C CALCURV3.INS: SETSUP, CALCFG, XVALID
C ============
C
      SUBROUTINE SETSUP (NOPT, NOUT, NSET, N7,
     +                   PCENT,
     +                   TEXT_SAV,
     +                   ISTOP, XPERT)
C
C NSET = 0 ... restore defaults that have been altered outside of XPERT mode
C NSET = 1 ... Initialise default options on start-up
C NSET = 2 ... Change current options
C NSET = 3 ... Re-define current option deacriptions from anywhere in the program
C NSET = 4 ... Close down and display name of results file if present at end of run
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NOUT(3)   
      INTEGER,             INTENT (INOUT) :: NOPT(8), NSET, N7  
      DOUBLE PRECISION,    INTENT (INOUT) :: PCENT
      CHARACTER (LEN = *), INTENT (INOUT) :: TEXT_SAV(*)
      LOGICAL,             INTENT (INOUT) :: ISTOP(2), XPERT
C
C Locals
C      
      INTEGER    I, ISAV(5)
      INTEGER    N8
      PARAMETER (N8 = 8)
      INTEGER    NOPT_SAV(N8)
      DOUBLE PRECISION PCENT_SAV
      DOUBLE PRECISION PMAX, PMIN
      CHARACTER (LEN = 1024) DFILE
      CHARACTER (LEN = 100 ) LINE, TEMP(30)
      CHARACTER (LEN = 51  ) TEXT1, TEXT2
      CHARACTER (LEN = 9   ) CIPHER, MODE, OPTION(N8)
      CHARACTER (LEN = 1   ) BLANK
      PARAMETER (BLANK = ' ', CIPHER = '***')
      LOGICAL    ABORT, EXIST
      LOGICAL    FIRST
      EXTERNAL   PUTADV, GETDM1, FNAMES, RESFIL
      EXTERNAL   CALCCFG
      SAVE       NOPT_SAV
      SAVE       PCENT_SAV
      SAVE       DFILE, EXIST, FIRST
      DATA       PCENT_SAV / 7.5D+00 /
      DATA       NOPT_SAV / 2, 1, 4, 3, 1, 1, 2, 2 /
      DATA       FIRST / .TRUE. /
      DATA       EXIST / .FALSE. /
C
C Part 1: Define or re-define options if 0 =< NSET =< 4 
C ------
C      
      IF (NSET.EQ.0) THEN
C
C NSET = 0: Restore configured values to cancel XPERT mode
C        
         IF (.NOT.XPERT) THEN
            DO I = 1, N8
               NOPT(I) = NOPT_SAV(I)
            ENDDO   
            PCENT = PCENT_SAV
         ENDIF   
         ISTOP(2) = .TRUE.
      ELSEIF (NSET.EQ.1) THEN
C
C NSET = 1: Initialise 
C      
         PCENT = 7.5D+00
         NOPT(1) = 2
         NOPT(2) = 1
         NOPT(3) = 4
         NOPT(4) = 3
         NOPT(5) = 1
         NOPT(6) = 1
         NOPT(7) = 2
         NOPT(8) = 2
         PCENT_SAV = PCENT
         DO I = 1, N8
            NOPT_SAV(I) = NOPT(I)
         ENDDO   
         ISTOP(1) = .TRUE.
         ISTOP(2) = .TRUE.
         N7 = 1
         IF (FIRST) THEN
            FIRST = .FALSE.
            CLOSE (UNIT = NOUT(2)) 
            CALL RESFIL (NOUT(2),
     +                   DFILE,
     +                   ABORT)    
            IF (ABORT) THEN
               CALL PUTADV ('Results file cannot be opened')
            ELSE
               EXIST = .TRUE.
               WRITE (NOUT(2),100)
            ENDIF
         ELSE
            CALL PUTADV ('Error 1 in call to SETSUP')
         ENDIF  
      ELSEIF (NSET.EQ.2) THEN 
C
C NSET = 2: configure, re-define NOPT_SAV and PCENT_SAV, and check if re-fit is required
C      
         DO I = 1, 5
            ISAV(I) = NOPT(I + 1)
         ENDDO 
         CALL CALCCFG (N8, NOPT) 
         ISTOP(2) = .FALSE.
         IF (NOPT(4).EQ.2) THEN
            WRITE (LINE,300)
            PMAX = 100.0d+00
            PMIN = 0.1D+00
            CALL GETDM1 (PMIN, PCENT, PMAX,
     +                   LINE)
            IF (ABS(PCENT - PCENT_SAV).GT.1.0D-04) ISTOP(2) = .TRUE.
         ENDIF
         IF (.NOT.XPERT) THEN
            PCENT_SAV = PCENT
            DO I = 1, N8
               NOPT_SAV(I) = NOPT(I) 
            ENDDO
         ENDIF
         DO I = 1, 5
            IF (I.NE.4) THEN
               IF (ISAV(I).NE.NOPT(I + 1)) THEN
                  ISTOP(2) = .TRUE.
                  EXIT
               ENDIF  
            ENDIF   
         ENDDO        
      ELSEIF (NSET.EQ.4) THEN
C
C NSET = 4: Close down
C      
         CLOSE (UNIT = NOUT(2))
         I = 2
         IF (EXIST) CALL FNAMES (I,
     +                           DFILE)
         RETURN
      ENDIF
C
C Part 2: Systematic steps to define TEXT_SAV
C -------
C      
      IF (XPERT) THEN
         MODE = 'Expert'
         IF (ISTOP(1)) RETURN
      ELSE
         MODE = 'Normal'
      ENDIF
C
C OPTION 1
C
      IF (NOPT(1).EQ.1) THEN
         OPTION(1) = 'File/File'
      ELSEIF (NOPT(1).EQ.2) THEN
         OPTION(1) = 'File/Keyb'
      ELSE
         NOPT(1) = 3
         OPTION(1) = 'Keyb/Keyb'
      ENDIF
C
C OPTION 2
C
      IF (NOPT(2).EQ.1) THEN
         OPTION(2) = 'x'
      ELSE
         NOPT(2) = 2
         OPTION(2) = 'log(x)'
      ENDIF
C
C OPTION 3
C
      IF (NOPT(3).EQ.1) THEN
         OPTION(3) = 'Sparse'
      ELSEIF (NOPT(3).EQ.2) THEN
         OPTION(3) = 'Medium'
      ELSEIF (NOPT(3).EQ.3) THEN
         OPTION(3) = 'Dense'
      ELSE
         NOPT(3) = 4
         OPTION(3) = 'Solid'
      ENDIF
C
C OPTION 4
C
      IF (NOPT(4).EQ.1) THEN
         OPTION(4) = '1/s^2'
      ELSEIF (NOPT(4).EQ.2) THEN
         OPTION(4) = '1/%y^2'
      ELSE
         NOPT(4) = 3
         OPTION(4) = '1'   
      ENDIF
C
C OPTION 5
C
      IF (NOPT(5).EQ.1) THEN
         OPTION(5) = 'x,y'
      ELSE
         NOPT(5) = 2
         OPTION(5) = 'x,y,+/-cl'
      ENDIF
C
C OPTION 6
C
      IF (NOPT(6).EQ.1) THEN
         OPTION(6) = 'No'
      ELSEIF (NOPT(6).EQ.2) THEN
         OPTION(6) = 'Slack'
      ELSEIF (NOPT(6).EQ.3) THEN
         OPTION(6) = 'Medium'
      ELSE
         NOPT(6) = 4
         OPTION(6) = 'Tight'
      ENDIF
C
C OPTION 7
C
      IF (NOPT(7).EQ.1) THEN
         OPTION(7) = 'No'
      ELSE
         NOPT(7) = 2
         OPTION(7) = 'Yes'
      ENDIF
C
C OPTION 8
C
      IF (NOPT(8).EQ.1) THEN
         OPTION(8) = 'No'
      ELSE
         NOPT(8) = 2
         OPTION(8) = 'Yes'
      ENDIF
      IF (ISTOP(1)) THEN
         TEXT1 = 'Status of the  current data:- waiting for input ***'
      ELSE
         TEXT1 = 'Status of the  current data:- ready for fitting'
      ENDIF
      IF (ISTOP(2)) THEN
         TEXT2 = 'Status of calibration curve:- fitting  required ***'
      ELSE
         TEXT2 = 'Status of calibration curve:- fitting completed'
      ENDIF
      DO I = 1, 20
         TEXT_SAV(I) = BLANK
         TEMP(I) = BLANK
      ENDDO
      IF (ISTOP(2)) THEN
         WRITE (TEMP,400) OPTION(1), OPTION(2), OPTION(5),
     +                    CIPHER, OPTION(3), OPTION(4)
      ELSE
         WRITE (TEMP,500) OPTION(1), OPTION(2), OPTION(5),
     +                    N7 - 8, OPTION(3), OPTION(4)
      ENDIF
      DO I = 1, 5
         TEXT_SAV(I) = TEMP(I)
      ENDDO
      WRITE (TEMP,600) (OPTION(I), I = 6, 8), MODE,
     +                   TEXT1, TEXT2
      DO I = 1, 5
         TEXT_SAV(5 + I) = TEMP(I)
      ENDDO
C
C Format statements
C      
  100 FORMAT (/1X,'PACKAGE : SIMFIT'/1X,'PROGRAM : CALCURVE',
     +/1X,'ACTION  : Prediction from cubic spline calibration curve',
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U.K.')
c  200 FORMAT (
c     +'c value required for constant variance (or set c = 1)')
  300 FORMAT (
     +'cv% value required for constant relative error (e.g. 7.5)')

  400 FORMAT (
     +/'Input mode = ',A,'       `Indep. var. = ',A
     +/'Graph axes = ',A,'       `Knots = ',A
     +/              22X,'       `Density = ',A
     +/'Weight = ',A)
  500 FORMAT (
     +/'Input mode = ',A,'       `Indep. var. = ',A
     +/'Graph axes = ',A,'       `Knots =',I5
     +/              22X,'       `Density = ',A
     +/'Weight = ',A)
  600 FORMAT (
     + '95% con. lim. = ', A,'   `Tables to file = ',A
     +/'Show residuals = ',A,'   `Program mode = ',A
     +/
     +/A
     +/A)
      END
C
C
      subroutine calccfg (nmax, nopt)
c
c action: configure calcurve
c author: w.g.bardsley, university of manchester, u.k.,12/04/2015
c   
c The default is: nmax = 8, but nopt(7) and nopt(8) are always returned equal to 1
c                 index1 sets the defaults while nreps is used to count the six
c                 ganging groups as indicated by numbld 
c   
      implicit none
c
c arguments    
c    
      integer, intent (in)    :: nmax 
      integer, intent (inout) :: nopt(nmax) 
c
c locals
c       
       integer    i, j, k, nreps(6)
       integer    icolor, ixl, iyl, lshade, numdec, numopt, nstart,
     +            ntext
       parameter (icolor = 3, ixl = 4, iyl = 4, lshade = 1, numdec = 1,
     +            numopt = 18, nstart = 3, ntext = nstart + numopt - 1)
       integer    numbld(numopt + 2), numpos(numopt)
       integer    index1(numopt)
       character (len = 100) text(ntext)
       logical    border,flash, high
       parameter (border = .false., flash = .false., high =.true.)
       logical    first
       external   rbox01
       save       nreps
       save       first
       save       index1
       data       first /.true. / 
       data       nreps / 3, 2, 4, 3, 2, 4 /
       data       index1 / 0, 1, 0,    !data input mode
     +                     1, 0,       !x or log(x)
     +                     0, 0, 0, 1, !knot density
     +                     0, 0,  1,   !weights
     +                     1, 0,       !plots
     +                     1, 0, 0, 0 /!confidence limits
       data       numbld / 0, 0,               !header
     +                     100, 100, 100,      !data input mode
     +                     200, 200,           !x or log(x) 
     +                     300, 300, 300, 300, !knot density
     +                     400, 400, 400,      !weights 
     +                     500, 500,           !plots 
     +                     600, 600, 600, 600 /!confidence limits
     
       if (first) then
          first = .false.
          do i = 1, numopt
             numpos(i) = index1(i)
          enddo  
       else
          do i = 1, numopt
             numpos(i) = 0
          enddo
          j = 0
          do i = 1, 6
             do k = 1, nreps(i)
                j = j + 1
                if (nopt(i).eq.k) numpos(j) = 1
             enddo  
          enddo  
       endif 
       
       write (text,100)

       numbld(1) = 4
       
       CALL RBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, 
     +              NUMOPT,
     +              NUMPOS, NSTART, NTEXT,
     +              TEXT,
     +              BORDER, FLASH, HIGH)

      j = 0
      do i = 1, 6
         do k = 1, nreps(i)
            j = j + 1
            if (numpos(j).eq.1) nopt(i) = k
         enddo     
      enddo
      nopt(7) = 2
      nopt(8) = 2
c
c format statement
c      
  100 format (
     + 'The Calcurve configuration options'
     +/
     +/'File/File: All data input from files'     
     +/'File/Keyb: Prediction values from keyboard'     
     +/'Keyb/Keyb: All data values from keyboard'
     +/'Independent variable: x'
     +/'Independent variable: log(x)'
     +/'Knot density: Sparse'        
     +/'Knot density: Medium'        
     +/'Knot density: Dense'        
     +/'Knot density: Solid (Cross validation)'
     +/'Weights: Use w = 1/s^2 (s from data file)'
     +/'Weights: Use w = 1/%y^2 (% supplied)'
     +/'Weights: Use w = 1 (Unweighted)'   
     +/'Plot: x, y'       
     +/'Plot: x, y +/- confidence limits'       
     +/'Confidence limits: None'
     +/'Confidence limits: Slack (using +/- 4s)'
     +/'Confidence limits: Medium (using +/- 3s)'
     +/'Confidence limits: Tight (using +/- 2s))')
      end
c
c
      subroutine xvalid (ndim, m, ncap7, 
     +                   x, y, s, lambda, work1, work2, c, ss, ifail)
c
c action: spline for program calcurve by generalised cross validation
c author: w.g.bardsley, university of manchester, u.k.
c         16/04/2015 derived from splfit
c     
c The arguments are designed to be as for E02BAF but internally G10ACF is called 
c and there are several differences between this routine and splfit.
c Note: 1) ncap7 is returned as the value from spltrn after calculating the knot set
c       2) c is similarly returned as the spline coefficients from spltrn
c       3) work1 and work2 are dummy workspaces
c     
      implicit none
c
c arguments
c      
      integer,          intent (in)    :: ndim, m 
      integer,          intent (inout) :: ncap7
      integer,          intent (inout) :: ifail
      double precision, intent (in)    :: x(m), y(m), s(m) 
      double precision, intent (inout) :: c(ndim), ss   
      double precision, intent (inout) :: lambda(ndim), work1(2),
     +                                    work2(2) 
c
c locals
c
      integer    i, j, k, npts, maxcal, nmax, nout, nreps
      parameter (nmax = 1000, nout = 4)
      integer    iwrk(nmax)
      double precision cc(nmax,3), crit, df, rho, rss, tol, u
      double precision h(nmax), xreps(nmax), yhat(nmax), yreps(nmax)
      double precision w(10*nmax), res(nmax), 
     +                 rk(nmax + 8), sreps(nmax)
      double precision epsi, one, slow, shigh
      parameter (epsi = 1.0d-06, one = 1.0d+00, slow = one - epsi, 
     +           shigh = one + epsi)
      character (len = 100) line
      character (len = 1  ) mode, weight
      logical    reps
      external   putadv, putfat, spltrn
      external   g10zaf$, g10acf$
      intrinsic  abs
c
c initialise and check the data supplied
c      
      npts = m
      weight = 'U'
      do i = 1, npts
         if (s(i).lt.slow .or. s(i).gt.shigh) then
            weight = 'W'
            exit
         endif
      enddo  
      reps = .false.
      do i = 2, npts
         if (x(i).lt.x(i - 1)) then
            call putfat ('X not in nondecreasing order')
            return
         endif   
      enddo
      do i = 2, npts      
         if (x(i).le.x(i - 1) + epsi*abs(x(i - 1))) then
            reps = .true. 
            exit
         endif
      enddo      
        
c
c method = 3 or 4: G10ABF/G10ACF...adjust s and action required if reps
c ---------------- Note: s is not transformed but first w = 1/s^2 is used
c                  then sreps effectively = 1/s^2 is used i.e.
c                  nreps, sreps, xreps, yreps are used by G10ABF/G10ACF
c
      if (weight.eq.'W') then
         do i = 1, npts
            w(i) = one/s(i)**2
            sreps(i) = w(i)
         enddo
      else
         do i = 1, npts
            sreps(i) = one
         enddo
      endif
      if (reps) then
         ifail = 1
         call g10zaf$(weight, npts, x, y, w, nreps, xreps,
     +                yreps, sreps, rss, iwrk, ifail)
         if (ifail.ne.0) then
            write (line,100) ifail
            call putadv (line)
            npts = 0
            nreps = 0
         endif
      else
         nreps = npts
         do i = 1, npts
            xreps(i) = x(i)
            yreps(i) = y(i)
         enddo
      endif

c
c method = 4: fit using g10acf
c ===========
c      
         mode = 'G'
         u = 1.0d+04
         tol = 1.0d-03
         crit = 3.0d+00
         maxcal = 40
         ifail = 1
         call g10acf$(mode, weight, nreps, xreps, yreps, sreps, yhat,
     +                cc, nmax, rss, df, res, h, crit, rho, u, tol,
     +                maxcal, w, ifail)
         if (ifail.ne.0) then
            write (line,200) ifail
            call putadv (line)
         endif   

c
c map spline from g10abc or g10acf into B-spline format
c         
      if (ifail.eq.0) then
         j = 7*nmax - 1
         k = 8*nmax
         do i = 1, nreps
            j = j + 1
            k = k + 1
            w(j) = yhat(i)
            w(k) = res(i)
         enddo
         call spltrn (ncap7, nout, nreps, nmax,
     +                c, cc, rk, xreps, yhat, w)
         do i = 1, ncap7
            lambda(i) = rk(i)
         enddo
         ss = rss  
         work1(1) = rss
         work2(1) = rss 
      endif
  100 format ('On exit from G10ZAF: IFAIL =',i4)     
  200 format ('On exit from G10ACF: IFAIL =',i4)     
      end
c
c                      

