C
C FTN95 version
C =============
C
C CALCURVE
C ========
C
C CALCURVE.FOR: MAIN, ADVISE
C CALCURV1.INS: FUNC, CHECK1, CHECK2, CHOOSE, DATAIN, DATFIT, DATOUT
C CALCURV2.INS: PLOTIT, PRDXFY, PRDYFX
C CALCURV3.INS: SETSUP, CALCFG, XVALID
C
C
C Now include the extra source code
C =================================
C
C      INCLUDE 'calcurv1.for', NOLIST
C      INCLUDE 'calcurv2.for', NOLIST
C      INCLUDE 'calcurv3.for', NOLIST
C      INCLUDE 'dllchk.for'
C
C
      PROGRAM CALCUR
C
C VERSION : details from SIMVER/DLLCHK
C ACTION  : Fit B-splines to data then predict X given Y etc.
C NAG     : C05AZF, E02BAF, E02BBF, G10ABF
C INPUT   : X, Y, error in Y, X or Y for prediction
C OUTPUT  : Weighted least squares B-spline fit, table, graph and
C           prediction of X given Y, Y given X and approximate 95% con. lim.
C ADVICE  : Set array dimensions etc. using parameters as follows:-
C           NBIG    = Maximum number of spline knots + 8
C           NCHECK  = Number of checks for turning points
C           NGRAF   = Number of graph points
C           NHUGE   = Maximum number of  prediction points (PRDXFY and PRDYFX)
C           NMAX    = Maximum number of calibration points
C           NSTOP   = Number of lines in tables until NPAUSE = NSTOP(..scrolling..)
C                     (not used in this version)
C           N7 - 8  = Number of B-spline interior knots (set in DATAIN)
C           NOUT(1) =  INPUT, 3  
C           NOUT(2) =  OUTPUT, 4 
C           Note NOUT in FUNC, DATFIT for call to PUTIFA should  agree with NOUT(2)
C AUTHOR  : W. G. Bardsley, University of Manchester, U.K., 2/8/89
C REVISED : 31/09/1990 INDATA, INVECC, PROMPT
C           10/04/1991 DATIN, VECCIN, GRF001, RES001
C           30/04/1991 Added SCREEN and GRFGK2/4, 27/4/92 GKSR01, GETCHR, GETNUM
C           18/10/1992 SPL004
C           19/11/1992 Correct XGRAF when XTOLOG=.TRUE. in PLOTIT
C           25/01/1993 GET???, PUT??? and compressed
C           29/09/1994 DBOS version
C           16/02/1995 Revised for Salamanca
C           17/08/1997 win32 version ... Added TEXT_SAV
C           05/08/1998 added dllchk
C           14/12/1998 Replaced TUTORS by TUTOR1
C           12/09/1999 added WINDOWS
C           12/02/2000 added SIMVER and increased filnames to 256
C                      This version has all titles, etc. = 80 characters
C           20/03/2001 revised
C           28/07/2005 increased DVER to *30 and added to call to ADVISE
C           17/04/2015 major overhaul and introduced cross-validation splines
C
      IMPLICIT   NONE
      INTEGER    NGRAF, NHUGE, NMAX
      PARAMETER (NGRAF = 160, NHUGE = 100, NMAX = 1000)
      INTEGER    NBIG, NCHECK
      PARAMETER (NBIG = 48, NCHECK = 100)
      INTEGER    I, ISEND, NPTS, NSET, N7
      INTEGER    ICHECK(NCHECK), INDEX(NCHECK), NOPT(8), NOUT(3)
      DOUBLE PRECISION PCENT, YMAX, YMIN
      DOUBLE PRECISION C(NMAX), CL(NMAX), CU(NMAX), FK(NMAX)
      DOUBLE PRECISION E(NMAX), X(NMAX), Y(NMAX), Z(NMAX)
      DOUBLE PRECISION W(NMAX), WINV(NMAX), XTEMP(NMAX), YTEMP(NMAX)
      DOUBLE PRECISION XFIT(NGRAF), XGRAF(NGRAF), YFIT(NGRAF),
     +                 YGRAF(NGRAF)
      DOUBLE PRECISION XL95(NGRAF), XU95(NGRAF), YL95(NGRAF),
     +                 YU95(NGRAF)
      DOUBLE PRECISION WORK1(NMAX), WORK2(4,NBIG), XTP(NCHECK),
     +                 YTP(NCHECK)
      DOUBLE PRECISION W1(NHUGE), W2(NHUGE), W3(NHUGE), W4(NHUGE),
     +                 W5(NHUGE)
      DOUBLE PRECISION XVER, YVER
      
      CHARACTER (LEN = 1024) FNAME
      CHARACTER (LEN = 80  ) TITLE
      CHARACTER (LEN = 100 ) TEXT_SAV(30)
      CHARACTER (LEN = 30  ) DVER
      CHARACTER (LEN = 15  ) PVER
      CHARACTER (LEN = 10  ) CHAR1(NHUGE), CHAR2(NHUGE), CHAR3(NHUGE)
      CHARACTER (LEN = 8   ) PNAME
      CHARACTER (LEN = 1   ) BLANK
      PARAMETER (PVER = 'w_calcurve.exe')
      PARAMETER (PNAME = 'CALCURVE')
      PARAMETER (BLANK = ' ')
      LOGICAL    ABORT, ACTION, ISTOP(2), SHOW, XISLOG, XPERT
      LOGICAL    AGAIN, FIRST, OP
      LOGICAL    SPLINE_FILE
      EXTERNAL   ADVISE, SETSUP, CHOOSE, DATAIN, DATFIT, DATOUT, PRDXFY,
     +           PRDYFX, PLOTIT, SPL004, REVPRO
      EXTERNAL   DLLCHK, WINDOW, SIMVER

C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C
      ISEND = 1
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND, TITLE, ACTION)
      CALL SIMVER (XVER, YVER, DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER, DVER, PVER, ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C

      AGAIN = .FALSE.
      FIRST = .TRUE.
      SPLINE_FILE = .FALSE.
      NOUT(1) = 3
      NOUT(2) = 4
      NOUT(3) = 10
      CALL ADVISE (NMAX,
     +             DVER,
     +             ABORT, FIRST)
      IF (.NOT.ABORT) THEN
         
         NPTS = 1
         DO ISEND = 1, 30
            TEXT_SAV(ISEND) = BLANK
         ENDDO
         FNAME = BLANK
         NSET = 1
         XPERT = .FALSE.
         CALL SETSUP (NOPT, NOUT, NSET, N7, 
     +                PCENT,
     +                TEXT_SAV,
     +                ISTOP, XPERT)
         IF (NSET.GE.1) AGAIN = .TRUE.
      ENDIF
C
C Main cycle point
C ================
C
      DO WHILE (AGAIN)
         CALL CHOOSE (ISEND, NOPT, NOUT, NSET, N7, 
     +                PCENT,
     +                TEXT_SAV,
     +                ISTOP, XPERT)
         IF (ISEND.EQ.1) THEN
            CALL DATAIN (ISEND, NBIG, NMAX, NOPT, NOUT, NPTS, N7,
     +                   E, PCENT, W, WINV, X, Y, YMAX, YMIN, 
     +                   FNAME, TITLE,
     +                   ISTOP, XISLOG, XPERT)
         ELSEIF (ISEND.EQ.2) THEN
            CALL DATAIN (ISEND, NBIG, NMAX, NOPT, NOUT, NPTS, N7,
     +                   E, PCENT, W, WINV, X, Y, YMAX, YMIN,
     +                   FNAME, TITLE,
     +                   ISTOP, XISLOG, XPERT)
            CALL DATFIT (ICHECK, INDEX, NCHECK, NMAX, NOPT, NPTS, N7,
     +                   C, CL, CU, FK, W, WINV, WORK1, WORK2, X, XTEMP,
     +                   XTP, Y, YMAX, YMIN, YTEMP, YTP, Z, 
     +                   ISTOP, XISLOG)
            IF (.NOT.ISTOP(1) .AND. .NOT.ISTOP(2)) THEN  
               CALL PLOTIT (NGRAF, NOPT, NOUT, NPTS, N7,
     +                      C, CL, CU, FK,  X, XFIT, XGRAF, XL95, XTEMP,
     +                      XU95, Y, YFIT, YGRAF, YL95, YTEMP, YU95, 
     +                     ISTOP, XISLOG)
            ENDIF
         ELSEIF (ISEND.EQ.3) THEN
            CALL DATOUT (NOPT, NOUT, NPTS,
     +                   WINV, WORK1, X, XTEMP, Y, Z,
     +                   ISTOP)
         ELSEIF (ISEND.EQ.4) THEN
            CALL PLOTIT (NGRAF, NOPT, NOUT, NPTS, N7,
     +                   C, CL, CU, FK,  X, XFIT, XGRAF, XL95, XTEMP,
     +                   XU95, Y, YFIT, YGRAF, YL95, YTEMP, YU95, 
     +                   ISTOP, XISLOG)
            IF (SPLINE_FILE   .AND.
     +          .NOT.ISTOP(1) .AND.
     +          .NOT.ISTOP(2)) CALL SPL004 (N7, NOUT(3), NGRAF, NOUT(2),
     +                                      NBIG,
     +                                      C, FK, W, XGRAF, YGRAF)
         ELSEIF (ISEND.EQ.5) THEN
            CALL PRDXFY (NHUGE, NOPT, NOUT, NPTS, N7,
     +                   C, CL, CU, FK, X, W1, W2, W3, YMAX, YMIN, W4,
     +                   W5, 
     +                   FNAME, CHAR1, CHAR2, TITLE, CHAR3,
     +                   ISTOP, XISLOG)
         ELSEIF (ISEND.EQ.6) THEN
            CALL PRDYFX (NHUGE, NOPT, NOUT, NPTS, N7,
     +                   C, CL, CU, FK, X, W1, W2, W3, W4, W5,
     +                   ISTOP, XISLOG)
         ELSEIF (ISEND.EQ.7) THEN
            NSET = 2
            CALL SETSUP (NOPT, NOUT, NSET, N7, 
     +                   PCENT,
     +                   TEXT_SAV,
     +                   ISTOP, XPERT)
         ELSEIF (ISEND.EQ.8) THEN
            CALL REVPRO(NOUT(2))
         ELSEIF (ISEND.EQ.9) THEN
            FIRST = .FALSE.
            CALL ADVISE (NMAX,
     +                   DVER,
     +                   ABORT, FIRST)
         ELSE
            AGAIN = .FALSE.
            NSET = 4
            CALL SETSUP (NOPT, NOUT, NSET, N7,
     +                   PCENT,
     +                   TEXT_SAV,
     +                   ISTOP, XPERT)
         ENDIF
      ENDDO

C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = 1
      ACTION = .FALSE.
      CALL WINDOW (ISEND, TITLE, ACTION)
C
C======================================================================
C
      DO I = 1, 3
         INQUIRE (UNIT = NOUT(I), OPENED = OP)
         IF (OP) CLOSE (UNIT = NOUT(I))
      ENDDO     
      END
C
C
      SUBROUTINE ADVISE (NMAX,
     +                   DVER,
     +                   ABORT, FIRST)
C
C Advise user
C
      IMPLICIT   NONE
C
C arguments
C
      INTEGER,             INTENT (IN)  :: NMAX
      CHARACTER (LEN = *), INTENT (IN)  :: DVER
      LOGICAL,             INTENT (OUT) :: ABORT
      LOGICAL,             INTENT (IN)  :: FIRST
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 3, NUMHDR = 14, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER (LEN = 100) HEADER(NUMHDR)
      CHARACTER (LEN = 50 ) OPTION(NUMOPT)
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_CALCURVE
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help           ',
     +'Run the program',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (FIRST) THEN
            WRITE (HEADER,100) DVER, NMAX
            ISEND = 1
            CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
            ISEND = 1
         ENDIF
         IF (ISEND.EQ.1) THEN
            CALL HELP_CALCURVE ('calcurve')
            IF (FIRST) THEN
               REPEET = .TRUE.
            ELSE
               ABORT = .FALSE.
               REPEET = .FALSE.
            ENDIF
         ELSEIF (ISEND.EQ.2) THEN
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `CALCURVE'
     +/'        `      '
     +/'Action  `Cubic spline calibration curve.'
     +/'        `Input: the standard data, then prediction values.'
     +/'        `Output: x-predicted with 95% con. lim. given y.'
     +/'        `      '
     +/'Version `',A
     +/'        `Maximum number of rows',I5
     +/'        `      '
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      '
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C


