C
C FTN95 version
C =============
C
C
C     INCLUDE 'dllchk.for'
      PROGRAM MAIN
C
C VERSION : details from SIMVER/DLLCHK
C FORTRAN : 95, Double precision
C NAG     : G01AFF, G01ECF, G01FCF, S14ABF, X02AMF
C INPUT   : Degrees of freedom, arguments, etc.
C OUTPUT  : PDF, CDF, ALPHA, Inverses for chi-square distribution
C           Maps C's onto uniform (0, 1) then performs Kolmogorov
C           Smirnov and chi-square tests (? cells) for chisqd d'bn.
C           Also performs chi-sq test on data supplied and Fishers
C           exact test for 2 by 2 and N <= 40
C AUTHOR  : W. G. Bardsley, 18/07/90
C           09/07/1992 ENDALL, PDFCDF
C           14/03/1993 GET???, PUT??? and compressed
C           17/06/1993 RESFIL
C           23/08/1994 DBOS version
C           17/02/1995 Version for Salamanca
C           03/05/1995 Corrected NUM in CONTIN for no shrinkage
C           27/07/1995 New code in CONTIN when IFAIL = 1 from NUM = 1
C           20/11/1995 Upgraded to nag mark 16
C           18/12/1996 Moved CONTIN to SIMFIT.LIB
C           25/04/1997 win32 version ...  COMMON only used for CDF and PDF
C           05/08/1998 added dllchk
C           14/12/1998 replaced TUTORS by TUTOR1
C           13/09/1999 added call to WINDOW
C           20/12/1999 added call to NONCEN
C           12/02/2000 added SIMVER
C           20/03/2001 revised
C           28/07/2005 increased DVER to *18 and added to call to ADVISE
C           10/02/2006 new arguments for call to CONTIN
C           12/09/2007 revised for version 6 
C           02/07/2022 added E_NUMBERS and E_FORMATS and extensive revision and added X_DOFDOT
C
      IMPLICIT   NONE
      INTEGER    NIN, NOUT4
      PARAMETER (NIN = 3, NOUT4 = 4)
      INTEGER    NPAR
      PARAMETER (NPAR = 4)
      INTEGER    ISEND, JSEND, NOUT, NTYPE
      INTEGER    NCOL_A, NROW_A, NROW_Z
      INTEGER    NROW_E, NROW_O
      DOUBLE PRECISION DBLE_N, PAR(NPAR)
      DOUBLE PRECISION ENEG, EXPON, FACTOR, RTOL
      DOUBLE PRECISION X02AMF$
      DOUBLE PRECISION XVER, YVER
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  PNAME*6
      PARAMETER (PNAME = 'CHISQD')
      CHARACTER  FNAME_A*1024, TITLE_A*80
      CHARACTER  FNAME_Z*1024, TITLE_Z*80
      CHARACTER  FNAME_E*1024, TITLE_E*80
      CHARACTER  FNAME_O*1024, TITLE_O*80
      CHARACTER  FNAME*1024, PTITLE*42, TITLE*80
      CHARACTER  DVER*30, PVER*15
      PARAMETER (PVER = 'w_chisqd.exe')
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    ABORT, ACTION, AGAIN, FIRST, NOPDF, OP, SHOW
      EXTERNAL   X02AMF$
      EXTERNAL   RESFIL, PUTADV, FNAMES, REVPRO, WINDOW, NONCEN
      EXTERNAL   ADVISE, DETAIL, ARGUIN, PDFVAL, CDFVAL,  
     +           INVERT, M_MATONE, M_ONEVEC, M_VECTWO
      EXTERNAL   DLLCHK, SIMVER
      INTRINSIC  LOG

C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C Note ISEND = 2 since may be called from SIMSTAT which has already
C called WINDOW with ISEND = 1
C
      ISEND = 2
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND, TITLE, ACTION)
      CALL SIMVER (XVER, YVER, DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER,
     +             DVER, PVER,
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C

      AGAIN = .FALSE.
      FIRST = .TRUE.
      NOUT = NOUT4
      CALL ADVISE (DVER,
     +             ABORT, FIRST)
      IF (.NOT.ABORT) THEN
         NCOL_A = 0
         NROW_A = 0
         NROW_E = 0
         NROW_O = 0
         NROW_Z = 0
         FNAME_A = BLANK
         FNAME_E = BLANK
         FNAME_O = BLANK
         FNAME_Z = BLANK
         TITLE_A = BLANK
         TITLE_E = BLANK
         TITLE_O = BLANK
         TITLE_Z = BLANK
         FNAME = BLANK
         CALL RESFIL (NOUT,
     +                FNAME,
     +                ABORT)
         IF (.NOT.ABORT) THEN
            AGAIN = .TRUE.
            WRITE (NOUT,100)
            RTOL = 1.0D+09*X02AMF$()
            ENEG = LOG(RTOL)
C
C First set N = 0 to make sure N is initialised
C
            DBLE_N = ZERO
         ENDIF
      ENDIF
C
C Main cycle point
C ================
C
      DO WHILE (AGAIN)
         CALL DETAIL (ISEND,
     +                DBLE_N)
         IF (ISEND.EQ.1) THEN
C
C ISEND = 1: define degrees of freedom
C           
            CALL ARGUIN (NOUT, NPAR,
     +                   DBLE_N, ENEG, EXPON, FACTOR, PAR, 
     +                   PTITLE, 
     +                   NOPDF)
         ELSEIF (ISEND.EQ.2) THEN
C
C ISEND = 2: pdf
C          
            CALL PDFVAL (NOUT, 
     +                   DBLE_N, ENEG, EXPON, FACTOR, RTOL,
     +                   NOPDF)
         ELSEIF (ISEND.EQ.3) THEN
C
C ISEND = 3: cdf
C          
            CALL CDFVAL (NOUT,
     +                   DBLE_N, RTOL)
         ELSEIF (ISEND.EQ.4) THEN
C
C ISEND = 4: inverses
C                
            CALL INVERT (NOUT,
     +                   DBLE_N)
         ELSEIF (ISEND.EQ.5) THEN
C
C ISEND = 5: test for chi-square distribution
C          
            IF (DBLE_N.LE.ZERO) THEN
               CALL PUTADV ('First choose option 1 to input N')
            ELSE
               JSEND = 1 
               CALL M_ONEVEC (JSEND, NIN, NOUT, NPAR, NROW_Z,
     +                        PAR,
     +                        FNAME_Z, TITLE_Z)
            ENDIF
         ELSEIF (ISEND.EQ.6) THEN
C
C ISEND = 6: O/E frequencies for chi-square test
C          
            JSEND = 10
            CALL M_VECTWO (JSEND, NIN, NOUT, NROW_O, NROW_E,
     +                     FNAME_O, FNAME_E, TITLE_O, TITLE_E)            
         ELSEIF (ISEND.EQ.7) THEN
C
C ISEND = 7: contingency tables
C          
            NTYPE = 8
            CALL M_MATONE (NTYPE, NCOL_A, NIN, NOUT, NROW_A,
     +                     FNAME_A, TITLE_A)           
         ELSEIF (ISEND.EQ.8) THEN
C
C ISEND = 8: non-central distributions
C          
            NTYPE = 2
            CALL NONCEN (NOUT, NTYPE)
         ELSEIF (ISEND.EQ.9) THEN
C
C ISEND = 9: help
C          
            FIRST = .FALSE.
            CALL ADVISE (DVER,
     +                   ABORT, FIRST)
         ELSEIF (ISEND.EQ.10) THEN
C
C ISEND = 10: results
C          
            CALL REVPRO (NOUT)
         ELSE
C
C ISEND = 10: quit
C            
            AGAIN = .FALSE.
            INQUIRE (UNIT = NOUT, OPENED = OP)
            IF (OP) CLOSE (UNIT = NOUT)
            ISEND = 2
            CALL FNAMES (ISEND, FNAME)
         ENDIF
      ENDDO

C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = 2
      ACTION = .FALSE.
      CALL WINDOW (ISEND,
     +             TITLE, 
     +             ACTION)
C
C======================================================================
C
      CLOSE (UNIT = NOUT)
C
C Format statement
C
  100 FORMAT (/1X,'PACKAGE : SIMFIT'/1X,'PROGRAM : CHISQD'
     +/1X,'ACTION  : Chi-square and Fisher exact test'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U.K.')
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE ADVISE (DVER,
     +                   ABORT, FIRST)
C
C Advise user
C
      IMPLICIT   NONE
C
C Arguments
C
      CHARACTER (LEN = *), INTENT (IN)  :: DVER
      LOGICAL,             INTENT (OUT) :: ABORT
      LOGICAL,             INTENT (IN)  :: FIRST
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 3, NUMHDR = 13, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_CHISQD
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help           ',
     +'Run the program',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (FIRST) THEN
            WRITE (HEADER,100) DVER
            ISEND = 1
            CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
            ISEND = 1
         ENDIF
         IF (ISEND.EQ.1) THEN
            CALL HELP_CHISQD ('chisqd')
            IF (FIRST) THEN
               REPEET = .TRUE.
            ELSE
               ABORT = .FALSE.
               REPEET = .FALSE.
            ENDIF
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statment
C      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `CHISQD'
     +/'        `      '
     +/'Action  `The chi-square distribution'
     +/'        `pdf/cdf/inverse-values/Fisher-exact/chi-sq test/'
     +/'        `contingency table/test for chi-sq distribution'
     +/'        `      '
     +/'Version `',A
     +/'        `      '
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      '
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE ARGUIN (NOUT, NPAR, 
     +                   DBLE_N, ENEG, EXPON, FACTOR, PAR, 
     +                   PTITLE,
     +                   NOPDF)
C
C Enter degress of freedom N then calculate constants
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NOUT, NPAR
      DOUBLE PRECISION,    INTENT (INOUT) :: DBLE_N, ENEG, EXPON,
     +                                       FACTOR, PAR(NPAR) 
      CHARACTER (LEN = *), INTENT (INOUT) :: PTITLE
      LOGICAL,             INTENT (OUT)   :: NOPDF
C
C Locals
C      
      INTEGER    NCDF, NPDF, N0, N1, NBIG, NTYPE
      PARAMETER (NCDF = 100, NPDF = 160, N0 = 0, N1 = 1,
     +           NBIG = 1000000, NTYPE = 2)
      INTEGER    ISEND
      PARAMETER (ISEND = 0) 
      INTEGER    IFAIL
      DOUBLE PRECISION ARG, GAMMA, RNO2, XBOT, XTOP
      DOUBLE PRECISION XCDF(NPDF), XPDF(NPDF), YCDF(NCDF), YPDF(NPDF)
      DOUBLE PRECISION EPSI, CLOW, CHIGH
      PARAMETER (EPSI = 1.0D-06, CLOW = 0.0D+00, CHIGH = 1.0D+30)
      DOUBLE PRECISION S14ABF$
      DOUBLE PRECISION ONE, TWO, TEN
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, TEN = 10.0D+00)
      CHARACTER (LEN = 1 ) CIPHER
      PARAMETER (CIPHER = 'L')
      CHARACTER  XTITLE*10, YTITLE*11
      CHARACTER  VALUEN*10
      LOGICAL    YESNO
      EXTERNAL   S14ABF$
      EXTERNAL   GETDM1, PUTADV, PUTIFA, GETL01, X_DOFDOT
      EXTERNAL   PDFCDF
      INTRINSIC  DBLE, LOG, EXP
      IF (DBLE_N.LT.EPSI) DBLE_N = TEN
      XBOT = EPSI
      XTOP = DBLE(NBIG)  
      CALL GETDM1 (XBOT, DBLE_N, XTOP,
     +'Number of degrees of freedom required for chi-square')
      RNO2 = DBLE_N/TWO
      EXPON = RNO2 - ONE
      NOPDF = .FALSE.
      IFAIL = N1
      GAMMA = S14ABF$(RNO2, IFAIL)
      IF (IFAIL.NE.N0) THEN
         CALL PUTIFA (IFAIL, NOUT, 'S14ABF/ARGUIN')
         NOPDF = .TRUE.
      ENDIF
      ARG = RNO2*LOG(ONE/TWO) - GAMMA
      IF (ARG.LT.ENEG) THEN
         CALL PUTADV ('Overflow ... PDF cannot be calculated')
         NOPDF = .TRUE.
      ENDIF
      FACTOR = EXP(ARG)
      WRITE (VALUEN,'(F10.2)') DBLE_N
      CALL X_DOFDOT (ISEND,
     +               CIPHER, VALUEN)  
      WRITE (PTITLE,100) VALUEN
      XTITLE = 'chi-square'
      YTITLE = 'cdf and pdf'
      PAR(1) = DBLE_N
      PAR(2) = ENEG
      PAR(3) = EXPON
      PAR(4) = FACTOR
      YESNO = .FALSE.
      CALL GETL01 ('Plot pdf and cdf ?', YESNO)
      IF (YESNO) THEN
         CALL PDFCDF (NCDF, NOUT, NPAR, NPDF, NTYPE,
     +                PAR, CLOW, XCDF, XPDF, CHIGH, YCDF, YPDF,     
     +                PTITLE, XTITLE, YTITLE)
      ENDIF
C
C Format statement
C     
  100 FORMAT ('Chi-square degrees of freedom =',1X,A)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE CDFVAL (NOUT, 
     +                   DBLE_N, RTOL)
C
C Evaluate CDF
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NOUT
      DOUBLE PRECISION, INTENT (IN) :: DBLE_N, RTOL
C
C Locals
C      
      INTEGER    I, NCVALS
      INTEGER    KMAX, KMIN, K1, K2, K3
      PARAMETER (KMAX = 20, KMIN = 0, K1 = 1, K2 = 2, K3 = 3)
      INTEGER    JCOLOR
      PARAMETER (JCOLOR = 9)
      INTEGER    NTEMP(3)
      DOUBLE PRECISION ZERO, ONE, CMAX
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, CMAX = 1.0D+07)
      DOUBLE PRECISION ALPHA, BETA, C
      DOUBLE PRECISION CDF_CHISQUARE
      DOUBLE PRECISION XTEMP(3)
      CHARACTER (LEN = 13) D13, SHOWRJ 
      CHARACTER (LEN = 90) LINE
      LOGICAL    E_NUMBERS, E_FORMATS
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   PUTADV, GETJM1, TABLE4, MIDDLE
      EXTERNAL   CDF_CHISQUARE, PARAMS
      SAVE       NCVALS
      DATA       NCVALS / 1 /
      IF (DBLE_N.LE.ZERO) THEN
         CALL PUTADV ('First choose option 1 to input N')
         RETURN
      ENDIF
      CALL GETJM1 (KMIN, NCVALS, KMAX,
     +            'Number of cdf(x) values required')
      IF (NCVALS.LT.K1) RETURN
      E_NUMBERS = E_FORMATS()
      CALL PARAMS (NOUT,
     +             DBLE_N)
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'OPEN')
      WRITE (LINE,50)
      WRITE (NOUT,50)
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
      XTEMP(K1) = ZERO
      XTEMP(K3) = ONE/RTOL
      XTEMP(K3) = CMAX
      DO I = K1, NCVALS
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'GETRL1')
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'x required for cdf(x)')
         C = XTEMP(K2)
         BETA = CDF_CHISQUARE (NOUT,
     +                         DBLE_N, C)
         ALPHA = ONE - BETA
         CALL MIDDLE (ZERO, ALPHA, ONE)
         CALL MIDDLE (ZERO, BETA, ONE)
         IF (E_NUMBERS) THEN
            WRITE (LINE,100) C, BETA, ALPHA
            WRITE (NOUT,100) C, BETA, ALPHA
         ELSE
            D13 = SHOWRJ(C)
            WRITE (LINE,150) D13, BETA, ALPHA
            WRITE (NOUT,150) D13, BETA, ALPHA
         ENDIF  
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
      ENDDO
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'CLOSE')
C
C Format statementS
C 
   50 FORMAT (13X,'x',8X,'cdf(x)',6X,'1-cdf(x)')    
  100 FORMAT (1X,1P,E13.5,2X,0P,F12.6,2X,F12.6)
  150 FORMAT (1X,A13,2X,F12.6,2X,F12.6)     
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE DETAIL (ISEND,
     +                   DBLE_N)
C
C Decide option required
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (INOUT) :: ISEND
      DOUBLE PRECISION, INTENT (IN)    :: DBLE_N
C
C Locals
C      
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT, N1
      PARAMETER (ICOLOR = 9, IX = 12, IY = 8, LSHADE = 1, NUMOPT = 11,
     +           NSTART = 3, NTEXT = 15, N1 = 1)
      INTEGER    JSEND
      PARAMETER (JSEND = 0)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      INTEGER    ISAV
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER (LEN = 1) CIPHER
      PARAMETER (CIPHER = 'L')
      CHARACTER  LINE*100, TEXT(NTEXT)*100, VALUEN*10
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   LBOX01, X_DOFDOT
      SAVE       ISAV
      DATA       ISAV / 9 /
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
      WRITE (TEXT,100)
      IF (DBLE_N.LE.ZERO) THEN
         WRITE (LINE,200)
         TEXT(NTEXT) = LINE
      ELSE
         WRITE (VALUEN,'(F10.2)') DBLE_N
         CALL X_DOFDOT (JSEND,
     +                  CIPHER, VALUEN)     
         WRITE (TEXT(NTEXT),300) VALUEN
      ENDIF
      NUMBLD(N1) = N1
      NUMBLD(NTEXT) = N1
      ISEND = ISAV
      CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, ISEND, NUMOPT,
     +             NUMPOS, NSTART, NTEXT, 
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      ISAV = ISEND
C
C Format statement
C      
  100 FORMAT (
     + 'Options available for program CHISQD'
     +/
     +/'Input: number of degrees of freedom'
     +/'Input: x-values then output pdf(x)'
     +/'Input: x-values then output cdf(x)'
     +/'Input: alpha then output x-critical'
     +/'Input: sample then test for chi-sq. dbn.'
     +/'Input: O and E values for a chi-sq. test'
     +/'Input: contingency table for chi-sq. test'
     +/'Input: parameters for non-central chi-sq. dbn.'
     +/'Help'
     +/'Results'
     +/'Quit ... Exit program CHISQD'
     +/)
  200 FORMAT ('Degrees of freedom not yet initialised')
  300 FORMAT ('Current chi-square degrees of freedom =',1X,A)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE INVERT (NOUT,
     +                   DBLE_N)
C
C Invert chi-sq. distribution
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NOUT
      DOUBLE PRECISION, INTENT (IN) :: DBLE_N
C
C Locals
C      
      INTEGER    I, NPVALS
      INTEGER    KMAX, KMIN, K1, K2, K3
      PARAMETER (KMAX = 20, KMIN = 0, K1 = 1, K2 = 2, K3 = 3)
      INTEGER    JCOLOR
      PARAMETER (JCOLOR = 9)
      INTEGER    NTEMP(3)
      DOUBLE PRECISION XTEMP(3)
      DOUBLE PRECISION PCMAX, PCMIN
      PARAMETER (PCMAX = 99.99D+00, PCMIN = 0.01D+00)
      DOUBLE PRECISION ZERO, ONE, CENT
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, CENT = 100.0D+00)
      DOUBLE PRECISION ALPHA, BETA, CSTAT, PCENT
      DOUBLE PRECISION CDFINV_CHISQUARE
      CHARACTER (LEN = 13) D13, SHOWRJ 
      CHARACTER (LEN = 90) LINE
      LOGICAL    E_NUMBERS, E_FORMATS
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   CDFINV_CHISQUARE, PARAMS
      EXTERNAL   PUTADV, GETJM1, TABLE4
      SAVE       NPVALS
      DATA       NPVALS / 1 /
      IF (DBLE_N.LE.ZERO) THEN
         CALL PUTADV ('First choose option 1 to input N')
         RETURN
      ENDIF
      CALL GETJM1 (KMIN, NPVALS, KMAX,
     +            'Number of percentage points required')
      IF (NPVALS.LT.K1) RETURN
      E_NUMBERS = E_FORMATS()  
      CALL PARAMS (NOUT,
     +             DBLE_N)
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'OPEN')
      WRITE (LINE,50)
      WRITE (NOUT,50)
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
      XTEMP(K1) = PCMIN
      XTEMP(K3) = PCMAX
      DO I = K1, NPVALS
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'GETRL1')
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP,
     +               'Percentage point (100*alpha) required')
         PCENT = XTEMP(K2)
         ALPHA = PCENT/CENT
         BETA = ONE - ALPHA
         CSTAT = CDFINV_CHISQUARE (NOUT,
     +                             DBLE_N, BETA)
         IF (E_NUMBERS) THEN
            WRITE (LINE,100) CSTAT, BETA, ALPHA
            WRITE (NOUT,100) CSTAT, BETA, ALPHA
         ELSE
            D13 = SHOWRJ(CSTAT)
            WRITE (LINE,150) D13, BETA, ALPHA
            WRITE (NOUT,150) D13, BETA, ALPHA   
         ENDIF  
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
      ENDDO
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'CLOSE')
C
C Format statements
C 
   50 FORMAT (13X,'x',10X,'beta',9X,'alpha')   
  100 FORMAT (1X,1P,E13.5,5X,0P,F9.6,5X,F9.6)
  150 FORMAT (1X,A13,5X,F9.6,5X,F9.6)       
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE PARAMS (NOUT,
     +                   DBLE_N)
C
C Output current parameters to a file
C
      IMPLICIT  NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NOUT
      DOUBLE PRECISION, INTENT (IN) :: DBLE_N
C
C Locals
C      
      INTEGER    ISEND
      PARAMETER (ISEND = 0)
      CHARACTER (LEN = 1 ) CIPHER
      PARAMETER (CIPHER = 'L')
      CHARACTER (LEN = 10) VALUEN
      EXTERNAL  X_DOFDOT
      WRITE (VALUEN,'(F10.2)') DBLE_N
      CALL X_DOFDOT (ISEND,
     +               CIPHER, VALUEN)  
      WRITE (NOUT,100) VALUEN
C
C Format statement
C      
  100 FORMAT (/1X,'Current chi-square degrees of freedom =',1X,A)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE PDFVAL (NOUT, 
     +                   DBLE_N, ENEG, EXPON, FACTOR, RTOL, 
     +                   NOPDF)
C
C Calculate PDF(C) given C
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NOUT
      DOUBLE PRECISION, INTENT (IN) :: DBLE_N, ENEG, EXPON, FACTOR, RTOL
      LOGICAL,          INTENT (IN) :: NOPDF
C
C Locals
C      
      INTEGER    I, NCVALS
      INTEGER    KMAX, KMIN, K1, K2, K3
      PARAMETER (KMAX = 20, KMIN = 0, K1 = 1, K2 = 2, K3 = 3)
      INTEGER    JCOLOR
      PARAMETER (JCOLOR = 9)
      INTEGER    NTEMP(3)
      DOUBLE PRECISION XTEMP(3)
      DOUBLE PRECISION ZERO, ONE, CMAX
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, CMAX = 1.0D+07)
      DOUBLE PRECISION C, VALUE
      DOUBLE PRECISION PDF_CHISQUARE
      CHARACTER (LEN = 13) D13(2), SHOWRJ 
      CHARACTER (LEN = 90) LINE
      LOGICAL    E_NUMBERS, E_FORMATS
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   PDF_CHISQUARE, PARAMS
      EXTERNAL   PUTADV, GETJM1, TABLE4
      SAVE       NCVALS
      DATA       NCVALS / 1 /
      IF (DBLE_N.LE.ZERO) THEN
         CALL PUTADV ('First choose option 1 to input N')
         RETURN
      ENDIF
      IF (NOPDF) THEN
         CALL PUTADV ('pdf cannot be calculated')
         RETURN
      ENDIF
      CALL GETJM1 (KMIN, NCVALS, KMAX,
     +            'Number of pdf(x) values required')
      IF (NCVALS.LT.K1) RETURN
      E_NUMBERS = E_FORMATS()
      CALL PARAMS (NOUT,
     +             DBLE_N)
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'OPEN')
      WRITE (LINE,50)
      WRITE (NOUT,50)
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
      XTEMP(K1) = ZERO
      XTEMP(K3) = ONE/RTOL!original value
      XTEMP(K3) = CMAX
      DO I = K1, NCVALS
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'GETRL1')
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'x required for pdf(x)')
         C = XTEMP(K2)
         IF (C.LE.RTOL .AND. EXPON.LE.ZERO) C = RTOL
         VALUE = PDF_CHISQUARE (ENEG, EXPON, FACTOR, C)
         IF (E_NUMBERS) THEN
            WRITE (LINE,100) C, VALUE
            WRITE (NOUT,100) C, VALUE
         ELSE
            D13(1) = SHOWRJ(C)
            D13(2) = SHOWRJ(VALUE)
            WRITE (LINE,150) D13(1), D13(2)
            WRITE (NOUT,150) D13(1), D13(2)
         ENDIF   
         CALL TABLE4 (JCOLOR, NTEMP, XTEMP, LINE)
      ENDDO
      CALL TABLE4 (JCOLOR, NTEMP, XTEMP, 'CLOSE')
C
C Format statements
C  
   50 FORMAT (13X,'x',9X,'pdf(x)')
  100 FORMAT (1X,1P,E13.5,2X,E13.5)
  150 FORMAT (1X,A13,2X,A13)    
      END
C
C
