C
C FTN95 version
C =============
C
C
C COMPARE.FOR  : MAIN, ADVISE
C COMPARE1.FOR : DATAIN, ERRBAR, SHOWIT, SPLINE, SUMMIT
C
C      INCLUDE 'compare1.for'
C      INCLUDE 'dllchk.for'
       PROGRAM MAIN
C
C PACKAGE : SIMFIT
C PROGRAM : COMPARE
C VERSION : details from SIMVER/DLLCHK
C ACTION  : Best fit splines then comparison of curves
C NAG     : E02BBF, E02BEF, E02BCF, E02BDF, G01FBF,
C INPUT   : Files with TITLE, NPTS, TIME, SIZE, STANDARD ERROR IN
C           SIZE as formatted by program MAKFIL.
C OUTPUT  : AREA, BEST-FIT CURVES and COMPARISONS
C ADVICE  : The program requires X in increasing order and errors > 0
C           Set array dimension using parameter NMAX
C           C = B spline coefficients
C           RK = spline knots
C           NSETS = 1, just analyse single data sets
C           NSETS = 2, analyse pairs of data
C           YREPS1 = .TRUE., input data 1 has Y replicates
C AUTHOR  : W. G. Bardsley, 19/6/91
C           18/10/1992 added call to SPL004
C           09/05/1994 DBOS version 
C           17/02/1995 version for Salamanca
C           15/08/1997 win32 version
C           02/12/1997 re-organised method for dealing with no replicates
C           05/08/1998 added dllchk
C           14/12/1998 replaced TUTORS by TUTOR1
C           13/09/1999 added call to WINDOW
C           12/02/2000 added call to SIMVER
C           20/03/2001 revised
C           28/07/2005 increased DVER to *30 and included in call to ADVISE
C           06/02/2008 revised for version 6
C
      IMPLICIT   NONE
C
C Allocatable arrays
C      
      INTEGER,          ALLOCATABLE :: IWRK(:)
      DOUBLE PRECISION, ALLOCATABLE :: C1(:), RK1(:), X1(:), Y1(:)
      DOUBLE PRECISION, ALLOCATABLE :: C2(:), RK2(:), X2(:), Y2(:)
      DOUBLE PRECISION, ALLOCATABLE :: E(:), W(:)
      DOUBLE PRECISION, ALLOCATABLE :: YH1(:),  YH2(:), YL1(:), YL2(:) 
      DOUBLE PRECISION, ALLOCATABLE :: RESID(:), THEORY(:), WRESID(:)
      DOUBLE PRECISION, ALLOCATABLE :: ESAV(:), XSAV(:), YSAV(:)
      DOUBLE PRECISION, ALLOCATABLE :: WRK(:)
C
C Declarations
C      
      INTEGER    NF, NIN, NFILE, NGRAF, NMAX
      PARAMETER (NF = 4, NIN = 3, NFILE = 10, NGRAF = 200)
      INTEGER    LWRK, NEST
      INTEGER    K2
      PARAMETER (K2 = 2)
      INTEGER    IERR, ISEND, KT, NSAV1, NSAV2
      INTEGER    NCOL1, NCOL2, NROW1, NROW2
      INTEGER    M1, M2, NDATA, NEST1, NEST2, NSETS, N1, N2
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 1, NUMOPT = 4,
     +           NSTART = 10, NTEXT = NSTART + NUMOPT - 1)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      DOUBLE PRECISION FP1, FP2, S1, S2, T1, T2
      DOUBLE PRECISION XGRAF(NGRAF), XGRAF1(NGRAF), XGRAF2(NGRAF)
      DOUBLE PRECISION YGRAF(NGRAF), YGRAF1(NGRAF), YGRAF2(NGRAF)
      DOUBLE PRECISION XVER, YVER
      CHARACTER  DNAME1*1024, DNAME2*1024, FNAME*1024, TITLE*80,
     +           TITLE1*80, TITLE2*80
      CHARACTER  DVER*30, PVER*15
      PARAMETER (PVER = 'w_compare.exe')
      CHARACTER  BLANK*1, PNAME*7
      PARAMETER (BLANK = ' ', PNAME = 'COMPARE')
      CHARACTER  TEXT(NTEXT)*100
      LOGICAL    ABORT, ACTION, FIRST, ISTOP, SHOW, YREPS1, YREPS2
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   SPL004, GOSTOP, LBOX01, WINDOW, M_FITONE, STOP02
      EXTERNAL   ADVISE, DATAIN, SPLINE, SHOWIT, SUMMIT
      EXTERNAL   DLLCHK, SIMVER
      DATA NUMBLD / 1*1, 12*0 /
      DATA NUMPOS / NUMOPT*1 /

C
C=================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C
      ISEND = 1
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND, 
     +             TITLE, 
     +             ACTION)
      CALL SIMVER (XVER, YVER,
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER,
     +             DVER, PVER,
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================
C

      NDATA = 0
      FIRST = .TRUE.
      CALL ADVISE (DVER,
     +             ISTOP, FIRST)
      IF (ISTOP) GOTO 80
C
C Allocate 
C
      IERR = 0
      IF (ALLOCATED(IWRK)) DEALLOCATE(IWRK, STAT = IERR)
      IF (IERR.NE.0) GOTO 80  
      IF (ALLOCATED(C1)) DEALLOCATE(C1, STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      IF (ALLOCATED(RK1)) DEALLOCATE(RK1, STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      IF (ALLOCATED(X1)) DEALLOCATE(X1, STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      IF (ALLOCATED(Y1)) DEALLOCATE(Y1, STAT = IERR)
      IF (IERR.NE.0) GOTO 80        
      IF (ALLOCATED(C2)) DEALLOCATE(C2, STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      IF (ALLOCATED(RK2)) DEALLOCATE(RK2, STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      IF (ALLOCATED(X2)) DEALLOCATE(X2, STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      IF (ALLOCATED(Y2)) DEALLOCATE(Y2, STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      IF (ALLOCATED(E)) DEALLOCATE(E, STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      IF (ALLOCATED(W)) DEALLOCATE(W, STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      IF (ALLOCATED(YH1)) DEALLOCATE(YH1, STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      IF (ALLOCATED(YH2)) DEALLOCATE(YH2, STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      IF (ALLOCATED(YL1)) DEALLOCATE(YL1, STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      IF (ALLOCATED(YL2)) DEALLOCATE(YL2, STAT = IERR)
      IF (IERR.NE.0) GOTO 80        
      IF (ALLOCATED(RESID)) DEALLOCATE(RESID, STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      IF (ALLOCATED(THEORY)) DEALLOCATE(THEORY, STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      IF (ALLOCATED(WRESID)) DEALLOCATE(WRESID, STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      IF (ALLOCATED(ESAV)) DEALLOCATE(ESAV, STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      IF (ALLOCATED(XSAV)) DEALLOCATE(XSAV, STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      IF (ALLOCATED(YSAV)) DEALLOCATE(YSAV, STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      IF (ALLOCATED(WRK)) DEALLOCATE(WRK, STAT = IERR)
      IF (IERR.NE.0) GOTO 80

      NMAX = 1000
      NEST = NMAX + 4
      LWRK = 4*NMAX + 16*NEST + 41

      ALLOCATE(IWRK(NEST), STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      ALLOCATE(C1(NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      ALLOCATE(RK1(NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      ALLOCATE(X1(NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      ALLOCATE(Y1(NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      ALLOCATE(C2(NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      ALLOCATE(RK2(NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      ALLOCATE(X2(NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      ALLOCATE(Y2(NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      ALLOCATE(E(NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      ALLOCATE(W(2*NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      ALLOCATE(YH1(NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      ALLOCATE(YH2(NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      ALLOCATE(YL1(NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      ALLOCATE(YL2(NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      ALLOCATE(RESID(NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      ALLOCATE(THEORY(NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      ALLOCATE(WRESID(NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      ALLOCATE(ESAV(NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      ALLOCATE(XSAV(NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 80
      ALLOCATE(YSAV(NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 80 
      ALLOCATE(WRK(LWRK), STAT = IERR)
      IF (IERR.NE.0) GOTO 80     
C
C LABEL 20:  cycle point for method, i.e. 1 or 2 files
C ========
C        
   20 CONTINUE
      WRITE (TEXT,100)
      NSETS = 1
      CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NSETS, NUMOPT,
     +             NUMPOS, NSTART, NTEXT, 
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      IF (NSETS.EQ.NUMOPT - 1) THEN
         FIRST = .FALSE.
         CALL ADVISE (DVER,
     +                ISTOP, FIRST)
         GOTO 20
      ELSEIF (NSETS.EQ.NUMOPT) THEN
         CLOSE (UNIT = NIN)
         CLOSE (UNIT = NF)
         GOTO 80   
      ENDIF
      KT = NSETS - 1
      NCOL1 = 0
      NCOL2 = 0
      NROW1 = 0
      NROW2 = 0
      FNAME = BLANK 
      DNAME1 = BLANK
      DNAME2 = BLANK
C
C LABEL 40: main cycle point
C ========
C
   40 CONTINUE
C
C Fit first data set
C   
      NDATA = NDATA + 1
      ISEND = 15
      CALL M_FITONE (ISEND, NCOL1, NIN, NROW1,
     +               DNAME1, TITLE1)
      IF (NROW1.GT.NMAX) THEN
          IERR = 0
         IF (ALLOCATED(IWRK)) DEALLOCATE(IWRK, STAT = IERR)
         IF (IERR.NE.0) GOTO 80  
         IF (ALLOCATED(C1)) DEALLOCATE(C1, STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         IF (ALLOCATED(RK1)) DEALLOCATE(RK1, STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         IF (ALLOCATED(X1)) DEALLOCATE(X1, STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         IF (ALLOCATED(Y1)) DEALLOCATE(Y1, STAT = IERR)
         IF (IERR.NE.0) GOTO 80        
         IF (ALLOCATED(C2)) DEALLOCATE(C2, STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         IF (ALLOCATED(RK2)) DEALLOCATE(RK2, STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         IF (ALLOCATED(X2)) DEALLOCATE(X2, STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         IF (ALLOCATED(Y2)) DEALLOCATE(Y2, STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         IF (ALLOCATED(E)) DEALLOCATE(E, STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         IF (ALLOCATED(W)) DEALLOCATE(W, STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         IF (ALLOCATED(YH1)) DEALLOCATE(YH1, STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         IF (ALLOCATED(YH2)) DEALLOCATE(YH2, STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         IF (ALLOCATED(YL1)) DEALLOCATE(YL1, STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         IF (ALLOCATED(YL2)) DEALLOCATE(YL2, STAT = IERR)
         IF (IERR.NE.0) GOTO 80        
         IF (ALLOCATED(RESID)) DEALLOCATE(RESID, STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         IF (ALLOCATED(THEORY)) DEALLOCATE(THEORY, STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         IF (ALLOCATED(WRESID)) DEALLOCATE(WRESID, STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         IF (ALLOCATED(ESAV)) DEALLOCATE(ESAV, STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         IF (ALLOCATED(XSAV)) DEALLOCATE(XSAV, STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         IF (ALLOCATED(YSAV)) DEALLOCATE(YSAV, STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         IF (ALLOCATED(WRK)) DEALLOCATE(WRK, STAT = IERR)
         IF (IERR.NE.0) GOTO 80

         NMAX = NROW1
         NEST = NMAX + 4
         LWRK = 4*NMAX + 16*NEST + 41

         ALLOCATE(IWRK(NEST), STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         ALLOCATE(C1(NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         ALLOCATE(RK1(NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         ALLOCATE(X1(NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         ALLOCATE(Y1(NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         ALLOCATE(C2(NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         ALLOCATE(RK2(NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         ALLOCATE(X2(NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         ALLOCATE(Y2(NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         ALLOCATE(E(NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         ALLOCATE(W(2*NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         ALLOCATE(YH1(NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         ALLOCATE(YH2(NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         ALLOCATE(YL1(NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         ALLOCATE(YL2(NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         ALLOCATE(RESID(NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         ALLOCATE(THEORY(NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         ALLOCATE(WRESID(NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         ALLOCATE(ESAV(NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         ALLOCATE(XSAV(NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 80
         ALLOCATE(YSAV(NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 80 
         ALLOCATE(WRK(LWRK), STAT = IERR)
         IF (IERR.NE.0) GOTO 80     
      ENDIF 
      CALL DATAIN (KT, M1, NCOL1, NDATA, NF, NGRAF, NMAX, NROW1, NSAV1,
     +             E, ESAV, T1, W, X1, XGRAF1, XSAV, Y1, YH1, YL1, YSAV,
     +             DNAME1, FNAME,
     +             ISTOP, YREPS1)
      IF (ISTOP) GOTO 60
      NEST1 = M1 + 4
      CALL SPLINE (IWRK, KT, LWRK, M1, N1, NDATA, NEST1, NF, NGRAF,
     +             NSAV1,
     +             C1, ESAV, FP1, RESID, RK1, S1, THEORY, W, WRESID,
     +             WRK, X1, XGRAF1, XSAV, Y1, YGRAF1, YH1, YL1, YSAV, 
     +             ISTOP)
      IF (ISTOP) GOTO 60
      CALL SHOWIT (KT, M1, N1, NDATA, NF, NGRAF, NSAV1,
     +             C1, RK1, X1, XGRAF1, XSAV, Y1, YGRAF1, YSAV, 
     +             YREPS1)
      CALL SPL004 (N1, NFILE, NGRAF, NF, NMAX,
     +             C1, RK1, W, XGRAF, YGRAF)
      IF (NSETS.GT.1) THEN
C
C Fit second data set
C        
         ISEND = 16
         CALL M_FITONE (ISEND, NCOL2, NIN, NROW2,
     +                  DNAME2, TITLE2)
         IF (NROW2.GT.NMAX) THEN
C
C Re-allocate everything except C1, RK1, X1, Y1, YH1, YL1
C           
            IERR = 0
            IF (ALLOCATED(IWRK)) DEALLOCATE(IWRK, STAT = IERR)
            IF (IERR.NE.0) GOTO 80  
            IF (ALLOCATED(C2)) DEALLOCATE(C2, STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            IF (ALLOCATED(RK2)) DEALLOCATE(RK2, STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            IF (ALLOCATED(X2)) DEALLOCATE(X2, STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            IF (ALLOCATED(Y2)) DEALLOCATE(Y2, STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            IF (ALLOCATED(E)) DEALLOCATE(E, STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            IF (ALLOCATED(W)) DEALLOCATE(W, STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            IF (ALLOCATED(YH2)) DEALLOCATE(YH2, STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            IF (ALLOCATED(YL2)) DEALLOCATE(YL2, STAT = IERR)
            IF (IERR.NE.0) GOTO 80        
            IF (ALLOCATED(RESID)) DEALLOCATE(RESID, STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            IF (ALLOCATED(THEORY)) DEALLOCATE(THEORY, STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            IF (ALLOCATED(WRESID)) DEALLOCATE(WRESID, STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            IF (ALLOCATED(ESAV)) DEALLOCATE(ESAV, STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            IF (ALLOCATED(XSAV)) DEALLOCATE(XSAV, STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            IF (ALLOCATED(YSAV)) DEALLOCATE(YSAV, STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            IF (ALLOCATED(WRK)) DEALLOCATE(WRK, STAT = IERR)
            IF (IERR.NE.0) GOTO 80

            NMAX = NROW2
            NEST = NMAX + 4
            LWRK = 4*NMAX + 16*NEST + 41

            ALLOCATE(IWRK(NEST), STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            ALLOCATE(C2(NMAX), STAT = IERR)
            IF (IERR.NE.0) GOTO 80  
            ALLOCATE(RK2(NMAX), STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            ALLOCATE(X2(NMAX), STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            ALLOCATE(Y2(NMAX), STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            ALLOCATE(E(NMAX), STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            ALLOCATE(W(2*NMAX), STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            ALLOCATE(YH2(NMAX), STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            ALLOCATE(YL2(NMAX), STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            ALLOCATE(RESID(NMAX), STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            ALLOCATE(THEORY(NMAX), STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            ALLOCATE(WRESID(NMAX), STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            ALLOCATE(ESAV(NMAX), STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            ALLOCATE(XSAV(NMAX), STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            ALLOCATE(YSAV(NMAX), STAT = IERR)
            IF (IERR.NE.0) GOTO 80 
            ALLOCATE(WRK(LWRK), STAT = IERR)
            IF (IERR.NE.0) GOTO 80 
            ACTION = .TRUE.      
         ELSE
            ACTION = .FALSE.     
         ENDIF           
         CALL DATAIN (K2, M2, NCOL2, NDATA, NF, NGRAF, NMAX, NROW2, 
     +                NSAV2,
     +                E, ESAV, T2, W, X2, XGRAF2, XSAV, Y2, YH2, YL2,
     +                YSAV,
     +                DNAME2, FNAME,
     +                ISTOP, YREPS2)
         IF (ISTOP) GOTO 60
         NEST2 = M2 + 4
         CALL SPLINE (IWRK, K2, LWRK, M2, N2, NDATA, NEST2, NF, NGRAF,
     +                NSAV2, 
     +                C2, ESAV, FP2, RESID, RK2, S2, THEORY, W, WRESID, 
     +                WRK, X2, XGRAF2, XSAV, Y2, YGRAF2, YH2, YL2, YSAV, 
     +                ISTOP)
         IF (ISTOP) GOTO 60
         CALL SHOWIT (K2, M2, N2, NDATA, NF, NGRAF, NSAV2,
     +                C2, RK2, X2, XGRAF2, XSAV, Y2, YGRAF2, YSAV,
     +                YREPS2)
         CALL SPL004 (N2, NFILE, NGRAF, NF, NMAX,
     +                C2, RK2, W, XGRAF, YGRAF)
         CALL SUMMIT (M1, M2, N1, N2, NDATA, NF, NGRAF,
     +                C1, C2, RK1, RK2, XGRAF1, XGRAF2, X1, X2,
     +                YH1, YH2, YL1, YL2, YGRAF1, YGRAF2, Y1, Y2)
         IF (ACTION) THEN
C
C Re-allocate C1, RK1, X1, Y1, YH1, YL1
C           
            ACTION = .FALSE.
            IERR = 0
            IF (ALLOCATED(C1)) DEALLOCATE(C1, STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            IF (ALLOCATED(RK1)) DEALLOCATE(RK1, STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            IF (ALLOCATED(X1)) DEALLOCATE(X1, STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            IF (ALLOCATED(Y1)) DEALLOCATE(Y1, STAT = IERR)
            IF (IERR.NE.0) GOTO 80        
            IF (ALLOCATED(YH1)) DEALLOCATE(YH1, STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            IF (ALLOCATED(YL1)) DEALLOCATE(YL1, STAT = IERR)
            IF (IERR.NE.0) GOTO 80

            ALLOCATE(C1(NMAX), STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            ALLOCATE(RK1(NMAX), STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            ALLOCATE(X1(NMAX), STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            ALLOCATE(Y1(NMAX), STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            ALLOCATE(YH1(NMAX), STAT = IERR)
            IF (IERR.NE.0) GOTO 80
            ALLOCATE(YL1(NMAX), STAT = IERR)
            IF (IERR.NE.0) GOTO 80
         ENDIF           
      ENDIF
C
C LABEL 60: Another go ?
C ========
C
   60 CONTINUE
      IF (NSETS.EQ.1) THEN
         CALL GOSTOP (NF, 
     +                DNAME1, FNAME, PNAME,
     +                ISTOP)
      ELSE
         CALL STOP02 (NF, 
     +                DNAME1, DNAME2, FNAME, PNAME,
     +                ISTOP)        
      ENDIF  
      IF (.NOT.ISTOP) GOTO 40
C
C LABEL 80: terminate program
C ========
C
   80 CONTINUE

C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = 1
      ACTION = .FALSE.
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
C
C======================================================================
C
      CLOSE (UNIT = NF)
      
C
C Format statement
C
  100 FORMAT (
     + 'Choose the procedure required for program COMPARE'
     +/
     +/'You can fit single data sets, or fit then compare'
     +/'matched pairs.'
     +/
     +/'Single files (or first files of pairs) are'
     +/'reference files, while the second of matched'
     +/'pairs are referred to as comparison files.'
     +/
     +/'Just fit single sets'
     +/'Fit then compare matched sets'
     +/'Help'
     +/'Quit ... Exit program COMPARE')
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE ADVISE (DVER,
     +                   ABORT, FIRST)
C
C Advise user
C
      IMPLICIT   NONE
C
C Arguments
C
      CHARACTER (LEN = *), INTENT (IN)  :: DVER
      LOGICAL,             INTENT (IN)  :: FIRST 
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 3, NUMHDR = 13, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_COMPARE
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help           ',
     +'Run the program',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (FIRST) THEN
            WRITE (HEADER,100) DVER
            ISEND = 1
            CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
            ISEND = 1
         ENDIF
         IF (ISEND.EQ.1) THEN
            CALL HELP_COMPARE ('compare')
            IF (FIRST) THEN
               REPEET = .TRUE.
            ELSE
               ABORT = .FALSE.
               REPEET = .FALSE.
            ENDIF
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      ' 
     +/'Program `COMPARE'
     +/'        `      ' 
     +/'Action  `Wtd. least squares splines data smoothing to plot'
     +/'        `graphs or estimate derivatives/areas. Also compare'
     +/'        `two best-fit curves for significant differences.'
     +/'        `      ' 
     +/'Version `',A
     +/'        `      ' 
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      ' 
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C
