C
C INCLUDE file for COMPARE
C ========================
C DATAIN
C ERRBAR
C SHOWIT
C SPLINE
C SUMMIT
C
      SUBROUTINE DATAIN (K, M, NCOL, NDATA, NF, NGRAF, NMAX, NROW, NSAV,
     +                   E, ESAV, T, W, X, XGRAF, XSAV, Y, YH, YL, YSAV,
     +                   DNAME, FNAME,
     +                   ISTOP, YREPS)
C
C Read in data then produce arrays W, X, Y, YH and YL
C
      IMPLICIT   NONE
c
c Arguments
c      
      INTEGER,             INTENT (IN)    :: K, NDATA, NF, NGRAF, NMAX
      INTEGER,             INTENT (OUT)   :: M, NSAV
      INTEGER,             INTENT (INOUT) :: NCOL, NROW 
      DOUBLE PRECISION,    INTENT (OUT)   :: E(NMAX), W(NMAX), X(NMAX),
     +                                       Y(NMAX), YH(NMAX), YL(NMAX)
      DOUBLE PRECISION,    INTENT (OUT)   :: ESAV(NMAX), XSAV(NMAX),
     +                                       YSAV(NMAX)
      DOUBLE PRECISION,    INTENT (OUT)   :: XGRAF(NGRAF)
      CHARACTER (LEN = *), INTENT (INOUT) :: DNAME, FNAME
      LOGICAL,             INTENT (OUT)   :: ISTOP, YREPS
C
C Locals
C      
      INTEGER    ISEND, ITYPE
      INTEGER    NIN
      PARAMETER (NIN = 3)
      INTEGER    I, NERR, NLIM
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (LSHADE = 2, NUMOPT = 3, NSTART = 6, NTEXT = 8)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      DOUBLE PRECISION ONE, RTOL
      PARAMETER (ONE = 1.0D+00, RTOL = 1.0D-150)
      DOUBLE PRECISION T
      DOUBLE PRECISION DELTA
      CHARACTER  TITLE*80
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      CHARACTER  LINE*100, TEXT(NTEXT)*100
      CHARACTER (LEN = 80) TRIM80, WORD80
      LOGICAL    FIRST1, FIRST2, FIXNPT, LABEL, YES
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .TRUE., HIGH = .TRUE.)
      EXTERNAL   DATTIN, RESFIL, PUTFAT, NYYBAR, PUTADV, LBOX01,
     +           YESNO2, TRIM80
      EXTERNAL   ERRBAR, ISITMF
      INTRINSIC  DBLE
      SAVE       ITYPE, FIRST1, FIRST2, FIXNPT, LABEL
      DATA       FIRST1, FIRST2 / .FALSE., .TRUE. /
      DATA NUMBLD / 5*1, 3*0 /
      DATA NUMPOS /NUMOPT*1 /
C
C Initialise
C      
      M = 0
      NSAV = 0
      ISTOP = .TRUE.
      YREPS = .FALSE.
      
      FIXNPT = .FALSE.
      LABEL = .TRUE.
      IF (FIRST1) THEN
C
C Request data input type if FIRST1 = .TRUE.
C        
         DNAME = BLANK
         WRITE (TEXT,100)
         ICOLOR = 3
         IX = 4
         IY = 4
         ITYPE = 2
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, ITYPE, NUMOPT,
     +                NUMPOS, NSTART, NTEXT, 
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         FIRST1 = .FALSE.
      ELSE
         ITYPE = 2        
      ENDIF
C
C Read in and check data
C
      CALL ISITMF (NCOL, NROW,
     +             DNAME)
      IF ((NCOL.EQ.2 .OR. NCOL.EQ.3) .AND. NROW.LT.4) THEN
         CALL PUTFAT ('Must have at least 4 values ... Try again')
         NCOL = 0
         NROW = 0
      ENDIF
           
   20 CONTINUE
      IF ((NCOL.EQ.2 .OR. NCOL.EQ.3) .AND. NROW.GT.3) THEN
         CLOSE (UNIT = NIN)
         OPEN (UNIT = NIN, FILE = DNAME)
         READ (NIN,'(A)') TITLE
         READ (NIN,*) NROW, NCOL
         M = NROW
         IF (NCOL.EQ.2) THEN
            DO I = 1, M
               READ (NIN,*) X(I), Y(I)
               E(I) = ONE
            ENDDO
         ELSE
           DO I = 1, M
               READ (NIN,*) X(I), Y(I), E(I)
            ENDDO
         ENDIF 
         CLOSE (UNIT = NIN)
         ISEND = ITYPE         
      ELSE  
         ISEND = ITYPE
         IF (K.GT.0) THEN
            WRITE (LINE,200) NDATA, K
            CALL PUTADV (LINE)
         ENDIF
         CLOSE (UNIT = NIN)
         CALL DATTIN (ISEND, NIN, NMAX, M,
     +                E, X, Y,
     +                DNAME, TITLE,
     +                ISTOP, FIXNPT, LABEL)
         CLOSE (UNIT = NIN)
         CALL ISITMF (NCOL, NROW,
     +                DNAME)           
         IF (ISTOP) RETURN
         IF (ISEND.EQ.2) THEN
            IF (ISTOP) THEN
               LINE = ' Try another filename ?'
               ICOLOR = 9
               IX = 4
               IY = 4
               YES = .TRUE.
               CALL YESNO2 (ICOLOR, IX, IY, LINE, YES)
               IF (YES) THEN
                  NCOL = 0
                  NROW = 0
                  GOTO 20
               ELSE
                  RETURN
               ENDIF
            ENDIF
         ENDIF
      ENDIF   
      
      IF (FIRST2) THEN
         CALL RESFIL (NF,
     +                FNAME,
     +                ISTOP)
         IF (ISTOP) THEN
            FNAME = BLANK
            RETURN
         ENDIF
         WRITE (NF,300)
         FIRST2 = .FALSE.
      ENDIF
      
      NSAV = M
      IF (M.LT.4) THEN
         CALL PUTFAT ('Must have at least 4 values ... Try again')
         ISTOP = .TRUE.
         NCOL = 0
         NROW = 0
         GOTO 20
      ENDIF
C
C Check for replicates, X in increasing order, E > 0 and save original data
C
      YREPS = .FALSE.
      IF (E(1).LT.RTOL) THEN
         WRITE (LINE,400) NDATA, K, 1
         CALL PUTFAT (LINE)
         ISTOP = .TRUE.
         NCOL = 0
         NROW = 0
         GOTO 20
      ENDIF
      ESAV(1) = ONE
      XSAV(1) = X(1)
      YSAV(1) = Y(1)
      DO I = 2, M
         IF (X(I).LT.X(I - 1) .OR. E(I).LT.RTOL) THEN
            WRITE (LINE,400) I
            CALL PUTFAT (LINE)
            ISTOP = .TRUE.
            NCOL = 0
            NROW = 0
            GOTO 20
         ENDIF
         IF (X(I).LE.X(I - 1)) YREPS = .TRUE.
         ESAV(I) = ONE
         XSAV(I) = X(I)
         YSAV(I) = Y(I)
      ENDDO
C
C Calculate XGRAF for graphical axes
C
         XGRAF(1) = X(1)
         DELTA = (X(M) - X(1))/DBLE(NGRAF - 1)
         DO I = 2, NGRAF - 1
            XGRAF(I) = XGRAF(I - 1) + DELTA
         ENDDO
         XGRAF(NGRAF) = X(M)
C
C M, XGRAF, X, Y, have now been initialised
C Now E, T, YH, YL and W must be calculated
C If YREPS create means and STD.ERRORS OF MEANS, M and X,Y, may be changed
C
      IF (YREPS) THEN
         I = 2
         CALL NYYBAR (I, M, 
     +                X, Y, E)
      ENDIF
      CALL ERRBAR (K, NDATA, NERR, NLIM, M, NSAV,
     +             E, T, W, Y, YH, YL,
     +             YREPS)
      IF (K.GT.0) THEN
         WRITE (NF,500) NDATA, K
      ELSE
         WRITE (NF,600) NDATA
      ENDIF
      IF (ISEND.EQ.2) THEN
         WORD80 = TRIM80(DNAME)
         WRITE (NF,700) WORD80
      ENDIF   
      WRITE (NF,800) TITLE
      ISTOP = .FALSE.
C
C Format statements
C      
  100 FORMAT (
     + 'Now select the type of data input'
     +/'mode you wish to employ.'
     +/'Your choice will then be used for'
     +/'the current set of analyses.'
     +/
     +/'Data typed in'
     +/'Data from file'
     +/'Choose each time')
  200 FORMAT ('Now supply x,y,s values for matched pair',I3,':',I1)
  300 FORMAT (/1X,'PACKAGE : SIMFIT'/1X,'PROGRAM : COMPARE'
     +/1X,'ACTION  : Spline data-smoothing/areas/comparison'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U.K.')
  400 FORMAT ('Error at data point no.',I6,' ... Try again')
  500 FORMAT (/1X,'Analysis for matched pair number',I3,':',I1
     +/1X,'--------------------------------------')
  600 FORMAT (/1X,'Analysis number',I3
     +/1X,        '------------------')
  700 FORMAT (1X,'File name'/1X,A)
  800 FORMAT (1X,'Data title'/1X,A)
      END
C
C------------------------------------------------------------------------
C
      SUBROUTINE ERRBAR (K, NDATA, NERR, NLIM, NPTS, NSAV,
     +                   E, T, W, Y, YH, YL,
     +                   YREPS)
C
C Define weights W and confidence limits S, YH, YL given errors E
C 31/05/2013 initialised SHOW_MENU .TRUE. in case it is needed again to suppress menus
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: K, NDATA, NPTS, NSAV
      INTEGER,          INTENT (INOUT) :: NERR, NLIM
      DOUBLE PRECISION, INTENT (INOUT) :: E(NPTS), Y(NPTS)
      DOUBLE PRECISION, INTENT (OUT)   :: W(NPTS), YH(NPTS), YL(NPTS)
      LOGICAL,          INTENT (IN)    :: YREPS
C
C Locals
C      
      INTEGER    I, IFAIL, NDOF, NREPS
      INTEGER    N0
      PARAMETER (N0 = 0)
      INTEGER    ICOLOR, IX, IY, LSHADE
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 2)
      INTEGER    NUMOPT, NSTART, NTEXT, NUMBLD(15), NUMPOS(15)
      DOUBLE PRECISION T
      DOUBLE PRECISION ZERO, PNT975, ONE, TWO, CENT
      PARAMETER (ZERO = 0.0D+00, PNT975 = 0.975D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00, CENT = 100.0D+00)
      DOUBLE PRECISION XBOT, XTOP, X25
      PARAMETER (XBOT = 1.0D-06, XTOP = 1.0D+06, X25 = 25.0D+00)
      DOUBLE PRECISION FRACN, RNREPS, ROOTN
      DOUBLE PRECISION G01FBF$
      CHARACTER  TEXT(20)*63
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    SHOW_MENU
      LOGICAL    ABORT, FIRST
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   ADVISE
      EXTERNAL   GETRM1, PUTWAR, PUTIFA, PUTADV, GETIGT, GETRGT, LBOX01
      EXTERNAL   G01FBF$
      INTRINSIC  ABS, NINT, SQRT, DBLE
      DATA NUMBLD / 15*0 /
      DATA NUMPOS / 15*1 /
      SHOW_MENU = .TRUE.
C
C Decide on the type of STD. ERRORS supplied
C
      IF (YREPS) THEN
   20    CONTINUE
         IF (SHOW_MENU) THEN
            WRITE (TEXT,100) NDATA, K
            NSTART = 10
            NUMOPT = 4
            NTEXT = NSTART + NUMOPT - 1
            NERR = 1
            CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NERR, NUMOPT,
     +                   NUMPOS, NSTART, NTEXT,
     +                   TEXT, 
     +                   BORDER, FLASH, HIGH)
            IF (NERR.EQ.3) THEN
               NREPS = 1
               T = ZERO
               DO I = 1, NPTS
                  E(I) = ONE
               ENDDO
               GOTO 80
            ELSEIF (NERR.EQ.NUMOPT) THEN
               FIRST = .FALSE.
               CALL ADVISE (BLANK,
     +                      ABORT, FIRST)
               GOTO 20
            ENDIF
            IF (NERR.EQ.2) NERR = NERR + 1
         ELSE
            NERR = 1
         ENDIF     
      ELSE
         IF (SHOW_MENU) THEN
   40       CONTINUE
            WRITE (TEXT,200) NDATA, K
            NSTART = 11
            NUMOPT = 5
            NTEXT = NSTART + NUMOPT - 1
            NERR = 3
            CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NERR, NUMOPT,
     +                   NUMPOS, NSTART, NTEXT, 
     +                   TEXT, 
     +                   BORDER, FLASH, HIGH)
            IF (NERR.EQ.4) THEN
               NREPS = 1
               T = ZERO
               DO I = 1, NPTS
                  E(I) = ONE
               ENDDO
               GOTO 80
            ELSEIF (NERR.EQ.NUMOPT) THEN
               FIRST = .FALSE.
               CALL ADVISE (BLANK,
     +                      ABORT, FIRST)
               GOTO 40
            ENDIF
         ELSE
            NERR = 4
            NREPS = 1
            T = ZERO
            DO I = 1, NPTS
               E(I) = ONE
            ENDDO
            GOTO 80
         ENDIF      
      ENDIF
      IF (NERR.EQ.3) THEN
         CALL GETRM1 (XBOT, FRACN, XTOP,
     +               'cv% required for standard errors (e.g. 7.5)')
         IF (FRACN.LT.ONE .OR. FRACN.GT.X25) CALL PUTWAR
     +      ('Unrealistic value ... 5 to 10% is more usual')
         FRACN = FRACN/CENT
         DO I = 1, NPTS
            E(I) = FRACN*ABS(Y(I))
         ENDDO
      ENDIF
C
C Read/estimate no. of replicates used and make sure E = STD. ERR. MEAN
C
      IF (YREPS) THEN
         RNREPS = DBLE(NSAV)
         RNREPS = RNREPS/DBLE(NPTS)
         NREPS = NINT(RNREPS)
      ELSE
         CALL PUTADV ('No error bars will be plotted if no. reps. = 1')
         CALL GETIGT (NREPS, N0,
     +               'No. of replicates (>=1) used to calculate means')
         RNREPS = NREPS
      ENDIF
      IF (NREPS.EQ.1) THEN
         T = ZERO
         GOTO 80
      ENDIF
      ROOTN = SQRT(RNREPS)
      IF (NERR.GT.1) THEN
         DO I = 1, NPTS
            E(I) = E(I)/ROOTN
         ENDDO
      ENDIF
C
C Decide the type of error bars required
C
   60 CONTINUE
      IF (SHOW_MENU) THEN
         WRITE (TEXT,300) NDATA, K
         NSTART = 4
         NUMOPT = 4
         NTEXT = NSTART + NUMOPT - 1
         NLIM = 1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NLIM, NUMOPT,
     +                NUMPOS, NSTART, NTEXT, 
     +                TEXT, 
     +                BORDER, FLASH, HIGH)
         IF (NLIM.EQ.NUMOPT) THEN
            FIRST = .FALSE.
            CALL ADVISE (BLANK,
     +                   ABORT, FIRST)
            GOTO 60
         ENDIF
         IF (NLIM.EQ.1) THEN
            NDOF = NREPS - 1
            IFAIL = 1
            I = 2
            T = G01FBF$('Lower-tail', PNT975, DBLE(NDOF), IFAIL)
            CALL PUTIFA (IFAIL, I, 'G01FBF/ERRBAR')
         ELSEIF (NLIM.EQ.2) THEN
            T = TWO*ROOTN
         ELSE
            CALL GETRGT (T, ZERO, 'Value required for n (>0)')
            T = ROOTN*T
         ENDIF
      ELSE
         NLIM = 1
         NDOF = NREPS - 1
         IFAIL = 1
         I = 2
         T = G01FBF$('Lower-tail', PNT975, DBLE(NDOF), IFAIL)
         CALL PUTIFA (IFAIL, I, 'G01FBF/ERRBAR')
      ENDIF      
C
C Finally define W, YH and YL using T, Y and E
C
   80 CONTINUE
      DO I = 1, NPTS
         YH(I) = Y(I) + T*E(I)
         YL(I) = Y(I) - T*E(I)
         W(I) = ONE/E(I)
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Advice   `Your data set contains replicates at some or'
     +/'         `all x-values and now you must decide on the'
     +/'         `type of weighting you wish to use for spline'
     +/'         `fitting. The s-values you supplied have been'
     +/'         `discarded at all sets of replicates but new'
     +/'         `s-values equal to standard errors of mean-Y'
     +/'         `have been calculated where possible from the'
     +/'         `replicates in data set',I3,':',I1
     +/
     +/'Use calculated s for weighting/error bars'
     +/'Use cv% rather than calculated s-values'
     +/'Unweighted fitting (s=1), no error bars'
     +/'Help')
  200 FORMAT (
     + 'Advice   `Your data set contains no replicates and so'
     +/'         `it has to be concluded that either you have'
     +/'         `no replicates or have input mean-y-values.'
     +/'         `The s-values you have supplied can be any'
     +/'         `arbitrary numbers, say s = 1, or they may be'
     +/'         `estimated standard deviations of y or else'
     +/'         `standard errors of mean-y-values.'
     +/'         `Now indicate the type of standard errors s'
     +/'         `you have supplied in data set',I3,':',I1
     +/
     +/'s are equal to standard errors of mean y'
     +/'s are equal to standard deviations of y'
     +/'s are arbitrary, use cv% to estimate s'
     +/'Unweighted fitting (s=1), no error bars'
     +/'Help')
  300 FORMAT (
     + 'Choose which type of error bars'
     +/'to display for data set',I4,':',I1
     +/
     +/'95% limits on mean-y ***'
     +/'2 std. dev. of y'
     +/'n std. dev. of y'
     +/'Help')
      END
C
C------------------------------------------------------------------------
C
      SUBROUTINE SHOWIT (K, M, N, NDATA, NF, NGRAF, NSAV,
     +                   C, RK, X, XGRAF, XSAV, Y, YGRAF, YSAV,
     +                   YREPS)
C
C Summary for single curve
C 02/03/20222 added e_numbers and e_formats, etc.
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: K, M, N, NDATA, NF, NGRAF, NSAV
      DOUBLE PRECISION, INTENT (IN) :: C(N), RK(N)
      DOUBLE PRECISION, INTENT (IN) :: X(M), XGRAF(NGRAF), XSAV(NSAV)
      DOUBLE PRECISION, INTENT (IN) :: Y(M), YGRAF(NGRAF), YSAV(NSAV)
      LOGICAL,          INTENT (IN) :: YREPS
C
C Locals
C      
      INTEGER    L0, L1
      PARAMETER (L0 = 0, L1 = 1)
      INTEGER    IFAIL
      INTEGER    ICOLOR, IX, IY, NTEXT, NTITLE
      PARAMETER (NTEXT = 7, NTITLE = 1)
      DOUBLE PRECISION AREA1, AREA2, DIFF, RATIO, RATIO2, SUM1
      DOUBLE PRECISION TWO
      PARAMETER (TWO = 2.0D+00)
      CHARACTER (LEN = 13) D13(3), SHOWLJ
      CHARACTER  PTITLE*25, XTITLE*1, YTITLE*1
      CHARACTER  LINE*100, TEXT(NTEXT)*100, TITLE(NTITLE)*100
      LOGICAL    SAVEIT
      PARAMETER (SAVEIT = .TRUE.)
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    YES
      LOGICAL    FRAME
      PARAMETER (FRAME = .TRUE.)
      EXTERNAL   E_FORMATS, SHOWLJ
      EXTERNAL   TRAPZD, GKS004, PUTIFA, PUTFAT, YESNO2, TABLE3
      EXTERNAL   E02BDF$
      INTRINSIC  ABS
      DATA       PTITLE, XTITLE, YTITLE / 'Best fit to original data',
     +                                    'X', 'Y' /
      E_NUMBERS = E_FORMATS()
      IF (YREPS) THEN
         WRITE (LINE,100) NDATA, K
         ICOLOR = 9
         IX = 4
         IY = 4
         YES = .FALSE.
         CALL YESNO2 (ICOLOR, IX, IY,
     +                LINE,
     +                YES)
         IF (YES) THEN
            CALL GKS004 (L0, L1, L0, L0, L1, L0, L0, L0,
     +                   NSAV, NGRAF, NGRAF, NGRAF,
     +                   XSAV, XGRAF, XGRAF, XGRAF, 
     +                   YSAV, YGRAF, YGRAF, YGRAF,
     +                   PTITLE, XTITLE, YTITLE,
     +                   SAVEIT, SAVEIT)
         ENDIF
      ENDIF
      CALL TRAPZD (M,
     +             AREA1, X, Y)
      IFAIL = 1
      CALL E02BDF$(N, RK, C, AREA2, IFAIL)
      CALL PUTIFA (IFAIL, NF, 'E02BDF/SHOWIT')
      DIFF = ABS(AREA1 - AREA2)
      SUM1 = AREA1 + AREA2
      IF (SUM1.LE.1.0D-300) THEN
         CALL PUTFAT ('Sum of areas = 0 ... Ratio set = 0')
         RATIO = 0.0D+00
      ELSE
         RATIO = DIFF/(AREA1 + AREA2)
      ENDIF
      RATIO2 = TWO*RATIO
      WRITE (TITLE,200) NDATA, K
      IF (E_NUMBERS) THEN
         WRITE (TEXT,300) AREA1, AREA2, DIFF, RATIO, 100.0D+00*RATIO,
     +                    RATIO2, 100.0D+00*RATIO2                     
      ELSE
         D13(1) = SHOWLJ(AREA1)
         D13(2) = SHOWLJ(AREA2)
         D13(3) = SHOWLJ(DIFF) 
         WRITE (TEXT,350) D13(1), D13(2), D13(3), RATIO,
     +                    100.0D+00*RATIO, RATIO2, 100.0D+00*RATIO2    
      ENDIF  
      ICOLOR = 15
      CALL TABLE3 (ICOLOR, NTEXT, NTITLE,
     +             TEXT, TITLE,
     +             FRAME)
      IF (E_NUMBERS) THEN
         WRITE (NF,400) AREA1, AREA2, DIFF, RATIO, 100.0D+00*RATIO,
     +                  RATIO2, 100.0d+00*RATIO2 
      ELSE
         D13(1) = SHOWLJ(AREA1)
         D13(2) = SHOWLJ(AREA2)
         D13(3) = SHOWLJ(DIFF) 
         WRITE (NF,450) D13(1), D13(2), D13(3), RATIO,
     +                  100.0D+00*RATIO, RATIO2, 100.0D+00*RATIO 

      ENDIF  
C
C Format statements
C      
  100 FORMAT (
     +'Display fit to replicates in data set',I3,':',I1,1X,'?')
  200 FORMAT ('Estimates for data set',I3,':',I1)
  300 FORMAT (
     + 'Area by trapezoidal rule        (A)  =',1P,E13.5
     +/'Area under best-fit spline      (B)  =',   E13.5
     +/'Absolute difference   (C = |A - B|)  =',   E13.5
     +/'Fractional difference     C/(A + B)  =',0P,F9.4
     +/'Percent difference between A and B   =',   F9.4,
     + '% (denominator = sum)'
     +/'Fractional difference C/[0.5(A + B)] =',   F9.4
     +/'Percent difference between A and B   =',   F9.4,
     + '% (denominator = average)')
  350 FORMAT (
     + 'Area by trapezoidal rule        (A)  =',1X,A
     +/'Area under best-fit spline      (B)  =',1X,A
     +/'Absolute difference   (C = |A - B|)  =',1X,A
     +/'Fractional difference     C/(A + B)  =',F9.4
     +/'Percent difference between A and B   =',F9.4,
     + '% (denominator = sum)'
     +/'Fractional difference C/[0.5(A + B)] =',F9.4
     +/'Percent difference between A and B   =',F9.4,
     + '% (denominator = average)')   
  400 FORMAT (
     +/1X,'Area by trapezoidal rule         (A) =',1P,E13.5
     +/1X,'Area under best-fit spline       (B) =',   E13.5
     +/1X,'Absolute difference    (C = |A - B|) =',   E13.5
     +/1X,'Fractional difference      C/(A + B) =',0P,F9.4
     +/1X,'Percent difference between A and B   =',   F9.4,
     +    '% (denominator = sum)'
     +/1X,'Fractional difference C/[0.5(A + B)] =',   F9.4
     +/1X,'Percent difference between A and B   =',   F9.4,
     +    '% (denominator = average)'
     /)
  450 FORMAT (
     +/1X,'Area by trapezoidal rule         (A) =',1X,A
     +/1X,'Area under best-fit spline       (B) =',1X,A
     +/1X,'Absolute difference    (C = |A - B|) =',1X,A
     +/1X,'Fractional difference      C/(A + B) =',F9.4
     +/1X,'Percent difference between A and B   =',F9.4,
     +    '% (denominator = sum)'
     +/1X,'Fractional difference C/[0.5(A + B)] =',F9.4
     +/1X,'Percent difference between A and B   =',F9.4,
     +    '% (denominator = average)'
     /)    
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE SPLINE (IWRK, K, LWRK, M, N, NDATA, NEST, NF, NGRAF,
     +                   NSAV,
     +                   C, ESAV, FP, RESID, RK, S, THEORY,
     +                   W, WRESID, WRK, X, XGRAF, XSAV, Y, YGRAF,
     +                   YH, YL, YSAV,
     +                   ISTOP)
C
C ACTION : Fit spline using E02BEF
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 20/6/91
C ADVICE : Eliminate ICOUNT etc. if hot/cold start facility required
C 02/03/20222 added e_numbers and e_formats, etc.
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: K, LWRK, M, NDATA, NEST,
     +                                  NF, NGRAF, NSAV
      INTEGER,          INTENT (OUT) :: N
      INTEGER,          INTENT (OUT) :: IWRK(NEST)
      DOUBLE PRECISION, INTENT (IN)  :: ESAV(NSAV), X(M), XSAV(NSAV),
     +                                  Y(M), YSAV(NSAV), W(M)
      DOUBLE PRECISION, INTENT (IN)  :: XGRAF(NGRAF)
      DOUBLE PRECISION, INTENT (OUT) :: C(NEST), FP, RK(NEST), S
      DOUBLE PRECISION, INTENT (OUT) :: RESID(NSAV),THEORY(NSAV),
     +                                  WRESID(NSAV), WRK(LWRK)
      DOUBLE PRECISION, INTENT (OUT) :: YGRAF(NGRAF)
      DOUBLE PRECISION, INTENT (IN)  :: YH(M), YL(M)
      LOGICAL,          INTENT (OUT) :: ISTOP
C
C Locals
C      
      INTEGER    L0, L1, L5, NPAR
      PARAMETER (L0 = 0, L1 = 1, L5 = 5, NPAR = 4)
      INTEGER    I, ICOUNT, IFAIL, NDEC
      INTEGER    COLOUR
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT
      INTEGER    NUMBLD(11), NUMPOS(11)
      INTEGER    NTEMP(3)
      DOUBLE PRECISION XTEMP(3)
      DOUBLE PRECISION SBIG, SMIN, S0
      PARAMETER (SBIG = 1.0D+4, SMIN = 1.0D-06, S0 = 1.0D+00)
      DOUBLE PRECISION SMAX, STRY
      CHARACTER (LEN = 13) D13(4), SHOWLJ
      CHARACTER (LEN = 12) I12, FORM12
      CHARACTER  START*1
      CHARACTER  PTITLE*15, XTITLE*1, YTITLE*1
      CHARACTER  TEXT(30)*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ABORT, FIRST
      LOGICAL    SAVEIT
      PARAMETER (SAVEIT = .TRUE.)
      LOGICAL    FILE1, FILE2, GRAPH, TAB1, TAB2
      LOGICAL    SHOW_MENU
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., HIGH = .TRUE.)
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   ADVISE
      EXTERNAL   E02BEF$, E02BBF$
      EXTERNAL   PUTIFA, GKSEB4, GKSR01, LBOX01, TABLE4
      DATA       PTITLE, XTITLE, YTITLE / 'Best-fit spline', 'X', 'Y' /
      DATA       NUMBLD / 1*1, 10*0 /
      DATA       NUMPOS / 11*1 /
      DATA       SHOW_MENU / .TRUE. / 
      E_NUMBERS = E_FORMATS()
      ICOUNT = 1
      START = 'C'
      S = S0
   20 CONTINUE
      IFAIL = 1
      CALL E02BEF$(START, M, X, Y, W, S, NEST, N, RK, C, FP, WRK, LWRK,
     +             IWRK, IFAIL)
      IF (IFAIL.NE.0) THEN
         CALL PUTIFA (IFAIL, NF, 'E02BEF/SPLINE')
         ISTOP = .TRUE.
         RETURN
      ELSE
         ISTOP = .FALSE.
C
C Swap next two lines if hot/cold start facility required
C
C********IF (START.EQ.'C') THEN
         IF (ICOUNT.EQ.1) THEN
            STRY = M
            SMAX = DBLE(NINT(FP) + 1)
            IF (STRY.GT.SMAX) STRY = SMAX/2.0D+00
         ENDIF
      ENDIF
      IFAIL = 1
      DO I = 1, NGRAF
         CALL E02BBF$(N, RK, C, XGRAF(I), YGRAF(I), IFAIL)
         IF (IFAIL.NE.0) THEN
            CALL PUTIFA (IFAIL, NF, 'E02BBF/SPLINE')
            ISTOP = .TRUE.
            RETURN
         ENDIF
      ENDDO
      IFAIL = 1
      DO I = 1, NSAV
         CALL E02BBF$(N, RK, C, XSAV(I), THEORY(I), IFAIL)
         IF (IFAIL.NE.0) THEN
            CALL PUTIFA (IFAIL, NF, 'E02BBF/SPLINE')
            ISTOP = .TRUE.
            RETURN
         ENDIF
      ENDDO
   40 CONTINUE
      ICOLOR = 3
      IX = 4
      IY = 4
      LSHADE = 3
      NSTART = 7
      NTEXT = 11
      NUMOPT = 5
C
C Swap next two lines if hot/cold start facility required
C
C*****IF (START.EQ.'C') THEN
      IF (ICOUNT.EQ.1) THEN
         FLASH = .TRUE.
         IF (E_NUMBERS) THEN
            WRITE (TEXT,100) NDATA, K, N - 8, S, FP
         ELSE
            I12 = FORM12(N - 8)
            D13(1) = SHOWLJ(S)
            D13(2) = SHOWLJ(FP)
            WRITE (TEXT,150) NDATA, K, I12, D13(1), D13(2) 
         ENDIF  
         NDEC = 3
      ELSE
         FLASH = .FALSE.
         IF (E_NUMBERS) THEN
            WRITE (TEXT,200) NDATA, K, N - 8, S, FP
         ELSE
            I12 = FORM12(K)
            D13(1) = SHOWLJ(S)
            D13(2) = SHOWLJ(FP)
            WRITE (TEXT,250) NDATA, K, I12, D13(1), D13(2)  
         ENDIF  
         NDEC = 1
      ENDIF
      CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      IF (NDEC.EQ.1) THEN
         CALL GKSEB4 (L0, L1, L0, L0, L5, L0, L0, L0,
     +                M, NGRAF, M, NGRAF, X, XGRAF, X, XGRAF,
     +                YH, YH, YL, YL, Y, YGRAF, Y, YGRAF,
     +                PTITLE, XTITLE, YTITLE,
     +                SAVEIT, SAVEIT)
         GOTO 40
      ELSEIF (NDEC.EQ.2) THEN
         FILE1 = .FALSE.
         FILE2 = .FALSE.
         GRAPH = .FALSE.
         TAB1 = .FALSE.
         TAB2 = .TRUE.
         CALL GKSR01 (NF, NPAR, NSAV,
     +                RESID, ESAV, THEORY,  WRESID, XSAV, YSAV,
     +                FILE1, FILE2, GRAPH, TAB1, TAB2)
         GOTO 40
      ELSEIF (NDEC.EQ.3) THEN
         COLOUR = 15
         CALL TABLE4 (COLOUR, NTEMP, XTEMP, 'OPEN')
         IF (S.LT.STRY) STRY = STRY/2.0D+00
         IF (E_NUMBERS) THEN  
            WRITE (TEXT,300) SMIN, SMAX, S, STRY
         ELSE
            D13(1) = SHOWLJ(SMIN)
            D13(2) = SHOWLJ(SMAX)
            D13(3) = SHOWLJ(S)
            D13(4) = SHOWLJ(STRY)
            WRITE (TEXT,350) D13(1), D13(2), D13(3), D13(4)
         ENDIF  
         DO I = 1, 10
            IF (I.LE.3 .OR. I.EQ.10) THEN
               COLOUR = 4
            ELSE
               COLOUR = 0
            ENDIF
            CALL TABLE4 (COLOUR, NTEMP, XTEMP, TEXT(I))
         ENDDO
         CALL TABLE4 (ICOLOR, NTEMP, XTEMP, 'GETRM1')
         ICOLOR = 3
         XTEMP(1) = SMIN
         XTEMP(3) = SBIG
         CALL TABLE4 (ICOLOR, NTEMP, XTEMP,
     +           'Value for smoothing factor F (i.e. WSSQ required)')
         S = XTEMP(2)
         CALL TABLE4 (COLOUR, NTEMP, XTEMP, 'CLOSE (NO PROMPT)')

C
C Swap next two lines if hot/cold start facility required
C
C********START = 'W'
         ICOUNT = ICOUNT + 1
         GOTO 20
      ELSEIF (NDEC.EQ.NUMOPT) THEN
         FIRST = .FALSE.
         CALL ADVISE (BLANK,
     +                ABORT, FIRST)
         GOTO 40
      ENDIF
      IF (E_NUMBERS) THEN
         WRITE (NF,400) N - 8, S, FP
      ELSE
         I12 = FORM12 (N - 8)
         D13(1) = SHOWLJ(S)
         D13(2) = SHOWLJ(FP)
         WRITE (NF,450) I12, D13(1), D13(2) 
      ENDIF  
      FILE1 = .FALSE.
      FILE2 = .FALSE.
      GRAPH = .FALSE.
      TAB1 = .FALSE.
      TAB2 = .FALSE.
   60 CONTINUE
      IF (SHOW_MENU) THEN
         WRITE (TEXT,500) NDATA, K
         ICOLOR = 3
         IX = 4
         IY = 4
         LSHADE = 4
         NSTART = 3
         NUMOPT = 6
         NTEXT = NSTART + NUMOPT - 1
         NDEC = NUMOPT - 2
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         
         IF (NDEC.EQ.NUMOPT) THEN
            SHOW_MENU = .FALSE.
         ELSEIF (NDEC.EQ.NUMOPT - 1) THEN
            FIRST = .FALSE.
            CALL ADVISE (BLANK,
     +                   ABORT, FIRST)
            GOTO 60
         ELSEIF (NDEC.LE.3) THEN
            IF (NDEC.EQ.1) THEN
               FILE2 = .TRUE.
            ELSEIF (NDEC.EQ.2) THEN
               FILE2 = .TRUE.
               TAB2 = .TRUE.
            ELSEIF (NDEC.EQ.3) THEN
               FILE1 = .TRUE.
               FILE2 = .TRUE.
               GRAPH = .TRUE.
               TAB1 = .TRUE.
               TAB2 = .TRUE.
            ENDIF
            CALL GKSR01 (NF, NPAR, NSAV, 
     +                   RESID, ESAV, THEORY, WRESID, XSAV, YSAV, 
     +                   FILE1, FILE2, GRAPH, TAB1, TAB2)
         ENDIF
      ENDIF   
C
C Format statements
C      
  100 FORMAT (
     + 'Preliminary results for data set',I3,':',I1
     +/
     +/'Current number of spline knots =',I6
     +/'Current smoothing factor (F)   =',1P,E13.5
     +/'Weighted sum of squares (WSSQ) =',   E13.5
     +/
     +/'Display the best-fit spline'
     +/'Display analysis of residuals'
     +/'Change the smoothing factor F ***'
     +/'Accept the current spline-fit'
     +/'Help')
  150 FORMAT (
     + 'Preliminary results for data set',I3,':',I1
     +/
     +/'Current number of spline knots =',1X,A
     +/'Current smoothing factor (F)   =',1X,A
     +/'Weighted sum of squares (WSSQ) =',1X,A
     +/
     +/'Display the best-fit spline'
     +/'Display analysis of residuals'
     +/'Change the smoothing factor F ***'
     +/'Accept the current spline-fit'
     +/'Help')     
  200 FORMAT (
     + 'Current fit to data set',I3,':',I1
     +/
     +/'Current number of spline knots =',I6
     +/'Current smoothing factor (F)   =',1P,E13.5
     +/'Weighted sum of squares (WSSQ) =',   E13.5
     +/
     +/'Display the best-fit spline'
     +/'Display analysis of residuals'
     +/'Change the smoothing factor F'
     +/'Accept the current spline-fit'
     +/'Help')
  250 FORMAT (
     + 'Current fit to data set',I3,':',I1
     +/
     +/'Current number of spline knots =',1X,A
     +/'Current smoothing factor (F)   =',1X,A
     +/'Weighted sum of squares (WSSQ) =',1X,A
     +/
     +/'Display the best-fit spline'
     +/'Display analysis of residuals'
     +/'Change the smoothing factor F'
     +/'Accept the current spline-fit'
     +/'Help')     
  300 FORMAT (
     +'Choices for the smoothing factor F'
     +/' '
     +/' '
     +/'For overfit  (an interpolating spline)  set F =',1P,E13.5
     +/'For underfit (wtd. least squares cubic) set F =',   E13.5
     +/'The current smoothing factor has a value of F =',   E13.5
     +/'Based on the number of points you could try F =',   E13.5
     +/ ' '
     +/ ' '
     +/'ADVICE : Choose a value between overfit and underfit')
  350 FORMAT (
     +'Choices for the smoothing factor F'
     +/' '
     +/' '
     +/'For overfit  (an interpolating spline)  set F =',1X,A
     +/'For underfit (wtd. least squares cubic) set F =',1X,A
     +/'The current smoothing factor has a value of F =',1X,A
     +/'Based on the number of points you could try F =',1X,A
     +/ ' '
     +/ ' '
     +/'ADVICE : Choose a value between overfit and underfit')     
  400 FORMAT (/1X,'Knots =',I6/5X,'F =',1P,E13.5/2X,'WSSQ =',E13.5)
  450 FORMAT (/1X,'Knots =',1X,A,
     +        /1X,'F =',1X,A
     +        /1X,'WSSQ =',1X,A)
  500 FORMAT (
     + 'Smoothing is completed for data set',I3,':',I1
     +/
     +/'Just file a short analysis of residuals'
     +/'Display/file short analysis of residuals'
     +/'Display/file full analysis of residuals'
     +/'Proceed with no analysis of residuals'
     +/'Help'
     +/'Cancel ... Suppress all residuals analysis')
      END
C
C------------------------------------------------------------------------
C
      SUBROUTINE SUMMIT (M1, M2, N1, N2, NDATA, NF, NGRAF,
     +                   C1, C2, RK1, RK2, XGRAF1, XGRAF2, X1, X2,
     +                   YH1, YH2, YL1, YL2, YGRAF1, YGRAF2, Y1, Y2)
C
C Sum it all up
C 02/03/20222 added e_numbers and e_formats, etc.
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: M1, M2, N1, N2, NDATA, NF, NGRAF
      DOUBLE PRECISION, INTENT (IN) :: C1(N1), C2(N2), RK1(N1), RK2(N2)
      DOUBLE PRECISION, INTENT (IN) :: XGRAF1(NGRAF), XGRAF2(NGRAF)
      DOUBLE PRECISION, INTENT (IN) :: YGRAF1(NGRAF), YGRAF2(NGRAF)
      DOUBLE PRECISION, INTENT (IN) :: X1(M1), X2(M2)
      DOUBLE PRECISION, INTENT (IN) :: YH1(M1), YH2(M2), YL1(M1), 
     +                                 YL2(M2), Y1(M1), Y2(M2)
C
C Locals
C     
      INTEGER    K0, K1, K5, K8
      PARAMETER (K0 = 0, K1 = 1, K5 = 5, K8 = 8)
      INTEGER    N
      PARAMETER (N = 101)
      INTEGER    I, IFAIL, NDEC
      INTEGER    LSHADE, NUMOPT, NSTART, NTITLE
      PARAMETER (LSHADE = 3, NUMOPT = 3, NSTART = 3, NTITLE = 1)
      INTEGER    ICOLOR, IX, IY, NTEXT, NUMBLD(5), NUMPOS(5)
      DOUBLE PRECISION AA1, AA2, AB1, AB2, AC1, AC2, DIFF, R1, R2, R3
      DOUBLE PRECISION XMAX, XMIN, YMIN
      DOUBLE PRECISION X(N), F(N), G(N), TEMP(N)
      DOUBLE PRECISION DELTA
      DOUBLE PRECISION TWO
      PARAMETER (TWO = 2.0D+00)
      CHARACTER (LEN = 13) D13(17), SHOWLJ, SHOWRJ
      CHARACTER  PTITLE*16, XTITLE*1, YTITLE*1
      CHARACTER  TEXT(30)*100, TITLE(NTITLE)*80
      CHARACTER (LEN = 40) FINAL_VERDICT
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    SAVEIT
      PARAMETER (SAVEIT = .TRUE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    FRAME
      PARAMETER (FRAME = .TRUE.)
      EXTERNAL   E_FORMATS, SHOWLJ, SHOWRJ
      EXTERNAL   E02BDF$, E02BBF$
      EXTERNAL   PUTIFA, PUTFAT, SIMSON, GKSEB4, TABLE3, LBOX01
      EXTERNAL   VERDIC
      INTRINSIC  ABS, MAX, MIN
      DATA       PTITLE, XTITLE, YTITLE / 'Best-fit splines', 'X', 'Y' /
      DATA       NUMBLD / 1*1, 4*0 /
      DATA       NUMPOS / 5*1 /
      E_NUMBERS = E_FORMATS()
C
C Area under splines AA1, AA2 then define XMAX, XMIN
C
      IFAIL = 1
      CALL E02BDF$(N1, RK1, C1, AA1, IFAIL)
      CALL PUTIFA (IFAIL, NF, 'E02BDF/SUMMIT')
      IFAIL = 1
      CALL E02BDF$(N2, RK2, C2, AA2, IFAIL)
      CALL PUTIFA (IFAIL, NF, 'E02BDF/SUMMIT')
      XMAX = MIN(XGRAF1(NGRAF), XGRAF2(NGRAF))
      XMIN = MAX(XGRAF1(1), XGRAF2(1))
      IF (XMAX.LE.XMIN) THEN
         CALL PUTFAT ('No X-range overlap ... Comparison not possible')
         AA1 = - 1.0D+00
         AA2 = - 1.0D+00
         AB1 = - 1.0D+00
         AB2 = - 1.0D+00
         AC1 = - 1.0D+00
         AC2 = - 1.0D+00
         GOTO 20
      ENDIF
C
C Prepare points for Simpsons rule over range XMIN, XMAX
C
      X(1) = XMIN
      DELTA = (XMAX - XMIN)/(N - 1)
      DO I = 2, N - 1
         X(I) = X(I - 1) + DELTA
      ENDDO
      X(N) = XMAX
      DO I = 1, N
         IFAIL = 1
         CALL E02BBF$(N1, RK1, C1, X(I), F(I), IFAIL)
         CALL PUTIFA (IFAIL, NF, 'E02BBF/SUMMIT')
         IFAIL = 1
         CALL E02BBF$(N2, RK2, C2, X(I), G(I), IFAIL)
         CALL PUTIFA (IFAIL, NF, 'E02BBF/SUMMIT')
      ENDDO
C
C Area under splines in window range AB1, AB2
C
      CALL SIMSON (N,
     +             AB1, XMIN, XMAX, F)
      CALL SIMSON (N,
     +             AB2, XMIN, XMAX, G)
C
C Find absolute area DIFF
C
      DO I = 1, N
         TEMP(I) = ABS(F(I) - G(I))
      ENDDO
      CALL SIMSON (N, 
     +             DIFF, XMIN, XMAX, TEMP)
C
C Find YMIN then AC1, AC2 areas in the window
C
      YMIN = F(1)
      DO I = 1, N
         IF (F(I).LT.YMIN) YMIN = F(I)
         IF (G(I).LT.YMIN) YMIN = G(I)
      ENDDO
      DO I = 1, NGRAF
         IF (XGRAF1(I).GE.XMIN .AND. XGRAF1(I).LE.XMAX) THEN
            IF (YGRAF1(I).LT.YMIN) YMIN = YGRAF1(I)
         ENDIF
         IF (XGRAF2(I).GE.XMIN .AND. XGRAF2(I).LE.XMAX) THEN
            IF (YGRAF2(I).LT.YMIN) YMIN = YGRAF2(I)
         ENDIF
      ENDDO
      DO I = 1, N
         F(I) = F(I) - YMIN
         G(I) = G(I) - YMIN
      ENDDO
      CALL SIMSON (N,
     +             AC1, XMIN, XMAX, F)
      CALL SIMSON (N,
     +             AC2, XMIN, XMAX, G)
C
C Define ratios
C
      R1 = 100.0D+00*ABS(AA1 - AA2)/(AA1 + AA2)
      R2 = 100.0D+00*DIFF/(AB1 + AB2)
      R3 = 100.0D+00*DIFF/(AC1 + AC2)
      CALL VERDIC (R1, R2, R3, XGRAF1(1), XGRAF1(NGRAF), XMIN, XMAX,
     +             FINAL_VERDICT)         
      WRITE (NF,'(A)') ' '
      IF (E_NUMBERS) THEN
         WRITE (NF,100) XGRAF1(1), XGRAF1(NGRAF), AA1,
     +                  XGRAF2(1), XGRAF2(NGRAF), AA2,
     +                  XMIN, XMAX, 0.0D+00,
     +                  XMIN, XMAX, YMIN,
     +                  AB1, AB2, DIFF,
     +                  AC1, AC2,
     +                  R1, R2, R3,
     +                  TWO*R1, TWO*R2, TWO*R3,
     +                  FINAL_VERDICT 
      ELSE
         D13(1) = SHOWRJ(XGRAF1(1))
         D13(2) = SHOWLJ(XGRAF1(NGRAF))
         D13(3) = SHOWLJ(AA1)

         D13(4) = SHOWRJ(XGRAF2(1))
         D13(5) = SHOWLJ(XGRAF2(NGRAF))
         D13(6) = SHOWLJ(AA2) 
           
         D13(7) = SHOWRJ(XMIN)
         D13(8) = SHOWLJ(XMAX)
         D13(9) = SHOWLJ(0.0D+00)
            
         D13(10) = SHOWRJ(XMIN)
         D13(11) = SHOWLJ(XMAX) 
         D13(12) = SHOWLJ(YMIN)

         D13(13) = SHOWLJ(AB1)
         D13(14) = SHOWLJ(AB2)
         D13(15) = SHOWLJ(DIFF)

         D13(16) = SHOWLJ(AC1)
         D13(17) = SHOWLJ(AC2)
           
         WRITE (NF,150) D13(1), D13(2), D13(3),
     +                  D13(4), D13(5), D13(6),
     +                  D13(7), D13(8), D13(9),
     +                  D13(10), D13(11), D13(12),
     +                  D13(13), D13(14), D13(15),
     +                  D13(16), D13(17),
     +                  R1, R2, R3,
     +                  TWO*R1, TWO*R2, TWO*R3,
     +                  FINAL_VERDICT
      ENDIF  
      NDEC = 1
C
C Decide output
C
   20 CONTINUE
      WRITE (TEXT,200) NDATA, NDATA
      ICOLOR = 3
      IX = 4
      IY = 4
      NTEXT = 5
      CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      IF (NDEC.EQ.1) THEN
         CALL GKSEB4 (K0, K1, K0, K1, K5, K0, K8, K0, M1, NGRAF, M2,
     +                NGRAF, 
     +                X1, XGRAF1, X2, XGRAF2, 
     +                YH1, YH2, YL1, YL2,
     +                Y1, YGRAF1, Y2, YGRAF2,
     +                PTITLE, XTITLE, YTITLE,
     +                SAVEIT, SAVEIT)
         NDEC = 2
         GOTO 20
      ELSEIF (NDEC.EQ.2) THEN
         IF (AA1.LT.0.0D+00  .OR. AA2.LT.0.0D+00) THEN
            CALL PUTFAT ('Comparison impossible')
            NDEC = 3
            GOTO 20
         ENDIF
         IF (E_NUMBERS) THEN
            WRITE (TEXT,100) XGRAF1(1), XGRAF1(NGRAF), AA1,
     +                       XGRAF2(1), XGRAF2(NGRAF), AA2,
     +                       XMIN, XMAX, 0.0D+00,
     +                       XMIN, XMAX, YMIN,
     +                       AB1, AB2, DIFF,
     +                       AC1, AC2,
     +                       R1, R2, R3,
     +                       TWO*R1, TWO*R2, TWO*R3,
     +                       FINAL_VERDICT
         ELSE
            D13(1) = SHOWRJ(XGRAF1(1))
            D13(2) = SHOWLJ(XGRAF1(NGRAF))
            D13(3) = SHOWLJ(AA1)

            D13(4) = SHOWRJ(XGRAF2(1))
            D13(5) = SHOWLJ(XGRAF2(NGRAF))
            D13(6) = SHOWLJ(AA2) 
           
            D13(7) = SHOWRJ(XMIN)
            D13(8) = SHOWLJ(XMAX)
            D13(9) = SHOWLJ(0.0D+00)
            
            D13(10) = SHOWRJ(XMIN)
            D13(11) = SHOWLJ(XMAX) 
            D13(12) = SHOWLJ(YMIN)

            D13(13) = SHOWLJ(AB1)
            D13(14) = SHOWLJ(AB2)
            D13(15) = SHOWLJ(DIFF)

            D13(16) = SHOWLJ(AC1)
            D13(17) = SHOWLJ(AC2)
           
            WRITE (TEXT,150) D13(1), D13(2), D13(3),
     +                       D13(4), D13(5), D13(6),
     +                       D13(7), D13(8), D13(9),
     +                       D13(10), D13(11), D13(12),
     +                       D13(13), D13(14), D13(15),
     +                       D13(16), D13(17),
     +                       R1, R2, R3,
     +                       TWO*R1, TWO*R2, TWO*R3,
     +                       FINAL_VERDICT 
         ENDIF  
         TITLE(1) = ' Comparison of data sets and best-fit curves'
         ICOLOR = 7
         NTEXT = 17
         NDEC = 3
         CALL TABLE3 (ICOLOR, NTEXT, NTITLE, TEXT, TITLE, FRAME)
         GOTO 20
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     + ' Area under curve 1 (',1P,1X,E13.5,' < x <',1X,E13.5,')',
     +1X,'(A1)',1X,'=',1X,E13.5
     +/' Area under curve 2 (',   1X,E13.5,' < x <',1X,E13.5,')',
     +1X,'(A2)',1X,'=',1X,E13.5
     +/' For window number 1:',   1X,E13.5,' < x <',1X,E13.5,
     +',y_min =',1X,E13.5
     +/' For window number 2:',   1X,E13.5,' < x <',1X,E13.5,
     +',y_min =',1X,E13.5
     +/1X,'Area under curve 1 inside window 1',
     +14X,'(B1)',1X,'=',1X,E13.5
     +/1X,'Area under curve 2 inside window 1',
     +14X,'(B2)',1X,'=',1X,E13.5
     +/1X,'Integral of |curve1 - curve2| for the x_overlap (A0)',1X,
     +'=',1X,E13.5
     +/1X,'Area under curve 1 inside window 2',
     +14X,'(C1)',1X,'=',1X,E13.5
     +/1X,'Area under curve 2 inside window 2',
     +14X,'(C2)',1X,'=',1X,E13.5
     +/1X,'Estimated percentage differences between the curves:'
     +/1X,'Over total range of x values: 100|A1 - A2|/(A1 + A2)',1X,'=',
     +0P,F8.3,'%'
     +/1X,'In window 1 (with a zero baseline): 100*A0/(B1 + B2)',1X,'=',
     +0P,F8.3,'%'
     +/1X,'In window 2 (with  y_min baseline): 100*A0/(C1 + C2)',1X,'=',
     +0P,F8.3,'%'
     +/1X,'Over total range of x values: 200|A1 - A2|/(A1 + A2)',1X,'=',
     +0P,F8.3,'%'
     +/1X,'In window 1 (with a zero baseline): 200*A0/(B1 + B2)',1X,'=',
     +0P,F8.3,'%'
     +/1X,'In window 2 (with  y_min baseline): 200*A0/(C1 + C2)',1X,'=',
     +0P,F8.3,'%',
     +/1X,'Conclusion: Comparison of curves is',1X,A)
  150 FORMAT (
     + ' Area under curve 1 (',1P,1X,A13,' < x <',1X,A13,')',
     +1X,'(A1)',1X,'=',1X,A13
     +/' Area under curve 2 (',   1X,A13,' < x <',1X,A13,')',
     +1X,'(A2)',1X,'=',1X,A13
     +/' For window number 1:',   1X,A13,' < x <',1X,A13,
     +' y_min =',1X,A13
     +/' For window number 2:',   1X,A13,' < x <',1X,A13,
     +' y_min =',1X,A13
     +/1X,'Area under curve 1 inside window 1',
     +14X,'(B1)',1X,'=',1X,A13
     +/1X,'Area under curve 2 inside window 1',
     +14X,'(B2)',1X,'=',1X,A13
     +/1X,'Integral of |curve1 - curve2| for the x_overlap (A0)',1X,
     +'=',1X,A13
     +/1X,'Area under curve 1 inside window 2',
     +14X,'(C1)',1X,'=',1X,A13
     +/1X,'Area under curve 2 inside window 2',
     +14X,'(C2)',1X,'=',1X,A13
     +/1X,'Estimated percentage differences between the curves:'
     +/1X,'Over total range of x values: 100|A1 - A2|/(A1 + A2)',1X,'=',
     +0P,F8.3,'%'
     +/1X,'In window 1 (with a zero baseline): 100*A0/(B1 + B2)',1X,'=',
     +0P,F8.3,'%'
     +/1X,'In window 2 (with  y_min baseline): 100*A0/(C1 + C2)',1X,'=',
     +0P,F8.3,'%'
     +/1X,'Over total range of x values: 200|A1 - A2|/(A1 + A2)',1X,'=',
     +0P,F8.3,'%'
     +/1X,'In window 1 (with a zero baseline): 200*A0/(B1 + B2)',1X,'=',
     +0P,F8.3,'%'
     +/1X,'In window 2 (with  y_min baseline): 200*A0/(C1 + C2)',1X,'=',
     +0P,F8.3,'%',
     +/1X,'Conclusion: Comparison of curves is',1X,A)   
  200 FORMAT (
     + 'Analysis completed for matched pair',I3
     +/
     +/'Graph to compare fit for matched pair',I3
     +/'Table of window, areas and % difference'
     +/'Cancel')
      END
C
C
      SUBROUTINE VERDIC (R1, R2, R3, XBIG1, XBIG2, XOVER1, XOVER2,
     +                   VERDICT)
C
C R1 = difference over total range
C R2 = difference over window with zero baseline
C R3 = difference over window with y-min baseline
C XBIG1 = smallest X
C XBIG2 = largest X
C XOVER1 = smallest X in window
C XOVER2 = largest X in window
C
     
      IMPLICIT NONE
      DOUBLE PRECISION,    INTENT (IN)  :: R1, R2, R3, XBIG1, XBIG2,
     +                                     XOVER1, XOVER2
      CHARACTER (LEN = *), INTENT (OUT) :: VERDICT
      INTEGER    IADD1
      INTEGER    NMAX
      PARAMETER (NMAX = 8)
      DOUBLE PRECISION TEST
      DOUBLE PRECISION EPSI
      PARAMETER (EPSI = 1.0D-300)     
      CHARACTER (LEN = 40) ANSWER(NMAX)
      DATA ANSWER / 'terrible (definitely not identical)', 
     +              'extremely bad (probably not identical)', 
     +              'very bad (unlikely to be identical)' ,
     +              'poor (few similarities)',
     +              'reasonable (some similarities)',
     +              'good (likely to be identical)',
     +              'excellent (probably identical)',
     +              'incredible (definitely identical)' /
      IADD1 = 1
      TEST = (XOVER2 - XOVER1)/(XBIG2 - XBIG1 + EPSI)
      IF (TEST.GT.0.90D+00) IADD1 = IADD1 + 1
      IF (R1.LT. 5.0D+00) IADD1 = IADD1 + 1
      IF (R2.LT. 5.0D+00) IADD1 = IADD1 + 1
      IF (R2.LT. 2.5D+00) IADD1 = IADD1 + 1
      IF (R3.LT.10.0D+00) IADD1 = IADD1 + 1
      IF (R3.LT. 5.0D+00) IADD1 = IADD1 + 1
      IF (R3.LT. 2.50D+00) IADD1 = IADD1 + 1
      IF (IADD1.LT.1) THEN
         IADD1 = 1
      ELSEIF (IADD1.GT.NMAX) THEN
         IADD1 = NMAX
      ENDIF        
      VERDICT = ANSWER(IADD1)
      END
C
C           
          
      
