C
C FTN95 version
C =============
C
C CSAFIT
C ======
C
C This version requires extra source code as follows:
C
C CSAFIT.FOR : MAIN, ADVISE
C CSAFIT1.FOR: DATAIN, DATFIT, DATOUT, DERIV1
C CSAFIT2.FOR: DETAIL, FUNCT1, GOFFIT, GRAPHS, LSFUN1, LSFUN2,
C              XSTART, FX44, GX44, HXM1, HXM2, HXM3, HXM4
C
C In this version QNFIT1/LBFGS replaces E04JAF
C
C Now include the extra source code
C =================================
C
C     INCLUDE 'csafit1.for', NOLIST
C     INCLUDE 'csafit2.for', NOLIST
C     INCLUDE 'dllchk.for'
C

C****************************************************************
C Start of module for CSAFIT 
C****************************************************************
      
      MODULE MODULE_CSAFIT
      
      IMPLICIT NONE

      DOUBLE PRECISION, ALLOCATABLE :: XMID(:), XVAL(:), YVAL(:,:),
     +                                 ZVAL(:)
      DOUBLE PRECISION, ALLOCATABLE :: W(:)
      
      INTEGER    NC7, NSMALL
      PARAMETER (NC7 = 58, NSMALL = 202)
      INTEGER    NMAX
      INTEGER    IV(NSMALL)
      INTEGER    ICOUNT, ITIME, NCAP7, NCELLS(2), NMOD, NPTS, NTYPE,
     +           N1, N2      
      DOUBLE PRECISION V(8*(NSMALL - 2))
      DOUBLE PRECISION XBOT, XLIM, XMAX, XMIN, XSCALE, XTOP, YSCALE(2)
      DOUBLE PRECISION BIGNUM, EPSABS, EPSREL, RTOL   
      DOUBLE PRECISION FFIX(NC7), GFIX(5)
      DOUBLE PRECISION AREA(2), CNOR(NC7)
      DOUBLE PRECISION COEFF(NC7), RKNOT(NC7), XSAV(2), ZBOT, ZTOP 
      
      LOGICAL    GRAPH, ITIME1, LOGDAT, NTYPE4
      
      SAVE
      
      END MODULE MODULE_CSAFIT
      
C***************************************************************
C End of module for CSAFIT
C***************************************************************
      
C
C
      PROGRAM MAIN

      USE MODULE_CSAFIT, ONLY : NMAX,
     +                          XMID, XVAL, YVAL, ZVAL,
     +                          W,
     +                          ICOUNT, ITIME, N1, N2,
     +                          ITIME1, GRAPH       
C
C PROGRAM : CSAFIT
C VERSION : 5.5, FX44 = A CUBIC SPLINE WITH NO SMOOTHING FACTOR
C NAG     : D01AJF, E02BAF, E02BBF, E04JAF(?),
C           G01EBF, G01ECF, G01FBF, G01FCF, S15ABF, X02AMF
C ACTION  : 1. PREDICT XMIN THEN NORMALISE SO THAT XBOT < XVAL < XTOP AND
C              DEFINE MID-POINTS X-MID ETC. SO THAT SUM XDIFF*YVAL = 1
C           2. FIT F(XMID, COEFF) TO DATA SET 1
C           3. NORMALISE SO THAT F(XVAL, CNOR) INTEGRATES TO 1
C           4. PERFORM CHISQUARE TEST ETC. FOR GOODNESS OF FIT
C           5. FIT (GAMMA/ALPHA)*F((XMID-BETA)/ALPHA, CNOR) TO DATA 2
C           6. PERFORM CHISQUARE TEST ETC. FOR GOODNESS OF FIT
C           7. FINAL CALL TO GRAPHICS TO DISPLAY BEST-FIT CURVES
C ADVICE  : XBOT = MINIMUM X VALUE AFTER NORMALISING (0 IN THIS VERSION)
C           XMAX = HIGHEST ACTUAL X VALUE
C           XMIN = LOWEST PREDICTED X-VALUE (I.E. APPARATUS ZERO)
C           XTOP = HIGHEST X-VALUE AFTER NORMALISING (1 IN THIS VERSION)
C           1.0  = VALUE OF SUM XDIFF*YVAL AFTER THE INITIAL NORMALISING
C ARRAYS  : NC7 = 8 + MAXIMUM NUMBER OF SPLINE KNOTS
C           NMAX = MAXIMUM NUMBER OF DATA POINTS
C           IV, V, NSMALL = WORKSPACE FOR D01JAE
C           NMAX, W = GENERAL WORKSPACE
C           IU, LIU, U, LU = WORKSPACE FOR E04JAF
C AUTHOR  : W. G. BARDSLEY , 16/2/88
C REVISED : 22/03/1989 IMPROVED CONTROL AND INCLUDED MOMENTS AND RUN TEST
C           18/04/1989 FULL MODEL, 4/5/89 SPECIAL CASES ALPHA = 1 AND BETA = 0
C           16/01/1991 ADAPTED FOR PC, NUMEROUS CHANGES INCLUDING
C                      NMAX, GRF002, PROBRS, NTYPE, DATTIN, FNAMES, PROMPT
C           28/01/1991 CUBIC SPLINE VERSION AND EXTENSIVE USE OF W
C                      GAMMA DIRECTLY AS INTEGRAL IN LSFUN1 AND FINAL GRAPH
C           21/03/1993 GET???, PUT?? and compressed, 17/6/93 RESFIL
C           30/11/1993 Added XLIM and LOGDAT and code for log-type histogram
C           16/12/1994 DBOS version
C           17/02/1995 Version for Salamanca
C           06/11/1997 WIN32 version using QNFIT1 not E04JAF
C           07/08/1998 added dllchk
C           14/12/1998 replaced TUTORS by TUTOR1
C           13/09/1999 added call to WINDOW
C           12/02/2000 added call to SIMVER
C           22/03/2001 revised
C           13/02/2008 revised for version 6
C           07/06/2022 added E_NUMBERS and E_FORMATS, etc. 
C
      IMPLICIT   NONE
      INTEGER    NIN, NOUT
      PARAMETER (NIN = 3, NOUT = 4)
      INTEGER    ISEND
      INTEGER    IERR, NCOL, NROW
      DOUBLE PRECISION XVER, YVER
      CHARACTER  FNAME1*1024, FNAME2*1024, TITLE*80
      CHARACTER  DVER*30, PVER*15
      PARAMETER (PVER = 'w_csafit.exe')
      CHARACTER  BLANK*1, PNAME*6
      PARAMETER (BLANK = ' ', PNAME = 'CSAFIT')
      LOGICAL    ABORT, ACTION, OP, SHOW
      EXTERNAL   GOSTOP
      EXTERNAL   DATAIN, DATFIT, DATNOR, DATOUT, GOFFIT, GRAPHS, ADVISE,
     +           M_ONEFIT, PUTADV 
      EXTERNAL   DLLCHK, WINDOW, SIMVER

C
C======================================================================
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C
      ISEND = 1
      ACTION = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND,
     +             TITLE, 
     +             ACTION)
      CALL SIMVER (XVER, YVER,
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER,
     +             DVER, PVER,
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C======================================================================
C

C
C Advise the user then initialise
C
      CALL ADVISE (DVER,
     +             ABORT)
      IF (ABORT) GOTO 60
      ICOUNT = 0
      N1 = NIN
      N2 = NOUT
      NCOL = 0
      NROW = 0
      FNAME1 = BLANK
      FNAME2 = BLANK
C
C Allocate
C
      IERR = 0 
      IF (ALLOCATED(XMID)) DEALLOCATE(XMID, STAT = IERR)
      IF (IERR.NE.0) GOTO 60 
      IF (ALLOCATED(XVAL)) DEALLOCATE(XVAL, STAT = IERR)
      IF (IERR.NE.0) GOTO 60
      IF (ALLOCATED(YVAL)) DEALLOCATE(YVAL, STAT = IERR)
      IF (IERR.NE.0) GOTO 60
      IF (ALLOCATED(ZVAL)) DEALLOCATE(ZVAL, STAT = IERR)
      IF (IERR.NE.0) GOTO 60
      IF (ALLOCATED(W)) DEALLOCATE(W, STAT = IERR)
      IF (IERR.NE.0) GOTO 60 

      NMAX = 1000

      ALLOCATE(XMID(NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 60
      ALLOCATE(XVAL(0:NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 60
      ALLOCATE(YVAL(2,NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 60
      ALLOCATE(ZVAL(NMAX), STAT = IERR)
      IF (IERR.NE.0) GOTO 60
      ALLOCATE(W(4*(NMAX + 2)), STAT = IERR)
      IF (IERR.NE.0) GOTO 60  
C
C LABEL 20: main loop
C =========
C            
   20 CONTINUE
C
C Read in and check data file
C
      ISEND = 1 
      CALL M_ONEFIT (ISEND, NCOL, NIN, NROW,
     +               FNAME1, TITLE)
      IF (NCOL.NE.3 .OR. NROW.LT.4) THEN 
         CALL PUTADV ('Data file must have 3 columns and > 3 rows')
         NCOL = 0
         NROW = 0
         FNAME1 = BLANK
         GOTO 40
      ENDIF   
      IF (NROW.GT.NMAX) THEN
         IERR = 0 
         IF (ALLOCATED(XMID)) DEALLOCATE(XMID, STAT = IERR)
         IF (IERR.NE.0) GOTO 60 
         IF (ALLOCATED(XVAL)) DEALLOCATE(XVAL, STAT = IERR)
         IF (IERR.NE.0) GOTO 60
         IF (ALLOCATED(YVAL)) DEALLOCATE(YVAL, STAT = IERR)
         IF (IERR.NE.0) GOTO 60
         IF (ALLOCATED(ZVAL)) DEALLOCATE(ZVAL, STAT = IERR)
         IF (IERR.NE.0) GOTO 60
         IF (ALLOCATED(W)) DEALLOCATE(W, STAT = IERR)
         IF (IERR.NE.0) GOTO 60 

         NMAX = NROW

         ALLOCATE(XMID(NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 60
         ALLOCATE(XVAL(0:NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 60
         ALLOCATE(YVAL(2,NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 60
         ALLOCATE(ZVAL(NMAX), STAT = IERR)
         IF (IERR.NE.0) GOTO 60
         ALLOCATE(W(4*(NMAX + 2)), STAT = IERR)
         IF (IERR.NE.0) GOTO 60      
      ENDIF  
      CALL DATAIN (FNAME1, FNAME2,
     +             ABORT)
      IF (ABORT) THEN
         NCOL = 0
         NROW = 0
         FNAME1 = BLANK
         GOTO 40
      ENDIF   
      ITIME1 = .TRUE.
      DO ITIME = 1, 2
         CALL DATFIT
         CALL DATNOR
         CALL DATOUT
         CALL GOFFIT
         ITIME1 = .FALSE.
      ENDDO
      IF (GRAPH) CALL GRAPHS
   40 CONTINUE
C
C Another go ?
C
      CALL GOSTOP (NOUT,
     +             FNAME1, FNAME2, PNAME,
     +             ABORT)
      IF (.NOT.ABORT) GOTO 20
   60 CONTINUE


C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = 1
      ACTION = .FALSE.
      CALL WINDOW (ISEND,
     +             TITLE,
     +             ACTION)
C
C======================================================================
C
      INQUIRE (UNIT = N2, OPENED = OP)
      IF (OP) CLOSE (UNIT = N2)
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE ADVISE (DVER,
     +                   ABORT)
C
C Advise user
C
      IMPLICIT   NONE
C
C Arguments
C
      CHARACTER (LEN = *), INTENT (IN)  :: DVER
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 3, NUMHDR = 13, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    REPEET
      EXTERNAL   TITLES, HELP_CSAFIT
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help           ',
     +'Run the program',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         WRITE (HEADER,100) DVER
         ISEND = 1
         CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                HEADER, OPTION)
         IF (ISEND.EQ.1) THEN
            CALL HELP_CSAFIT ('csafit')
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `CSAFIT'
     +/'        `      '
     +/'Action  `Analysis of histograms (e.g., from flow cytometry)'
     +/'        `Input: reference/test scattering/fluorescence data'
     +/'        `Output: stretch and shift parameters'
     +/'        `      '
     +/'Version `',A
     +/'        `      '
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      '
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C
