C
C CSAFIT1.FOR : DATAIN, DATFIT, DATOUT
C ===========
C
      SUBROUTINE DATAIN (FNAME1, FNAME2,
     +                   ABORT)

      USE MODULE_CSAFIT, ONLY : NMAX,
     +                          XMID, XVAL, YVAL, 
     +                          W,
     +                          ICOUNT, NCAP7, NCELLS, NMOD, NPTS,
     +                          NTYPE, N1, N2,
     +                          GRAPH, LOGDAT, NTYPE4,
     +                          XBOT, XMAX, XMIN, XSCALE, XTOP, YSCALE,
     +                          BIGNUM, EPSABS, EPSREL, RTOL,
     +                          NC7, 
     +                          RKNOT
C
C SET BIGNUM, EPSABS, EPSREL, RTOL AND XTOP THEN READ/TRANSFORM DATA
C
      IMPLICIT   NONE
C
C Arguments
C      
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME1, FNAME2 
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C      
      INTEGER    I, IOS, ISEND, J, NDEC, NKNOTS, NTEXT
      INTEGER    NCOL, NROW
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMOPT
      PARAMETER (IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(20), NUMPOS(10)
      DOUBLE PRECISION ABSERR, ONE, RELERR, ZERO, HALF, TWO
      PARAMETER (ABSERR = 1.0D-05, ONE = 1.0D+00, RELERR = 1.0D-03,
     +           ZERO = 0.0D+00, TWO = 2.0D+00, HALF = 5.0D-01)
      DOUBLE PRECISION X02AMF$, YADD(2), YSUM(2), YMAX
      DOUBLE PRECISION DELTA, DELTA1, DELTA2, DUMMY, FACTOR, RNDIV2
      DOUBLE PRECISION DBIG, DNEG, DNOR, DPOS, D1, D5, PGDBIG, XDIFF
      CHARACTER (LEN = 13) D13(8), SHOWLJ
      CHARACTER (LEN = 12) I12(4), FORM12
      CHARACTER  TITLE*80
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER (LEN = 80) TRIM80, WORD80
      LOGICAL    E_NUMBERS, E_FORMATS 
      LOGICAL    FIRST, FIRST1, FIXNPT, LABEL
      LOGICAL    BORDER
      PARAMETER (BORDER = .FALSE.)
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   X02AMF$
      EXTERNAL   DATTIN, RESFIL, KSHIST, LBOX02, PATCH1, PUTFAT,
     +           TABLE1, PUTADV, ISITMF, TRIM80
      EXTERNAL   DETAIL
      INTRINSIC  NINT, ABS, SQRT, DBLE, TRIM
      SAVE       FIRST, FIRST1
      DATA       FIRST, FIRST1 / .TRUE., .TRUE. /
      DATA       NUMBLD / 20*0 /
      DATA       NUMPOS / 10*1 /
C
C READ IN DATA FROM FILE INTO WORKSPACE W
C
      E_NUMBERS = E_FORMATS()
      CALL ISITMF (NCOL, NROW,
     +             FNAME1)
      IF (NCOL.NE.3 .OR. NROW.LT.4) THEN      
         ISEND = 2
         FIXNPT = .FALSE.
         LABEL = .FALSE.
         CLOSE (UNIT = N1)
         IF (FIRST1) CALL PUTADV (
     +'Now input a data file formatted like csafit.tf1')   
         CALL DATTIN (ISEND, N1, NMAX, NPTS,
     +                W(NMAX + 1), XVAL(1), W(1),
     +                FNAME1, TITLE,
     +                ABORT, FIXNPT, LABEL)
         IF (ABORT) THEN
            CLOSE (UNIT = N1)
            RETURN
         ENDIF
         FIRST1 = .FALSE.
      ELSE
         NPTS = NROW 
         CLOSE (UNIT = N1)
         OPEN (UNIT = N1, FILE = FNAME1)
         READ (N1,'(A)') TITLE
         READ (N1,*) NCOL, NROW
         DO I = 1, NPTS
            READ (N1,*) XVAL(I), W(I), W(NMAX + I)
         ENDDO
      ENDIF   
C
C FIX VALUES FOR BIGNUM, EPSABS, EPSREL, RTOL, XBOT, XTOP THEN CHECK DATA
C
      IF (NPTS.LT.4) GOTO 20
      EPSABS = ABSERR
      EPSREL = RELERR
      RTOL = 1.0D+09*X02AMF$()
      BIGNUM = ONE/RTOL
      XTOP = ONE
      DELTA = XVAL(2) - XVAL(1)
      IF (DELTA.LE.ZERO) THEN
         IF (E_NUMBERS) THEN
            WRITE (LINE,100) XVAL(2), XVAL(1)
         ELSE
            D13(1) = SHOWLJ(XVAL(2))
            D13(2) = SHOWLJ(XVAL(1))
            WRITE (LINE,150) TRIM(D13(1)), TRIM(D13(2))
         ENDIF  
         CALL PUTFAT (LINE)
         GOTO 20
      ENDIF
      DELTA1 = 7.5D-01*DELTA
      DELTA2 = 1.25D+00*DELTA
      XMAX = XVAL(1)
      XMIN = XVAL(1) - DELTA
      XVAL(0) = XMIN
      YMAX = ZERO
      DO I = 1, 2
         YADD(I) = ZERO
         YSUM(I) = ZERO
      ENDDO
      DO I = 1, 2
         DO J = 1, NPTS
            IF (I.EQ.1) THEN
               XDIFF = XVAL(J) - XVAL(J - 1)
               IF (XDIFF.LT.DELTA1 .OR. XDIFF.GT.DELTA2) THEN
                  WRITE (LINE,200) J, J - 1
                  CALL PUTFAT (LINE)
                  GOTO 20
               ENDIF
               IF (XVAL(J).GT.XMAX) XMAX = XVAL(J)
               YVAL(1,J) = W(J)
            ELSE
               YVAL(2,J) = W(NMAX + J)
            ENDIF
            IF (YVAL(I,J).LT.ZERO) THEN
               WRITE (LINE,300) J, I
               CALL PUTFAT (LINE)
               GOTO 20
            ENDIF
            IF (YVAL(I,J).GT.YMAX) YMAX = YVAL(I,J)
            YADD(I) = YADD(I) + YVAL(I,J)
            YSUM(I) = YSUM(I) + XDIFF*YVAL(I,J)
         ENDDO
      ENDDO
      IF (FIRST) THEN
         CALL RESFIL (N2,
     +                FNAME2,
     +                ABORT)
         IF (ABORT) THEN
            FNAME2 = ' '
C***********RETURN
         ENDIF
         WRITE (N2,400)
         FIRST = .FALSE.
      ENDIF
      CALL DETAIL (NMOD, NTYPE,
     +             XMAX, 
     +             ABORT, GRAPH, LOGDAT, NTYPE4)
      IF (ABORT) RETURN
C
C KOLMOGOROV-SMIRNOV TEST ON ORIGINAL HISTOGRAMS IN WORKSPACE W THEN
C TRANSFORM INTO NEW COORDINATES SO XBOT < X-VAL < XTOP AND YSUM = 1.0
C SET NCELLS(I) = YADD(I). XSCALE AND YSCALE ARE CALCULATED
C
      CALL KSHIST (NPTS,
     +             W(1), W(NMAX + 1), DBIG, DNEG, DPOS, D1, D5, PGDBIG)
      FACTOR = SQRT((YADD(1) + YADD(2))/(YADD(1)*YADD(2)))
      DNOR = FACTOR*DBIG
      IF (LOGDAT) THEN
         XSCALE = ONE
      ELSE
         XSCALE = XTOP/(XMAX - XMIN)
      ENDIF
      DO I = 1, 2
         NCELLS(I) = NINT(YADD(I))
         IF (.NOT.LOGDAT) YSUM(I) = XSCALE*YSUM(I)
         YSCALE(I) = ONE/YSUM(I)
         DO J = 1, NPTS
            YVAL(I,J) = YSCALE(I)*YVAL(I,J)
         ENDDO
      ENDDO
      IF (.NOT.LOGDAT) THEN
         DO I = 0, NPTS
            XVAL(I) = XSCALE*(XVAL(I) - XMIN)
         ENDDO
      ENDIF
      XBOT = XVAL(0)
      DO I = 1, NPTS
         XMID(I) = HALF*(XVAL(I - 1) + XVAL(I))
      ENDDO
      WRITE (TEXT,500)
      ICOLOR = 3
      NUMOPT = 4
      NDEC = 2
      CALL LBOX02 (ICOLOR, IXL, IYL, NDEC, NUMOPT, NUMPOS,
     +             TEXT)
      IF (NDEC.LT.4) THEN
         RNDIV2 = DBLE(NPTS)/TWO
         NKNOTS = (2**(NDEC - 1))*(NINT(SQRT(RNDIV2)) + 1)
         IF (NKNOTS.GT.NPTS) NKNOTS = NPTS
         IF (NKNOTS.GT.NC7 - 8) NKNOTS = NC7 - 8
         NCAP7 = NKNOTS + 8
         IF (LOGDAT) THEN
            DELTA = (XMAX - XMIN)/(DBLE(NKNOTS) + ONE)
            DUMMY = XMIN
         ELSE
            DELTA = XTOP/(DBLE(NKNOTS) + ONE)
            DUMMY = XBOT
         ENDIF
         DO I = 1, NKNOTS
            DUMMY = DUMMY + DELTA
            RKNOT(4 + I) = DUMMY
         ENDDO
      ELSE
C
C Read knot positions off data file
C        
         READ (N1,*,END=40,ERR=40,IOSTAT=IOS) NTEXT
         READ (N1,*,END=40,ERR=40,IOSTAT=IOS) NKNOTS
         NCAP7 = NKNOTS + 8
         IF (NKNOTS.LT.0 .OR. NCAP7.GT.NC7) THEN
            WRITE (LINE,600) NKNOTS, NC7 - 8
            CALL PUTFAT (LINE)
            GOTO 40
         ENDIF
         READ (N1,*,END=40,ERR=40,IOSTAT=IOS) (W(I), I = 1, NKNOTS)
         DO I = 1, NKNOTS
            IF (W(I).LT.XMIN .OR. W(I).GT.XMAX) THEN
                WRITE (LINE,700) I
                CALL PUTFAT (LINE)
                GOTO 40
            ENDIF
            IF (LOGDAT) THEN
               RKNOT(4 + I) = W(I)
            ELSE
               RKNOT(4 + I) = XSCALE*(W(I) - XMIN)
            ENDIF
         ENDDO
      ENDIF
      ICOUNT = ICOUNT + 1
      IF (LOGDAT) THEN
         WRITE (N2,800) ICOUNT, 'geometric (logarithmic)'
      ELSE
         WRITE (N2,800) ICOUNT, 'arithmetic (linear)'
      ENDIF
      WORD80 = TRIM80(FNAME1)
      IF (E_NUMBERS) THEN
         WRITE (TEXT,900) WORD80, TITLE,
     +                    XMIN, XMAX, XVAL(0), XVAL(NPTS),
     +                    XSCALE, YSCALE(1), YSCALE(2),
     +                    NPTS, NCELLS(1), NCELLS(2), NKNOTS,
     +                    DBIG, D5, D1, PGDBIG, DNOR
        WRITE (N2,900) WORD80, TITLE,
     +                    XMIN, XMAX, XVAL(0), XVAL(NPTS),
     +                    XSCALE, YSCALE(1), YSCALE(2),
     +                    NPTS, NCELLS(1), NCELLS(2), NKNOTS,
     +                    DBIG, D5, D1, PGDBIG, DNOR
      ELSE
         D13(1) = SHOWLJ(XMIN)
         D13(2) = SHOWLJ(XMAX)
         D13(3) = SHOWLJ(XVAL(0))
         D13(4) = SHOWLJ(XVAL(NPTS))
         D13(5) = SHOWLJ(XSCALE)
         D13(6) = SHOWLJ(YSCALE(1))
         D13(7) = SHOWLJ(YSCALE(2))
         I12(1) = FORM12(NPTS)
         I12(2) = FORM12(NCELLS(1))
         I12(3) = FORM12(NCELLS(2))
         I12(4) = FORM12(NKNOTS)
         WRITE (TEXT,950) WORD80, TITLE,
     +                    TRIM(D13(1)), D13(2), TRIM(D13(3)), D13(4),
     +                    D13(5), D13(6), D13(7),
     +                    I12(1), I12(2), I12(3), I12(4),
     +                    DBIG, D5, D1, PGDBIG, DNOR
         WRITE (N2,950) WORD80, TITLE,
     +                  TRIM(D13(1)), D13(2), TRIM(D13(3)), D13(4),
     +                  D13(5), D13(6), D13(7),
     +                  I12(1), I12(2), I12(3), I12(4),
     +                  DBIG, D5, D1, PGDBIG, DNOR
      ENDIF  
      ICOLOR = 15
      CALL TABLE1 (ICOLOR, 'OPEN')
      DO I = 1, 20
         IF (I.EQ.2) THEN
            ICOLOR = 4
         ELSE
            ICOLOR = 0
         ENDIF
         CALL TABLE1 (ICOLOR, TEXT(I))
      ENDDO
      CALL TABLE1 (ICOLOR, 'CLOSE')
      CLOSE (UNIT = N1)
      IF (.NOT.LOGDAT .AND. ABS(XBOT - ZERO).GT.1.0D-07
     +    .OR. ABS(XTOP - ONE).GT.1.0D-07) GOTO 60
      RETURN
   20 CONTINUE
      ABORT = .TRUE.
      CLOSE (UNIT = N1)
      WRITE (TEXT,1000)
      ICOLOR = 9
      NTEXT = 7
      CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NTEXT,
     +             TEXT,
     +             BORDER)
      RETURN
   40 CONTINUE
      ABORT = .TRUE.
      CLOSE (UNIT = N1)
      WRITE (TEXT,1100) IOS
      ICOLOR = 9
      NTEXT = 8
      CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NTEXT, 
     +             TEXT,
     +             BORDER)
      RETURN
   60 CONTINUE
      ABORT = .TRUE.
      CLOSE (UNIT = N1)
      IF (E_NUMBERS) THEN
         WRITE (LINE,1200) XBOT, XTOP
      ELSE
         D13(1) = SHOWLJ(XBOT)
         D13(2) = SHOWLJ(XTOP) 
         WRITE (LINE,1250) TRIM(D13(1)), TRIM(D13(2))  
      ENDIF  
      CALL PUTFAT (LINE)
C
C Format statements
C      
  100 FORMAT ('X1 =',1P,E11.3,', X2 =',E11.3,', but X2 should be > X1')
  150 FORMAT ('X1 =',1X,A,', X2 =',1X,A,', but X2 should be > X1')
  200 FORMAT ('Unequal increments: check XVAL(',I4,') and XVAL(',I4,')')
  300 FORMAT ('YVAL(',I4,') < 0 in data set',I3)
  400 FORMAT (/1X,'PACKAGE : SIMFIT'/1X,'PROGRAM : CSAFIT'
     +/1X,'ACTION  : Fit Y = alpha*X + beta to shifted histogram'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U.K.')
  500 FORMAT ('Lowest density of interior spline knots'
     +/'Medium density of interior spline knots'
     +/'High density of interior spline knots'
     +/'Read knot positions from the data file (EXPERT mode)')
  600 FORMAT (
     +'Number of knots requested =',I3,' Maximum allowed',4X,'=',I3)
  700 FORMAT ('Knots are out of order at position',I3)
  800 FORMAT (/1X,'CSAFIT analysis number',I3
     +/1X,'-------------------------'
     +/1X,'Data spacing is',1X,A)
  900 FORMAT (/1X,'Summary'/1X,'File'/1X,A/1X,'Title'/1X,A
     +/4X,'Range of X before normalising      =',1P,E11.3,2X,'to',E11.3
     +/4X,'Range of X after  normalising      =',   E11.3,2X,'to',E11.3
     +/4X,'Scaling factor for X, Y            =',   E11.3
     +/4X,'Scaling factor for Phi(X)          =',   E11.3
     +/4X,'Scaling factor for Psi(Y)          =',   E11.3
     +/4X,'Number of bins in the histograms   =',   I7
     +/4X,'Number of X-cells in data 1 (Nx)   =',   I7
     +/4X,'Number of Y-cells in data 2 (Ny)   =',   I7
     +/4X,'Number of interior spline knots    =',   I7
     +/4X,'Kolmogorov-Smirnov D               =',0P,F7.3
     +/4X,'Upper 5% critical D-value          =',   F7.3
     +/4X,'Upper 1% critical D-value          =',   F7.3
     +/4X,'Approx. P(KS >= D observed)        =',   F7.3
     +/4X,'Z = D*(sq.root[(Nx + Ny)/(Nx*Ny)]) =',   F7.3)
  950 FORMAT (/1X,'Summary'/1X,'File'/1X,A/1X,'Title'/1X,A
     +/4X,'Range of X before normalising      =',1X,A,2X,'to',1X,A
     +/4X,'Range of X after  normalising      =',1X,A,2X,'to',1X,A
     +/4X,'Scaling factor for X, Y            =',1X,A
     +/4X,'Scaling factor for Phi(X)          =',1X,A
     +/4X,'Scaling factor for Psi(Y)          =',1X,A
     +/4X,'Number of bins in the histograms   =',1X,A
     +/4X,'Number of X-cells in data 1 (Nx)   =',1X,A
     +/4X,'Number of Y-cells in data 2 (Ny)   =',1X,A
     +/4X,'Number of interior spline knots    =',1X,A
     +/4X,'Kolmogorov-Smirnov D               =',F7.4
     +/4X,'Upper 5% critical D-value          =',F7.4
     +/4X,'Upper 1% critical D-value          =',F7.4
     +/4X,'Approx p = P(KS >= D observed)     =',F7.4
     +/4X,'Z = D*(sq.root[(Nx + Ny)/(Nx*Ny)]) =',F7.4)     
 1000 FORMAT (
     + '*There is a fatal error in your data which must be'
     +/'corrected before this program can be run. You must'
     +/'have at least 4 distinct histogram partitions of'
     +/'your data in an arithmetic progression with all of'
     +/'the frequencies positive and adding up to the size'
     +/'of the samples.'
     +/'Use (CSADAT/MAKDAT)/EDITMT to prepare/edit files')
 1100 FORMAT (
     + '*FATAL* : To use EXPERT mode, data in your file must'
     +/'be followed by an integer giving the no. of extra'
     +/'lines of text,  then an integer giving the no. of'
     +/'interior spline knots followed by  knot positions'
     +/'required.These must be in increasing order  lying'
     +/'between the extreme data values.'
     +/'*IOSTAT : Input/Output status specifier =',I3,
     +/'*REMEDY : Use (CSADAT/MAKDAT)/EDITMT to prepare/edit files')
 1200 FORMAT ('XBOT =',1P,E11.3,' XTOP = ',E11.3,' Must be 0,1')
 1250 FORMAT ('XBOT =',1X,A,' XTOP = ',1X,A,' Must be 0,1') 
      END
C
C-----------------------------------------------------------------------------
C
      SUBROUTINE DATFIT

      USE MODULE_CSAFIT, ONLY : XMID, YVAL, 
     +                          W,
     +                          ITIME, NCAP7, NMOD, NPTS, N2,
     +                          LOGDAT,
     +                          XBOT, XLIM, XMAX, XMIN, XTOP,
     +                          NC7,
     +                          COEFF, RKNOT, ZBOT, ZTOP,
     +                          NCAP7,
     +                          CNOR, FFIX,
     +                          XSAV 
C
C ITIME = 1, FIT SPLINE, ITIME = 2, FIT MODEL TO THE DATA USING E04JAF
C
      IMPLICIT   NONE
      INTEGER    I, NPAR, N10
      PARAMETER (NPAR = 2, N10 = 10)
C*****INTEGER    LIU, LU
C*****PARAMETER (LIU = NPAR + 2, LU = 12*NPAR + NPAR*(NPAR - 1)/2)
C*****INTEGER    IU(LIU)
      INTEGER    LIW, LW1, LW2
      PARAMETER (LIW = 3*NPAR,
     +           LW1 = 2*(2*N10*NPAR + 4*NPAR + 11*N10**2 + 8*N10),
     +           LW2 = 3*NPAR)
      INTEGER    IW(LIW), NBD(NPAR)
      INTEGER    IFAIL, M, MP1, M2P1, M3P1, N
C*****INTEGER    IBOUND
      DOUBLE PRECISION BL(NPAR), BU(NPAR), G(NPAR)
C*****DOUBLE PRECISION U(LU)
      DOUBLE PRECISION WORK2(4,NC7), X(3)
      DOUBLE PRECISION F, WEIGHT
      DOUBLE PRECISION W1(LW1), W2(LW2)
      DOUBLE PRECISION ONE, TEN
      PARAMETER (ONE = 1.0D+00, TEN = 10.0D+00)
      LOGICAL    ABORT
      EXTERNAL   E02BAF$, QNFIT1, DERIV1, FUNCT1, PUTIFA
      EXTERNAL   XSTART, LSFUN1
      IF (NPTS.LT.4) RETURN
      IF (ITIME.EQ.1) THEN
         GOTO 20
      ELSE
         GOTO 40
      ENDIF
C
C ITIME = 1 ... INTRODUCE DUMMY POINTS AT EXTREME X VALUES
C SO THE SPLINE COVERS THE DATA RANGE BUT THEN WEIGHT THESE OUT
C
   20 CONTINUE
      WEIGHT = ONE
      M = NPTS + 2
      MP1 = M + 1
      M2P1 = 2*M + 1
      M3P1 = 3*M + 1
      IF (LOGDAT) THEN
         W(1) = XMIN
         W(M) = XMAX
      ELSE
         W(1) = XBOT
         W(M) = XTOP
      ENDIF
      W(MP1) = YVAL(1,1)
      W(M2P1) = WEIGHT/TEN
      DO I = 1, NPTS
         W(1 + I) = XMID(I)
         W(MP1 + I) = YVAL(1,I)
         W(M2P1 + I) = WEIGHT
      ENDDO
      W(2*M) = YVAL(1,NPTS)
      W(3*M) = WEIGHT/TEN
      IFAIL = 1
      CALL E02BAF$(M, NCAP7, W(1), W(MP1), W(M2P1), RKNOT, W(M3P1),
     +             WORK2, COEFF, F, IFAIL)
      ZBOT = RKNOT(1)
      ZTOP = RKNOT(NCAP7)
      IF (IFAIL.NE.0) THEN
         CALL PUTIFA (IFAIL, N2, 'E02BAF/DATFIT')
C********WRITE (* ,100)
         WRITE (N2,100)
         NPTS = - 1
         RETURN
      ENDIF
C
C SET FFIX = COEFF FOR SUBSEQUENT USE OF FX44/D01AJF/DATNOR
C
      DO I = 1, NCAP7 - 4
         FFIX(I) = COEFF(I)
      ENDDO
      RETURN
C
C ITIME = 2 SO MAKE SURE FFIX = CNOR BEFORE CURVE-FITTING USING GX44
C
   40 CONTINUE
      DO I = 1, NCAP7 - 4
         FFIX(I) = CNOR(I)
      ENDDO
      N = 1
      IF (NMOD.EQ.3) N = N + 1
      IF (LOGDAT) THEN
         XLIM = TEN**XMAX - TEN**XMIN
      ELSE
         XLIM = XTOP - XBOT
      ENDIF
      I = 1
      CALL XSTART (I, NMOD, N, BL, BU, X, XLIM, ABORT)
   50 CONTINUE
C
C******************************************************************
C Next code if E04JAF is used
C     WRITE (*,200) ICOUNT, ITIME
C     IBOUND = 0
C     IFAIL = 1
C     CALL E04JAF (N, IBOUND, BL, BU, X, F, IU, LIU, U, LU, IFAIL)
C******************************************************************
C
      NBD(1) = 2
      NBD(2) = 2
      CALL QNFIT1 (DERIV1, FUNCT1,
     +             IFAIL, IW, LIW, LW1, LW2, N, NBD, N2, NPTS,
     +             BL, BU, F, G, W1, W2, X,
     +             'approximate', 'medium')
      CALL XSTART (IFAIL, NMOD, N, BL, BU, X, XLIM, ABORT)
      IF (.NOT.ABORT) GOTO 50
C
C CALL LSFUN1 TO SET GFIX TO CORRECT VALUE FOR DATNOR THEN SAVE IN XSAV
C
      CALL LSFUN1 (NPTS, N, X, W)
      DO I = 1, N
         XSAV(I) = X(I)
      ENDDO
C
C Format statement
C    
  100 FORMAT (/1X,'*REMEDY : 1. Check that the data makes sense'
     +/11X,'2. Check that the knots make sense'
     +/11X,'3. Use better  data/knot  settings')
C*200 FORMAT (
C****+1X,'Wait ... Curve-fitting  in progress for data set',I3,':',I1)
      END
C
C------------------------------------------------------------------------
C
      SUBROUTINE DATNOR

      USE MODULE_CSAFIT, ONLY : NSMALL, IV, V ,
     +                          ICOUNT, ITIME, NCAP7, NPTS, N2,
     +                          LOGDAT, NTYPE4,
     +                          EPSABS, EPSREL,
     +                          XBOT, XMAX, XMIN, XTOP,
     +                          AREA, COEFF, CNOR 
C
C AREA UNDER CURVE THEN NORMALISE TO GENERATE CNOR IF ITIME = 1
C
      IMPLICIT   NONE
      INTEGER    I, IFAIL, LIV, LV
      DOUBLE PRECISION A, B, ERROR, FDIFF, RESUL
      DOUBLE PRECISION FX44, GX44
      DOUBLE PRECISION PNT05, ONE
      PARAMETER (PNT05 = 5.0D-02, ONE = 1.0D+00)
      CHARACTER (LEN = 13) D13, SHOWLJ
      LOGICAL   E_NUMBERS, E_FORMATS
      EXTERNAL  E_FORMATS, SHOWLJ  
      EXTERNAL  FX44, GX44
      EXTERNAL  PUTIFA
      EXTERNAL  D01AJF$
      INTRINSIC ABS
      IF (NPTS.LT.4) RETURN
      E_NUMBERS = E_FORMATS()  
      IF (LOGDAT) THEN
         A = XMIN
         B = XMAX
      ELSE
         A = XBOT
         B = XTOP
      ENDIF
      LIV = NSMALL
      LV = 8*(LIV - 2)
      IFAIL = 1
      IF (ITIME.EQ.1) THEN
         GOTO 20
      ELSE
         GOTO 40
      ENDIF
   20 CONTINUE
      CALL D01AJF$(FX44, A, B, EPSABS, EPSREL, RESUL, ERROR, V, LV,
     +             IV, LIV, IFAIL)
      DO I = 1, NCAP7 - 4
         CNOR(I) = COEFF(I)/RESUL
      ENDDO
      FDIFF = ABS(RESUL - ONE)
      IF (NTYPE4 .AND. FDIFF.GT.PNT05) THEN
C********WRITE ( *,100)
         WRITE (N2,100)
      ENDIF
      GOTO 60
   40 CONTINUE
C
C NEXT CODE IS NOT STRICTLY NECESSARY WHEN GAMMA IS CALCULATED NOT ESTIMATED
C
      CALL D01AJF$(GX44, A, B, EPSABS, EPSREL, RESUL, ERROR, V, LV,
     +             IV, LIV, IFAIL)
   60 CONTINUE
      IF (NTYPE4 .AND. IFAIL.NE.0) THEN
         CALL PUTIFA (IFAIL, N2, 'D01AJF/DATNOR')
C********WRITE ( *,200)
         WRITE (N2,200)
      ENDIF
      AREA(ITIME) = RESUL
      IF (NTYPE4) THEN
C********WRITE ( *,300) ICOUNT, ITIME, AREA(ITIME)
         IF (E_NUMBERS) THEN
            WRITE (N2,300) ICOUNT, ITIME, AREA(ITIME)
         ELSE
            D13 = SHOWLJ(AREA(ITIME))
            WRITE (N2,350) ICOUNT, ITIME, D13
         ENDIF      
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     +/1X,'WARNING : Spline may be a poor fit to data'
     +/1X,'SUSPECT : Inappropriate interior spline knots'
     +/1X,'SUGGEST : Change spline knot positions and/or density')
  200 FORMAT (/11X,'Numerical integration may be inaccurate')
  300 FORMAT (1X,'For data set',I3,':',I1,' (before normalising)',1X,
     +'area under best-fit curve =',1P,E9.2)
  350 FORMAT (1X,'For data set',I3,':',I1,' (before normalising)',1X,
     +'area under best-fit curve =',1X,A)     
      END
C
C------------------------------------------------------------------------
C
      SUBROUTINE DATOUT

      USE MODULE_CSAFIT, ONLY : NMAX,
     +                          XMID, YVAL, ZVAL,
     +                          W,
     +                          ICOUNT, ITIME, NCAP7, NMOD, NPTS, NTYPE,
     +                          N2,
     +                          GRAPH, LOGDAT, NTYPE4,
     +                          COEFF, CNOR, XLIM, XSAV
C
C PARAMETERS NOT NORMALISED ON ENTRY ... BUT NORMALISED ON EXIT
C
      IMPLICIT   NONE
      INTEGER    ICOLOR
      INTEGER    L1, L2, M1, M2
      PARAMETER (L1 = 0, L2 = 1, M1 = 1, M2 = 0)
      INTEGER    I, M, N
      DOUBLE PRECISION ALPHA, ALPHA1, BETA, BETA1, SSQA, SSQB
      DOUBLE PRECISION ZERO, ONE, F100
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, F100 = 1.0D+02)
      CHARACTER (LEN = 13) D13(4), SHOWLJ, SHOWRJ
      CHARACTER  LINE*80, TEXT(20)*80
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    AXES
      PARAMETER (AXES = .FALSE.)
      CHARACTER  PTITLE*21, XTITLE*11, YTITLE*9
      EXTERNAL E_FORMATS, SHOWLJ, SHOWRJ
      EXTERNAL LSFUN1, LSFUN2
      EXTERNAL GKS004, TABLE1, TABLE5
      DATA PTITLE, YTITLE / 'Best Fit to Histogram', 'Frequency' /
      IF (NPTS.LT.4) RETURN
      E_NUMBERS = E_FORMATS()  
      IF (ITIME.EQ.1) THEN
         GOTO 20
      ELSE
         GOTO 40
      ENDIF
   20 CONTINUE
      M = NPTS
      N = NCAP7 - 4
C
C OUTPUT FOR DATA SET 1 BEFORE NORMALISING IF REQUIRED ... W = RESIDUALS
C
      IF (NTYPE4) THEN
         CALL LSFUN1 (M, N, COEFF, W)
         CALL LSFUN2 (M, SSQB, W)
C********WRITE ( *,100)  ICOUNT, 1, 'before', SSQB
         IF (E_NUMBERS) THEN
            WRITE (N2,100)  ICOUNT, 1, 'before', SSQB
         ELSE
            D13(1) = SHOWLJ(SSQB)
            WRITE (N2,150) ICOUNT, 1, 'before', D13(1)
         ENDIF  
C********WRITE (N2,200)
C********WRITE (N2,300) (XMID(I), YVAL(1,I), ZVAL(I),
C****+                   W(I), I = 1, NPTS)
      ENDIF
C
C OUTPUT FOR DATA SET 1 AFTER NORMALISING. THE NEXT CALL TO LSFUN1 SETS
C FFIX = CNOR FOR GOFFIT AND ALSO SETS UP W = RESIDUALS FOR RUN TEST
C********************************
C**** IT MUST NOT BE OMITTED ****
C********************************
C
      CALL LSFUN1 (M, N, CNOR, W)
      CALL LSFUN2 (M, SSQA, W)
C*****WRITE ( *,100) ICOUNT, 1, ' after', SSQA
      IF (E_NUMBERS) THEN
         WRITE (N2,100) ICOUNT, 1, 'after', SSQA
      ELSE
         D13(1) = SHOWLJ(SSQA) 
         WRITE (N2,150) ICOUNT, 1, 'after', D13(1)
      ENDIF  
      IF (NTYPE4) THEN
         ICOLOR = 15
         CALL TABLE5 (ICOLOR, 'OPEN')
         WRITE (LINE,200)
         ICOLOR = 4
         CALL TABLE5 (ICOLOR, LINE)
         ICOLOR = 0
         DO I = 1, NPTS
            IF (E_NUMBERS) THEN
               WRITE (LINE,300) XMID(I), YVAL(1,I), ZVAL(I), W(I)
            ELSE
               D13(1) = SHOWRJ(XMID(I))
               D13(2) = SHOWRJ(YVAL(1,I))
               D13(3) = SHOWRJ(ZVAL(I))
               D13(4) = SHOWRJ(W(I))
               WRITE(LINE,350) D13(1), D13(2), D13(3), D13(4)  
            ENDIF  
            CALL TABLE5 (ICOLOR, LINE)
         ENDDO
         CALL TABLE5 (ICOLOR, 'CLOSE')
      ENDIF
      IF (NTYPE.GT.2) THEN
         WRITE (N2,200)
         IF (E_NUMBERS) THEN
            WRITE (N2,300) (XMID(I), YVAL(1,I), ZVAL(I),
     +                      W(I), I = 1, NPTS)
         ELSE
            DO I = 1, NPTS
               D13(1) = SHOWRJ(XMID(I))
               D13(2) = SHOWRJ(YVAL(1,I))
               D13(3) = SHOWRJ(ZVAL(I))
               D13(1) = SHOWRJ(W(I))
               WRITE(N2,350) D13(1), D13(2), D13(3), D13(4)   
            ENDDO
         ENDIF   
      ENDIF
      IF (GRAPH) THEN
         GOTO 60
      ELSE
         GOTO 80
      ENDIF
C
C ENTER HERE AT STATEMENT 40 THE SECOND TIME ROUND WHEN ITIME = 2
C
   40 CONTINUE
      M = NPTS
      N = 1
      IF (NMOD.EQ.3) N = N + 1
C
C OUTPUT FOR DATA SET 2 AFTER NORMALISING, RESIDUALS IN ARRAY W
C
      CALL LSFUN1 (M, N, XSAV, W)
      CALL LSFUN2 (M, SSQA, W)
C*****WRITE ( *,100) ICOUNT, 2, ' after', SSQA
      IF (E_NUMBERS) THEN
         WRITE (N2,100) ICOUNT, 2, ' after', SSQA
      ELSE
         D13(1) = SHOWLJ(SSQA)
         WRITE (N2,150) ICOUNT, 2, ' after', D13(1)
      ENDIF      
      IF (NMOD.EQ.1) THEN
         ALPHA = XSAV(1)
         BETA = ZERO
      ELSEIF (NMOD.EQ.2) THEN
         ALPHA = ONE
         BETA = XSAV(1)
      ELSE
         ALPHA = XSAV(1)
         BETA = XSAV(2)
      ENDIF
C
C NOW RESTORE BETA TO EXTERNAL COORDINATES USING XSCALE
C*****BETA2 = BETA/XSCALE
C
      ALPHA1 = F100*(ALPHA - ONE)
      BETA1 = F100*BETA/XLIM
      ICOLOR = 15
      CALL TABLE1 (ICOLOR, 'OPEN')
      IF (E_NUMBERS) THEN
         WRITE (TEXT,400) ALPHA, BETA, ALPHA1, BETA1
      ELSE
         D13(1) = SHOWLJ(ALPHA)
         D13(2) = SHOWLJ(BETA)
         WRITE (TEXT,450) D13(1), D13(2), ALPHA1, BETA1
      ENDIF  
      DO I = 1, 7
         IF (I.EQ.2) THEN
            ICOLOR = 4
         ELSE
            ICOLOR = 0
         ENDIF
         CALL TABLE1 (ICOLOR, TEXT(I))
      ENDDO
      IF (E_NUMBERS) THEN
         WRITE (N2,400) ALPHA, BETA, ALPHA1, BETA1
      ELSE
         D13(1) = SHOWLJ(ALPHA)
         D13(2) = SHOWLJ(BETA)
         WRITE (N2,450) D13(1), D13(2), ALPHA1, BETA1
      ENDIF  
      IF (LOGDAT) THEN
         WRITE (TEXT,'(/4X,A)')'Data spacing is geometric (logarithmic)'
         WRITE (N2,'(/4X,A)') 'Data spacing is geometric (logarithmic)'
      ELSE
         WRITE (TEXT,'(/4X,A)') 'Data spacing is arithmetic (linear)'
         WRITE (N2,'(/4X,A)') 'Data spacing is arithmetic (linear)'
      ENDIF
      DO I = 1, 2
        CALL TABLE1 (ICOLOR, TEXT(I))
      ENDDO
      CALL TABLE1 (ICOLOR, 'CLOSE')
      IF (NTYPE4) THEN
         ICOLOR = 15
         CALL TABLE5 (ICOLOR, 'OPEN')
         WRITE (LINE,200)
         ICOLOR = 4
         CALL TABLE5 (ICOLOR, LINE)
         ICOLOR = 0
         DO I = 1, NPTS
            IF (E_NUMBERS) THEN
               WRITE (LINE,300) XMID(I), YVAL(2,I), ZVAL(I), W(I)
            ELSE
               D13(1) = SHOWRJ(XMID(I))
               D13(2) = SHOWRJ(YVAL(2,I))
               D13(3) = SHOWRJ(ZVAL(I))
               D13(4) = SHOWRJ(W(I)) 
               WRITE (LINE,350) D13(1), D13(2), D13(3), D13(4) 
            ENDIF  
            CALL TABLE5 (ICOLOR, LINE)
         ENDDO
         CALL TABLE5 (ICOLOR, 'CLOSE')
      ENDIF
      IF (NTYPE.GT.2) THEN
         WRITE (N2,200)
         IF (E_NUMBERS) THEN
            WRITE (N2,300) (XMID(I), YVAL(2,I), ZVAL(I),
     +                      W(I), I = 1, NPTS)
         ELSE
            DO I = 1, NPTS
               D13(1) = SHOWRJ(XMID(I))
               D13(2) = SHOWRJ(YVAL(2,I))
               D13(3) = SHOWRJ(ZVAL(I))
               D13(4) = SHOWRJ(W(I)) 
               WRITE (N2,350) D13(1), D13(2), D13(3), D13(4)  
            ENDDO
         ENDIF  
      ENDIF
      IF (.NOT.GRAPH) GOTO 80
C
C ARRAYS FOR GRAPHS. W STARTS AT NMAX + 1 TO PRESERVE THE BEST FIT
C RESIDUALS IN POSITIONS 1 TO NPTS OF W AFTER CALL TO LSFUN1
C
   60 CONTINUE
      DO I = 1, M
         W(NMAX + I) = YVAL(ITIME,I)
      ENDDO
      IF (LOGDAT) THEN
         XTITLE = 'log(Values)'
      ELSE
         XTITLE = '  Values   '
      ENDIF
      CALL GKS004 (L1, L2, 0, 0, M1, M2, 0, 0, M, M, M, M,
     +             XMID, XMID, XMID, XMID, W(NMAX + 1), ZVAL, ZVAL,
     +             ZVAL, PTITLE, XTITLE, YTITLE, AXES, GRAPH)
   80 CONTINUE
C*****WRITE (*,500) ICOUNT, ITIME
C
C Format statements 
C
  100 FORMAT (1X,'For data set',I3,':',I1,' (',A6,' normalising)',1X,
     +'sum of  squared residuals =',1P,E9.2)
  150 FORMAT (1X,'For data set',I3,':',I1,' (',A6,' normalising)',1X,
     +'sum of  squared residuals =',1X,A)
  200 FORMAT (8X,'V-mid',9X,'Data',9X,'Theory',6X,'Residuals')
  300 FORMAT (1P,4E14.2)
  350 FORMAT (4(1X,A13))
  400 FORMAT (/4X,'Best-fit parameters'/
     +/10X,'alpha =',1P,E10.2,1X,'(Dimensionless)'
     +/11X,'beta =',    E10.2,1X,'(Internal coordinates)'
     +/8X,'stretch =',0P,F10.2,1X,'%'/4X,'translation =',F10.2,1X,'%')
  450 FORMAT (/4X,'Best-fit parameters'/
     +/10X,'alpha =',1X,A,1X,'(Dimensionless)'
     +/11X,'beta =',1X,A,1X,'(Internal coordinates)'
     +/8X,'stretch =',F10.2,1X,'%'/4X,'translation =',F10.2,1X,'%')   
C*500 FORMAT (
C****+1X,'Wait ... Calculating the statistics for data set',I3,':',I1)
      END
C
C---------------------------------------------------------------------------
C
      subroutine deriv1 (funct,
     +                   n,
     +                   g, w, x)
c
c action : finite difference approximation to derivatives using qngrd1
c
      implicit   none
c
c Arguments
c      
      integer,          intent (in)    :: n
      double precision, intent (inout) :: g(n), w(3*n), x(n)
c
c Locals
c      
      integer    inform
      logical    tpoint
      parameter (tpoint = .false.)
      external   funct, qngrd1
      call qngrd1 (funct, inform, n, g, w, x, tpoint)
      end
C
C
