C
C CSAFIT2.FOR
C ==========
C            DETAIL, FUNCT1, GOFFIT, GRAPHS, LSFUN1, LSDUN2, XSTART,
C            FX44, GX44, HXM1, HXM2, HXM3, HXM4
C
C
      SUBROUTINE DETAIL (NMOD, NTYPE, 
     +                   XMAX,
     +                   ABORT, GRAPH, LOGDAT, NTYPE4)
C
C DETAILS OF PROGRAM OPERATION
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (INOUT) :: NMOD
      INTEGER,          INTENT (OUT)   :: NTYPE
      DOUBLE PRECISION, INTENT (IN)    :: XMAX
      LOGICAL,          INTENT (OUT)   :: ABORT, GRAPH, LOGDAT, NTYPE4
C
C Locals
C      
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NTEXT, NUMCOL, NUMROW,
     +           NUMOPT, NUMPOS(10)
      PARAMETER (IXL = 4, IYL = 4, LSHADE = 1, NTEXT = 3, NUMCOL = 0,
     +           NUMROW = 0)
      CHARACTER  LINE*100, TEXT(30)*100
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   YESNO1, YESNO2, PUTWAR, LBOX02
      DATA       NUMPOS / 10*1 /
      WRITE (TEXT,100)
      ICOLOR = 3
      NUMOPT = 4
      NTYPE = NUMOPT
      CALL LBOX02 (ICOLOR, IXL, IYL, NTYPE, NUMOPT, NUMPOS,
     +             TEXT)
      IF (NTYPE.EQ.4) THEN
         NTYPE4 = .TRUE.
      ELSE
         NTYPE4 = .FALSE.
      ENDIF
      WRITE (LINE,200)
      ICOLOR = 9
      GRAPH = .TRUE.
      CALL YESNO2 (ICOLOR, IXL, IYL, LINE, GRAPH)
   20 CONTINUE
      WRITE (TEXT,300)
      ICOLOR = 3
      NUMOPT = 4
      NMOD = 1
      CALL LBOX02 (ICOLOR, IXL, IYL, NMOD, NUMOPT, NUMPOS,
     +             TEXT)
      IF (NMOD.EQ.4) THEN
         ABORT = .TRUE.
         RETURN
      ELSE
         ABORT = .FALSE.
      ENDIF
      ICOLOR = 9
      WRITE (TEXT,400)
      LINE = 'Does your data have log spacing ?'
      LOGDAT = .TRUE.
      CALL YESNO1 (ICOLOR, IXL, IYL, LSHADE, NUMCOL, NUMROW, NTEXT,
     +             LINE, TEXT,
     +             BORDER, FLASH, HIGH, LOGDAT)
      IF (LOGDAT) THEN
         IF (XMAX.GT.10.0D+00) THEN
            CALL PUTWAR ('Value too large for log spacing ?')
            ABORT = .TRUE.
         ENDIF
         IF (NMOD.GT.1) THEN
            CALL PUTWAR ('Fitting beta may cause problems ?')
            ABORT = .TRUE.
         ENDIF
      ENDIF
      IF (ABORT) THEN
         WRITE (LINE,500)
         ICOLOR = 9
         CALL YESNO2 (ICOLOR, IXL, IYL, LINE,
     +                ABORT)
         IF (ABORT) THEN
            ABORT = .FALSE.
         ELSE
            GOTO 20
         ENDIF
      ENDIF
C
C Format statements
C      
  100 FORMAT ('Just display and file parameters'
     +/'Also display and file statistics'
     +/'Also write the residuals to file'
     +/'Comprehensive screen/file output')
  200 FORMAT ('Display graphs of best fit curves ?')
  300 FORMAT ('Just fit geometric  model, Y = alpha*X'
     +/'Just fit arithmetic model, Y = X + beta'
     +/'Fit the full linear model, Y = alpha*X + beta'
     +/'Quit')
  400 FORMAT (
     + 'Histograms can have bin limits in an arithmetic progression'
     +/'(equal spacing of actual values) or a geometric progression'
     +/'(equal spacing of log_to_base_10 values).')
  500 FORMAT ('Proceed and ignore this warning ?')
      END
C
C--------------------------------------------------------------------
C
      SUBROUTINE FUNCT1 (N,
     +                   XC, FC)

      USE MODULE_CSAFIT, ONLY : W,
     +                          NPTS      
C
C SUBROUTINE FOR E04JAF USING W FOR RESIDUALS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: N
      DOUBLE PRECISION, INTENT (IN)  :: XC(N)    
      DOUBLE PRECISION, INTENT (OUT) :: FC
C
C Locals
C
      EXTERNAL LSFUN1, LSFUN2
      CALL LSFUN1 (NPTS, N, XC, W)
      CALL LSFUN2 (NPTS, FC, W)
      END
C
C----------------------------------------------------------------------------
C
      SUBROUTINE GOFFIT

      USE MODULE_CSAFIT, ONLY : XMID, XVAL, YVAL,      
     +                          W,
     +                          NSMALL, IV, V,
     +                          ICOUNT, ITIME, NCELLS, NMOD, NPTS,
     +                          NTYPE, N2,
     +                          ITIME1, LOGDAT, NTYPE4,
     +                          XBOT, XMAX, XMIN, XSCALE, XTOP,
     +                          EPSABS, EPSREL, RTOL  
C
C GOODNESS OF FIT:- CHI-SQUARE, RUNS, MOMENTS ETC.
C
      IMPLICIT   NONE
      INTEGER    NNEG, NPOS, NRUN
      INTEGER    I, ICOLOR, IFAIL, ISEND, LIV, LV, NDOF, NFUSE, NR1, NR5
      DOUBLE PRECISION A, B, ERROR, ESAV, OBSERV, OSAV, RNCELL, RNTEST
      DOUBLE PRECISION CHISQ1, EOAREA, EXPECT, G01ECF$, G01FCF$, OEDIFF
      DOUBLE PRECISION FUNC1, FUNC2, FX44, GX44, RESUL
      DOUBLE PRECISION HXM1, HXM2, HXM3, HXM4
      DOUBLE PRECISION CHI95, CHI99, PGCHI1, PROBR, PROBS, PROBT
      DOUBLE PRECISION RE1SQ, RESIG, REVAR, SUSIG, SUVAR, SU1SQ
      DOUBLE PRECISION RESM1, RESM1Z, RESM2, RESM2Z, RESM3, RESM4
      DOUBLE PRECISION RKURT, RSKEW, RTEMP, SKURT, SSKEW, STEMP
      DOUBLE PRECISION SUM1, SUMD1, SUMD2, SUME, SUMO
      DOUBLE PRECISION SUMM1, SUMM1Z, SUMM2, SUMM2Z, SUMM3, SUMM4
      DOUBLE PRECISION TERM1, XDIFF, XTPX1, XTPX2, XTPX3, XTPX4
      DOUBLE PRECISION ZERO, ONE, TWO, THREE, FOUR, FIVE, SIX, PNT95,
     +                 PNT99, F100
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           THREE = 3.0D+00, FOUR = 4.0D+00, FIVE = 5.0D+00,
     +           SIX = 6.0D+00,
     +           PNT95 = 9.5D-01, PNT99 = 9.9D-01, F100 = 1.0D+02)
      CHARACTER (LEN = 13) D13(10), SHOWLJ
      CHARACTER (LEN = 12) I12(6), FORM12
      CHARACTER  LINE*100, TEXT(30)*100
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ABORT
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   D01AJF$, G01ECF$, G01FCF$
      EXTERNAL   PUTIFA, PROBRS, PUTFAT, PUTWAR, TABLE1
      EXTERNAL   FX44, GX44, HXM1, HXM2, HXM3, HXM4
      INTRINSIC  ABS, SQRT, DBLE
      IF (NPTS.LT.5) RETURN
      E_NUMBERS = E_FORMATS()  
      IF (ITIME1) THEN
         NDOF = NPTS - 4
      ELSE
         NDOF = NPTS - 3
         IF (NMOD.EQ.3) NDOF = NDOF - 1
      ENDIF
      LIV = NSMALL
      LV = 8*(LIV - 2)
      NFUSE = 0
      ESAV = ZERO
      OSAV = ZERO
      RNCELL = DBLE(NCELLS(ITIME))
      RNTEST = FIVE/RNCELL
      SUM1 = ZERO
      SUMD1 = ZERO
      SUMD2 = ZERO
      SUME = ZERO
      SUMO = ZERO
      SUMM1 = ZERO
      SUMM2 = ZERO
      SUMM3 = ZERO
      SUMM4 = ZERO
      DO I = 1, NPTS
         A = XVAL(I - 1)
         B = XVAL(I)
         XDIFF = B - A
         OBSERV = XDIFF*YVAL(ITIME,I)
         XTPX1 = OBSERV*XMID(I)
         XTPX2 = XMID(I)*XTPX1
         XTPX3 = XMID(I)*XTPX2
         XTPX4 = XMID(I)*XTPX3
         SUMM1 = SUMM1 + XTPX1
         SUMM2 = SUMM2 + XTPX2
         SUMM3 = SUMM3 + XTPX3
         SUMM4 = SUMM4 + XTPX4
         IFAIL = 1
         IF (ITIME.EQ.1) THEN
            CALL D01AJF$(FX44, A, B, EPSABS, EPSREL, RESUL, ERROR,
     +                   V, LV, IV, LIV, IFAIL)
         ELSE
            CALL D01AJF$(GX44, A, B, EPSABS, EPSREL, RESUL, ERROR,
     +                   V, LV, IV, LIV, IFAIL)
         ENDIF
         IF (IFAIL.NE.0) THEN
            IF (NTYPE4) THEN
               WRITE (LINE,100) IFAIL, I
               CALL PUTWAR (LINE)
               WRITE (N2,100) IFAIL, I
            ENDIF
            IF (ITIME.EQ.1) THEN
               FUNC1 = FX44(A)
               FUNC2 = FX44(B)
            ELSE
               FUNC1 = GX44(A)
               FUNC2 = GX44(B)
            ENDIF
            RESUL = XDIFF*(FUNC1 + FUNC2)/TWO
         ENDIF
         EOAREA = RESUL - OBSERV
         EXPECT = ABS(RESUL)
         SUME = SUME + EXPECT
         SUMO = SUMO + OBSERV
         IF (EXPECT.GT.RNTEST) THEN
            EXPECT = EXPECT + ESAV
            OBSERV = OBSERV + OSAV
            OEDIFF = OBSERV - EXPECT
            IF (ABS(EXPECT).GT.RTOL) TERM1 = OEDIFF**2/EXPECT
            SUM1 = SUM1 + TERM1
            ESAV = ZERO
            OSAV = ZERO
         ELSE
            ESAV = ESAV + EXPECT
            OSAV = OSAV + OBSERV
            NFUSE = NFUSE + 1
         ENDIF
         SUMD1 = SUMD1 + EOAREA
         SUMD2 = SUMD2 + ABS(EOAREA)
      ENDDO
C
C OUTPUT TO CONFIRM THAT SUM(EXPECTED) = 1.0 AND SUM(OBSERVED) = 1.0
C
      IF (NTYPE4) THEN
         ICOLOR = 15
         CALL TABLE1 (ICOLOR, 'OPEN')
         WRITE (TEXT,200) ICOUNT, ITIME, SUME, SUMO
         DO I = 1, 5
            IF (I.EQ.2) THEN
               ICOLOR = 4
            ELSE
               ICOLOR = 0
            ENDIF
            CALL TABLE1 (ICOLOR, TEXT(I))
         ENDDO
      ENDIF
      IF (NTYPE.GT.1) WRITE (N2,200) ICOUNT, ITIME, SUME, SUMO
C
C CHI-SQUARE TEST
C
      CHISQ1 = RNCELL*SUM1
      NDOF = NDOF - NFUSE
      IF (NDOF.LT.1) THEN
         WRITE (LINE,300)
         CALL PUTFAT (LINE)
         WRITE (N2,300)
         PGCHI1 = - ONE
         CHI95 = - ONE
         CHI99 = - ONE
      ELSE
         IFAIL = 1
         PGCHI1 = G01ECF$('Upper-tail', CHISQ1, DBLE(NDOF), IFAIL)
         CALL PUTIFA (IFAIL, N2, 'G01ECF/GOFFIT')
         IFAIL = 1
         CHI95 = G01FCF$(PNT95, DBLE(NDOF), IFAIL)
         CALL PUTIFA (IFAIL, N2, 'G01FCF/GOFFIT')
         IFAIL = 1
         CHI99 = G01FCF$(PNT99, DBLE(NDOF), IFAIL)
         CALL PUTIFA (IFAIL, N2, 'G01FCF/GOFFIT')
      ENDIF
      IF (NTYPE.GT.1) THEN
         ICOLOR = 15
         CALL TABLE1 (ICOLOR, 'OPEN')
         IF (E_NUMBERS) THEN
            WRITE (TEXT,400) NDOF, CHISQ1, PGCHI1, CHI95, CHI99
            WRITE (N2,400) NDOF, CHISQ1, PGCHI1, CHI95, CHI99
         ELSE
            I12(1) = FORM12(NDOF)
            D13(1) = SHOWLJ(CHISQ1)
            D13(2) = SHOWLJ(CHI95)
            D13(3) = SHOWLJ(CHI99)
            WRITE (TEXT,450) I12(1), D13(1), PGCHI1, D13(2), D13(3)
            WRITE (N2,450) I12(1), D13(1), PGCHI1, D13(2), D13(3)
         ENDIF  
         DO I = 1, 8
            IF (I.EQ.2) THEN
               ICOLOR = 4
            ELSE
               ICOLOR = 0
            ENDIF
            CALL TABLE1 (ICOLOR, TEXT(I))
         ENDDO
         IF (NFUSE.GT.0) THEN
            WRITE (TEXT,500) NFUSE
            DO I = 1, 2
               CALL TABLE1 (ICOLOR, TEXT(I))
            ENDDO
            CALL TABLE1 (ICOLOR, 'CLOSE')
         ENDIF
         IF (NFUSE.GT.0) WRITE (N2,500) NFUSE
      ENDIF
C
C RUN TEST USING W = RESIDUALS FROM DATOUT/LSFUN1
C
      ISEND = 1
      CALL PROBRS (ISEND, N2, NNEG, NPOS, NPTS, NRUN, NR1, NR5, 
     +             PROBR, PROBS, PROBT, W)
C
C MOMENTS, SKEW, KURTOSIS
C
      IF (LOGDAT) THEN
         A = XMIN
         B = XMAX
      ELSE
         A = XBOT
         B = XTOP
      ENDIF
      ABORT = .FALSE.
      IFAIL = 1
      CALL D01AJF$(HXM1, A, B, EPSABS, EPSREL, RESM1, ERROR, V, LV,
     +             IV, LIV, IFAIL)
      IF (IFAIL.NE.0) ABORT = .TRUE.
      IF (NTYPE4 .AND. IFAIL.NE.0) THEN
         WRITE (LINE,600) IFAIL, ICOUNT, ITIME
         CALL PUTWAR (LINE)
         WRITE (N2,600) IFAIL, ICOUNT, ITIME
      ENDIF
      IFAIL = 1
      CALL D01AJF$(HXM2, A, B, EPSABS, EPSREL, RESM2, ERROR, V, LV,
     +             IV, LIV, IFAIL)
      IF (IFAIL.NE.0) ABORT = .TRUE.
      IF (NTYPE4 .AND. IFAIL.NE.0) THEN
         WRITE (LINE,700) IFAIL, ICOUNT, ITIME
         CALL PUTWAR (LINE)
         WRITE (N2,700) IFAIL, ICOUNT, ITIME
      ENDIF
      IFAIL = 1
      CALL D01AJF$(HXM3, A, B, EPSABS, EPSREL, RESM3, ERROR, V, LV,
     +             IV, LIV, IFAIL)
      IF (IFAIL.NE.0) ABORT = .TRUE.
      IF (NTYPE4 .AND. IFAIL.NE.0) THEN
         WRITE (LINE,800) IFAIL, ICOUNT, ITIME
         CALL PUTWAR (LINE)
         WRITE (N2,800) IFAIL, ICOUNT, ITIME
      ENDIF
      IFAIL = 1
      CALL D01AJF$(HXM4, A, B, EPSABS, EPSREL, RESM4, ERROR, V, LV,
     +             IV, LIV, IFAIL)
      IF (IFAIL.NE.0) ABORT = .TRUE.
      IF (NTYPE4 .AND. IFAIL.NE.0) THEN
         WRITE (LINE,900) IFAIL, ICOUNT, ITIME
         CALL PUTWAR (LINE)
         WRITE (N2,900) IFAIL, ICOUNT, ITIME
      ENDIF
      IF (ABORT .OR. SUMO.LE.RTOL .OR. SUME.LE.RTOL) THEN
         CALL PUTFAT ('Moments canot be calculated accurately')
         RETURN
      ENDIF
      SUMM1 = SUMM1/SUMO
      SUMM2 = SUMM2/SUMO
      SUMM3 = SUMM3/SUMO
      SUMM4 = SUMM4/SUMO
      SU1SQ = SUMM1*SUMM1
      SUVAR = SUMM2 - SU1SQ
      IF (SUVAR.LE.RTOL) RETURN
      IF (SUVAR*SUVAR.LE.RTOL) RETURN
      SUSIG = SQRT(SUVAR)
      IF (SUSIG*SUVAR.LE.RTOL) RETURN
      STEMP = SUMM3 - THREE*SUMM2*SUMM1 + TWO*SUMM1*SU1SQ
      SSKEW = STEMP/(SUSIG*SUVAR)
      STEMP = SUMM4 - FOUR*SUMM3*SUMM1 + SIX*SUMM2*SU1SQ
     +        - THREE*SU1SQ*SU1SQ
      SKURT = STEMP/(SUVAR*SUVAR) - THREE
      RESM1 = RESM1/SUME
      RESM2 = RESM2/SUME
      RESM3 = RESM3/SUME
      RESM4 = RESM4/SUME
      RE1SQ = RESM1*RESM1
      REVAR = RESM2 - RE1SQ
      IF (REVAR.LE.RTOL) RETURN
      IF (REVAR*REVAR.LE.RTOL) RETURN
      RESIG = SQRT(REVAR)
      IF (RESIG*REVAR.LE.RTOL) RETURN
      RTEMP = RESM3 - THREE*RESM2*RESM1 + TWO*RESM1*RE1SQ
      RSKEW = RTEMP/(RESIG*REVAR)
      RTEMP = RESM4 - FOUR*RESM3*RESM1 + SIX*RESM2*RE1SQ
     +        - THREE*RE1SQ*RE1SQ
      RKURT = RTEMP/(REVAR*REVAR) - THREE
C
C RESTORE SOME MOMENTS TO EXTERNAL COORDINATES
C
      IF (LOGDAT) THEN
         SUMM1Z = SUMM1
         SUMM2Z = SUSIG
         RESM1Z = RESM1
         RESM2Z = RESIG
      ELSE
         SUMM1Z = SUMM1/XSCALE + XMIN
         SUMM2Z = SUSIG/XSCALE
         RESM1Z = RESM1/XSCALE + XMIN
         RESM2Z = RESIG/XSCALE
      ENDIF
      IF (NTYPE.GT.1) THEN
         ICOLOR = 15
         CALL TABLE1 (ICOLOR, 'OPEN')
         IF (E_NUMBERS) THEN
            WRITE (TEXT,1000) NPTS, NNEG, NPOS, NRUN, PROBR, NR1, NR5
            WRITE (N2,1000) NPTS, NNEG, NPOS, NRUN, PROBR, NR1, NR5
         ELSE
            I12(1) = FORM12(NPTS)
            I12(2) = FORM12(NNEG)
            I12(3) = FORM12(NPOS)
            I12(4) = FORM12(NRUN)
            I12(5) = FORM12(NR1)
            I12(6) = FORM12(NR5)
            WRITE (TEXT,1050) I12(1), I12(2), I12(3), I12(4), PROBR, 
     +                        I12(5), I12(6)
            WRITE (N2,1050) I12(1), I12(2), I12(3), I12(4), PROBR, 
     +                      I12(5), I12(6) 
         ENDIF  
         DO I = 1, 10
            IF (I.EQ.2) THEN
               ICOLOR = 4
            ELSE
               ICOLOR = 0
            ENDIF
            CALL TABLE1 (ICOLOR, TEXT(I))
         ENDDO
         WRITE (TEXT,1100) ONE, SUMD1, SUMD2, F100*SUMD2
         WRITE (N2,1100) ONE, SUMD1, SUMD2, F100*SUMD2
         DO I = 1, 8
            IF (I.EQ.2) THEN
               ICOLOR = 4
            ELSE
               ICOLOR = 0
            ENDIF
            CALL TABLE1 (ICOLOR, TEXT(I))
         ENDDO
         CALL TABLE1 (ICOLOR, 'CLOSE')
         ICOLOR = 15
         CALL TABLE1 (ICOLOR, 'OPEN')
         IF (E_NUMBERS) THEN
            WRITE (TEXT,1200) SUMM1, SUMM2, SUMM3, SUMM4, SUVAR,
     +                        RESM1, RESM2, RESM3, RESM4, REVAR
            WRITE (N2,1200) SUMM1, SUMM2, SUMM3, SUMM4, SUVAR,
     +                      RESM1, RESM2, RESM3, RESM4, REVAR
         ELSE
            D13(1) = SHOWLJ(SUMM1)  
            D13(2) = SHOWLJ(SUMM2)  
            D13(3) = SHOWLJ(SUMM3)  
            D13(4) = SHOWLJ(SUMM4)  
            D13(5) = SHOWLJ(SUVAR)  
            D13(6) = SHOWLJ(RESM1)  
            D13(7) = SHOWLJ(RESM2)  
            D13(8) = SHOWLJ(RESM3)  
            D13(9) = SHOWLJ(RESM4)  
            D13(10) = SHOWLJ(REVAR)  
            WRITE (TEXT,1250) (D13(I), I = 1, 10)
            WRITE (N2,1250) (D13(I), I = 1, 10)
         ENDIF   
         DO I = 1, 14
            IF (I.EQ.2) THEN
               ICOLOR = 4
            ELSE
               ICOLOR = 0
            ENDIF
            CALL TABLE1 (ICOLOR, TEXT(I))
         ENDDO
         IF (E_NUMBERS) THEN
            WRITE (TEXT,1300) SUMM1Z, SUMM2Z, SSKEW, SKURT,
     +                        RESM1Z, RESM2Z, RSKEW, RKURT
            WRITE (TEXT,1300) SUMM1Z, SUMM2Z, SSKEW, SKURT,
     +                        RESM1Z, RESM2Z, RSKEW, RKURT
         ELSE
            D13(1) = SHOWLJ(SUMM1Z) 
            D13(2) = SHOWLJ(SUMM2Z) 
            D13(3) = SHOWLJ(SSKEW) 
            D13(4) = SHOWLJ(SKURT) 
            D13(5) = SHOWLJ(RESM1Z) 
            D13(6) = SHOWLJ(RESM2Z) 
            D13(7) = SHOWLJ(RSKEW) 
            D13(8) = SHOWLJ(RKURT) 
            WRITE (TEXT,1350) (D13(I), I = 1, 8) 
            WRITE (N2,1350) (D13(I), I = 1, 8) 
         ENDIF  
         DO I = 1, 10
            CALL TABLE1 (ICOLOR, TEXT(I))
         ENDDO
         CALL TABLE1 (ICOLOR, 'CLOSE')
      ENDIF
C
C Format statements
C      
  100 FORMAT ('IFAIL =',I2,' from D01AJF/GOFFIT, I =',I4)
  200 FORMAT (/1X,'Analysis number',I3,':',I1/
     +/1X,'Integral of probabilities =',F6.3
     +/1X,'Sum of obsvd. proportions =',F6.3)
  300 FORMAT (1X,'Insuffient degrees of freedom for chi-square')
  400 FORMAT (/1X,'Chi-square test'/
     +/4X,'Number of degrees of freedom =',I6
     +/4X,'Chi-square test statistic  C =',1P,E10.2
     +/4X,'p = P(chi-square >= C)       =',0P,F7.4
     +/4X,'5% upper tail critical point =',1P,E10.2
     +/4X,'1% upper tail critical point =',   E10.2)
  450 FORMAT (/1X,'Chi-square test'/
     +/4X,'Number of degrees of freedom =',1X,A
     +/4X,'Chi-square test statistic  C =',1X,A
     +/4X,'p = P(chi-square >= C)       =',F7.4
     +/4X,'5% upper tail critical point =',1X,A
     +/4X,'1% upper tail critical point =',1X,A)     
  500 FORMAT (/I4,1X,'bins have been pooled where expected < 5')
  600 FORMAT (1X,'IFAIL =',I2,1X,'from D01AJF/GOFFIT/HXM1',
     +1X,'at data set',I3,':',I1)
  700 FORMAT (1X,'IFAIL =',I2,1X,'from D01AJF/GOFFIT/HXM2',
     +1X,'at data set',I3,':',I1)
  800 FORMAT (1X,'IFAIL =',I2,1X,'from D01AJF/GOFFIT/HXM3',
     +1X,'at data set',I3,':',I1)
  900 FORMAT (1X,'IFAIL =',I2,1X,'from D01AJF/GOFFIT/HXM4',
     +1X,'at data set',I3,':',I1)
 1000 FORMAT (/1X,'Run test on residuals (after normalising)'/
     +/4X,'Number of normalised residuals   =',I6
     +/4X,'Number of negative residuals (m) =',I6
     +/4X,'Number of positive residuals (n) =',I6
     +/4X,'Number of runs observed  (r)     =',I6
     +/4X,'p = P(runs < = r: given m and n) =',F7.4
     +/4X,'1% lower tail crit. no. of runs  =',I6
     +/4X,'5% lower tail crit. no. of runs  =',I6)
 1050 FORMAT (/1X,'Run test on residuals (after normalising)'/
     +/4X,'Number of normalised residuals   =',1X,A
     +/4X,'Number of negative residuals (m) =',1X,A
     +/4X,'Number of positive residuals (n) =',1X,A
     +/4X,'Number of runs observed  (r)     =',1X,A
     +/4X,'p = P(runs < = r: given m and n) =',F7.4
     +/4X,'1% lower tail crit. no. of runs  =',1X,A
     +/4X,'5% lower tail crit. no. of runs  =',1X,A)     
 1100 FORMAT (/1X,'Difference between data histogram and best-fit',1X,
     +'curve after normalising'/
     +/4X,'Area under histogram and best-fit curve  =',F6.2
     +/4X,'Actual (+/-) area between data and curve =',F6.2
     +/4X,'Absolute (+) area between data and curve =',F6.2
     +/4X,'% difference between histogram and curve =',F6.2,1X,'%'/)
 1200 FORMAT (/1X,'Moments (about 0) of data and best-fit curve'/
     +/1X,'(i) In internal coordinates:'
     +/4X,'Histogram 1st moment =',1P,E10.2
     +/4X,'Histogram 2nd moment =',   E10.2
     +/4X,'Histogram 3rd moment =',   E10.2
     +/4X,'Histogram 4th moment =',   E10.2
     +/4X,'Histogram variance   =',   E10.2
     +/4X,'Best-fit 1st moment  =',   E10.2
     +/4X,'Best-fit 2nd moment  =',   E10.2
     +/4X,'Best-fit 3rd moment  =',   E10.2
     +/4X,'Best-fit 4th moment  =',   E10.2
     +/4X,'Best-fit variance    =',   E10.2)
 1250 FORMAT (/1X,'Moments (about 0) of data and best-fit curve'/
     +/1X,'(i) In internal coordinates:'
     +/4X,'Histogram 1st moment =',1X,A
     +/4X,'Histogram 2nd moment =',1X,A
     +/4X,'Histogram 3rd moment =',1X,A
     +/4X,'Histogram 4th moment =',1X,A
     +/4X,'Histogram variance   =',1X,A
     +/4X,'Best-fit 1st moment  =',1X,A
     +/4X,'Best-fit 2nd moment  =',1X,A
     +/4X,'Best-fit 3rd moment  =',1X,A
     +/4X,'Best-fit 4th moment  =',1X,A
     +/4X,'Best-fit variance    =',1X,A)     
 1300 FORMAT (/1X,'(ii) In dimensionless and external coordinates:'
     +/4X,'Sample 1st moment (mean)    =',1P,E10.2
     +/4X,'Sample standard deviation   =',   E10.2
     +/4X,'Sample coeff. of skew       =',   E10.2
     +/4X,'Sample coeff. of kurtosis   =',   E10.2
     +/4X,'Best-fit 1st moment (mean)  =',   E10.2
     +/4X,'Best-fit standard deviation =',   E10.2
     +/4X,'Best-fit coeff. of skew     =',   E10.2
     +/4X,'Best-fit coeff. of kurtosis =',   E10.2)
 1350 FORMAT (/1X,'(ii) In dimensionless and external coordinates:'
     +/4X,'Sample 1st moment (mean)    =',1X,A
     +/4X,'Sample standard deviation   =',1X,A
     +/4X,'Sample coeff. of skew       =',1X,A
     +/4X,'Sample coeff. of kurtosis   =',1X,A
     +/4X,'Best-fit 1st moment (mean)  =',1X,A
     +/4X,'Best-fit standard deviation =',1X,A
     +/4X,'Best-fit coeff. of skew     =',1X,A
     +/4X,'Best-fit coeff. of kurtosis =',1X,A)    
      END
C
C----------------------------------------------------------------
C
      SUBROUTINE GRAPHS

      USE MODULE_CSAFIT, ONLY : XMID, YVAL, ZVAL,
     +                          W,
     +                          V,
     +                          ITIME, NCAP7, NMOD, NPTS,
     +                          LOGDAT,
     +                          XMIN, XSCALE, YSCALE,
     +                          CNOR, XSAV 
C
C FINAL GRAPHICS FOR CSAFIT MUST BE CALCULATED IN ORDER ITIME = 2, 1
C
      IMPLICIT   NONE
      INTEGER    L1, L2, L3, L4, M1, M2, M3, M4
      PARAMETER (L1 = 0, L2 = 1, L3 = 0, L4 = 1)
      PARAMETER (M1 = 1, M2 = 0, M3 = 1, M4 = 0)
      INTEGER    I, K1, K2, K3, K4, M, N
      CHARACTER  PTITLE*22, XTITLE*11, YTITLE*9
      LOGICAL    ADVANCED, SIMPLE
      LOGICAL    AXES, SAVEIT
      PARAMETER (AXES = .FALSE., SAVEIT = .TRUE.)
      EXTERNAL   LSFUN1
      EXTERNAL   GKS004, NEWPLT
      DATA PTITLE, YTITLE / 'Best Fit to Histograms', 'Frequency' /
      ADVANCED = .TRUE.
      SIMPLE = .FALSE.
      ITIME = 2
      M = NPTS
      N = 1
      IF (NMOD.EQ.3) N = N + 1
      CALL LSFUN1 (M, N, XSAV, W)
      K3 = 2*NPTS
      K4 = 3*NPTS
      DO I = 1, NPTS
         W(K3 + I) = YVAL(2,I)/YSCALE(2)
         W(K4 + I) = ZVAL(I)/YSCALE(2)
      ENDDO
      ITIME = 1
      M = NPTS
      N = NCAP7 - 4
      CALL LSFUN1 (M, N, CNOR, V)
      K1 = 0
      K2 = NPTS
      DO I = 1, NPTS
         W(K1 + I) = YVAL(1,I)/YSCALE(1)
         W(K2 + I) = ZVAL(I)/YSCALE(1)
         IF (.NOT.LOGDAT) XMID(I) = XMID(I)/XSCALE + XMIN
      ENDDO
      K1 = 1
      K2 = NPTS + 1
      K3 = 2*NPTS + 1
      K4 = 3*NPTS + 1
      N = NPTS
      IF (LOGDAT) THEN
         XTITLE = 'log(Values)'
      ELSE
         XTITLE = '  Values   '
      ENDIF
      IF (SIMPLE) THEN
         CALL GKS004 (L1, L2, L3, L4, M1, M2, M3, M4, N, N, N, N,
     +                XMID, XMID, XMID, XMID, W(K1), W(K2), W(K3),
     +                W(K4), 
     +                PTITLE, XTITLE, YTITLE,
     +                AXES, SAVEIT)
      ENDIF
      IF (ADVANCED) THEN 
         CALL NEWPLT (K1, K2, K3, K4, N,
     +                W, XMID)
      ENDIF
      END
C
C
      subroutine newplt (k1, k2, k3, k4, n,
     +                   w, xmid)
c
c arguments
c     
      integer,          intent (in) :: k1, k2, k3, k4, n
      double precision, intent (in) :: w(*), xmid(*) 
c
c locals
c      
      integer    m
      parameter (m = 4) 
      integer    i, ifail, j, nout
      integer    jfiles(m), lfiles(m), mfiles(m), nfiles
      character (len = 1024) files(m)
      character (len = 60  ) titles(m)
      external   deltmp, getnou, gettmp, smplot
      data jfiles / 0, 0, 4, 4 /
      data lfiles / 1, 1, 1, 1 /
      data mfiles / 0, 0, 0, 0 /
      data titles / 'Data and BEST-FIT Curves', 'Values', 'Frequencies', 
     + ' ' /
      nfiles = m
      do i = 1, m
         call gettmp (ifail,
     +                files(i))
         call getnou (nout)
         open (unit = nout, file = files(i))
         write (nout,'(a)') 'temporary file'
         write (nout,'(2i6)') n, 2
         do j = 1, n
            if (i.eq.1) then
               write (nout,'(2(1p,e12.4))') xmid(j), w(k1 + j - 1)    
            elseif (i.eq.2) then           
               write (nout,'(2(1p,e12.4))') xmid(j), w(k2 + j - 1)  
            elseif (i.eq.3) then   
               write (nout,'(2(1p,e12.4))') xmid(j), w(k3 + j - 1) 
            else    
               write (nout,'(2(1p,e12.4))') xmid(j), w(k4 + j - 1)   
            endif  
         enddo  
         close (unit = nout)   
      enddo  
      call smplot (jfiles, lfiles, mfiles, nfiles,
     +             files, titles) 
      call deltmp
      end
C
C---------------------------------------------------------------------------
C
      SUBROUTINE LSFUN1 (M, N,
     +                   XC, FVECC)

      USE MODULE_CSAFIT, ONLY : XMID, YVAL, ZVAL,
     +                          NSMALL, IV, V,
     +                          ITIME, NMOD,
     +                          LOGDAT,
     +                          XBOT, XMAX, XMIN, XTOP,
     +                          BIGNUM, EPSABS, EPSREL, RTOL,
     +                          FFIX, GFIX      
C
C SUBROUTINE FOR E04FDE TO RETURN FVECC AS DETERMINED BY ITIME
C
C NOTE THAT FX44 AND GX44 WILL DEPEND ON THE SETTINGS OF FFIX AND GFIX
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: M, N
      DOUBLE PRECISION, INTENT (IN)  :: XC(N)
      DOUBLE PRECISION, INTENT (OUT) :: FVECC(M)
C
C Locals
C      
      INTEGER    I, IFAIL, LIV, LV
      DOUBLE PRECISION FX44, GX44
      DOUBLE PRECISION A, B, ERROR, RESUL, TEMP
      DOUBLE PRECISION ZERO, ONE, TEN
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TEN = 1.0D+01)
      EXTERNAL  D01AJF$
      EXTERNAL  FX44, GX44
      INTRINSIC ABS, SIGN, MAX, LOG10, MIN
      IF (ITIME.EQ.1) THEN
         GOTO 20
      ELSE
         GOTO 40
      ENDIF
C
C ITIME = 1
C
   20 CONTINUE
      DO I = 1, N
         FFIX(I) = XC(I)
      ENDDO
      DO I = 1, M
         ZVAL(I) = FX44(XMID(I))
         FVECC(I) = YVAL(1,I) - ZVAL(I)
      ENDDO
      RETURN
C
C ITIME = 2
C
   40 CONTINUE
      IF (NMOD.EQ.1) THEN
         GOTO 50
      ELSEIF (NMOD.EQ.2) THEN
         GOTO 60
      ELSE
         GOTO 70
      ENDIF
   50 CONTINUE
      IF (ABS(XC(1)).GT.RTOL) THEN
         GFIX(1) = ONE/XC(1)
      ELSE
         GFIX(1) = SIGN(BIGNUM, XC(1))
      ENDIF
      GFIX(2) = ZERO
      A = XC(1)
      B = ZERO
      GOTO 80
   60 CONTINUE
      GFIX(1) = ONE
      GFIX(2) = XC(1)
      A = ONE
      B = XC(1)
      GOTO 80
   70 CONTINUE
      IF (ABS(XC(1)).GT.RTOL) THEN
         GFIX(1) = ONE/XC(1)
      ELSE
         GFIX(1) = SIGN(BIGNUM, XC(1))
      ENDIF
      GFIX(2) = XC(2)
      A = XC(1)
      B = XC(2)
   80 CONTINUE
C
C FIRST ASSIGN VALUES TO GFIX(4), GFIX(5) FOR LIMITS USED IN GX44 THEN
C CALCULATE THE VALUE OF GAMMA USING CURRENT VALUES FOR ALPHA, BETA
C
      LIV = NSMALL
      LV = 8*(LIV - 2)
      IFAIL = 1
      IF (LOGDAT) THEN
         TEMP = MAX(A*TEN**XMIN + B, RTOL)
         GFIX(4) = MAX(LOG10(TEMP), XMIN)
         TEMP = MAX(A*TEN**XMAX + B, RTOL)
         GFIX(5) = MIN(LOG10(TEMP), XMAX)
         A = GFIX(4)
         B = GFIX(5)
         GFIX(3) = ONE
         CALL D01AJF$(GX44, A, B, EPSABS, EPSREL, RESUL, ERROR, V, LV,
     +                IV, LIV, IFAIL)
         GFIX(3) = ONE/MAX(RESUL, RTOL)
      ELSE
         GFIX(4) = MAX(XBOT, B)
         GFIX(5) = MIN(XTOP, A + B)
         A = GFIX(1)*(GFIX(4) - GFIX(2))
         B = GFIX(1)*(GFIX(5) - GFIX(2))
         CALL D01AJF$(FX44, A, B, EPSABS, EPSREL, RESUL, ERROR, V, LV,
     +                IV, LIV, IFAIL)
         IF (ABS(RESUL).GT.RTOL) THEN
            GFIX(3) = GFIX(1)/RESUL
         ELSE
            GFIX(3) = BIGNUM*GFIX(1)
         ENDIF
      ENDIF
      DO I = 1, M
         ZVAL(I) = GX44(XMID(I))
         FVECC(I) = YVAL(2,I) - ZVAL(I)
      ENDDO
      END
C
C--------------------------------------------------------------------
C
      SUBROUTINE LSFUN2 (M,
     +                   SSQ, FVECC)
C
C CALCULATE SSQ GIVEN M AND FVECC, E.G. FROM LSFUN1
C
      IMPLICIT NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: M
      DOUBLE PRECISION, INTENT (OUT) :: SSQ
      DOUBLE PRECISION, INTENT (IN)  :: FVECC(M)
C
C Locals
C      
      INTEGER  I
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      SSQ = ZERO
      DO I = 1, M
         SSQ = SSQ + FVECC(I)*FVECC(I)
      ENDDO
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE XSTART (IFAIL, NMOD, NPAR, 
     +                   BL, BU, X, XLIM,
     +                   ABORT)
C
C INPUT STARTING ESTIMATES FOR BL, BU AND X IN SUBROUTINE DATFIT
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: IFAIL, NMOD, NPAR 
      DOUBLE PRECISION, INTENT (INOUT) :: BL(NPAR), BU(NPAR), X(NPAR),
     +                                    XLIM
      LOGICAL,          INTENT (OUT)   :: ABORT
C
C Locals
C      
      INTEGER    NDEC
      INTEGER    ICOLOR, IXL, IYL, NUMOPT, NUMPOS(2)
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4)
      DOUBLE PRECISION ASTART, BSTART
      DOUBLE PRECISION ALIM1, ALIM2, BLIM1, BLIM2
      DOUBLE PRECISION ZERO, HALF, ONE, TEN, PNT1, F100
      PARAMETER (ZERO = 0.0D+00, HALF = 5.0D-01, ONE = 1.0D+00,
     +           TEN = 1.0D+01, PNT1 = 1.0D-01, F100 = 1.0D+02)
      CHARACTER  TEXT(2)*100
      EXTERNAL   GETRG3, LBOX02
      DATA       NUMPOS / 2*1 /
      ABORT = .FALSE.
C
C If E04JAF is used then comment out the next line and restore the
C tests for IFAIL on exit FROM E04JAF
C
      IF (IFAIL.LT.0 .OR. IFAIL.GT.1) RETURN
C*****IF (IFAIL.EQ.0 .OR. IFAIL.EQ.5 .OR. IFAIL.EQ.7) THEN
      IF (IFAIL.EQ.0) THEN
         ABORT = .TRUE.
         RETURN
      ELSEIF (IFAIL.EQ.1) THEN
         WRITE (TEXT,100)
         NUMOPT = 2
         NDEC = 1
         CALL LBOX02 (ICOLOR, IXL, IYL, NDEC, NUMOPT, NUMPOS,
     +                TEXT)
         IF (NDEC.EQ.1) THEN
            IF (NMOD.EQ.1) THEN
               X(1) = ONE
               BL(1) = PNT1
               BU(1) = TEN
            ELSEIF (NMOD.EQ.2) THEN
               X(1) = ZERO
               BL(1) = - HALF*XLIM
               BU(1) = HALF*XLIM
            ELSE
               X(1) = ONE
               X(2) = ZERO
               BL(1) = PNT1
               BU(1) = TEN
               BL(2) = - HALF*XLIM
               BU(2) = HALF*XLIM
            ENDIF
            RETURN
         ENDIF
C******************************************
C These tests are only for use with E04JAF
CC****ELSE
CC       IF (IFAIL.EQ.2) THEN
CC          WRITE (*,200)
CC          CALL PROMPT
CC       ELSEIF (IFAIL.EQ.3) THEN
CC          WRITE (*,300)
CC          CALL PROMPT
CC       ELSEIF (IFAIL.EQ.4) THEN
CC          WRITE (*,400)
CC          CALL PROMPT
CC       ELSE
CC          IF (NMOD.EQ.3) THEN
CC             WRITE (*,500)
CC             CALL PROMPT
CC          ENDIF
CC       ENDIF
CC       IF (NMOD.EQ.1) THEN
CC          ASTART = X(1)
CC          BSTART = 0.0
CC       ELSEIF (NMOD.EQ.2) THEN
CC          ASTART = 1.0
CC          BSTART = X(1)
CC       ELSE
CC          ASTART = X(1)
CC          BSTART = X(2)
CC       ENDIF
CC       WRITE (*,600) WSSQ, ASTART, BSTART
CC       CALL GETNUM (1, NDEC, 3)
CC       IF (NDEC.EQ.1) THEN
CC          ABORT = .TRUE.
CC          RETURN
CC       ELSEIF (NDEC.EQ.2) THEN
CC          ABORT = .FALSE.
CC          RETURN
CC*******ENDIF
C******************************************
      ENDIF
      IF (NMOD.EQ.1) THEN
         CALL GETRG3 (ALIM1, ASTART, ALIM2,
     +'Lower-limit, Starting-estimate, Upper-limit for % stretch')
         X(1) = ONE + ASTART/F100
         BL(1) = ONE + ALIM1/F100
         BU(1) = ONE + ALIM2/F100
      ELSEIF (NMOD.EQ.2) THEN
         CALL GETRG3 (BLIM1, BSTART, BLIM2,
     +'Lower-limit, Starting-estimate, Upper-limit for % translation')
         X(1) = BSTART*XLIM/F100
         BL(1) = BLIM1*XLIM/F100
         BU(1) = BLIM2*XLIM/F100
      ELSE
         CALL GETRG3 (ALIM1, ASTART, ALIM2,
     +'Lower-limit, Start-estimate, Upper-limit for % stretch')
         X(1) = ONE + ASTART/F100
         BL(1) = ONE + ALIM1/F100
         BU(1) = ONE + ALIM2/F100
         CALL GETRG3 (BLIM1, BSTART, BLIM2,
     +'Lower-limit, Starting-estimate, Upper-limit for % translation')
         X(2) = BSTART*XLIM/F100
         BL(2) = BLIM1*XLIM/F100
         BU(2) = BLIM2*XLIM/F100
      ENDIF
      ABORT = .FALSE.
C
C Format statements
C      
  100 FORMAT (
     + 'Use default starting estimates for alpha/beta'
     +/'You choose  starting estimates for alpha/beta')
C*200 FORMAT (/1X,'WARNING : IFAIL = 2 from E04JAF/DATFIT'
C    +/11X,'Curve-fitting has used up all the maximum allowed'
C    +/11X,'number of  iterations but without locating a well'
C    +/11X,'defined and satisfactory solution point.  You can'
C    +/11X,'choose to stop, re-enter or else start again. The'
C    +/11X,'current best-fit parameters may be meaningful but'
C    +/11X,'you might see if the fit improves after re-entry.')
C 300 FORMAT (/1X,'WARNING : IFAIL = 3 from E04JAF/DATFIT'
C    +/11X,'The curve-fitting has run into  some  difficulties'
C    +/11X,'using  current starting estimates and the solution'
C    +/11X,'point may not be a well defined minimum.   You can'
C    +/11X,'either stop or input new starting estimates.   The'
C    +/11X,'current best-fit parameters may  not be meaningful'
C    +/11X,'so  consider investigating  new starting estimates'
C    +/11X,'to see if you can locate a better solution point.')
C 400 FORMAT (/1X,'CAUTION : IFAIL = 4 from E04JAF/DATFIT'
C    +/11X,'Curve-fitting is somewhat ill-conditioned but the'
C    +/11X,'parameter estimates may still be useful')
C 500 FORMAT (/1X,'CAUTION : IFAIL > 6 from E04JAF/DATFIT'
C    +/11X,'The best-fit curve is  not very well defined  but'
C    +/11X,'it  may be the  best that can be found  for  this'
C    +/11X,'particular data set.  The best-fit parameters are'
C    +/11X,'probably  the best estimates  that you can obtain'
C    +/11X,'so new starting estimates may give no improvement.')
C 600 FORMAT (
C    +/2X,'ADVICE : Curve-fitting has come to a temporary halt with'
C    +/11X,'the following parameters:'
C    +/11X,'SSQ   =',1P,E11.3,/11X,'alpha =',1P,E11.3
C    +/11X,'beta  =',E11.3//
C    +/1X,'OPTIONS : 1. Stop the curve-fitting  at this stage'
C    +/11X,'2. Re-entry using the  current estimates'
C****+/11X,'3. Try again with new starting estimates')
      END
C
C-------------------------------------------------------------------------
C
      DOUBLE PRECISION FUNCTION FX44(X)

      USE MODULE_CSAFIT, ONLY : NCAP7,
     +                          ZBOT, ZTOP,
     +                          FFIX, RKNOT      
C
C EVALUATE THE CUBIC SPLINE WHEN ITIME = 1
C CALLED BY GX44 WHEN ITIME = 2, VALUE DEPENDS ON FFIX
C
      IMPLICIT   NONE
C
C Argument
C      
      DOUBLE PRECISION, INTENT (IN) :: X
C
C Locals
C      
      INTEGER    IFAIL
      DOUBLE PRECISION RESUL
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      EXTERNAL  E02BBF$
      INTRINSIC MAX
      IF (X.LT.ZBOT .OR. X.GT.ZTOP) THEN
         FX44 = ZERO
         RETURN
      ENDIF
      IFAIL = 1
      CALL E02BBF$(NCAP7, RKNOT, FFIX, X, RESUL, IFAIL)
      FX44 = MAX(RESUL, ZERO)
      END
C
C--------------------------------------------------------------------------      
C
      DOUBLE PRECISION FUNCTION GX44(X)

      USE MODULE_CSAFIT, ONLY : LOGDAT,
     +                          RTOL,
     +                          GFIX      
C
C FUNCTION (GAMMA/ALPHA)*FX44((X - BETA)/ALPHA), DEPENDS ON GFIX
C
      IMPLICIT   NONE
C
C Argument
C      
      DOUBLE PRECISION, INTENT (IN) :: X
C
C Locals
C      
      DOUBLE PRECISION FX44, TEMP1, TEMP2
      DOUBLE PRECISION ZERO, TEN
      PARAMETER (ZERO = 0.0D+00, TEN = 1.0D+01)
      EXTERNAL  FX44
      INTRINSIC MAX, LOG10
      IF (X.LT.GFIX(4) .OR. X.GT.GFIX(5)) THEN
         GX44 = ZERO
      ELSE
         IF (LOGDAT) THEN
            TEMP1 = TEN**X
            TEMP2 = MAX(GFIX(1)*(TEMP1 - GFIX(2)), RTOL)
            GX44 = TEMP1*GFIX(3)*FX44(LOG10(TEMP2))/TEMP2
         ELSE
            TEMP1 = GFIX(1)*(X - GFIX(2))
            GX44 = GFIX(3)*FX44(TEMP1)
         ENDIF
      ENDIF
      END
C
C--------------------------------------------------------------------
C
      DOUBLE PRECISION FUNCTION HXM1(X)

      USE MODULE_CSAFIT, ONLY : ITIME1
C
C FUNCTION FOR FIRST MOMENT
C
      IMPLICIT NONE
C
C Argument
C
      
      DOUBLE PRECISION, INTENT (IN) :: X
C
C Locals
C      
      
      DOUBLE PRECISION FX44, GX44 
      EXTERNAL FX44, GX44
      IF (ITIME1) THEN
         HXM1 = X*FX44(X)
      ELSE
         HXM1 = X*GX44(X)
      ENDIF
      END
C
C--------------------------------------------------------------------------
C
      DOUBLE PRECISION FUNCTION HXM2(X)

      USE MODULE_CSAFIT, ONLY : ITIME1
C
C FUNCTION FOR SECOND MOMENT
C
      IMPLICIT NONE
C
C Argument
C      
      DOUBLE PRECISION X
C
C Locals
C      
      DOUBLE PRECISION FX44, GX44
      EXTERNAL FX44, GX44
      IF (ITIME1) THEN
         HXM2 = X*X*FX44(X)
      ELSE
         HXM2 = X*X*GX44(X)
      ENDIF
      END
C
C----------------------------------------------------------------------
C
      DOUBLE PRECISION FUNCTION HXM3(X)

      USE MODULE_CSAFIT, ONLY : ITIME1
C
C FUNCTION FOR THIRD MOMENT
C
      IMPLICIT NONE
C
C Argument
C  
      DOUBLE PRECISION, INTENT (IN) :: X
C
C Locals
C           
      DOUBLE PRECISION FX44, GX44
      EXTERNAL FX44, GX44
      IF (ITIME1) THEN
         HXM3 = X*X*X*FX44(X)
      ELSE
         HXM3 = X*X*X*GX44(X)
      ENDIF
      END
C
C-------------------------------------------------------------------------
C
      DOUBLE PRECISION FUNCTION HXM4(X)

      USE MODULE_CSAFIT, ONLY : ITIME1
      
C
C FUNCTION FOR FOURTH MOMENT
C
      IMPLICIT NONE
C
C Argument
C      
      DOUBLE PRECISION, INTENT (IN) :: X
C
C Locals
C      
      DOUBLE PRECISION FX44, GX44
      EXTERNAL FX44, GX44
      IF (ITIME1) THEN
         HXM4 = X*X*X*X*FX44(X)
      ELSE
         HXM4 = X*X*X*X*GX44(X)
      ENDIF
      END
C
C
