C
C ===================================================
C About this version
C ------------------
C 1) Uses DVODE or NAG D02...
C 2) Uses QNFIT1/LBFGS or NAG E04...
C 3) Always assumes initial conditions refer to x = 0
C    even if xstart > 0
C 4) Does not allow integration for x < 0
C ===================================================
C
C
C Requires extra source code as follows:
C ======================================
C
C DEQSOL1.FOR: ADVISE, DEQCHK, DEQFIL, DEQPLT, DEQSWP
C DEQSOL2.FOR: ACTION, COMPAR, DECIDE, GRAPHS
C DEQSOL3.FOR: OUTPUT, PARSIN, SHOWIT, TABOUT, TABPRN, TIMEIN, VALUES
C DEQSOL4.FOR: DERIV2, DEQFIT, DEQRAN, FUNCT1, GOFFIT
C DEQSOL5.FOR: DEUSER, PLTORB, PORTRT
C DEQSOL6.FOR: DEQF01, DEQJ01, ..., DEQCOM, DEQINI, DEQMOD, USEDEQ, USEJAC
C DEQSOL7.FOR: DEQEXP, VCOVAR, VUCORR, VUSTD
C DEQSOL8.FOR: CONTRL, FUNCT2, FUNCT3, D02PAR, D02SOL
C DEQSOL9.FOR: D02_DEQF0I and D02_DEQJ0I for I = 1 to 5, D02_USEDEQ, D02_USEJAC 
C
C     INCLUDE 'deqsol1.for', NOLIST
C     INCLUDE 'deqsol2.for', NOLIST
C     INCLUDE 'deqsol3.for', NOLIST
C     INCLUDE 'deqsol4.for', NOLIST
C     INCLUDE 'deqsol5.for', NOLIST
C     INCLUDE 'deqsol6.for', NOLIST
C     INCLUDE 'deqsol7.for', NOLIST
C     INCLUDE 'deqsol8.for', NOLIST
C     INCLUDE 'deqsol9.for', NOLIST
C     INCLUDE 'dllchk.for'
C
C=======================================================================
C Start of module for DEQSOL
C=======================================================================
C
      MODULE MODULE_DEQSOL
C
C Array dimensions
C ----------------
C NPMAX: maximum number of parameters
C NTMAX: maximum number of time points
C NYMAX: maximum number of equations
C NHESS: NPMAX + 1
C    IW: W(IW) as follows:
C        DEQFIL ... >= 3*NX
C        ACTION ... DVODE >= NYMAX*(2*NYMAX + 9) + 22    
C        VCOVAR ... DVODE
C        VUCORR ... F02AAF
C   LIW: DVODE ...>= NEQN + 30
C LIWRK: E04QN1 >= NPAR = 2
C        E04MN1 >= NPAR + 2
C        E04SQ1 >= 3*NPAR 
C        QNFIT2 >= 3*NPAR 
C   LW1: E04QN1 >= NPAR*(NPAR - 1)/2 + 12*NPAR
C        E04MN1 >= NPAR*(NPAR + 7)
C        E04SQ1 >= 21*NPAR + 2
C        QNFIT2 >= 2(2*M*N + 4*N + 11*M^2 + 8*M) [M = 10]  
C   LW2: DEQFIT and DEQRAN ... E04 dummy
C                          ... QNFIT2 >= 3*NPAR
C   LW3: DATBIG ... >= NTMAX
C      
C
C Fixed items
C  
      INTEGER    ML, MU, NIP
      PARAMETER (NIP = 10)
      INTEGER    IP(NIP) 
C
C Scalars
C   
      INTEGER    ICOUNT, IRELAB, M, METHOD, MODEL, MPED, N, NMOD, 
     +           NPTBIG, NPTS      
      DOUBLE PRECISION DOFDOM, TOL, XEND, XSTART
      DOUBLE PRECISION RTOL, SIGMA
      DOUBLE PRECISION XESAV1, XESAV2, XSSAV1, XSSAV2
      DOUBLE PRECISION FC
      LOGICAL    ISWAP, USER
      LOGICAL    STATS
C      
C Items for user defined model
C
C NXX controls maximum length of stack
C NXX**2 = length of USED (check all parameters/eqns./Jacobians defined)
C NSTACK_1 = length of equation stack
C NSTACK_2 = length of Jacobian stack
C
      INTEGER    NSTACK_1, NSTACK_2, NXX
      PARAMETER (NXX = 100, NSTACK_1 = 100*NXX, NSTACK_2 = NSTACK_1)
      INTEGER    INDEX_1(NSTACK_1), INDEX_2(NSTACK_2),
     +           NLINES_1, NLINES_2,
     +           NUMBER_1(NSTACK_1), NUMBER_2(NSTACK_2)
      DOUBLE PRECISION DATA_1(NSTACK_1/10), DATA_2(NSTACK_2/10),
     +                 STACK(NSTACK_2)
      LOGICAL    USED(NXX**2)      
C
C Items shared by OUTPUT, FUNCT1 and GOFFIT 
C
      INTEGER    NPMAX, NTMAX, NYMAX
      PARAMETER (NPMAX = 500, NTMAX = 2001, NYMAX = 100)
   
      INTEGER    INDX(NTMAX,NYMAX), NUMPNT(NYMAX)
      DOUBLE PRECISION ASWAP(NYMAX,NYMAX), YSWAP(NTMAX,NYMAX)
      DOUBLE PRECISION YPREV(NYMAX), YVAL(NTMAX,NYMAX)
      DOUBLE PRECISION TX(NTMAX)
      DOUBLE PRECISION SDATA(NTMAX,NYMAX), Y(NYMAX),
     +                 YDATA(NTMAX,NYMAX), Y0(NYMAX)
      DOUBLE PRECISION FACTOR(NPMAX), PARNEW(NPMAX)
      LOGICAL    SWAPIT(NYMAX)


C
C Items for covariance matrix
C  
      INTEGER    NHESS
      PARAMETER (NHESS = NPMAX + 1)
      INTEGER    INDEX1(NPMAX), ISTATE(NPMAX)
      DOUBLE PRECISION CORR(NHESS,NHESS), CV(NHESS,NHESS), DIAGV(NPMAX),
     +                 EIGVAL(NPMAX), HESSIN(NHESS,NHESS),
     +                 FJACC(NTMAX,NPMAX),
     +                 HESSEX(NHESS,NHESS)
      CHARACTER (LEN = 9) RECORD(NPMAX,NPMAX)
      LOGICAL    FREE(NPMAX)
C
C Items for NAG
C  
      DOUBLE PRECISION DTOL
      CHARACTER RELABS*1
      LOGICAL   USE_E04JYF, USE_E04KZF, USE_E04UFF 
      LOGICAL   USE_D02CJF, USE_D02EJF, USE_JACOBIAN  
      LOGICAL   USE_NAG

C
C Items for workspace
C  
      INTEGER    LIWRK, LW1, LW2, LW3
      PARAMETER (LIWRK = 3*NPMAX,
C     +           LW1 = 2*(N2*N10*NPMAX + N4*NPMAX + N11*N10*N10 +
C     +                 N8*N10),
     +           LW1 = NPMAX*(NPMAX + 7) + 1,
     +           LW2 = 3*NPMAX,
     +           LW3 = NTMAX)
      INTEGER    IW, LIW
      PARAMETER (IW = NYMAX*(2*NYMAX + 9) + 22, LIW = NYMAX + 30)
      INTEGER    NWORK(LIW)
      INTEGER    IWRK(LIWRK), NBD(NPMAX)
      DOUBLE PRECISION W(IW)
      DOUBLE PRECISION W1(LW1), W2(LW2), W3(LW3)

C
C Items for data and plotting
C

      DOUBLE PRECISION X1(NTMAX), X2(NTMAX), X3(NTMAX), X4(NTMAX),
     +                 X5(NTMAX), X6(NTMAX), X7(NTMAX), X8(NTMAX),
     +                 X9(NTMAX), X10(NTMAX), X11(NTMAX), X12(NTMAX)
      DOUBLE PRECISION Y1(NTMAX), Y2(NTMAX), Y3(NTMAX), Y4(NTMAX),
     +                 Y5(NTMAX), Y6(NTMAX), Y7(NTMAX), Y8(NTMAX),
     +                 Y9(NTMAX), Y10(NTMAX), Y11(NTMAX), Y12(NTMAX)
      DOUBLE PRECISION TXSAV1(NTMAX), TXSAV2(NTMAX)
      DOUBLE PRECISION XDATA(NTMAX,NYMAX), YCOM(NTMAX,NYMAX)


C
C Items for model parameters
C

      DOUBLE PRECISION BL(NPMAX), BU(NPMAX), G(NPMAX), XC(NPMAX),
     +                 XCRAN(NPMAX)
      DOUBLE PRECISION P(NPMAX)

   
      END MODULE MODULE_DEQSOL
          
C      
C=======================================================================
C End of module DEQSOL 
C=======================================================================
C

      PROGRAM DEQSOL
      USE MODULE_DEQSOL
C
C
C FORTRAN : 95, Double precision
C VERSION : details from SIMVER/DLLCHK
C INPUT   : Parameters, time range, initial conditions etc.
C ACTION  : Solve the system of differential equations
C           DY(i)/DT = F(i)[T,Y(1),Y(2),...,Y(N)] , I = 1,2,...,N
C           with fixed parameters, P(i), i = 1,2,...,M
C USES    : DEQCOM to compare results with alternative solutions
C           DEQF0? to define the differential equations using P(i)
C           GRAPHS to provide graphical output
C           DEQJ0? to calculate elements of the Jacobian
C           PVALUE to save parameters and avoid common blocks
C           DATBIG sets up INDX so that replicates are not integrated
C           and to allow for missing values in the y(i)
C           NPTS is the number of distinct data points
C ADVICE  : NPMAX = No. parameters
C           NTMAX = No. time points
C           NYMAX = No. differential equations
C           ******  These parameters must have the same values
C           ******  in ALL the routines DEQ???
C OUTPUT  : Chosen Y(i) values for XSTART =< T =< XEND
C SOLVER  : DVODE
C AUTHOR  : W. G. Bardsley, University of Manchester, U.K., 06/01/1987
C           02/03/1995 DBOS version
C           04/05/1995 Interchanged NTMAX and NYMAX to speed up FUNCT1
C           06/07/1995 Included deqsol3.ins = qnuser with new common blocks
C           09/10/1995 Added ASWAP, ISWAP, SWAPIT for transformations
C           10/01/1996 Added RESUL
C           12/08/1997 win32 version
C           05/03/1998 Revised graphics to include orbits and phase portrait
C           07/08/1998 added dllchk
C           24/08/1998 added FACTOR and PARNEW for parameter scaling and
C                       added NPTBIG to the common block with NPTS. Also
C                       controlled menu system by IFIT value
C           14/12/1998 Replaced TUTORS by TUTOR1
C                      Added call to CHECKW before and after fitting
C           24/08/1999 Added call to PARLIM to set parameters and limits
C           13/09/1999 Added call to WINDOW
C           28/11/1999 Altered control so ascci model file sets no. of eqns.
C           05/12/1999 increased dimension LW1
C           29/12/1999 added code for random fitting
C           25/01/2000 added NFREE to re-define DOFDOM
C           12/02/2000 added SIMVER
C           23/03/2001 revised
C           20/03/2002 opened iterate.dat on unit 8
C           16/04/2004 removed array PARAMS and added LMHEDI to PARSIN
C           01/07/2005 added DEQCHK and revised to force initial conditions
C                      to always refer to X = 0, even if XSTART > 0
C           28/07/2005 increased DVER to *30 and added to call to ADVISE
C           24/01/2007 introduced FULL_PATH and SIM256
C           26/07/2007 added WORD32 and call to YMDHMS
C           23/12/2009 replaced COMMON blocks by MODULE_DEQSOL
C           25/07/2011 decreased TOL and DTOL from 1.0e-5 to 1.0e-4
C           14/08/2018 replaced E04JYF by E04UFF as NAG default
C
      IMPLICIT   NONE

C----------------------------------------------------------------------
C Declarations for items not in modules 
C
      INTEGER    NORBIT
      PARAMETER (NORBIT = 12)
      INTEGER    NIN, NOUT, NOUT1, N0, N1, N2, N4, N12
      PARAMETER (NIN = 3, NOUT = 4, NOUT1 = 10, N0 = 0, N1 = 1, N2 = 2,
     +           N4 = 4, N12 = 12)
      INTEGER    NHEAD, NZMOD
      PARAMETER (NHEAD = 4, NZMOD = 24)
      INTEGER    NSMALL
      PARAMETER (NSMALL = 49)
      INTEGER    IWANT(N12)
      INTEGER    MARK, NFREE, NTEMP, NTVAL, NUMY, NYVAL
      INTEGER    I, IADDUP, IFIT, ISEND, J, NCYCLE, NDEC, NTSAV1, NTSAV2
      INTEGER    IFAIL, IFAIL1, IOS, NRAND, NUMDAT, NUMPI, NUMY0
      INTEGER    NCOL, NROW
      DOUBLE PRECISION EPSI, ZERO, ONE, TEN, F100, PNT1
      PARAMETER (EPSI = 1.0D-10, ZERO = 0.0D+00, ONE = 1.0D+00,
     +           TEN = 10.0D+00, F100 = 100.0D+00, PNT1 = 0.1D+00)
      DOUBLE PRECISION ABSPI, STEP
      DOUBLE PRECISION CPU, CPU1
      DOUBLE PRECISION XVER, YVER  
      DOUBLE PRECISION X02AMF$
      CHARACTER  FULL_PATH*1024, SIM256*1024, WORD32*32
      CHARACTER  OTYPE*6
      CHARACTER  BLANK*1, PNAME*6
      PARAMETER (BLANK = ' ', PNAME = 'DEQSOL')
      CHARACTER  ANAME*1024, ATITLE*80, DNAME*1024, FNAME*1024
      CHARACTER  MODEL_FILE*1024, ZMOD(NZMOD)*80
      CHARACTER  FSAV(NSMALL)*1024, TSAV(NSMALL)*80
      CHARACTER  FSAV1(NYMAX)*1024, TSAV1(NYMAX)*80
      CHARACTER  HEADER(NHEAD)*100
      CHARACTER  LINE*100, TITLE*80
      CHARACTER  NOT_ASSIGNED*30
      PARAMETER (NOT_ASSIGNED = 'Orbit not yet assigned')
      CHARACTER  DVER*30, PVER*15
      PARAMETER (PVER = 'w_deqsol.exe')
      CHARACTER  ORBIT(NORBIT)*12, ORBITF(NORBIT)*1024,
     +           ORBITT(NORBIT)*80
      CHARACTER (LEN = 80) WORD80, TRIM80
      LOGICAL    ORBITR(NORBIT)
      LOGICAL    ABORT, DOIT, FIRST, OK, READY, RESUL, THERE, TIMER
      LOGICAL    COVAR, IWARNU, RANPAR, RANY0, REFRESH, SHOW, SUPPLY
C-----------------------------------------------------------------------
C
C=======================================================================
C Externals and intrinsics
C
      EXTERNAL  PUTFAT, PUTADV, RESFIL, FNAMES, DATBIG, GETSTR, ISITMF,
     +          CHECKW, SIM256, YMDHMS, DEQEXP, VCOVAR, DATMUL
      EXTERNAL  DEQFIT, DEQMOD, DEQINI, DEQCOM, DEQFIL, DEQRAN, DEQCHK
      EXTERNAL  ADVISE, DECIDE, PARSIN, CONTRL, TIMEIN, ACTION, VALUES,
     +          GRAPHS, TABPRN, COMPAR, TABOUT, SHOWIT, GOFFIT, FUNCT1,
     +          DEQPLT
      EXTERNAL  DLLCHK, WINDOW, SIMVER, DLLNAG, X02AMF$
      EXTERNAL  DEFGKS
      EXTERNAL  TRIM80
      INTRINSIC MIN, DBLE, ABS
C=======================================================================
C
C=======================================================================
C Save arrays used for storage ... probably not necessary
C
      SAVE NTSAV1, NTSAV2
      SAVE NUMDAT, RESUL
      DATA COVAR / .FALSE. /
      DATA ORBIT / 'f$orbits.001', 'f$orbits.002', 'f$orbits.003',
     +             'f$orbits.004', 'f$orbits.005', 'f$orbits.006',
     +             'f$orbits.007', 'f$orbits.008', 'f$orbits.009',
     +             'f$orbits.010', 'f$orbits.011', 'f$orbits.012' /
C=======================================================================
C
C
C************************************************************************
C Open an inactive background window and then check the DLLs
C The following values must be edited at each release:
C XVER = version number
C YVER = release number
C DVER = release date
C These must be consistent with the same values in the SIMFIT DLLs
C
      ISEND = 1
      DOIT = .TRUE.
      TITLE = 'Simfit: program '// PNAME
      CALL WINDOW (ISEND,
     +             TITLE,
     +             DOIT)
      CALL SIMVER (XVER, YVER,
     +             DVER)
      ABORT = .FALSE.
      SHOW = .FALSE.
      CALL DLLCHK (XVER, YVER,
     +             DVER, PVER,
     +             ABORT, SHOW)
C
C Checking completed so now proceed to the main program
C**********************************************************************
C


C
C Advise user then stop or initialise
C
      FNAME = BLANK
      FIRST = .TRUE.
      CALL ADVISE (NPMAX, NTMAX, NYMAX,
     +             DVER,
     +             ABORT, FIRST)
      IF (ABORT) GOTO 60
      CALL DEFGKS
C
C Create temporary files to hold the phase plane orbits
C
      DO I = N1, NORBIT
         ORBITF(I) = SIM256(ORBIT(I))
         INQUIRE (FILE = ORBITF(I), EXIST = THERE)
         IF (THERE) THEN
C
C The orbit file exists
C           
            CALL ISITMF (NCOL, NROW,
     +                   ORBITF(I))
            IF (NCOL.EQ.N2 .AND. NROW.GT.N1) THEN  
C
C It is a simfit plot file so read the title
C
               OPEN (UNIT = 6, FILE = ORBITF(I), IOSTAT = IOS)
               READ (6,'(A)',IOSTAT=IOS) TITLE
               IF (IOS.EQ.N0) THEN
                  ORBITT(I) = TITLE 
                  ORBITR(I) = .TRUE.
               ELSE
                  ORBITR(I) = .FALSE.   
                  ORBITT(I) = NOT_ASSIGNED
               ENDIF
               CLOSE (UNIT = 6)
            ELSE
               ORBITR(I) = .FALSE.   
               ORBITT(I) = NOT_ASSIGNED   
            ENDIF   
         ELSE 
C
C The orbit file does not exist
C            
            ORBITT(I) = NOT_ASSIGNED
            ORBITR(I) = .FALSE.
         ENDIF   
      ENDDO
C
C Open error file unit for DVODE/LBFGS and iterate.dat
C                                     
      CALL YMDHMS (WORD32)
      FULL_PATH = SIM256('w_deqsol.txt')
      OPEN (UNIT = 6, FILE = FULL_PATH)
      WRITE (6,'(A)')
     +'SIMFIT: program DEQSOL ... messages from DVODE/LBFGSB'
      WRITE (6,'(A)') WORD32
      FULL_PATH = SIM256('iterate.txt')         
      OPEN (UNIT = 8, FILE = FULL_PATH)
      WRITE (8,'(A)')
     +'SIMFIT: program DEQSOL ... iteration data from LBFGSB'
      WRITE (8,'(A)') WORD32
C
C Initialise IFIT, IWANT, MUMPNT, SWAPIT, ASWAP
C
      IFIT = N0
      DO I = N1, N12
         IWANT(I) = I
      ENDDO
      DO I = N1, NYMAX
         NUMPNT(I) = N0
         SWAPIT(I) = .FALSE.
         DO J = N1, NYMAX
            IF (I.EQ.J) THEN
               ASWAP(I,J) = ONE
            ELSE
               ASWAP(I,J) = ZERO
            ENDIF
         ENDDO
      ENDDO
C
C Initialise X and Y to avoid graphics problems
C
      DO I = N1, N2
         X1(I) = ZERO
         X2(I) = ZERO
         X3(I) = ZERO
         X4(I) = ZERO
         X5(I) = ZERO
         X6(I) = ZERO
         X7(I) = ZERO
         X8(I) = ZERO
         X9(I) = ZERO
         X10(I) = ZERO
         X11(I) = ZERO
         X12(I) = ZERO
         Y1(I) = ZERO
         Y2(I) = ZERO
         Y3(I) = ZERO
         Y4(I) = ZERO
         Y5(I) = ZERO
         Y6(I) = ZERO
         Y7(I) = ZERO
         Y8(I) = ZERO
         Y9(I) = ZERO
         Y10(I) = ZERO
         Y11(I) = ZERO
         Y12(I) = ZERO
      ENDDO
      DO I = N1, IW
         W(I) = ZERO
      ENDDO  
C
C Initialise parameters and limits 
C       
      DO I = N1, NPMAX
         BL(I) = -ONE
         BU(I) = ONE
         P(I) = ZERO
         G(I) = ZERO
         XC(I) = ZERO
         XCRAN(I) = ZERO
      ENDDO   
C
C Initialise other variables that must be set on start up
C
      TOL = 1.0D-04
      DTOL = 1.0D-04 
      XEND = ONE
      XSTART = ZERO 
      FC = ZERO
      DO I = N1, NTMAX
         TX(I) = ZERO
         TXSAV1(I) = ZERO
         TXSAV2(I) = ZERO
      ENDDO
      DO I = N1, NSMALL
         FSAV(I) = BLANK
         TSAV(I) = BLANK
      ENDDO
      IADDUP = N0
      IRELAB = N0
      METHOD = N1
      ML = N1
      MPED = N1
      MU = N1
      NCYCLE = N4
      NFREE = N0
      NPTS = 121
      NRAND = N1
      NTSAV1 = N0
      NTSAV2 = N0
      NUMDAT = N0
      RTOL = 1.0D+12*X02AMF$()
      ANAME = 'No current transformation file'
      ATITLE = 'The identity matrix'
      OTYPE = 'medium'
      RELABS = 'M'
      STATS = COVAR
      FIRST = .TRUE.
      ISWAP = .FALSE.
      IWARNU = .TRUE.
      RANPAR = .FALSE.
      RANY0 = .FALSE.
      RESUL = .FALSE.
      TIMER = .TRUE.
      USER = .FALSE.
      USE_D02CJF = .FALSE.
      USE_D02EJF = .FALSE.
      USE_E04JYF = .FALSE.
      USE_E04KZF = .FALSE.
      USE_E04UFF = .FALSE.
      USE_JACOBIAN = .TRUE.
      CALL DLLNAG (MARK,
     +             OK)
      IF (MARK.GE.20 .AND. OK) THEN
         USE_NAG = .TRUE.
         REFRESH = .FALSE.
         USE_D02EJF = .TRUE.
         USE_E04UFF = .TRUE.
      ELSE
         USE_NAG = .FALSE.
         REFRESH = .TRUE.
      ENDIF  
      CALL CONTRL (IRELAB, METHOD, MPED, NHEAD, NOUT1, NYMAX,
     +             ASWAP, DTOL, TOL,
     +             ANAME, ATITLE, HEADER, OTYPE, RELABS,
     +             COVAR, ISWAP, READY, REFRESH, SWAPIT,
     +             USE_D02CJF, USE_D02EJF,
     +             USE_E04JYF, USE_E04KZF, USE_E04UFF,
     +             USE_JACOBIAN,
     +             USE_NAG)           
C
C =========
C LABEL 20: Initialise the differential equations each time round
C =========
C
   20 CONTINUE
      DO I = N1, NZMOD
         ZMOD(I) = BLANK
      ENDDO
      USER = .FALSE.
      CALL DEQMOD (MODEL, N, NMOD, NYMAX,
     +             MODEL_FILE, ZMOD,
     +             USER)
      IF (USER) THEN
C
C If USER = .TRUE. initialise a user supplied model
C
         FSAV(1) = MODEL_FILE
         M = NMOD
         CALL DEQEXP (M, N, N1,
     +                BL, BU, P, Y0,
     +                FSAV(1),
     +                ABORT)
         IF (ABORT) THEN            
            CALL PUTADV (
     +'Now read in a configure/initialise file (like deqpar?.tf?)')
            M = NMOD
            CALL DEQFIL (IRELAB, IW, M, METHOD, MPED, N, NIN, NPMAX,
     +                   NPTS, NTMAX, NYMAX,
     +                   BL, BU, P, TOL, W, XEND, XSTART, Y0,
     +                   ABORT)
         ELSE
            CALL DEQPLT (NIN, NPTS,
     +                   XEND, XSTART,
     +                   MODEL_FILE)           
         ENDIF
         IF (NLINES_2.LE.N**2) THEN
            IF (USE_NAG .AND. USE_D02EJF .AND. USE_JACOBIAN .OR.
     +          METHOD.EQ.1 .AND. MPED.EQ.1) CALL PUTADV (
     +'DEQSOL has now been re-configured to ignore the Jacobian')
            USE_JACOBIAN = .FALSE.
            MPED = 0
         ENDIF  
         DO I = N1, M - N
            PARNEW(I) = P(I)
         ENDDO     
         IF (ABORT) GOTO 20
      ELSEIF (MODEL.LE.0 .OR. N.LE.0 .OR. NMOD.LE.0) THEN
C
C User has selected Cancel in DEQMOD
C
         GOTO 60
      ELSE
C
C Otherwise initialise a library supplied model
C
         CALL DEQINI (IRELAB, M, MODEL, MPED, N, NMOD, NPMAX, NPTS,
     +                NYMAX,
     +                P, TOL, XEND, XSTART, Y0)
         DO I = N1, M - N
            PARNEW(I) = P(I)
         ENDDO   
         DO I = N1, M
            ABSPI = ABS(P(I))
            IF (ABSPI.LE.PNT1) THEN
               STEP = PNT1
            ELSEIF (ABSPI.LE.ONE) THEN
               STEP = ONE
            ELSEIF (ABSPI.LE.TEN) THEN
               STEP = TEN
            ELSEIF (ABSPI.LE.F100) THEN
               STEP = F100
            ELSE
               STEP = ABSPI
            ENDIF
            BL(I) = P(I) - STEP
            BU(I) = P(I) + STEP
         ENDDO
      ENDIF
      REFRESH = .TRUE.
      CALL CONTRL (IRELAB, METHOD, MPED, NHEAD, NOUT1, NYMAX,
     +             ASWAP, DTOL, TOL,
     +             ANAME, ATITLE, HEADER, OTYPE, RELABS,
     +             COVAR, ISWAP, READY, REFRESH, SWAPIT,
     +             USE_D02CJF, USE_D02EJF,
     +             USE_E04JYF, USE_E04KZF, USE_E04UFF,
     +             USE_JACOBIAN,
     +             USE_NAG)      
C
C Create then save data range
C
      CALL DEQCHK (XEND, XSTART,
     +             ABORT)
      STEP = (XEND - XSTART)/(DBLE(NPTS) - ONE)
      TX(1) = XSTART
      DO I = N2, NPTS - N1
         TX(I) = TX(I - N1) + STEP
      ENDDO
      TX(NPTS) = XEND
      TX(NPTS + N1) = XEND + ONE
      NTSAV1 = NPTS
      DO I = N1, NTSAV1 + N1
         TXSAV1(I) = TX(I)
      ENDDO
      XESAV1 = XEND
      XSSAV1 = XSTART
C
C Re-set NUMY since a new equation has been chosen
C
      NUMY = MIN(N12,N)
      J = N0
      DO I = N1, NUMY
         IF (IWANT(I).GT.N) THEN
            IWANT(I) = N1
            J = J + N1
         ENDIF    
      ENDDO
      IF (J.GT.N0) THEN
         CALL PUTFAT ('Index i in selected y(i) exceeded .. Re-select')
         CALL VALUES (IWANT, N, NUMY)
      ENDIF
      CPU = - ONE
      READY = .FALSE.
C
C =========
C LABEL 40: Decide next course of action
C =========
C
   40 CONTINUE
      NPTS = NTSAV1
      XEND = XESAV1
      XSTART = XSSAV1
c*****IF (METHOD.EQ.1   .AND.
c****+    USER          .AND.
c****+    MPED.EQ.1     .AND.
c****+    NLINES_2.LT.1) THEN
c*********MPED = 0
c*********CALL PUTADV ('No Jacobian ... MPED set to 0')
c*****ENDIF
      IF (READY) THEN
         NDEC = 8
      ELSE
         NDEC = 7
      ENDIF
      NUMPI = M - N
      NUMY0 = N
      CALL DECIDE (IFIT, NCYCLE, NDEC, NOUT, NPTS,
     +             NRAND, NUMPI, NUMY0,
     +             CPU, XEND, XSTART, 
     +             HEADER, OTYPE,
     +             COVAR, ISWAP, RANPAR, RANY0, READY)
C
C Exit if NDEC = 15
C -----------------
C
      IF (NDEC.EQ.15) GOTO 60
C
C Check if decision is consistent with current state of program
C
      IF (NDEC.EQ.8 .OR. NDEC.EQ.9 .OR.NDEC.EQ.10 .OR. NDEC.EQ.11) THEN
         IF (.NOT.READY) THEN
            CALL PUTFAT ('First integrate the equations')
            GOTO 40
         ENDIF
         IF (NUMY.LT.N1) THEN
            CALL PUTFAT ('First select y(i) to plot etc.')
            GOTO 40
         ENDIF
      ENDIF
      IF (NDEC.EQ.1) THEN
C
C NDEC = 1: Details of model
C --------------------------
C
         CALL SHOWIT (NZMOD,
     +                ZMOD)
      ELSEIF (NDEC.EQ.2) THEN
C
C NDEC = 2: Alter control parameters
C ----------------------------------
C
         REFRESH = .FALSE.
         CALL CONTRL (IRELAB, METHOD, MPED, NHEAD, NOUT1, NYMAX,
     +                ASWAP, DTOL, TOL,
     +                ANAME, ATITLE, HEADER, OTYPE, RELABS,
     +                COVAR, ISWAP, READY, REFRESH, SWAPIT,
     +                USE_D02CJF, USE_D02EJF,
     +                USE_E04JYF, USE_E04KZF, USE_E04UFF,
     +                USE_JACOBIAN,
     +                USE_NAG)
      ELSEIF (NDEC.EQ.3) THEN
C
C NDEC = 3: Alter parameters
C --------------------------
C
         NTEMP = 1
         CALL PARSIN (NSMALL, NTEMP, M, N, NPMAX,
     +                BL, BU, P, Y0,
     +                FSAV, TSAV,
     +                READY)
         DO I = N1, M - N
            PARNEW(I) = P(I)
         ENDDO   
      ELSEIF (NDEC.EQ.4) THEN
C
C NDEC = 4: Alter initial conditions
C ----------------------------------
C
         NTEMP = 2
         CALL PARSIN (NSMALL, NTEMP, M, N, NPMAX,
     +                BL, BU, P, Y0,
     +                FSAV, TSAV,
     +                READY)
      ELSEIF (NDEC.EQ.5) THEN
C
C NDEC = 5: Parameter file
C ------------------------
C
         CALL PUTADV (
     +'Now read in a configure/initialise file (like deqpar?.tf?)')
         CALL DEQFIL (IRELAB, IW, M, METHOD, MPED, N, NIN, NPMAX, NPTS,
     +                NTMAX, NYMAX,
     +                BL, BU, P, TOL, W, XEND, XSTART, Y0,
     +                ABORT)
         DO I = N1, M - N
            PARNEW(I) = P(I)
         ENDDO   
         CALL DEQCHK (XEND, XSTART,
     +                ABORT)
         STEP = (XEND - XSTART)/(DBLE(NPTS) - ONE)
         TX(1) = XSTART
         DO I = N2, NPTS - N1
            TX(I) = TX(I - N1) + STEP
         ENDDO
         TX(NPTS) = XEND
         TX(NPTS + N1) = XEND + ONE
         NTSAV1 = NPTS
         DO I = N1, NTSAV1 + N1
            TXSAV1(I) = TX(I)
         ENDDO
         XESAV1 = XEND
         XSSAV1 = XSTART
         READY = .FALSE.
      ELSEIF (NDEC.EQ.6) THEN
C
C NDEC = 6: Alter time values
C ---------------------------
C
         CALL TIMEIN (NPTS, NTMAX,
     +                XEND, XSTART,
     +                READY)
         CALL DEQCHK (XEND, XSTART,
     +                ABORT)
         STEP = (XEND - XSTART)/(DBLE(NPTS) - ONE)
         TX(1) = XSTART
         DO I = N2, NPTS - N1
            TX(I) = TX(I - N1) + STEP
         ENDDO
         TX(NPTS) = XEND
         TX(NPTS + N1) = XEND + ONE
         NTSAV1 = NPTS
         DO I = N1, NTSAV1 + N1
            TXSAV1(I) = TX(I)
         ENDDO
         XESAV1 = XEND
         XSSAV1 = XSTART
      ELSEIF (NDEC.EQ.7) THEN
C
C NDEC = 7: Integrate
C -------------------
C
C Set ICOUNT = 1, calculate time points then integrate
C ICOUNT, N and TX must be in the module to communicate with OUTPUT
C Extra time point required to fool OUTPUT into quiet integration at XEND
C
         ICOUNT = N1
         TIMER = .TRUE.
         DO I = N1, M - N
            PARNEW(I) = P(I)
         ENDDO  
         DO I = N1, IW
            W(I) = ZERO
         ENDDO    
         CALL ACTION (IFAIL, IP, IRELAB, IW, M, METHOD, MODEL, MPED, N,
     +                NIP, NMOD, NPMAX, NWORK, NYMAX,
     +                CPU, P, TOL, W, XEND, XSTART, Y, YPREV, Y0,
     +                TIMER, USER)
         IF (IFAIL.EQ.2) THEN
            READY = .TRUE.
         ELSE
            WRITE (LINE,100) IFAIL
            CALL PUTFAT (LINE)
            READY = .FALSE.
         ENDIF
      ELSEIF (NDEC.EQ.8) THEN
C
C NDEC = 8: Graph
C ---------------
C
         IP(1) = N
         IP(2) = NMOD
         IP(3) = NYMAX
         IP(4) = M
         CALL GRAPHS (IP, IWANT, N, NIP, NORBIT, NPMAX, NPTS, NTMAX,
     +                NUMY, NYMAX,
     +                P, TX,
     +                X1, X2, X3, X4, X5, X6, X7, X8, X9, X10, X11, X12,
     +                YVAL,
     +                Y1, Y2, Y3, Y4, Y5, Y6, Y7, Y8, Y9, Y10, Y11, Y12,
     +                ORBITF, ORBITT,
     +                ORBITR, USER)
      ELSEIF (NDEC.EQ.9) THEN
C
C NDEC = 9: Table
C ---------------
C
         CALL TABPRN (IWANT, NPTS, NTMAX, NUMY, NYMAX,
     +                TX, YVAL)
      ELSEIF (NDEC.EQ.10) THEN
C
C NDEC = 10: File
C ---------------
C
         CALL TABOUT (IWANT, NOUT1, NPTS, NTMAX, NUMY, NYMAX,
     +                TX, YVAL)
      ELSEIF (NDEC.EQ.11) THEN
C
C NDEC = 11: Compare with alternative model
C -----------------------------------------
C
         CALL DEQCOM (IWANT, M, MODEL, NMOD, NPTS, NTMAX, NUMY, NYMAX,
     +                P, TX, XSTART, YCOM, Y0,
     +                ABORT)
         IF (ABORT) THEN
            CALL PUTFAT ('No comparison equation supplied')
         ELSE
            CALL COMPAR (IWANT, NPTS, NTMAX, NUMY, NYMAX,
     +                   TX, YCOM, YVAL, Y1, Y2, Y3, Y4, Y5, Y6, Y7, Y8,
     +                   Y9, Y10, Y11, Y12)
         ENDIF
      ELSEIF (NDEC.EQ.12) THEN
C
C NDEC = 12: Choose values i for y(i) plotting etc.
C -------------------------------------------------
C
         CALL VALUES (IWANT, N, NUMY)
      ELSEIF (NDEC.EQ.13) THEN
C
C NDEC = 13: curve fitting ... action depends on IFIT
C ---------------------------------------------------
C
         IF (IFIT.EQ.1) THEN
C
C Fitting (1) ... Open file to store output if first time round
C
            IF (FIRST) THEN
               CALL RESFIL (NOUT,
     +                      FNAME,
     +                      ABORT)
               IF (FNAME.EQ.BLANK) THEN
                  RESUL = .FALSE.
               ELSE
                  RESUL = .TRUE.
                  WRITE (NOUT,200)
               ENDIF
               FIRST = .FALSE.
            ENDIF
C
C Fitting (2) ... Read in data if IFIT = 1
C
            CALL DATMUL (N, NIN, NPTBIG,
     +                   FSAV1, TSAV1,
     +                   ABORT)
            IF (.NOT.ABORT .AND. NPTBIG.GT.0) THEN
               SUPPLY = .TRUE. 
            ELSE
               SUPPLY = .FALSE.
            ENDIF   
            CALL DATBIG (IADDUP, INDX, LW3, N, NIN, NUMPNT, NTMAX,
     +                   NYMAX,
     +                   SDATA, Y1, W3, XDATA, Y2, YDATA, Y3,
     +                   FSAV1, TSAV1, 
     +                   ABORT, SUPPLY)
            IF (IADDUP.GT.0) CALL DEQCHK (W3(IADDUP), W3(1),
     +                                    ABORT)
            IF (IADDUP.LT.N2 .OR. ABORT) THEN
               NTSAV2 = N0
               IFIT = N0
               CALL PUTFAT ('Insufficient data for fitting')
               GOTO 40
            ENDIF
C
C Get NPTBIG = total no. data points and DOFDOM = NPTBIG - M
C
            NPTBIG = 0
            DO I = 1, N
               NPTBIG = NPTBIG + NUMPNT(I)
            ENDDO
            IF (NPTBIG.LE.M) THEN
               IFIT = N0
               CALL PUTFAT ('Insufficient data to fit this model')
               GOTO 40
            ENDIF
            IF (RESUL) THEN
               NUMDAT = NUMDAT + N1
               WRITE (LINE,300) NUMDAT
               CALL YMDHMS (WORD32)
               WRITE (DNAME,400) WORD32, NUMDAT
               CALL GETSTR (LINE, DNAME)
               WORD80 = TRIM80(DNAME)
               WRITE (NOUT,500) NUMDAT, WORD80
            ENDIF
C
C Fitting (3) ... Store curve fitting time points and check for EXPERT mode
C
            NTSAV2 = IADDUP
            XSSAV2 = W3(1)
            XESAV2 = W3(NTSAV2)
            DO I = N1, NTSAV2
               TXSAV2(I) = W3(I)
            ENDDO
            TXSAV2(NTSAV2 + N1) = XESAV2 + ONE
            CALL DEQEXP (M, N, N,
     +                   BL, BU, P, Y0,
     +                   FSAV1,
     +                   ABORT)
            READY = ABORT  
            IF (W3(1).LT.XSTART .OR. W3(IADDUP).GT.XEND) THEN
               READY = .FALSE.
               XSTART = W3(1)
               XEND = W3(IADDUP)
               STEP = (XEND - XSTART)/(DBLE(NPTS) - ONE)
               TX(1) = XSTART
               DO I = N2, NPTS - N1
                  TX(I) = TX(I - N1) + STEP
               ENDDO
               TX(NPTS) = XEND
               TX(NPTS + N1) = XEND + ONE
               NTSAV1 = NPTS
               DO I = N1, NTSAV1 + N1
                  TXSAV1(I) = TX(I)
               ENDDO
               XESAV1 = XEND
               XSSAV1 = XSTART 
            ENDIF                     
            GOTO 40
         ELSEIF (IFIT.EQ.2) THEN
            IF (IADDUP.LT.N2 .OR. NTSAV2.LT.N2) THEN
               IFIT = N0
               CALL PUTFAT ('Data not yet supplied for fitting')
               GOTO 40
            ENDIF
C
C Fitting (4) ... IFIT = 2, Initialise XC to make sure XC = P, Y0 = P
C
C =========================================
C Note the use of FACTOR to achieve scaling
C =========================================
C
            NFREE = 0
            DO I = N1, M - N
               IF (ABS(P(I)).GT.EPSI) THEN
                  FACTOR(I) = ABS(P(I))
               ELSE
                  FACTOR(I) = ONE
               ENDIF
               BL(I) = BL(I)/FACTOR(I)
               XC(I) = P(I)/FACTOR(I)
               BU(I) = BU(I)/FACTOR(I)
               IF (BU(I) - BL(I).GT.EPSI) THEN
                  NFREE = NFREE + 1
                  ISTATE(I) = 1
               ELSE
                  ISTATE(I) = 0
               ENDIF      
            ENDDO
            J = M - N
            DO I = N1, N
               J = J + N1
               IF (ABS(P(J)).GT.EPSI) THEN
                  FACTOR(J) = ABS(P(J))
               ELSE
                  FACTOR(J) = ONE
               ENDIF
               BL(J) = BL(J)/FACTOR(J)
               XC(J) = Y0(I)/FACTOR(J)
               BU(J) = BU(J)/FACTOR(J)
               IF (BU(J) - BL(J).GT.EPSI) THEN
                  NFREE = NFREE + 1
                  ISTATE(J) = 1
               ELSE
                  ISTATE(J) = 0
               ENDIF      
            ENDDO
            DOFDOM = DBLE(NPTBIG - NFREE)
C
C Fitting (5) ... IFIT = 2, Use old data if IFIT = 2
C
            XEND = XESAV2
            XSTART = XSSAV2
            NPTS = NTSAV2
            DO I = N1, NPTS + N1
               TX(I) = TXSAV2(I)
            ENDDO
C
C Fitting (6) ... IFIT = 2, Call fitting routine
C
            CALL FUNCT1 (M,
     +                   XC, FC)
            CALL CHECKW (NPTBIG - NFREE,
     +                   DOFDOM*FC)
            IF (RANPAR .OR. RANY0) THEN
               CALL DEQRAN (IFAIL1, IWRK, LIWRK, LW1, LW2, M, N, NBD,
     +                      NCYCLE, NOUT, NPTBIG, NRAND,
     +                      BL, BU, CPU1, FC, G, W1, W2, XC, XCRAN,
     +                      OTYPE,
     +                      IWARNU, RANPAR, RANY0,
     +                      USE_E04JYF, USE_E04KZF, USE_E04UFF)
            ELSE
               CALL DEQFIT (IFAIL1, IWRK, LIWRK, LW1, LW2, M, NBD, NOUT,
     +                      NPTBIG,
     +                      BL, BU, CPU1, FC, G, W1, W2, XC,
     +                      OTYPE,
     +                      IWARNU,
     +                      USE_E04JYF, USE_E04KZF, USE_E04UFF)
            ENDIF
            SIGMA = FC
            CALL CHECKW (NPTBIG - NFREE,
     +                   DOFDOM*FC)
            STATS = COVAR
            CALL VCOVAR (IADDUP, INDEX1, INDX, IRELAB, ISTATE, IW,
     +                   LIW, M, METHOD, MODEL, MPED, N, NFREE, NHESS,
     +                   NMOD, NOUT, NPMAX, NTMAX, NWORK, NPTBIG,
     +                   NUMPNT, NYMAX,
     +                   CORR, CV, DIAGV, DOFDOM, 
     +                   FACTOR, FJACC, HESSEX, HESSIN, PARNEW,
     +                   RTOL, SDATA, SIGMA, TOL, W, XC, XEND,
     +                   XSTART, Y, YCOM, YVAL, YPREV, Y0,
     +                   FREE, STATS, TIMER, USER)
C
C Fitting (7) ... IFIT = 2, Make sure parameters = best-fit parameters
C
C =========================================
C Note the use of FACTOR to achieve scaling
C =========================================
C
            DO I = N1, M - N
               BL(I) = FACTOR(I)*BL(I)
               P(I) = FACTOR(I)*XC(I)
               XC(I) = P(I)
               BU(I) = FACTOR(I)*BU(I)
            ENDDO
            J = M - N
            DO I = N1, N
               J = J + N1
               BL(J) = FACTOR(J)*BL(J)
               P(J) = FACTOR(J)*XC(J)
               XC(J) = P(J)
               Y0(I) = P(J)
               BU(J) = FACTOR(J)*BU(J)
            ENDDO
C
C Fitting (8) ... IFIT = 2, Final integration to check quality of integration
C
            TIMER = .FALSE.
            ICOUNT = N1
            CALL ACTION (IFAIL, IP, IRELAB, IW, M, METHOD, MODEL, MPED,
     +                   N, NIP, NMOD, NPMAX, NWORK, NYMAX,
     +                   CPU, XC, TOL, W, XEND, XSTART, Y, YPREV, Y0,
     +                   TIMER, USER)
            IF (IFAIL.EQ.2) THEN
               READY = .TRUE.
            ELSE
               WRITE (LINE,100) IFAIL
               CALL PUTFAT (LINE)
               READY = .FALSE.
C**************GOTO 40
            ENDIF
C
C Fitting (9) ... IFIT = 2, Save best fit values for GOFFIT
C
            DO I = N1, N
               DO J = N1, NPTS
                  YCOM(J,I) = YVAL(J,I)
               ENDDO
            ENDDO
C
C Fitting (10) ... IFIT = 2, Restore data
C
            XEND = XESAV1
            XSTART = XSSAV1
            NPTS = NTSAV1
            DO I = N1, NPTS + N1
               TX(I) = TXSAV1(I)
            ENDDO
C
C Fitting (11) ... IFIT = 2, Generate points for plotting
C
            TIMER = .TRUE.
            ICOUNT = N1
            CALL ACTION (IFAIL, IP, IRELAB, IW, M, METHOD, MODEL, MPED,
     +                   N, NIP, NMOD, NPMAX, NWORK, NYMAX,
     +                   CPU, P, TOL, W, XEND, XSTART, Y, YPREV, Y0,
     +                   TIMER, USER)
            IF (IFAIL.EQ.2) THEN
               READY = .TRUE.
            ELSE
               WRITE (LINE,100) IFAIL
               CALL PUTFAT (LINE)
               READY = .FALSE.
C**************GOTO 40
            ENDIF
         ENDIF
         IF (IFIT.EQ.2 .OR. IFIT.EQ.3) THEN
            IF (IADDUP.LT.N2 .OR. NTSAV2.LT.N2) THEN
               IFIT = N0
               CALL PUTFAT ('Insufficient data for plotting')
               GOTO 40
            ENDIF
C
C Fitting (12) ... IFIT = 2 or 3, Goodness of fit
C
            NTVAL = NTMAX
            NYVAL = NYMAX
            CALL GOFFIT (IFAIL1, IFIT, IWANT, M, NFREE, NOUT, NTVAL,
     +                   NTVAL, NUMY, NYVAL,
     +                   BL, BU, CPU1, FC, XC, XDATA, X1, X3, X5, X7,
     +                   X9, X11, YCOM, Y1, Y2, Y3, Y4, Y5, Y6, Y7, Y8,
     +                   Y9, Y10, Y11, Y12,
     +                   RESUL)
          ENDIF
      ELSEIF (NDEC.EQ.14) THEN
C
C NDEC = 14: New equations
C ------------------------
C
         GOTO 20
      ENDIF

      IF (NDEC.NE.15) GOTO 40

C
C =========
C LABEL 60: Close down
C =========
C
   60 CONTINUE
      CLOSE (UNIT = NOUT)
      I = N2
      CALL FNAMES (I, FNAME)
      CLOSE (UNIT = 6)
      CLOSE (UNIT = 8)

C
C======================================================================
C The program is finished so we can close down the background window
C
      ISEND = 1
      DOIT = .FALSE.
      CALL WINDOW (ISEND, TITLE, DOIT)
C
C======================================================================
C


  100 FORMAT (
     +'IFAIL =',I3,', Change TOL/Err./Method/Jac./p(i)/y0(i)/range ?')
  200 FORMAT (
     +/' PACKAGE: SIMFIT'
     +/' PROGRAM: DEQSOL'
     +/' ACTION : Simulate/Fit systems of differential equations'
     +/' AUTHOR : W.G.Bardsley, University of Manchester, U.K.')
  300 FORMAT (
     +'Details to identify data set ',I3,': model/params/data, etc.')
  400 FORMAT (
     +A,': Data set:',i3,' ...')   
  500 FORMAT (
     +/' Analysis of data set number',I3,
     +/' ------------------------------'
     +/1X,A)
      END
C
C
