
C
C DEQSOL1.FOR
C ===========
C
C ADVISE
C DEQCHK
C DEQFIL
C DEQPLT
C DEQSWP uses MODULE_DEQSOL
C
C-----------------------------------------------------------------------
C
      SUBROUTINE ADVISE (NPMAX, NTMAX, NYMAX,
     +                   DVER,
     +                   ABORT, FIRST)
C
C Action: Advise user
C Author: w.g.bardsley, university of manchester, u.k.
C         18/01/2010 extensive revision
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)  :: NPMAX, NTMAX, NYMAX
      CHARACTER (LEN = *), INTENT (IN)  :: DVER
      LOGICAL,             INTENT (OUT) :: ABORT
      LOGICAL,             INTENT (IN)  :: FIRST
C
C Locals
C
      INTEGER    ISEND
      INTEGER    ICOLOR, NUMHDR, NUMOPT
      PARAMETER (ICOLOR = 3, NUMHDR = 14, NUMOPT = 3)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      CHARACTER (LEN = 12) I12(3), FORM12
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*50
      LOGICAL    REPEET
      EXTERNAL   FORM12
      EXTERNAL   TITLES, HELP_DEQSOL
      INTRINSIC  TRIM
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION /
     +'Help           ',
     +'Run the program',
     +'Quit  ...  Exit' /
      ABORT = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (FIRST) THEN
            I12(1) = FORM12(NYMAX)
            I12(2) = FORM12(NPMAX)
            I12(3) = FORM12(NTMAX - 1)
            WRITE (HEADER,100) TRIM(I12(1)), TRIM(I12(2)), DVER, 
     +                         TRIM(I12(3))
            ISEND = 1
            CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
         ELSE
            ISEND = 1
         ENDIF
         IF (ISEND.EQ.1) THEN
            CALL HELP_DEQSOL ('deqsol')
            IF (FIRST) THEN
               REPEET = .TRUE.
            ELSE
               ABORT = .FALSE.
               REPEET = .FALSE.
            ENDIF
         ELSEIF (ISEND.EQ.2) THEN
            ABORT = .FALSE.
            REPEET = .FALSE.
         ELSEIF (ISEND.EQ.3) THEN
            ABORT = .TRUE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT (
     + 'Package `SIMFIT'
     +/'        `      '
     +/'Program `DEQSOL (max. eqns. ',A,', max. params. ',A,')'
     +/'        `      '
     +/'Action  `Input differential equations from a library/file.'
     +/'        `Choose parameters,initial conditions,methods,etc.'
     +/'        `Integrate,curve-fit-data,plot,file,compare,etc.'
     +/'        `      '
     +/'Version `',A
     +/'        `Maximum number of data rows',1X,A
     +/'        `      '
     +/'Graphics`Windows types plus EPS, PDF, PNG, and SVG.'
     +/'        `      '
     +/'Author  `W.G.Bardsley, University of Manchester, U.K.')
      END
C
C
c----------------------------------------------------------------------
c
c
      subroutine deqchk (xend, xstart,
     +                   abort)
c
c action: make sure xend > xstart >= 0
c author: w.g.bardsley, university of manchester, u.k., 01/07/2005
c
c   xend: (input/output) end value for integration
c xstart: (input/output) start value for integration
c  abort: (output) error indicator
c
      implicit   none
c
c arguments
c
      double precision, intent (inout) :: xend, xstart
      logical,          intent (out)   :: abort
c
c locals
c
      character  line*100
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      character (len = 13) d13, showlj
      logical    e_numbers, e_formats
      external   e_formats, showlj
      external   putadv
      
      if (xstart.ge.zero .and. xend.gt.xstart) then
         abort = .false.
         if (xstart.gt.zero) then
            e_numbers = e_formats()
            if (e_numbers) then
               write (line,100) xstart
            else
               d13 = showlj(xstart)
               write (line,150) d13
            endif      
            call putadv (line)
         endif
      else
         abort = .true.
         xstart = zero
         xend = one
         write (line,200)
         call putadv (line)
      endif
c
c Format statements
c      
  100 format ('x_start =',1p,e10.3,
     +' > 0 but note that initial conditions refer to x = 0')
  150 format ('x_start =',1x,a,
     +' > 0 but note that initial conditions refer to x = 0')   
  200 format (
     +'Must have x_end > x_start >= 0, values re-set to 0,1')
      end
c
c
c-----------------------------------------------------------------------
C
C
      SUBROUTINE DEQFIL (IRELAB, IW, M, METHOD, MPED, N, NIN, NPMAX,
     +                   NPTS, NTMAX, NYMAX,
     +                   BL, BU, P, TOL, W, XEND,  XSTART, Y0,
     +                   ABORT)
C
C ACTION : Read in a parameter file for DEQSOL
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 18/4/95
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: IW, NIN, NPMAX, NTMAX, NYMAX
      INTEGER,          INTENT (INOUT) :: IRELAB, M, METHOD, MPED, N,
     +                                    NPTS
      DOUBLE PRECISION, INTENT (INOUT) :: BL(NPMAX), BU(NPMAX)
      DOUBLE PRECISION, INTENT (INOUT) :: P(NPMAX), TOL, W(IW), XEND,
     +                                    XSTART, Y0(NYMAX)
      LOGICAL,          INTENT (OUT)   :: ABORT
C
C Locals
C      
      INTEGER    I, ICOUNT, IOS, ISEND, J
      PARAMETER (ISEND = 3)
      INTEGER    K1, K2, K3, K4, K5, K6
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4)
      DOUBLE PRECISION A, B, C, T1, X1, X2
      CHARACTER  FNAME*1024, LINE*100
      LOGICAL    YES
      EXTERNAL   OFILES, PUTFAT, YESNO2, PUTADV
   20 CONTINUE
C
C Open file
C
      CLOSE (UNIT = NIN)
      CALL OFILES (ISEND, NIN, 
     +             FNAME,
     +             ABORT)
      IF (ABORT) RETURN
C
C Title
C
      ABORT = .TRUE.
      ICOUNT = 1
      READ (NIN,100,END=40,ERR=40,IOSTAT=IOS) LINE
      IF (IOS.NE.0) GOTO 40
C
C IRELAB
C
      ICOUNT = ICOUNT + 1
      READ (NIN,100,END=40,ERR=40,IOSTAT=IOS) LINE
      IF (IOS.NE.0) GOTO 40
      READ (LINE(1:12),*,END=40,ERR=40,IOSTAT=IOS) K1
      IF (IOS.NE.0) GOTO 40
      IF (K1.LT.0 .OR. K1.GT.2) THEN
         CALL PUTFAT ('IRELAB must be 0, 1 or 2')
         GOTO 40
      ENDIF
C
C M
C
      ICOUNT = ICOUNT + 1
      READ (NIN,100,END=40,ERR=40,IOSTAT=IOS) LINE
      IF (IOS.NE.0) GOTO 40
      READ (LINE(1:12),*,END=40,ERR=40,IOSTAT=IOS) K2
      IF (IOS.NE.0) GOTO 40
      IF (K2.LT.1 .OR. K2.GT.NPMAX) THEN
         CALL PUTFAT ('M must be > 0 and < max allowed')
         GOTO 40
      ENDIF
      IF (K2.NE.M) THEN
         CALL PUTFAT (
     +   'No. of parameters inconsistent with current model')
         GOTO 40
      ENDIF
C
C METHOD
C
      ICOUNT = ICOUNT + 1
      READ (NIN,100,END=40,ERR=40,IOSTAT=IOS) LINE
      IF (IOS.NE.0) GOTO 40
      READ (LINE(1:12),*,END=40,ERR=40,IOSTAT=IOS) K3
      IF (IOS.NE.0) GOTO 40
      IF (K3.EQ.3) THEN
         K3 = 2
         CALL PUTADV (
     +'3 not allowed in this version  ...  METHOD re-set to 2 (Adams)')
      ENDIF
      IF (K3.LT.1 .OR. K3.GT.3) THEN
         CALL PUTFAT ('METHOD must be 1 (BDF) or 2 (Adams)')
         GOTO 40
      ENDIF
C
C MPED
C
      ICOUNT = ICOUNT + 1
      READ (NIN,100,END=40,ERR=40,IOSTAT=IOS) LINE
      IF (IOS.NE.0) GOTO 40
      READ (LINE(1:12),*,END=40,ERR=40,IOSTAT=IOS) K4
      IF (IOS.NE.0) GOTO 40
      IF (K4.LT.0 .OR. K4.GT.1) THEN
         CALL PUTFAT ('MPED must be 0 or 1')
         GOTO 40
      ENDIF
C
C N
C
      ICOUNT = ICOUNT + 1
      READ (NIN,100,END=40,ERR=40,IOSTAT=IOS) LINE
      IF (IOS.NE.0) GOTO 40
      READ (LINE(1:12),*,END=40,ERR=40,IOSTAT=IOS) K5
      IF (IOS.NE.0) GOTO 40
      IF (K5.LT.1 .OR. K5.GT.NYMAX) THEN
         CALL PUTFAT ('N must be > 0 and < max allowed')
         GOTO 40
      ENDIF
      IF (K5.NE.N) THEN
         CALL PUTFAT (
     +   'No. of equations inconsistent with current model')
         GOTO 40
      ENDIF
C
C NPTS
C
      ICOUNT = ICOUNT + 1
      READ (NIN,100,END=40,ERR=40,IOSTAT=IOS) LINE
      IF (IOS.NE.0) GOTO 40
      READ (LINE(1:12),*,END=40,ERR=40,IOSTAT=IOS) K6
      IF (IOS.NE.0) GOTO 40
      IF (K6.LT.2 .OR. K6.GT.NTMAX) THEN
         CALL PUTFAT ('NPTS < 2 or NPTS > max allowed')
         GOTO 40
      ENDIF
C
C P
C
      DO I = 1, M
         ICOUNT = ICOUNT + 1
         READ (NIN,100,END=40,ERR=40,IOSTAT=IOS) LINE
         IF (IOS.NE.0) GOTO 40
         READ (LINE(1:36),*,END=40,ERR=40,IOSTAT=IOS) A, B, C
         IF (IOS.NE.0) GOTO 40
         IF (A.GT.B) THEN
            CALL PUTFAT ('lower limit > parameter starting value')
            GOTO 40
         ENDIF
         IF (B.GT.C) THEN
            CALL PUTFAT ('parameter starting value > upper limit')
            GOTO 40
         ENDIF
         W(I) = A
         W(M + I) = B
         W(2*M + I) = C
      ENDDO
C
C TOL
C
      ICOUNT = ICOUNT + 1
      READ (NIN,100,END=40,ERR=40,IOSTAT=IOS) LINE
      IF (IOS.NE.0) GOTO 40
      READ (LINE(1:12),*,END=40,ERR=40,IOSTAT=IOS) T1
      IF (IOS.NE.0) GOTO 40
      IF (T1.LT.0 .OR. T1.GT.1.0) THEN
         CALL PUTFAT ('TOL must be > 0 and < 1.0')
         GOTO 40
      ENDIF
C
C XEND
C
      ICOUNT = ICOUNT + 1
      READ (NIN,100,END=40,ERR=40,IOSTAT=IOS) LINE
      IF (IOS.NE.0) GOTO 40
      READ (LINE(1:12),*,END=40,ERR=40,IOSTAT=IOS) X2
      IF (IOS.NE.0) GOTO 40
C
C XSTART
C
      ICOUNT = ICOUNT + 1
      READ (NIN,100,END=40,ERR=40,IOSTAT=IOS) LINE
      IF (IOS.NE.0) GOTO 40
      READ (LINE(1:12),*,END=40,ERR=40,IOSTAT=IOS) X1
      IF (IOS.NE.0) GOTO 40
      IF (X1.GE.X2) THEN
         CALL PUTFAT ('XSTART >= XEND')
         GOTO 40
      ENDIF
      IRELAB = K1
      METHOD = K3
      MPED = K4
      NPTS = K6
      DO I = 1, M
         BL(I) = W(I)
         P(I) = W(M + I)
         BU(I) = W(2*M + I)
      ENDDO
      J = M - N
      DO I = 1, N
         J = J + 1
         Y0(I) = P(J)
      ENDDO
      TOL = T1
      XSTART = X1
      XEND = X2
      ABORT = .FALSE.
      CLOSE (UNIT = NIN)
      RETURN
   40 CONTINUE
      WRITE (LINE,200) ICOUNT
      CALL PUTFAT (LINE)
      CLOSE (UNIT = NIN)
      WRITE (LINE,300)
      YES = .TRUE.
      CALL YESNO2 (ICOLOR, IX, IY,
     +             LINE, 
     +             YES)
      IF (YES) GOTO 20
      ABORT = .TRUE.
C
C format statements
C      
  100 FORMAT (A)
  200 FORMAT ('Check the configuration file at line number',I3)
  300 FORMAT ('Do you want to try another configuration file ?')
      END
C
C----------------------------------------------------------------------
C      
      SUBROUTINE DEQPLT (NIN, NPTS,
     +                   XEND, XSTART,
     +                   FNAME)
C
C ACTION: read plotting range data off user model file o/w manually
C AUTHOR: w.g.bardsley, university of manchester, u.k., 27/01/2010
C
       IMPLICIT NONE
C
C Arguments
C
       INTEGER,             INTENT (IN)    :: NIN
       INTEGER,             INTENT (INOUT) :: NPTS
       DOUBLE PRECISION,    INTENT (INOUT) :: XEND, XSTART
       CHARACTER (LEN = *), INTENT (IN)    :: FNAME
C
C Locals
C       
       INTEGER    IOS, I, NPTS_1
       INTEGER    NPTMAX, NPTMIN
       PARAMETER (NPTMAX = 200, NPTMIN = 2)
       DOUBLE PRECISION X1, X2, XEND_1, XSTART_1
       DOUBLE PRECISION ZERO, ONE
       PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
       CHARACTER  LINE1*100, LINE*100
       CHARACTER  BLANK*1
       PARAMETER (BLANK = ' ')
       EXTERNAL   GETJM1, GETDG2  
       INTRINSIC  INDEX
C
C Initialise
C       
       NPTS_1 = 0
       XEND_1 = ZERO
       XSTART_1 = ONE
       CLOSE (UNIT = NIN)
C
C Scan the file until begin{range} is encountered
C       
       OPEN (UNIT = NIN, FILE = FNAME, IOSTAT = IOS)
       DO WHILE (IOS.EQ.0)
          READ (NIN,'(A)',IOSTAT=IOS) LINE1
          IF (IOS.EQ.0) THEN
             LINE = LINE1
          ELSE
             LINE = BLANK
          ENDIF       
          IF (IOS.EQ.0 .AND. INDEX(LINE,'begin{range}').GT.0) THEN
C
C Try to read NPTS, XSTART, XEND
C            
             READ (NIN,*,IOSTAT=IOS) I 
             IF (IOS.EQ.0) THEN
                NPTS_1 = I
                READ(NIN,*,IOSTAT=IOS) X1
                IF (IOS.EQ.0) THEN
                   READ(NIN,*,IOSTAT=IOS) X2
                   IF (IOS.EQ.0) THEN
                      IF (X1.LE.X2) THEN
                         XSTART_1 = X1
                         XEND_1 = X2
                      ELSE   
                         XSTART_1 = X2
                         XEND_1 = X1
                      ENDIF  
                   ENDIF    
                ENDIF
             ENDIF
             IOS = 1      
          ENDIF          
       ENDDO 
       CLOSE (UNIT = NIN)
C
C Check
C         
      IF (NPTS_1.GE.NPTMIN .AND. XSTART_1.GE.ZERO 
     +                     .AND.   XEND_1.GT.XSTART_1) THEN
C
C Accept data from file
C     
         NPTS = NPTS_1
         XEND = XEND_1
         XSTART = XSTART_1
      ELSE
C
C Input data manually
C        
         IF (NPTS.LE.NPTMIN) THEN
           NPTS = NPTMIN
         ELSEIF (NPTS.GT.NPTMAX) THEN
           NPTS = NPTMAX
         ENDIF        
         CALL GETJM1 (NPTMIN, NPTS, NPTMAX,
     +               'Number of points required')
         IF (XSTART.LT.ZERO) XSTART = ZERO
         IF (XEND.LE.XSTART) XEND = XSTART + ONE
         CALL GETDG2 (XSTART, XEND,
     +               'Range of integration required')                        
      ENDIF
      END     
C
C----------------------------------------------------------------------
C
      SUBROUTINE DEQSWP
      USE MODULE_DEQSOL, ONLY : ISWAP, N, SWAPIT, NPTS, ASWAP, YVAL,
     +                          YSWAP 
C
C ACTION : Transform y(new) = ASWAP*y(old) if ISWAP = .TRUE.
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 9/10/95
C          The first dimension is the time dimension
C          The second dimension is the deqn. dimension
C
      IMPLICIT   NONE
      INTEGER    I, J, K
      DOUBLE PRECISION TEMP
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      IF (ISWAP) THEN
C
C Store the inner product in YSWAP
C
         DO I = 1, N
            IF (SWAPIT(I)) THEN
               DO J = 1, NPTS
                  TEMP = ZERO
                  DO K = 1, N
                     TEMP = TEMP + ASWAP(I,K)*YVAL(J,K)
                  ENDDO
                  YSWAP(J,I) = TEMP
               ENDDO
            ENDIF
         ENDDO
C
C Replace the YVAL by corresponding YSWAP
C
         DO I = 1, N
            IF (SWAPIT(I)) THEN
               DO J = 1, NPTS
                  YVAL(J,I) = YSWAP(J,I)
               ENDDO
            ENDIF
         ENDDO
      ENDIF
      END
C
C
