
C
C DEQSOL2.FOR
C ===========
C
C ACTION
C COMPAR
C DECIDE
C GRAPHS
C
C------------------------------------------------------------------------
C
      SUBROUTINE ACTION (IFAIL, IP, IRELAB, IW, M, METHOD, MODEL, MPED,
     +                   N, NIP, NMOD, NPMAX, NWORK, NYMAX,
     +                   CPU, P, TOL, W, XEND, XSTART, Y, YPREV, Y0,
     +                   TIMER, USER)
      USE MODULE_DEQSOL, ONLY : DTOL, 
     +                          RELABS,
     +                          USE_D02CJF, USE_D02EJF, USE_JACOBIAN
C
C Action: Initialise arguments then call to DVODE or D02
C Author: w.g.bardsley, university of manchester, u.k.
C         31/06/2005 Initialised T = 0 to force integration to always start from zero
C         18/01/2010 now can call NAG D02
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: IRELAB, IW, M, METHOD, MODEL,
     +                                    MPED, N, NIP, NMOD, NPMAX,
     +                                    NYMAX 
      INTEGER,          INTENT (INOUT) :: NWORK(NYMAX + 30)
      INTEGER,          INTENT (INOUT) :: IP(NIP)
      DOUBLE PRECISION, INTENT (IN)    :: P(NPMAX), TOL, XEND, XSTART,
     +                                    Y0(NYMAX)  
      DOUBLE PRECISION, INTENT (INOUT) :: W(IW), Y(NYMAX), YPREV(NYMAX)
      DOUBLE PRECISION, INTENT (OUT)   :: CPU
      LOGICAL,          INTENT (IN)    :: TIMER, USER
C
C locals
C      
      INTEGER    ITOL, ITASK, ISTATE, IOPT, MF, JSV, METH, MITER
      INTEGER    I, IFAIL, LIW, LRW
      DOUBLE PRECISION ATOL(2), RTOL(2), YNORM
      DOUBLE PRECISION EPSI, TOLMAX, TOLMIN, ZERO, ONE
      PARAMETER (EPSI = 1.0D-15, TOLMAX = 1.0D-01, TOLMIN = 1.0D-10,
     +           ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION T, TOUT
      DOUBLE PRECISION CLOCK2, TEMP, T1, T2
      CHARACTER  DEQERR(6)*100
      LOGICAL    ALIGN1
      EXTERNAL   CLOCK2
      EXTERNAL   PUTFAT
      EXTERNAL   DEQSWP
      EXTERNAL   DVODE
      EXTERNAL   D02SOL
      EXTERNAL   USEDEQ, USEJAC
      EXTERNAL   DEQF01, DEQJ01
      EXTERNAL   DEQF02, DEQJ02
      EXTERNAL   DEQF03, DEQJ03
      EXTERNAL   DEQF04, DEQJ04
      EXTERNAL   DEQF05, DEQJ05
      EXTERNAL   D02_USEDEQ, D02_USEJAC
      EXTERNAL   D02_DEQF01, D02_DEQJ01
      EXTERNAL   D02_DEQF02, D02_DEQJ02
      EXTERNAL   D02_DEQF03, D02_DEQJ03
      EXTERNAL   D02_DEQF04, D02_DEQJ04
      EXTERNAL   D02_DEQF05, D02_DEQJ05
      EXTERNAL   OUTPUT
      INTRINSIC  DBLE, SQRT, MAX
      DATA  DEQERR /
     +'FATAL: ISTATE = -1 from DVODE ... excess work, maybe wrong MF ?',
     +'FATAL: ISTATE = -2 from DVODE .. maybe TOL value is too small ?',
     +'FATAL: ISTATE = -3 from DVODE .. maybe illegal input detected ?',
     +'FATAL: ISTATE = -4 from DVODE .. repeated error test failures ?',
     +'FATAL: ISTATE = -5 from DVODE  no conv. check Jacobian/MF/TOL ?',
     +'FATAL: ISTATE = -6 from DVODE  error weight = 0, and ATOL = 0 ?'/
C
C Define IP (to communicate with the model if required)
C
      I = MODEL!to silence ftn95
      IP(1) = N
      IP(2) = NMOD
      IP(3) = NYMAX
      IP(4) = M
      IF (TIMER) THEN
         ALIGN1 = .TRUE.
         T1 = CLOCK2 (ALIGN1)
      ENDIF
      
      IF (USE_D02CJF .OR. USE_D02EJF) THEN
C
C Use the NAG solvers: define the initial conditions 
C
         T = ZERO
         IFAIL = 0
         DO I = 1, N
            Y(I) = Y0(I)
            YPREV(I) = Y(I)
         ENDDO
C
C The main loop to integrate using OUTPUT 
C
         IF (USER) THEN 
            CALL D02SOL (D02_USEDEQ, D02_USEJAC,
     +                   IFAIL, N,
     +                   DTOL, T, XEND, Y,
     +                   RELABS,
     +                   USE_D02CJF, USE_D02EJF, USE_JACOBIAN)            
         ELSEIF (N.EQ.1) THEN
            CALL D02SOL (D02_DEQF01, D02_DEQJ01,
     +                   IFAIL, N,
     +                   DTOL, T, XEND, Y,
     +                   RELABS,
     +                   USE_D02CJF, USE_D02EJF, USE_JACOBIAN)               
         ELSEIF (N.EQ.2) THEN
            CALL D02SOL (D02_DEQF02, D02_DEQJ02,
     +                   IFAIL, N,
     +                   DTOL, T, XEND, Y,
     +                   RELABS,
     +                   USE_D02CJF, USE_D02EJF, USE_JACOBIAN)                 
         ELSEIF (N.EQ.3) THEN
            CALL D02SOL (D02_DEQF03, D02_DEQJ03,
     +                   IFAIL, N,
     +                   DTOL, T, XEND, Y,
     +                   RELABS,
     +                   USE_D02CJF, USE_D02EJF, USE_JACOBIAN)             
         ELSEIF (N.EQ.4) THEN
            CALL D02SOL (D02_DEQF04, D02_DEQJ04,
     +                   IFAIL, N,
     +                   DTOL, T, XEND, Y,
     +                   RELABS,
     +                   USE_D02CJF, USE_D02EJF, USE_JACOBIAN)               
         ELSEIF (N.EQ.5) THEN
            CALL D02SOL (D02_DEQF05, D02_DEQJ05,
     +                   IFAIL, N,
     +                   DTOL, T, XEND, Y,
     +                   RELABS,
     +                   USE_D02CJF, USE_D02EJF, USE_JACOBIAN)             
         ELSE
            CALL PUTFAT ('Value of N out of range in ACTION')
         ENDIF
     
         IF (IFAIL.EQ.0) IFAIL = 2        

      ELSE       
        
C
C Use DVODE: Define the initial conditions and calculate T, TOUT
C
         YNORM = ZERO
         DO I = 1, N
            Y(I) = Y0(I)
            YNORM = YNORM + Y(I)**2
            YPREV(I) = Y(I)
         ENDDO
         YNORM = SQRT(YNORM/DBLE(N))
C
C Note: Initialise T = 0 so integration always starts from T = 0
C       In the iteration T gets replaced by TOUT
C
         T = ZERO
         TOUT = XSTART
C
C Set tolerances etc. ... this is a temporary compromise
C
         IF (TOL.LT.TOLMIN) THEN
            TEMP = TOLMIN
         ELSEIF (TOL.GT.TOLMAX) THEN
            TEMP = TOLMAX
         ELSE
            TEMP = TOL
         ENDIF
         IF (IRELAB.EQ.0) THEN
            ATOL(1) = EPSI*(MAX(ONE, YNORM))
            RTOL(1) = TEMP
         ELSEIF (IRELAB.EQ.1) THEN
            ATOL(1) = EPSI*(MAX(ONE, YNORM))
            RTOL(1) = ZERO
         ELSE
            ATOL(1) = ZERO
            RTOL(1) = TEMP
         ENDIF
         ATOL(2) = ATOL(1)
         RTOL(2) = RTOL(1)
C
C Parameters before the calculation starts
C
         IFAIL = 0
         ITOL = 1
         ITASK = 1
         ISTATE = 1
         IOPT = 0
         JSV = 1
         LRW = IW
         LIW = NYMAX + 30
C
C The method (Stiff/Jacobian = 21, Stiff-no-Jacobian = 22, Adams = 10)
C
         IF (METHOD.EQ.1) THEN
            METH = 2
            IF (MPED.EQ.1) THEN
               MITER = 1
            ELSE
               MITER = 2
            ENDIF
         ELSEIF (METHOD.EQ.2) THEN
            METH = 1
            MITER = 0
         ENDIF
         MF = JSV*(10*METH + MITER)
C
C The main loop to integrate using OUTPUT to set TOUT
C
         IF (USER) THEN
            DO WHILE (TOUT.LE.XEND)
               IF (ISTATE.GT.0) THEN
                  CALL DVODE (USEDEQ, N, Y, T, TOUT, ITOL, RTOL, ATOL,
     +                        ITASK, ISTATE, IOPT, W, LRW, NWORK, LIW,
     +                        USEJAC, MF, P, IP)
                  IF (ISTATE.GT.0) THEN
                     DO I = 1, N
                        YPREV(I) = Y(I)
                     ENDDO
                  ELSE
                     I = - ISTATE
                     WRITE (6,'(A)') DEQERR(I)
                     DO I = 1, N
                        Y(I) = YPREV(I)
                     ENDDO
                  ENDIF
               ELSE
                  DO I = 1, N
                     Y(I) = YPREV(I)
                  ENDDO
               ENDIF
               CALL OUTPUT (TOUT, Y)
            ENDDO
         ELSEIF (N.EQ.1) THEN
            DO WHILE (TOUT.LE.XEND)
               IF (ISTATE.GT.0) THEN
                  CALL DVODE (DEQF01, N, Y, T, TOUT, ITOL, RTOL, ATOL,
     +                        ITASK, ISTATE, IOPT, W, LRW, NWORK, LIW,
     +                        DEQJ01, MF, P, IP)
                  IF (ISTATE.GT.0) THEN
                     YPREV(1) = Y(1)
                  ELSE
                     I = - ISTATE
                     WRITE (6,'(A)') DEQERR(I)
                     Y(1) = YPREV(1)
                  ENDIF
               ELSE
                  Y(1) = YPREV(1)
               ENDIF
               CALL OUTPUT (TOUT, Y)
            ENDDO
         ELSEIF (N.EQ.2) THEN
            DO WHILE (TOUT.LE.XEND)
               IF (ISTATE.GT.0) THEN
                  CALL DVODE (DEQF02, N, Y, T, TOUT, ITOL, RTOL, ATOL,
     +                        ITASK, ISTATE, IOPT, W, LRW, NWORK, LIW,
     +                        DEQJ02, MF, P, IP)
                  IF (ISTATE.GT.0) THEN
                     YPREV(1) = Y(1)
                     YPREV(2) = Y(2)
                  ELSE
                     I = - ISTATE
                     WRITE (6,'(A)') DEQERR(I)
                     Y(1) = YPREV(1)
                     Y(2) = YPREV(2)
                  ENDIF
               ELSE
                  Y(1) = YPREV(1)
                  Y(2) = YPREV(2)
               ENDIF
               CALL OUTPUT (TOUT, Y)
            ENDDO
         ELSEIF (N.EQ.3) THEN
            DO WHILE (TOUT.LE.XEND)
               IF (ISTATE.GT.0) THEN
                  CALL DVODE (DEQF03, N, Y, T, TOUT, ITOL, RTOL, ATOL,
     +                        ITASK, ISTATE, IOPT, W, LRW, NWORK, LIW,
     +                        DEQJ03, MF, P, IP)
                  IF (ISTATE.GT.0) THEN
                     DO I = 1, 3
                        YPREV(I) = Y(I)
                     ENDDO
                  ELSE
                     I = - ISTATE
                     WRITE (6,'(A)') DEQERR(I)
                     DO I = 1, 3
                        Y(I) = YPREV(I)
                     ENDDO
                  ENDIF
               ELSE
                  DO I = 1, 3
                     Y(I) = YPREV(I)
                  ENDDO
               ENDIF
               CALL OUTPUT (TOUT, Y)
            ENDDO
         ELSEIF (N.EQ.4) THEN
            DO WHILE (TOUT.LE.XEND)
               IF (ISTATE.GT.0) THEN
                  CALL DVODE (DEQF04, N, Y, T, TOUT, ITOL, RTOL, ATOL,
     +                        ITASK, ISTATE, IOPT, W, LRW, NWORK, LIW,
     +                         DEQJ04, MF, P, IP)
                  IF (ISTATE.GT.0) THEN
                     DO I = 1, 4
                        YPREV(I) = Y(I)
                     ENDDO
                  ELSE
                     I = - ISTATE
                     WRITE (6,'(A)') DEQERR(I)
                     DO I = 1, 4
                        Y(I) = YPREV(I)
                     ENDDO
                  ENDIF
               ELSE
                  DO I = 1, 4
                     Y(I) = YPREV(I)
                  ENDDO
               ENDIF
               CALL OUTPUT (TOUT, Y)
            ENDDO
         ELSEIF (N.EQ.5) THEN
            DO WHILE (TOUT.LE.XEND)
               IF (ISTATE.GT.0) THEN
                  CALL DVODE (DEQF05, N, Y, T, TOUT, ITOL, RTOL, ATOL,
     +                        ITASK, ISTATE, IOPT, W, LRW, NWORK, LIW,
     +                        DEQJ05, MF, P, IP)
                  IF (ISTATE.GT.0) THEN
                     DO I = 1, 5
                        YPREV(I) = Y(I)
                     ENDDO
                  ELSE
                     I = - ISTATE
                     WRITE (6,'(A)') DEQERR(I)
                     DO I = 1, 5
                        Y(I) = YPREV(I)
                     ENDDO
                  ENDIF
               ELSE
                  DO I = 1, 5
                     Y(I) = YPREV(I)
                  ENDDO
               ENDIF
               CALL OUTPUT (TOUT, Y)
            ENDDO
         ELSE
            CALL PUTFAT ('Value of N out of range in ACTION')
         ENDIF
C
C Finally set IFAIL
C
         IFAIL = ISTATE
  
      ENDIF
      
      IF (TIMER) THEN
         ALIGN1 = .FALSE.
         T2 = CLOCK2 (ALIGN1)
         CPU = T2 - T1
      ENDIF
C
C Now transform the solution y(new) = ASWAP*y(old)
C
      CALL DEQSWP

      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE COMPAR (IWANT, NPTS, NTMAX, NUMY, NYMAX, TX, YCOM,
     +                   YVAL, Y1, Y2, Y3, Y4, Y5, Y6, Y7, Y8, Y9, Y10,
     +                   Y11, Y12)
C
C Action: Compare solutions
C Author: w.g.bardsley, university of manchester, u.k.
C         currently disabled and requires revision
C
      IMPLICIT   NONE
      INTEGER    NPTS, NTMAX, NUMY, NYMAX
      INTEGER    IWANT(12)
      INTEGER    I
      INTEGER    L1, L2, L3, L4, L5, L6, L7, L8, L9, L10, L11, L12,
     +           M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12,
     +           N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12
      INTEGER    ICOLOR, IX, IY, NUMDEC, NUMOPT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, NUMOPT = 3)
      INTEGER    NUMPOS(NUMOPT)
      DOUBLE PRECISION TX(NTMAX), YCOM(NTMAX,NYMAX), YVAL(NTMAX,NYMAX),
     +                 Y1(NTMAX), Y2(NTMAX), Y3(NTMAX), Y4(NTMAX),
     +                 Y5(NTMAX), Y6(NTMAX), Y7(NTMAX), Y8(NTMAX),
     +                 Y9(NTMAX), Y10(NTMAX), Y11(NTMAX), Y12(NTMAX)
      CHARACTER  TEXT(30)*100
      LOGICAL    SAVEIT
      PARAMETER (SAVEIT = .TRUE.)
      EXTERNAL TABPRN
      EXTERNAL GKS004, LBOX02, GKS012
      DATA       NUMPOS / NUMOPT*1 /
   20 CONTINUE
      WRITE (TEXT,100)
      NUMDEC = NUMOPT
      CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS,
     +             TEXT)
      IF (NUMDEC.EQ.1) THEN
         CALL TABPRN (IWANT, NPTS, NTMAX, NUMY, NYMAX, 
     +                TX, YCOM)
         GOTO 20
      ELSEIF (NUMDEC.EQ.2) THEN
         L1 = 1
         L2 = 2
         L3 = 0
         L4 = 0
         L5 = 0
         L6 = 0
         L7 = 0
         L8 = 0
         L9 = 0
         L10 = 0
         L11 = 0
         L12 = 0
         M1 = 0
         M2 = 0
         M3 = 0
         M4 = 0
         M5 = 0
         M6 = 0
         M7 = 0
         M8 = 0
         M9 = 0
         M10 = 0
         M11 = 0
         M12 = 0
         N1 = NPTS
         N2 = NPTS
         N3 = 1
         N4 = 1
         N5 = 1
         N6 = 1
         N7 = 1
         N8 = 1
         N9 = 1
         N10 = 1
         N11 = 1
         N12 = 1
         DO I = 1, NPTS
            Y1(I) = YVAL(I,IWANT(1))
            Y2(I) = YCOM(I,IWANT(1))
         ENDDO
         IF (NUMY.GT.1) THEN
            DO I = 1, NPTS
               Y3(I) = YVAL(I,IWANT(2))
               Y4(I) = YCOM(I,IWANT(2))
            ENDDO
            L3 = 3
            L4 = 4
            N3 = NPTS
            N4 = NPTS
         ENDIF
         IF (NUMY.GT.2) THEN
            DO I = 1, NPTS
               Y5(I) = YVAL(I,IWANT(3))
               Y6(I) = YCOM(I,IWANT(3))
            ENDDO
            L5 = 1
            L6 = 2
            N5 = NPTS
            N6 = NPTS
         ENDIF
         IF (NUMY.GT.3) THEN
            DO I = 1, NPTS
               Y7(I) = YVAL(I,IWANT(4))
               Y8(I) = YCOM(I,IWANT(4))
            ENDDO
            L7 = 3
            L8 = 4
            N7 = NPTS
            N8 = NPTS
         ENDIF
         IF (NUMY.GT.4) THEN
            DO I = 1, NPTS
               Y9(I) = YVAL(I,IWANT(5))
               Y10(I) = YCOM(I,IWANT(5))
            ENDDO
            L9 = 1
            L10 = 2
            N9 = NPTS
            N10 = NPTS
         ENDIF
         IF (NUMY.GT.5) THEN
            DO I = 1, NPTS
               Y11(I) = YVAL(I,IWANT(6))
               Y12(I) = YCOM(I,IWANT(6))
            ENDDO
            L11 = 3
            L12 = 4
            N11 = NPTS
            N12 = NPTS
         ENDIF
         IF (NUMY.LE.2) THEN
            CALL GKS004 (L1, L2, L3, L4, M1, M2, M3, M4, N1, N2, N3, N4,
     +                   TX, TX, TX, TX, Y1, Y2, Y3, Y4,
     +                   'Solutions', 'Time', 'Y values',
     +                   SAVEIT, SAVEIT)
         ELSEIF (NUMY.LE.6) THEN
            CALL GKS012 (L1, L2, L3, L4, L5, L6, L7, L8, L9, L10, L11,
     +                   L12,
     +                   M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11,
     +                   M12,
     +                   N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11,
     +                   N12,
     +                   TX, TX, TX, TX, TX, TX, TX, TX, TX, TX, TX, TX,
     +                   Y1, Y2, Y3, Y4, Y5, Y6, Y7, Y8, Y9, Y10, Y11,
     +                   Y12,
     +                   'Solutions', 'Time', 'Y values',
     +                   SAVEIT, SAVEIT)
         ENDIF
         GOTO 20
      ENDIF
  100 FORMAT (
     + 'Table'
     +/'Graph'
     +/'Cancel')
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE DECIDE (IFIT, NCYCLE, NDEC, NOUT, 
     +                   NPTS, NRAND, NUMPI, NUMY0,
     +                   CPU, XEND, XSTART, 
     +                   HEADER, OTYPE,
     +                   COVAR, ISWAP, RANPAR, RANY0, READY)
C
C ACTION: Decide action required
C AUTHOR: W.G.Bardsley, University of Manchester, U.K.
C         01/01/2000 revised menus for random curve fitting options
C         18/01/2010 extensive revision 
C         08/04/2021 improved the secondary menu (i.e. format 300)
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NOUT, NPTS, NUMPI, NUMY0
      INTEGER,             INTENT (INOUT) :: IFIT, NCYCLE, NDEC, NRAND
      DOUBLE PRECISION,    INTENT (IN)    :: CPU, XSTART, XEND
      CHARACTER (LEN = *), INTENT (IN)    :: HEADER(4), OTYPE
      LOGICAL,             INTENT (IN)    :: ISWAP, READY
      LOGICAL,             INTENT (INOUT) :: COVAR, RANPAR, RANY0
C
C Locals
C      
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMOPT, NUMOPT1, NSTART,
     +           NSTART1, NTEXT, NTEXT1
      PARAMETER (IXL = 20, IYL = 4, LSHADE = 1,
     +           NSTART = 12, NSTART1 = 9, NUMOPT = 17, NUMOPT1 = 11,
     +           NTEXT = NSTART + NUMOPT - 1,
     +           NTEXT1 = NSTART1 + NUMOPT1 - 1)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      INTEGER    I, J
      INTEGER    N0, N1, N2, N4, N7, NBOT, NTOP
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N4 = 4, N7 = 7, NBOT = 2,
     +           NTOP = 50)
      CHARACTER (LEN = 13) D13(3), SHOWLJ
      CHARACTER (LEN = 12) I12(3), FORM12
      CHARACTER  SYMBOL*11
      CHARACTER  MESSAGE*41
      CHARACTER  TEXT(NTEXT)*100, TEXT1(NTEXT1)*100
      CHARACTER  WORD9(10)*9
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ABORT, AGAIN, FIRST
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., HIGH = .TRUE.)
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   ADVISE
      EXTERNAL   PUTFAT, LBOX01, TRIML1, GETJM1, PUTADV, REVPRO
      INTRINSIC  INDEX, TRIM
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Initialise
C
      E_NUMBERS = E_FORMATS()
      IF (ISWAP) THEN
         ICOLOR = 1
      ELSE
         ICOLOR = 3
      ENDIF

      IF (ISWAP) THEN
         MESSAGE = 'y is being transformed: y(new) = A*y(old)'
      ELSE
         MESSAGE = 'y is not transformed: A = identity matrix'
      ENDIF
      IF (READY) THEN
         SYMBOL = ' (finished)'
         FLASH = .FALSE.
         IF (E_NUMBERS) THEN
            WRITE (TEXT,100) OTYPE, NPTS, XSTART, XEND, MESSAGE, NUMPI,
     +                       NUMY0, CPU, SYMBOL
         ELSE
            I12(1) = FORM12(NPTS)
            D13(1) = SHOWLJ(XSTART)
            D13(2) = SHOWLJ(XEND)
            I12(2) = FORM12(NUMPI)
            I12(3) = FORM12(NUMY0)
            D13(3) = SHOWLJ(CPU)
            WRITE (TEXT,150) OTYPE, TRIM(I12(1)), TRIM(D13(1)), 
     +                       TRIM(D13(2)), MESSAGE, TRIM(I12(2)),
     +                       TRIM(I12(3)), TRIM(D13(3)), SYMBOL  
         ENDIF  
      ELSE
         SYMBOL = ' **** next '
         FLASH = .TRUE.
         IF (E_NUMBERS) THEN
            WRITE (TEXT,200) OTYPE, NPTS, XSTART, XEND, MESSAGE, NUMPI,
     +                       NUMY0, SYMBOL
         ELSE
            I12(1) = FORM12(NPTS)
            D13(1) = SHOWLJ(XSTART)
            D13(2) = SHOWLJ(XEND)
            I12(2) = FORM12(NUMPI)
            I12(3) = FORM12(NUMY0)   
            WRITE (TEXT,250) OTYPE, TRIM(I12(1)), TRIM(D13(1)),
     +                       TRIM(D13(2)), MESSAGE, TRIM(I12(2)),
     +                       TRIM(I12(3)), SYMBOL
         ENDIF  
      ENDIF
C
C Adjust TEXT using HEADER
C      
      DO I = N1, N4
         TEXT(N2 + I) = HEADER(I)
      ENDDO 
      IF (INDEX(HEADER(N4),'LBFGSB').LE.N0) TEXT(N7) = BLANK  
C
C LABEL 20: Main branch point ... IFIT = 1, 2, 3 indicates curve fitting
C =========
C
   20 CONTINUE
      IF (.NOT.READY .OR. IFIT.LT.1 .OR. IFIT.GT.3) THEN
         NUMBLD(1) = 1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
      ELSE
         NDEC = 13
      ENDIF
      IF (READY) THEN
         IF (NDEC.EQ.7) THEN
            CALL PUTADV ('Integration already completed')
            GOTO 20
         ENDIF
      ELSE
         IF (NDEC.GE.8 .AND. NDEC.LE.11) THEN
            CALL PUTFAT ('You have not yet integrated')
            NDEC = 7
            GOTO 20
         ENDIF
      ENDIF
C
C NDEC = 13 indicates a curve fitting option, i.e. IFIT = 1, 2, 3
C
      IF (NDEC.EQ.13) THEN
         AGAIN = .TRUE.
         DO WHILE (AGAIN)
            IF (COVAR) THEN
               WORD9(1) = '[Yes]'
            ELSE
               WORD9(1) = '[No]'
            ENDIF
            WRITE (WORD9(2),'(I9)') NCYCLE
            CALL TRIML1 (WORD9(2))
            J = LEN_TRIM(WORD9(2))
            WORD9(2) = '['//WORD9(2)(1:J)//']'
            IF (RANPAR) THEN
               WORD9(3) = '[Yes]'
            ELSE
               WORD9(3) = '[No]'
            ENDIF
            IF (RANY0) THEN
               WORD9(4) = '[Yes]'
            ELSE
               WORD9(4) = '[No]'
            ENDIF
            IF (NRAND.EQ.1) THEN
               WORD9(5) = '[Normal]'
            ELSEIF (NRAND.EQ.2) THEN
               WORD9(5) = '[Uniform]'
            ENDIF
            DO I = 6, 10
               WORD9(I) = WORD9(I - 5)
            ENDDO
            WRITE (TEXT1,300) (WORD9(I), I = 1, 10)
            IFIT = 10
            NUMBLD(1) = 1
            CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, IFIT,
     +                   NUMOPT1, NUMPOS, NSTART1, NTEXT1,
     +                   TEXT1,
     +                   BORDER, FLASH, HIGH)
            NUMBLD(1) = 0
            IF (IFIT.EQ.1) THEN
               AGAIN = .FALSE.
            ELSEIF (IFIT.EQ.2) THEN
               AGAIN = .FALSE.
            ELSEIF (IFIT.EQ.3) THEN
               IF (.NOT.READY) THEN
                  CALL PUTFAT ('You have not yet integrated')
                  IFIT = NUMOPT1
                  NDEC = 7
                  AGAIN = .FALSE.
               ELSE
                  AGAIN = .FALSE.
               ENDIF
            ELSEIF (IFIT.EQ.4) THEN
               COVAR = .NOT.COVAR
               IF (COVAR) THEN
                  CALL PUTADV (
     +            'Variance /Covariance matrix will be calculated')
                ELSE
                   CALL PUTADV (
     +            'Variance/Covariance matrix will not be calculated')
               ENDIF                    
            ELSEIF (IFIT.EQ.5) THEN
               CALL GETJM1 (NBOT, NCYCLE, NTOP,
     +        'Number of random cycles required')
            ELSEIF (IFIT.EQ.6) THEN
              RANPAR = .NOT.RANPAR
              IF (RANPAR) THEN
                 CALL PUTADV ('Parameters will be randomised')
              ELSE   
                 CALL PUTADV ('Parameters will not be randomised')
              ENDIF   
            ELSEIF (IFIT.EQ.7) THEN
               RANY0 = .NOT.RANY0
               IF (RANY0) THEN
                 CALL PUTADV (
     +           'Initial conditions will be randomised')
              ELSE   
                 CALL PUTADV (
     +           'Initial conditions will not be randomised')
              ENDIF   
            ELSEIF (IFIT.EQ.8) THEN
               IF (NRAND.EQ.1) THEN
                  NRAND = 2
               ELSEIF (NRAND.EQ.2) THEN
                  NRAND = 1
               ENDIF
               IF (NRAND.EQ.1) THEN
                  CALL PUTADV ('A normal distribution will be used')
               ELSE   
                  CALL PUTADV ('A uniform distribution will be used')
               ENDIF   
            ELSEIF (IFIT.EQ.9) THEN
               CALL REVPRO (NOUT)   
            ELSEIF (IFIT.EQ.10) THEN
               FIRST = .FALSE.
               CALL ADVISE (IXL, IYL, LSHADE,
     +                      BLANK,
     +                      ABORT, FIRST)
            ELSEIF (IFIT.EQ.NUMOPT1) THEN
              AGAIN = .FALSE.
            ENDIF
         ENDDO
         IF (IFIT.EQ.NUMOPT1) GOTO 20
      ELSEIF (NDEC.EQ.15) THEN
         CALL REVPRO (NOUT) 
         GOTO 20    
      ELSEIF (NDEC.EQ.16) THEN
         FIRST = .FALSE.
         CALL ADVISE (IXL, IYL, LSHADE,
     +                BLANK,
     +                ABORT, FIRST)
         GOTO 20
      ELSEIF (NDEC.EQ.17) THEN
         NDEC = 15
         RETURN
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     + 'DEQSOL main options'
     +/
     +/
     +/
     +/
     +/
     +/'LBFGSB optimiser precision = ',A
     +/'NPTS: No. of x_points for plotting =',I5
     +/'x_start =',1P,E11.3,', x_stop =',E11.3
     +/A
     +/
     +/'Display current equations'
     +/'Configure numerical methods'
     +/'Edit the',I4,' p(i) and limits'
     +/'Edit the',I4,' y0(i) and limits'
     +/'Input a configure/initialise file'
     +/'Change range: x_start, x_stop, NPTS'
     +/'cpu time:',E10.3,' (sec) ',A
     +/'Plot selected y(i)'
     +/'Table for selected y(i)'
     +/'File selected y(i)'
     +/'Compare selected y(i)'
     +/'Select y(i) for Plot/Table/File/Compare'
     +/'Curve fitting'
     +/'New equations'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit program DEQSOL')
  150 FORMAT (
     + 'DEQSOL main options'
     +/
     +/
     +/
     +/
     +/
     +/'LBFGSB optimiser precision = ',A
     +/'NPTS: Number of x_points for plotting =',1X,A
     +/'x_start =',1X,A,', x_stop =',1X,A
     +/A
     +/
     +/'Display current equations'
     +/'Configure numerical methods'
     +/'Edit the',1X,A,1X,'p(i) and limits'
     +/'Edit the',1X,A,1X,'y0(i) and limits'
     +/'Input a configure/initialise file'
     +/'Change range: x_start, x_stop, NPTS'
     +/'cpu time:',1X,A,' (sec) ',A
     +/'Plot selected y(i)'
     +/'Table for selected y(i)'
     +/'File selected y(i)'
     +/'Compare selected y(i)'
     +/'Select y(i) for Plot/Table/File/Compare'
     +/'Curve fitting'
     +/'New equations'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit program DEQSOL')     
  200 FORMAT (
     + 'DEQSOL main options'
     +/
     +/
     +/
     +/
     +/
     +/'LBFGSB optimiser precision = ',A
     +/'NPTS: Number of x_points for plotting =',I5
     +/'x_start =',1P,E11.3,', x_stop =',E11.3
     +/A
     +/
     +/'Display current equations'
     +/'Configure numerical methods'
     +/'Edit the',I4,' p(i) and limits'
     +/'Edit the',I4,' y0(i) and limits'
     +/'Input a configure/initialise file'
     +/'Change range: x_start, x_stop, NPTS'
     +/'Integrate',A
     +/'... [NA]'
     +/'... [NA]'
     +/'... [NA]'
     +/'... [NA]'
     +/'Select y(i) for Plot/Table/Compare'
     +/'Curve fitting'
     +/'New equations'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit program DEQSOL')
  250 FORMAT (
     + 'DEQSOL main options'
     +/
     +/
     +/
     +/
     +/
     +/'LBFGSB optimiser precision = ',A
     +/'NPTS: Number of x_points for plotting =',1X,A
     +/'x_start =',1X,A,', x_stop =',1X,A
     +/A
     +/
     +/'Display current equations'
     +/'Configure numerical methods'
     +/'Edit the',1X,A,' p(i) and limits'
     +/'Edit the',1X,A,' y0(i) and limits'
     +/'Input a configure/initialise file'
     +/'Change range: x_start, x_stop, NPTS'
     +/'Integrate',A
     +/'... [NA]'
     +/'... [NA]'
     +/'... [NA]'
     +/'... [NA]'
     +/'Select y(i) for Plot/Table/Compare'
     +/'Curve fitting'
     +/'New equations'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit program DEQSOL')     
  300 FORMAT (
     + 'DEQSOL curve fitting options'
     +/
     +/'Estimate Variance/Covariance matrix:',2X,A
     +/'Number of random cycles:',2X,A
     +/'Randomise model parameters p(i) then fit:',2X,A
     +/'Randomise initial conditions y_0(i) then fit:',2X,A
     +/'Current random distribution:',2X,A
     +/
     +/'Input new data for curve fitting'
     +/'Proceed to curve fitting'
     +/'Overlay current model on data'
     +/'Estimate the Variance/Covariance matrix:',2X,A
     +/'Randomise...Change the number of cycles:',2X,A
     +/'Randomise...Parameters p(i):',2X,A
     +/'Randomise...Initial conditions y0(i)):',2X,A
     +/'Randomise...Change the distribution:',2X,A
     +/'Results'
     +/'Help'
     +/'Cancel')
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GRAPHS (IP, IWANT, N, NIP, NORBIT, NPMAX, NPTS, NTMAX,
     +                   NUMY, NYMAX,
     +                   P, TX,
     +                   X1, X2, X3, X4, X5, X6, X7, X8, X9, X10, X11,
     +                   X12,
     +                   YVAL, Y1, Y2, Y3, Y4, Y5, Y6, Y7, Y8,
     +                   Y9, Y10, Y11, Y12,
     +                   ORBITF, ORBITT,
     +                   ORBITR, USER)
C
C ACTION : Plot chosen values as functions of time
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          07/03/98 Revised to save orbits and plot portraits
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: N, NIP, NORBIT, NPMAX, 
     +                                       NTMAX, NUMY, NYMAX
      INTEGER,             INTENT (IN)    :: NPTS 
      INTEGER,             INTENT (IN)    :: IP(NIP), IWANT(12)
      DOUBLE PRECISION,    INTENT (IN)    :: P(NPMAX)
      DOUBLE PRECISION,    INTENT (INOUT) :: TX(NTMAX),
     +           X1(NTMAX), X2(NTMAX),
     +           X3(NTMAX), X4(NTMAX), X5(NTMAX), X6(NTMAX), X7(NTMAX),
     +           X8(NTMAX), X9(NTMAX), X10(NTMAX), X11(NTMAX),
     +           X12(NTMAX),
     +           YVAL(NTMAX,NYMAX), Y1(NTMAX), Y2(NTMAX),
     +           Y3(NTMAX), Y4(NTMAX), Y5(NTMAX), Y6(NTMAX), Y7(NTMAX),
     +           Y8(NTMAX), Y9(NTMAX), Y10(NTMAX), Y11(NTMAX),
     +           Y12(NTMAX)
      CHARACTER (LEN = *), INTENT (IN)    :: ORBITF(NORBIT)
      CHARACTER (LEN = *), INTENT (INOUT) :: ORBITT(NORBIT)      
      LOGICAL,             INTENT (IN)    :: USER
      LOGICAL,             INTENT (INOUT) :: ORBITR(NORBIT) 
C
C Locals
C      
      INTEGER    I, J,
     +L1, L2, L3, L4, L5, L6, L7, L8, L9, L10, L11, L12,
     +M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12,
     +N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12
      INTEGER    JCOLOR, NUMDEC, NUMOPT, NUMSTA, NUMTXT
      PARAMETER (JCOLOR = 9, NUMOPT = 7, NUMSTA = 8)
      INTEGER    NUMBLD(30)
      CHARACTER  TEXT(30)*100
      CHARACTER  PLABEL*46, XLABEL*8, YLABEL*8
      LOGICAL    FRAME, SAVEIT, UPDOWN
      PARAMETER (FRAME = .FALSE., SAVEIT = .TRUE., UPDOWN = .FALSE.)
      LOGICAL    AGAIN, NEXT, ORBITS, PHASE, PLOT, PTRAIT, STORE_ORBITS
      EXTERNAL   GKS004, PUTFAT, GETIM1, PUTADV, GKS012, LSTBOX, TUTORS
      EXTERNAL   PLTORB, PORTRT
      DATA       NUMBLD / 30*0 /
      IF (N.LT.1) RETURN
      NUMDEC = 1
C
C Main branch point for repeat operations
C
   20 CONTINUE
      AGAIN = .TRUE.
      ORBITS = .FALSE.
      PHASE = .FALSE.
      PLOT = .FALSE.
      PTRAIT = .FALSE.
      STORE_ORBITS = .FALSE.
      NUMTXT = NUMSTA + NUMOPT - 1
      WRITE (TEXT,100)
      NUMBLD(1) = 4
      CALL LSTBOX (NUMBLD, NUMDEC, NUMOPT, NUMSTA, NUMTXT,
     +             TEXT)
      NUMBLD(1) = 0
      IF (NUMDEC.EQ.1) THEN
C
C Plot
C
         IF (NUMY.LT.1) THEN
            CALL PUTADV ('No components are currently selected')
         ELSE
            PLOT = .TRUE.
         ENDIF
      ELSEIF (NUMDEC.EQ.2) THEN
C
C Phase
C
         IF (N.GT.1 .AND. NUMY.GT.1) THEN
            PHASE = .TRUE.
         ELSE
            CALL PUTADV ('Phase plane requires at least 2 equations')
         ENDIF
      ELSEIF (NUMDEC.EQ.3) THEN
C
C Store orbits
C         
         IF (N.GT.1 .AND. NUMY.GT.1) THEN
            STORE_ORBITS = .TRUE.
         ELSE
            CALL PUTADV ('Orbits require at least 2 equations')
         ENDIF
      ELSEIF (NUMDEC.EQ.4) THEN
C
C Orbits
C
         ORBITS = .TRUE.
      ELSEIF (NUMDEC.EQ.5) THEN
C
C Portrait
C
         IF (N.EQ.2 .AND. NUMY.EQ.2) THEN
            PTRAIT = .TRUE.
         ELSE
            CALL PUTADV ('Only possible with two autonomous equations')
         ENDIF
      ELSEIF (NUMDEC.EQ.6) THEN
C
C Help
C
         WRITE (TEXT,700)
         NUMTXT = 21
         NUMBLD(1) = 4
         NUMBLD(7) = 1
         NUMBLD(14) = 1
         NUMBLD(18) = 1
         CALL TUTORS (JCOLOR, NUMBLD, NUMTXT,
     +                TEXT,
     +                FRAME, NEXT, UPDOWN)
         NUMBLD(1) = 0
         NUMBLD(7) = 0
         NUMBLD(14) = 0
         NUMBLD(18) = 0
      ELSEIF (NUMDEC.EQ.7) THEN
C
C End
C
         AGAIN = .FALSE.
      ENDIF
C
C Set NUMDEC = NUMOPT so menu ready for return
C
      NUMDEC = NUMOPT
      IF (PLOT) THEN
C
C Plot selected components
C
         IF (NUMY.LT.1) THEN
            CALL PUTADV ('No components selected')
            GOTO 20
         ENDIF
         L2 = 0
         L3 = 0
         L4 = 0
         L5 = 0
         L6 = 0
         L7 = 0
         L8 = 0
         L9 = 0
         L10 = 0
         L11 = 0
         L12 = 0
         M1 = 0
         M2 = 0
         M3 = 0
         M4 = 0
         M5 = 0
         M6 = 0
         M7 = 0
         M8 = 0
         M9 = 0
         M10 = 0
         M11 = 0
         M12 = 0
         N2 = 1
         N3 = 1
         N4 = 1
         N5 = 1
         N6 = 1
         N7 = 1
         N8 = 1
         N9 = 1
         N10 = 1
         N11 = 1
         N12 = 1
         J = IWANT(1)
         L1 = 1
         N1 = NPTS
         DO I = 1, N1
            Y1(I) = YVAL(I,J)
         ENDDO
         IF (NUMY.GT.1) THEN
            J = IWANT(2)
            L2 = 2
            N2 = NPTS
            DO I = 1, N2
               Y2(I) = YVAL(I,J)
            ENDDO
         ENDIF
         IF (NUMY.GT.2) THEN
            J = IWANT(3)
            L3 = 3
            N3 = NPTS
            DO I = 1, N3
               Y3(I) = YVAL(I,J)
            ENDDO
         ENDIF
         IF (NUMY.GT.3) THEN
            J = IWANT(4)
            L4 = 4
            N4 = NPTS
            DO I = 1, N4
               Y4(I) = YVAL(I,J)
            ENDDO
         ENDIF
         IF (NUMY.GT.4) THEN
            J = IWANT(5)
            L5 = 1
            N5 = NPTS
            DO I = 1, N5
               Y5(I) = YVAL(I,J)
            ENDDO
         ENDIF
         IF (NUMY.GT.5) THEN
            J = IWANT(6)
            L6 = 2
            N6 = NPTS
            DO I = 1, N6
               Y6(I) = YVAL(I,J)
            ENDDO
         ENDIF
         IF (NUMY.GT.6) THEN
            J = IWANT(7)
            L7 = 3
            N7 = NPTS
            DO I = 1, N7
               Y7(I) = YVAL(I,J)
            ENDDO
         ENDIF
         IF (NUMY.GT.7) THEN
            J = IWANT(8)
            L8 = 4
            N8 = NPTS
            DO I = 1, N8
               Y8(I) = YVAL(I,J)
            ENDDO
         ENDIF
         IF (NUMY.GT.8) THEN
            J = IWANT(9)
            L9 = 1
            N9 = NPTS
            DO I = 1, N9
               Y9(I) = YVAL(I,J)
            ENDDO
         ENDIF
         IF (NUMY.GT.9) THEN
            J = IWANT(10)
            L10 = 2
            N10 = NPTS
            DO I = 1, N10
               Y10(I) = YVAL(I,J)
            ENDDO
         ENDIF
         IF (NUMY.GT.10) THEN
            J = IWANT(11)
            L11 = 3
            N11 = NPTS
            DO I = 1, N11
               Y11(I) = YVAL(I,J)
            ENDDO
         ENDIF
         IF (NUMY.GT.11) THEN
            J = IWANT(12)
            L12 = 4
            N12 = NPTS
            DO I = 1, N12
               Y12(I) = YVAL(I,J)
            ENDDO
         ENDIF
         IF (NUMY.EQ.1) THEN
            WRITE (PLABEL,201) IWANT(1)
         ELSEIF (NUMY.EQ.2) THEN
            WRITE (PLABEL,202) IWANT(1), IWANT(2)
         ELSEIF (NUMY.EQ.3) THEN
            WRITE (PLABEL,203) IWANT(1), IWANT(2), IWANT(3)
         ELSEIF (NUMY.EQ.4) THEN
            WRITE (PLABEL,204) IWANT(1), IWANT(2), IWANT(3), IWANT(4)
         ENDIF
         IF (NUMY.LE.4) THEN
            CALL GKS004 (L1, L2, L3, L4, M1, M2, M3, M4, N1, N2, N3, N4,
     +                   TX, TX, TX, TX, Y1, Y2, Y3, Y4,
     +                   PLABEL, 'X-value', 'Y-values', 
     +                   SAVEIT, SAVEIT)
         ELSE
            CALL GKS012 (
     +      L1, L2, L3, L4, L5, L6, L7, L8, L9, L10, L11, L12,
     +      M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12,
     +      N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12,
     +      TX, TX, TX, TX, TX, TX, TX, TX, TX, TX,  TX,  TX,
     +      Y1, Y2, Y3, Y4, Y5, Y6, Y7, Y8, Y9, Y10, Y11, Y12,
     +      'Components y(i)', 'X-value', 'Y-values', 
     +      SAVEIT, SAVEIT)
         ENDIF
      ELSEIF (PHASE) THEN
C
C Plot the phase plane
C
         IF (N.GT.2) THEN
            L1 = 0
            N1 = N
            CALL GETIM1 (L1, M1, N1,
     +   'Index for y-component in phase plane (0 for no phase plane)')
         ELSE
            M1 = 1
         ENDIF
         IF (M1.LT.1) THEN
             GOTO 20
         ELSEIF (M1.LT.10) THEN
            WRITE (YLABEL,300) M1
         ELSEIF (M1.LT.100) THEN
            WRITE (YLABEL,400) M1
         ELSEIF (M1.LT.1000) THEN
            WRITE (YLABEL,500) M1
         ELSE
            WRITE (YLABEL,600) M1
         ENDIF
         IF (N.GT.2) THEN
            L2 = 0
            N2 = N
            CALL GETIM1 (L2, M2, N2,
     +   'Index for x-component in phase plane (0 for no phase plane)')
         ELSE
            M2 = 2
         ENDIF
         IF (M2.LT.1) THEN
            GOTO 20
         ELSEIF (M2.LT.10) THEN
            WRITE (XLABEL,300) M2
         ELSEIF (M2.LT.100) THEN
            WRITE (XLABEL,400) M2
         ELSE
            WRITE (XLABEL,500) M2
         ENDIF
         IF (M1.EQ.M2) THEN
            CALL PUTFAT ('No portrait for y(i) against y(j) when i = j')
            GOTO 20
         ENDIF
         DO I = 1, NPTS
            Y1(I) = YVAL(I, M1)
            Y2(I) = YVAL(I, M2)
         ENDDO
         L1 = 5
         L2 = 0
         L3 = 0
         L4 = 0
         M1 = 0
         M2 = 0
         M3 = 0
         M4 = 0
         N1 = NPTS
         N2 = 0
         N3 = 0
         N4 = 0
         CALL GKS004 (L1, L2, L3, L4,
     +                M1, M2, M3, M4,
     +                N1, N2, N3, N4,
     +                Y2, Y2, Y2, Y2,
     +                Y1, Y1, Y1, Y1,
     +                'Phase plane', XLABEL, YLABEL,
     +                SAVEIT, SAVEIT)
      ELSEIF (STORE_ORBITS) THEN
C
C Store orbits
C
         M1 = 0
         M2 = 0
         IF (N.GT.2) THEN
            L1 = 0
            N1 = N
            CALL GETIM1 (L1, M1, N1,
     +   'Index for y-component orbit to store (0 for no storage)')
         ELSE
            M1 = 1
         ENDIF 
         IF (M1.GT.0 .AND. N.GT.2) THEN
            L2 = 0
            N2 = N
            CALL GETIM1 (L2, M2, N2,
     +   'Index for x-component orbit to store (0 for no storage)')
         ELSE
            M2 = 2
         ENDIF 
         IF (M1.GT.0 .AND. M2.GT.0) THEN
            IF (M1.EQ.M2) THEN
               CALL PUTFAT ('No orbits for y(i) and y(j) when i = j')
               GOTO 20
            ENDIF 
            DO I = 1, NPTS
               Y1(I) = YVAL(I, M1)
               Y2(I) = YVAL(I, M2)
            ENDDO
            I = 1
            CALL PLTORB (I, NORBIT, NPTS, NTMAX,
     +                   X1, X2, X3, X4, X5, X6, X7, X8, X9, X10, X11,
     +                   X12,
     +                   Y1, Y2, Y3, Y4, Y5, Y6, Y7, Y8, Y9, Y10, Y11,
     +                   Y12,
     +                   ORBITF, ORBITT,
     +                   ORBITR)
         ENDIF 
      ELSEIF (ORBITS) THEN
C
C Orbits
C
         I = 2
         CALL PLTORB (I, NORBIT, NPTS, NTMAX,
     +                X1, X2, X3, X4, X5, X6, X7, X8, X9, X10, X11, X12,
     +                Y1, Y2, Y3, Y4, Y5, Y6, Y7, Y8, Y9, Y10, Y11, Y12,
     +                ORBITF, ORBITT,
     +                ORBITR)
      ELSEIF (PTRAIT) THEN
C
C Portrait
C
         CALL PORTRT (IP, NIP, NPMAX, 
     +                P,
     +                USER)
      ENDIF
C
C Repeat if Cancel has not been selected
C
      IF (AGAIN) GOTO 20
C
C Format statements
C        
  100 FORMAT (
     + 'DEQSOL graph plotting options'
     +/
     +/'Up to twelve currently selected components can be'
     +/'plotted and, for plane autonomous systems, options'
     +/'to plot archived trajectories, or display a phase'
     +/'portrait as vector field are also provided.'     
     +/
     +/'Plot selected components y(i)'
     +/'Plot a selected orbit'
     +/'Store a selected orbit'
     +/'Plot archived orbits'
     +/'Plot a phase portrait'
     +/'Help'
     +/'Cancel')
  201 FORMAT ('Component y(i): i =',I4)
  202 FORMAT ('y(i):',I4,'(solid)',I4,'(dashed line)')
  203 FORMAT ('y(i):',I4,'(solid)',I4,'(dash)',I4,'(dot)')
  204 FORMAT ('y(i):',I4,'(solid)',I4,'(dash)',I4,'(dot)',I4,'(d/d)')
  300 FORMAT ('y(',I1,')  ')
  400 FORMAT ('y(',I2,') ')
  500 FORMAT ('y(',I3,') ')
  600 FORMAT ('y(',I4,')')
  700 FORMAT (
     + 'Plotting options for selected integrated components y(i)'
     +/
     +/'From this control you can choose from up to 12 of the selected'
     +/'components (or their transforms) and plot current values for'
     +/'these as functions of x (i.e. time) after integration.'
     +/
     +/'Plotting or storing individual phase plane orbits'
     +/'If you have a system of 2 autonomous equations you can plot the'
     +/'orbit of y(1) against y(2) parameterised by time. Then, if you'
     +/'wish, you can store up to 12 such orbits for plotting. If there'
     +/'are more than 2 equations or the equations are not autonomous'
     +/'this option (and the next one) must be used with care.'
     +/
     +/'Plotting the collected stored orbits'
     +/'A selection from up to 12 archived orbits can be plotted. This'
     +/'option is used to plot collected phase planes simultaneously.'
     +/
     +/'Phase portraits for autonomous systems'
     +/'You choose the range of y(i) and number of grid divisions and'
     +/'an arrow is plotted at each grid point (tan(theta) = F(1)/F(2))'
     +/'to generate a vector field. The equations are not integrated.')
      END
C
C
